// -------------------------------------------------------------------- 
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<< 
// -------------------------------------------------------------------- 
// Copyright (c) 2001 by Lattice Semiconductor Corporation 
// -------------------------------------------------------------------- 
// 
// 
//                     Lattice Semiconductor Corporation 
//                     5555 NE Moore Court 
//                     Hillsboro, OR 97214 
//                     U.S.A 
// 
//                     TEL: 1-800-Lattice (USA and Canada) 
//                          408-826-6000 (other locations) 
// 
//                     web: http://www.latticesemi.com/ 
//                     email: techsupport@latticesemi.com 
// 
// -------------------------------------------------------------------- 
// 
// Simulation Library File for ispMACH5000MX

//$Header: R:/src/mod_kits/Mach/verilog/rcs/lc5kmx.v 1.66 2004/03/04 19:12:24Z jli Exp jli $ 

`timescale 100ps / 10ps // TIMESCALE FOR THE LIBRARY
//`define PUC
// 1.2 Added default timing to work around the zero time loop
// 1.3 Default propagation delay time is changed to zero
// 1.4 Change default pulse width and period to 1ns

`celldefine

module MUX2 (O,I0,I1,S0); 
input I0,I1,S0; 
output O; 
supply0 GND; 
supply1 VCC; 
 
not INS1 (S_inv, S0); 
and INS2 (out_1, I0, S_inv); 
and INS3 (out_2, I1, S0); 
or  INS4 (O, out_1, out_2); 
 
specify 
 
(S0 => O) =  0:0:0, 0:0:0; 
(I0 => O) =  0:0:0, 0:0:0;  
(I1 => O) =  0:0:0, 0:0:0;  
 
endspecify 
 
 
endmodule 

`endcelldefine

`celldefine

module MUX4 (O,I0,I1,I2,I3,S0,S1); 
input I0,I1,I2,I3,S0,S1; 
output O; 
supply0 GND; 
supply1 VCC; 
 
 
not INS1 (S0_inv, S0); 
not INS9 (S1_inv, S1); 
and INS3 (out_1, I0, S0_inv, S1_inv); 
and INS4 (out_2, I1, S0, S1_inv); 
and INS5 (out_3, I2, S0_inv, S1); 
and INS6 (out_4, I3, S0, S1); 
or  INS7 (O, out_1, out_2, out_3, out_4); 
 
specify 
 
(S0 => O) =  0:0:0, 0:0:0;  
(S1 => O) =  0:0:0, 0:0:0; 
(I0 => O) =  0:0:0, 0:0:0;  
(I1 => O) =  0:0:0, 0:0:0;  
(I2 => O) =  0:0:0, 0:0:0;  
(I3 => O) =  0:0:0, 0:0:0;  
 
endspecify 
 
 
endmodule 

`endcelldefine

`timescale 10 ps / 10 ps
`celldefine 
`timescale 10 ps / 10 ps
 
module SPLL (CLK_OUT,CLK_IN); 
parameter in_freq = "100.00";
parameter clk_out_to_pin = "off";
parameter wake_on_lock = "off";
input CLK_IN; 
output CLK_OUT; 
supply0 GND; 
supply1 VCC; 
buf INS1 (CLK_OUT, CLK_IN); 
 
specify 
 
(CLK_IN => CLK_OUT) =  0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 


`timescale  10 ps / 10 ps
`celldefine 

`timescale  10 ps / 10 ps


module STDPLL (CLK_IN, CLK_OUT, PLL_LOCK);

parameter   in_freq  = "100.00";
parameter   clk_out_to_pin = "off";
parameter   wake_on_lock = "off";
parameter   div      = "1";
parameter   post     = "1";
parameter   mult     = "1";
parameter   pll_dly  = "0.00";
parameter   secdiv   = "2";
parameter   lock_cyc   = 2;
real clockboost;

input  CLK_IN;
output CLK_OUT, PLL_LOCK;
wire    CLK_OUT, PLL_LOCK;
wire    CLK_OUT_node, PLL_LOCK_node;

wire   clkin_in;

time   new_delay;
time   clklock_last_rising_edge;
time   clklock_last_falling_edge;
time   clklock_half_period1;
time   clklock_half_period0;
time   clklock_half_period;
time   clklock_half_period_minus_dly1;
time   clklock_half_period_minus_dly0;

reg [15:0] mult_r;
integer mult_i;
initial mult_r = mult;
initial mult_i = 10 * convert_int(mult_r[15:8]) + convert_int(mult_r[7:0]);

reg [15:0] div_r;
integer div_i;
initial div_r = div;
initial div_i = 10 * convert_int(div_r[15:8]) + convert_int(div_r[7:0]);

reg [15:0] post_r;
integer post_i;
initial post_r = post;
initial post_i = 10 * convert_int(post_r[15:8]) + convert_int(post_r[7:0]);

reg [39:0] pll_dly_r;
real pll_delay, pll_dly_re, pll_dly_step;
real pll_dly_re_temp, pll_dly_re_temp_abs, pll_dly_step_temp;
initial pll_dly_r = pll_dly;

initial 
  begin
    if(pll_dly_r[23:16] == 8'b00101110)
      begin
      pll_dly_re_temp = convert_real(pll_dly_r[39:32]) * (convert_real(pll_dly_r[31:24]) + 0.1 * convert_real(pll_dly_r[15:8]) + 0.01 * convert_real(pll_dly_r[7:0]));
      pll_dly_re_temp_abs = convert_real(pll_dly_r[31:24]) + 0.1 * convert_real(pll_dly_r[15:8]) + 0.01 * convert_real(pll_dly_r[7:0]);
      end
    else if (pll_dly_r[15:8] == 8'b00101110)
      begin
      pll_dly_re_temp = convert_real(pll_dly_r[31:24]) * (convert_real(pll_dly_r[23:16]) + 0.1 * convert_real(pll_dly_r[7:0])); 
      pll_dly_re_temp_abs = convert_real(pll_dly_r[23:16]) + 0.1 * convert_real(pll_dly_r[7:0]); 
      end
  end

initial  pll_dly_step_temp = convert_int(pll_dly_r[15:8]) * convert_int(pll_dly_r[7:0]) *0.25;

initial
      if(pll_dly_re_temp >= 0)
       pll_dly_re = pll_dly_re_temp_abs;
      else
       pll_dly_re = pll_dly_re_temp;

initial
      if(pll_dly_step_temp >= 0)
       pll_dly_step = 0.25 * convert_real(pll_dly_r[7:0]);
      else
       pll_dly_step = pll_dly_step_temp; 

reg real_or_step;
initial real_or_step = 1'b0;  // real

initial
  begin
      if (pll_dly_r[39:16] == 24'h000000)
        begin
            begin
              real_or_step = 1'b1;
              pll_delay = pll_dly_step;
            end
        end
      else  
         begin
              real_or_step = 1'b0;
              pll_delay = pll_dly_re;
         end
  end                                                    


initial begin
  clklock_half_period1 = 0;
  clklock_half_period0 = 0;
  clklock_half_period = 0;
  clklock_half_period_minus_dly1 = 0;
  clklock_half_period_minus_dly0 = 0;
  clockboost     = mult_i/div_i;
  new_delay      = (real_or_step == 1'b0) ? (pll_dly_re_temp_abs * 100.0) : (0.25 * convert_int(pll_dly_r[7:0]) * 100.0);
end


integer   cnt_m_div;
reg       clk_out_m_div;


buf buf_clkin (clkin_in, CLK_IN);

integer clklock_rising_edge_count;
integer clklock_falling_edge_count;

initial
begin
	cnt_m_div = -1;
	clk_out_m_div = 0;
        clklock_rising_edge_count = 0;
        clklock_falling_edge_count = 0;
end

always @(posedge clkin_in) 
begin
    clklock_rising_edge_count = clklock_rising_edge_count + 1;
    clklock_last_rising_edge = $time;
end

always @(negedge clkin_in)
begin
    clklock_falling_edge_count = clklock_falling_edge_count + 1;
    clklock_last_falling_edge = $time;
end

always @(posedge clkin_in)
begin
    if (clklock_falling_edge_count == 2)
       clklock_half_period0 = ($time - clklock_last_falling_edge)*div_i/mult_i;
       clklock_half_period_minus_dly0 = ($time - clklock_last_falling_edge) + 100.0 * pll_delay;
end

always @(negedge clkin_in) 
begin
    if (clklock_rising_edge_count == 1)
       clklock_half_period1 = ($time - clklock_last_rising_edge)*div_i/mult_i;
       clklock_half_period_minus_dly1 = ($time - clklock_last_rising_edge) + 100.0 * pll_delay; 
end

always @(negedge clkin_in) 
begin
clklock_half_period = (clklock_half_period0 + clklock_half_period1)/2.0; 
end

integer   i, n, clock_count, clock_count_falling;
reg       clock_out_sig;

initial
begin
	clock_out_sig = 1'b0;
	clock_count = -1;
	clock_count_falling = -1;
end
always @(clklock_rising_edge_count)
begin
    if (clklock_rising_edge_count > lock_cyc + 1)
    begin
      if (clockboost > 1)
       begin
	for (i = 1; i <= 2* clockboost ; i = i +1)
           begin
                clock_count = clock_count + 1;
                #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count = clock_count + 1;
              #clklock_half_period   n = 0;
           end
    end
    else
      clock_count = 0;
end

always @(clklock_falling_edge_count)
begin
    if (clklock_falling_edge_count > lock_cyc + 1)
    begin
      if (clockboost > 1)
       begin
	for (i = 1; i <= 2* clockboost ; i = i +1)
           begin
                clock_count_falling = clock_count_falling + 1;
              #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count_falling = clock_count_falling + 1;
              #clklock_half_period   n = 0;
           end
    end
    else
      clock_count_falling = 0;
end

reg PLL_LOCK_plus,PLL_LOCK_minus;
reg CLK_OUT_sig_d_start;

initial
begin
	PLL_LOCK_plus  = 1'b0;
	PLL_LOCK_minus = 1'b0;
	CLK_OUT_sig_d_start = 1'b0;
end

always @(clock_count)
begin
  if (clock_count == 1)
  begin
    CLK_OUT_sig_d_start = 1'b1;
  end
end

always @(clock_count)
begin
  if (clock_count == 1)
  begin
    PLL_LOCK_plus = 1'b1;
  end
end

always @(clock_count)
begin
  if (clock_count == 3)
    PLL_LOCK_minus = 1'b1;
end

reg CLK_OUT_sig_d_not;
initial
begin
    CLK_OUT_sig_d_not = 1'b0;
end

always @(clock_count)
begin
      while (clock_count>0) 
      begin
         #clklock_half_period1 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
         #clklock_half_period0 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
      end
end

wire CLK_OUT_sig_d = ~CLK_OUT_sig_d_not && CLK_OUT_sig_d_start;


reg CLK_OUT_sig_3d;
wire CLK_OUT_plus_delay;

reg start_CLK_OUT;

initial 
begin
CLK_OUT_sig_3d = 1'b0; start_CLK_OUT = 1'b0;
end

always @(clock_count_falling)
begin
  if (clock_count_falling == 1)
  begin
    #clklock_half_period_minus_dly0 CLK_OUT_sig_3d = 1'b1; start_CLK_OUT = 1'b1;
  end
end

always @(start_CLK_OUT)
begin
 while (start_CLK_OUT) 
      begin
         #clklock_half_period1 
         CLK_OUT_sig_3d = ~ CLK_OUT_sig_3d;
         #clklock_half_period0 
         CLK_OUT_sig_3d = ~ CLK_OUT_sig_3d;
      end
end


assign #new_delay CLK_OUT_plus_delay = CLK_OUT_sig_d;


assign PLL_LOCK_node = PLL_LOCK_plus && (pll_delay>=0) || PLL_LOCK_minus && (pll_delay<0) ;
assign CLK_OUT_node = (CLK_OUT_plus_delay && (pll_delay >=0) || CLK_OUT_sig_3d && (pll_delay<0));
buf INSXQ1 (PLL_LOCK,PLL_LOCK_node);
buf INSXQ2 (CLK_OUT,CLK_OUT_node);
function integer convert_int;
input [7:0] int_str;
  begin

    if (int_str == "9")
      convert_int = 9;
    else if (int_str == "8")
      convert_int = 8;
    else if (int_str == "7")
      convert_int = 7;
    else if (int_str == "6")
      convert_int = 6;
    else if (int_str == "5")
      convert_int = 5;
    else if (int_str == "4")
      convert_int = 4;
    else if (int_str == "3")
      convert_int = 3;
    else if (int_str == "2")
      convert_int = 2;
    else if (int_str == "1")
      convert_int = 1;
    else if (int_str == "0")
      convert_int = 0;
    else if (int_str == "-")
      convert_int = -1;
    else
      convert_int = 0;

  end
endfunction


// --------- for real number convertion function ------------
function real convert_real;
input [7:0] real_str;
  begin

    if (real_str == "9")
      convert_real = 9.0;
    else if (real_str == "8")
      convert_real = 8.0;
    else if (real_str == "7")
      convert_real = 7.0;
    else if (real_str == "6")
      convert_real = 6.0;
    else if (real_str == "5")
      convert_real = 5.0;
    else if (real_str == "4")
      convert_real = 4.0;
    else if (real_str == "3")
      convert_real = 3.0;
    else if (real_str == "2")
      convert_real = 2.0;
    else if (real_str == "1")
      convert_real = 1.0;
    else if (real_str == "0")
      convert_real = 0.0;
    else if (real_str == "-")
      convert_real = -1.0;
    else
      convert_real = 1.0; 

  end
endfunction
specify
      (CLK_IN => CLK_OUT)  =  0:0:0, 0:0:0;
      (CLK_IN => PLL_LOCK) =  0:0:0, 0:0:0;
endspecify
endmodule


`endcelldefine 



`timescale  10 ps / 10 ps
`celldefine 
`timescale 10 ps / 10 ps

module STDPLLX (CLK_IN, PLL_FBK, PLL_RST,CLK_OUT, PLL_LOCK, SEC_OUT);

parameter   in_freq    = "100.0";
parameter   clk_out_to_pin = "off";
parameter   wake_on_lock = "off";
parameter   div        = "1";
parameter   post       = "1";
parameter   mult       = "1";
parameter   pll_dly    = "0.00";
parameter   secdiv     = "2";
parameter   lock_cyc   = 2;
integer     clockboost;

input  CLK_IN, PLL_FBK, PLL_RST;
output CLK_OUT, PLL_LOCK, SEC_OUT;
wire   CLK_OUT, PLL_LOCK;
wire   CLK_OUT_node, PLL_LOCK_node,SEC_OUT_node;

wire   clkin_in;

time   new_delay;
time   secd_delay1;
time   secd_delay0;
time   secd_delay;
time   secd_delay_minus1;
time   secd_delay_minus0;

time   clklock_last_rising_edge;
time   clklock_last_falling_edge;
time   clklock_half_period1;
time   clklock_half_period0;
time   clklock_half_period;
time   clklock_half_period_minus_dly1;
time   clklock_half_period_minus_dly0;

reg [15:0] mult_r;
integer mult_i;
initial mult_r = mult;
initial mult_i = 10 * convert_int(mult_r[15:8]) + convert_int(mult_r[7:0]);

reg [15:0] div_r;
integer div_i;
initial div_r = div;
initial div_i = 10 * convert_int(div_r[15:8]) + convert_int(div_r[7:0]);

reg [15:0] secdiv_r;
integer secdiv_i;
initial secdiv_r = secdiv;
initial secdiv_i = 10 * convert_int(secdiv_r[15:8]) + convert_int(secdiv_r[7:0]);

reg [15:0] post_r;
integer post_i;
initial post_r = post;
initial post_i = 10 * convert_int(post_r[15:8]) + convert_int(post_r[7:0]);

reg [39:0] pll_dly_r;
real pll_delay, pll_dly_re, pll_dly_step;
real pll_dly_re_temp, pll_dly_re_temp_abs, pll_dly_step_temp;
initial pll_dly_r = pll_dly;

initial 
  begin
    if(pll_dly_r[23:16] == 8'b00101110)
      begin
      pll_dly_re_temp = convert_real(pll_dly_r[39:32]) * (convert_real(pll_dly_r[31:24]) + 0.1 * convert_real(pll_dly_r[15:8]) + 0.01 * convert_real(pll_dly_r[7:0]));
      pll_dly_re_temp_abs = convert_real(pll_dly_r[31:24]) + 0.1 * convert_real(pll_dly_r[15:8]) + 0.01 * convert_real(pll_dly_r[7:0]);
      end
    else if (pll_dly_r[15:8] == 8'b00101110)
      begin
      pll_dly_re_temp = convert_real(pll_dly_r[31:24]) * (convert_real(pll_dly_r[23:16]) + 0.1 * convert_real(pll_dly_r[7:0])); 
      pll_dly_re_temp_abs = convert_real(pll_dly_r[23:16]) + 0.1 * convert_real(pll_dly_r[7:0]); 
      end
  end

initial  pll_dly_step_temp = convert_int(pll_dly_r[15:8]) * convert_int(pll_dly_r[7:0]) *0.25;

initial
      if(pll_dly_re_temp >= 0)
       pll_dly_re = pll_dly_re_temp_abs;
      else
       pll_dly_re = pll_dly_re_temp;

initial
      if(pll_dly_step_temp >= 0)
       pll_dly_step = 0.25 * convert_real(pll_dly_r[7:0]);
      else
       pll_dly_step = pll_dly_step_temp; 

reg real_or_step;
initial real_or_step = 1'b0;  // real

initial
  begin
      if (pll_dly_r[39:16] == 24'h000000)
        begin
            begin
              real_or_step = 1'b1;
              pll_delay = pll_dly_step;
            end
        end
      else  
         begin
              real_or_step = 1'b0;
              pll_delay = pll_dly_re;
         end
  end                                           

initial begin
  clklock_half_period1 = 0;
  clklock_half_period0 = 0;
  clklock_half_period = 0;
  clklock_half_period_minus_dly1 = 0;
  clklock_half_period_minus_dly0 = 0;
  clockboost     = mult_i/div_i;
  new_delay      = (real_or_step == 1'b0) ? (pll_dly_re_temp_abs * 100.0) : (0.25 * convert_int(pll_dly_r[7:0]) * 100.0);
end


integer   cnt_m_div;
wire      clkin_m_div;
reg       clk_out_m_div;


buf buf_clkin (clkin_in, CLK_IN);

integer clklock_rising_edge_count;
integer clklock_falling_edge_count;

initial
begin
	cnt_m_div = -1;
	clk_out_m_div = 0;
        clklock_rising_edge_count = 0;
        clklock_falling_edge_count = 0;
end

always @(posedge clkin_in) 
begin
    casez(PLL_FBK)
        1'bX : $display("Error : PLL feedback unknown.");
    endcase
end

always @(posedge clkin_in) 
begin
    clklock_rising_edge_count = clklock_rising_edge_count + 1;
    clklock_last_rising_edge = $time;
end

always @(negedge clkin_in)
begin
    clklock_falling_edge_count = clklock_falling_edge_count + 1;
    clklock_last_falling_edge = $time;
end

always @(posedge clkin_in)
begin
    if (clklock_falling_edge_count == 2)
       clklock_half_period0 = ($time - clklock_last_falling_edge)*div_i/mult_i;
       clklock_half_period_minus_dly0 = ($time - clklock_last_falling_edge) + 100.0 * pll_delay; 
       secd_delay0 = clklock_half_period0 * secdiv_i;
       secd_delay_minus0 = clklock_half_period0 * secdiv_i + 100.0 * pll_delay; 
end

always @(negedge clkin_in) 
begin
    if (clklock_rising_edge_count == 1)
       clklock_half_period1 = ($time - clklock_last_rising_edge)*div_i/mult_i;
       clklock_half_period_minus_dly1 = ($time - clklock_last_rising_edge) + 100.0 * pll_delay; 
       secd_delay1 = clklock_half_period1 * secdiv_i;
       secd_delay_minus1 = clklock_half_period1 * secdiv_i + 100.0 * pll_delay; 
end

integer   i, n, clock_count, clock_count_falling;
reg       clock_out_sig;

initial
begin
	clock_out_sig = 1'b0;
	clock_count = -1;
	clock_count_falling = -1;
end
always @(clklock_rising_edge_count)
begin
    if (clklock_rising_edge_count > lock_cyc + 1 && !PLL_RST)
    begin
      if (clockboost > 1)
       begin
	for (i = 1; i <= 2* clockboost ; i = i +1)
           begin
                clock_count = clock_count + 1;
                #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count = clock_count + 1;
              #clklock_half_period   n = 0;
           end
    end
    else
      clock_count = 0;
end

always @(clklock_falling_edge_count)
begin
    if (clklock_falling_edge_count > lock_cyc + 1 && !PLL_RST)
    begin
      if (clockboost > 1)
       begin
	for (i = 1; i <= 2* clockboost ; i = i +1)
           begin
              clock_count_falling = clock_count_falling + 1;
              #clklock_half_period   n = 0;
           end
       end
      else
           begin
              clock_count_falling = clock_count_falling + 1;
              #clklock_half_period   n = 0;
           end
    end
    else
      clock_count_falling = 0;
end

reg PLL_LOCK_plus,PLL_LOCK_minus;
reg CLK_OUT_sig_d_start;
reg SEC_OUT_sig_d_start;

initial
begin
	PLL_LOCK_plus  = 1'b0;
	PLL_LOCK_minus = 1'b0;
	CLK_OUT_sig_d_start = 1'b0;
	SEC_OUT_sig_d_start = 1'b0;
end

always @(clock_count)
begin
  if (clock_count == 1)
  begin
    PLL_LOCK_plus = 1'b1;
    CLK_OUT_sig_d_start = 1'b1;
    SEC_OUT_sig_d_start = 1'b1;
  end
end

always @(clock_count)
begin
  if (clock_count == 3)
    PLL_LOCK_minus = 1'b1;
end

reg CLK_OUT_sig_d_not;
initial
begin
    CLK_OUT_sig_d_not = 1'b0;
end

always @(clock_count)
begin
      while (clock_count>0) 
      begin
         #clklock_half_period1 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
         #clklock_half_period0 
         CLK_OUT_sig_d_not = ~ CLK_OUT_sig_d_not;
      end
end

wire CLK_OUT_sig_d = ~CLK_OUT_sig_d_not && CLK_OUT_sig_d_start;

reg CLK_OUT_sig_3d;
wire CLK_OUT_plus_delay;

reg SEC_OUT_sig_3d;

reg start_CLK_OUT;

initial 
begin
CLK_OUT_sig_3d = 1'b0; start_CLK_OUT = 1'b0;
end

always @(clock_count_falling)
begin
  if (clock_count_falling == 1)
  begin
    #clklock_half_period_minus_dly0 CLK_OUT_sig_3d = 1'b1; start_CLK_OUT = 1'b1;
  end
end

always @(start_CLK_OUT)
begin
 while (start_CLK_OUT) 
      begin
         #clklock_half_period1 
         CLK_OUT_sig_3d = ~ CLK_OUT_sig_3d;
         #clklock_half_period0 
         CLK_OUT_sig_3d = ~ CLK_OUT_sig_3d;
      end
end

reg start_SEC_OUT;

initial 
begin
SEC_OUT_sig_3d = 1'b0; start_SEC_OUT = 1'b0;
end

always @(clock_count_falling)
begin
  if (clock_count_falling == 1)
  begin
    #clklock_half_period_minus_dly0 SEC_OUT_sig_3d = 1'b1; start_SEC_OUT = 1'b1;
  end
end

always @(start_SEC_OUT)
begin
      while (start_SEC_OUT) 
      begin
         #secd_delay1 
         SEC_OUT_sig_3d = ~ SEC_OUT_sig_3d;
         #secd_delay0 
         SEC_OUT_sig_3d = ~ SEC_OUT_sig_3d;
      end
end


assign #new_delay CLK_OUT_plus_delay = CLK_OUT_sig_d;

assign PLL_LOCK_node = !PLL_RST && (PLL_LOCK_plus && (pll_delay>=0) || PLL_LOCK_minus && (pll_delay<0));
assign CLK_OUT_node = !PLL_RST && (CLK_OUT_plus_delay && (pll_delay >=0) || CLK_OUT_sig_3d && (pll_delay<0));
buf INSXQ1 (PLL_LOCK,PLL_LOCK_node);
buf INSXQ2 (CLK_OUT,CLK_OUT_node);

reg SEC_OUT_sig_d_not;
initial
begin
    SEC_OUT_sig_d_not = 1'b0;
end

always @(clock_count)
begin
      while (clock_count>0) 
      begin
         #secd_delay1 
         SEC_OUT_sig_d_not = ~ SEC_OUT_sig_d_not;
         #secd_delay0 
         SEC_OUT_sig_d_not = ~ SEC_OUT_sig_d_not;
      end
end

wire SEC_OUT_sig_d = ~SEC_OUT_sig_d_not && SEC_OUT_sig_d_start;

wire SEC_OUT_plus_delay;

assign #new_delay SEC_OUT_plus_delay = SEC_OUT_sig_d;

assign SEC_OUT_node = !PLL_RST &&  (SEC_OUT_plus_delay && (pll_delay >=0) || SEC_OUT_sig_3d && (pll_delay<0));
buf INSXQ3 (SEC_OUT,SEC_OUT_node);
function integer convert_int;
input [7:0] int_str;
  begin

    if (int_str == "9")
      convert_int = 9;
    else if (int_str == "8")
      convert_int = 8;
    else if (int_str == "7")
      convert_int = 7;
    else if (int_str == "6")
      convert_int = 6;
    else if (int_str == "5")
      convert_int = 5;
    else if (int_str == "4")
      convert_int = 4;
    else if (int_str == "3")
      convert_int = 3;
    else if (int_str == "2")
      convert_int = 2;
    else if (int_str == "1")
      convert_int = 1;
    else if (int_str == "0")
      convert_int = 0;
    else if (int_str == "-")
      convert_int = -1;
    else
      convert_int = 0;

  end
endfunction


// --------- for real number convertion function ------------
function real convert_real;
input [7:0] real_str;
  begin

    if (real_str == "9")
      convert_real = 9.0;
    else if (real_str == "8")
      convert_real = 8.0;
    else if (real_str == "7")
      convert_real = 7.0;
    else if (real_str == "6")
      convert_real = 6.0;
    else if (real_str == "5")
      convert_real = 5.0;
    else if (real_str == "4")
      convert_real = 4.0;
    else if (real_str == "3")
      convert_real = 3.0;
    else if (real_str == "2")
      convert_real = 2.0;
    else if (real_str == "1")
      convert_real = 1.0;
    else if (real_str == "0")
      convert_real = 0.0;
    else if (real_str == "-")
      convert_real = -1.0;
    else
      convert_real = 1.0; 

  end
endfunction

specify 
 
(PLL_RST => PLL_LOCK) =  0:0:0, 0:0:0;
(CLK_IN => CLK_OUT)   =   0:0:0, 0:0:0;
(CLK_IN => PLL_LOCK)  =   0:0:0, 0:0:0;
(CLK_IN => SEC_OUT)   =   0:0:0, 0:0:0;
 
endspecify 

endmodule

`endcelldefine 


`celldefine 
 
module AND2 (O,I0,I1); 
input I0,I1; 
output O; 
supply0 GND; 
supply1 VCC; 
and INS1 (O, I0, I1); 
 
specify 
 
(I0 => O) =  0:0:0, 0:0:0; 
(I1 => O) =  0:0:0, 0:0:0; 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module AND3 (O,I0,I1,I2); 
input I0,I1,I2; 
output O; 
supply0 GND; 
supply1 VCC; 
and INS1 (O, I0, I1, I2); 
 
specify 
 
(I0 => O) =  0:0:0, 0:0:0;
(I1 => O) =  0:0:0, 0:0:0;
(I2 => O) =  0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
 
`celldefine 
 
module AND4 (O,I0,I1,I2,I3); 
input I0,I1,I2,I3; 
output O; 
supply0 GND; 
supply1 VCC; 
and INS1 (O, I0, I1, I2, I3); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(I1 => O) = 0:0:0, 0:0:0;
(I2 => O) = 0:0:0, 0:0:0;
(I3 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
 
`celldefine 
 
module AND5 (O,I0,I1,I2,I3,I4); 
input I0,I1,I2,I3,I4; 
output O; 
supply0 GND; 
supply1 VCC; 
and INS1 (O, I0, I1, I2, I3, I4); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(I1 => O) = 0:0:0, 0:0:0;
(I2 => O) = 0:0:0, 0:0:0;
(I3 => O) = 0:0:0, 0:0:0;
(I4 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
 
`celldefine 
 
module AND6 (O,I0,I1,I2,I3,I4,I5); 
input I0,I1,I2,I3,I4,I5; 
output O; 
supply0 GND; 
supply1 VCC; 
and INS1 (O, I0, I1, I2, I3, I4, I5); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(I1 => O) = 0:0:0, 0:0:0;
(I2 => O) = 0:0:0, 0:0:0;
(I3 => O) = 0:0:0, 0:0:0;
(I4 => O) = 0:0:0, 0:0:0;
(I5 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
 
`celldefine 
 
module AND7 (O,I0,I1,I2,I3,I4,I5,I6); 
input I0,I1,I2,I3,I4,I5,I6; 
output O; 
supply0 GND; 
supply1 VCC; 
and INS1 (O, I0, I1, I2, I3, I4, I5, I6); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(I1 => O) = 0:0:0, 0:0:0;
(I2 => O) = 0:0:0, 0:0:0;
(I3 => O) = 0:0:0, 0:0:0;
(I4 => O) = 0:0:0, 0:0:0;
(I5 => O) = 0:0:0, 0:0:0;
(I6 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
 
`celldefine 
 
module AND8 (O,I0,I1,I2,I3,I4,I5,I6,I7); 
input I0,I1,I2,I3,I4,I5,I6,I7; 
output O; 
supply0 GND; 
supply1 VCC; 
and INS1 (O, I0, I1, I2, I3, I4, I5, I6, I7); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(I1 => O) = 0:0:0, 0:0:0;
(I2 => O) = 0:0:0, 0:0:0;
(I3 => O) = 0:0:0, 0:0:0;
(I4 => O) = 0:0:0, 0:0:0;
(I5 => O) = 0:0:0, 0:0:0;
(I6 => O) = 0:0:0, 0:0:0;
(I7 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
`celldefine 
 
module BI_DIR (O,I0,IO,OE); 
input I0,OE; 
inout IO; 
output O; 
 
supply0 GND; 
supply1 VCC; 

reg IO0, O0;
wire IO1;

parameter PULL = "Off";
parameter OUTOPEN = "Off";

buf INSXQ1 (O,O0);

bufif1 INSXQ2 (IO,IO0,OE);
buf INSXQ3 (IO1,IO);
always @(IO1)
begin
 if (PULL == "Off")
        case(IO1)
           1'b0: O0 = 1'b0;
           1'b1: O0 = 1'b1;
           1'bz: O0 = 1'bx;
           1'bx: O0 = 1'bx;
        endcase
 else if (PULL == "Up")
        case(IO1)
           1'b0: O0 = 1'b0;
           1'b1: O0 = 1'b1;
           1'bz: O0 = 1'b1;
        endcase
 else if (PULL == "Down")
        case(IO1)
           1'b0: O0 = 1'b0;
           1'b1: O0 = 1'b1;
           1'bz: O0 = 1'b0;
        endcase
 else if (PULL == "Hold")
        case(IO1)
           1'b0: O0 = 1'b0;
           1'b1: O0 = 1'b1;
           1'bz: O0 = O0;
        endcase
end


always @(OE or I0)
  begin
     if (OE == 1'b0)
         IO0 = 1'bz;
     else if (OE == 1'b1)
            if (OUTOPEN == "Off")
               case(I0)
                 1'b0: IO0 = 1'b0;
                 1'b1: IO0 = 1'b1;
                 1'bz: IO0 = 1'bx;
                 1'bx: IO0 = 1'bx;
               endcase
            else if (OUTOPEN == "Drain" || OUTOPEN == "Collect")
               begin
                 if (I0 == 1'b0)
                    IO0 = 1'b0;
                 else if (I0 == 1'b1)
                    IO0 = 1'bz;
                 else
                    IO0 = 1'bx;
          end
  end       

 
specify 
 
(I0 => IO) = 0:0:0, 0:0:0;
(OE => IO) = 0:0:0, 0:0:0;
(IO => O) =  0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
`celldefine 
 
module BUFF (O,I0); 
input I0; 
output O; 
supply0 GND; 
supply1 VCC; 
buf INS1 (O, I0); 
 
specify 
 
(I0 => O) =  0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
`celldefine 
 
module BUFTH (O,I0,OE); 
input I0,OE; 
output O; 
supply0 GND; 
supply1 VCC; 
wire I0_i,OE_i;
reg o0;

parameter OUTOPEN = "Off";

buf INSXQ1 (I0_i,I0);  
buf INSXQ2 (OE_i,OE);  
bufif1 INSXQ3 (O,o0,OE_i);  

always @(OE_i or I0_i)
  begin
     if (OE_i == 1'b0)
         o0 = 1'bz;
     else if (OE_i == 1'b1)
            if (OUTOPEN == "Off")
               case(I0_i)
                 1'b0: o0 = 1'b0;
                 1'b1: o0 = 1'b1;
                 1'bz: o0 = 1'bx;
                 1'bx: o0 = 1'bx;
               endcase
            else if (OUTOPEN == "Drain" || OUTOPEN == "Collect")
               begin
                 if (I0_i == 1'b0)
                    o0 = 1'b0;
                 else if (I0_i == 1'b1)
                    o0 = 1'bz;
                 else
                    o0 = 1'bx;
          end
  end       
 
specify 
 
(I0 => O) =  0:0:0, 0:0:0;
(OE => O) =  0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module BUFTI (O,I0,OE); 
input I0,OE; 
output O; 
supply0 GND; 
supply1 VCC; 
bufif1 INS1 (O, I0, OE); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(OE => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
`celldefine 
 
module BUFTL (O,I0,OE); 
input I0,OE; 
output O; 
supply0 GND; 
supply1 VCC;
wire I0_i,OE_i;
reg o0;

parameter OUTOPEN = "Off";

buf INSXQ1 (I0_i,I0);  
buf INSXQ2 (OE_i,OE);  
bufif0 INSXQ3 (O,o0,OE_i);  

always @(OE_i or I0_i)
  begin
     if (OE_i == 1'b1)
         o0 = 1'bz;
     else if (OE_i == 1'b0)
            if (OUTOPEN == "Off")
               case(I0_i)
                 1'b0: o0 = 1'b0;
                 1'b1: o0 = 1'b1;
                 1'bz: o0 = 1'bx;
                 1'bx: o0 = 1'bx;
               endcase
            else if (OUTOPEN == "Drain" || OUTOPEN == "Collect")
               begin
                 if (I0_i == 1'b0)
                    o0 = 1'b0;
                 else if (I0_i == 1'b1)
                    o0 = 1'bz;
                 else
                    o0 = 1'bx;
          end
  end     
 
specify 
 
(I0 => O) =  0:0:0, 0:0:0;
(OE => O) =  0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
`celldefine 
  
module CLKI(O,PAD); 
input PAD; 
output O; 
supply0 GND; 
supply1 VCC; 
buf INS1 (O, PAD); 
  
specify 
  
(PAD => O) =  0:0:0, 0:0:0;
  
endspecify 
  
  
endmodule 
`endcelldefine 
 
`celldefine 
 
module DFF (Q,D,CLK); 
input D,CLK; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
 
`ifdef xmodel 
MACH_DFF_X INS1 (Q_int, D, CLK, VCC, VCC, notifier); 
`else 
MACH_DFF INS4 (Q_int, D, CLK, VCC, VCC, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
buf INS2 (Q, Q_reg); 
 
specify 
 
(CLK => Q) = ( 0:0:0, 0:0:0); 
$setuphold(posedge CLK, D , 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge CLK, 1:1:1, 0, notifier); 
$period(posedge CLK, 1:1:1, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module DFFC (Q,D,CLK,CE); 
input D,CLK,CE; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
MACH_DFF_CE_X INS1 (Q_int, D, CLK, VCC, VCC, CE, notifier); 
`else 
MACH_DFF_CE INS4 (Q_int, D, CLK, VCC, VCC, CE, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
 
specify 
 
(CLK => Q) = ( 0:0:0, 0:0:0);  
$setuphold(posedge CLK &&& (CE == 1), D , 0.1:0.1:0.1, 0:0:0, notifier); 
$setuphold(posedge CLK , posedge CE , 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge CLK &&& (CE == 1), 1:1:1, 0, notifier); 
$period(posedge CLK &&& (CE == 1), 1:1:1, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module DFFCR (Q,D,CLK,CE,R); 
input D,CLK,CE,R; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
MACH_DFF_CE_X INS1 (Q_int, D, CLK, R, VCC, CE, notifier); 
`else 
MACH_DFF_CE INS5 (Q_int, D, CLK, R, VCC, CE, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
and INS4 (CE_R, CE, R); 
 
specify 
 
(CLK => Q) = ( 0:0:0, 0:0:0); 
(R => Q) = ( 0:0:0, 0:0:0); 
$width(negedge R, 1:1:1, 0, notifier); 
$setuphold(posedge CLK &&& (CE_R), D , 0.1:0.1:0.1, 0:0:0, notifier); 
$setuphold(posedge CLK &&& (R == 1), posedge CE , 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge CLK &&& (CE_R), 1:1:1, 0, notifier); 
$period(posedge CLK &&& (CE_R), 1:1:1, notifier); 
$recovery(posedge R , posedge CLK &&& (CE == 1), 0.1:0.1:0.1, notifier); 
$hold(posedge CLK &&& (CE == 1), posedge R , 0:0:0, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module DFFCRH (Q,D,CLK,CE,R); 
input D,CLK,CE,R; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
MACH_DFF_CE_X INS1 (Q_int, D, CLK, R1, VCC, CE, notifier); 
`else 
MACH_DFF_CE INS7 (Q_int, D, CLK, R1, VCC, CE, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (R1, R); 
not INS5 (R2, R); 
and INS6 (CE_NR, CE, R2); 
 
specify 
 
(CLK => Q) = ( 0:0:0, 0:0:0); 
(R => Q) = ( 0:0:0, 0:0:0); 
$width(posedge R, 1:1:1, 0, notifier); 
$setuphold(posedge CLK &&& (CE_NR), D , 0.1:0.1:0.1, 0:0:0, notifier); 
$setuphold(posedge CLK &&& (R == 0), posedge CE , 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge CLK &&& (CE_NR), 1:1:1, 0, notifier); 
$period(posedge CLK &&& (CE_NR), 1:1:1, notifier); 
$recovery(negedge R , posedge CLK &&& (CE == 1), 0.1:0.1:0.1, notifier); 
$hold(posedge CLK &&& (CE == 1), negedge R , 0:0:0, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module DFFCRS (Q,D,CLK,CE,R,S); 
input D,CLK,CE,R,S; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
 
`ifdef xmodel 
MACH_DFF_CE_X INS1 (Q_int, D, CLK, R, S, CE, notifier); 
`else 
MACH_DFF_CE INS7 (Q_int, D, CLK, R, S, CE, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
and INS4 (CE_R_S, CE, R, S); 
and INS5 (CE_R, CE, R); 
and INS6 (CE_S, CE, S); 
and INS8 (R_S, R, S);
 
specify 
 
(CLK => Q) = ( 0:0:0, 0:0:0); 
(R => Q) = ( 0:0:0, 0:0:0);
(S => Q) = ( 0:0:0, 0:0:0);
$width(negedge R, 1:1:1, 0, notifier); 
$width(negedge S, 1:1:1, 0, notifier);  
$setuphold(posedge CLK &&& (CE_R_S), D , 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge CLK &&& (CE_R_S), 1:1:1, 0, notifier); 
$period(posedge CLK &&& (CE_R_S), 1:1:1, notifier); 
$recovery(posedge R , posedge CLK &&& (CE_S), 0.1:0.1:0.1, notifier); 
$hold(posedge CLK &&& (CE_S), posedge R , 0:0:0, notifier); 
$recovery(posedge S , posedge CLK &&& (CE_R), 0.1:0.1:0.1, notifier); 
$hold(posedge CLK &&& (CE_R), posedge S , 0:0:0, notifier); 
 
$setuphold(posedge CLK &&& (R_S), posedge CE , 0.1:0.1:0.1, 0:0:0, notifier); 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module DFFCRSH (Q,D,CLK,CE,R,S); 
input D,CLK,CE,R,S; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
 
`ifdef xmodel 
MACH_DFF_CE_X INS1 (Q_int, D, CLK, R1,S1, CE, notifier); 
`else 
MACH_DFF_CE INS11 (Q_int, D, CLK, R1, S1, CE, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (S1, S); 
not INS5 (R1, R); 
and INS8 (CE_NR_NS, CE, R1, S1); 
and INS9 (CE_NR, CE, R1); 
and INS10 (CE_NS, CE, S1); 
and INS12 (NR_NS, R1, S1);
 
specify 
 
(CLK => Q) = ( 0:0:0, 0:0:0);
(R => Q) = ( 0:0:0, 0:0:0);
(S => Q) = ( 0:0:0, 0:0:0);
$width(posedge R, 1:1:1, 0, notifier); 
$width(posedge S, 1:1:1, 0, notifier); 
$setuphold(posedge CLK &&& (CE_NR_NS), D , 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge CLK &&& (CE_NR_NS), 1:1:1, 0, notifier); 
$period(posedge CLK &&& (CE_NR_NS), 1:1:1, notifier); 
$recovery(negedge R , posedge CLK &&& (CE_NS), 0.1:0.1:0.1, notifier); 
$hold(posedge CLK &&& (CE_NS), negedge R , 0:0:0, notifier); 
$recovery(negedge S , posedge CLK &&& (CE_NR), 0.1:0.1:0.1, notifier); 
$hold(posedge CLK &&& (CE_NR), negedge S , 0:0:0, notifier);  
$setuphold(posedge CLK &&& (NR_NS), posedge CE , 0.1:0.1:0.1, 0:0:0, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module DFFCS (Q,D,CLK,CE,S); 
input D,CLK,CE,S; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
MACH_DFF_CE_X INS1 (Q_int, D, CLK, VCC, S, CE, notifier); 
`else 
MACH_DFF_CE INS5 (Q_int, D, CLK, VCC, S, CE, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
and INS4 (CE_S, CE, S); 
 
specify 
 
(CLK => Q) = ( 0:0:0, 0:0:0);
(S => Q) = ( 0:0:0, 0:0:0);
$width(negedge S, 1:1:1, 0, notifier);  
$setuphold(posedge CLK &&& (CE_S), D , 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge CLK &&& (CE_S), 1:1:1, 0, notifier); 
$period(posedge CLK &&& (CE_S), 1:1:1, notifier); 
$recovery(posedge S , posedge CLK &&& (CE == 1), 0.1:0.1:0.1, notifier); 
$hold(posedge CLK &&& (CE == 1), posedge S , 0:0:0, notifier);  
$setuphold(posedge CLK &&& (S == 1), posedge CE , 0.1:0.1:0.1, 0:0:0, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module DFFCSH (Q,D,CLK,CE,S); 
input D,CLK,CE,S; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
MACH_DFF_CE_X INS1 (Q_int, D, CLK, VCC, S1, CE, notifier); 
`else 
MACH_DFF_CE INS7 (Q_int, D, CLK, VCC, S1, CE, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (S1, S); 
not INS5 (S2, S); 
and INS6 (CE_NS, CE, S2); 
 
specify 
 
(CLK => Q) = ( 0:0:0, 0:0:0);
(S => Q) = ( 0:0:0, 0:0:0);
$width(posedge S, 1:1:1, 0, notifier);  
$setuphold(posedge CLK &&& (CE_NS), D , 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge CLK &&& (CE_NS), 1:1:1, 0, notifier); 
$period(posedge CLK &&& (CE_NS), 1:1:1, notifier); 
$recovery(negedge S , posedge CLK &&& (CE == 1), 0.1:0.1:0.1, notifier); 
$hold(posedge CLK &&& (CE == 1), negedge S , 0:0:0, notifier); 
$setuphold(posedge CLK &&& (S == 0),posedge  CE , 0.1:0.1:0.1, 0:0:0, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module DFFR (Q,D,CLK,R); 
input D,CLK,R; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
MACH_DFF_X INS1 (Q_int, D, CLK, R, VCC, notifier); 
`else 
MACH_DFF INS4 (Q_int, D, CLK, R, VCC, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
 
specify 
 
(CLK => Q) = ( 0:0:0, 0:0:0);
(R => Q) = ( 0:0:0, 0:0:0);

$width(negedge R, 1:1:1, 0, notifier); 
$setuphold(posedge CLK &&& R, D , 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge CLK &&& R, 1:1:1, 0, notifier); 
$period(posedge CLK &&& R, 1:1:1, notifier); 
$recovery(posedge R, posedge CLK, 0.1:0.1:0.1, notifier); 
$hold(posedge CLK, posedge R , 0:0:0, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module DFFRH (Q,D,CLK,R); 
input D,CLK,R; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
MACH_DFF_X INS1 (Q_int, D, CLK, R1, VCC, notifier); 
`else 
MACH_DFF INS1 (Q_int, D, CLK, R1, VCC, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (R1, R); 
not INS5 (R2, R); 
 
specify 
 
(CLK => Q) = ( 0:0:0, 0:0:0);
(R => Q) = ( 0:0:0, 0:0:0);
$width(posedge  R, 1:1:1, 0, notifier); 
$setuphold(posedge CLK &&& R2, D , 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge CLK &&& R2, 1:1:1, 0, notifier); 
$period(posedge CLK &&& R2, 1:1:1, notifier); 
$recovery(negedge R, posedge CLK, 0.1:0.1:0.1, notifier); 
$hold(posedge CLK, negedge R , 0:0:0, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module DFFRS (Q,D,CLK,R,S); 
input D,CLK,R,S; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
 
`ifdef xmodel 
MACH_DFF_X INS1 (Q_int, D, CLK, R, S, notifier); 
`else 
MACH_DFF INS5 (Q_int, D, CLK, R, S, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
and INS4 (R_S, R, S); 
 
specify 
 
(CLK => Q) = ( 0:0:0, 0:0:0);
(R => Q) = ( 0:0:0, 0:0:0);
(S => Q) = ( 0:0:0, 0:0:0);
$width(negedge S, 1:1:1, 0, notifier); 
$width(negedge R, 1:1:1, 0, notifier); 
$setuphold(posedge CLK &&& (R_S), D , 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge CLK &&& (R_S), 1:1:1, 0, notifier); 
$period(posedge CLK &&& (R_S), 1:1:1, notifier); 
$recovery(posedge R &&& (S), posedge CLK, 0.1:0.1:0.1, notifier); 
$hold(posedge CLK &&& (S), posedge R , 0:0:0, notifier); 
$recovery(posedge S &&& (R), posedge CLK, 0.1:0.1:0.1, notifier); 
$hold(posedge CLK &&& (R), posedge S , 0:0:0, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module DFFRSH (Q,D,CLK,R,S); 
input D,CLK,R,S; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
 
`ifdef xmodel 
MACH_DFF_X INS1 (Q_int, D, CLK, R1, S1, notifier); 
`else 
MACH_DFF INS7 (Q_int, D, CLK, R1, S1, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (R1, R); 
not INS5 (S1, S); 
and INS6 (NR_NS, R1, S1); 
 
specify 
 
(CLK => Q) = ( 0:0:0, 0:0:0);
(R => Q) = ( 0:0:0, 0:0:0);
(S => Q) = ( 0:0:0, 0:0:0);
$width(posedge S, 1:1:1, 0, notifier); 
$width(posedge R, 1:1:1, 0, notifier); 
$setuphold(posedge CLK &&& (NR_NS), D , 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge CLK &&& (NR_NS), 1:1:1, 0, notifier); 
$period(posedge CLK &&& (NR_NS), 1:1:1, notifier); 
$recovery(negedge R &&& (S1), posedge CLK, 0.1:0.1:0.1, notifier); 
$hold(posedge CLK &&& (S1), negedge R , 0:0:0, notifier); 
$recovery(negedge S &&& (R1), posedge CLK, 0.1:0.1:0.1, notifier); 
$hold(posedge CLK &&& (R1), negedge S , 0:0:0, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module DFFS (Q,D,CLK,S); 
input D,CLK,S; 
output Q;
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
MACH_DFF_X INS7 (Q_int, D, CLK, VCC, S, notifier); 
`else 
MACH_DFF INS4 (Q_int, D, CLK, VCC, S, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
 
specify 
 
(CLK => Q) = ( 0:0:0, 0:0:0);
(S => Q) = ( 0:0:0, 0:0:0);
$width(negedge S, 1:1:1, 0, notifier);  
$setuphold(posedge CLK &&& (S), D , 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge CLK &&& (S), 1:1:1, 0, notifier); 
$period(posedge CLK &&& (S), 1:1:1, notifier); 
$recovery(posedge S, posedge CLK, 0.1:0.1:0.1, notifier); 
$hold(posedge CLK, posedge S , 0:0:0, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module DFFSH (Q,D,CLK,S); 
input D,CLK,S; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
MACH_DFF_X INS1 (Q_int, D, CLK, VCC, S1, notifier); 
`else 
MACH_DFF INS5 (Q_int, D, CLK, VCC, S1, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (S1, S); 
 
specify 
 
(CLK => Q) = ( 0:0:0, 0:0:0);
(S => Q) = ( 0:0:0, 0:0:0);
$width(posedge S, 1:1:1, 0, notifier);  
$setuphold(posedge CLK &&& (S1), D , 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge CLK &&& (S1), 1:1:1, 0, notifier); 
$period(posedge CLK &&& (S1), 1:1:1, notifier); 
$recovery(negedge S, posedge CLK, 0.1:0.1:0.1, notifier); 
$hold(posedge CLK, negedge S , 0:0:0, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module DLAT (Q,D,LAT); 
input D,LAT; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
MACH_LATCH_X INS1 (Q_int, D, LAT, VCC, VCC, notifier); 
`else 
MACH_LATCH INS4 (Q_int, D, LAT, VCC, VCC, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
 
specify 
 
(LAT => Q) = ( 0:0:0, 0:0:0);
(D => Q) = ( 0:0:0, 0:0:0); 
$setuphold(negedge LAT, D , 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge LAT, 1:1:1, 0, notifier); 
$period(posedge LAT, 1:1:1, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
`celldefine 
 
module DLATR (Q,D,LAT,R); 
input D,LAT,R; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
MACH_LATCH_X INS1 (Q_int, D, LAT, R, VCC, notifier); 
`else 
MACH_LATCH INS4 (Q_int, D, LAT, R, VCC, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
 
specify 
 
(LAT => Q) = ( 0:0:0, 0:0:0);
(D => Q) = ( 0:0:0, 0:0:0);
(R => Q) = ( 0:0:0, 0:0:0);
$width(negedge R, 1:1:1, 0, notifier);  
$setuphold(negedge LAT &&& R, D , 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge LAT &&& R, 1:1:1, 0, notifier); 
$period(posedge LAT &&& R, 1:1:1, notifier); 
$recovery(posedge R, negedge LAT, 0.1:0.1:0.1, notifier); 
$hold(negedge LAT, posedge R , 0:0:0, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module DLATRH (Q,D,LAT,R); 
input D,LAT,R; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
MACH_LATCH_X INS1 (Q_int, D, LAT, R1, VCC, notifier); 
`else 
MACH_LATCH INS5 (Q_int, D, LAT, R1, VCC, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (R1, R); 
 
specify 
 
(LAT => Q) = ( 0:0:0, 0:0:0);
(D => Q) = ( 0:0:0, 0:0:0);
(R => Q) = ( 0:0:0, 0:0:0);
$width(posedge R, 1:1:1, 0, notifier);  
$setuphold(negedge LAT, D &&& R1, 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge LAT &&& R1, 1:1:1, 0, notifier); 
$period(posedge LAT &&& R1, 1:1:1, notifier); 
$recovery(negedge R, negedge LAT, 0.1:0.1:0.1, notifier); 
$hold(negedge LAT, negedge R , 0:0:0, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
  
 
`celldefine 
 
module DLATRS (Q,D,LAT,R,S); 
input D,LAT,R,S; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
not INS8 (NOT_S, S); 
or INS9 (D_in, NOT_S, D); 
 
`ifdef xmodel 
MACH_LATCH_X INS1 (Q_int, D, LAT, R, S, notifier); 
`else 
MACH_LATCH INS5 (Q_int, D, LAT, R, S, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
and INS6 (R_S, R, S); 
specify 
 
(LAT => Q) = ( 0:0:0, 0:0:0);
(D => Q) = ( 0:0:0, 0:0:0);
(S => Q) = ( 0:0:0, 0:0:0);
(R => Q) = ( 0:0:0, 0:0:0);
$width(negedge R, 1:1:1, 0, notifier); 
$width(negedge S, 1:1:1, 0, notifier);  
$setuphold(negedge LAT, D &&& R_S, 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge LAT &&& R_S, 1:1:1, 0, notifier); 
$period(posedge LAT &&& R_S, 1:1:1, notifier); 
$recovery(posedge R &&& (S == 1), negedge LAT, 0.1:0.1:0.1, notifier); 
$recovery(posedge S &&& (R == 1), negedge LAT, 0.1:0.1:0.1, notifier); 
$hold(negedge LAT &&& (S == 1), posedge R , 0:0:0, notifier); 
$hold(negedge LAT &&& (R == 1), posedge S , 0:0:0, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module DLATRSH (Q,D,LAT,R,S); 
input D,LAT,R,S; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
or INS20 (D_in, S, D); 
 
`ifdef xmodel 
MACH_LATCH_X INS1 (Q_int, D, LAT, R1, S1, notifier); 
`else 
MACH_LATCH INS7 (Q_int, D, LAT, R1, S1, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (S1, S); 
not INS5 (R1, R); 
and INS6 (NR_NS , R1, S1); 
specify 
 
(LAT => Q) = ( 0:0:0, 0:0:0);
(D => Q) = ( 0:0:0, 0:0:0);
(S => Q) = ( 0:0:0, 0:0:0);
(R => Q) = ( 0:0:0, 0:0:0);
$width(posedge R, 1:1:1, 0, notifier); 
$width(posedge S, 1:1:1, 0, notifier); 
$setuphold(negedge LAT, D &&& NR_NS, 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge LAT &&& NR_NS, 1:1:1, 0, notifier); 
$period(posedge LAT &&& NR_NS, 1:1:1, notifier); 
$recovery(negedge R &&& (S == 0), negedge LAT, 0.1:0.1:0.1, notifier); 
$hold(negedge LAT, negedge R  &&& (S == 0), 1:1:1, notifier); 
$recovery(negedge S &&& (R == 0), negedge LAT, 0.1:0.1:0.1, notifier); 
$hold(negedge LAT, negedge S  &&& (R == 0), 1:1:1, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module DLATS (Q,D,LAT,S); 
input D,LAT,S; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
MACH_LATCH_X INS1 (Q_int, D, LAT, VCC, S, notifier); 
`else 
MACH_LATCH INS4 (Q_int, D, LAT, VCC, S, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
 
specify 
 
(LAT => Q) = ( 0:0:0, 0:0:0);
(D => Q) = ( 0:0:0, 0:0:0);
(S => Q) = ( 0:0:0, 0:0:0);
$width(negedge S, 1:1:1, 0, notifier);  
$setuphold(negedge LAT, D &&& S, 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge LAT &&& S, 1:1:1, 0, notifier); 
$period(posedge LAT &&& S, 1:1:1, notifier); 
$recovery(posedge S, negedge LAT, 0.1:0.1:0.1, notifier); 
$hold(negedge LAT, posedge S , 0:0:0, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module DLATSH (Q,D,LAT,S); 
input D,LAT,S; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
MACH_LATCH_X INS1 (Q_int, D, LAT, VCC, S1, notifier); 
`else 
MACH_LATCH INS5 (Q_int, D, LAT, VCC, S1, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (S1, S); 
 
specify 
 
(LAT => Q) = ( 0:0:0, 0:0:0);
(D => Q) = ( 0:0:0, 0:0:0);
(S => Q) = ( 0:0:0, 0:0:0);
$width(posedge S, 1:1:1, 0, notifier); 
$setuphold(negedge LAT, D &&& S1, 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge LAT &&& S1, 1:1:1, 0, notifier); 
$period(posedge LAT &&& S1, 1:1:1, notifier); 
$recovery(negedge S, negedge LAT, 0.1:0.1:0.1, notifier); 
$hold(negedge LAT, negedge S , 0:0:0, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
`celldefine 
 
module VCC (X); 
output X; 
 
supply0 GND; 
supply1 VCC; 
 
assign X = VCC; 
 
specify 
 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module GND (X); 
output X; 
 
supply0 GND; 
supply1 VCC; 
 
assign X = GND; 
 
specify 
 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
  
  
`celldefine 
  
module GSRBUF (O,SRI); 
input SRI; 
output O; 
supply0 GND; 
supply1 VCC; 
buf INS1 (O, SRI); 
  
specify 
  
(SRI => O) =  0:0:0, 0:0:0;
  
endspecify 
  
  
endmodule 
`endcelldefine 
 
`celldefine 
 
module IBUF (O,I0); 
input I0; 
output O; 
supply0 GND; 
supply1 VCC; 

reg o0;

parameter PULL = "Off";

 
buf INS1 (O, o0); 

always @(I0)
begin
 if (PULL == "Off")
    o0 = I0;
 else if (PULL == "Up")
        case(I0)
           1'b0: o0 = 1'b0;
           1'b1: o0 = 1'b1;
           1'bz: o0 = 1'b1;
        endcase
 else if (PULL == "Down")
        case(I0)
           1'b0: o0 = 1'b0;
           1'b1: o0 = 1'b1;
           1'bz: o0 = 1'b0;
        endcase
 else if (PULL == "Hold")
        case(I0)
           1'b0: o0 = 1'b0;
           1'b1: o0 = 1'b1;
           1'bz: o0 = o0;
        endcase
end
             
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
 
endspecify 

endmodule
`endcelldefine
 
`celldefine

module LVDSIN (O,P_IN,N_IN); 
input P_IN,N_IN; 
output O; 
 
buf INS1 (O, P_IN); 
 
specify 
 
(P_IN => O) =  0:0:0, 0:0:0; 
(N_IN => O) =  0:0:0, 0:0:0; 
 
endspecify 
endmodule 

`endcelldefine

`celldefine

module LVDSOUT (P_OUT,N_OUT,I); 
input I; 
output P_OUT,N_OUT; 

not INS1 (N_OUT, I); 
buf INS2 (P_OUT, I); 
 
specify 
 
(I => P_OUT) =  0:0:0, 0:0:0; 
(I => N_OUT) =  0:0:0, 0:0:0; 
 
endspecify 
endmodule 

`endcelldefine
 
 
`celldefine 
 
module LVDSTRI (N_OUT,P_OUT,I,OE); 
input I,OE; 
output N_OUT, P_OUT; 

supply0 GND; 
supply1 VCC; 

bufif1 INS1 (P_OUT, I, OE); 
notif1 INS2 (N_OUT, I, OE);
 
specify 
 
(I => P_OUT) =  0:0:0, 0:0:0;
(I => N_OUT) =  0:0:0, 0:0:0;
(OE => P_OUT) =  0:0:0, 0:0:0;
(OE => N_OUT) =  0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 

`celldefine 
 
module LVDSIO (O,I,P_IO,N_IO,OE); 
input I,OE; 
inout P_IO,N_IO; 
output O; 
 
supply0 GND; 
supply1 VCC; 

buf INS1 (O, P_IO); 
bufif1 INS2 (P_IO, I, OE); 
notif1 INS3 (N_IO, I, OE); 
specify 
 
(I => P_IO) = 0:0:0, 0:0:0;
(I => N_IO) = 0:0:0, 0:0:0;
(OE => P_IO) = 0:0:0, 0:0:0;
(OE => N_IO) = 0:0:0, 0:0:0;
(P_IO => O) =  0:0:0, 0:0:0;
(N_IO => O) =  0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
`celldefine

module BLVDSIN (O,P_IN,N_IN); 
input P_IN,N_IN; 
output O; 
 
buf INS1 (O, P_IN); 
 
specify 
 
(P_IN => O) =  0:0:0, 0:0:0; 
(N_IN => O) =  0:0:0, 0:0:0; 
 
endspecify 
endmodule 

`endcelldefine

`celldefine

module BLVDSOUT (P_OUT,N_OUT,I); 
input I; 
output P_OUT,N_OUT; 
 
buf INS1 (P_OUT, I); 
not INS2 (N_OUT, I); 
specify 
 
(I => P_OUT) =  0:0:0, 0:0:0; 
(I => N_OUT) =  0:0:0, 0:0:0; 
 
endspecify 
endmodule 

`endcelldefine
 
 
`celldefine 
 
module BLVDSTRI (N_OUT,P_OUT,I,OE); 
input I,OE; 
output N_OUT, P_OUT;
supply0 GND; 
supply1 VCC; 

bufif1 INS1 (P_OUT, I, OE); 
notif1 INS2 (N_OUT, I, OE);
 
specify 
 
(I => P_OUT) =  0:0:0, 0:0:0;
(I => N_OUT) =  0:0:0, 0:0:0;
(OE => P_OUT) =  0:0:0, 0:0:0;
(OE => N_OUT) =  0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 

`celldefine 
 
module BLVDSIO (O,I,P_IO,N_IO,OE); 
input I,OE; 
inout P_IO,N_IO; 
output O; 
supply0 GND; 
supply1 VCC; 
 
buf INS1 (O, P_IO); 
bufif1 INS2 (P_IO, I, OE); 
notif1 INS3 (N_IO, I, OE);
 
specify 
 
(I => P_IO) = 0:0:0, 0:0:0;
(I => N_IO) = 0:0:0, 0:0:0;
(OE => P_IO) = 0:0:0, 0:0:0;
(OE => N_IO) = 0:0:0, 0:0:0;
(P_IO => O) =  0:0:0, 0:0:0;
(N_IO => O) =  0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
 
`celldefine 
 
module INV (O,I0); 
input I0; 
output O; 
supply0 GND; 
supply1 VCC; 
not INS1 (O, I0); 
 
specify 
 
(I0 => O) =  0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
`celldefine 
 
module INVTH (O,I0,OE); 
input I0,OE; 
output O; 
supply0 GND; 
supply1 VCC; 

reg O2;

parameter OUTOPEN = "Off";

not INS2 (O1,I0);

bufif1 INSXQ (O,O2,OE);  

always @(OE or O1)
  begin
     if (OE == 1'b0)
         O2 = 1'bz;
     else if (OE == 1'b1)
            if (OUTOPEN == "Off")
                 O2 = O1;
            else if (OUTOPEN == "Drain" || OUTOPEN == "Collect")
               begin
                 if (O1 == 1'b0)
                    O2 = 1'b0;
                 else if (O1 == 1'b1)
                    O2 = 1'bz;
                 else
                    O2 = 1'bx;
          end
  end     
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(OE => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
`celldefine 
 
module INVTL (O,I0,OE); 
input I0,OE; 
output O; 
supply0 GND; 
supply1 VCC; 

reg O2;

parameter OUTOPEN = "Off";

not INS2 (O1,I0);

bufif0 INSXQ (O,O2,OE);  

always @(OE or O1)
  begin
     if (OE == 1'b1)
         O2 = 1'bz;
     else if (OE == 1'b0)
            if (OUTOPEN == "Off")
                 O2 = O1;
            else if (OUTOPEN == "Drain" || OUTOPEN == "Collect")
               begin
                 if (O1 == 1'b0)
                    O2 = 1'b0;
                 else if (O1 == 1'b1)
                    O2 = 1'bz;
                 else
                    O2 = 1'bx;
          end
  end     
 
specify 
 
(I0 => O) =  0:0:0, 0:0:0;
(OE => O) =  0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
`celldefine 
 
module NAN2 (O,I0,I1); 
input I0,I1; 
output O; 
supply0 GND; 
supply1 VCC; 
nand INS1 (O, I0, I1); 
 
specify 
 
(I0 => O) =  0:0:0, 0:0:0;
(I1 => O) =  0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
 
`celldefine 
 
module NAN3 (O,I0,I1,I2); 
input I0,I1,I2; 
output O; 
supply0 GND; 
supply1 VCC; 
nand INS1 (O, I0, I1, I2); 
 
specify 
 
(I0 => O) =  0:0:0, 0:0:0;
(I1 => O) =  0:0:0, 0:0:0;
(I2 => O) =  0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
 
`celldefine 
 
module NAN4 (O,I0,I1,I2,I3); 
input I0,I1,I2,I3; 
output O; 
supply0 GND; 
supply1 VCC; 
nand INS1 (O, I0, I1, I2, I3); 
 
specify 
 
(I0 => O) =  0:0:0, 0:0:0;
(I1 => O) =  0:0:0, 0:0:0;
(I2 => O) =  0:0:0, 0:0:0;
(I3 => O) =  0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
 
`celldefine 
 
module NAN5 (O,I0,I1,I2,I3,I4); 
input I0,I1,I2,I3,I4; 
output O; 
supply0 GND; 
supply1 VCC; 
nand INS1 (O, I0, I1, I2, I3, I4); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(I1 => O) = 0:0:0, 0:0:0;
(I2 => O) = 0:0:0, 0:0:0;
(I3 => O) = 0:0:0, 0:0:0;
(I4 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
 
`celldefine 
 
module NAN6 (O,I0,I1,I2,I3,I4,I5); 
input I0,I1,I2,I3,I4,I5; 
output O; 
supply0 GND; 
supply1 VCC; 
nand INS1 (O, I0, I1, I2, I3, I4, I5); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(I1 => O) = 0:0:0, 0:0:0;
(I2 => O) = 0:0:0, 0:0:0;
(I3 => O) = 0:0:0, 0:0:0;
(I4 => O) = 0:0:0, 0:0:0;
(I5 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
 
`celldefine 
 
module NAN7 (O,I0,I1,I2,I3,I4,I5,I6); 
input I0,I1,I2,I3,I4,I5,I6; 
output O; 
supply0 GND; 
supply1 VCC; 
nand INS1 (O, I0, I1, I2, I3, I4, I5, I6); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(I1 => O) = 0:0:0, 0:0:0;
(I2 => O) = 0:0:0, 0:0:0;
(I3 => O) = 0:0:0, 0:0:0;
(I4 => O) = 0:0:0, 0:0:0;
(I5 => O) = 0:0:0, 0:0:0;
(I6 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
 
`celldefine 
 
module NAN8 (O,I0,I1,I2,I3,I4,I5,I6,I7); 
input I0,I1,I2,I3,I4,I5,I6,I7; 
output O; 
supply0 GND; 
supply1 VCC; 
nand INS1 (O, I0, I1, I2, I3, I4, I5, I6, I7); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(I1 => O) = 0:0:0, 0:0:0;
(I2 => O) = 0:0:0, 0:0:0;
(I3 => O) = 0:0:0, 0:0:0;
(I4 => O) = 0:0:0, 0:0:0;
(I5 => O) = 0:0:0, 0:0:0;
(I6 => O) = 0:0:0, 0:0:0;
(I7 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
`celldefine 
 
module NOR2 (O,I0,I1); 
input I0,I1; 
output O; 
supply0 GND; 
supply1 VCC; 
nor INS1 (O, I0, I1); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(I1 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
 
`celldefine 
 
module NOR3 (O,I0,I1,I2); 
input I0,I1,I2; 
output O; 
supply0 GND; 
supply1 VCC; 
nor INS1 (O, I0, I1, I2); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(I1 => O) = 0:0:0, 0:0:0;
(I2 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
 
`celldefine 
 
module NOR4 (O,I0,I1,I2,I3); 
input I0,I1,I2,I3; 
output O; 
supply0 GND; 
supply1 VCC; 
nor INS1 (O, I0, I1, I2, I3); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(I1 => O) = 0:0:0, 0:0:0;
(I2 => O) = 0:0:0, 0:0:0;
(I3 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
 
`celldefine 
 
module NOR5 (O,I0,I1,I2,I3,I4); 
input I0,I1,I2,I3,I4; 
output O; 
supply0 GND; 
supply1 VCC; 
nor INS1 (O, I0, I1, I2, I3, I4); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(I1 => O) = 0:0:0, 0:0:0;
(I2 => O) = 0:0:0, 0:0:0;
(I3 => O) = 0:0:0, 0:0:0;
(I4 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
 
`celldefine 
 
module NOR6 (O,I0,I1,I2,I3,I4,I5); 
input I0,I1,I2,I3,I4,I5; 
output O; 
supply0 GND; 
supply1 VCC; 
nor INS1 (O, I0, I1, I2, I3, I4, I5); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(I1 => O) = 0:0:0, 0:0:0;
(I2 => O) = 0:0:0, 0:0:0;
(I3 => O) = 0:0:0, 0:0:0;
(I4 => O) = 0:0:0, 0:0:0;
(I5 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
 
`celldefine 
 
module NOR7 (O,I0,I1,I2,I3,I4,I5,I6); 
input I0,I1,I2,I3,I4,I5,I6; 
output O; 
supply0 GND; 
supply1 VCC; 
nor INS1 (O, I0, I1, I2, I3, I4, I5, I6); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(I1 => O) = 0:0:0, 0:0:0;
(I2 => O) = 0:0:0, 0:0:0;
(I3 => O) = 0:0:0, 0:0:0;
(I4 => O) = 0:0:0, 0:0:0;
(I5 => O) = 0:0:0, 0:0:0;
(I6 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
 
`celldefine 
 
module NOR8 (O,I0,I1,I2,I3,I4,I5,I6,I7); 
input I0,I1,I2,I3,I4,I5,I6,I7; 
output O; 
supply0 GND; 
supply1 VCC; 
nor INS1 (O, I0, I1, I2, I3, I4, I5, I6, I7); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(I1 => O) = 0:0:0, 0:0:0;
(I2 => O) = 0:0:0, 0:0:0;
(I3 => O) = 0:0:0, 0:0:0;
(I4 => O) = 0:0:0, 0:0:0;
(I5 => O) = 0:0:0, 0:0:0;
(I6 => O) = 0:0:0, 0:0:0;
(I7 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
`celldefine 
 
module OBUF (O,I0); 
input I0; 
output O; 
supply0 GND; 
supply1 VCC;

reg o0;

parameter OUTOPEN = "Off";

buf INSXQ (O,o0);  

always @(I0)
 begin
   if (OUTOPEN == "Off")
      o0 = I0;
   else if (OUTOPEN == "Drain" || OUTOPEN == "Collect")
          begin
            if (I0 == 1'b0)
               o0 = 1'b0;
            else if (I0 == 1'b1)
               o0 = 1'bz;
            else
               o0 = 1'bx;
          end
 end
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
`celldefine 
 
module OR2 (O,I0,I1); 
input I0,I1; 
output O; 
supply0 GND; 
supply1 VCC; 
or INS1 (O, I0, I1); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(I1 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
 
`celldefine 
 
module OR3 (O,I0,I1,I2); 
input I0,I1,I2; 
output O; 
supply0 GND; 
supply1 VCC; 
or INS1 (O, I0, I1, I2); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(I1 => O) = 0:0:0, 0:0:0;
(I2 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
 
`celldefine 
 
module OR4 (O,I0,I1,I2,I3); 
input I0,I1,I2,I3; 
output O; 
supply0 GND; 
supply1 VCC; 
or INS1 (O, I0, I1, I2, I3); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(I1 => O) = 0:0:0, 0:0:0;
(I2 => O) = 0:0:0, 0:0:0;
(I3 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
 
`celldefine 
 
module OR5 (O,I0,I1,I2,I3,I4); 
input I0,I1,I2,I3,I4; 
output O; 
supply0 GND; 
supply1 VCC; 
or INS1 (O, I0, I1, I2, I3, I4); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(I1 => O) = 0:0:0, 0:0:0;
(I2 => O) = 0:0:0, 0:0:0;
(I3 => O) = 0:0:0, 0:0:0;
(I4 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
 
`celldefine 
 
module OR6 (O,I0,I1,I2,I3,I4,I5); 
input I0,I1,I2,I3,I4,I5; 
output O; 
supply0 GND; 
supply1 VCC; 
or INS1 (O, I0, I1, I2, I3, I4, I5); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(I1 => O) = 0:0:0, 0:0:0;
(I2 => O) = 0:0:0, 0:0:0;
(I3 => O) = 0:0:0, 0:0:0;
(I4 => O) = 0:0:0, 0:0:0;
(I5 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
 
`celldefine 
 
module OR7 (O,I0,I1,I2,I3,I4,I5,I6); 
input I0,I1,I2,I3,I4,I5,I6; 
output O; 
supply0 GND; 
supply1 VCC; 
or INS1 (O, I0, I1, I2, I3, I4, I5, I6); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(I1 => O) = 0:0:0, 0:0:0;
(I2 => O) = 0:0:0, 0:0:0;
(I3 => O) = 0:0:0, 0:0:0;
(I4 => O) = 0:0:0, 0:0:0;
(I5 => O) = 0:0:0, 0:0:0;
(I6 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
 
`celldefine 
 
module OR8 (O,I0,I1,I2,I3,I4,I5,I6,I7); 
input I0,I1,I2,I3,I4,I5,I6,I7; 
output O; 
supply0 GND; 
supply1 VCC; 
or INS1 (O, I0, I1, I2, I3, I4, I5, I6, I7); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(I1 => O) = 0:0:0, 0:0:0;
(I2 => O) = 0:0:0, 0:0:0;
(I3 => O) = 0:0:0, 0:0:0;
(I4 => O) = 0:0:0, 0:0:0;
(I5 => O) = 0:0:0, 0:0:0;
(I6 => O) = 0:0:0, 0:0:0;
(I7 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module TFF (Q,T,CLK); 
input T,CLK; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
MACH_DFF_X INS1 (Q_int, T_int,CLK, VCC, VCC, notifier); 
`else 
MACH_DFF INS4 (Q_int, T_int,CLK, VCC, VCC, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
xor INS2 (T_int,Q_reg,T);
buf INS3 (Q, Q_reg); 
 
specify 
 
(CLK => Q) = ( 0:0:0, 0:0:0);
$setuphold(posedge CLK, T , 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge CLK, 1:1:1, 0, notifier); 
$period(posedge CLK, 1:1:1, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module TFFR (Q,T,CLK,R); 
input T,CLK,R; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
MACH_TFF_X INS1 (Q_int, CLK, T, VCC, R, notifier); 
`else 
MACH_TFF INS4 (Q_int, CLK, T, VCC, R, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
 
specify 
 
(CLK => Q) = ( 0:0:0, 0:0:0);
(R => Q) = ( 0:0:0, 0:0:0);
$width(negedge R, 1:1:1, 0, notifier);  
$setuphold(posedge CLK, T  &&& (R), 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge CLK &&& (R), 1:1:1, 0, notifier); 
$period(posedge CLK &&& (R), 1:1:1, notifier); 
$recovery(posedge R, posedge CLK, 0.1:0.1:0.1, notifier); 
$hold(posedge CLK, posedge R , 0:0:0, notifier ); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module TFFRH (Q,T,CLK,R); 
input T,CLK,R; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
MACH_TFF_X INS1 (Q_int, CLK, T, VCC, R1, notifier); 
`else 
MACH_TFF INS5 (Q_int, CLK, T, VCC, R1, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (R1, R); 
 
specify 
 
(CLK => Q) = ( 0:0:0, 0:0:0);
(R => Q) = ( 0:0:0, 0:0:0);
$width(posedge R, 1:1:1, 0, notifier); 
$setuphold(posedge CLK, T  &&& (R == 0), 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge CLK &&& (R == 0), 1:1:1, 0, notifier); 
$period(posedge CLK &&& (R == 0), 1:1:1, notifier); 
$recovery(negedge R, posedge CLK, 0.1:0.1:0.1, notifier); 
$hold(posedge CLK, negedge R , 0:0:0, notifier ); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module TFFRS (Q,T,CLK,R,S); 
input T,CLK,R,S; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
MACH_TFF_X INS1 (Q_int, CLK, T, S, R, notifier); 
`else 
MACH_TFF INS4 (Q_int, CLK, T, S, R, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
and INS5 (S_R, S, R); 
 
specify 
 
(CLK => Q) = ( 0:0:0, 0:0:0);
(R => Q) = ( 0:0:0, 0:0:0);
(S => Q) = ( 0:0:0, 0:0:0);
$width(negedge R, 1:1:1, 0, notifier); 
$width(negedge S, 1:1:1, 0, notifier); 
$setuphold(posedge CLK, T  &&& (S_R), 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge CLK &&& (S_R), 1:1:1, 0, notifier); 
$period(posedge CLK &&& (S_R), 1:1:1, notifier); 
$recovery(posedge R &&& (S), posedge CLK, 0.1:0.1:0.1, notifier); 
$hold(posedge CLK, posedge R  &&& (S), 0:0:0, notifier); 
$recovery(posedge S &&& (R), posedge CLK, 0.1:0.1:0.1, notifier); 
$hold(posedge CLK, posedge S  &&& (R), 0:0:0, notifier); 
 
endspecify 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module TFFRSH (Q,T,CLK,R,S); 
input T,CLK,R,S; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
MACH_TFF_X INS1 (Q_int, CLK, T, S1, R1, notifier); 
`else 
MACH_TFF INS2 (Q_int, CLK, T, S1, R1, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS3 (Q, Q_reg); 
not INS5 (R1, R); 
not INS6 (S1, S); 
and INS7 (S_R, S1, R1); 
 
specify 
 
(CLK => Q) = ( 0:0:0, 0:0:0);
(R => Q) = ( 0:0:0, 0:0:0);
(S => Q) = ( 0:0:0, 0:0:0);
$width(posedge R, 1:1:1, 0, notifier); 
$width(posedge S, 1:1:1, 0, notifier);  
$setuphold(posedge CLK, T  &&& (S_R), 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge CLK &&& (S_R), 1:1:1, 0, notifier); 
$period(posedge CLK &&& (S_R), 1:1:1, notifier); 
$recovery(negedge R &&& (S1), posedge CLK, 0.1:0.1:0.1, notifier); 
$hold(posedge CLK, negedge R  &&& (S1), 0:0:0, notifier); 
$recovery(negedge S &&& (R1), posedge CLK, 0.1:0.1:0.1, notifier); 
$hold(posedge CLK, negedge S  &&& (R1), 0:0:0, notifier); 
 
endspecify 
 
endmodule 
`endcelldefine 
 
`celldefine 
 
module TFFS (Q,T,CLK,S); 
input T,CLK,S; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
MACH_TFF_X INS1 (Q_int, CLK, T, S, VCC, notifier); 
`else 
MACH_TFF INS4 (Q_int, CLK, T, S, VCC, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
 
specify 
 
(CLK => Q) = ( 0:0:0, 0:0:0);
(S => Q) = ( 0:0:0, 0:0:0);
$width(negedge S, 1:1:1, 0, notifier); 
$setuphold(posedge CLK, T  &&& (S), 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge CLK &&& (S), 1:1:1, 0, notifier); 
$period(posedge CLK &&& (S), 1:1:1, notifier); 
$recovery(posedge S, posedge CLK, 0.1:0.1:0.1, notifier); 
$hold(posedge CLK, posedge S , 0:0:0, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module TFFSH (Q,T,CLK,S); 
input T,CLK,S; 
output Q; 
reg notifier; 
reg Q_reg; 
 
supply0 GND; 
supply1 VCC; 
 
`ifdef xmodel 
MACH_TFF_X INS1 (Q_int, CLK, T, S1, VCC, notifier); 
`else 
MACH_TFF INS5 (Q_int, CLK, T, S1, VCC, notifier); 
`endif 
 
`ifdef PUC 
        initial Q_reg = 0; 
`endif 
 
        always @(Q_int) Q_reg = Q_int; 
 
 
buf INS2 (Q, Q_reg); 
not INS4 (S1, S); 
 
specify 
 
(CLK => Q) = ( 0:0:0, 0:0:0);
(S => Q) = ( 0:0:0, 0:0:0);
$width(posedge S, 1:1:1, 0, notifier); 
$setuphold(posedge CLK, T  &&& (S == 0), 0.1:0.1:0.1, 0:0:0, notifier); 
$width(posedge CLK &&& (S == 0), 1:1:1, 0, notifier); 
$period(posedge CLK &&& (S == 0), 1:1:1, notifier); 
$recovery(negedge S, posedge CLK, 0.1:0.1:0.1, notifier); 
$hold(posedge CLK, negedge S , 0:0:0, notifier); 
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
`celldefine 
 
module XOR2 (O,I0,I1); 
input I0,I1; 
output O; 
supply0 GND; 
supply1 VCC; 
xor INS1 (O, I0, I1); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(I1 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 
 
 
`celldefine 
 
module XORSOFT (O,I0,I1); 
input I0,I1; 
output O; 
supply0 GND; 
supply1 VCC; 
xor INS1 (O, I0, I1); 
 
specify 
 
(I0 => O) = 0:0:0, 0:0:0;
(I1 => O) = 0:0:0, 0:0:0;
 
endspecify 
 
 
endmodule 
`endcelldefine 

`celldefine

module CCU_AGB (COUT,A0,B0,CIN); 
input A0,B0,CIN; 
output COUT; 
supply0 GND; 
supply1 VCC; 
 
not INS1(b,B0); 
and INS2(a,A0,b); 
xnor INS3(a1,A0,B0); 
and INS4(a2,a1,CIN); 
or INS5(COUT,a,a2); 
 
specify 
 
(A0 => COUT) =  0:0:0, 0:0:0; 
(B0 => COUT) =  0:0:0, 0:0:0; 
(CIN => COUT) =  0:0:0, 0:0:0; 
 
endspecify 
endmodule 
 

`endcelldefine

`celldefine

module CCU_AS (S0,COUT,A0,B0,CIN,AS); 
input A0,B0,CIN,AS; 
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
xor INS1 (S0, A0, CIN, out_1); 
xnor INS2 (out_1, AS, B0); 
or  INS3 (out_2, CIN, A0); 
and INS4 (out_3, out_1, out_2); 
and INS5 (out_4, CIN, A0); 
or  INS6 (COUT, out_4, out_3); 
 
specify 
 
(A0 => S0) =  0:0:0, 0:0:0; 
(B0 => S0) =  0:0:0, 0:0:0; 
(CIN => S0) =  0:0:0, 0:0:0; 
(AS => S0) =  0:0:0, 0:0:0; 
(A0 => COUT) =  0:0:0, 0:0:0; 
(B0 => COUT) =  0:0:0, 0:0:0; 
(AS => COUT) =  0:0:0, 0:0:0; 
(CIN => COUT) =  0:0:0, 0:0:0; 
 
endspecify 
 
 
endmodule 

`endcelldefine

`celldefine

module CCU_ADD (S0,COUT,A0,B0,CIN); 
input A0,B0,CIN; 
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
xor  INS1 (S0, A0, CIN, B0); 
and  INS2 (out_1, A0, B0); 
and  INS3 (out_2, A0, CIN); 
and  INS4 (out_3, CIN, B0); 
or   INS5 (COUT, out_1, out_2, out_3); 

 
specify 
 
(A0 => S0) =  0:0:0, 0:0:0; 
(B0 => S0) =  0:0:0, 0:0:0; 
(CIN => S0) =  0:0:0, 0:0:0; 
(A0 => COUT) =  0:0:0, 0:0:0; 
(B0 => COUT) =  0:0:0, 0:0:0; 
(CIN => COUT) =  0:0:0, 0:0:0; 
 
endspecify 
 
 
endmodule 

`endcelldefine

`celldefine

module CCU_SUB (S0,COUT,A0,B0,CIN); 
input A0,B0,CIN; 
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
not  INS0 (B0_B, B0);
xor  INS1 (S0, A0, CIN, B0_B); 
and  INS2 (out_1, A0, B0_B); 
and  INS3 (out_2, A0, CIN); 
and  INS4 (out_3, CIN, B0_B); 
or   INS5 (COUT, out_1, out_2, out_3); 

 
specify 
 
(A0 => S0) =  0:0:0, 0:0:0; 
(B0 => S0) =  0:0:0, 0:0:0; 
(CIN => S0) =  0:0:0, 0:0:0; 
(A0 => COUT) =  0:0:0, 0:0:0; 
(B0 => COUT) =  0:0:0, 0:0:0; 
(CIN => COUT) =  0:0:0, 0:0:0; 
 
endspecify 
 
 
endmodule 

`endcelldefine

`celldefine

module CCU_UDCP (S0,COUT,D, SD, LOAD, UD, CIN);
input D, SD, LOAD, UD, CIN ;
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 

not  INS1 (LOAD_B, LOAD);
not  INS2 (UD_B, UD);
and  INS3 (out_1, LOAD, SD);
xor  INS4 (out_2, D, UD_B, CIN);
and  INS5 (out_3, LOAD_B, out_2);
or   INS6 (S0, out_1, out_3);

and  INS7 (out_4, D, UD_B);
and  INS8 (out_5, D, CIN);
and  INS9 (out_6, UD_B, CIN);
or   INS10 (COUT, out_4, out_5, out_6);
 
specify 
 
(D => S0)    =  0:0:0, 0:0:0; 
(SD => S0)   =  0:0:0, 0:0:0; 
(LOAD => S0) =  0:0:0, 0:0:0; 
(UD => S0)   =  0:0:0, 0:0:0; 
(CIN => S0)  =  0:0:0, 0:0:0; 
(D => COUT)    =  0:0:0, 0:0:0; 
(SD => COUT)   =  0:0:0, 0:0:0; 
(LOAD => COUT) =  0:0:0, 0:0:0; 
(UD => COUT)   =  0:0:0, 0:0:0; 
(CIN => COUT)  =  0:0:0, 0:0:0; 
 
endspecify 

endmodule 

`endcelldefine

`celldefine

module CCU_UDC (S0,COUT, D, UD,CIN); 
input D, UD, CIN; 
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
not  INS1 (UD_B, UD);
xor  INS2 (S0, D, UD_B, CIN); 
and  INS3 (out_1, D, UD_B);
and  INS4 (out_2, D, CIN);
and  INS5 (out_3, CIN, UD_B); 
or   INS6 (COUT, out_1, out_2, out_3); 

 
specify 
 
(D => S0) =  0:0:0, 0:0:0; 
(UD => S0) =  0:0:0, 0:0:0; 
(CIN => S0) =  0:0:0, 0:0:0; 
(D => COUT) =  0:0:0, 0:0:0; 
(UD => COUT) =  0:0:0, 0:0:0; 
(CIN => COUT) =  0:0:0, 0:0:0; 
 
endspecify 
 
 
endmodule 

`endcelldefine

`celldefine

module CCU_DC (S0,COUT, D, CIN); 
input D, CIN; 
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
xnor  INS1 (S0, D, CIN); 
or    INS2 (COUT,D,CIN);

 
specify 
 
(D => S0) =  0:0:0, 0:0:0; 
(CIN => S0) =  0:0:0, 0:0:0; 
(D => COUT) =  0:0:0, 0:0:0; 
(CIN => COUT) =  0:0:0, 0:0:0; 
 
endspecify 
 
 
endmodule 

`endcelldefine

`celldefine

module CCU_UC (S0,COUT, D, CIN); 
input D, CIN; 
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
xor   INS1 (S0, D, CIN); 
and   INS2 (COUT,D,CIN);

 
specify 
 
(D => S0) =  0:0:0, 0:0:0; 
(CIN => S0) =  0:0:0, 0:0:0; 
(D => COUT) =  0:0:0, 0:0:0; 
(CIN => COUT) =  0:0:0, 0:0:0; 
 
endspecify 
 
 
endmodule 

`endcelldefine

`celldefine

module DC_LSB (S0,COUT, D, CIN); 
input D, CIN; 
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
xor  INS1 (S0, D, CIN); 
and  INS2 (COUT, D, CIN);

 
specify 
 
(D => S0) =  0:0:0, 0:0:0; 
(CIN => S0) =  0:0:0, 0:0:0; 
(D => COUT) =  0:0:0, 0:0:0; 
(CIN => COUT) =  0:0:0, 0:0:0; 
 
endspecify 
 
 
endmodule 

`endcelldefine

`celldefine

module UC_LSB (S0,COUT, D, CIN); 
input D, CIN; 
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 
 
xor  INS1 (S0, D, CIN); 
and  INS2 (COUT, D, CIN);

 
specify 
 
(D => S0) =  0:0:0, 0:0:0; 
(CIN => S0) =  0:0:0, 0:0:0; 
(D => COUT) =  0:0:0, 0:0:0; 
(CIN => COUT) =  0:0:0, 0:0:0; 
 
endspecify 
 
 
endmodule 

`endcelldefine

`celldefine

module CCU_UCP (S0,COUT,D, SD, LOAD, CIN);
input D, SD, LOAD, CIN ;
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 


not  INS1 (LOAD_B, LOAD);
and  INS2 (out_1, LOAD, SD);
and  INS3 (out_2, D, LOAD_B);
or   INS4 (out_3, out_1, out_2);
xor  INS5 (S0, out_3, CIN);

and  INS6 (COUT, out_3, CIN);

specify 
 
(D => S0)    =  0:0:0, 0:0:0; 
(SD => S0)   =  0:0:0, 0:0:0; 
(LOAD => S0) =  0:0:0, 0:0:0; 
(CIN => S0)  =  0:0:0, 0:0:0; 
(D => COUT)    =  0:0:0, 0:0:0; 
(SD => COUT)   =  0:0:0, 0:0:0; 
(LOAD => COUT) =  0:0:0, 0:0:0; 
(CIN => COUT)  =  0:0:0, 0:0:0; 
 
endspecify 
 
 
endmodule 

`endcelldefine

`celldefine

module CCU_DCP (S0,COUT,D, SD, LOAD, CIN);
input D, SD, LOAD, CIN ;
output S0,COUT; 
 
supply0 GND; 
supply1 VCC; 


not  INS1 (LOAD_B, LOAD);
and  INS2 (out_1, LOAD, SD);
and  INS3 (out_2, D, LOAD_B);
or   INS4 (out_3, out_1, out_2);
xnor INS5 (S0, out_3, CIN);

or   INS6 (COUT , out_3, CIN);

specify 
 
(D => S0)    =  0:0:0, 0:0:0; 
(SD => S0)   =  0:0:0, 0:0:0; 
(LOAD => S0) =  0:0:0, 0:0:0; 
(CIN => S0)  =  0:0:0, 0:0:0; 
(D => COUT)    =  0:0:0, 0:0:0; 
(SD => COUT)   =  0:0:0, 0:0:0; 
(LOAD => COUT) =  0:0:0, 0:0:0; 
(CIN => COUT)  =  0:0:0, 0:0:0; 
 
endspecify 
 
 
endmodule 

`endcelldefine
 
primitive  MACH_DFF(Q,D,CLK,R,S,NOTIFIER);
output Q;
reg Q;
input CLK,
      D,
      R,S,
      NOTIFIER;

// FUNCTION : POSITIVE EDGE TRIGGERED D-FLIP FLOP WITH ACTIVE LOW 
//              ASYNCHRONOUS SET AND CLEAR
 table
//D      CLK     R   S   NOTIFIER      Q(t)    Q(t+1)
       
  1      (01)    1   ?      ?       :   ?   :   1;  // clocked data
  0      (01)    ?   1      ?       :   ?   :   0;  // clocked data

  1       ?      1   *      ?       :   1   :   1;  // pessimism
  ?       0      1   *      ?       :   1   :   1;  // pessimism
  ?       1      1   *      ?       :   1   :   1;  // pessimism
  1       ?      0   (10)      ?       :   0   :   x;  // pessimism
  ?       0      0   (10)      ?       :   0   :   x;  // pessimism
  ?       1      0   (10)      ?       :   0   :   x;  // pessimism

  0       ?      *   1      ?       :   0   :   0;  // pessimism
  ?       0      *   1      ?       :   0   :   0;  // pessimism
  ?       1      *   1      ?       :   0   :   0;  // pessimism
  0       ?      (10)   0      ?       :   1   :   x;  // pessimism
  ?       0      (10)   0      ?       :   1   :   x;  // pessimism
  ?       1      (10)   0      ?       :   1   :   x;  // pessimism

  1       p      1   1      ?       :   1   :   1;  // reducing pessimism
  0       p      1   1      ?       :   0   :   0;
 
  ?       ?      0   1      ?       :   ?   :   0;  // asynchronous clear
  ?       ?      1   0      ?       :   ?   :   1;  // asynchronous set

  ?      (?0)    ?   ?      ?       :   ?   :   -;  // ignore falling clock
  0      (?x)    ?   ?      ?       :   0   :   -;  // retain state when D == Qt
  1      (?x)    ?   ?      ?       :   1   :   -;  // retain state when D == Qt
  *       1      ?   ?      ?       :   ?   :   -;  // ignore data edges
  *       0      ?   ?      ?       :   ?   :   -;  // ignore data edges
  ?       ?      ?   ?      *       :   ?   :   -;
 
endtable
endprimitive
primitive  MACH_DFF_CE(Q,D,CLK,R,S,CE,NOTIFIER);
output Q;
reg Q;
input CLK,
      D,
      R,S,
      CE,  //clock enable active high
      NOTIFIER;

// FUNCTION : POSITIVE EDGE TRIGGERED D-FLIP FLOP WITH ACTIVE HIGH CLOCK ENABLE 
//              AND ACTIVE LOW ASYNCHRONOUS SET AND RESET

 table
//D      CLK     R   S   CE   NOTIFIER      Q(t)    Q(t+1)
       
  1      (01)    1   ?   1       ?       :   ?   :   1;  // clocked data
  0      (01)    ?   1   1       ?       :   ?   :   0;  // clocked data

  1       ?      1   *   1       ?       :   1   :   1;  // pessimism
  ?       0      1   *   1       ?       :   1   :   1;  // pessimism
  ?       1      1   *   1       ?       :   1   :   1;  // pessimism

  0       ?      *   1   1       ?       :   0   :   0;  // pessimism
  ?       0      *   1   1       ?       :   0   :   0;  // pessimism
  ?       1      *   1   1       ?       :   0   :   0;  // pessimism

  1       p      1   1   1       ?       :   1   :   1;  // reducing pessimism
  0       p      1   1   1       ?       :   0   :   0;
 
  ?       ?      0   1   ?       ?       :   ?   :   0;  // asynchronous clear
  ?       ?      1   0   ?       ?       :   ?   :   1;  // asynchronous set

//  ?      (?0)    ?   ?   1       ?       :   ?   :   -;  // ignore falling clock
//  0      (?x)    ?   ?   1       ?       :   0   :   -;  // retain state when D == Qt
//  1      (?x)    ?   ?   1       ?       :   1   :   -;  // retain state when D == Qt
//  *       1      ?   ?   1       ?       :   ?   :   -;  // ignore data edges
//  *       0      ?   ?   1       ?       :   ?   :   -;  // ignore data edges

  ?      (?0)    ?   ?   ?       ?       :   ?   :   -;  // ignore falling clock
  0      (?x)    ?   ?   ?       ?       :   0   :   -;  // retain state when D == Qt
  1      (?x)    ?   ?   ?       ?       :   1   :   -;  // retain state when D == Qt
  *       1      ?   ?   ?       ?       :   ?   :   -;  // ignore data edges
  *       0      ?   ?   ?       ?       :   ?   :   -;  // ignore data edges

  ?       ?      1   1   0       ?       :   ?   :   -;
  ?	  ?      ?   ?   ?       *       :   ?   :   -;
  ?       ?      1   1   *       ?       :   ?   :   -; 
endtable
endprimitive
primitive  MACH_DFF_CE_X(Q,D,CLK,R,S,CE,NOTIFIER);
output Q;
reg Q;
input CLK, D, R,S, CE, NOTIFIER;  //clock enable active high

// FUNCTION : POSITIVE EDGE TRIGGERED D-FLIP FLOP WITH ACTIVE HIGH CLOCK ENABLE 
//              AND ACTIVE LOW ASYNCHRONOUS SET AND RESET

 table
//D      CLK     R   S   CE   NOTIFIER Q(t)    Q(t+1)
       
  1      (01)    1   ?   1      ?:   ?   :   1;  // clocked data
  0      (01)    ?   1   1      ?:   ?   :   0;  // clocked data

  1       ?      1   *   1      ?:   1   :   1;  // pessimism
  ?       0      1   *   1      ?:   1   :   1;  // pessimism
  ?       1      1   *   1      ?:   1   :   1;  // pessimism

  
  0       ?      *   1   1      ?:   0   :   0;  // pessimism
  ?       0      *   1   1      ?:   0   :   0;  // pessimism
  ?       1      *   1   1      ?:   0   :   0;  // pessimism

  1       p      1   1   1      ?:   1   :   1;  // reducing pessimism
  0       p      1   1   1      ?:   0   :   0;
 
  ?       ?      0   1   ?      ?:   ?   :   0;  // asynchronous clear
  ?       ?      1   0   ?      ?:   ?   :   1;  // asynchronous set

//  ?      (?0)    ?   ?   1       ?       :   ?   :   -;  // ignore falling clock
//  0      (?x)    ?   ?   1       ?       :   0   :   -;  // retain state when D == Qt
//  1      (?x)    ?   ?   1       ?       :   1   :   -;  // retain state when D == Qt
//  *       1      ?   ?   1       ?       :   ?   :   -;  // ignore data edges
//  *       0      ?   ?   1       ?       :   ?   :   -;  // ignore data edges

  ?      (?0)    ?   ?   ?       ?       :   ?   :   -;  // ignore falling clock
  0      (?x)    ?   ?   ?       ?       :   0   :   -;  // retain state when D == Qt
  1      (?x)    ?   ?   ?       ?       :   1   :   -;  // retain state when D == Qt
  *       1      ?   ?   ?       ?       :   ?   :   -;  // ignore data edges
  *       0      ?   ?   ?       ?       :   ?   :   -;  // ignore data edges

  ?       ?      1   1   0       ?       :   ?   :   -;
  ?       ?      ?   ?   ?       *       :   ?   :   x;
  ?       ?      1   1   *       ?       :   ?   :   -; 
 
endtable
endprimitive
primitive  MACH_DFF_X (Q,D,CLK,R,S,NOTIFIER);
output Q;
reg Q;
input D, CLK, R,S, NOTIFIER;

// FUNCTION : POSITIVE EDGE TRIGGERED D-FLIP FLOP WITH ACTIVE LOW 
//              ASYNCHRONOUS SET AND CLEAR
 table
//D      CLK     R   S   NOTIFIER      Q(t)    Q(t+1)
       
  1      (01)    1   ?      ?       :   ?   :   1;  // clocked data
  0      (01)    ?   1      ?       :   ?   :   0;  // clocked data

  1       ?      1   *      ?       :   1   :   1;  // pessimism
  ?       0      1   *      ?       :   1   :   1;  // pessimism
  ?       1      1   *      ?       :   1   :   1;  // pessimism
  1       ?      0   *      ?       :   0   :   0;  // pessimism
  ?       0      0   *      ?       :   0   :   0;  // pessimism
  ?       1      0   *      ?       :   0   :   0;  // pessimism

  0       ?      *   1      ?       :   0   :   0;  // pessimism
  ?       0      *   1      ?       :   0   :   0;  // pessimism
  ?       1      *   1      ?       :   0   :   0;  // pessimism
  0       ?      *   0      ?       :   1   :   1;  // pessimism
  ?       0      *   0      ?       :   1   :   1;  // pessimism
  ?       1      *   0      ?       :   1   :   1;  // pessimism

  1       p      1   1      ?       :   1   :   1;  // reducing pessimism
  0       p      1   1      ?       :   0   :   0;
 
  ?       ?      0   1      ?       :   ?   :   0;  // asynchronous clear
  ?       ?      1   0      ?       :   ?   :   1;  // asynchronous set

  ?      (?0)    ?   ?      ?       :   ?   :   -;  // ignore falling clock
  0      (?x)    ?   ?      ?       :   0   :   -;  // retain state when D == Qt
  1      (?x)    ?   ?      ?       :   1   :   -;  // retain state when D == Qt
  *       1      ?   ?      ?       :   ?   :   -;  // ignore data edges
  *       0      ?   ?      ?       :   ?   :   -;  // ignore data edges
  ?       ?      ?   ?      *       :   ?   :   x;
 
endtable
endprimitive
primitive MACH_JKFF(Q,CLK,J,K,S,R,NOTIFIER);
output Q;
reg Q;
input CLK,  //clock input
      J,K,  // FF inputs
      S,R,  // Reset,Set inputs
      NOTIFIER;

 //POSITIVE EDGE TRIGGERED JK-FLIP FLOP WITH ACTIVE LOW ASYNCHRONOUS SET AND CLEAR

table

// CLK  J   K   S   R  NOTIFIER   Q(t)   Q(t+1) 
    ?   ?   ?   0   1     ?       : ? :    1;
    ?   ?   ?   *   1     ?       : 1 :    1; // Reset logic
    ?   ?   ?   1   0     ?       : ? :    0;
    ?   ?   ?   1   *     ?       : 0 :    0;
                                       // normal clocking cases
    r   0   0   1   1     ?       : ? :    -;
    r   0   1   1   1     ?       : ? :    0;
    r   1   0   1   1     ?       : ? :    1;
    r   1   1   1   1     ?       : 1 :    0;
    r   1   1   1   1     ?       : 0 :    1;
    f   ?   ?   ?   ?     ?       : ? :    - ;   
                                   // J K transition cases
    b   *   ?   ?   ?     ?       : ? :    -;
    b   ?   *   ?   ?     ?       : ? :    -;
                                    // cases reducing pessimism
    p   0   0   1   1     ?       : ? :    -;
    p   0   ?   1   ?     ?       : 0 :    -;
    p   ?   0   ?   1     ?       : 1 :    -;
   (x0) ?   ?   ?   ?     ?       : ? :    -;
   (1x) 0   0   1   1     ?       : ? :    -;
   (1x) 0   ?   1   ?     ?       : 0 :    -;
   (1x) ?   0   ?   1     ?       : 1 :    -;
     x  *   0   ?   1     ?       : 1 :    -;
     x  0   *   1   ?     ?       : 0 :    -;
     ?  ?   ?   ?   ?     *       : ? :    -;

endtable
endprimitive 
   
primitive MACH_JKFF_X(Q,CLK,J,K,S,R,NOTIFIER);
output Q;
reg Q;
input CLK,  //clock input
      J,K,  // FF inputs
      S,R,  // Reset,Set inputs
      NOTIFIER;

 //POSITIVE EDGE TRIGGERED JK-FLIP FLOP WITH ACTIVE LOW ASYNCHRONOUS SET AND CLEAR

table

// CLK  J   K   S   R  NOTIFIER   Q(t)   Q(t+1) 
    ?   ?   ?   0   1     ?       : ? :    1;
    ?   ?   ?   *   1     ?       : 1 :    1; // Reset logic
    ?   ?   ?   1   0     ?       : ? :    0;
    ?   ?   ?   1   *     ?       : 0 :    0;
                                       // normal clocking cases
    r   0   0   1   1     ?       : ? :    -;
    r   0   1   1   1     ?       : ? :    0;
    r   1   0   1   1     ?       : ? :    1;
    r   1   1   1   1     ?       : 1 :    0;
    r   1   1   1   1     ?       : 0 :    1;
    f   ?   ?   ?   ?     ?       : ? :    - ;   
                                   // J K transition cases
    b   *   ?   ?   ?     ?       : ? :    -;
    b   ?   *   ?   ?     ?       : ? :    -;
                                    // cases reducing pessimism
    p   0   0   1   1     ?       : ? :    -;
    p   0   ?   1   ?     ?       : 0 :    -;
    p   ?   0   ?   1     ?       : 1 :    -;
   (x0) ?   ?   ?   ?     ?       : ? :    -;
   (1x) 0   0   1   1     ?       : ? :    -;
   (1x) 0   ?   1   ?     ?       : 0 :    -;
   (1x) ?   0   ?   1     ?       : 1 :    -;
     x  *   0   ?   1     ?       : 1 :    -;
     x  0   *   1   ?     ?       : 0 :    -;
     ?  ?   ?   ?   ?     *       : ? :    x;  
endtable
endprimitive 
   
primitive MACH_LATCH(Q,D,LAT,R,S,NOTIFIER);
output Q;
reg Q;
input D,                                     // D input
      LAT,                                   //  Clock input
      R,S,                                   //   Active Low RESET and SET
      NOTIFIER;

// FUNCTION : POSITIVE LEVEL SENSITIVE D-TYPE LATCH WITH ACTIVE LOW ASYNCHRONOUS
//            RESET AND SET. (Q OUTPUT UDP)
table
//  D  LAT   R   S    NOTIFIER  :Q(t) :  Q(t+1)
    *   0    1   1      ?       :  ?  :  -  ;
    ?   ?    0   1      ?       :  ?  :  0  ;
    ?   ?    1   0      ?       :  ?  :  1  ;
    ?  (?0)  1   1      ?       :  ?  :  -  ;
    ?  (1x)  1   1      ?       :  ?  :  -  ;
    0  (x1)  ?   1      ?       :  ?  :  0  ;
    1  (x1)  1   ?      ?       :  ?  :  1  ;
    0  (0x)  1   1      ?       :  0  :  0  ;
    1  (0x)  1   1      ?       :  1  :  1  ;
  (?0)  1    ?   1      ?       :  ?  :  0  ;
  (?1)  1    1   ?      ?       :  ?  :  1  ;
    0  (01)  ?   1      ?       :  ?  :  0  ;
    1  (01)  1   ?      ?       :  ?  :  1  ;
    ?   0    1  (?1)    ?       :  ?  :  -  ; // ignore edge on SE
    ?   0   (?1) 1      ?       :  ?  :  -  ; // ignore edge on RE
    0   1    ?  (?1)    ?       :  ?  :  0  ;
    1   1   (?1) ?      ?       :  ?  :  1  ;
    1   1    1  (?1)    ?       :  ?  :  1  ;
    0   1   (?1) 1      ?       :  ?  :  0  ;
   (?1) x    1   ?      ?       :  1  :  1  ;
   (?0) x    ?   1      ?       :  0  :  0  ;
    ?   ?    ?   ?      *       :  ?  :  -  ;

endtable
 
endprimitive
primitive MACH_LATCH_X(Q,D,LAT,R,S,NOTIFIER);
output Q;
reg Q;
input D,                                     // D input
      LAT,                                   //  Clock input
      R,S,                                   //   Active Low RESET and SET
      NOTIFIER;

// FUNCTION : POSITIVE LEVEL SENSITIVE D-TYPE LATCH WITH ACTIVE LOW ASYNCHRONOUS
//            RESET AND SET. (Q OUTPUT UDP)
table
//  D  LAT   R   S    NOTIFIER  :Q(t) :  Q(t+1)
    *   0    1   1      ?       :  ?  :  -  ;
    ?   ?    0   1      ?       :  ?  :  0  ;
    ?   ?    1   0      ?       :  ?  :  1  ;
    ?  (?0)  1   1      ?       :  ?  :  -  ;
    ?  (1x)  1   1      ?       :  ?  :  -  ;
    0  (x1)  ?   1      ?       :  ?  :  0  ;
    1  (x1)  1   ?      ?       :  ?  :  1  ;
    0  (0x)  1   1      ?       :  0  :  0  ;
    1  (0x)  1   1      ?       :  1  :  1  ;
  (?0)  1    ?   1      ?       :  ?  :  0  ;
  (?1)  1    1   ?      ?       :  ?  :  1  ;
    0  (01)  ?   1      ?       :  ?  :  0  ;
    1  (01)  1   ?      ?       :  ?  :  1  ;
    ?   0    1  (?1)    ?       :  ?  :  -  ; // ignore edge on SE
    ?   0   (?1) 1      ?       :  ?  :  -  ; // ignore edge on RE
    0   1    ?  (?1)    ?       :  ?  :  0  ;
    1   1   (?1) ?      ?       :  ?  :  1  ;
    1   1    1  (?1)    ?       :  ?  :  1  ;
    0   1   (?1) 1      ?       :  ?  :  0  ;
   (?1) x    1   ?      ?       :  1  :  1  ;
   (?0) x    ?   1      ?       :  0  :  0  ;
    ?   ?    ?   ?      *       :  ?  :  x  ;
endtable
 
endprimitive
primitive MACH_RSFF(Q,CLK,RE,SE,S,R,NOTIFIER);
output Q;
reg Q;
input CLK,  //clock input
      RE,SE,  // FF inputs
      S,R,  // Reset,Set inputs
      NOTIFIER;

 //POSITIVE EDGE TRIGGERED SR-FLIP FLOP WITH ACTIVE LOW ASYNCHRONOUS SET AND CLEAR

table

// CLK  RE  SE  S   R  NOTIFIER   Q(t)   Q(t+1) 
                                         // Set logic
    ?   ?   ?   0   1     ?       : ? :    1;
    ?   ?   ?   *   1     ?       : 1 :    1;
                                        // Reset logic
    ?   ?   ?   1   0     ?       : ? :    0;
    ?   ?   ?   1   *     ?       : 0 :    0;
                                       // normal clocking cases
    r   0   0   1   1     ?       : ? :    -;
    r   0   1   1   1     ?       : ? :    1;
    r   1   0   1   1     ?       : ? :    0;
    f   ?   ?   ?   ?     ?       : ? :    - ;   
                                   // S R transition cases

                                    // cases reducing pessimism
    p   0   0   1   1     ?       : ? :    -;
    p   1   1   1   ?     ?       : 0 :    x;
//  p   ?   1   ?   1     ?       : 1 :    x;
   (x0) ?   ?   ?   ?     ?       : ? :    -;
   (1x) 0   0   1   1     ?       : ? :    -;
   (1x) 0   ?   1   ?     ?       : 0 :    -;
   (1x) ?   0   ?   1     ?       : 1 :    -;
     x  *   0   ?   1     ?       : 1 :    -;
     x  0   *   1   ?     ?       : 0 :    -;
     ?  ?   ?   ?   ?     *	  : ? :    -;
     ?  *   ?   1   1     ?       : ? :    -;
     ?  ?   *   1   1     ?       : ? :    -;

endtable
endprimitive 
primitive MACH_RSFF_X(Q,CLK,RE,SE,S,R,NOTIFIER);
output Q;
reg Q;
input CLK,  //clock input
      RE,SE,  // FF inputs
      S,R,  // Reset,Set inputs
      NOTIFIER;

 //POSITIVE EDGE TRIGGERED SR-FLIP FLOP WITH ACTIVE LOW ASYNCHRONOUS SET AND CLEAR

table

// CLK  RE  SE  S   R  NOTIFIER   Q(t)   Q(t+1) 
                                         // Set logic
    ?   ?   ?   0   1     ?       : ? :    1;
//  ?   ?   ? (?1)   1     ?      : ? :    -;
    ?   1   1 (?1)   1     ?      : ? :    x;
//  ?   ?   ?   *   1     ?       : 1 :    1;
                                        // Reset logic
    ?   ?   ?   1   0     ?       : ? :    0;
//  ?   ?   ?   1   *     ?       : 0 :    0;
//  ?   ?   ?   1 (?1)    ?       : ? :    -;
    ?   1   1   1 (?1)    ?       : ? :    x;
                                       // normal clocking cases
    r   0   0   1   1     ?       : ? :    -;
    r   0   1   1   1     ?       : ? :    1;
    r   1   0   1   1     ?       : ? :    0;
    f   ?   ?   ?   ?     ?       : ? :    - ;   
                                   // S R transition cases
                                    // cases reducing pessimism
    p   0   0   1   1     ?       : ? :    -;
    p   1   1   1   ?     ?       : 0 :    x;
//  p   ?   1   ?   1     ?       : 1 :    -;
   (x0) ?   ?   ?   ?     ?       : ? :    -;
   (1x) 0   0   1   1     ?       : ? :    -;
   (1x) 0   ?   1   ?     ?       : 0 :    -;
   (1x) ?   0   ?   1     ?       : 1 :    -;
     x  *   0   ?   1     ?       : 1 :    -;
     x  0   *   1   ?     ?       : 0 :    -;
     ?  ?   ?   ?   ?     *       : ? :    x;
     ?  *   ?   1   1     ?       : ? :    -;
     ?  ?   *   1   1     ?       : ? :    -;
endtable
endprimitive 
primitive MACH_TFF(Q,CLK,T,S,R,NOTIFIER);
output Q;
reg Q;
input CLK,  //clock input
      T,  // FF inputs
      S,R,  // Reset,Set inputs
      NOTIFIER;


table

// CLK  T      S   R  NOTIFIER   Q(t)   Q(t+1) 
                                         // Set logic
    ?   ?      0   1     ?       : ? :    1;
    ?   ?      *   1     ?       : 1 :    1;
                                        // Reset logic
    ?   ?      1   0     ?       : ? :    0;
    ?   ?      1   *     ?       : 0 :    0;
                                       // normal clocking cases
    r   0      1   1     ?       : ? :    -;
    r   1      1   1     ?       : 1 :    0;
    r   1      1   1     ?       : 0 :    1;
    f   ?      ?   ?     ?       : ? :    - ;   
                                   // T  transition cases
    b   *      ?   ?     ?       : ? :    -;
                                    // cases reducing pessimism
    p   0      1   1     ?       : ? :    -;
    p   0      1   ?     ?       : 0 :    -;
    p   0      ?   1     ?       : 1 :    -;
   (x0) ?      ?   ?     ?       : ? :    -;
   (1x) 0      1   1     ?       : ? :    -;
   (1x) ?      ?   1     ?       : 1 :    -;
     x  0      1   ?     ?       : 0 :    -;
     ?  ?      ?   ?     *       : ? :    -;

endtable
endprimitive 
primitive MACH_TFF_X(Q,CLK,T,S,R,NOTIFIER);
output Q;
reg Q;
input CLK,  //clock input
      T,  // FF inputs
      S,R,  // Reset,Set inputs
      NOTIFIER;


table

// CLK  T      S   R  NOTIFIER   Q(t)   Q(t+1) 
                                         // Set logic
    ?   ?      0   1     ?       : ? :    1;
    ?   ?      *   1     ?       : 1 :    1;
                                        // Reset logic
    ?   ?      1   0     ?       : ? :    0;
    ?   ?      1   *     ?       : 0 :    0;
                                       // normal clocking cases
    r   0      1   1     ?       : ? :    -;
    r   1      1   1     ?       : 1 :    0;
    r   1      1   1     ?       : 0 :    1;
    f   ?      ?   ?     ?       : ? :    - ;   
                                   // T  transition cases
    b   *      ?   ?     ?       : ? :    -;
                                    // cases reducing pessimism
    p   0      1   1     ?       : ? :    -;
    p   0      1   ?     ?       : 0 :    -;
    p   0      ?   1     ?       : 1 :    -;
   (x0) ?      ?   ?     ?       : ? :    -;
   (1x) 0      1   1     ?       : ? :    -;
   (1x) ?      ?   1     ?       : 1 :    -;
     x  0      1   ?     ?       : 0 :    -;
     ?  ?      ?   ?     *       : ? :    x;
endtable
endprimitive 
`celldefine

`timescale 1ns / 100ps
module SC_BRAM_16K (WEA,REA,WEB,REB,WADA,WDA,RADA,RDA,WADB,WDB,RADB,RDB);

	parameter  DEVICE_FAMILY = "SuperCool";
	parameter  MEM_INIT_FILE = "";
	parameter  MEM_INIT_FLAG = 0;
//	parameter  ADDR_WIDTH = 13; // 8K
//	parameter  DATA_WIDTH = 2;  // 2 bits

	parameter  WADDR_WIDTH_A = 14;
	parameter  RADDR_WIDTH_A = 12;
        parameter  WADDR_WIDTH_B = 14;
        parameter  RADDR_WIDTH_B = 12;
        parameter  WDATA_WIDTH_A = 1;
        parameter  RDATA_WIDTH_A = 4;
        parameter  WDATA_WIDTH_B = 1;
        parameter  RDATA_WIDTH_B = 4;
        parameter  ARRAY_SIZE = 262144;

	input WEA,REA,WEB,REB;
	input [WADDR_WIDTH_A -1:0] WADA;
	input [WDATA_WIDTH_A -1:0] WDA ;
	input [RADDR_WIDTH_A -1:0] RADA;
	output [RDATA_WIDTH_A -1:0] RDA ;
	input [WADDR_WIDTH_B -1:0] WADB;
	input [WDATA_WIDTH_B -1:0] WDB ;
	input [RADDR_WIDTH_B -1:0] RADB;
	output [RDATA_WIDTH_B -1:0] RDB ;

	wire WEA_node,REA_node,WEB_node,REB_node;
	wire [WADDR_WIDTH_A -1:0] WADA_node;
	wire [WDATA_WIDTH_A -1:0] WDA_node;
	wire [RADDR_WIDTH_A -1:0] RADA_node;
	reg  [RDATA_WIDTH_A -1:0] RDA_node;

	wire [WADDR_WIDTH_B -1:0] WADB_node;
	wire [WDATA_WIDTH_B -1:0] WDB_node;
	wire [RADDR_WIDTH_B -1:0] RADB_node;
	reg  [RDATA_WIDTH_B -1:0] RDB_node;

	assign  WADA_node = WADA;
	assign  WEA_node  = WEA;
	assign  WDA_node  = WDA;
	assign  RADA_node = RADA;
	assign  REA_node  = REA;
	assign  RDA       = RDA_node;
	 
	assign  WADB_node = WADB;
	assign  WEB_node  = WEB;
	assign  WDB_node  = WDB;
	assign  RADB_node = RADB;
	assign  REB_node  = REB;
	assign  RDB       = RDB_node;

	integer v_MEM[ARRAY_SIZE - 1:0];
	integer v_WADDR_A,v_RADDR_A,v_WADDR_B,v_RADDR_B;
	integer i,flag,flag1[3:0],j;
	integer bitval;
	reg [WDATA_WIDTH_A-1:0] VMEMTEMP[0:ARRAY_SIZE/WDATA_WIDTH_A-1];
	

	initial	begin
		for ( i = 0; i < RDATA_WIDTH_A ;i=i+1 )
			RDA_node[i] = 'bx;
		for ( i = 0; i < RDATA_WIDTH_B ;i=i+1 )
			RDB_node[i] = 'bx;
		for ( i = 0;i < ARRAY_SIZE ; i=i+1 )
			v_MEM[i] = 0;

		if( MEM_INIT_FLAG == 1 )
		begin
			for ( i = 0 ; i < ARRAY_SIZE/WDATA_WIDTH_A; i = i + 1)
				VMEMTEMP[i] = 'b0;

			$readmemb(MEM_INIT_FILE,VMEMTEMP);  //,0,ARRAY_SIZE/WDATA_WIDTH_A-1);
			for ( i = 0; i < ARRAY_SIZE/WDATA_WIDTH_A; i = i + 1)
				for ( j = 0; j < WDATA_WIDTH_A; j = j + 1)
				begin
					bitval = (1'b1 << j);			
					v_MEM[i*WDATA_WIDTH_A+j] = (VMEMTEMP[i] & bitval)>>j;
				end
		end
	end
		
	always @(WADA_node or WEA_node or WDA_node or RADA_node or REA_node or WADB_node or WEB_node or WDB_node or RADB_node or REB_node)
	begin
		v_WADDR_A = WADA_node;
		v_WADDR_B = WADB_node;	
		v_RADDR_A = RADA_node;	
		v_RADDR_B = RADB_node;	

		flag = 0;

		if(v_WADDR_A * WDATA_WIDTH_A == v_WADDR_B * WDATA_WIDTH_B)
			flag = 1;
		else if(WDATA_WIDTH_A > WDATA_WIDTH_B && 
                        (v_WADDR_A + 1) * WDATA_WIDTH_A > v_WADDR_B * WDATA_WIDTH_B &&
			v_WADDR_A * WDATA_WIDTH_A <= v_WADDR_B * WDATA_WIDTH_B) 
			flag = 2;
		else if(WDATA_WIDTH_B > WDATA_WIDTH_A &&
                        (v_WADDR_B + 1) * WDATA_WIDTH_B > v_WADDR_A * WDATA_WIDTH_A &&
			v_WADDR_B * WDATA_WIDTH_B <= v_WADDR_A * WDATA_WIDTH_A)
			flag = 3;
			

		if (flag != 0 && WEA_node == 1 && WEB_node == 1)
		   begin
			$display ("\nsimulation time: ",$time);
			$display ("Write collision. Writing in the cross memory location using Port A and Port B will cause the memory content invalid.");
			$stop;
		   end

		for ( i = 0; i < 4 ; i = i + 1 )
			flag1[i] = 0;
		
		if (^WADA_node === 1'bx ) // if there is 'x' or 'z' in the bit of the bus.
			begin
//				$display ("\nsimulation time: ",$time);
//				$display ("Write address of port A is invalid.");
				flag1[0] = 1;
			end
		if (^WADB_node === 1'bx )
			begin
//				$display ("\nsimulation time: ",$time);
//				$display ("Write address of port B is invalid.");
				flag1[1] = 2;
			end
		if (^RADA_node === 1'bx )
			begin
				if (REA_node != 1)
					for ( i = 0; i < RDATA_WIDTH_A; i=i+1 )
						RDA_node[i] = 'bx;	
//				$display ("\nRead address of port A is invalid.");
				flag1[2] = 3;
			end
		if (^RADB_node === 1'bx )
			begin
				if (REB_node != 1)
					for ( i = 0; i < RDATA_WIDTH_B; i=i+1 )
						RDB_node[i] = 'bx;	
//				$display ("\nRead address of port B is invalid.");
				flag1[3] = 4;
			end


		if (WEA_node == 1)
			begin: signal1
				if(flag1[0] == 1)
					disable signal1;
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Write to port A...");
				$display ("Writing address from %d -- %d",v_WADDR_A*WDATA_WIDTH_A,(v_WADDR_A+1)*WDATA_WIDTH_A-1);
`endif
				if (v_WADDR_A*WDATA_WIDTH_A > ARRAY_SIZE - 1)
					begin
						$display ("Fatal Error. Write address A exceeds the array boundary ");
						$stop;
					end

				for ( i = 0; i < WDATA_WIDTH_A; i=i+1 )
					begin
						v_MEM[v_WADDR_A*WDATA_WIDTH_A+i] = WDA_node[i];
`ifdef debug
						$display ("Write address is  %d",v_WADDR_A*WDATA_WIDTH_A+i);
						$display ("WDA_node[%d] = %b",i,WDA_node[i]);
`endif
					end
			end
`ifdef debug
		else
			begin
				$display ("\nsimulation time: ",$time);
				$display ("Write port A disabled");
			end
`endif

		if (WEB_node == 1)
			begin: signal2
				if(flag1[1] == 2)
					disable signal2;
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Write to port B...");
				$display ("Writing address from %d -- %d",v_WADDR_B*WDATA_WIDTH_B,(v_WADDR_B+1)*WDATA_WIDTH_B-1);
`endif
				if (v_WADDR_B*WDATA_WIDTH_B > ARRAY_SIZE - 1)
					begin
						$display ("Fatal Error. Write address B exceeds the array boundary ");
						$stop;
					end

				for ( i = 0; i < WDATA_WIDTH_B; i=i+1 )
					begin
						v_MEM[v_WADDR_B*WDATA_WIDTH_B+i] = WDB_node[i];
`ifdef debug
						$display ("Write address is  %d",v_WADDR_B*WDATA_WIDTH_B+i);
						$display ("WDB_node[%d] = %b",i,WDB_node[i]);
`endif
					end
		end
`ifdef debug
		else
			begin
				$display ("\nsimulation time: ",$time);
				$display ("Write port B disabled");
			end
`endif

		if (REA_node == 1)
			begin: signal3
				if(flag1[2] == 3)
					disable signal3;
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Read port A...");
				$display ("Reading address from %d -- %d",v_RADDR_A*RDATA_WIDTH_A,(v_RADDR_A+1)*RDATA_WIDTH_A-1);
`endif

				if (v_RADDR_A*RDATA_WIDTH_A > ARRAY_SIZE - 1)
					begin
						$display ("Fatal Error. Read address A exceeds the array boundary ");
						$stop;
					end

				for ( i = 0; i < RDATA_WIDTH_A; i=i+1 )
					begin
						RDA_node[i] = v_MEM[v_RADDR_A*RDATA_WIDTH_A+i];		
`ifdef debug
						$display ("Read address is %d",v_RADDR_A*RDATA_WIDTH_A+i);
						$display ("RDA_node[%d] = %b",i,RDA_node[i]);
`endif
					end
			end
		else
			begin
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Read Port A disabled.");
				$display ("Reading address from %d -- %d",v_RADDR_B*RDATA_WIDTH_B,(v_RADDR_B+1)*RDATA_WIDTH_B-1);
`endif
		//		for ( i = 0; i < RDATA_WIDTH_A; i=i+1 )
		//			RDA_node[i] = 'bx;	
			end


		if (REB_node == 1)
			begin: signal4
				if(flag1[3] == 4)
					disable signal4;
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Read port B...");
`endif

				if (v_RADDR_B*RDATA_WIDTH_B > ARRAY_SIZE - 1)
					begin
						$display ("Fatal Error. Read address B exceeds the array boundary ");
						$stop;
					end

				for ( i = 0; i < RDATA_WIDTH_B; i=i+1 )
					begin
					RDB_node[i] = v_MEM[v_RADDR_B*RDATA_WIDTH_B+i];		
`ifdef debug
						$display ("Read address is %d",v_RADDR_B*RDATA_WIDTH_B+i);
						$display ("RDB_node[%d] = %b",i,RDB_node[i]);
`endif
					end
			end
		else
			begin
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Read Port B disabled.");
`endif


	//			for ( i = 0; i < RDATA_WIDTH_B; i=i+1 )
	//				RDB_node[i] = 'bx;
			end
						
	end

endmodule


`endcelldefine

`celldefine

`celldefine

`timescale 1ns / 100ps
   module SC_BRAM_16K_SYNC (WCLK,RCLK,WEA,REA,WEB,REB,WADA,WDA,RADA,RDA,
                            WADB,WDB,RADB,RDB);

   parameter  DEVICE_FAMILY = "SuperCool";
   parameter  MEM_INIT_FLAG = "";
   parameter  MEM_INIT_FILE = 0;

   parameter  WADDR_WIDTH_A = 14;
   parameter  RADDR_WIDTH_A = 12;
   parameter  WADDR_WIDTH_B = 14;
   parameter  RADDR_WIDTH_B = 12;
   parameter  WDATA_WIDTH_A = 1;
   parameter  RDATA_WIDTH_A = 4;
   parameter  WDATA_WIDTH_B = 1;
   parameter  RDATA_WIDTH_B = 4;
   parameter  ARRAY_SIZE = 262144;

   input      WEA,REA,WEB,REB;
   input      WCLK, RCLK;
   
   input [WADDR_WIDTH_A -1:0] WADA;
   input [WDATA_WIDTH_A -1:0] WDA ;
   input [RADDR_WIDTH_A -1:0] RADA;
   output [RDATA_WIDTH_A -1:0] RDA ;
   input [WADDR_WIDTH_B -1:0]  WADB;
   input [WDATA_WIDTH_B -1:0]  WDB ;
   input [RADDR_WIDTH_B -1:0]  RADB;
   output [RDATA_WIDTH_B -1:0] RDB ;

   wire                        WEA_node,REA_node,WEB_node,REB_node;
   wire [WADDR_WIDTH_A -1:0]   WADA_node;
   wire [WDATA_WIDTH_A -1:0]   WDA_node;
   wire [RADDR_WIDTH_A -1:0]   RADA_node;
   reg [RDATA_WIDTH_A -1:0]    RDA_node;

   wire [WADDR_WIDTH_B -1:0]   WADB_node;
   wire [WDATA_WIDTH_B -1:0]   WDB_node;
   wire [RADDR_WIDTH_B -1:0]   RADB_node;
   reg [RDATA_WIDTH_B -1:0]    RDB_node;

   assign                      WADA_node = WADA;
   assign                      WEA_node  = WEA;
   assign                      WDA_node  = WDA;
   assign                      RADA_node = RADA;
   assign                      REA_node  = REA;
   assign                      RDA       = RDA_node;
   
   assign                      WADB_node = WADB;
   assign                      WEB_node  = WEB;
   assign                      WDB_node  = WDB;
   assign                      RADB_node = RADB;
   assign                      REB_node  = REB;
   assign                      RDB       = RDB_node;

   integer                     v_WADDR_A,v_RADDR_A,v_WADDR_B,v_RADDR_B;
   integer                     loopCount1,flag,flag1[3:0],loopCount2;
   integer                     bitval;
   // Allocate enough memory to hold the contents of the incoming FIFO
   // data.
   reg                         v_MEM[ARRAY_SIZE*WDATA_WIDTH_A - 1:0];
   reg [WDATA_WIDTH_A-1:0]     VMEMTEMP[0:ARRAY_SIZE-1];
   
   // Mimic the power on initial state of the RAM
   initial begin
      // Clear all of the A side read addresses to 'x'
      for ( loopCount1 =0; loopCount1 < RDATA_WIDTH_A ;
            loopCount1=loopCount1+1 )
         RDA_node[loopCount1] = 'bx;
      // Clear all of the B side read addresses to 'x'
      for ( loopCount1 =0; loopCount1 < RDATA_WIDTH_B ;
            loopCount1=loopCount1+1 )
         RDB_node[loopCount1] = 'bx;
      // Clear the memory cells to '0'
      for ( loopCount1 =0;loopCount1 < ARRAY_SIZE ;
            loopCount1=loopCount1+1 )
         v_MEM[loopCount1] = 0;

      // The user has requested the memory be filled with a
      // specific pattern.  Initialize that data here.
      if( MEM_INIT_FLAG == 1 )
         begin
            for ( loopCount1 =0 ; loopCount1 < ARRAY_SIZE/WDATA_WIDTH_A; 
                  loopCount1 = loopCount1 + 1)
               VMEMTEMP[loopCount1] = 'b0;

            // Read the data contained in the MEM_INIT_FILE into
            // VMEMTEMP.  VMEMTEMP is used just long enough to capture
            // the information in the file.  Implicitly read the whole
            // file contents.
            $readmemb(MEM_INIT_FILE,VMEMTEMP);

            // Iterate over each bit read into VMEMTEMP from the
            // initialization file, and store it into the v_MEM array
            // which is the store actually accessed during normal operation.
            for ( loopCount1 = 0; loopCount1 < ARRAY_SIZE; 
                  loopCount1 = loopCount1 + 1)
               for ( loopCount2 = 0; loopCount2 < WDATA_WIDTH_A; 
                     loopCount2 = loopCount2 + 1)
                  begin
//                   bitval = (1'b1 << loopCount2);                   
                     v_MEM[loopCount1*WDATA_WIDTH_A+loopCount2] = 
                           (VMEMTEMP[loopCount1] >>loopCount2) & 1'b1;

//                         (VMEMTEMP[loopCount1] & bitval)>>loopCount2;
                  end
         end
   end
   
   always @(posedge(WCLK))
      begin
         v_WADDR_A = WADA_node;
         v_WADDR_B = WADB_node;  

         flag = 0;

         if((v_WADDR_A * WDATA_WIDTH_A <= v_WADDR_B * WDATA_WIDTH_B) &&
            ((v_WADDR_A+1) * WDATA_WIDTH_A >= (v_WADDR_B+1) * WDATA_WIDTH_B))
            flag = 1;
         else if ((v_WADDR_B * WDATA_WIDTH_B <= v_WADDR_A * WDATA_WIDTH_A) &&
                  ((v_WADDR_B+1) * WDATA_WIDTH_B >= (v_WADDR_A+1) * WDATA_WIDTH_A))
            flag = 1;
         else if ((v_WADDR_A * WDATA_WIDTH_A <= v_WADDR_B * WDATA_WIDTH_B) &&
                  ((v_WADDR_B+1) * WDATA_WIDTH_B >= (v_WADDR_A+1) * WDATA_WIDTH_A) &&
                  ((v_WADDR_A+1) * WDATA_WIDTH_A >= v_WADDR_B * WDATA_WIDTH_B))
            flag = 1;
         else if ((v_WADDR_B * WDATA_WIDTH_B <= v_WADDR_A * WDATA_WIDTH_A) &&
                  ((v_WADDR_A+1) * WDATA_WIDTH_A >= (v_WADDR_B+1) * WDATA_WIDTH_B) &&
                  ((v_WADDR_B+1) * WDATA_WIDTH_B >= v_WADDR_A * WDATA_WIDTH_A))
            flag = 1;
         

         if (flag != 0 && WEA_node == 1 && WEB_node == 1)
            begin
               $display ("\nsimulation time: ",$time);
               $display ("Write collision. Writing in the cross memory location using Port A and Port B will cause the memory content invalid.");
               $stop;
            end

         for ( loopCount1 = 0; loopCount1 < 4 ; loopCount1 = loopCount1 + 1 )
            flag1[loopCount1] = 0;
         
         // Check to see if there is 'x' or 'z' on the bus.
         if (^WADA_node === 1'bx )
            begin
               flag1[0] = 1;
            end
         if (^WADB_node === 1'bx )
            begin
               flag1[1] = 2;
            end

         if (WEA_node == 1)
            begin: signal1
               if(flag1[0] == 1)
                  disable signal1;
`ifdef debug
               $display ("\nsimulation time: ",$time);
               $display ("Write to port A...");
               $display ("Writing address from %d -- %d",v_WADDR_A*WDATA_WIDTH_A,(v_WADDR_A+1)*WDATA_WIDTH_A-1);
`endif
               if (v_WADDR_A*WDATA_WIDTH_A >  (ARRAY_SIZE * WDATA_WIDTH_A) -1)
                  begin
                     $display ("Fatal Error. Write address A exceeds the array boundary ");
                     $stop;
                  end

               for ( loopCount1 =0; loopCount1 < WDATA_WIDTH_A; 
                     loopCount1=loopCount1+1 )
                  begin
                     v_MEM[v_WADDR_A*WDATA_WIDTH_A+loopCount1] =
                          WDA_node[loopCount1];
`ifdef debug
                     $display ("Write address is  %d",v_WADDR_A*WDATA_WIDTH_A+
                               loopCount1);
                     $display ("WDA_node[%d] = %b",loopCount1,
                               WDA_node[loopCount1]);
`endif
                  end
            end
`ifdef debug
         else
            begin
               $display ("\nsimulation time: ",$time);
               $display ("Write port A disabled");
            end
`endif

         if (WEB_node == 1)
            begin: signal2
               if(flag1[1] == 2)
                  disable signal2;
`ifdef debug
               $display ("\nsimulation time: ",$time);
               $display ("Write to port B...");
               $display ("Writing address from %d -- %d",v_WADDR_B*
                         WDATA_WIDTH_B,(v_WADDR_B+1)*WDATA_WIDTH_B-1);
`endif
               if (v_WADDR_B*WDATA_WIDTH_B > (ARRAY_SIZE * WDATA_WIDTH_B) -1)
                  begin
                     $display ("Fatal Error. Write address B exceeds the array boundary ");
                     $stop;
                  end

               for ( loopCount1 = 0; loopCount1 < WDATA_WIDTH_B; 
                     loopCount1=loopCount1+1 )
                  begin
                     v_MEM[v_WADDR_B*WDATA_WIDTH_B+loopCount1] = 
                          WDB_node[loopCount1];
`ifdef debug
                     $display ("Write address is  %d",v_WADDR_B*WDATA_WIDTH_B+
                               loopCount1);
                     $display ("WDB_node[%d] = %b",loopCount1,
                               WDB_node[loopCount1]);
`endif
                  end
            end
`ifdef debug
         else
            begin
               $display ("\nsimulation time: ",$time);
               $display ("Write port B disabled");
            end
`endif

      end // always @ (posedge(WCLK))
   

   always @(posedge(RCLK))
      begin

         v_RADDR_A = RADA_node;  
         v_RADDR_B = RADB_node;  


         if (^RADA_node === 1'bx )
            begin
               if (REA_node != 1)
                  for ( loopCount1 = 0; loopCount1 < RDATA_WIDTH_A;
                        loopCount1=loopCount1+1 )
                     RDA_node[loopCount1] = 'bx;      
               flag1[2] = 3;
            end
         if (^RADB_node === 1'bx )
            begin
               if (REB_node != 1)
                  for ( loopCount1 = 0; loopCount1 < RDATA_WIDTH_B;
                        loopCount1=loopCount1+1 )
                     RDB_node[loopCount1] = 'bx;      
               flag1[3] = 4;
            end

         if (REA_node == 1)
            begin: signal3
               if(flag1[2] == 3)
                  disable signal3;
`ifdef debug
               $display ("\nsimulation time: ",$time);
               $display ("Read port A...");
               $display ("Reading address from %d -- %d",v_RADDR_A*
                         RDATA_WIDTH_A,(v_RADDR_A+1)*RDATA_WIDTH_A-1);
`endif
               for ( loopCount1 = 0; loopCount1 < RDATA_WIDTH_A;
                     loopCount1=loopCount1+1 )
                  begin
                     RDA_node[loopCount1] <= v_MEM[v_RADDR_A*RDATA_WIDTH_A+
                                                  loopCount1];
`ifdef debug
                     $display ("Read address is %d",v_RADDR_A*RDATA_WIDTH_A+
                               loopCount1);
                     $display ("RDA_node[%d] = %b",loopCount1,
                               RDA_node[loopCount1]);
`endif
                  end
            end
         else
            begin
`ifdef debug
               $display ("\nsimulation time: ",$time);
               $display ("Read Port A disabled.");
               $display ("Reading address from %d -- %d",v_RADDR_B*
                         RDATA_WIDTH_B,(v_RADDR_B+1)*RDATA_WIDTH_B-1);
`endif
            end


         if (REB_node == 1)
            begin: signal4
               if(flag1[3] == 4)
                  disable signal4;
`ifdef debug
               $display ("\nsimulation time: ",$time);
               $display ("Read port B...");
`endif
               if (v_RADDR_B*RDATA_WIDTH_B > (ARRAY_SIZE * WDATA_WIDTH_B) -1)
                  begin
                     $display ("Fatal Error. Read address A exceeds the array boundary ");
                     $stop;
                  end

               for ( loopCount1 = 0; loopCount1 < RDATA_WIDTH_B;
                     loopCount1=loopCount1+1 )
                  begin
                     RDB_node[loopCount1] <= v_MEM[v_RADDR_B*RDATA_WIDTH_B+
                                                  loopCount1];         
`ifdef debug
                     $display ("Read address is %d",v_RADDR_B*RDATA_WIDTH_B+
                               loopCount1);
                     $display ("RDB_node[%d] = %b",loopCount1,
                               RDB_node[loopCount1]);
`endif
                  end
            end
         else
            begin
`ifdef debug
               $display ("\nsimulation time: ",$time);
               $display ("Read Port B disabled.");
`endif
               if (v_RADDR_B*RDATA_WIDTH_B > (ARRAY_SIZE * WDATA_WIDTH_B) -1)
                  begin
                     $display ("Fatal Error. Read address A exceeds the array boundary ");
                     $stop;
                  end

            end // else: !if(REB_node == 1)
      end // always @ (posedge(RCLK))

endmodule

`endcelldefine
`endcelldefine

`celldefine

`timescale 1ns / 100ps
module SC_BRAM_PDP_16K (WEA,REA,WEB,REB,WADA,WDA,RADA,RDA,WADB,WDB,RADB,RDB);

	parameter  DEVICE_FAMILY = "SuperCool";
	parameter  MEM_INIT_FILE = "";
	parameter  MEM_INIT_FLAG = 0;
//	parameter  ADDR_WIDTH = 13; // 8K
//	parameter  DATA_WIDTH = 2;  // 2 bits

	parameter  WADDR_WIDTH_A = 14;
	parameter  RADDR_WIDTH_A = 12;
        parameter  WADDR_WIDTH_B = 14;
        parameter  RADDR_WIDTH_B = 12;
        parameter  WDATA_WIDTH_A = 1;
        parameter  RDATA_WIDTH_A = 4;
        parameter  WDATA_WIDTH_B = 1;
        parameter  RDATA_WIDTH_B = 4;
        parameter  ARRAY_SIZE = 262144;

	input WEA,REA,WEB,REB;
	input [WADDR_WIDTH_A -1:0] WADA;
	input [WDATA_WIDTH_A -1:0] WDA ;
	input [RADDR_WIDTH_A -1:0] RADA;
	output [RDATA_WIDTH_A -1:0] RDA ;
	input [WADDR_WIDTH_B -1:0] WADB;
	input [WDATA_WIDTH_B -1:0] WDB ;
	input [RADDR_WIDTH_B -1:0] RADB;
	output [RDATA_WIDTH_B -1:0] RDB ;

	wire WEA_node,REA_node,WEB_node,REB_node;
	wire [WADDR_WIDTH_A -1:0] WADA_node;
	wire [WDATA_WIDTH_A -1:0] WDA_node;
	wire [RADDR_WIDTH_A -1:0] RADA_node;
	reg  [RDATA_WIDTH_A -1:0] RDA_node;

	wire [WADDR_WIDTH_B -1:0] WADB_node;
	wire [WDATA_WIDTH_B -1:0] WDB_node;
	wire [RADDR_WIDTH_B -1:0] RADB_node;
	reg  [RDATA_WIDTH_B -1:0] RDB_node;

	assign  WADA_node = WADA;
	assign  WEA_node  = WEA;
	assign  WDA_node  = WDA;
	assign  RADA_node = RADA;
	assign  REA_node  = REA;
	assign  RDA       = RDA_node;
	 
	assign  WADB_node = WADB;
	assign  WEB_node  = WEB;
	assign  WDB_node  = WDB;
	assign  RADB_node = RADB;
	assign  REB_node  = REB;
	assign  RDB       = RDB_node;

	integer v_MEM[ARRAY_SIZE - 1:0];
	integer v_WADDR_A,v_RADDR_A,v_WADDR_B,v_RADDR_B;
	integer i,flag,flag1[3:0],j;
	integer bitval;
	reg [RDATA_WIDTH_A-1:0] VMEMTEMP[0:ARRAY_SIZE/RDATA_WIDTH_A-1];
	

	initial	begin
		for ( i = 0; i < RDATA_WIDTH_A ;i=i+1 )
			RDA_node[i] = 'bx;
		for ( i = 0; i < RDATA_WIDTH_B ;i=i+1 )
			RDB_node[i] = 'bx;
		for ( i = 0;i < ARRAY_SIZE ; i=i+1 )
			v_MEM[i] = 0;

		if( MEM_INIT_FLAG == 1 )
		begin
			for ( i = 0 ; i < ARRAY_SIZE/RDATA_WIDTH_A; i = i + 1)
				VMEMTEMP[i] = 'b0;

			$readmemb(MEM_INIT_FILE,VMEMTEMP);         //,0,ARRAY_SIZE/RDATA_WIDTH_A-1);
			for ( i = 0; i < ARRAY_SIZE/RDATA_WIDTH_A; i = i + 1)
				for ( j = 0; j < RDATA_WIDTH_A; j = j + 1)
				begin
					bitval = (1'b1 << j);			
					v_MEM[i*RDATA_WIDTH_A+j] = (VMEMTEMP[i] & bitval)>>j;
				end
		end
	end
		
	always @(WADA_node or WEA_node or WDA_node or RADA_node or REA_node or WADB_node or WEB_node or WDB_node or RADB_node or REB_node)
	begin
		v_WADDR_A = WADA_node;
		v_WADDR_B = WADB_node;	
		v_RADDR_A = RADA_node;	
		v_RADDR_B = RADB_node;	

		flag = 0;

		if(v_WADDR_A * WDATA_WIDTH_A <= v_WADDR_B * WDATA_WIDTH_B &&
			(v_WADDR_A+1) * WDATA_WIDTH_A >= (v_WADDR_B+1) * WDATA_WIDTH_B)
			flag = 1;
		else if (v_WADDR_B * WDATA_WIDTH_B <= v_WADDR_A * WDATA_WIDTH_A &&
			(v_WADDR_B+1) * WDATA_WIDTH_B >= (v_WADDR_A+1) * WDATA_WIDTH_A)
			flag = 2;
		else if (v_WADDR_A * WDATA_WIDTH_A <= v_WADDR_B * WDATA_WIDTH_B &&
			(v_WADDR_B+1) * WDATA_WIDTH_B >= (v_WADDR_A+1) * WDATA_WIDTH_A &&
			(v_WADDR_A+1) * WDATA_WIDTH_A >= v_WADDR_B * WDATA_WIDTH_B)
			flag = 3;
		else if (v_WADDR_B * WDATA_WIDTH_B <= v_WADDR_A * WDATA_WIDTH_A &&
			(v_WADDR_A+1) * WDATA_WIDTH_A >= (v_WADDR_B+1) * WDATA_WIDTH_B &&
			(v_WADDR_B+1) * WDATA_WIDTH_B >= v_WADDR_A * WDATA_WIDTH_A)
			flag = 4;
			

		if (flag != 0 && WEA_node == 1 && WEB_node == 1)
		   begin
			$display ("\nsimulation time: ",$time);
			$display ("Write collision. Writing in the cross memory location using Port A and Port B will cause the memory content invalid.");
			$stop;
		   end

		for ( i = 0; i < 4 ; i = i + 1 )
			flag1[i] = 0;
		
		if (^WADA_node === 1'bx ) // if there is 'x' or 'z' in the bit of the bus.
			begin
//				$display ("\nsimulation time: ",$time);
//				$display ("Write address of port A is invalid.");
				flag1[0] = 1;
			end
		if (^WADB_node === 1'bx )
			begin
//				$display ("\nsimulation time: ",$time);
//				$display ("Write address of port B is invalid.");
				flag1[1] = 2;
			end
		if (^RADA_node === 1'bx )
			begin
				if (REA_node != 1)
					for ( i = 0; i < RDATA_WIDTH_A; i=i+1 )
						RDA_node[i] = 'bx;	
//				$display ("\nRead address of port A is invalid.");
				flag1[2] = 3;
			end
		if (^RADB_node === 1'bx )
			begin
				if (REB_node != 1)
					for ( i = 0; i < RDATA_WIDTH_B; i=i+1 )
						RDB_node[i] = 'bx;	
//				$display ("\nRead address of port B is invalid.");
				flag1[3] = 4;
			end

		if (WEA_node == 1)
			begin: signal1
				if(flag1[0] == 1)
					disable signal1;
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Write to port A...");
				$display ("Writing address from %d -- %d",v_WADDR_A*WDATA_WIDTH_A,(v_WADDR_A+1)*WDATA_WIDTH_A-1);
`endif
				if (v_WADDR_A*WDATA_WIDTH_A > ARRAY_SIZE - 1)
					begin
						$display ("Fatal Error. Write address A exceeds the array boundary ");
						$stop;
					end

				for ( i = 0; i < WDATA_WIDTH_A; i=i+1 )
					begin
						v_MEM[v_WADDR_A*WDATA_WIDTH_A+i] = WDA_node[i];
`ifdef debug
						$display ("Write address is  %d",v_WADDR_A*WDATA_WIDTH_A+i);
						$display ("WDA_node[%d] = %b",i,WDA_node[i]);
`endif
					end
			end
`ifdef debug
		else
			begin
				$display ("\nsimulation time: ",$time);
				$display ("Write port A disabled");
			end
`endif

		if (WEB_node == 1)
			begin: signal2
				if(flag1[1] == 2)
					disable signal2;
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Write to port B...");
				$display ("Writing address from %d -- %d",v_WADDR_B*WDATA_WIDTH_B,(v_WADDR_B+1)*WDATA_WIDTH_B-1);
`endif
				if (v_WADDR_B*WDATA_WIDTH_B > ARRAY_SIZE - 1)
					begin
						$display ("Fatal Error. Write address B exceeds the array boundary ");
						$stop;
					end

				for ( i = 0; i < WDATA_WIDTH_B; i=i+1 )
					begin
						v_MEM[v_WADDR_B*WDATA_WIDTH_B+i] = WDB_node[i];
`ifdef debug
						$display ("Write address is  %d",v_WADDR_B*WDATA_WIDTH_B+i);
						$display ("WDB_node[%d] = %b",i,WDB_node[i]);
`endif
					end
		end
`ifdef debug
		else
			begin
				$display ("\nsimulation time: ",$time);
				$display ("Write port B disabled");
			end
`endif

		if (REA_node == 1)
			begin: signal3
				if(flag1[2] == 3)
					disable signal3;
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Read port A...");
				$display ("Reading address from %d -- %d",v_RADDR_A*RDATA_WIDTH_A,(v_RADDR_A+1)*RDATA_WIDTH_A-1);
`endif

				if (v_RADDR_A*RDATA_WIDTH_A > ARRAY_SIZE - 1)
					begin
						$display ("Fatal Error. Read address A exceeds the array boundary ");
						$stop;
					end

				for ( i = 0; i < RDATA_WIDTH_A; i=i+1 )
					begin
						RDA_node[i] = v_MEM[v_RADDR_A*RDATA_WIDTH_A+i];		
`ifdef debug
						$display ("Read address is %d",v_RADDR_A*RDATA_WIDTH_A+i);
						$display ("RDA_node[%d] = %b",i,RDA_node[i]);
`endif
					end
			end
		else
			begin
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Read Port A disabled.");
				$display ("Reading address from %d -- %d",v_RADDR_B*RDATA_WIDTH_B,(v_RADDR_B+1)*RDATA_WIDTH_B-1);
`endif
		//		for ( i = 0; i < RDATA_WIDTH_A; i=i+1 )
		//			RDA_node[i] = 'bx;	
			end


		if (REB_node == 1)
			begin: signal4
				if(flag1[3] == 4)
					disable signal4;
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Read port B...");
`endif

				if (v_RADDR_B*RDATA_WIDTH_B > ARRAY_SIZE - 1)
					begin
						$display ("Fatal Error. Read address B exceeds the array boundary ");
						$stop;
					end

				for ( i = 0; i < RDATA_WIDTH_B; i=i+1 )
					begin
					RDB_node[i] = v_MEM[v_RADDR_B*RDATA_WIDTH_B+i];		
`ifdef debug
						$display ("Read address is %d",v_RADDR_B*RDATA_WIDTH_B+i);
						$display ("RDB_node[%d] = %b",i,RDB_node[i]);
`endif
					end
			end
		else
			begin
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Read Port B disabled.");
`endif


	//			for ( i = 0; i < RDATA_WIDTH_B; i=i+1 )
	//				RDB_node[i] = 'bx;
			end
						
	end


endmodule


`endcelldefine

`celldefine

`timescale 1ns / 100ps
module SC_BRAM_16K_L (WEA,REA,WEB,REB,WADA,WDA,RADA,RDA,WADB,WDB,RADB,RDB);

	parameter  DEVICE_FAMILY = "SuperCool";
	parameter  MEM_INIT_FILE = "";
	parameter  MEM_INIT_FLAG = 0;
//	parameter  ADDR_WIDTH = 13; // 8K
//	parameter  DATA_WIDTH = 2;  // 2 bits

	parameter  WADDR_WIDTH_A = 14;
	parameter  RADDR_WIDTH_A = 12;
        parameter  WADDR_WIDTH_B = 14;
        parameter  RADDR_WIDTH_B = 12;
        parameter  WDATA_WIDTH_A = 1;
        parameter  RDATA_WIDTH_A = 4;
        parameter  WDATA_WIDTH_B = 1;
        parameter  RDATA_WIDTH_B = 4;
        parameter  ARRAY_SIZE = 262144;

	input WEA,REA,WEB,REB;
	input [WADDR_WIDTH_A -1:0] WADA;
	input [WDATA_WIDTH_A -1:0] WDA ;
	input [RADDR_WIDTH_A -1:0] RADA;
	output [RDATA_WIDTH_A -1:0] RDA ;
	input [WADDR_WIDTH_B -1:0] WADB;
	input [WDATA_WIDTH_B -1:0] WDB ;
	input [RADDR_WIDTH_B -1:0] RADB;
	output [RDATA_WIDTH_B -1:0] RDB ;

	wire WEA_node,REA_node,WEB_node,REB_node;
	wire [WADDR_WIDTH_A -1:0] WADA_node;
	wire [WDATA_WIDTH_A -1:0] WDA_node;
	wire [RADDR_WIDTH_A -1:0] RADA_node;
	reg  [RDATA_WIDTH_A -1:0] RDA_node;

	wire [WADDR_WIDTH_B -1:0] WADB_node;
	wire [WDATA_WIDTH_B -1:0] WDB_node;
	wire [RADDR_WIDTH_B -1:0] RADB_node;
	reg  [RDATA_WIDTH_B -1:0] RDB_node;

	assign  WADA_node = WADA;
	assign  WEA_node  = WEA;
	assign  WDA_node  = WDA;
	assign  RADA_node = RADA;
	assign  REA_node  = REA;
	assign  RDA       = RDA_node;
	 
	assign  WADB_node = WADB;
	assign  WEB_node  = WEB;
	assign  WDB_node  = WDB;
	assign  RADB_node = RADB;
	assign  REB_node  = REB;
	assign  RDB       = RDB_node;

//	integer v_MEM[ARRAY_SIZE - 1:0];
	integer v_MEM[ARRAY_SIZE*WDATA_WIDTH_A - 1:0];
	
	integer v_WADDR_A,v_RADDR_A,v_WADDR_B,v_RADDR_B;
	integer i,flag,flag1[3:0],j;
	integer bitval;
//	reg [WDATA_WIDTH_A-1:0] VMEMTEMP[0:ARRAY_SIZE/WDATA_WIDTH_A-1];
	reg [WDATA_WIDTH_A-1:0] VMEMTEMP[0:ARRAY_SIZE-1];
	

	initial	begin
		for ( i = 0; i < RDATA_WIDTH_A ;i=i+1 )
			RDA_node[i] = 'bx;
		for ( i = 0; i < RDATA_WIDTH_B ;i=i+1 )
			RDB_node[i] = 'bx;
		for ( i = 0;i < ARRAY_SIZE ; i=i+1 )
//			v_MEM[i] = 0;
			v_MEM[i] = 'b0;

		if( MEM_INIT_FLAG == 1 )
		begin
//			for ( i = 0 ; i < ARRAY_SIZE/WDATA_WIDTH_A; i = i + 1)
			for ( i = 0 ; i < ARRAY_SIZE; i = i + 1)
				VMEMTEMP[i] = 'b0;

//			$readmemb(MEM_INIT_FILE,VMEMTEMP,ARRAY_SIZE/WDATA_WIDTH_A-1,0);
			$readmemb(MEM_INIT_FILE,VMEMTEMP);                  //,0, ARRAY_SIZE-1);
//			for ( i = 0; i < ARRAY_SIZE/WDATA_WIDTH_A; i = i + 1)
			for ( i = 0; i < ARRAY_SIZE; i = i + 1)
				for ( j = 0; j < WDATA_WIDTH_A; j = j + 1)
				begin
					bitval = (1'b1 << j);			
					v_MEM[i*WDATA_WIDTH_A+j] = (VMEMTEMP[i] & bitval)>>j;
				end
		end
	end
		
	always @(WADA_node or WEA_node or WDA_node or RADA_node or REA_node or WADB_node or WEB_node or WDB_node or RADB_node or REB_node)
	begin
		v_WADDR_A = WADA_node;
		v_WADDR_B = WADB_node;	
		v_RADDR_A = RADA_node;	
		v_RADDR_B = RADB_node;	

		flag = 0;

		if(v_WADDR_A * WDATA_WIDTH_A == v_WADDR_B * WDATA_WIDTH_B)
			flag = 1;
		else if(WDATA_WIDTH_A > WDATA_WIDTH_B && 
                        (v_WADDR_A + 1) * WDATA_WIDTH_A > v_WADDR_B * WDATA_WIDTH_B &&
			v_WADDR_A * WDATA_WIDTH_A <= v_WADDR_B * WDATA_WIDTH_B) 
			flag = 2;
		else if(WDATA_WIDTH_B > WDATA_WIDTH_A &&
                        (v_WADDR_B + 1) * WDATA_WIDTH_B > v_WADDR_A * WDATA_WIDTH_A &&
			v_WADDR_B * WDATA_WIDTH_B <= v_WADDR_A * WDATA_WIDTH_A)
			flag = 3;
			

		if (flag != 0 && WEA_node == 1 && WEB_node == 1)
		   begin
			$display ("\nsimulation time: ",$time);
			$display ("Write collision. Writing in the cross memory location using Port A and Port B will cause the memory content invalid.");
			$stop;
		   end

		for ( i = 0; i < 4 ; i = i + 1 )
			flag1[i] = 0;
		
		if (^WADA_node === 1'bx ) // if there is 'x' or 'z' in the bit of the bus.
			begin
//				$display ("\nsimulation time: ",$time);
//				$display ("Write address of port A is invalid.");
				flag1[0] = 1;
			end
		if (^WADB_node === 1'bx )
			begin
//				$display ("\nsimulation time: ",$time);
//				$display ("Write address of port B is invalid.");
				flag1[1] = 2;
			end
		if (^RADA_node === 1'bx )
			begin
				if (REA_node != 1)
					for ( i = 0; i < RDATA_WIDTH_A; i=i+1 )
						RDA_node[i] = 'bx;	
//				$display ("\nRead address of port A is invalid.");
				flag1[2] = 3;
			end
		if (^RADB_node === 1'bx )
			begin
				if (REB_node != 1)
					for ( i = 0; i < RDATA_WIDTH_B; i=i+1 )
						RDB_node[i] = 'bx;	
//				$display ("\nRead address of port B is invalid.");
				flag1[3] = 4;
			end


		if (WEA_node == 1)
			begin: signal1
				if(flag1[0] == 1)
					disable signal1;
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Write to port A...");
				$display ("Writing address from %d -- %d",v_WADDR_A*WDATA_WIDTH_A,(v_WADDR_A+1)*WDATA_WIDTH_A-1);
`endif
//				if (v_WADDR_A*WDATA_WIDTH_A > ARRAY_SIZE - WDATA_WIDTH_A)
				if (v_WADDR_A*WDATA_WIDTH_A > ARRAY_SIZE*WDATA_WIDTH_A - WDATA_WIDTH_A)
					begin
						$display ("Fatal Error. Write address A exceeds the array boundary ");
						$stop;
					end

				for ( i = 0; i < WDATA_WIDTH_A; i=i+1 )
					begin
						v_MEM[v_WADDR_A*WDATA_WIDTH_A+i] = WDA_node[i];
`ifdef debug
						$display ("Write address is  %d",v_WADDR_A*WDATA_WIDTH_A+i);
						$display ("WDA_node[%d] = %b",i,WDA_node[i]);
`endif
					end
			end
`ifdef debug
		else
			begin
				$display ("\nsimulation time: ",$time);
				$display ("Write port A disabled");
			end
`endif

		if (WEB_node == 1)
			begin: signal2
				if(flag1[1] == 2)
					disable signal2;
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Write to port B...");
				$display ("Writing address from %d -- %d",v_WADDR_B*WDATA_WIDTH_B,(v_WADDR_B+1)*WDATA_WIDTH_B-1);
`endif
//				if (v_WADDR_B*WDATA_WIDTH_B > ARRAY_SIZE - WDATA_WIDTH_B)
				if (v_WADDR_B*WDATA_WIDTH_B > ARRAY_SIZE*WDATA_WIDTH_A - WDATA_WIDTH_B)
					begin
						$display ("Fatal Error. Write address B exceeds the array boundary ");
						$stop;
					end

				for ( i = 0; i < WDATA_WIDTH_B; i=i+1 )
					begin
						v_MEM[v_WADDR_B*WDATA_WIDTH_B+i] = WDB_node[i];
`ifdef debug
						$display ("Write address is  %d",v_WADDR_B*WDATA_WIDTH_B+i);
						$display ("WDB_node[%d] = %b",i,WDB_node[i]);
`endif
					end
		end
`ifdef debug
		else
			begin
				$display ("\nsimulation time: ",$time);
				$display ("Write port B disabled");
			end
`endif

		if (REA_node == 1)
			begin: signal3
				if(flag1[2] == 3)
					disable signal3;
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Read port A...");
				$display ("Reading address from %d -- %d",v_RADDR_A*RDATA_WIDTH_A,(v_RADDR_A+1)*RDATA_WIDTH_A-1);
`endif

//				if (v_RADDR_A*RDATA_WIDTH_A > ARRAY_SIZE - WDATA_WIDTH_A)
				if (v_RADDR_A*RDATA_WIDTH_A > ARRAY_SIZE*WDATA_WIDTH_A - WDATA_WIDTH_A)
					begin
						$display ("Fatal Error. Read address A exceeds the array boundary ");
						$stop;
					end

				for ( i = 0; i < RDATA_WIDTH_A; i=i+1 )
					begin
						RDA_node[i] = v_MEM[v_RADDR_A*RDATA_WIDTH_A+i];		
`ifdef debug
						$display ("Read address is %d",v_RADDR_A*RDATA_WIDTH_A+i);
						$display ("RDA_node[%d] = %b",i,RDA_node[i]);
`endif
					end
			end
		else
			begin
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Read Port A disabled.");
				$display ("Reading address from %d -- %d",v_RADDR_B*RDATA_WIDTH_B,(v_RADDR_B+1)*RDATA_WIDTH_B-1);
`endif
//				for ( i = 0; i < RDATA_WIDTH_A; i=i+1 )
//					RDA_node[i] = 'bx;	
			end


		if (REB_node == 1)
			begin: signal4
				if(flag1[3] == 4)
					disable signal4;
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Read port B...");
`endif

//				if (v_RADDR_B*RDATA_WIDTH_B > ARRAY_SIZE - WDATA_WIDTH_B)
				if (v_RADDR_B*RDATA_WIDTH_B > ARRAY_SIZE*WDATA_WIDTH_B - WDATA_WIDTH_B)
					begin
						$display ("Fatal Error. Read address B exceeds the array boundary ");
						$stop;
					end


				for ( i = 0; i < RDATA_WIDTH_B; i=i+1 )
					begin
					RDB_node[i] = v_MEM[v_RADDR_B*RDATA_WIDTH_B+i];		
`ifdef debug
						$display ("Read address is %d",v_RADDR_B*RDATA_WIDTH_B+i);
						$display ("RDB_node[%d] = %b",i,RDB_node[i]);
`endif
					end
			end
		else
			begin
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Read Port B disabled.");
`endif

//				for ( i = 0; i < RDATA_WIDTH_B; i=i+1 )
//					RDB_node[i] = 'bx;
			end
						
	end


endmodule


`endcelldefine

`celldefine

`timescale 1ns / 100ps
module SC_BRAM_PDP_16K_L (WEA,REA,WEB,REB,WADA,WDA,RADA,RDA,WADB,WDB,RADB,RDB);

	parameter  DEVICE_FAMILY = "SuperCool";
	parameter  MEM_INIT_FILE = "";
	parameter  MEM_INIT_FLAG = 0;

	parameter  WADDR_WIDTH_A = 14;
	parameter  RADDR_WIDTH_A = 12;
        parameter  WADDR_WIDTH_B = 14;
        parameter  RADDR_WIDTH_B = 12;
        parameter  WDATA_WIDTH_A = 1;
        parameter  RDATA_WIDTH_A = 4;
        parameter  WDATA_WIDTH_B = 1;
        parameter  RDATA_WIDTH_B = 4;
        parameter  ARRAY_SIZE = 262144;

	input WEA,REA,WEB,REB;
	input [WADDR_WIDTH_A -1:0] WADA;
	input [WDATA_WIDTH_A -1:0] WDA ;
	input [RADDR_WIDTH_A -1:0] RADA;
	output [RDATA_WIDTH_A -1:0] RDA ;
	input [WADDR_WIDTH_B -1:0] WADB;
	input [WDATA_WIDTH_B -1:0] WDB ;
	input [RADDR_WIDTH_B -1:0] RADB;
	output [RDATA_WIDTH_B -1:0] RDB ;

	wire WEA_node,REA_node,WEB_node,REB_node;
	wire [WADDR_WIDTH_A -1:0] WADA_node;
	wire [WDATA_WIDTH_A -1:0] WDA_node;
	wire [RADDR_WIDTH_A -1:0] RADA_node;
	reg  [RDATA_WIDTH_A -1:0] RDA_node;

	wire [WADDR_WIDTH_B -1:0] WADB_node;
	wire [WDATA_WIDTH_B -1:0] WDB_node;
	wire [RADDR_WIDTH_B -1:0] RADB_node;
	reg  [RDATA_WIDTH_B -1:0] RDB_node;

	assign  WADA_node = WADA;
	assign  WEA_node  = WEA;
	assign  WDA_node  = WDA;
	assign  RADA_node = RADA;
	assign  REA_node  = REA;
	assign  RDA       = RDA_node;
	 
	assign  WADB_node = WADB;
	assign  WEB_node  = WEB;
	assign  WDB_node  = WDB;
	assign  RADB_node = RADB;
	assign  REB_node  = REB;
	assign  RDB       = RDB_node;

	integer v_MEM[ARRAY_SIZE - 1:0];
	
	integer v_WADDR_A,v_RADDR_A,v_WADDR_B,v_RADDR_B;
	integer i,flag,flag1[3:0],j;
	integer bitval;
	reg [RDATA_WIDTH_A-1:0] VMEMTEMP[0:ARRAY_SIZE/RDATA_WIDTH_A-1];
	

	initial	begin
		for ( i = 0; i < RDATA_WIDTH_A ;i=i+1 )
			RDA_node[i] = 'bx;
		for ( i = 0; i < RDATA_WIDTH_B ;i=i+1 )
			RDB_node[i] = 'bx;
		for ( i = 0;i < ARRAY_SIZE ; i=i+1 )
			v_MEM[i] = 1'b0;

		if( MEM_INIT_FLAG == 1 )
		begin
			for ( i = 0 ; i < ARRAY_SIZE/WDATA_WIDTH_A; i = i + 1)
				VMEMTEMP[i] = 'b0;

			$readmemb(MEM_INIT_FILE,VMEMTEMP);
			for ( i = 0; i < ARRAY_SIZE/RDATA_WIDTH_A; i = i + 1)
				for ( j = 0; j < RDATA_WIDTH_A; j = j + 1)
				begin
					bitval = (1'b1 << j);			
					v_MEM[i*RDATA_WIDTH_A+j] = (VMEMTEMP[i] & bitval)>>j;
				end
		end
	end
		
	always @(WADA_node or WEA_node or WDA_node or RADA_node or REA_node or WADB_node or WEB_node or WDB_node or RADB_node or REB_node)
	begin
		v_WADDR_A = WADA_node;
		v_WADDR_B = WADB_node;	
		v_RADDR_A = RADA_node;	
		v_RADDR_B = RADB_node;	

		flag = 0;

		if(v_WADDR_A * WDATA_WIDTH_A <= v_WADDR_B * WDATA_WIDTH_B &&
			(v_WADDR_A+1) * WDATA_WIDTH_A >= (v_WADDR_B+1) * WDATA_WIDTH_B)
			flag = 1;
		else if (v_WADDR_B * WDATA_WIDTH_B <= v_WADDR_A * WDATA_WIDTH_A &&
			(v_WADDR_B+1) * WDATA_WIDTH_B >= (v_WADDR_A+1) * WDATA_WIDTH_A)
			flag = 2;
		else if (v_WADDR_A * WDATA_WIDTH_A <= v_WADDR_B * WDATA_WIDTH_B &&
			(v_WADDR_B+1) * WDATA_WIDTH_B >= (v_WADDR_A+1) * WDATA_WIDTH_A &&
			(v_WADDR_A+1) * WDATA_WIDTH_A >= v_WADDR_B * WDATA_WIDTH_B)
			flag = 3;
		else if (v_WADDR_B * WDATA_WIDTH_B <= v_WADDR_A * WDATA_WIDTH_A &&
			(v_WADDR_A+1) * WDATA_WIDTH_A >= (v_WADDR_B+1) * WDATA_WIDTH_B &&
			(v_WADDR_B+1) * WDATA_WIDTH_B >= v_WADDR_A * WDATA_WIDTH_A)
			flag = 4;
			

		if (flag != 0 && WEA_node == 1 && WEB_node == 1)
		   begin
			$display ("\nsimulation time: ",$time);
			$display ("Write collision. Writing in the cross memory location using Port A and Port B will cause the memory content invalid.");
			$stop;
		   end

		for ( i = 0; i < 4 ; i = i + 1 )
			flag1[i] = 0;
		
		if (^WADA_node === 1'bx ) // if there is 'x' or 'z' in the bit of the bus.
			begin
//				$display ("\nsimulation time: ",$time);
//				$display ("Write address of port A is invalid.");
				flag1[0] = 1;
			end
		if (^WADB_node === 1'bx )
			begin
//				$display ("\nsimulation time: ",$time);
//				$display ("Write address of port B is invalid.");
				flag1[1] = 2;
			end
		if (^RADA_node === 1'bx )
			begin
				if (REA_node != 1)
					for ( i = 0; i < RDATA_WIDTH_A; i=i+1 )
						RDA_node[i] = 'bx;	
//				$display ("\nRead address of port A is invalid.");
				flag1[2] = 3;
			end
		if (^RADB_node === 1'bx )
			begin
				if (REB_node != 1)
					for ( i = 0; i < RDATA_WIDTH_B; i=i+1 )
						RDB_node[i] = 'bx;	
//				$display ("\nRead address of port B is invalid.");
				flag1[3] = 4;
			end


		if (WEA_node == 1)
			begin: signal1
				if(flag1[0] == 1)
					disable signal1;
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Write to port A...");
				$display ("Writing address from %d -- %d",v_WADDR_A*WDATA_WIDTH_A,(v_WADDR_A+1)*WDATA_WIDTH_A-1);
`endif
				if (v_WADDR_A*WDATA_WIDTH_A > ARRAY_SIZE - 1)
					begin
						$display ("Fatal Error. Write address A exceeds the array boundary ");
						$stop;
					end

				for ( i = 0; i < WDATA_WIDTH_A; i=i+1 )
					begin
						v_MEM[v_WADDR_A*WDATA_WIDTH_A+i] = WDA_node[i];
`ifdef debug
						$display ("Write address is  %d",v_WADDR_A*WDATA_WIDTH_A+i);
						$display ("WDA_node[%d] = %b",i,WDA_node[i]);
`endif
					end
			end
`ifdef debug
		else
			begin
				$display ("\nsimulation time: ",$time);
				$display ("Write port A disabled");
			end
`endif

		if (WEB_node == 1)
			begin: signal2
				if(flag1[1] == 2)
					disable signal2;
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Write to port B...");
				$display ("Writing address from %d -- %d",v_WADDR_B*WDATA_WIDTH_B,(v_WADDR_B+1)*WDATA_WIDTH_B-1);
`endif
				if (v_WADDR_B*WDATA_WIDTH_B > ARRAY_SIZE - 1)
					begin
						$display ("Fatal Error. Write address B exceeds the array boundary ");
						$stop;
					end

				for ( i = 0; i < WDATA_WIDTH_B; i=i+1 )
					begin
						v_MEM[v_WADDR_B*WDATA_WIDTH_B+i] = WDB_node[i];
`ifdef debug
						$display ("Write address is  %d",v_WADDR_B*WDATA_WIDTH_B+i);
						$display ("WDB_node[%d] = %b",i,WDB_node[i]);
`endif
					end
		end
`ifdef debug
		else
			begin
				$display ("\nsimulation time: ",$time);
				$display ("Write port B disabled");
			end
`endif

		if (REA_node == 1)
			begin: signal3
				if(flag1[2] == 3)
					disable signal3;
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Read port A...");
				$display ("Reading address from %d -- %d",v_RADDR_A*RDATA_WIDTH_A,(v_RADDR_A+1)*RDATA_WIDTH_A-1);
`endif

				if (v_RADDR_A*RDATA_WIDTH_A > ARRAY_SIZE - 1)
					begin
						$display ("Fatal Error. Read address A exceeds the array boundary ");
						$stop;
					end

				for ( i = 0; i < RDATA_WIDTH_A; i=i+1 )
					begin
						RDA_node[i] = v_MEM[v_RADDR_A*RDATA_WIDTH_A+i];		
`ifdef debug
						$display ("Read address is %d",v_RADDR_A*RDATA_WIDTH_A+i);
						$display ("RDA_node[%d] = %b",i,RDA_node[i]);
`endif
					end
			end
		else
			begin
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Read Port A disabled.");
				$display ("Reading address from %d -- %d",v_RADDR_B*RDATA_WIDTH_B,(v_RADDR_B+1)*RDATA_WIDTH_B-1);
`endif
		//		for ( i = 0; i < RDATA_WIDTH_A; i=i+1 )
		//			RDA_node[i] = 'bx;	
			end


		if (REB_node == 1)
			begin: signal4
				if(flag1[3] == 4)
					disable signal4;
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Read port B...");
`endif

				if (v_RADDR_B*RDATA_WIDTH_B > ARRAY_SIZE - 1)
					begin
						$display ("Fatal Error. Read address B exceeds the array boundary ");
						$stop;
					end

				for ( i = 0; i < RDATA_WIDTH_B; i=i+1 )
					begin
					RDB_node[i] = v_MEM[v_RADDR_B*RDATA_WIDTH_B+i];		
`ifdef debug
						$display ("Read address is %d",v_RADDR_B*RDATA_WIDTH_B+i);
						$display ("RDB_node[%d] = %b",i,RDB_node[i]);
`endif
					end
			end
		else
			begin
`ifdef debug
				$display ("\nsimulation time: ",$time);
				$display ("Read Port B disabled.");
`endif


	//			for ( i = 0; i < RDATA_WIDTH_B; i=i+1 )
	//				RDB_node[i] = 'bx;
			end
						
	end
endmodule


`endcelldefine

`celldefine






`celldefine

`timescale 1ns / 100ps
module SC_BRAM_16K_L_SYNC (WCLK, RCLK, WEA,REA,WEB,REB,WADA,WDA,RADA,RDA,
                           WADB,WDB,RADB,RDB, RESET);

   parameter  DEVICE_FAMILY = "SuperCool";
   parameter  MEM_INIT_FLAG = "";
   parameter  MEM_INIT_FILE = 0;

   parameter  WADDR_WIDTH_A = 14;
   parameter  RADDR_WIDTH_A = 12;
   parameter  WADDR_WIDTH_B = 14;
   parameter  RADDR_WIDTH_B = 12;
   parameter  WDATA_WIDTH_A = 1;
   parameter  RDATA_WIDTH_A = 4;
   parameter  WDATA_WIDTH_B = 1;
   parameter  RDATA_WIDTH_B = 4;
   parameter  ARRAY_SIZE = 262144;

   input      WCLK, RCLK, RESET;
   input      WEA,REA,WEB,REB;
   input [WADDR_WIDTH_A -1:0] WADA;
   input [WDATA_WIDTH_A -1:0] WDA ;
   input [RADDR_WIDTH_A -1:0] RADA;
   output [RDATA_WIDTH_A -1:0] RDA ;
   input [WADDR_WIDTH_B -1:0]  WADB;
   input [WDATA_WIDTH_B -1:0]  WDB ;
   input [RADDR_WIDTH_B -1:0]  RADB;
   output [RDATA_WIDTH_B -1:0] RDB ;

   wire                        WEA_node,REA_node,WEB_node,REB_node;
   wire [WADDR_WIDTH_A -1:0]   WADA_node;
   wire [WDATA_WIDTH_A -1:0]   WDA_node;
   wire [RADDR_WIDTH_A -1:0]   RADA_node;
   reg [RDATA_WIDTH_A -1:0]    RDA_node;

   wire [WADDR_WIDTH_B -1:0]   WADB_node;
   wire [WDATA_WIDTH_B -1:0]   WDB_node;
   wire [RADDR_WIDTH_B -1:0]   RADB_node;
   reg [RDATA_WIDTH_B -1:0]    RDB_node;

   assign                      WADA_node = WADA;
   assign                      WEA_node  = WEA;
   assign                      WDA_node  = WDA;
   assign                      RADA_node = RADA;
   assign                      REA_node  = REA;
   assign                      RDA       = RDA_node;
   
   assign                      WADB_node = WADB;
   assign                      WEB_node  = WEB;
   assign                      WDB_node  = WDB;
   assign                      RADB_node = RADB;
   assign                      REB_node  = REB;
   assign                      RDB       = RDB_node;

   integer                     v_MEM[ARRAY_SIZE*WDATA_WIDTH_A - 1:0];
   
   integer                     v_WADDR_A,v_RADDR_A,v_WADDR_B,v_RADDR_B;
   integer                     wr_address_collision;
   integer                     flag1[3:0],loopCount1, loopCount2;
   integer                     bitval;

   reg [WDATA_WIDTH_A-1:0]     VMEMTEMP[0:ARRAY_SIZE-1];
   

   // Mimic the power on initial state of the RAM
   initial begin
      // Clear all of the A side read addresses to 'x'
      for ( loopCount1 = 0; loopCount1 < RDATA_WIDTH_A ;
            loopCount1=loopCount1+1)
         RDA_node[loopCount1] = 'bx;
      // Clear all of the B side read addresses to 'x'
      for ( loopCount1 = 0; loopCount1 < RDATA_WIDTH_B ;
            loopCount1=loopCount1+1)
         RDB_node[loopCount1] = 'bx;
      // Clear the memory cells to '0'
      for (loopCount1 = 0;loopCount1 < ARRAY_SIZE ;
           loopCount1=loopCount1+1)
         v_MEM[loopCount1] = 'b0;

      // The user has requested the memory be filled with a
      // specific pattern.  Initialize that data here.
      if( MEM_INIT_FLAG == 1 )
         begin
            for (loopCount1 = 0 ; loopCount1 < ARRAY_SIZE;
                 loopCount1=loopCount1+1)
               VMEMTEMP[loopCount1] = 'b0;

            $readmemb(MEM_INIT_FILE,VMEMTEMP,0, ARRAY_SIZE-1);
            for (loopCount1 = 0; loopCount1 < ARRAY_SIZE;
                 loopCount1=loopCount1+1)
               for (loopCount2 = 0; loopCount2 < WDATA_WIDTH_A;
                    loopCount2 = loopCount2 + 1)
                  begin
                     bitval = (1'b1 << loopCount2);                   
                     v_MEM[loopCount1*WDATA_WIDTH_A+loopCount2] = 
                          (VMEMTEMP[loopCount1] & bitval)>>loopCount2;
                  end
         end // if ( MEM_INIT_FLAG == 1 )
   end // initial begin
   
   always @(posedge(WCLK))
      begin
         v_WADDR_A = WADA_node;
         v_WADDR_B = WADB_node;  

         wr_address_collision = 0;

         if(v_WADDR_A * WDATA_WIDTH_A <= v_WADDR_B * WDATA_WIDTH_B &&
            (v_WADDR_A+1) * WDATA_WIDTH_A >= (v_WADDR_B+1) * WDATA_WIDTH_B)
            wr_address_collision = 1;
         else if (v_WADDR_B * WDATA_WIDTH_B <= v_WADDR_A * WDATA_WIDTH_A &&
                  (v_WADDR_B+1) * WDATA_WIDTH_B >= (v_WADDR_A+1) * WDATA_WIDTH_A)
            wr_address_collision = 1;
         else if (v_WADDR_A * WDATA_WIDTH_A <= v_WADDR_B * WDATA_WIDTH_B &&
                  (v_WADDR_B+1) * WDATA_WIDTH_B >= (v_WADDR_A+1) * WDATA_WIDTH_A &&
                  (v_WADDR_A+1) * WDATA_WIDTH_A >= v_WADDR_B * WDATA_WIDTH_B)
            wr_address_collision = 1;
         else if (v_WADDR_B * WDATA_WIDTH_B <= v_WADDR_A * WDATA_WIDTH_A &&
                  (v_WADDR_A+1) * WDATA_WIDTH_A >= (v_WADDR_B+1) * WDATA_WIDTH_B &&
                  (v_WADDR_B+1) * WDATA_WIDTH_B >= v_WADDR_A * WDATA_WIDTH_A)
            wr_address_collision = 1;
         
 
         if (wr_address_collision != 0 && WEA_node == 1 && WEB_node == 1)
            begin
               $display ("\nsimulation time: ",$time);
               $display ("Write collision. Writing in the cross memory location using Port A and Port B will cause the memory content invalid.");
               $stop;
            end

         for ( loopCount1 = 0; loopCount1 < 4 ; loopCount1=loopCount1+1 )
            flag1[loopCount1] = 0;
         
         // Check to see if there is 'x' or 'z' on the bus.
         if (^WADA_node === 1'bx )
            begin
               flag1[0] = 1;
            end
         if (^WADB_node === 1'bx )
            begin
               flag1[1] = 1;
            end


         if (WEA_node == 1)
            begin: signal1
               if(flag1[0] == 1)
                  disable signal1;
               if (v_WADDR_A*WDATA_WIDTH_A > ARRAY_SIZE*WDATA_WIDTH_A)
                  begin
                     $display ("Fatal Error. Write address A exceeds the array boundary ");
                     $stop;
                  end

               for (loopCount1 = 0; loopCount1 < WDATA_WIDTH_A; 
                    loopCount1=loopCount1+1 )
                  begin
                     v_MEM[v_WADDR_A*WDATA_WIDTH_A+loopCount1] = 
                          WDA_node[loopCount1];
                  end
            end

         if (WEB_node == 1)
            begin: signal2
               if(flag1[1] == 1)
                  disable signal2;

               if (v_WADDR_B*WDATA_WIDTH_B > ARRAY_SIZE*WDATA_WIDTH_B)
                  begin
                     $display ("Fatal Error. Write address B exceeds the array boundary ");
                     $stop;
                  end

               for (loopCount1 = 0; loopCount1 < WDATA_WIDTH_B;
                    loopCount1=loopCount1+1 )
                  begin
                     v_MEM[v_WADDR_B*WDATA_WIDTH_B+loopCount1] =
                          WDB_node[loopCount1];
                  end
            end // block: signal2
      end // always @ (posedge(WCLK))
   
   always @ (posedge(RCLK))
      begin
         v_RADDR_A = RADA_node;  
         v_RADDR_B = RADB_node;  
         if (^RADA_node === 1'bx)
            begin
               if (REA_node != 1)
                  for (loopCount1 = 0; loopCount1 < RDATA_WIDTH_A; 
                       loopCount1=loopCount1+1 )
                     RDA_node[loopCount1] = 'bx;      
               flag1[2] = 1;
            end
         if (^RADB_node === 1'bx )
            begin
               if (REB_node != 1)
                  for (loopCount1 = 0; loopCount1 < RDATA_WIDTH_B; 
                       loopCount1=loopCount1+1 )
                     RDB_node[loopCount1] = 'bx;      
               flag1[3] = 1;
            end


         if (REA_node == 1)
            begin: signal3
               if(flag1[2] == 1)
                  disable signal3;
               if (v_RADDR_A*RDATA_WIDTH_A > ARRAY_SIZE*WDATA_WIDTH_A
                   - WDATA_WIDTH_A)
                  begin
                     $display ("Fatal Error. Read address A exceeds the array boundary ");
                     $stop;
                  end
               for (loopCount1 = 0; loopCount1 < RDATA_WIDTH_A;
                    loopCount1=loopCount1+1 )
                  begin
                     RDA_node[loopCount1] <= 
                         v_MEM[v_RADDR_A*RDATA_WIDTH_A+loopCount1];
                  end
            end // block: signal3
        // else
        //    RDA_node <= 'bx;
   

         if (REB_node == 1)
            begin: signal4
               if(flag1[3] == 1)
                  disable signal4;

               if (v_RADDR_B*RDATA_WIDTH_B > ARRAY_SIZE*WDATA_WIDTH_A - WDATA_WIDTH_B)
                  begin
                     $display ("Fatal Error. Read address A exceeds the array boundary ");
                     $stop;
                  end
               for ( loopCount1 = 0; loopCount1 < RDATA_WIDTH_B; loopCount1=loopCount1+1 )
                  begin
                     RDB_node[loopCount1] <= 
                         v_MEM[v_RADDR_B*RDATA_WIDTH_B+loopCount1];
                  end
            end // block: signal4
      end // always @ (posedge(RCLK))

endmodule

`endcelldefine


`endcelldefine

`celldefine

module SC_CAM_16K (CE,WE,CLK,EN_MASK,WR_MASK,WR_DC,RST,CS,WAD,WD,CO,MATCH,MUL_MATCH);

	parameter DEVICE_FAMILY = "SuperCool";
	parameter  MEM_INIT_FILE = "";
	parameter  MEM_INIT_FLAG = 0;
	parameter ADDR_WIDTH = 7;
	parameter DATA_WIDTH = 48;

	input  CE;
	input  WE;
	input  CLK;
	input  EN_MASK;
	input  WR_MASK;
	input  WR_DC;
	input  RST;
	input  [1:0] CS;
	input  [ADDR_WIDTH -1:0] WAD;
	input  [DATA_WIDTH -1:0] WD;
	output [ADDR_WIDTH -1:0] CO;
	output MATCH;
	output MUL_MATCH;
	integer i;
	integer j;
	integer k;

// Input Nodes
	wire CE_node;
	wire WE_node;
	wire CLK_node;
	wire EN_MASK_node;
	wire WR_MASK_node;
	wire WR_DC_node;
	wire RST_node;
	wire [1:0] CS_node;
	wire [ADDR_WIDTH -1:0] WAD_node;
	wire [DATA_WIDTH -1:0] WD_node;

// Register Nodes
	reg EN_MASK_reg;
	reg [DATA_WIDTH -1:0] MASK_DATA_reg;
	reg [DATA_WIDTH -1:0] COMP_DATA_reg;
	reg [ADDR_WIDTH -1:0] WAD_reg;
	reg WEN_reg;
	reg WR_DC_reg;

// From WRITE_DATA_ENCODER to CAM Array
	reg [DATA_WIDTH -1:0] WRITE_DATA_node;

// From COMPARE_DATA_ENCODER to CAM Array
 	reg [DATA_WIDTH -1:0] COMPARE_DATA_node;

// From CAM Array to MATCH_FLAG_LOGIC/ CAM_OUTPUT_ENCODER
 	reg [(1<<ADDR_WIDTH) -1:0] UNEN_CAM_OUT_node;

// Output Nodes
 	reg [ADDR_WIDTH -1:0] CO_node;
 	reg  MATCH_node;
 	reg  MUL_MATCH_node;

	integer vADDR;
	integer vUNEN_CAM_OUT[(1<<ADDR_WIDTH) -1:0];
	integer vMEM[(1<<ADDR_WIDTH)*DATA_WIDTH -1:0];
	reg [DATA_WIDTH -1:0] vMEMTemp;
	reg [DATA_WIDTH -1:0] VMEMINITEMP[0:(1<<ADDR_WIDTH)-1];
	reg [DATA_WIDTH -1:0] vLINETEMP;
	reg [DATA_WIDTH -1:0] vLINECLR;


/************************************************************************
	 Architecture
************************************************************************/
	assign CE_node      = CE;
	assign WE_node      = WE;
	assign CLK_node     = CLK;
	assign EN_MASK_node = EN_MASK;
	assign WR_MASK_node = WR_MASK;
	assign WR_DC_node   = WR_DC;
	assign RST_node     = RST;
	assign CS_node      = CS;
	assign WAD_node     = WAD;
	assign WD_node      = WD;

	assign CO           = CO_node;
	assign MATCH        = MATCH_node;
	assign MUL_MATCH    = MUL_MATCH_node;

	always @(WR_DC_reg or COMP_DATA_reg or MASK_DATA_reg or EN_MASK_reg)
	begin
		WRITE_DATA_node = WRITE_DATA_ENCODER (WR_DC_reg, COMP_DATA_reg, MASK_DATA_reg, EN_MASK_reg);
	end

	always @(COMP_DATA_reg or MASK_DATA_reg or EN_MASK_reg)
	begin
		COMPARE_DATA_node = COMPARE_DATA_ENCODER (COMP_DATA_reg, MASK_DATA_reg, EN_MASK_reg);
	end
	
	always @(UNEN_CAM_OUT_node)
	begin
		MUL_MATCH_node = MUL_MATCH_FLAG (UNEN_CAM_OUT_node);
		MATCH_node     = MATCH_FLAG (UNEN_CAM_OUT_node);
		CO_node = OUTPUT_ENCODER(UNEN_CAM_OUT_node);
	end
	

	always @(RST_node)
		begin
			if(RST_node == 1)
				begin
					assign EN_MASK_reg = 'b0;
					assign COMP_DATA_reg = 'b0;
					assign WAD_reg = 'b0;
					assign WEN_reg = 'b0;
					assign WR_DC_reg = 'b0;
				end
			else
				begin
					deassign  EN_MASK_reg;
					deassign  COMP_DATA_reg;
					deassign  WAD_reg;
					deassign  WEN_reg;
					deassign  WR_DC_reg;
				end
		end

	always @(posedge CLK_node)
		begin
			if ( CE_node == 1)
				begin
					EN_MASK_reg   = EN_MASK_node;
					COMP_DATA_reg = WD_node;
					WAD_reg       = WAD_node;
					WEN_reg       = WE_node & CS_node[0] & CS_node[1];
					WR_DC_reg     = WR_DC_node;
					if (WR_MASK_node == 1)
						MASK_DATA_reg = WD_node;
				end
		end
	
	initial	begin
		for (i = 0 ; i < (1 << ADDR_WIDTH)  ; i = i + 1)
		begin
			vUNEN_CAM_OUT[i] = 0;
			for ( j = 0; j < DATA_WIDTH; j = j + 1 )
				vMEM[ i * DATA_WIDTH + j ] = 'bz;
		end

		if( MEM_INIT_FLAG == 1 )
		begin
			for ( i = 0 ; i < (1<<ADDR_WIDTH); i = i + 1)
				begin
					for ( k = 0; k < DATA_WIDTH; k = k + 1)
						vLINECLR[k] = 1'bz;
					VMEMINITEMP[i]= vLINECLR;
				end
			$readmemb(MEM_INIT_FILE,VMEMINITEMP,0,(1<<ADDR_WIDTH)-1);
			for ( i = 0; i < (1<<ADDR_WIDTH); i = i + 1)
 				for ( j = 0; j < DATA_WIDTH; j = j + 1)
				begin
					vLINETEMP = VMEMINITEMP[i];
					vMEM[i*DATA_WIDTH+j] = vLINETEMP[j];
				end
		end

	end
	
	always @(WEN_reg or WAD_reg or COMPARE_DATA_node or WRITE_DATA_node)
		begin

			vADDR = WAD_reg;

			if (WEN_reg == 1)
                            begin
				for ( i = 0; i < DATA_WIDTH; i = i + 1 )
					vMEM[ vADDR*DATA_WIDTH + i ] = WRITE_DATA_node[i];


				for (i = 0 ; i < (1 << ADDR_WIDTH)  ; i = i + 1)
					begin
						vUNEN_CAM_OUT[i] = 0;
						for ( j = 0; j < DATA_WIDTH; j = j + 1 )
							vMEMTemp[j] = vMEM[i * DATA_WIDTH + j];
						if (WORD_COMPARE(vMEMTemp, COMPARE_DATA_node) == 1)
								vUNEN_CAM_OUT[i] = 1;
						UNEN_CAM_OUT_node[i] = vUNEN_CAM_OUT[i];
					end
                            end

			else if (WEN_reg == 0)
				begin
					for (i = 0 ; i < (1 << ADDR_WIDTH)  ; i = i + 1)
						begin
							vUNEN_CAM_OUT[i] = 0;
							for ( j = 0; j < DATA_WIDTH; j = j + 1 )
								vMEMTemp[j] = vMEM[i * DATA_WIDTH + j];
							if (WORD_COMPARE(vMEMTemp, COMPARE_DATA_node) == 1)
								vUNEN_CAM_OUT[i] = 1;
							UNEN_CAM_OUT_node[i] = vUNEN_CAM_OUT[i];
						end
				end

		end



	function [DATA_WIDTH -1:0] WRITE_DATA_ENCODER;
		input WR_DONT_CARE;
		input [DATA_WIDTH -1:0] UPDATA_DATA;
		input [DATA_WIDTH -1:0] MASK_DATA;
		input EN_MASK_REG;
		integer i;

		begin
			if (EN_MASK_REG == 0)
			  WRITE_DATA_ENCODER = UPDATA_DATA;
			else if (EN_MASK_REG == 1)
			  for ( i = 0; i < DATA_WIDTH ; i = i + 1 )
			    if (MASK_DATA[i] == 0)
				WRITE_DATA_ENCODER[i] = UPDATA_DATA[i];
			    else if ( MASK_DATA[i] == 1 && WR_DONT_CARE == 1)
				WRITE_DATA_ENCODER[i] = 'bx;
		end
	endfunction

	function [DATA_WIDTH -1:0] COMPARE_DATA_ENCODER;
	input [DATA_WIDTH -1:0] COMPARE_DATA;
	input [DATA_WIDTH -1:0] MASK_DATA;
	input EN_MASK_REG;
	integer i;

	begin
		if (EN_MASK_REG == 0)
			  COMPARE_DATA_ENCODER = COMPARE_DATA;
		else if (EN_MASK_REG == 1)
			for (i = 0; i < DATA_WIDTH ; i = i + 1)
			    if (MASK_DATA[i] == 0)
	    			COMPARE_DATA_ENCODER[i] = COMPARE_DATA[i];
			    else if ( MASK_DATA[i] == 1 )
	    			COMPARE_DATA_ENCODER[i] = 1'bx;

	end
	endfunction

	function [ADDR_WIDTH -1:0] OUTPUT_ENCODER;
	input [(1 << ADDR_WIDTH) -1:0] UNEN_CAM_OUT;
	integer i;
        reg [ADDR_WIDTH -1:0] default_value; 
	begin: Label_OUTPUT_ENCODER

                    default_value[ADDR_WIDTH-1] = 1'b1;
                for (j = 0; j < ADDR_WIDTH - 1; j = j + 1)
                    default_value[j] = 1'b0;

	 	for ( i = 0 ; i < (1 << ADDR_WIDTH) ; i = i + 1 )
			  if (UNEN_CAM_OUT[i] == 1)
				begin
				OUTPUT_ENCODER = i;
				disable Label_OUTPUT_ENCODER;
				end
                          else
                                OUTPUT_ENCODER = default_value;
	end
	endfunction


        function MATCH_FLAG;
	input [(1 << ADDR_WIDTH) -1:0] UNEN_CAM_OUT;
	integer i;
        begin
	 	MATCH_FLAG = 0;
		for ( i = 0 ; i < (1 << ADDR_WIDTH) ; i = i + 1 )
			if (UNEN_CAM_OUT[i] == 1)
				MATCH_FLAG = 1;
        end
        endfunction

	function MUL_MATCH_FLAG;
	input [(1 << ADDR_WIDTH) -1:0] UNEN_CAM_OUT;
	integer vMATCH_COUNTE;
	integer i;
	begin
		vMATCH_COUNTE = 0;
		MUL_MATCH_FLAG = 0;
	 	for ( i = 0 ; i < (1 << ADDR_WIDTH) ; i = i + 1 )
			if (UNEN_CAM_OUT[i] == 1)
			    vMATCH_COUNTE = vMATCH_COUNTE + 1;

		if (vMATCH_COUNTE > 1)
			MUL_MATCH_FLAG = 1;
	end
	endfunction

	function WORD_COMPARE;
	input [DATA_WIDTH -1:0] BRAM_DATA;
	input [DATA_WIDTH -1:0] COMP_DATA;
	reg [DATA_WIDTH -1:0] vCOMP_SECT;
	integer i;
	begin
	 	vCOMP_SECT = BRAM_DATA;
		WORD_COMPARE = 1;
		for (i = 0; i < DATA_WIDTH ; i = i + 1)
		begin
			if ( COMP_DATA[i] !== 1'bx && vCOMP_SECT[i] !== 1'bx)
	    		    if ( vCOMP_SECT[i] !== COMP_DATA[i]  || vCOMP_SECT[i] ===1'bz)
				WORD_COMPARE = 0;
		end
	end
	endfunction

endmodule

`endcelldefine

`celldefine

module SC_CAMCL_16K (CE,WE,CLK,EN_MASK,WR_MASK,WR_DC,RST,CS,WAD,WD,/*CO,MATCH,MUL_MATCH*/CLO);

	parameter DEVICE_FAMILY = "SuperCool";
	parameter  MEM_INIT_FLAG = 0;
	parameter  MEM_INIT_FILE = "";
	parameter ADDR_WIDTH = 7;
	parameter DATA_WIDTH = 48;

	input  CE;
	input  WE;
	input  CLK;
	input  EN_MASK;
	input  WR_MASK;
	input  WR_DC;
	input  RST;
	input  [1:0] CS;
	input  [ADDR_WIDTH -1:0] WAD;
	input  [DATA_WIDTH -1:0] WD;
//	output [ADDR_WIDTH -1:0] CO;
//	output MATCH;
//	output MUL_MATCH;
	output [(1<<ADDR_WIDTH)-1:0] CLO;
	integer i;
	integer j;
	integer k;


// Input Nodes
	wire CE_node;
	wire WE_node;
	wire CLK_node;
	wire EN_MASK_node;
	wire WR_MASK_node;
	wire WR_DC_node;
	wire RST_node;
	wire [1:0] CS_node;
	wire [ADDR_WIDTH -1:0] WAD_node;
	wire [DATA_WIDTH -1:0] WD_node;
// Register Nodes
	reg EN_MASK_reg;
	reg [DATA_WIDTH -1:0] MASK_DATA_reg;
	reg [DATA_WIDTH -1:0] COMP_DATA_reg;
	reg [ADDR_WIDTH -1:0] WAD_reg;
	reg WEN_reg;
	reg WR_DC_reg;
	reg [(1<<ADDR_WIDTH)-1:0] CLO_node;

// From WRITE_DATA_ENCODER to CAM Array
	reg [DATA_WIDTH -1:0] WRITE_DATA_node;

// From COMPARE_DATA_ENCODER to CAM Array
 	reg [DATA_WIDTH -1:0] COMPARE_DATA_node;

// From CAM Array to MATCH_FLAG_LOGIC/ CAM_OUTPUT_ENCODER
// 	reg [2**ADDR_WIDTH -1:0] UNEN_CAM_OUT_node;

// Output Nodes
// 	reg [ADDR_WIDTH -1:0] CO_node;
// 	reg  MATCH_node;
// 	reg  MUL_MATCH_node;

	integer vADDR;
	integer vUNEN_CAM_OUT[(1<<ADDR_WIDTH) -1:0];
	integer vMEM[(1<<ADDR_WIDTH)*DATA_WIDTH -1:0];
	reg [DATA_WIDTH -1:0] vMEMTemp;
	reg [DATA_WIDTH-1:0] VMEMINITEMP[0:(1<<ADDR_WIDTH)-1];
	reg [DATA_WIDTH -1:0] vLINETEMP;
	reg [DATA_WIDTH -1:0] vLINECLR;


/************************************************************************
	 Architecture
************************************************************************/
	assign CE_node      = CE;
	assign WE_node      = WE;
	assign CLK_node     = CLK;
	assign EN_MASK_node = EN_MASK;
	assign WR_MASK_node = WR_MASK;
	assign WR_DC_node   = WR_DC;
	assign RST_node     = RST;
	assign CS_node      = CS;
	assign WAD_node     = WAD;
	assign WD_node      = WD;

//	assign CO           = CO_node;
//	assign MATCH        = MATCH_node;
//	assign MUL_MATCH    = MUL_MATCH_node;
	assign CLO	    = CLO_node;

	always @(WR_DC_reg or COMP_DATA_reg or MASK_DATA_reg or EN_MASK_reg)
	begin
		WRITE_DATA_node = WRITE_DATA_ENCODER (WR_DC_reg, COMP_DATA_reg, MASK_DATA_reg, EN_MASK_reg);
	end

	always @(COMP_DATA_reg or MASK_DATA_reg or EN_MASK_reg)
	begin
		COMPARE_DATA_node = COMPARE_DATA_ENCODER (COMP_DATA_reg, MASK_DATA_reg, EN_MASK_reg);
	end
/*	
	always @(UNEN_CAM_OUT_node)
	begin
		MUL_MATCH_node = MUL_MATCH_FLAG (UNEN_CAM_OUT_node);
		MATCH_node     = MATCH_FLAG (UNEN_CAM_OUT_node);
		CO_node = OUTPUT_ENCODER(UNEN_CAM_OUT_node);
	end
*/	

	always @(RST_node)
		begin
			if(RST_node == 1)
				begin
					assign EN_MASK_reg = 'b0;
					assign COMP_DATA_reg = 'b0;
					assign WAD_reg = 'b0;
					assign WEN_reg = 'b0;
					assign WR_DC_reg = 'b0;
				end
			else
				begin
					deassign  EN_MASK_reg;
					deassign  COMP_DATA_reg;
					deassign  WAD_reg;
					deassign  WEN_reg;
					deassign  WR_DC_reg;
				end
		end

	always @(posedge CLK_node)
		begin
			if ( CE_node == 1)
				begin
					EN_MASK_reg   = EN_MASK_node;
					COMP_DATA_reg = WD_node;
					WAD_reg       = WAD_node;
					WEN_reg       = WE_node & CS_node[0] & CS_node[1];
					WR_DC_reg     = WR_DC_node;
					if (WR_MASK_node == 1)
						MASK_DATA_reg = WD_node;
				end
		end
	
	initial	begin
		for (i = 0 ; i < (1 << ADDR_WIDTH)  ; i = i + 1)
		begin
			vUNEN_CAM_OUT[i] = 0;
			for ( j = 0; j < DATA_WIDTH; j = j + 1 )
				vMEM[ i * DATA_WIDTH + j ] = 'bz;
		end

		if( MEM_INIT_FLAG == 1 )
		begin
			for ( i = 0 ; i < (1<<ADDR_WIDTH); i = i + 1)
				begin
					for ( k = 0; k < DATA_WIDTH; k = k + 1)
						vLINECLR[k] = 1'bz;
					VMEMINITEMP[i]= vLINECLR;
				end

			$readmemb(MEM_INIT_FILE,VMEMINITEMP,0,(1<<ADDR_WIDTH)-1);
			for ( i = 0; i < (1<<ADDR_WIDTH); i = i + 1)
				for ( j = 0; j < DATA_WIDTH; j = j + 1)
				begin
					vLINETEMP = VMEMINITEMP[i];
					vMEM[i*DATA_WIDTH+j] = vLINETEMP[j];
				end
		end

	end
	
	always @(WEN_reg or WAD_reg or COMPARE_DATA_node or WRITE_DATA_node)
		begin

			vADDR = WAD_reg;

			if (WEN_reg == 1)
                             begin
				for ( i = 0; i < DATA_WIDTH; i = i + 1 )
					vMEM[ vADDR*DATA_WIDTH + i ] = WRITE_DATA_node[i];
				for (i = 0 ; i < (1 << ADDR_WIDTH)  ; i = i + 1)
					begin
						vUNEN_CAM_OUT[i] = 0;
						for ( j = 0; j < DATA_WIDTH; j = j + 1 )
							vMEMTemp[j] = vMEM[i * DATA_WIDTH + j];
						if (WORD_COMPARE(vMEMTemp, COMPARE_DATA_node) == 1)
							vUNEN_CAM_OUT[i] = 1;
//						UNEN_CAM_OUT_node[i] = vUNEN_CAM_OUT[i];
						CLO_node[i] = vUNEN_CAM_OUT[i];
					end
                             end
			else if (WEN_reg == 0)
				begin
					for (i = 0 ; i < (1 << ADDR_WIDTH)  ; i = i + 1)
						begin
							vUNEN_CAM_OUT[i] = 0;
							for ( j = 0; j < DATA_WIDTH; j = j + 1 )
								vMEMTemp[j] = vMEM[i * DATA_WIDTH + j];
							if (WORD_COMPARE(vMEMTemp, COMPARE_DATA_node) == 1)
								vUNEN_CAM_OUT[i] = 1;
//							UNEN_CAM_OUT_node[i] = vUNEN_CAM_OUT[i];
							CLO_node[i] = vUNEN_CAM_OUT[i];
						end
				end

		end



	function [DATA_WIDTH -1:0] WRITE_DATA_ENCODER;
		input WR_DONT_CARE;
		input [DATA_WIDTH -1:0] UPDATA_DATA;
		input [DATA_WIDTH -1:0] MASK_DATA;
		input EN_MASK_REG;
		integer i;

		begin
			if (EN_MASK_REG == 0)
			  WRITE_DATA_ENCODER = UPDATA_DATA;
			else if (EN_MASK_REG == 1)
			  for ( i = 0; i < DATA_WIDTH ; i = i + 1 )
			    if (MASK_DATA[i] == 0)
				WRITE_DATA_ENCODER[i] = UPDATA_DATA[i];
			    else if ( MASK_DATA[i] == 1 && WR_DONT_CARE == 1)
				WRITE_DATA_ENCODER[i] = "-";
		end
	endfunction

	function [DATA_WIDTH -1:0] COMPARE_DATA_ENCODER;
	input [DATA_WIDTH -1:0] COMPARE_DATA;
	input [DATA_WIDTH -1:0] MASK_DATA;
	input EN_MASK_REG;
	integer i;

	begin
		if (EN_MASK_REG == 0)
			  COMPARE_DATA_ENCODER = COMPARE_DATA;
		else if (EN_MASK_REG == 1)
			for (i = 0; i < DATA_WIDTH ; i = i + 1)
			    if (MASK_DATA[i] == 0)
	    			COMPARE_DATA_ENCODER[i] = COMPARE_DATA[i];
			    else if ( MASK_DATA[i] == 1 )
	    			COMPARE_DATA_ENCODER[i] = 1'bx;

	end
	endfunction

	function [ADDR_WIDTH -1:0] OUTPUT_ENCODER;
	input [(1 << ADDR_WIDTH) -1:0] UNEN_CAM_OUT;
	integer i;
        reg [ADDR_WIDTH -1:0] default_value; 
	begin: Label_OUTPUT_ENCODER

                    default_value[ADDR_WIDTH-1] = 1'b1;
                for (j = 0; j < ADDR_WIDTH - 1; j = j + 1)
                    default_value[j] = 1'b0;

	 	for ( i = 0 ; i < (1 << ADDR_WIDTH) ; i = i + 1 )
			  if (UNEN_CAM_OUT[i] == 1)
				begin
				OUTPUT_ENCODER = i;
				disable Label_OUTPUT_ENCODER;
				end
                          else
                                OUTPUT_ENCODER = default_value;
	end
	endfunction

/*
        function MATCH_FLAG;
	input [(1 << ADDR_WIDTH) -1:0] UNEN_CAM_OUT;
	integer i;
        begin
	 	MATCH_FLAG = 0;
		for ( i = 0 ; i < (1 << ADDR_WIDTH) ; i = i + 1 )
			if (UNEN_CAM_OUT[i] == 1)
				MATCH_FLAG = 1;
        end
        endfunction

	function MUL_MATCH_FLAG;
	input [(1 << ADDR_WIDTH) -1:0] UNEN_CAM_OUT;
	integer vMATCH_COUNTE;
	integer i;
	begin
		vMATCH_COUNTE = 0;
		MUL_MATCH_FLAG = 0;
	 	for ( i = 0 ; i < (1 << ADDR_WIDTH) ; i = i + 1 )
			if (UNEN_CAM_OUT[i] == 1)
			    vMATCH_COUNTE = vMATCH_COUNTE + 1;

		if (vMATCH_COUNTE > 1)
			MUL_MATCH_FLAG = 1;
	end
	endfunction
*/
	function WORD_COMPARE;
	input [DATA_WIDTH -1:0] BRAM_DATA;
	input [DATA_WIDTH -1:0] COMP_DATA;
	reg [DATA_WIDTH -1:0] vCOMP_SECT;
	integer i;
	begin
	 	vCOMP_SECT = BRAM_DATA;
		WORD_COMPARE = 1;
		for (i = 0; i < DATA_WIDTH ; i = i + 1)
		begin
			if ( COMP_DATA[i] !== 1'bx && vCOMP_SECT[i] !== 1'bx)
	    		    if ( vCOMP_SECT[i] !== COMP_DATA[i] || vCOMP_SECT[i] ===1'bz)
				WORD_COMPARE = 0;
		end
	end
	endfunction

endmodule

`endcelldefine

`celldefine

module SC_CAMCM_16K (CE,WE,CLK,EN_MASK,WR_MASK,WR_DC,RST,CS,WAD,WD,CMI,/*CO,MATCH,MUL_MATCH*/CMO);

	parameter DEVICE_FAMILY = "SuperCool";
	parameter  MEM_INIT_FLAG = "";
	parameter  MEM_INIT_FILE = 0;
	parameter ADDR_WIDTH = 7;
	parameter DATA_WIDTH = 48;

	input  CE;
	input  WE;
	input  CLK;
	input  EN_MASK;
	input  WR_MASK;
	input  WR_DC;
	input  RST;
	input  [1:0] CS;
	input  [ADDR_WIDTH -1:0] WAD;
	input  [DATA_WIDTH -1:0] WD;
//	output [ADDR_WIDTH -1:0] CO;
//	output MATCH;
//	output MUL_MATCH;
	input  [(1<<ADDR_WIDTH) -1:0] CMI;
	output [(1<<ADDR_WIDTH) -1:0] CMO;
	integer i;
	integer j;
	integer k;

// Input Nodes
	wire CE_node;
	wire WE_node;
	wire CLK_node;
	wire EN_MASK_node;
	wire WR_MASK_node;
	wire WR_DC_node;
	wire RST_node;
	wire [1:0] CS_node;
	wire [ADDR_WIDTH -1:0] WAD_node;
	wire [DATA_WIDTH -1:0] WD_node;
	wire [(1<<ADDR_WIDTH) -1:0] CMI_node;
// Register Nodes
	reg EN_MASK_reg;
	reg [DATA_WIDTH -1:0] MASK_DATA_reg;
	reg [DATA_WIDTH -1:0] COMP_DATA_reg;
	reg [ADDR_WIDTH -1:0] WAD_reg;
	reg WEN_reg;
	reg WR_DC_reg;
	reg [(1<<ADDR_WIDTH) -1:0] CMO_node;

// From WRITE_DATA_ENCODER to CAM Array
	reg [DATA_WIDTH -1:0] WRITE_DATA_node;

// From COMPARE_DATA_ENCODER to CAM Array
 	reg [DATA_WIDTH -1:0] COMPARE_DATA_node;

// From CAM Array to MATCH_FLAG_LOGIC/ CAM_OUTPUT_ENCODER
 	reg [(1'b1<<ADDR_WIDTH) -1:0] UNEN_CAM_OUT_node;

// Output Nodes
// 	reg [ADDR_WIDTH -1:0] CO_node;
// 	reg  MATCH_node;
// 	reg  MUL_MATCH_node;

	integer vADDR;
	integer vUNEN_CAM_OUT[(1<<ADDR_WIDTH) -1:0];
	integer vMEM[(1<<ADDR_WIDTH)*DATA_WIDTH -1:0];
	reg [DATA_WIDTH -1:0] vMEMTemp;
	reg [DATA_WIDTH-1:0] VMEMINITEMP[0:(1<<ADDR_WIDTH)-1];
	reg [DATA_WIDTH -1:0] vLINETEMP;
	reg [DATA_WIDTH -1:0] vLINECLR;
//        reg [DATA_WIDTH -1:0] vbitval;
//	integer bitval;



/************************************************************************
	 Architecture
************************************************************************/
	assign CE_node      = CE;
	assign WE_node      = WE;
	assign CLK_node     = CLK;
	assign EN_MASK_node = EN_MASK;
	assign WR_MASK_node = WR_MASK;
	assign WR_DC_node   = WR_DC;
	assign RST_node     = RST;
	assign CS_node      = CS;
	assign WAD_node     = WAD;
	assign WD_node      = WD;

//	assign CO           = CO_node;
//	assign MATCH        = MATCH_node;
//	assign MUL_MATCH    = MUL_MATCH_node;
	assign CMI_node	    = CMI;

	assign CMO	    = CMO_node;	

	always @(WR_DC_reg or COMP_DATA_reg or MASK_DATA_reg or EN_MASK_reg)
	begin
		WRITE_DATA_node = WRITE_DATA_ENCODER (WR_DC_reg, COMP_DATA_reg, MASK_DATA_reg, EN_MASK_reg);
	end

	always @(COMP_DATA_reg or MASK_DATA_reg or EN_MASK_reg)
	begin
		COMPARE_DATA_node = COMPARE_DATA_ENCODER (COMP_DATA_reg, MASK_DATA_reg, EN_MASK_reg);
	end

	
/*	always @(UNEN_CAM_OUT_node)
	begin
		MUL_MATCH_node = MUL_MATCH_FLAG (UNEN_CAM_OUT_node_tmp);
		MATCH_node     = MATCH_FLAG (UNEN_CAM_OUT_node_tmp);
		CMO_node = OUTPUT_ENCODER(UNEN_CAM_OUT_node_tmp);
	end
*/
	

	always @(RST_node)
		begin
			if(RST_node == 1)
				begin
					assign EN_MASK_reg = 'b0;
					assign COMP_DATA_reg = 'b0;
					assign WAD_reg = 'b0;
					assign WEN_reg = 'b0;
					assign WR_DC_reg = 'b0;
				end
			else
				begin
					deassign  EN_MASK_reg;
					deassign  COMP_DATA_reg;
					deassign  WAD_reg;
					deassign  WEN_reg;
					deassign  WR_DC_reg;
				end
		end

	always @(posedge CLK_node)
		begin
			if ( CE_node == 1)
				begin
					EN_MASK_reg   = EN_MASK_node;
					COMP_DATA_reg = WD_node;
					WAD_reg       = WAD_node;
					WEN_reg       = WE_node & CS_node[0] & CS_node[1];
					WR_DC_reg     = WR_DC_node;
					if (WR_MASK_node == 1)
						MASK_DATA_reg = WD_node;
				end
		end
	
	initial	begin
		for (i = 0 ; i < (1 << ADDR_WIDTH)  ; i = i + 1)
		begin
			vUNEN_CAM_OUT[i] = 0;
			for ( j = 0; j < DATA_WIDTH; j = j + 1 )
				vMEM[ i * DATA_WIDTH + j ] = 'bz;
		end

		if( MEM_INIT_FLAG == 1 )
		begin
			for ( i = 0 ; i < (1<<ADDR_WIDTH); i = i + 1)
				begin
					for ( k = 0; k < DATA_WIDTH; k = k + 1)
                                             begin
						vLINECLR[k] = 1'bz;
					        VMEMINITEMP[i]= vLINECLR;
                                             end
				end

			$readmemb(MEM_INIT_FILE,VMEMINITEMP,0,(1<<ADDR_WIDTH)-1);
			for ( i = 0; i < (1<<ADDR_WIDTH); i = i + 1)
				for ( j = 0; j < DATA_WIDTH; j = j + 1)
				begin
					vLINETEMP = VMEMINITEMP[i];
					vMEM[i*DATA_WIDTH+j] = vLINETEMP[j];
				end
		end

	end


	always @(WEN_reg or WAD_reg or COMPARE_DATA_node or WRITE_DATA_node or CMI_node)
		begin

			vADDR = WAD_reg;

			if (WEN_reg == 1)
                             begin
				for ( i = 0; i < DATA_WIDTH; i = i + 1 )
					vMEM[ vADDR*DATA_WIDTH + i ] = WRITE_DATA_node[i];


				for (i = 0 ; i < (1 << ADDR_WIDTH)  ; i = i + 1)
					begin
						vUNEN_CAM_OUT[i] = 0;

						for ( j = 0; j < DATA_WIDTH; j = j + 1 )
                                                    vMEMTemp[j] = vMEM[i * DATA_WIDTH + j];							

						if (WORD_COMPARE(vMEMTemp, COMPARE_DATA_node) == 1)
                                             
							vUNEN_CAM_OUT[i] = 1;

				                CMO_node[i] = vUNEN_CAM_OUT[i] & CMI_node[i];
                                             
					end
                             end

			else if (WEN_reg == 0)
				begin
					for (i = 0 ; i < (1 << ADDR_WIDTH)  ; i = i + 1)
						begin
							vUNEN_CAM_OUT[i] = 0;

							for ( j = 0; j < DATA_WIDTH; j = j + 1 )
								vMEMTemp[j] = vMEM[i * DATA_WIDTH + j];

							if (WORD_COMPARE(vMEMTemp, COMPARE_DATA_node) == 1)
								vUNEN_CAM_OUT[i] = 1;

							CMO_node[i] = vUNEN_CAM_OUT[i] & CMI_node[i];
                                                          
						end
				end

		end



	function [DATA_WIDTH -1:0] WRITE_DATA_ENCODER;
		input WR_DONT_CARE;
		input [DATA_WIDTH -1:0] UPDATA_DATA;
		input [DATA_WIDTH -1:0] MASK_DATA;
		input EN_MASK_REG;
		integer i;

		begin
			if (EN_MASK_REG == 0)
			  WRITE_DATA_ENCODER = UPDATA_DATA;
			else if (EN_MASK_REG == 1)
			  for ( i = 0; i < DATA_WIDTH ; i = i + 1 )
			    if (MASK_DATA[i] == 0)
				WRITE_DATA_ENCODER[i] = UPDATA_DATA[i];
			    else if ( MASK_DATA[i] == 1 && WR_DONT_CARE == 1)
				WRITE_DATA_ENCODER[i] = "-";
		end
	endfunction

	function [DATA_WIDTH -1:0] COMPARE_DATA_ENCODER;
	input [DATA_WIDTH -1:0] COMPARE_DATA;
	input [DATA_WIDTH -1:0] MASK_DATA;
	input EN_MASK_REG;
	integer i;

	begin
		if (EN_MASK_REG == 0)
			  COMPARE_DATA_ENCODER = COMPARE_DATA;
		else if (EN_MASK_REG == 1)
			for (i = 0; i < DATA_WIDTH ; i = i + 1)
			    if (MASK_DATA[i] == 0)
	    			COMPARE_DATA_ENCODER[i] = COMPARE_DATA[i];
			    else if ( MASK_DATA[i] == 1 )
	    			COMPARE_DATA_ENCODER[i] = 1'bx;

	end
	endfunction

	function [ADDR_WIDTH -1:0] OUTPUT_ENCODER;
	input [(1 << ADDR_WIDTH) -1:0] UNEN_CAM_OUT;
	integer i;
        reg [ADDR_WIDTH -1:0] default_value; 
	begin: Label_OUTPUT_ENCODER

                    default_value[ADDR_WIDTH-1] = 1'b1;
                for (j = 0; j < ADDR_WIDTH - 1; j = j + 1)
                    default_value[j] = 1'b0;

	 	for ( i = 0 ; i < (1 << ADDR_WIDTH) ; i = i + 1 )
			  if (UNEN_CAM_OUT[i] == 1)
				begin
				OUTPUT_ENCODER = i;
				disable Label_OUTPUT_ENCODER;
				end
                          else
                                OUTPUT_ENCODER = default_value;
	end
	endfunction

/*
        function MATCH_FLAG;
	input [(1 << ADDR_WIDTH) -1:0] UNEN_CAM_OUT;
	integer i;
        begin
	 	MATCH_FLAG = 0;
		for ( i = 0 ; i < (1 << ADDR_WIDTH) ; i = i + 1 )
			if (UNEN_CAM_OUT[i] == 1)
				MATCH_FLAG = 1;
        end
        endfunction

	function MUL_MATCH_FLAG;
	input [(1 << ADDR_WIDTH) -1:0] UNEN_CAM_OUT;
	integer vMATCH_COUNTE;
	integer i;
	begin
		vMATCH_COUNTE = 0;
		MUL_MATCH_FLAG = 0;
	 	for ( i = 0 ; i < (1 << ADDR_WIDTH) ; i = i + 1 )
			if (UNEN_CAM_OUT[i] == 1)
			    vMATCH_COUNTE = vMATCH_COUNTE + 1;

		if (vMATCH_COUNTE > 1)
			MUL_MATCH_FLAG = 1;
	end
	endfunction
*/
	function WORD_COMPARE;
	input [DATA_WIDTH -1:0] BRAM_DATA;
	input [DATA_WIDTH -1:0] COMP_DATA;
	reg [DATA_WIDTH -1:0] vCOMP_SECT;
	integer i;
	begin
	 	vCOMP_SECT = BRAM_DATA;
		WORD_COMPARE = 1;
		for (i = 0; i < DATA_WIDTH ; i = i + 1)
		begin
			if ( COMP_DATA[i] !== 1'bx && vCOMP_SECT[i] !== 1'bx)
	    		    if ( vCOMP_SECT[i] !== COMP_DATA[i]  || vCOMP_SECT[i] ===1'bz)
	    		    //if ( vCOMP_SECT[i] !== COMP_DATA[i] )
				WORD_COMPARE = 0;
		end
	end
	endfunction


/*
	function TO_STRING (INPUT_VECTOR,INPUT_LENGTH,STRING_OUT);
		input INPUT_VECTOR;
		input INPUT_LENGTH;
		output [INPUT_LENGTH-1:0]STRING_OUT;

		begin

		end
	endfunction
*/
endmodule

`endcelldefine

`celldefine

module SC_CAMCR_16K (CE,WE,CLK,EN_MASK,WR_MASK,WR_DC,RST,CS,WAD,WD,CMI,CO,MATCH,MUL_MATCH);

	parameter DEVICE_FAMILY = "SuperCool";
	parameter  MEM_INIT_FILE = "";
	parameter  MEM_INIT_FLAG = 0;
	parameter ADDR_WIDTH = 7;
	parameter DATA_WIDTH = 48;

	input  CE;
	input  WE;
	input  CLK;
	input  EN_MASK;
	input  WR_MASK;
	input  WR_DC;
	input  RST;
	input  [1:0] CS;
	input  [ADDR_WIDTH -1:0] WAD;
	input  [DATA_WIDTH -1:0] WD;
	input  [(1<<ADDR_WIDTH) -1:0] CMI;
	output [ADDR_WIDTH -1:0] CO;
	output MATCH;
	output MUL_MATCH;
	integer i;
	integer j;
	integer k;


// Input Nodes
	wire CE_node;
	wire WE_node;
	wire CLK_node;
	wire EN_MASK_node;
	wire WR_MASK_node;
	wire WR_DC_node;
	wire RST_node;
	wire [1:0] CS_node;
	wire [ADDR_WIDTH -1:0] WAD_node;
	wire [DATA_WIDTH -1:0] WD_node;
	wire [(1<<ADDR_WIDTH) -1:0] CMI_node;
// Register Nodes
	reg EN_MASK_reg;
	reg [DATA_WIDTH -1:0] MASK_DATA_reg;
	reg [DATA_WIDTH -1:0] COMP_DATA_reg;
	reg [ADDR_WIDTH -1:0] WAD_reg;
	reg WEN_reg;
	reg WR_DC_reg;

// From WRITE_DATA_ENCODER to CAM Array
	reg [DATA_WIDTH -1:0] WRITE_DATA_node;

// From COMPARE_DATA_ENCODER to CAM Array
 	reg [DATA_WIDTH -1:0] COMPARE_DATA_node;

// From CAM Array to MATCH_FLAG_LOGIC/ CAM_OUTPUT_ENCODER
 	reg [(1<<ADDR_WIDTH) -1:0] UNEN_CAM_OUT_node;
 	wire [(1<<ADDR_WIDTH) -1:0] UNEN_CAM_OUT_node_tmp ;

// Output Nodes
 	reg [ADDR_WIDTH -1:0] CO_node;
 	reg  MATCH_node;
 	reg  MUL_MATCH_node;

	integer vADDR;
	integer vUNEN_CAM_OUT[(1<<ADDR_WIDTH) -1:0];
	integer vMEM[(1<<ADDR_WIDTH)*DATA_WIDTH -1:0];
	reg [DATA_WIDTH -1:0] vMEMTemp;
	reg [DATA_WIDTH-1:0] VMEMINITEMP[0:(1<<ADDR_WIDTH)-1];
	reg [DATA_WIDTH -1:0] vLINETEMP;
	reg [DATA_WIDTH -1:0] vLINECLR;



/************************************************************************
	 Architecture
************************************************************************/
	assign CE_node      = CE;
	assign WE_node      = WE;
	assign CLK_node     = CLK;
	assign EN_MASK_node = EN_MASK;
	assign WR_MASK_node = WR_MASK;
	assign WR_DC_node   = WR_DC;
	assign RST_node     = RST;
	assign CS_node      = CS;
	assign WAD_node     = WAD;
	assign WD_node      = WD;
	assign CMI_node	    = CMI;

	assign CO           = CO_node;
	assign MATCH        = MATCH_node;
	assign MUL_MATCH    = MUL_MATCH_node;

	always @(WR_DC_reg or COMP_DATA_reg or MASK_DATA_reg or EN_MASK_reg)
	begin
		WRITE_DATA_node = WRITE_DATA_ENCODER (WR_DC_reg, COMP_DATA_reg, MASK_DATA_reg, EN_MASK_reg);
	end

	always @(COMP_DATA_reg or MASK_DATA_reg or EN_MASK_reg)
	begin
		COMPARE_DATA_node = COMPARE_DATA_ENCODER (COMP_DATA_reg, MASK_DATA_reg, EN_MASK_reg);
	end

	assign UNEN_CAM_OUT_node_tmp = UNEN_CAM_OUT_node & CMI_node;
	
	always @(UNEN_CAM_OUT_node_tmp)
	begin
		MUL_MATCH_node = MUL_MATCH_FLAG (UNEN_CAM_OUT_node_tmp);
		MATCH_node     = MATCH_FLAG (UNEN_CAM_OUT_node_tmp);
		CO_node = OUTPUT_ENCODER(UNEN_CAM_OUT_node_tmp);
	end
	

	always @(RST_node)
		begin
			if(RST_node == 1)
				begin
					assign EN_MASK_reg = 'b0;
					assign COMP_DATA_reg = 'b0;
					assign WAD_reg = 'b0;
					assign WEN_reg = 'b0;
					assign WR_DC_reg = 'b0;
				end
			else
				begin
					deassign  EN_MASK_reg;
					deassign  COMP_DATA_reg;
					deassign  WAD_reg;
					deassign  WEN_reg;
					deassign  WR_DC_reg;
				end
		end

	always @(posedge CLK_node)
		begin
			if ( CE_node == 1)
				begin
					EN_MASK_reg   = EN_MASK_node;
					COMP_DATA_reg = WD_node;
					WAD_reg       = WAD_node;
					WEN_reg       = WE_node & CS_node[0] & CS_node[1];
					WR_DC_reg     = WR_DC_node;
					if (WR_MASK_node == 1)
						MASK_DATA_reg = WD_node;
				end
		end
	
	initial	begin
		for (i = 0 ; i < (1 << ADDR_WIDTH)  ; i = i + 1)
		begin
			vUNEN_CAM_OUT[i] = 0;
			for ( j = 0; j < DATA_WIDTH; j = j + 1 )
				vMEM[ i * DATA_WIDTH + j ] = 'bz;
		end

		if( MEM_INIT_FLAG == 1 )
		begin
			for ( i = 0 ; i < (1<<ADDR_WIDTH); i = i + 1)
				begin
					for ( k = 0; k < DATA_WIDTH; k = k + 1)
						vLINECLR[k] = 1'bz;
					VMEMINITEMP[i]= vLINECLR;
				end

			$readmemb(MEM_INIT_FILE,VMEMINITEMP,0,(1<<ADDR_WIDTH)-1);
			for ( i = 0; i < (1<<ADDR_WIDTH); i = i + 1)
				for ( j = 0; j < DATA_WIDTH; j = j + 1)
				begin
					vLINETEMP = VMEMINITEMP[i];
					vMEM[i*DATA_WIDTH+j] = vLINETEMP[j];
				end
		end

	end
	
	always @(WEN_reg or WAD_reg or COMPARE_DATA_node or WRITE_DATA_node)
		begin

			vADDR = WAD_reg;

			if (WEN_reg == 1)
                           begin
				for ( i = 0; i < DATA_WIDTH; i = i + 1 )
					vMEM[ vADDR*DATA_WIDTH + i ] = WRITE_DATA_node[i];

				for (i = 0 ; i < (1 << ADDR_WIDTH)  ; i = i + 1)
					begin
						vUNEN_CAM_OUT[i] = 0;
						for ( j = 0; j < DATA_WIDTH; j = j + 1 )
							vMEMTemp[j] = vMEM[i * DATA_WIDTH + j];
						if (WORD_COMPARE(vMEMTemp, COMPARE_DATA_node) == 1)
							vUNEN_CAM_OUT[i] = 1;
						UNEN_CAM_OUT_node[i] = vUNEN_CAM_OUT[i];
					end
                           end

			else if (WEN_reg == 0)
				begin
					for (i = 0 ; i < (1 << ADDR_WIDTH)  ; i = i + 1)
						begin
							vUNEN_CAM_OUT[i] = 0;
							for ( j = 0; j < DATA_WIDTH; j = j + 1 )
								vMEMTemp[j] = vMEM[i * DATA_WIDTH + j];
							if (WORD_COMPARE(vMEMTemp, COMPARE_DATA_node) == 1)
								vUNEN_CAM_OUT[i] = 1;
							UNEN_CAM_OUT_node[i] = vUNEN_CAM_OUT[i];
						end
				end

		end



	function [DATA_WIDTH -1:0] WRITE_DATA_ENCODER;
		input WR_DONT_CARE;
		input [DATA_WIDTH -1:0] UPDATA_DATA;
		input [DATA_WIDTH -1:0] MASK_DATA;
		input EN_MASK_REG;
		integer i;

		begin
			if (EN_MASK_REG == 0)
			  WRITE_DATA_ENCODER = UPDATA_DATA;
			else if (EN_MASK_REG == 1)
			  for ( i = 0; i < DATA_WIDTH ; i = i + 1 )
			    if (MASK_DATA[i] == 0)
				WRITE_DATA_ENCODER[i] = UPDATA_DATA[i];
			    else if ( MASK_DATA[i] == 1 && WR_DONT_CARE == 1)
				WRITE_DATA_ENCODER[i] = "-";
		end
	endfunction

	function [DATA_WIDTH -1:0] COMPARE_DATA_ENCODER;
	input [DATA_WIDTH -1:0] COMPARE_DATA;
	input [DATA_WIDTH -1:0] MASK_DATA;
	input EN_MASK_REG;
	integer i;

	begin
		if (EN_MASK_REG == 0)
			  COMPARE_DATA_ENCODER = COMPARE_DATA;
		else if (EN_MASK_REG == 1)
			for (i = 0; i < DATA_WIDTH ; i = i + 1)
			    if (MASK_DATA[i] == 0)
	    			COMPARE_DATA_ENCODER[i] = COMPARE_DATA[i];
			    else if ( MASK_DATA[i] == 1 )
	    			COMPARE_DATA_ENCODER[i] = 1'bx;

	end
	endfunction

	function [ADDR_WIDTH -1:0] OUTPUT_ENCODER;
	input [(1 << ADDR_WIDTH) -1:0] UNEN_CAM_OUT;
	integer i;
        reg [ADDR_WIDTH -1:0] default_value; 
	begin: Label_OUTPUT_ENCODER

                    default_value[ADDR_WIDTH-1] = 1'b1;
                for (j = 0; j < ADDR_WIDTH - 1; j = j + 1)
                    default_value[j] = 1'b0;

	 	for ( i = 0 ; i < (1 << ADDR_WIDTH) ; i = i + 1 )
			  if (UNEN_CAM_OUT[i] == 1)
				begin
				OUTPUT_ENCODER = i;
				disable Label_OUTPUT_ENCODER;
				end
                          else
                                OUTPUT_ENCODER = default_value;
	end
	endfunction


        function MATCH_FLAG;
	input [(1 << ADDR_WIDTH) -1:0] UNEN_CAM_OUT;
	integer i;
        begin
	 	MATCH_FLAG = 0;
		for ( i = 0 ; i < (1 << ADDR_WIDTH) ; i = i + 1 )
			if (UNEN_CAM_OUT[i] == 1)
				MATCH_FLAG = 1;
        end
        endfunction

	function MUL_MATCH_FLAG;
	input [(1 << ADDR_WIDTH) -1:0] UNEN_CAM_OUT;
	integer vMATCH_COUNTE;
	integer i;
	begin
		vMATCH_COUNTE = 0;
		MUL_MATCH_FLAG = 0;
	 	for ( i = 0 ; i < (1 << ADDR_WIDTH) ; i = i + 1 )
			if (UNEN_CAM_OUT[i] == 1)
			    vMATCH_COUNTE = vMATCH_COUNTE + 1;

		if (vMATCH_COUNTE > 1)
			MUL_MATCH_FLAG = 1;
	end
	endfunction

	function WORD_COMPARE;
	input [DATA_WIDTH -1:0] BRAM_DATA;
	input [DATA_WIDTH -1:0] COMP_DATA;
	reg [DATA_WIDTH -1:0] vCOMP_SECT;
	integer i;
	begin
	 	vCOMP_SECT = BRAM_DATA;
		WORD_COMPARE = 1;
		for (i = 0; i < DATA_WIDTH ; i = i + 1)
		begin
			if ( COMP_DATA[i] !== 1'bx && vCOMP_SECT[i] !== 1'bx)
	    		    if ( vCOMP_SECT[i] !== COMP_DATA[i] || vCOMP_SECT[i] ===1'bz)
				WORD_COMPARE = 0;
		end
	end
	endfunction

endmodule

`endcelldefine

`celldefine

`timescale 1ns / 100ps
module SC_DPRAM_16K (CENA,CLKA,WRA,CSA,RSTA,DIA,ADA,DOA,CENB,CLKB,WRB,CSB,RSTB,DIB,ADB,DOB);

	parameter DEVICE_FAMILY = "SuperCool";
	parameter ADDR_WIDTH_A = 13;
	parameter DATA_WIDTH_A = 2;
	parameter ADDR_WIDTH_B = 14;
	parameter DATA_WIDTH_B = 1;
	parameter MEM_INIT_FILE = "";
	parameter MEM_INIT_FLAG = 0;

	input CENA;
	input CLKA;
	input WRA;
	input [1:0] CSA;
	input RSTA;
	input [DATA_WIDTH_A -1:0] DIA;
	input [ADDR_WIDTH_A -1:0] ADA;
	output [DATA_WIDTH_A -1:0] DOA;

	input CENB;
	input CLKB;
	input WRB;
	input [1:0] CSB;
	input RSTB;
	input [DATA_WIDTH_B -1:0] DIB;
	input [ADDR_WIDTH_B -1:0] ADB;
	output [DATA_WIDTH_B -1:0] DOB;

	wire CENA_node;
	wire CLKA_node;
	wire WRA_node;
	wire [1:0] CSA_node;
	wire RSTA_node;
	wire [DATA_WIDTH_A -1:0] DIA_node;
	wire [ADDR_WIDTH_A -1:0] ADA_node;
	wire [DATA_WIDTH_A -1:0] DOA_node;
			
	reg [DATA_WIDTH_A -1:0] DIA_reg;
	reg [ADDR_WIDTH_A -1:0] ADA_reg;
	reg ENA_reg;
	reg RENA_reg;
			
	wire CENB_node;
	wire CLKB_node;
	wire WRB_node;
	wire [1:0] CSB_node;
	wire RSTB_node;
	wire [DATA_WIDTH_B -1:0] DIB_node;
	wire [ADDR_WIDTH_B -1:0] ADB_node;
	wire [DATA_WIDTH_B -1:0] DOB_node;
			
	reg [DATA_WIDTH_B -1:0] DIB_reg;
	reg [ADDR_WIDTH_B -1:0] ADB_reg;
	reg ENB_reg;
	reg RENB_reg;
	integer i;

	SC_BRAM_16K hInstance(.WEA(ENA_reg),.REA(RENA_reg),.WEB(ENB_reg),.REB(RENB_reg),.WADA(ADA_reg),.WDA(DIA_reg),
			.RADA(ADA_reg),.RDA(DOA_node),.WADB(ADB_reg),.WDB(DIB_reg),.RADB(ADB_reg),.RDB(DOB_node));

	defparam hInstance.WADDR_WIDTH_A = ADDR_WIDTH_A;
	defparam hInstance.RADDR_WIDTH_A = ADDR_WIDTH_A;
	defparam hInstance.WADDR_WIDTH_B = ADDR_WIDTH_B;
	defparam hInstance.RADDR_WIDTH_B = ADDR_WIDTH_B;
	defparam hInstance.WDATA_WIDTH_A = DATA_WIDTH_A;
	defparam hInstance.RDATA_WIDTH_A = DATA_WIDTH_A;
	defparam hInstance.WDATA_WIDTH_B = DATA_WIDTH_B;
	defparam hInstance.RDATA_WIDTH_B = DATA_WIDTH_B;
	defparam hInstance.ARRAY_SIZE = 8192;
	defparam hInstance.MEM_INIT_FILE = MEM_INIT_FILE;
	defparam hInstance.MEM_INIT_FLAG = MEM_INIT_FLAG;

	assign CENA_node = CENA;
	assign CLKA_node = CLKA;
	assign WRA_node  = WRA;
	assign CSA_node  = CSA;
	assign RSTA_node = RSTA;
	assign DIA_node  = DIA;
	assign ADA_node  = ADA;
	assign DOA = DOA_node;

	assign CENB_node = CENB;
	assign CLKB_node = CLKB;
	assign WRB_node  = WRB;
	assign CSB_node  = CSB;
	assign RSTB_node = RSTB;
	assign DIB_node  = DIB;
	assign ADB_node  = ADB;
	assign DOB = DOB_node;


	always @(RSTA_node or RSTB_node)
	begin
		if (RSTA_node == 1)
			begin
				assign DIA_reg = 0;
				assign ADA_reg = 0;
				assign ENA_reg = 0;
				assign RENA_reg = 1;
			end
		else 
			begin
				deassign DIA_reg;
				deassign ADA_reg;
				deassign ENA_reg;
				deassign RENA_reg;
			end
		
			
		if (RSTB_node == 1)
			begin
				assign DIB_reg = 0;
				assign ADB_reg = 0;
				assign ENB_reg = 0;
				assign RENB_reg = 1;
			end
		else 
			begin
				deassign DIB_reg;
				deassign ADB_reg;
				deassign ENB_reg;
				deassign RENB_reg;
			end
			
	end
	
	always @(posedge CLKA_node)
	begin
	      if (CENA_node == 1)
		begin
			DIA_reg = DIA_node;
			ADA_reg = ADA_node;
			ENA_reg = WRA_node & CSA_node[0] & CSA_node[1];
			//RENA_reg = 1;
			RENA_reg = CSA_node[0] & CSA_node[1];
		end
	end

	always @(posedge CLKB_node)
	begin
	      if (CENB_node == 1)
		begin
			DIB_reg = DIB_node;
			ADB_reg = ADB_node;
			ENB_reg = WRB_node & CSB_node[0] & CSB_node[1];
			//RENB_reg = 1; 
			RENB_reg = CSB_node[0] & CSB_node[1]; 
		end
	end

endmodule

`endcelldefine

`celldefine

`timescale 1ns / 100ps
module SC_DPRAM_16K_L (CENA,CLKA,WRA,CSA,RSTA,DIA,ADA,DOA,CENB,CLKB,WRB,CSB,RSTB,DIB,ADB,DOB);

	parameter DEVICE_FAMILY = "SuperCool";
	parameter ADDR_WIDTH_A = 13;
	parameter DATA_WIDTH_A = 2;
	parameter ADDR_WIDTH_B = 14;
	parameter DATA_WIDTH_B = 1;
	parameter ARRAY_SIZE = 16384;    
	parameter MEM_INIT_FILE = "";
	parameter MEM_INIT_FLAG = 1;

	input CENA;
	input CLKA;
	input WRA;
	input [1:0] CSA;
	input RSTA;
	input [DATA_WIDTH_A -1:0] DIA;
	input [ADDR_WIDTH_A -1:0] ADA;
	output [DATA_WIDTH_A -1:0] DOA;

	input CENB;
	input CLKB;
	input WRB;
	input [1:0] CSB;
	input RSTB;
	input [DATA_WIDTH_B -1:0] DIB;
	input [ADDR_WIDTH_B -1:0] ADB;
	output [DATA_WIDTH_B -1:0] DOB;

	wire CENA_node;
	wire CLKA_node;
	wire WRA_node;
	wire [1:0] CSA_node;
	wire RSTA_node;
	wire [DATA_WIDTH_A -1:0] DIA_node;
	wire [ADDR_WIDTH_A -1:0] ADA_node;
	wire [DATA_WIDTH_A -1:0] DOA_node;
			
	reg [DATA_WIDTH_A -1:0] DIA_reg;
	reg [ADDR_WIDTH_A -1:0] ADA_reg;
	reg ENA_reg;
	reg RENA_reg;
			
	wire CENB_node;
	wire CLKB_node;
	wire WRB_node;
	wire [1:0] CSB_node;
	wire RSTB_node;
	wire [DATA_WIDTH_B -1:0] DIB_node;
	wire [ADDR_WIDTH_B -1:0] ADB_node;
	wire [DATA_WIDTH_B -1:0] DOB_node;
			
	reg [DATA_WIDTH_B -1:0] DIB_reg;
	reg [ADDR_WIDTH_B -1:0] ADB_reg;
	reg ENB_reg;
	reg RENB_reg;
	integer i;

	SC_BRAM_16K_L hInstance(.WEA(ENA_reg),.REA(RENA_reg),.WEB(ENB_reg),.REB(RENB_reg),.WADA(ADA_reg),.WDA(DIA_reg),
			.RADA(ADA_reg),.RDA(DOA_node),.WADB(ADB_reg),.WDB(DIB_reg),.RADB(ADB_reg),.RDB(DOB_node));

	defparam hInstance.WADDR_WIDTH_A = ADDR_WIDTH_A;
	defparam hInstance.RADDR_WIDTH_A = ADDR_WIDTH_A;
	defparam hInstance.WADDR_WIDTH_B = ADDR_WIDTH_B;
	defparam hInstance.RADDR_WIDTH_B = ADDR_WIDTH_B;
	defparam hInstance.WDATA_WIDTH_A = DATA_WIDTH_A;
	defparam hInstance.RDATA_WIDTH_A = DATA_WIDTH_A;
	defparam hInstance.WDATA_WIDTH_B = DATA_WIDTH_B;
	defparam hInstance.RDATA_WIDTH_B = DATA_WIDTH_B;
	defparam hInstance.ARRAY_SIZE =  ARRAY_SIZE;
	defparam hInstance.MEM_INIT_FILE = MEM_INIT_FILE;
	defparam hInstance.MEM_INIT_FLAG = MEM_INIT_FLAG;

	assign CENA_node = CENA;
	assign CLKA_node = CLKA;
	assign WRA_node  = WRA;
	assign CSA_node  = CSA;
	assign RSTA_node = RSTA;
	assign DIA_node  = DIA;
	assign ADA_node  = ADA;
	assign DOA = DOA_node;

	assign CENB_node = CENB;
	assign CLKB_node = CLKB;
	assign WRB_node  = WRB;
	assign CSB_node  = CSB;
	assign RSTB_node = RSTB;
	assign DIB_node  = DIB;
	assign ADB_node  = ADB;
	assign DOB = DOB_node;


	always @(RSTA_node or RSTB_node)
	begin
		if (RSTA_node == 1)
			begin
				assign DIA_reg = 0;
				assign ADA_reg = 0;
				assign ENA_reg = 0;
				assign RENA_reg = 1;
			end
		else 
			begin
				deassign DIA_reg;
				deassign ADA_reg;
				deassign ENA_reg;
				deassign RENA_reg;
			end
		
			
		if (RSTB_node == 1)
			begin
				assign DIB_reg = 0;
				assign ADB_reg = 0;
				assign ENB_reg = 0;
				assign RENB_reg = 1;
			end
		else 
			begin
				deassign DIB_reg;
				deassign ADB_reg;
				deassign ENB_reg;
				deassign RENB_reg;
			end
			
	end
	
	always @(posedge CLKA_node)
	begin
	      if (CENA_node == 1)
		begin
			DIA_reg = DIA_node;
			ADA_reg = ADA_node;
			ENA_reg = WRA_node & CSA_node[0] & CSA_node[1];
			//RENA_reg = 1; 
			RENA_reg = CSA_node[0] & CSA_node[1];
		end
	end

	always @(posedge CLKB_node)
	begin
	      if (CENB_node == 1)
		begin
			DIB_reg = DIB_node;
			ADB_reg = ADB_node;
			ENB_reg = WRB_node & CSB_node[0] & CSB_node[1];
			//RENB_reg = 1; 
			RENB_reg = CSB_node[0] & CSB_node[1]; 
		end
	end

endmodule

`endcelldefine

`celldefine

`celldefine

`timescale 1ns / 100ps
module READ_POINTER_CTRL (GLOBAL_RST,RESET_RP,READ_EN,READ_CLK,
                          EMPTY_FLAG,READ_POINTER,TERMINAL_COUNT,
                          READ_POINTER_WRAPPED, WRITE_POINTER, 
                          WRITE_POINTER_WRAPPED);

   parameter RPOINTER_WIDTH = 9;

   input     GLOBAL_RST;
   input     RESET_RP;
   input     READ_EN;
   input     READ_CLK;
   input     EMPTY_FLAG;
   input     [RPOINTER_WIDTH -1:0] WRITE_POINTER;
   input                           WRITE_POINTER_WRAPPED;
   input     [RPOINTER_WIDTH -1:0] TERMINAL_COUNT;
   output    [RPOINTER_WIDTH -1:0] READ_POINTER;
   output                          READ_POINTER_WRAPPED;

   reg [RPOINTER_WIDTH -1:0]       READ_POINTER_reg;
   reg                             WRAPPED_STATE;
   
   assign                          READ_POINTER = READ_POINTER_reg;
   assign                          READ_POINTER_WRAPPED = WRAPPED_STATE;

   always @(GLOBAL_RST or RESET_RP)
      begin
         if (GLOBAL_RST == 1 || RESET_RP == 1)
            begin
               assign READ_POINTER_reg = 0;
               assign WRAPPED_STATE = 0;
            end
         else
            begin
               deassign READ_POINTER_reg;
               deassign WRAPPED_STATE;
            end
      end
   
   always @(posedge READ_CLK)
      begin

         if (READ_EN == 1 && EMPTY_FLAG != 0)
            begin
               if (READ_POINTER_reg == TERMINAL_COUNT)
                  begin
                     // Wrap around to first memory location
                     READ_POINTER_reg <= 0;
                     WRAPPED_STATE <= ~WRAPPED_STATE;
                  end
               else if ((READ_POINTER_reg != WRITE_POINTER) || 
                        (READ_POINTER_WRAPPED != WRITE_POINTER_WRAPPED))
                  // if the read pointer has not met up with the write
                  // pointer, increment the read pointer.
                  READ_POINTER_reg <= READ_POINTER_reg + 1;
            end // if (READ_EN == 1 && EMPTY_FLAG != 0)
      end

endmodule
`timescale 1ns / 100ps
module WRITE_POINTER_CTRL (GLOBAL_RST,WRITE_EN,WRITE_CLK,FULL_FLAG,
                           WRITE_POINTER,TERMINAL_COUNT,WRITE_POINTER_WRAPPED);

   parameter WPOINTER_WIDTH = 9;
   parameter WDATA_WIDTH = 32;

   input     GLOBAL_RST;
   input     WRITE_EN;
   input     WRITE_CLK;
   input     FULL_FLAG;
   input [WPOINTER_WIDTH -1:0] TERMINAL_COUNT;
   output [WPOINTER_WIDTH -1:0] WRITE_POINTER;
   output                       WRITE_POINTER_WRAPPED;

   reg [WPOINTER_WIDTH -1:0]    WRITE_POINTER_reg;
   reg                          WRAPPED_STATE;
   
   assign                       WRITE_POINTER = WRITE_POINTER_reg;
   assign                       WRITE_POINTER_WRAPPED = WRAPPED_STATE;

   always @(GLOBAL_RST)
      begin
         if (GLOBAL_RST == 1)
            begin
               assign WRITE_POINTER_reg = 0;
               assign WRAPPED_STATE = 0;
            end
         else
            begin
               deassign WRITE_POINTER_reg;
               deassign WRAPPED_STATE;
            end
      end // always @ (GLOBAL_RST)

   always @(posedge WRITE_CLK)
      begin
         if (WRITE_EN == 1 && FULL_FLAG != 1)
            if (WRITE_POINTER_reg == TERMINAL_COUNT)
               begin
                  WRITE_POINTER_reg <= 0;
                  WRAPPED_STATE <= ~WRAPPED_STATE;
               end
            else 
               WRITE_POINTER_reg <= WRITE_POINTER_reg + 1;
      end // always @ (posedge WRITE_CLK)


endmodule
`timescale 1ns / 100ps
module FLAG_LOGIC (R_POINTER,W_POINTER,GLOBAL_RST,READ_EN,READ_CLK,WRITE_EN,
                   WRITE_CLK,WRITE_POINTER_WRAPPED, READ_POINTER_WRAPPED,
                   FULL_D,EMPTY_D,AMFULL_D,AMEMPTY_D);

   parameter POINTER_WIDTH = 9;
   parameter DATA_WIDTH = 32;
   parameter AMFULL_X = 1;
   parameter AMEMPTY_Y = 1;
   parameter TERMINAL_COUNT = 1;
   

   input [POINTER_WIDTH -1:0] R_POINTER;
   input [POINTER_WIDTH -1:0] W_POINTER;

   input                      GLOBAL_RST;
   input                      READ_EN;
   input                      READ_CLK;
   input                      WRITE_EN;
   input                      WRITE_CLK;

   input                      WRITE_POINTER_WRAPPED;
   input                      READ_POINTER_WRAPPED;

   output                     FULL_D;
   output                     EMPTY_D;
   output                     AMFULL_D;
   output                     AMEMPTY_D;
   
   reg                        FULL_D_reg;
   reg                        EMPTY_D_reg;
   reg                        AMFULL_D_reg;
   reg                        AMEMPTY_D_reg;

   wire                       full_node;
   wire                       empty_node;
   wire                       aempty_node;
   wire                       afull_node;

   assign                     FULL_D    = FULL_D_reg;
   assign                     AMFULL_D  = AMFULL_D_reg;
   assign                     EMPTY_D   = EMPTY_D_reg;
   assign                     AMEMPTY_D = AMEMPTY_D_reg;

   always @(GLOBAL_RST)
      begin
         if (GLOBAL_RST == 1)
            begin
               assign EMPTY_D_reg = 1'b0;
               assign AMEMPTY_D_reg = 1'b0;
               assign FULL_D_reg = 1'b0;
               assign AMFULL_D_reg = 1'b0;
            end
         else
            begin
               deassign EMPTY_D_reg;
               deassign AMEMPTY_D_reg;
               deassign FULL_D_reg;
               deassign AMFULL_D_reg;
            end
      end
   
   assign full_node  = fifo_full(READ_POINTER_WRAPPED,WRITE_POINTER_WRAPPED,
                                 R_POINTER, W_POINTER, TERMINAL_COUNT,
                                 WRITE_EN);

   assign afull_node = fifo_afull(READ_POINTER_WRAPPED,WRITE_POINTER_WRAPPED,
                                  R_POINTER, W_POINTER, AMFULL_X,
                                  TERMINAL_COUNT);
   
   assign empty_node = fifo_empty(READ_POINTER_WRAPPED,WRITE_POINTER_WRAPPED,
                                  R_POINTER, W_POINTER, TERMINAL_COUNT,
                                  READ_EN);

   assign aempty_node = fifo_aempty(READ_POINTER_WRAPPED,WRITE_POINTER_WRAPPED,
                                    R_POINTER, W_POINTER, AMEMPTY_Y,
                                    TERMINAL_COUNT, READ_EN);
   
   always @(posedge(WRITE_CLK))
      begin
         FULL_D_reg <= full_node;
         AMFULL_D_reg <= afull_node;
     end

   always @(posedge(READ_CLK))
      begin
         EMPTY_D_reg    <= empty_node;
         AMEMPTY_D_reg  <= aempty_node;
      end

   function fifo_full;
      input RP_W;
      input WP_W;
      input [POINTER_WIDTH -1 : 0] RP;
      input [POINTER_WIDTH -1 : 0] WP;
      input [POINTER_WIDTH -1 : 0] TERMINAL_COUNT;
      input                        WRITE_EN;
      
      parameter FIFO_FULL = 1'b1;
      parameter FIFO_N_FULL = 1'b0;
      begin
         if (WP == TERMINAL_COUNT)
            begin
               // Write pointer is about to wrap around, so
               // WP+1 == 0.  Also since this is the last entry, and
               // has already been determined as being writable
               // (i.e. wasn't already FULL) the wrapped pointers by
               // default do not match.  So there is no need to
               // compare them for mis-match.  Thus if RP == 0 then
               // the WP has caught up to the RP.
               if ((RP == 0) && WRITE_EN)
                  fifo_full = FIFO_FULL;
               else if ((RP == WP) && (RP_W != WP_W))
                  fifo_full = FIFO_FULL;
               else
                  fifo_full = FIFO_N_FULL;
            end
         else
            begin
               // check to see if the write pointer has caught up to
               // the read pointer.  If it has then signal the fifo is
               // FULL.
               if ((RP == WP+1) && WRITE_EN)
                  fifo_full = FIFO_FULL;
               else if ((RP == WP) && (RP_W != WP_W))
                  fifo_full = FIFO_FULL;
               else
                  fifo_full = FIFO_N_FULL;
            end
      end
      
   endfunction

   function fifo_afull;
      input RP_W;
      input WP_W;
      input [POINTER_WIDTH -1 : 0] RP;
      input [POINTER_WIDTH -1 : 0] WP;
      input [POINTER_WIDTH -1 : 0] AFULL_THRESHOLD;
      input [POINTER_WIDTH -1 : 0] TERMINAL_COUNT;
      
      parameter F_AFULL = 1'b1;
      parameter F_NOT_AFULL = 1'b0;
      begin
         if (RP_W != WP_W)
            begin
               // we need to do calculations comparing the read
               // pointer and write pointer across the end/begin fifo
               // boundary.
               if (RP - WP <= AFULL_THRESHOLD)
                  fifo_afull = F_AFULL;
               else
                  fifo_afull = F_NOT_AFULL;
            end // if (RP_W != WP_W)
         else
            if (TERMINAL_COUNT - (WP - RP) <= AFULL_THRESHOLD)
               fifo_afull = F_AFULL;
            else
               fifo_afull = F_NOT_AFULL;
      end
      
   endfunction

   function fifo_empty;
      input RP_W;
      input WP_W;
      input [POINTER_WIDTH -1 : 0] RP;
      input [POINTER_WIDTH -1 : 0] WP;
      input [POINTER_WIDTH -1 : 0] TERMINAL_COUNT;
      input                        READ_EN;
      
      
      parameter F_EMPTY = 1'b0;
      parameter F_NOT_EMPTY = 1'b1;
      begin
         if (RP == TERMINAL_COUNT)
            begin
               // Read pointer is about to wrap around, so
               // RP+1 == 0.  Also since this is the last entry, and
               // the FIFO was not empty on the last clock, by default
               // the write pointer has wrapped.  So there is no need to
               // compare the wrapped flags.  Thus if WP == 0 then
               // the RP has caught up to the WP.
               if ((WP == 0) && READ_EN)
                  fifo_empty = F_EMPTY;
               else if ((RP_W == WP_W) && (WP == RP))
                  fifo_empty = F_EMPTY;
               else
                  fifo_empty = F_NOT_EMPTY;
            end
         else
            begin
               // check to see if the read pointer has caught up to
               // the write pointer.  If it has then signal the fifo is
               // EMPTY.
               if ((RP_W == WP_W) && (WP == RP))
                  // The write and read pointers match exactly, so the
                  // fifo is EMPTY
                  fifo_empty = F_EMPTY;
               else if ((RP_W == WP_W) && (WP == RP+1) && READ_EN)
                  // the read pointer just caught up with the write
                  // pointer, so the fifo is EMPTY
                  fifo_empty = F_EMPTY;
               else
                  fifo_empty = F_NOT_EMPTY;
            end // else: !if(RP == TERMINAL_COUNT)
      end
      
   endfunction

   function fifo_aempty;
      input RP_W;
      input WP_W;
      input [POINTER_WIDTH -1 : 0] RP;
      input [POINTER_WIDTH -1 : 0] WP;
      input [POINTER_WIDTH -1 : 0] AEMPTY_THRESHOLD;
      input [POINTER_WIDTH -1 : 0] TERMINAL_COUNT;
      input                        READ_EN;
      
      parameter F_AEMPTY = 1'b0;
      parameter F_NOT_AEMPTY = 1'b1;
      begin
         if (READ_EN)
            begin
               if (RP_W != WP_W)
                  begin
                     // Calculations required due to the WP wrapping
                     // around the end of the fifo.
                     if ((TERMINAL_COUNT + 1 - RP) + WP <=
                         AEMPTY_THRESHOLD + 1)
                        fifo_aempty = F_AEMPTY;
                     else
                        fifo_aempty = F_NOT_AEMPTY;
                  end // if (RP_W != WP_W)
               else
                  if (WP - RP <= AEMPTY_THRESHOLD + 1)
                     fifo_aempty = F_AEMPTY;
                  else
                     fifo_aempty = F_NOT_AEMPTY;
            end // if (READ_EN)
         else
            begin
               if (RP_W != WP_W)
                  begin
                     // we need to do calculations comparing the read
                     // pointer and write pointer across the end/begin fifo
                     // boundary.
                     if ((TERMINAL_COUNT + 1 - RP) + WP > AEMPTY_THRESHOLD)
                        fifo_aempty = F_NOT_AEMPTY;
                     else
                        fifo_aempty = F_AEMPTY;
                  end // if (RP_W != WP_W)
               else
                  // Degenerate case where both pointers have not wrapped
                  if (WP - RP > AEMPTY_THRESHOLD)
                     fifo_aempty = F_NOT_AEMPTY;
                  else
                     fifo_aempty = F_AEMPTY;
            end // else: !if(READ_EN)
      end
   endfunction

endmodule
         
`timescale 1ns / 100ps
module SC_FIFO_16K (WE,WCLK,RST,RPRST,RE,RCLK,FULLIN,EMPTYIN,DI,FULL,EMPTY,AMFULL,AMEMPTY,DO);
   parameter DEVICE_FAMILY = "SuperCool";
   parameter TERMINAL_COUNT = 511;
   parameter ADDR_WIDTH = 9;
   parameter DATA_WIDTH = 32;
   parameter ALMOST_FULL_X = 1;
   parameter ALMOST_EMPTY_Y = 1;

   input     WE;
   input     WCLK;
   input     RST;
   input     RPRST;
   input     RE;
   input     RCLK;
   input     FULLIN;
   input     EMPTYIN;
   input [DATA_WIDTH -1:0] DI;

   output                  FULL;
   output                  EMPTY;
   output                  AMFULL;
   output                  AMEMPTY;
   output [DATA_WIDTH -1:0] DO;

   wire                     WE_node;
   wire                     WCLK_node;
   wire                     RST_node;
   wire                     RPRST_node;
   wire                     RE_node;
   wire                     RCLK_node;
   wire                     FULLIN_node;
   wire                     EMPTYIN_node;
   wire [DATA_WIDTH -1:0]   DI_node;

   reg [DATA_WIDTH -1:0]    DI_reg;
   reg                      FULLIN_reg;
   reg                      EMPTYIN_reg;

   wire                     FULL_node;
   wire                     EMPTY_node;
   wire                     AMFULL_node;
   wire                     AMEMPTY_node;
   wire [DATA_WIDTH -1:0]   DO_node;

   reg                      WE_reg;
   reg                      RE_reg;
   reg [ADDR_WIDTH - 1 : 0] TC_node;

   wire [ADDR_WIDTH -1:0]   RP_node;
   wire [ADDR_WIDTH -1:0]   WP_node;

   wire                     READ_POINTER_WRAPPED;
   wire                     WRITE_POINTER_WRAPPED;
   
   assign                   WE_node = WE & !FULL_node;
   assign                   WCLK_node = WCLK;
   assign                   RST_node = RST;
   assign                   RPRST_node = RPRST;
   assign                   RE_node = RE & EMPTY_node;
   assign                   RCLK_node = RCLK;
   assign                   FULLIN_node = FULLIN;
   assign                   EMPTYIN_node = EMPTYIN;
   assign                   DI_node = DI;

   assign                   FULL = FULL_node;
   assign                   AMFULL = AMFULL_node;
   assign                   EMPTY = EMPTY_node;
   assign                   AMEMPTY = AMEMPTY_node;
   
   assign                   DO = DO_node;

   initial begin
       TC_node = TERMINAL_COUNT;
   end
  // initial begin 
  //    TC_node = TERMINAL_COUNT;
  //    if ((ADDR_WIDTH == 9)  && (DATA_WIDTH > 32) ||
  //        (ADDR_WIDTH == 10) && (DATA_WIDTH > 16) ||
  //        (ADDR_WIDTH == 11) && (DATA_WIDTH > 8)  ||
  //        (ADDR_WIDTH == 12) && (DATA_WIDTH > 4)  ||
  //        (ADDR_WIDTH == 13) && (DATA_WIDTH > 2)  ||
  //        (ADDR_WIDTH == 14) && (DATA_WIDTH > 1));
  //       begin
  //          $display ("\nsimulation time: ",$time);
  //          $display ("Invalid FIFO size.  Adjust address and data width to manipulate 16Kbits.");
  //          $stop;
  //       end
  //    if ((ADDR_WIDTH < 9) || (ADDR_WIDTH > 14))
  //       begin
  //          $display ("\nsimulation time: ",$time);
  //          $display ("Invalid FIFO size.  The ADDRESS must be 9 to 14 bits in size.");
  //          $stop;
  //       end
  //    if (DATA_WIDTH > 32)
  //       begin
  //          $display ("\nsimulation time: ",$time);
  //          $display ("Invalid FIFO size.  The DATA bus width cannot be larger than 32bits.");
  //          $stop;
  //       end
  // end
   
   always @(RST_node)
      begin
         if (RST_node == 1)
            begin
               assign DI_reg = 'b0;
               assign FULLIN_reg = 1'b0;
               assign EMPTYIN_reg = 1'b0;
               assign WE_reg = 1'b0;
               assign RE_reg = 1'b0;
            end
         else
            begin
               deassign DI_reg;
               deassign FULLIN_reg;
               deassign EMPTYIN_reg;
               deassign WE_reg;
               deassign RE_reg;
            end
      end
   
   always @(posedge WCLK_node)
      begin
         DI_reg <= DI_node;
         FULLIN_reg <= FULLIN_node;
         WE_reg <= WE_node;
      end

   always @(posedge RCLK_node)
      begin
         EMPTYIN_reg <= EMPTYIN_node;
         RE_reg <= RE_node;
      end

   READ_POINTER_CTRL FIFO_RPC_INST(.GLOBAL_RST(RST_node),
                                   .RESET_RP(RPRST_node),
                                   .READ_EN(RE_node),
                                   .READ_CLK(RCLK_node),
                                   .EMPTY_FLAG(EMPTY_node),
                                   .READ_POINTER(RP_node),
                                   .TERMINAL_COUNT(TC_node),
                                   .READ_POINTER_WRAPPED(READ_POINTER_WRAPPED),
                                   .WRITE_POINTER(WP_node),
                                   .WRITE_POINTER_WRAPPED(WRITE_POINTER_WRAPPED));
   defparam FIFO_RPC_INST.RPOINTER_WIDTH = ADDR_WIDTH;

   WRITE_POINTER_CTRL FIFO_WPC_INST(.GLOBAL_RST(RST_node),
                                    .WRITE_EN(WE_node),
                                    .WRITE_CLK(WCLK_node),
                                    .FULL_FLAG(FULL_node),
                                    .WRITE_POINTER(WP_node),
                                    .TERMINAL_COUNT(TC_node),
                                    .WRITE_POINTER_WRAPPED(WRITE_POINTER_WRAPPED));
   defparam FIFO_WPC_INST.WPOINTER_WIDTH = ADDR_WIDTH;
   defparam FIFO_WPC_INST.WDATA_WIDTH = DATA_WIDTH;


   FLAG_LOGIC FIFO_FL_INST(.R_POINTER(RP_node),
                           .W_POINTER(WP_node),
                           .GLOBAL_RST(RST_node),
                           .READ_EN(RE_node),
                           .READ_CLK(RCLK_node),
                           .WRITE_EN(WE_node),
                           .WRITE_CLK(WCLK_node),
                           .FULL_D(FULL_node),
                           .EMPTY_D(EMPTY_node),
                           .AMFULL_D(AMFULL_node),
                           .AMEMPTY_D(AMEMPTY_node),
                           .READ_POINTER_WRAPPED(READ_POINTER_WRAPPED),
                           .WRITE_POINTER_WRAPPED(WRITE_POINTER_WRAPPED));

   defparam FIFO_FL_INST.POINTER_WIDTH = ADDR_WIDTH;
   defparam FIFO_FL_INST.DATA_WIDTH = DATA_WIDTH;
   defparam FIFO_FL_INST.AMFULL_X = ALMOST_FULL_X;
   defparam FIFO_FL_INST.AMEMPTY_Y = ALMOST_EMPTY_Y;
   defparam FIFO_FL_INST.TERMINAL_COUNT = TERMINAL_COUNT;
   

   SC_BRAM_16K_SYNC   FIFO_BRAM_INST(.WADA(WP_node),
                                     .WEA(WE_node),
                                     .WDA(DI_node),
                                     .RADA(RP_node),
                                     .REA(RE_node),
                                     .RDA(DO_node),
                                     .WADB(WP_node),
                                     .WEB(1'b0),
                                     .WDB(DI_node),
                                     .RADB(RP_node),
                                     .REB(1'b0),
                                     .RDB(),
                                     .WCLK(WCLK_node),
                                     .RCLK(RCLK_node)
                                     ); 

   defparam FIFO_BRAM_INST.WADDR_WIDTH_A  = ADDR_WIDTH;
   defparam FIFO_BRAM_INST.RADDR_WIDTH_A  = ADDR_WIDTH;
   defparam FIFO_BRAM_INST.WADDR_WIDTH_B  = ADDR_WIDTH;
   defparam FIFO_BRAM_INST.RADDR_WIDTH_B  = ADDR_WIDTH;
   defparam FIFO_BRAM_INST.WDATA_WIDTH_A  = DATA_WIDTH;
   defparam FIFO_BRAM_INST.RDATA_WIDTH_A  = DATA_WIDTH;
   defparam FIFO_BRAM_INST.WDATA_WIDTH_B  = DATA_WIDTH;
   defparam FIFO_BRAM_INST.RDATA_WIDTH_B  = DATA_WIDTH;
   defparam FIFO_BRAM_INST.MEM_INIT_FILE = "";
   defparam FIFO_BRAM_INST.MEM_INIT_FLAG = 0;
   defparam FIFO_BRAM_INST.ARRAY_SIZE = TERMINAL_COUNT+1;

endmodule
`endcelldefine

`celldefine

`endcelldefine

`timescale 1ns / 100ps
module SC_FIFO_16K_L (WE,WCLK,RST,RPRST,RE,RCLK,FULLIN,EMPTYIN,DI,FULL,EMPTY,AMFULL,AMEMPTY,DO);
   parameter DEVICE_FAMILY = "SuperCool";
   parameter TERMINAL_COUNT = 511;
   parameter ADDR_WIDTH = 9;
   parameter DATA_WIDTH = 32;
   parameter ALMOST_FULL_X = 1;
   parameter ALMOST_EMPTY_Y = 1;

   input     WE;
   input     WCLK;
   input     RST;
   input     RPRST;
   input     RE;
   input     RCLK;
   input     FULLIN;
   input     EMPTYIN;
   input [DATA_WIDTH -1:0] DI;

   output                  FULL;
   output                  EMPTY;
   output                  AMFULL;
   output                  AMEMPTY;
   output [DATA_WIDTH -1:0] DO;



//----------------------------------------------------------------------------
// REG WIRE DECLARATIONS
//----------------------------------------------------------------------------
reg	[ADDR_WIDTH:0]		wptr_wrap_appended, rptr_wrap_appended;
//wire	[ADDR_WIDTH:0]		wptr_wrap_appended, rptr_wrap_appended;
wire	[ADDR_WIDTH:0]		next_wptr_wrap_appended, next_rptr_wrap_appended;
wire	[ADDR_WIDTH-1:0]	wptr, rptr;
wire			wptr_wrap_bit, rptr_wrap_bit;

wire	[ADDR_WIDTH:0]		num_empty_loc, num_unread_loc ;

wire	we_ram, re_ram, full_bit, empty_bit, am_full_bit, am_empty_bit;
wire	[ADDR_WIDTH:0]		DEPTH = TERMINAL_COUNT + 1;

reg	[ADDR_WIDTH:0]		wptr_wrap_appended_rdomain;
reg	[ADDR_WIDTH:0]		rptr_wrap_appended_wdomain;
wire	[ADDR_WIDTH-1:0]	wptr_rdomain, rptr_wdomain;
wire	wptr_wrap_bit_rdomain,  rptr_wrap_bit_wdomain; 

//----------------------------------------------------------------------------
// ASSIGNMENTS
//----------------------------------------------------------------------------

assign we_ram = WE & ~full_bit;
assign re_ram = RE & ~empty_bit;

assign wptr = wptr_wrap_appended [ADDR_WIDTH-1:0];
assign rptr = rptr_wrap_appended [ADDR_WIDTH-1:0];
assign wptr_wrap_bit = wptr_wrap_appended[ADDR_WIDTH];
assign rptr_wrap_bit = rptr_wrap_appended[ADDR_WIDTH];
assign next_wptr_wrap_appended = next_ptr(wptr_wrap_bit, wptr, TERMINAL_COUNT);
assign next_rptr_wrap_appended = next_ptr(rptr_wrap_bit, rptr, TERMINAL_COUNT);

assign wptr_rdomain = wptr_wrap_appended_rdomain[ADDR_WIDTH-1:0];
assign rptr_wdomain = rptr_wrap_appended_wdomain[ADDR_WIDTH-1:0];
assign wptr_wrap_bit_rdomain = wptr_wrap_appended_rdomain[ADDR_WIDTH];
assign rptr_wrap_bit_wdomain = rptr_wrap_appended_wdomain[ADDR_WIDTH];


assign num_empty_loc = (rptr_wrap_bit_wdomain == wptr_wrap_bit) ?
   (DEPTH + rptr_wdomain) - wptr:
   {1'b0, rptr_wdomain - wptr};
assign num_unread_loc = (wptr_wrap_bit_rdomain != rptr_wrap_bit) ?
   (DEPTH + wptr_rdomain) - rptr:
   {1'b0, wptr_rdomain - rptr};

assign full_bit = (num_empty_loc == 0);
assign empty_bit = (num_unread_loc == 0);

assign am_full_bit = (num_empty_loc <= ALMOST_FULL_X);
assign am_empty_bit = (num_unread_loc <= ALMOST_EMPTY_Y);

assign FULL = full_bit;
assign EMPTY = ~empty_bit;
assign AMFULL = am_full_bit;
assign AMEMPTY = ~am_empty_bit;

//----------------------------------------------------------------------------
// WRITE/READ POINTERS
//----------------------------------------------------------------------------
always @ (posedge WCLK or posedge RST)
   if (RST)
      wptr_wrap_appended <= 0;
   else if (WE & ~full_bit)
      wptr_wrap_appended <= #1 next_wptr_wrap_appended;

always @ (posedge RCLK or posedge RST)
   if (RST)
      rptr_wrap_appended <= 0;
   else if (RE & ~empty_bit)
      rptr_wrap_appended <= #1 next_rptr_wrap_appended;

//*****************************************************************************
// POINTER SYNCHRONIZATIONS: SIMPLY DONE TO MATCH GATE-LEVEL MODEL 
//*****************************************************************************
always @ (posedge WCLK or posedge RST)
   if (RST)
   begin
      rptr_wrap_appended_wdomain <= 0;
   end
   else 
      rptr_wrap_appended_wdomain <= #1 rptr_wrap_appended;


always @ (posedge RCLK or posedge RST)
   if (RST)
      wptr_wrap_appended_rdomain <= 0;
   else 
      wptr_wrap_appended_rdomain <= #1 wptr_wrap_appended;
//*****************************************************************************
// FUNCTIONS
//*****************************************************************************

function [ADDR_WIDTH:0] next_ptr;
input ptr_wrap_bit;
input [ADDR_WIDTH-1:0] ptr;
input [ADDR_WIDTH-1:0] TERMINAL_COUNT;

begin
   if (ptr == TERMINAL_COUNT)
      next_ptr = {~ptr_wrap_bit, {ADDR_WIDTH{1'b0}}};
   else
      next_ptr = {ptr_wrap_bit, ptr} + 1;
end
endfunction


//*****************************************************************************
// MEMORY INSTANTIATIONS
//*****************************************************************************
SC_BRAM_16K_L_SYNC FIFO_BRAM_INST(
	.WADA(wptr),
	.WEA(we_ram),
	.WDA(DI),
	.RADA(rptr),
	.REA(re_ram),
	.RDA(DO),

	.WADB(wptr),
	.WEB(1'b0),
	.WDB(DI),
	.RADB(rptr),
	.REB(1'b0),
	.RDB(),

	.WCLK(WCLK),
	.RCLK(RCLK),
	.RESET(RST)
); 

   defparam FIFO_BRAM_INST.WADDR_WIDTH_A  = ADDR_WIDTH;
   defparam FIFO_BRAM_INST.RADDR_WIDTH_A  = ADDR_WIDTH;
   defparam FIFO_BRAM_INST.WADDR_WIDTH_B  = ADDR_WIDTH;
   defparam FIFO_BRAM_INST.RADDR_WIDTH_B  = ADDR_WIDTH;
   defparam FIFO_BRAM_INST.WDATA_WIDTH_A  = DATA_WIDTH;
   defparam FIFO_BRAM_INST.RDATA_WIDTH_A  = DATA_WIDTH;
   defparam FIFO_BRAM_INST.WDATA_WIDTH_B  = DATA_WIDTH;
   defparam FIFO_BRAM_INST.RDATA_WIDTH_B  = DATA_WIDTH;
   defparam FIFO_BRAM_INST.MEM_INIT_FILE = "";
   defparam FIFO_BRAM_INST.MEM_INIT_FLAG = 0;
   defparam FIFO_BRAM_INST.ARRAY_SIZE = TERMINAL_COUNT+1;

endmodule

`celldefine

`timescale 100ps / 1ps
module READ_POINTER_CTRL_V2 (GLOBAL_RST,RESET_RP,READ_EN,READ_CLK,EMPTY_FLAG,READ_POINTER,TERMINAL_COUNT); 

	parameter RPOINTER_WIDTH = 9;

        input GLOBAL_RST;
        input RESET_RP;
        input READ_EN;
        input READ_CLK;
        input EMPTY_FLAG;
	input [RPOINTER_WIDTH -1:0] TERMINAL_COUNT;	
        output [RPOINTER_WIDTH -1:0] READ_POINTER;

	reg [RPOINTER_WIDTH -1:0] s_READ_POINTER;
	reg [RPOINTER_WIDTH -1:0] s_READ_POINTER_temp;	
	integer i;
	
	assign READ_POINTER = s_READ_POINTER;


	initial	begin
		s_READ_POINTER = TERMINAL_COUNT;
	end
	
	always @(GLOBAL_RST or RESET_RP)
	begin
		if (GLOBAL_RST == 1 || RESET_RP == 1)
			assign s_READ_POINTER = TERMINAL_COUNT;	
		else
			deassign s_READ_POINTER;
	end
	
	always @(posedge READ_CLK)
	begin

		if (READ_EN == 1 && EMPTY_FLAG != 0)
			s_READ_POINTER = s_READ_POINTER + 1;

		s_READ_POINTER_temp = TERMINAL_COUNT + 1;	
		if (s_READ_POINTER == s_READ_POINTER_temp)	
		   s_READ_POINTER = 'b0;			
	end

endmodule

`timescale 100ps / 1ps
module WRITE_POINTER_CTRL_V2 (GLOBAL_RST,WRITE_EN,WRITE_CLK,FULL_FLAG,WRITE_POINTER,TERMINAL_COUNT); 

	parameter WPOINTER_WIDTH = 9;
	parameter WDATA_WIDTH = 32;

	input GLOBAL_RST;
	input WRITE_EN;
	input WRITE_CLK;
	input FULL_FLAG;
	input [WPOINTER_WIDTH -1:0] TERMINAL_COUNT; 
	output [WPOINTER_WIDTH -1:0] WRITE_POINTER;

	reg [WPOINTER_WIDTH -1:0] s_WRITE_POINTER;
	reg [WPOINTER_WIDTH -1:0] s_WRITE_POINTER_temp; 


	assign WRITE_POINTER = s_WRITE_POINTER;

	initial	begin
		s_WRITE_POINTER = TERMINAL_COUNT;
	end
	
	always @(GLOBAL_RST)
	begin
		if (GLOBAL_RST == 1)
			assign s_WRITE_POINTER = TERMINAL_COUNT; 
		else
			deassign s_WRITE_POINTER;
	end

	always @(posedge WRITE_CLK)
	begin
		if (WRITE_EN == 1 && FULL_FLAG != 1)
			s_WRITE_POINTER = s_WRITE_POINTER + 1;

		s_WRITE_POINTER_temp = 	TERMINAL_COUNT + 1; 
		if(s_WRITE_POINTER == s_WRITE_POINTER_temp) 
			s_WRITE_POINTER = 'b0; 
	end

endmodule

`timescale 100ps / 1ps
module FLAG_LOGIC_V2 (GLOBAL_RST,FIFO_CAP,FIFO_PTR,FULL_D,EMPTY_D,AMFULL_D,AMEMPTY_D); 

	parameter WDATA_WIDTH = 32;
	parameter RDATA_WIDTH = 32;
	parameter AMFULL_X = 1;
	parameter AMEMPTY_Y = 1;
	parameter WADDR_WIDTH = 15;
	
	input GLOBAL_RST;
	input [WADDR_WIDTH+WDATA_WIDTH-1:0] FIFO_CAP; 	
	input [WADDR_WIDTH+WDATA_WIDTH-1:0] FIFO_PTR; 	

        output FULL_D;
	output EMPTY_D;
        output AMFULL_D;
	output AMEMPTY_D;

	reg FULL_D;
	reg EMPTY_D;
        reg AMFULL_D;
	reg AMEMPTY_D;

	integer FIFO_CAP_node;
	integer FIFO_PTR_node;
	
	initial begin
			FULL_D = 0;
			AMFULL_D = 0;
			EMPTY_D = 0;
			AMEMPTY_D = 0;
	end

	always @(GLOBAL_RST, FIFO_CAP, FIFO_PTR)
	begin
		FIFO_CAP_node = FIFO_CAP;
		FIFO_PTR_node = FIFO_PTR;
	
	
		if (GLOBAL_RST == 1)
			begin
				assign FULL_D = 0;
				assign AMFULL_D = 0;
				assign EMPTY_D = 0;
				assign AMEMPTY_D = 0;
			end

		else 
			begin
				deassign FULL_D;
				deassign AMFULL_D;
				deassign EMPTY_D;
				deassign AMEMPTY_D;

				if (FIFO_CAP_node - FIFO_PTR_node < WDATA_WIDTH)
					FULL_D = 1;
				else 
					FULL_D = 0;

				if (FIFO_CAP_node - FIFO_PTR_node < WDATA_WIDTH + AMFULL_X*WDATA_WIDTH)
					AMFULL_D = 1;
				else 
					AMFULL_D = 0;

				if (FIFO_PTR_node < RDATA_WIDTH)
					EMPTY_D = 0;
				else 
					EMPTY_D = 1;

				if (FIFO_PTR_node < RDATA_WIDTH + AMEMPTY_Y*RDATA_WIDTH)
					AMEMPTY_D = 0;
				else 
					AMEMPTY_D = 1;

			end
	end





endmodule

module SC_FIFO_V2_16K (WE,WCLK,RST,RPRST,RE,RCLK,FULLIN,EMPTYIN,DI,FULL,EMPTY,AMFULL,AMEMPTY,DO);
	parameter DEVICE_FAMILY = "SuperCool";
	parameter TERMINAL_COUNT = 511; 
	parameter WADDR_WIDTH = 9;		
	parameter WDATA_WIDTH = 32;		
	parameter RADDR_WIDTH = 8;		
	parameter RDATA_WIDTH = 64;		

	parameter ALMOST_FULL_X = 1;
	parameter ALMOST_EMPTY_Y = 1;

	input WE;
	input WCLK;
	input RST;
	input RPRST;
	input RE;
	input RCLK;
	input FULLIN;
	input EMPTYIN;
	input [WDATA_WIDTH -1:0] DI;	

	output FULL;
	output EMPTY;
	output AMFULL;
	output AMEMPTY;
	output [RDATA_WIDTH -1:0] DO;		

	wire WE_node;
	wire WCLK_node;
	wire RST_node;
	wire RPRST_node;
	wire RE_node;
	wire RCLK_node;
	wire FULLIN_node;
	wire EMPTYIN_node;
	wire [WDATA_WIDTH -1:0] DI_node;	
	reg  [WDATA_WIDTH -1:0] DI_reg;		

	reg  FULLIN_reg;
	reg  EMPTYIN_reg;

	wire FULL_node;
	wire EMPTY_node;
	wire AMFULL_node;
	wire AMEMPTY_node;
	wire [RDATA_WIDTH -1:0] DO_node;	

	reg  FULL_reg;
	reg  EMPTY_reg;
	reg  AMFULL_reg;
	reg  AMEMPTY_reg;
	reg  WE_reg;	
	reg  RE_reg;	
	reg  [WADDR_WIDTH - 1 : 0] TC_W_node;	
	reg  [RADDR_WIDTH - 1 : 0] TC_R_node;	

	wire [RADDR_WIDTH -1:0] RP_node;	
	wire [WADDR_WIDTH -1:0] WP_node;	

	//integer FIFO_capacity = (TERMINAL_COUNT+1)*WDATA_WIDTH;	
	//integer FIFO_pointer = 0;	
	//integer FIFO_PTR_WIDTH = WADDR_WIDTH +WDATA_WIDTH;

	integer FIFO_capacity ;	
	integer FIFO_pointer ;	
	integer FIFO_PTR_WIDTH ;
	reg [WADDR_WIDTH +WDATA_WIDTH-1 :0] FIFO_capacity_node;
	reg [WADDR_WIDTH +WDATA_WIDTH-1 :0] FIFO_pointer_node; 

        assign WE_node = WE;
	assign WCLK_node = WCLK;
	assign RST_node = RST;
	assign RPRST_node = RPRST;
	assign RE_node = RE;
	assign RCLK_node = RCLK;
	assign FULLIN_node = FULLIN;
	assign EMPTYIN_node = EMPTYIN;
	assign DI_node = DI;

	assign FULL = FULL_reg;
	assign AMFULL = AMFULL_reg;
	assign EMPTY = EMPTY_reg;
	assign AMEMPTY = AMEMPTY_reg;
	  
	assign DO = DO_node;    

      

	initial begin 
		FIFO_capacity = (TERMINAL_COUNT+1)*WDATA_WIDTH;	
		FIFO_pointer = 0;	
		FIFO_PTR_WIDTH = WADDR_WIDTH +WDATA_WIDTH;
		TC_W_node = TERMINAL_COUNT; 
		TC_R_node = (TERMINAL_COUNT+1)*WDATA_WIDTH/RDATA_WIDTH-1; 
		FIFO_capacity_node = FIFO_capacity;
	end
	
	always @(RST_node)
	begin
		if (RST_node == 1)
			begin
				assign DI_reg = 'b0;
				assign FULLIN_reg = 1'b0;
				assign EMPTYIN_reg = 1'b0;
				assign FULL_reg = 'b0;
				assign AMFULL_reg = 'b0;
				assign EMPTY_reg = 'b0;
				assign AMEMPTY_reg = 'b0;
				assign WE_reg = 'b0; 
				assign RE_reg = 'b0; 
				FIFO_pointer = 0; 
			end
		else
			begin
				deassign DI_reg;
				deassign FULLIN_reg;
				deassign EMPTYIN_reg;
				deassign FULL_reg;
				deassign AMFULL_reg;
				deassign EMPTY_reg;
				deassign AMEMPTY_reg;
				deassign WE_reg; 
				deassign RE_reg; 
			end
	end
		
	always @(posedge WCLK_node)
	begin
		DI_reg = DI_node;
		FULLIN_reg = FULLIN_node;
		FULL_reg = FULL_node;
		AMFULL_reg = AMFULL_node;
		WE_reg = WE_node & ~FULL_node; 
	end

	always @(posedge RCLK_node)
	begin
		EMPTYIN_reg = EMPTYIN_node;
		EMPTY_reg = EMPTY_node;
		AMEMPTY_reg = AMEMPTY_node;
		RE_reg = RE_node & EMPTY_node;
	end

// Set FIFO_pointer Nov.2002
	always @(posedge RPRST_node)
	begin
		if ( RST_node != 1 )
			begin
				FIFO_pointer = (WP_node + 1) * WDATA_WIDTH;
			end
		FIFO_pointer_node = FIFO_pointer;
	end

	always @(WP_node)
	begin       
		if ( RST_node != 1 && RPRST_node != 1 )
			FIFO_pointer = FIFO_pointer + WDATA_WIDTH;
		FIFO_pointer_node = FIFO_pointer;
	end

	always @(RP_node)
	begin
		if ( RST_node != 1 && RPRST_node != 1 )
			FIFO_pointer = FIFO_pointer - RDATA_WIDTH;

		FIFO_pointer_node = FIFO_pointer;
	end

// INSTANCE of READ_POINTER_CTRL_V2
	READ_POINTER_CTRL_V2 FIFO_RPC_INST(
						.GLOBAL_RST(RST_node),
						.RESET_RP(RPRST_node),
						.READ_EN(RE_node),
						.READ_CLK(RCLK_node),
						.EMPTY_FLAG(EMPTY_node),
						.READ_POINTER(RP_node),
						.TERMINAL_COUNT(TC_R_node)
						); // 071102
	defparam FIFO_RPC_INST.RPOINTER_WIDTH = RADDR_WIDTH;

// INSTANCE of WRITE_POINTER_CTRL_V2
	WRITE_POINTER_CTRL_V2 FIFO_WPC_INST(
						.GLOBAL_RST(RST_node),
						.WRITE_EN(WE_node),
						.WRITE_CLK(WCLK_node),
						.FULL_FLAG(FULL_node),
						.WRITE_POINTER(WP_node),
						.TERMINAL_COUNT(TC_W_node)
						); // 071102

	defparam FIFO_WPC_INST.WPOINTER_WIDTH = WADDR_WIDTH;
	defparam FIFO_WPC_INST.WDATA_WIDTH = WDATA_WIDTH;

// INSTANCE of FLAG_LOGIC_V2
	FLAG_LOGIC_V2 FIFO_FL_INST(	
					.GLOBAL_RST(RST_node),
					.FIFO_CAP(FIFO_capacity_node),
					.FIFO_PTR(FIFO_pointer_node),
					.FULL_D(FULL_node),
					.EMPTY_D(EMPTY_node),
					.AMFULL_D(AMFULL_node),
					.AMEMPTY_D(AMEMPTY_node)
					); 

	defparam FIFO_FL_INST.WDATA_WIDTH = WDATA_WIDTH;
	defparam FIFO_FL_INST.RDATA_WIDTH = RDATA_WIDTH;
	defparam FIFO_FL_INST.AMFULL_X = ALMOST_FULL_X;
	defparam FIFO_FL_INST.AMEMPTY_Y = ALMOST_EMPTY_Y;
	defparam FIFO_FL_INST.WADDR_WIDTH = WADDR_WIDTH;
// INSTANCE of SC_BRAM_16K
	SC_BRAM_16K FIFO_BRAM_INST(
					.WADA(WP_node),
					.WEA(WE_reg),
					.WDA(DI_reg),
					.RADA(RP_node),
					.REA(RE_reg), 
					.RDA(DO_node),
					.WADB(WP_node),
					.WEB(1'b0),
					.WDB(DI_reg),
					.RADB(RP_node),
					.REB(1'b0),
					.RDB()
					); 

	defparam FIFO_BRAM_INST.WADDR_WIDTH_A  = WADDR_WIDTH;
	defparam FIFO_BRAM_INST.RADDR_WIDTH_A  = RADDR_WIDTH;
	defparam FIFO_BRAM_INST.WADDR_WIDTH_B  = WADDR_WIDTH;
	defparam FIFO_BRAM_INST.RADDR_WIDTH_B  = RADDR_WIDTH;
	defparam FIFO_BRAM_INST.WDATA_WIDTH_A  = WDATA_WIDTH;
	defparam FIFO_BRAM_INST.RDATA_WIDTH_A  = RDATA_WIDTH;
	defparam FIFO_BRAM_INST.WDATA_WIDTH_B  = WDATA_WIDTH;
	defparam FIFO_BRAM_INST.RDATA_WIDTH_B  = RDATA_WIDTH;   
	defparam FIFO_BRAM_INST.MEM_INIT_FILE = "";
	defparam FIFO_BRAM_INST.MEM_INIT_FLAG = 0;

endmodule

`endcelldefine

`celldefine

`timescale 1ns / 100ps
module SC_PDPRAM_16K (WCEN,WCLK,WE,WCS,RCLK,RCEN,RST,WD,WAD,RAD,RD);

	parameter DEVICE_FAMILY = "SuperCool";
	parameter WADDR_WIDTH =	13;
	parameter WDATA_WIDTH =	2;
	parameter RADDR_WIDTH =	13;
	parameter RDATA_WIDTH =	2;
	parameter MEM_INIT_FILE = "";
	parameter MEM_INIT_FLAG = 0;

	input	WCEN;
	input	WCLK;
	input	WE;
	input	[1:0] WCS;
	input	RCLK;
	input	RCEN;
	input  	RST;

	input	[WDATA_WIDTH -1:0] WD;
	input	[WADDR_WIDTH -1:0] WAD;
	input	[RADDR_WIDTH -1:0] RAD;
	output	[RDATA_WIDTH -1:0] RD;
	

	wire WCEN_node;
	wire WCLK_node;
	wire WE_node;
	wire [1:0] WCS_node;
	wire RCEN_node;
	wire RCLK_node;
	wire RST_node;
	wire [WDATA_WIDTH -1:0] WD_node;
	wire [WADDR_WIDTH -1:0] WAD_node;
	wire [RDATA_WIDTH -1:0] RD_node;
	wire [RADDR_WIDTH -1:0] RAD_node; 
	

	reg [WDATA_WIDTH -1:0] WD_reg;
	reg [WADDR_WIDTH -1:0] WAD_reg;
	reg [RADDR_WIDTH -1:0] RAD_reg;

	reg EN_reg;
	integer i;
	reg REN_reg;

	SC_BRAM_PDP_16K hInstance(.WEA(EN_reg),.REA(REN_reg),.WEB(1'b0),.REB(1'b0),.WADA(WAD_reg),.WDA(WD_reg),
			.RADA(RAD_reg),.RDA(RD_node),.WADB(WAD_reg),.WDB(WD_reg),.RADB(RAD_reg),.RDB());

	defparam hInstance.WADDR_WIDTH_A = WADDR_WIDTH;
	defparam hInstance.RADDR_WIDTH_A = RADDR_WIDTH;
	defparam hInstance.WADDR_WIDTH_B = WADDR_WIDTH;
	defparam hInstance.RADDR_WIDTH_B = RADDR_WIDTH;
	defparam hInstance.WDATA_WIDTH_A = WDATA_WIDTH;
	defparam hInstance.RDATA_WIDTH_A = RDATA_WIDTH;
	defparam hInstance.WDATA_WIDTH_B = WDATA_WIDTH;
	defparam hInstance.RDATA_WIDTH_B = RDATA_WIDTH;
	defparam hInstance.MEM_INIT_FILE = MEM_INIT_FILE;
	defparam hInstance.MEM_INIT_FLAG = MEM_INIT_FLAG;
//	defparam hInstance.ARRAY_SIZE;

	assign WCEN_node = WCEN;
	assign WCLK_node = WCLK;
	assign WE_node   = WE;
	assign WCS_node  = WCS;
	assign RCEN_node = RCEN;
	assign RCLK_node = RCLK;
	assign RST_node  = RST;
	assign WD_node   = WD;
	assign WAD_node  = WAD;
	assign RAD_node  = RAD;
	assign RD = RD_node;

        initial REN_reg = 1;

	always @(RST_node)
	begin
		if (RST_node == 1)
			begin
				assign WD_reg = 0;
				assign WAD_reg = 0;
				assign RAD_reg = 0;
				assign EN_reg = 0;
				assign REN_reg = 1;
			end
		else
			begin
				deassign WD_reg;
				deassign WAD_reg;
				deassign RAD_reg;
				deassign EN_reg;
				deassign REN_reg;
			end
	end


	always @(posedge WCLK_node)
		      if (WCEN_node == 1)
			begin
				WD_reg = WD_node;
				WAD_reg = WAD_node;
				EN_reg = WE_node & WCS_node[0] & WCS_node[1];			         
			end

	always @(posedge RCLK_node)
		begin
		      if (RCEN_node == 1)
                        begin
			  RAD_reg = RAD_node;
                          //REN_reg = 1;
                          REN_reg = WCS_node[0] & WCS_node[1];
                        end
		end

			
endmodule

`endcelldefine

`celldefine

`timescale 1ns / 100ps
module SC_PDPRAM_16K_L (WCEN,WCLK,WE,WCS,RCLK,RCEN,RST,WD,WAD,RAD,RD);

	parameter DEVICE_FAMILY = "SuperCool";
	parameter WADDR_WIDTH =	13;
	parameter WDATA_WIDTH =	2;
	parameter RADDR_WIDTH =	13;
	parameter RDATA_WIDTH =	2;
	parameter ARRAY_SIZE = 16384; 
	parameter MEM_INIT_FILE = "";
	parameter MEM_INIT_FLAG = 1;

	input	WCEN;
	input	WCLK;
	input	WE;
	input	[1:0] WCS;
	input	RCLK;
	input	RCEN;
	input  	RST;

	input	[WDATA_WIDTH -1:0] WD;
	input	[WADDR_WIDTH -1:0] WAD;
	input	[RADDR_WIDTH -1:0] RAD;
	output	[RDATA_WIDTH -1:0] RD;
	

	wire WCEN_node;
	wire WCLK_node;
	wire WE_node;
	wire [1:0] WCS_node;
	wire RCEN_node;
	wire RCLK_node;
	wire RST_node;
	wire [WDATA_WIDTH -1:0] WD_node;
	wire [WADDR_WIDTH -1:0] WAD_node;
	wire [RDATA_WIDTH -1:0] RD_node;
	wire [RADDR_WIDTH -1:0] RAD_node; 
	

	reg [WDATA_WIDTH -1:0] WD_reg;
	reg [WADDR_WIDTH -1:0] WAD_reg;
	reg [RADDR_WIDTH -1:0] RAD_reg;
	reg EN_reg;
	integer i;
	reg REN_reg;

	SC_BRAM_PDP_16K_L hInstance(.WEA(EN_reg),.REA(REN_reg),.WEB(1'b0),.REB(1'b0),.WADA(WAD_reg),.WDA(WD_reg),
			.RADA(RAD_reg),.RDA(RD_node),.WADB(WAD_reg),.WDB(WD_reg),.RADB(RAD_reg),.RDB());

	defparam hInstance.WADDR_WIDTH_A = WADDR_WIDTH;
	defparam hInstance.RADDR_WIDTH_A = RADDR_WIDTH;
	defparam hInstance.WADDR_WIDTH_B = WADDR_WIDTH;
	defparam hInstance.RADDR_WIDTH_B = RADDR_WIDTH;
	defparam hInstance.WDATA_WIDTH_A = WDATA_WIDTH;
	defparam hInstance.RDATA_WIDTH_A = RDATA_WIDTH;
	defparam hInstance.WDATA_WIDTH_B = WDATA_WIDTH;
	defparam hInstance.RDATA_WIDTH_B = RDATA_WIDTH;
	defparam hInstance.ARRAY_SIZE =  ARRAY_SIZE;
	defparam hInstance.MEM_INIT_FILE = MEM_INIT_FILE;
	defparam hInstance.MEM_INIT_FLAG = MEM_INIT_FLAG;

	assign WCEN_node = WCEN;
	assign WCLK_node = WCLK;
	assign WE_node   = WE;
	assign WCS_node  = WCS;
	assign RCEN_node = RCEN;
	assign RCLK_node = RCLK;
	assign RST_node  = RST;
	assign WD_node   = WD;
	assign WAD_node  = WAD;
	assign RAD_node  = RAD;
	assign RD = RD_node;

        initial REN_reg = 1;

	always @(RST_node)
	begin
		if (RST_node == 1)
			begin
				assign WD_reg = 0;
				assign WAD_reg = 0;
				assign RAD_reg = 0;
				assign EN_reg = 0;
				assign REN_reg = 1;
			end
		else
			begin
				deassign WD_reg;
				deassign WAD_reg;
				deassign RAD_reg;
				deassign EN_reg;
				deassign REN_reg;
			end
	end


	always @(posedge WCLK_node)
		      if (WCEN_node == 1)
			begin
				WD_reg = WD_node;
				WAD_reg = WAD_node;
				EN_reg = WE_node & WCS_node[0] & WCS_node[1];		                 
			end

	always @(posedge RCLK_node)
		begin
		      if (RCEN_node == 1)
                        begin
			  RAD_reg = RAD_node;
                          //REN_reg = 1;
                          REN_reg = WCS_node[0] & WCS_node[1];
                        end
		end

			
endmodule

`endcelldefine

`celldefine

`timescale 1ns / 100ps
module SC_PDPRAMA_16K (WCEN,WCLK,WE,WCS,/*RCLK,RCEN,*/RST,WD,WAD,RAD,RD);

	parameter DEVICE_FAMILY = "SuperCool";
	parameter WADDR_WIDTH =	13;
	parameter WDATA_WIDTH =	2;
	parameter RADDR_WIDTH =	13;
	parameter RDATA_WIDTH =	2;
	parameter MEM_INIT_FILE = "";
	parameter MEM_INIT_FLAG = 0;

	input	WCEN;
	input	WCLK;
	input	WE;
	input	[1:0] WCS;
//	input	RCLK;
//	input	RCEN;
	input  	RST;

	input	[WDATA_WIDTH -1:0] WD;
	input	[WADDR_WIDTH -1:0] WAD;
	input	[RADDR_WIDTH -1:0] RAD;
	output	[RDATA_WIDTH -1:0] RD;
	

	wire WCEN_node;
	wire WCLK_node;
	wire WE_node;
	wire [1:0] WCS_node;
//	wire RCEN_node;
//	wire RCLK_node;
	wire RST_node;
	wire [WDATA_WIDTH -1:0] WD_node;
	wire [WADDR_WIDTH -1:0] WAD_node;
	wire [RDATA_WIDTH -1:0] RD_node;
	wire [RADDR_WIDTH -1:0] RAD_node; 
	

	reg [WDATA_WIDTH -1:0] WD_reg;
	reg [WADDR_WIDTH -1:0] WAD_reg;
	reg [RADDR_WIDTH -1:0] RAD_reg;
	reg EN_reg;
	integer i;
        reg REN_reg;

	
	SC_BRAM_PDP_16K hInstance(.WEA(EN_reg),.REA(REN_reg),.WEB(1'b0),.REB(1'b0),.WADA(WAD_reg),.WDA(WD_reg),
			.RADA(RAD_node),.RDA(RD_node),.WADB(WAD_reg),.WDB(WD_reg),.RADB(RAD_node),.RDB());

	defparam hInstance.WADDR_WIDTH_A = WADDR_WIDTH;
	defparam hInstance.RADDR_WIDTH_A = RADDR_WIDTH;
	defparam hInstance.WADDR_WIDTH_B = WADDR_WIDTH;
	defparam hInstance.RADDR_WIDTH_B = RADDR_WIDTH;
	defparam hInstance.WDATA_WIDTH_A = WDATA_WIDTH;
	defparam hInstance.RDATA_WIDTH_A = RDATA_WIDTH;
	defparam hInstance.WDATA_WIDTH_B = WDATA_WIDTH;
	defparam hInstance.RDATA_WIDTH_B = RDATA_WIDTH;
	defparam hInstance.MEM_INIT_FILE = MEM_INIT_FILE;
	defparam hInstance.MEM_INIT_FLAG = MEM_INIT_FLAG;
//	defparam hInstance.ARRAY_SIZE;

	assign WCEN_node = WCEN;
	assign WCLK_node = WCLK;
	assign WE_node   = WE;
	assign WCS_node  = WCS;
//	assign RCEN_node = RCEN;
//	assign RCLK_node = RCLK;
	assign RST_node  = RST;
	assign WD_node   = WD;
	assign WAD_node  = WAD;
	assign RAD_node  = RAD;
	assign RD = RD_node;

        initial REN_reg = 1;

	always @(RST_node)
	begin
		if (RST_node == 1)
			begin
				assign WD_reg = 0;
				assign WAD_reg = 0;
				assign RAD_reg = 0;
				assign EN_reg = 0;
				assign REN_reg = 1;
			end
		else
			begin
				deassign WD_reg;
				deassign WAD_reg;
				deassign RAD_reg;
				deassign EN_reg;
				deassign REN_reg;
			end
	end


	always @(posedge WCLK_node)
		      if (WCEN_node == 1)
			begin
				WD_reg = WD_node;
				WAD_reg = WAD_node;
				EN_reg = WE_node & WCS_node[0] & WCS_node[1];
				//REN_reg = 1; 
			end
/*
	always @(posedge RCLK_node)
		begin
		      if (RCEN_node == 1)
			  RAD_reg = RAD_node;
		end
*/			
endmodule

`endcelldefine

`celldefine

`timescale 1ns / 100ps
module SC_PDPRAMA_16K_L (WCEN,WCLK,WE,WCS,/*RCLK,RCEN,*/RST,WD,WAD,RAD,RD);

	parameter DEVICE_FAMILY = "SuperCool";
	parameter WADDR_WIDTH =	13;
	parameter WDATA_WIDTH =	2;
	parameter RADDR_WIDTH =	13;
	parameter RDATA_WIDTH =	2;
	parameter ARRAY_SIZE = 16384; 
	parameter MEM_INIT_FILE = "";
	parameter MEM_INIT_FLAG = 1;

	input	WCEN;
	input	WCLK;
	input	WE;
	input	[1:0] WCS;
//	input	RCLK;
//	input	RCEN;
	input  	RST;

	input	[WDATA_WIDTH -1:0] WD;
	input	[WADDR_WIDTH -1:0] WAD;
	input	[RADDR_WIDTH -1:0] RAD;
	output	[RDATA_WIDTH -1:0] RD;
	

	wire WCEN_node;
	wire WCLK_node;
	wire WE_node;
	wire [1:0] WCS_node;
//	wire RCEN_node;
//	wire RCLK_node;
	wire RST_node;
	wire [WDATA_WIDTH -1:0] WD_node;
	wire [WADDR_WIDTH -1:0] WAD_node;
	wire [RDATA_WIDTH -1:0] RD_node;
	wire [RADDR_WIDTH -1:0] RAD_node; 
	

	reg [WDATA_WIDTH -1:0] WD_reg;
	reg [WADDR_WIDTH -1:0] WAD_reg;
	reg [RADDR_WIDTH -1:0] RAD_reg;
	reg EN_reg;
	integer i;
        reg REN_reg;

	
	SC_BRAM_PDP_16K_L hInstance(.WEA(EN_reg),.REA(REN_reg),.WEB(1'b0),.REB(1'b0),.WADA(WAD_reg),.WDA(WD_reg),
			.RADA(RAD_node),.RDA(RD_node),.WADB(WAD_reg),.WDB(WD_reg),.RADB(RAD_node),.RDB());

	defparam hInstance.WADDR_WIDTH_A = WADDR_WIDTH;
	defparam hInstance.RADDR_WIDTH_A = RADDR_WIDTH;
	defparam hInstance.WADDR_WIDTH_B = WADDR_WIDTH;
	defparam hInstance.RADDR_WIDTH_B = RADDR_WIDTH;
	defparam hInstance.WDATA_WIDTH_A = WDATA_WIDTH;
	defparam hInstance.RDATA_WIDTH_A = RDATA_WIDTH;
	defparam hInstance.WDATA_WIDTH_B = WDATA_WIDTH;
	defparam hInstance.RDATA_WIDTH_B = RDATA_WIDTH;
	defparam hInstance.MEM_INIT_FILE = MEM_INIT_FILE;
	defparam hInstance.MEM_INIT_FLAG = MEM_INIT_FLAG;
	defparam hInstance.ARRAY_SIZE    = ARRAY_SIZE;

	assign WCEN_node = WCEN;
	assign WCLK_node = WCLK;
	assign WE_node   = WE;
	assign WCS_node  = WCS;
//	assign RCEN_node = RCEN;
//	assign RCLK_node = RCLK;
	assign RST_node  = RST;
	assign WD_node   = WD;
	assign WAD_node  = WAD;
	assign RAD_node  = RAD;
	assign RD = RD_node;

        initial REN_reg = 1;

	always @(RST_node)
	begin
		if (RST_node == 1)
			begin
				assign WD_reg = 0;
				assign WAD_reg = 0;
				assign RAD_reg = 0;
				assign EN_reg = 0;
				assign REN_reg = 1;
			end
		else
			begin
				deassign WD_reg;
				deassign WAD_reg;
				deassign RAD_reg;
				deassign EN_reg;
				deassign REN_reg;
			end
	end


	always @(posedge WCLK_node)
		      if (WCEN_node == 1)
			begin
				WD_reg = WD_node;
				WAD_reg = WAD_node;
				EN_reg = WE_node & WCS_node[0] & WCS_node[1];
				//REN_reg = 1; 
			end
/*
	always @(posedge RCLK_node)
		begin
		      if (RCEN_node == 1)
			  RAD_reg = RAD_node;
		end
*/			
endmodule

`endcelldefine

`celldefine

`timescale 1ns / 100ps
module SC_SPRAM_16K (CEN,CLK,WR,CS,RST,DI,AD,DO);

	parameter DEVICE_FAMILY = "SuperCool";
	parameter ADDR_WIDTH = 13;   // 8K
	parameter DATA_WIDTH = 2;    // 2 bits	
	parameter MEM_INIT_FILE = "";
	parameter MEM_INIT_FLAG = 1;

	input CEN,CLK,WR,RST;
	input [1:0] CS;
	input [DATA_WIDTH-1:0] DI;
	input [ADDR_WIDTH-1:0] AD;
	output [DATA_WIDTH-1:0] DO;

	wire CEN_node;
	wire CLK_node;
	wire WR_node;
	wire [1:0] CS_node;
	wire RST_node;
	wire [DATA_WIDTH-1:0] DI_node;
	wire [ADDR_WIDTH-1:0] AD_node;
	wire [DATA_WIDTH-1:0] DO_node;

	reg [DATA_WIDTH-1:0] DI_reg;
	reg [ADDR_WIDTH-1:0] AD_reg;
	reg EN_reg;
	integer i;
        reg REN_reg;


	SC_BRAM_16K hInstance(.WEA(EN_reg),.REA(REN_reg),.WEB(1'b0),.REB(1'b0),.WADA(AD_reg),.WDA(DI_reg),
			.RADA(AD_reg),.RDA(DO_node),.WADB(AD_reg),.WDB(DI_reg),.RADB(AD_reg),.RDB());
//	defparam hInstance.ADDR_WIDTH = 13;
//	defparam hInstance.DATA_WIDTH=2;

	defparam hInstance.WADDR_WIDTH_A = ADDR_WIDTH;
	defparam hInstance.RADDR_WIDTH_A = ADDR_WIDTH;
	defparam hInstance.WADDR_WIDTH_B = ADDR_WIDTH;
	defparam hInstance.RADDR_WIDTH_B = ADDR_WIDTH;
	defparam hInstance.WDATA_WIDTH_A = DATA_WIDTH;
	defparam hInstance.RDATA_WIDTH_A = DATA_WIDTH;
	defparam hInstance.WDATA_WIDTH_B = DATA_WIDTH;
	defparam hInstance.RDATA_WIDTH_B = DATA_WIDTH;
	defparam hInstance.ARRAY_SIZE =  16384;
	defparam hInstance.MEM_INIT_FILE = MEM_INIT_FILE;
	defparam hInstance.MEM_INIT_FLAG = MEM_INIT_FLAG;


	assign  CEN_node = CEN;
	assign  CLK_node = CLK;
	assign  WR_node  = WR;
	assign  CS_node  = CS;
	assign  RST_node = RST;
	assign  DI_node  = DI;
	assign  AD_node  = AD;
	assign  DO = DO_node;  // output added by allenfei (VHDL source may be absent)
	
	initial	begin
		DI_reg = 'b0;
		AD_reg = 'b0;
		EN_reg = 'b0;
		REN_reg = 'b1;
	end
	
	always @(RST_node)
		begin
			if (RST_node == 1)
				begin	
					assign DI_reg = 'b0;
					assign AD_reg = 'b0;
					assign EN_reg = 'b0;
					assign REN_reg = 'b1;
				end
			else
				begin
					deassign DI_reg;
					deassign AD_reg;
					deassign EN_reg;
					deassign REN_reg;
				end
		
		end
	
	always @(posedge CLK_node)
	begin
		if (CEN_node == 1)
		  begin
			DI_reg = DI_node;
			AD_reg = AD_node;
			EN_reg = WR_node  & CS_node[0] & CS_node[1];
			//REN_reg = 'b1; 
			REN_reg = CS_node[0] & CS_node[1];
		  end
	end

		
endmodule



`endcelldefine

`celldefine

`timescale 1ns / 100ps
module SC_SPRAM_16K_L (CEN,CLK,WR,CS,RST,DI,AD,DO);

	parameter DEVICE_FAMILY = "SuperCool";
	parameter ADDR_WIDTH = 13;   // 8K
	parameter DATA_WIDTH = 2;    // 2 bits	
	parameter ARRAY_SIZE = 16384;    // 2 bits	
	parameter MEM_INIT_FILE = "";
	parameter MEM_INIT_FLAG = 1;

	input CEN,CLK,WR,RST;
	input [1:0] CS;
	input [DATA_WIDTH-1:0] DI;
	input [ADDR_WIDTH-1:0] AD;
	output [DATA_WIDTH-1:0] DO;

	wire CEN_node;
	wire CLK_node;
	wire WR_node;
	wire [1:0] CS_node;
	wire RST_node;
	wire [DATA_WIDTH-1:0] DI_node;
	wire [ADDR_WIDTH-1:0] AD_node;
	wire [DATA_WIDTH-1:0] DO_node;

	reg [DATA_WIDTH-1:0] DI_reg;
	reg [ADDR_WIDTH-1:0] AD_reg;
	reg EN_reg;
	integer i;
        reg REN_reg;


	SC_BRAM_16K_L hInstance(.WEA(EN_reg),.REA(REN_reg),.WEB(1'b0),.REB(1'b0),.WADA(AD_reg),.WDA(DI_reg),
			.RADA(AD_reg),.RDA(DO_node),.WADB(AD_reg),.WDB(DI_reg),.RADB(AD_reg),.RDB());
//	defparam hInstance.ADDR_WIDTH = 13;
//	defparam hInstance.DATA_WIDTH=2;

	defparam hInstance.WADDR_WIDTH_A = ADDR_WIDTH;
	defparam hInstance.RADDR_WIDTH_A = ADDR_WIDTH;
	defparam hInstance.WADDR_WIDTH_B = ADDR_WIDTH;
	defparam hInstance.RADDR_WIDTH_B = ADDR_WIDTH;
	defparam hInstance.WDATA_WIDTH_A = DATA_WIDTH;
	defparam hInstance.RDATA_WIDTH_A = DATA_WIDTH;
	defparam hInstance.WDATA_WIDTH_B = DATA_WIDTH;
	defparam hInstance.RDATA_WIDTH_B = DATA_WIDTH;
	defparam hInstance.ARRAY_SIZE =  ARRAY_SIZE;
	defparam hInstance.MEM_INIT_FILE = MEM_INIT_FILE;
	defparam hInstance.MEM_INIT_FLAG = MEM_INIT_FLAG;


	assign  CEN_node = CEN;
	assign  CLK_node = CLK;
	assign  WR_node  = WR;
	assign  CS_node  = CS;
	assign  RST_node = RST;
	assign  DI_node  = DI;
	assign  AD_node  = AD;
	assign  DO = DO_node;  // output added by allenfei (VHDL source may be absent)
	
	initial	begin
		DI_reg = 'b0;
		AD_reg = 'b0;
		EN_reg = 'b0;
		REN_reg = 'b1;
	end
	
	always @(RST_node)
		begin
			if (RST_node == 1)
				begin	
					assign DI_reg = 'b0;
					assign AD_reg = 'b0;
					assign EN_reg = 'b0;
					assign REN_reg = 'b1;
				end
			else
				begin
					deassign DI_reg;
					deassign AD_reg;
					deassign EN_reg;
					deassign REN_reg;
				end
		
		end
	
	always @(posedge CLK_node)
	begin
		if (CEN_node == 1)
		  begin
			DI_reg = DI_node;
			AD_reg = AD_node;
			EN_reg = WR_node  & CS_node[0] & CS_node[1];
			//REN_reg = 'b1; 
			REN_reg = CS_node[0] & CS_node[1]; 
		  end
	end

		
endmodule



`endcelldefine

`celldefine

`timescale 1ns / 100ps
module SC_SPRAMA_16K (CEN,CLK,WR,CS,RST,DI,AD,DO);

	parameter DEVICE_FAMILY = "SuperCool";
	parameter ADDR_WIDTH = 13;   // 8K
	parameter DATA_WIDTH = 2;    // 2 bits	
	parameter MEM_INIT_FILE = "";
	parameter MEM_INIT_FLAG = 0;

	input CEN,CLK,WR,RST;
	input [1:0] CS;
	input [DATA_WIDTH-1:0] DI;
	input [ADDR_WIDTH-1:0] AD;
	output [DATA_WIDTH-1:0] DO;

	wire CEN_node;
	wire CLK_node;
	wire WR_node;
	wire [1:0] CS_node;
	wire RST_node;
	wire [DATA_WIDTH-1:0] DI_node;
	wire [ADDR_WIDTH-1:0] AD_node;
	wire [DATA_WIDTH-1:0] DO_node;

	reg [DATA_WIDTH-1:0] DI_reg;
	reg [ADDR_WIDTH-1:0] AD_reg;
	reg EN_reg;
	integer i;
        reg REN_reg;

	SC_BRAM_16K hInstance(.WEA(EN_reg),.REA(REN_reg),.WEB(1'b0),.REB(1'b0),.WADA(AD_reg),.WDA(DI_reg),
			.RADA(AD_node),.RDA(DO_node),.WADB(AD_node),.WDB(DI_reg),.RADB(AD_reg),.RDB());
//	defparam hInstance.ADDR_WIDTH = 13;
//	defparam hInstance.DATA_WIDTH=2;

	defparam hInstance.WADDR_WIDTH_A = ADDR_WIDTH;
	defparam hInstance.RADDR_WIDTH_A = ADDR_WIDTH;
	defparam hInstance.WADDR_WIDTH_B = ADDR_WIDTH;
	defparam hInstance.RADDR_WIDTH_B = ADDR_WIDTH;
	defparam hInstance.WDATA_WIDTH_A = DATA_WIDTH;
	defparam hInstance.RDATA_WIDTH_A = DATA_WIDTH;
	defparam hInstance.WDATA_WIDTH_B = DATA_WIDTH;
	defparam hInstance.RDATA_WIDTH_B = DATA_WIDTH;
	defparam hInstance.ARRAY_SIZE = 16384;
	defparam hInstance.MEM_INIT_FILE = MEM_INIT_FILE;
	defparam hInstance.MEM_INIT_FLAG = MEM_INIT_FLAG;


	assign  CEN_node = CEN;
	assign  CLK_node = CLK;
	assign  WR_node  = WR;
	assign  CS_node  = CS;
	assign  RST_node = RST;
	assign  DI_node  = DI;
	assign  AD_node  = AD;
	assign  DO = DO_node;  // output added by allenfei (VHDL source may be absent)
	
	initial	begin
		DI_reg = 'b0;
		AD_reg = 'b0;
		EN_reg = 'b0;
		REN_reg = 'b1;
	end
	
	always @(RST_node)
		begin
			if (RST_node == 1)
				begin	
					assign DI_reg = 'b0;
					assign AD_reg = 'b0;
					assign EN_reg = 'b0;
					assign REN_reg = 'b1;
				end
			else
				begin
					deassign DI_reg;
					deassign AD_reg;
					deassign EN_reg;
					deassign REN_reg;
				end
		
		end
	
	always @(posedge CLK_node)
	begin
		if (CEN_node == 1)
		  begin
			DI_reg = DI_node;
			AD_reg = AD_node;
			EN_reg = WR_node  & CS_node[0] & CS_node[1];
                        //REN_reg = 'b1;
		  end
	end

		
endmodule



`endcelldefine

`celldefine

`timescale 1ns / 100ps
module SC_SPRAMA_16K_L (CEN,CLK,WR,CS,RST,DI,AD,DO);

	parameter DEVICE_FAMILY = "SuperCool";
	parameter ADDR_WIDTH = 13;   // 8K
	parameter DATA_WIDTH = 2;    // 2 bits	
	parameter ARRAY_SIZE = 16384; 
	parameter MEM_INIT_FILE = "";
	parameter MEM_INIT_FLAG = 1;

	input CEN,CLK,WR,RST;
	input [1:0] CS;
	input [DATA_WIDTH-1:0] DI;
	input [ADDR_WIDTH-1:0] AD;
	output [DATA_WIDTH-1:0] DO;

	wire CEN_node;
	wire CLK_node;
	wire WR_node;
	wire [1:0] CS_node;
	wire RST_node;
	wire [DATA_WIDTH-1:0] DI_node;
	wire [ADDR_WIDTH-1:0] AD_node;
	wire [DATA_WIDTH-1:0] DO_node;

	reg [DATA_WIDTH-1:0] DI_reg;
	reg [ADDR_WIDTH-1:0] AD_reg;
	reg EN_reg;
	integer i;
        reg REN_reg;

	SC_BRAM_16K_L hInstance(.WEA(EN_reg),.REA(REN_reg),.WEB(1'b0),.REB(1'b0),.WADA(AD_reg),.WDA(DI_reg),
			.RADA(AD_node),.RDA(DO_node),.WADB(AD_node),.WDB(DI_reg),.RADB(AD_node),.RDB());
//	defparam hInstance.ADDR_WIDTH = 13;
//	defparam hInstance.DATA_WIDTH=2;

	defparam hInstance.WADDR_WIDTH_A = ADDR_WIDTH;
	defparam hInstance.RADDR_WIDTH_A = ADDR_WIDTH;
	defparam hInstance.WADDR_WIDTH_B = ADDR_WIDTH;
	defparam hInstance.RADDR_WIDTH_B = ADDR_WIDTH;
	defparam hInstance.WDATA_WIDTH_A = DATA_WIDTH;
	defparam hInstance.RDATA_WIDTH_A = DATA_WIDTH;
	defparam hInstance.WDATA_WIDTH_B = DATA_WIDTH;
	defparam hInstance.RDATA_WIDTH_B = DATA_WIDTH;
	defparam hInstance.ARRAY_SIZE    = ARRAY_SIZE;
	defparam hInstance.MEM_INIT_FILE = MEM_INIT_FILE;
	defparam hInstance.MEM_INIT_FLAG = MEM_INIT_FLAG;


	assign  CEN_node = CEN;
	assign  CLK_node = CLK;
	assign  WR_node  = WR;
	assign  CS_node  = CS;
	assign  RST_node = RST;
	assign  DI_node  = DI;
	assign  AD_node  = AD;
	assign  DO = DO_node;  // output added by allenfei (VHDL source may be absent)

	
	initial	
        begin
		DI_reg = 'b0;
		AD_reg = 'b0;
		EN_reg = 'b0;
		REN_reg = 'b1;

	end
	
	always @(RST_node)
		begin
			if (RST_node == 1)
				begin	
					assign DI_reg = 'b0;
					assign AD_reg = 'b0;
					assign EN_reg = 'b0;
					assign REN_reg = 'b1;
				end
			else
				begin
					deassign DI_reg;
					deassign AD_reg;
					deassign EN_reg;
					deassign REN_reg;
				end
		
		end
	
	always @(posedge CLK_node)
	begin
		if (CEN_node == 1)
		  begin
			DI_reg = DI_node;
			AD_reg = AD_node;
			EN_reg = WR_node  & CS_node[0] & CS_node[1];
                        //REN_reg = 'b1;
		  end
	end

		
endmodule



`endcelldefine

`celldefine
module RAMB16K_WX1_RX1(WCEN,WCLK,WCS0,WCS1,WE,
                    RCEN,RCLK,RST,
                    WD0,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,WAD13,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,RAD13,
                    RD0
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RCEN,RCLK,RST;
input  WD0;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,WAD13;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,RAD13;

output  RD0;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [13:0] wad;
wire [13:0] rad;
wire [1:0]  wcs;
wire RD0_node;

reg notifier;

assign wad = {WAD13,WAD12,WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD13,RAD12,RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};

defparam RAM_U0.WADDR_WIDTH=14;
defparam RAM_U0.WDATA_WIDTH=1;
defparam RAM_U0.RADDR_WIDTH=14;
defparam RAM_U0.RDATA_WIDTH=1;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(WD0),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(RD0_node));		
					  
buf INSXQ (RD0,RD0_node);					  
specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WD0, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);
	$setuphold  (posedge WCLK, WAD12, 1, 0);
	$setuphold  (posedge WCLK, WAD13, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);
	$setuphold  (posedge RCLK, RAD10, 1, 0);
	$setuphold  (posedge RCLK, RAD11, 1, 0);
	$setuphold  (posedge RCLK, RAD12, 1, 0);
	$setuphold  (posedge RCLK, RAD13, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RST  => RD0) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16K_WX1_RX2(WCEN,WCLK,WCS0,WCS1,WE,
                    RCEN,RCLK,RST,
                    WD0,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,WAD13,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,
                    RD0,RD1
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RCEN,RCLK,RST;
input  WD0;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,WAD13;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12;

output  RD0,RD1;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [13:0] wad;
wire [12:0]  rad;
wire [1:0]  wcs;
wire [1:0] rd;

reg notifier;

assign wad = {WAD13,WAD12,WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD12,RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
//assign {RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);

defparam RAM_U0.WADDR_WIDTH=14;
defparam RAM_U0.WDATA_WIDTH=1;
defparam RAM_U0.RADDR_WIDTH=13;
defparam RAM_U0.RDATA_WIDTH=2;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(WD0),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WD0, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);
	$setuphold  (posedge WCLK, WAD12, 1, 0);
	$setuphold  (posedge WCLK, WAD13, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);
	$setuphold  (posedge RCLK, RAD10, 1, 0);
	$setuphold  (posedge RCLK, RAD11, 1, 0);
	$setuphold  (posedge RCLK, RAD12, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);

	(RST  => RD0) = (0:0:0, 0:0:0);
	(RST  => RD1) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16K_WX1_RX4(WCEN,WCLK,WCS0,WCS1,WE,
                    RCEN,RCLK,RST,
                    WD0,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,WAD13,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,
                    RD0,RD1,RD2,RD3
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RCEN,RCLK,RST;
input  WD0;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,WAD13;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11;

output  RD0,RD1,RD2,RD3;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [13:0] wad;
wire [11:0]  rad;
wire [1:0]  wcs;
wire [3:0] rd;

reg notifier;

assign wad = {WAD13,WAD12,WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
//assign {RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);

defparam RAM_U0.WADDR_WIDTH=14;
defparam RAM_U0.WDATA_WIDTH=1;
defparam RAM_U0.RADDR_WIDTH=12;
defparam RAM_U0.RDATA_WIDTH=4;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(WD0),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WD0, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);
	$setuphold  (posedge WCLK, WAD12, 1, 0);
	$setuphold  (posedge WCLK, WAD13, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);
	$setuphold  (posedge RCLK, RAD10, 1, 0);
	$setuphold  (posedge RCLK, RAD11, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);
	(RCLK => RD2) = (0:0:0, 0:0:0);
	(RCLK => RD3) = (0:0:0, 0:0:0);

	(RST  => RD0) = (0:0:0, 0:0:0);
	(RST  => RD1) = (0:0:0, 0:0:0);
	(RST  => RD2) = (0:0:0, 0:0:0);
	(RST  => RD3) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16K_WX1_RX8(WCEN,WCLK,WCS0,WCS1,WE,
                    RCEN,RCLK,RST,
                    WD0,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,WAD13,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RCEN,RCLK,RST;
input  WD0;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,WAD13;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [13:0] wad;
wire [10:0]  rad;
wire [1:0]  wcs;
wire [7:0] rd;

reg notifier;

assign wad = {WAD13,WAD12,WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
//assign {RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);

defparam RAM_U0.WADDR_WIDTH=14;
defparam RAM_U0.WDATA_WIDTH=1;
defparam RAM_U0.RADDR_WIDTH=11;
defparam RAM_U0.RDATA_WIDTH=8;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(WD0),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WD0, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);
	$setuphold  (posedge WCLK, WAD12, 1, 0);
	$setuphold  (posedge WCLK, WAD13, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);
	$setuphold  (posedge RCLK, RAD10, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);
	(RCLK => RD2) = (0:0:0, 0:0:0);
	(RCLK => RD3) = (0:0:0, 0:0:0);
	(RCLK => RD4) = (0:0:0, 0:0:0);
	(RCLK => RD5) = (0:0:0, 0:0:0);
	(RCLK => RD6) = (0:0:0, 0:0:0);
	(RCLK => RD7) = (0:0:0, 0:0:0);

	(RST  => RD0) = (0:0:0, 0:0:0);
	(RST  => RD1) = (0:0:0, 0:0:0);
	(RST  => RD2) = (0:0:0, 0:0:0);
	(RST  => RD3) = (0:0:0, 0:0:0);
	(RST  => RD4) = (0:0:0, 0:0:0);
	(RST  => RD5) = (0:0:0, 0:0:0);
	(RST  => RD6) = (0:0:0, 0:0:0);
	(RST  => RD7) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16K_WX1_RX16(WCEN,WCLK,WCS0,WCS1,WE,
                    RCEN,RCLK,RST,
                    WD0,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,WAD13,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RCEN,RCLK,RST;
input  WD0;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,WAD13;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [13:0] wad;
wire [9:0]  rad;
wire [1:0]  wcs;
wire [15:0] rd;

reg notifier;

assign wad = {WAD13,WAD12,WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
//assign {RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
buf INSXQ8 (RD8,rd[8]);
buf INSXQ9 (RD9,rd[9]);

buf INSXQ10 (RD10,rd[10]);
buf INSXQ11 (RD11,rd[11]);
buf INSXQ12 (RD12,rd[12]);
buf INSXQ13 (RD13,rd[13]);
buf INSXQ14 (RD14,rd[14]);
buf INSXQ15 (RD15,rd[15]);

defparam RAM_U0.WADDR_WIDTH=14;
defparam RAM_U0.WDATA_WIDTH=1;
defparam RAM_U0.RADDR_WIDTH=10;
defparam RAM_U0.RDATA_WIDTH=16;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(WD0),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WD0, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);
	$setuphold  (posedge WCLK, WAD12, 1, 0);
	$setuphold  (posedge WCLK, WAD13, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);
	(RCLK => RD2) = (0:0:0, 0:0:0);
	(RCLK => RD3) = (0:0:0, 0:0:0);
	(RCLK => RD4) = (0:0:0, 0:0:0);
	(RCLK => RD5) = (0:0:0, 0:0:0);
	(RCLK => RD6) = (0:0:0, 0:0:0);
	(RCLK => RD7) = (0:0:0, 0:0:0);
	(RCLK => RD8) = (0:0:0, 0:0:0);
	(RCLK => RD9) = (0:0:0, 0:0:0);
	(RCLK => RD10) = (0:0:0, 0:0:0);
	(RCLK => RD11) = (0:0:0, 0:0:0);
	(RCLK => RD12) = (0:0:0, 0:0:0);
	(RCLK => RD13) = (0:0:0, 0:0:0);
	(RCLK => RD14) = (0:0:0, 0:0:0);
	(RCLK => RD15) = (0:0:0, 0:0:0);

	(RST  => RD0) = (0:0:0, 0:0:0);
	(RST  => RD1) = (0:0:0, 0:0:0);
	(RST  => RD2) = (0:0:0, 0:0:0);
	(RST  => RD3) = (0:0:0, 0:0:0);
	(RST  => RD4) = (0:0:0, 0:0:0);
	(RST  => RD5) = (0:0:0, 0:0:0);
	(RST  => RD6) = (0:0:0, 0:0:0);
	(RST  => RD7) = (0:0:0, 0:0:0);
	(RST  => RD8) = (0:0:0, 0:0:0);
	(RST  => RD9) = (0:0:0, 0:0:0);
	(RST  => RD10) = (0:0:0, 0:0:0);
	(RST  => RD11) = (0:0:0, 0:0:0);
	(RST  => RD12) = (0:0:0, 0:0:0);
	(RST  => RD13) = (0:0:0, 0:0:0);
	(RST  => RD14) = (0:0:0, 0:0:0);
	(RST  => RD15) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16K_WX1_RX32(WCEN,WCLK,WCS0,WCS1,WE,
                    RCEN,RCLK,RST,
                    WD0,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,WAD13,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,
                    RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15,
                    RD16,RD17,RD18,RD19,RD20,RD21,RD22,RD23,
                    RD24,RD25,RD26,RD27,RD28,RD29,RD30,RD31,
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RCEN,RCLK,RST;
input  WD0;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,WAD13;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7;
output  RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15;
output  RD16,RD17,RD18,RD19,RD20,RD21,RD22,RD23;
output  RD24,RD25,RD26,RD27,RD28,RD29,RD30,RD31;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [13:0] wad;
wire [8:0]  rad;
wire [1:0]  wcs;
wire [31:0] rd;

reg notifier;

assign wad = {WAD13,WAD12,WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
//assign  {RD31,RD30,RD29,RD28,RD27,RD26,RD25,RD24,RD23,RD22,RD21,RD20,RD19,RD18,RD17,RD16,RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
buf INSXQ8 (RD8,rd[8]);
buf INSXQ9 (RD9,rd[9]);

buf INSXQ10 (RD10,rd[10]);
buf INSXQ11 (RD11,rd[11]);
buf INSXQ12 (RD12,rd[12]);
buf INSXQ13 (RD13,rd[13]);
buf INSXQ14 (RD14,rd[14]);
buf INSXQ15 (RD15,rd[15]);
buf INSXQ16 (RD16,rd[16]);
buf INSXQ17 (RD17,rd[17]);
buf INSXQ18 (RD18,rd[18]);
buf INSXQ19 (RD19,rd[19]);

buf INSXQ20 (RD20,rd[20]);
buf INSXQ21 (RD21,rd[21]);
buf INSXQ22 (RD22,rd[22]);
buf INSXQ23 (RD23,rd[23]);
buf INSXQ24 (RD24,rd[24]);
buf INSXQ25 (RD25,rd[25]);
buf INSXQ26 (RD26,rd[26]);
buf INSXQ27 (RD27,rd[27]);
buf INSXQ28 (RD28,rd[28]);
buf INSXQ29 (RD29,rd[29]);

buf INSXQ30 (RD30,rd[30]);
buf INSXQ31 (RD31,rd[31]);

defparam RAM_U0.WADDR_WIDTH=14;
defparam RAM_U0.WDATA_WIDTH=1;
defparam RAM_U0.RADDR_WIDTH=9;
defparam RAM_U0.RDATA_WIDTH=32;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(WD0),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WD0, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);
	$setuphold  (posedge WCLK, WAD12, 1, 0);
	$setuphold  (posedge WCLK, WAD13, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);
	(RCLK => RD2) = (0:0:0, 0:0:0);
	(RCLK => RD3) = (0:0:0, 0:0:0);
	(RCLK => RD4) = (0:0:0, 0:0:0);
	(RCLK => RD5) = (0:0:0, 0:0:0);
	(RCLK => RD6) = (0:0:0, 0:0:0);
	(RCLK => RD7) = (0:0:0, 0:0:0);
	(RCLK => RD8) = (0:0:0, 0:0:0);
	(RCLK => RD9) = (0:0:0, 0:0:0);
	(RCLK => RD10) = (0:0:0, 0:0:0);
	(RCLK => RD11) = (0:0:0, 0:0:0);
	(RCLK => RD12) = (0:0:0, 0:0:0);
	(RCLK => RD13) = (0:0:0, 0:0:0);
	(RCLK => RD14) = (0:0:0, 0:0:0);
	(RCLK => RD15) = (0:0:0, 0:0:0);
	(RCLK => RD16) = (0:0:0, 0:0:0);
	(RCLK => RD17) = (0:0:0, 0:0:0);
	(RCLK => RD18) = (0:0:0, 0:0:0);
	(RCLK => RD19) = (0:0:0, 0:0:0);
	(RCLK => RD20) = (0:0:0, 0:0:0);
	(RCLK => RD21) = (0:0:0, 0:0:0);
	(RCLK => RD22) = (0:0:0, 0:0:0);
	(RCLK => RD23) = (0:0:0, 0:0:0);
	(RCLK => RD24) = (0:0:0, 0:0:0);
	(RCLK => RD25) = (0:0:0, 0:0:0);
	(RCLK => RD26) = (0:0:0, 0:0:0);
	(RCLK => RD27) = (0:0:0, 0:0:0);
	(RCLK => RD28) = (0:0:0, 0:0:0);
	(RCLK => RD29) = (0:0:0, 0:0:0);
	(RCLK => RD30) = (0:0:0, 0:0:0);
	(RCLK => RD31) = (0:0:0, 0:0:0);

	(RST  => RD0) = (0:0:0, 0:0:0);
	(RST  => RD1) = (0:0:0, 0:0:0);
	(RST  => RD2) = (0:0:0, 0:0:0);
	(RST  => RD3) = (0:0:0, 0:0:0);
	(RST  => RD4) = (0:0:0, 0:0:0);
	(RST  => RD5) = (0:0:0, 0:0:0);
	(RST  => RD6) = (0:0:0, 0:0:0);
	(RST  => RD7) = (0:0:0, 0:0:0);
	(RST  => RD8) = (0:0:0, 0:0:0);
	(RST  => RD9) = (0:0:0, 0:0:0);
	(RST  => RD10) = (0:0:0, 0:0:0);
	(RST  => RD11) = (0:0:0, 0:0:0);
	(RST  => RD12) = (0:0:0, 0:0:0);
	(RST  => RD13) = (0:0:0, 0:0:0);
	(RST  => RD14) = (0:0:0, 0:0:0);
	(RST  => RD15) = (0:0:0, 0:0:0);
	(RST  => RD16) = (0:0:0, 0:0:0);
	(RST  => RD17) = (0:0:0, 0:0:0);
	(RST  => RD18) = (0:0:0, 0:0:0);
	(RST  => RD19) = (0:0:0, 0:0:0);
	(RST  => RD20) = (0:0:0, 0:0:0);
	(RST  => RD21) = (0:0:0, 0:0:0);
	(RST  => RD22) = (0:0:0, 0:0:0);
	(RST  => RD23) = (0:0:0, 0:0:0);
	(RST  => RD24) = (0:0:0, 0:0:0);
	(RST  => RD25) = (0:0:0, 0:0:0);
	(RST  => RD26) = (0:0:0, 0:0:0);
	(RST  => RD27) = (0:0:0, 0:0:0);
	(RST  => RD28) = (0:0:0, 0:0:0);
	(RST  => RD29) = (0:0:0, 0:0:0);
	(RST  => RD30) = (0:0:0, 0:0:0);
	(RST  => RD31) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16K_WX2_RX2(WCEN,WCLK,WCS0,WCS1,WE,
                    RCEN,RCLK,RST,
                    WD0,WD1,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,
                    RD0,RD1
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RCEN,RCLK,RST;
input  WD0,WD1;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12;

output  RD0,RD1;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [12:0] wad;
wire [12:0]  rad;
wire [1:0]  wcs;
wire [1:0]  wd;
wire [1:0] rd;

reg notifier;

assign wad = {WAD12,WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD12,RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd  = {WD1,WD0};
//assign {RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);

defparam RAM_U0.WADDR_WIDTH=13;
defparam RAM_U0.WDATA_WIDTH=2;
defparam RAM_U0.RADDR_WIDTH=13;
defparam RAM_U0.RDATA_WIDTH=2;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));


specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);
	$setuphold  (posedge WCLK, WAD12, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);
	$setuphold  (posedge RCLK, RAD10, 1, 0);
	$setuphold  (posedge RCLK, RAD11, 1, 0);
	$setuphold  (posedge RCLK, RAD12, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16K_WX2_RX4(WCEN,WCLK,WCS0,WCS1,WE,
                    RCEN,RCLK,RST,
                    WD0,WD1,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,
                    RD0,RD1,RD2,RD3
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RCEN,RCLK,RST;
input  WD0,WD1;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11;

output  RD0,RD1,RD2,RD3;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [12:0] wad;
wire [11:0]  rad;
wire [1:0]  wcs;
wire [1:0]  wd;
wire [3:0] rd;

reg notifier;

assign wad = {WAD12,WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd  = {WD1,WD0};
//assign {RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);

defparam RAM_U0.WADDR_WIDTH=13;
defparam RAM_U0.WDATA_WIDTH=2;
defparam RAM_U0.RADDR_WIDTH=12;
defparam RAM_U0.RDATA_WIDTH=4;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));


specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);
	$setuphold  (posedge WCLK, WAD12, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);
	$setuphold  (posedge RCLK, RAD10, 1, 0);
	$setuphold  (posedge RCLK, RAD11, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);
	(RCLK => RD2) = (0:0:0, 0:0:0);
	(RCLK => RD3) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16K_WX2_RX8(WCEN,WCLK,WCS0,WCS1,WE,
                    RCEN,RCLK,RST,
                    WD0,WD1,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RCEN,RCLK,RST;
input  WD0,WD1;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [12:0] wad;
wire [10:0]  rad;
wire [1:0]  wcs;
wire [1:0]  wd;
wire [7:0] rd;

reg notifier;

assign wad = {WAD12,WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd  = {WD1,WD0};
//assign {RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);

defparam RAM_U0.WADDR_WIDTH=13;
defparam RAM_U0.WDATA_WIDTH=2;
defparam RAM_U0.RADDR_WIDTH=11;
defparam RAM_U0.RDATA_WIDTH=8;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);
	$setuphold  (posedge WCLK, WAD12, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);
	$setuphold  (posedge RCLK, RAD10, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);
	(RCLK => RD2) = (0:0:0, 0:0:0);
	(RCLK => RD3) = (0:0:0, 0:0:0);
	(RCLK => RD4) = (0:0:0, 0:0:0);
	(RCLK => RD5) = (0:0:0, 0:0:0);
	(RCLK => RD6) = (0:0:0, 0:0:0);
	(RCLK => RD7) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16K_WX2_RX16(WCEN,WCLK,WCS0,WCS1,WE,
                    RCEN,RCLK,RST,
                    WD0,WD1,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,
                    RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RCEN,RCLK,RST;
input  WD0,WD1;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7;
output  RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [12:0] wad;
wire [9:0]  rad;
wire [1:0]  wcs;
wire [1:0]  wd;
wire [15:0] rd;

reg notifier;

assign wad = {WAD12,WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd = {WD1,WD0};
//assign {RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
buf INSXQ8 (RD8,rd[8]);
buf INSXQ9 (RD9,rd[9]);

buf INSXQ10 (RD10,rd[10]);
buf INSXQ11 (RD11,rd[11]);
buf INSXQ12 (RD12,rd[12]);
buf INSXQ13 (RD13,rd[13]);
buf INSXQ14 (RD14,rd[14]);
buf INSXQ15 (RD15,rd[15]);

defparam RAM_U0.WADDR_WIDTH=13;
defparam RAM_U0.WDATA_WIDTH=2;
defparam RAM_U0.RADDR_WIDTH=10;
defparam RAM_U0.RDATA_WIDTH=16;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);
	$setuphold  (posedge WCLK, WAD12, 1, 0);

	$setup (RCEN, posedge RCLK, 1);
	$hold  (posedge RCLK, RCEN, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);
	(RCLK => RD2) = (0:0:0, 0:0:0);
	(RCLK => RD3) = (0:0:0, 0:0:0);
	(RCLK => RD4) = (0:0:0, 0:0:0);
	(RCLK => RD5) = (0:0:0, 0:0:0);
	(RCLK => RD6) = (0:0:0, 0:0:0);
	(RCLK => RD7) = (0:0:0, 0:0:0);
	(RCLK => RD8) = (0:0:0, 0:0:0);
	(RCLK => RD9) = (0:0:0, 0:0:0);
	(RCLK => RD10) = (0:0:0, 0:0:0);
	(RCLK => RD11) = (0:0:0, 0:0:0);
	(RCLK => RD12) = (0:0:0, 0:0:0);
	(RCLK => RD13) = (0:0:0, 0:0:0);
	(RCLK => RD14) = (0:0:0, 0:0:0);
	(RCLK => RD15) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);
	(RST => RD8) = (0:0:0, 0:0:0);
	(RST => RD9) = (0:0:0, 0:0:0);
	(RST => RD10) = (0:0:0, 0:0:0);
	(RST => RD11) = (0:0:0, 0:0:0);
	(RST => RD12) = (0:0:0, 0:0:0);
	(RST => RD13) = (0:0:0, 0:0:0);
	(RST => RD14) = (0:0:0, 0:0:0);
	(RST => RD15) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16K_WX2_RX32(WCEN,WCLK,WCS0,WCS1,WE,
                    RCEN,RCLK,RST,
                    WD0,WD1,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,
                    RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15,
                    RD16,RD17,RD18,RD19,RD20,RD21,RD22,RD23,
                    RD24,RD25,RD26,RD27,RD28,RD29,RD30,RD31,
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RCEN,RCLK,RST;
input  WD0,WD1;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7;
output  RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15;
output  RD16,RD17,RD18,RD19,RD20,RD21,RD22,RD23;
output  RD24,RD25,RD26,RD27,RD28,RD29,RD30,RD31;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [12:0] wad;
wire [8:0]  rad;
wire [1:0]  wcs;
wire [1:0]  wd;
wire [31:0] rd;

reg notifier;

assign wad = {WAD12,WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd = {WD1,WD0};
//assign {RD31,RD30,RD29,RD28,RD27,RD26,RD25,RD24,RD23,RD22,RD21,RD20,RD19,RD18,RD17,RD16,RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
buf INSXQ8 (RD8,rd[8]);
buf INSXQ9 (RD9,rd[9]);

buf INSXQ10 (RD10,rd[10]);
buf INSXQ11 (RD11,rd[11]);
buf INSXQ12 (RD12,rd[12]);
buf INSXQ13 (RD13,rd[13]);
buf INSXQ14 (RD14,rd[14]);
buf INSXQ15 (RD15,rd[15]);
buf INSXQ16 (RD16,rd[16]);
buf INSXQ17 (RD17,rd[17]);
buf INSXQ18 (RD18,rd[18]);
buf INSXQ19 (RD19,rd[19]);

buf INSXQ20 (RD20,rd[20]);
buf INSXQ21 (RD21,rd[21]);
buf INSXQ22 (RD22,rd[22]);
buf INSXQ23 (RD23,rd[23]);
buf INSXQ24 (RD24,rd[24]);
buf INSXQ25 (RD25,rd[25]);
buf INSXQ26 (RD26,rd[26]);
buf INSXQ27 (RD27,rd[27]);
buf INSXQ28 (RD28,rd[28]);
buf INSXQ29 (RD29,rd[29]);

buf INSXQ30 (RD30,rd[30]);
buf INSXQ31 (RD31,rd[31]);

defparam RAM_U0.WADDR_WIDTH=13;
defparam RAM_U0.WDATA_WIDTH=2;
defparam RAM_U0.RADDR_WIDTH=9;
defparam RAM_U0.RDATA_WIDTH=32;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));


specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);
	$setuphold  (posedge WCLK, WAD12, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);
	(RCLK => RD2) = (0:0:0, 0:0:0);
	(RCLK => RD3) = (0:0:0, 0:0:0);
	(RCLK => RD4) = (0:0:0, 0:0:0);
	(RCLK => RD5) = (0:0:0, 0:0:0);
	(RCLK => RD6) = (0:0:0, 0:0:0);
	(RCLK => RD7) = (0:0:0, 0:0:0);
	(RCLK => RD8) = (0:0:0, 0:0:0);
	(RCLK => RD9) = (0:0:0, 0:0:0);
	(RCLK => RD10) = (0:0:0, 0:0:0);
	(RCLK => RD11) = (0:0:0, 0:0:0);
	(RCLK => RD12) = (0:0:0, 0:0:0);
	(RCLK => RD13) = (0:0:0, 0:0:0);
	(RCLK => RD14) = (0:0:0, 0:0:0);
	(RCLK => RD15) = (0:0:0, 0:0:0);
	(RCLK => RD16) = (0:0:0, 0:0:0);
	(RCLK => RD17) = (0:0:0, 0:0:0);
	(RCLK => RD18) = (0:0:0, 0:0:0);
	(RCLK => RD19) = (0:0:0, 0:0:0);
	(RCLK => RD20) = (0:0:0, 0:0:0);
	(RCLK => RD21) = (0:0:0, 0:0:0);
	(RCLK => RD22) = (0:0:0, 0:0:0);
	(RCLK => RD23) = (0:0:0, 0:0:0);
	(RCLK => RD24) = (0:0:0, 0:0:0);
	(RCLK => RD25) = (0:0:0, 0:0:0);
	(RCLK => RD26) = (0:0:0, 0:0:0);
	(RCLK => RD27) = (0:0:0, 0:0:0);
	(RCLK => RD28) = (0:0:0, 0:0:0);
	(RCLK => RD29) = (0:0:0, 0:0:0);
	(RCLK => RD30) = (0:0:0, 0:0:0);
	(RCLK => RD31) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);
	(RST => RD8) = (0:0:0, 0:0:0);
	(RST => RD9) = (0:0:0, 0:0:0);
	(RST => RD10) = (0:0:0, 0:0:0);
	(RST => RD11) = (0:0:0, 0:0:0);
	(RST => RD12) = (0:0:0, 0:0:0);
	(RST => RD13) = (0:0:0, 0:0:0);
	(RST => RD14) = (0:0:0, 0:0:0);
	(RST => RD15) = (0:0:0, 0:0:0);
	(RST => RD16) = (0:0:0, 0:0:0);
	(RST => RD17) = (0:0:0, 0:0:0);
	(RST => RD18) = (0:0:0, 0:0:0);
	(RST => RD19) = (0:0:0, 0:0:0);
	(RST => RD20) = (0:0:0, 0:0:0);
	(RST => RD21) = (0:0:0, 0:0:0);
	(RST => RD22) = (0:0:0, 0:0:0);
	(RST => RD23) = (0:0:0, 0:0:0);
	(RST => RD24) = (0:0:0, 0:0:0);
	(RST => RD25) = (0:0:0, 0:0:0);
	(RST => RD26) = (0:0:0, 0:0:0);
	(RST => RD27) = (0:0:0, 0:0:0);
	(RST => RD28) = (0:0:0, 0:0:0);
	(RST => RD29) = (0:0:0, 0:0:0);
	(RST => RD30) = (0:0:0, 0:0:0);
	(RST => RD31) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16K_WX4_RX4(WCEN,WCLK,WCS0,WCS1,WE,
                    RCEN,RCLK,RST,
                    WD0,WD1,WD2,WD3,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,
                    RD0,RD1,RD2,RD3
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RCEN,RCLK,RST;
input  WD0,WD1,WD2,WD3;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11;

output  RD0,RD1,RD2,RD3;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [11:0] wad;
wire [11:0]  rad;
wire [1:0]  wcs;
wire [3:0]  wd;
wire [3:0] rd;

reg notifier;

assign wad = {WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd  = {WD3,WD2,WD1,WD0};
//assign {RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);

defparam RAM_U0.WADDR_WIDTH=12;
defparam RAM_U0.WDATA_WIDTH=4;
defparam RAM_U0.RADDR_WIDTH=12;
defparam RAM_U0.RDATA_WIDTH=4;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));


specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setup (WCEN, posedge WCLK, 1);
	$hold  (posedge WCLK, WCEN, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setup (WE, posedge WCLK, 1);
	$hold  (posedge WCLK, WE, 0);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);
	$setuphold  (posedge RCLK, RAD10, 1, 0);
	$setuphold  (posedge RCLK, RAD11, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);
	(RCLK => RD2) = (0:0:0, 0:0:0);
	(RCLK => RD3) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16K_WX4_RX8(WCEN,WCLK,WCS0,WCS1,WE,
                    RCEN,RCLK,RST,
                    WD0,WD1,WD2,WD3,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RCEN,RCLK,RST;
input  WD0,WD1,WD2,WD3;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [11:0] wad;
wire [10:0]  rad;
wire [1:0]  wcs;
wire [3:0]  wd;
wire [7:0] rd;

reg notifier;

assign wad = {WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd  = {WD3,WD2,WD1,WD0};
//assign {RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);

defparam RAM_U0.WADDR_WIDTH=12;
defparam RAM_U0.WDATA_WIDTH=4;
defparam RAM_U0.RADDR_WIDTH=11;
defparam RAM_U0.RDATA_WIDTH=8;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);
	$setuphold  (posedge RCLK, RAD10, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);
	(RCLK => RD2) = (0:0:0, 0:0:0);
	(RCLK => RD3) = (0:0:0, 0:0:0);
	(RCLK => RD4) = (0:0:0, 0:0:0);
	(RCLK => RD5) = (0:0:0, 0:0:0);
	(RCLK => RD6) = (0:0:0, 0:0:0);
	(RCLK => RD7) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16K_WX4_RX16(WCEN,WCLK,WCS0,WCS1,WE,
                    RCEN,RCLK,RST,
                    WD0,WD1,WD2,WD3,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,
                    RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RCEN,RCLK,RST;
input  WD0,WD1,WD2,WD3;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7;
output  RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [11:0] wad;
wire [9:0]  rad;
wire [1:0]  wcs;
wire [3:0]  wd;
wire [15:0] rd;

reg notifier;

assign wad = {WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd = {WD3,WD2,WD1,WD0};
//assign {RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
buf INSXQ8 (RD8,rd[8]);
buf INSXQ9 (RD9,rd[9]);

buf INSXQ10 (RD10,rd[10]);
buf INSXQ11 (RD11,rd[11]);
buf INSXQ12 (RD12,rd[12]);
buf INSXQ13 (RD13,rd[13]);
buf INSXQ14 (RD14,rd[14]);
buf INSXQ15 (RD15,rd[15]);

defparam RAM_U0.WADDR_WIDTH=12;
defparam RAM_U0.WDATA_WIDTH=4;
defparam RAM_U0.RADDR_WIDTH=10;
defparam RAM_U0.RDATA_WIDTH=16;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));


specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);
	(RCLK => RD2) = (0:0:0, 0:0:0);
	(RCLK => RD3) = (0:0:0, 0:0:0);
	(RCLK => RD4) = (0:0:0, 0:0:0);
	(RCLK => RD5) = (0:0:0, 0:0:0);
	(RCLK => RD6) = (0:0:0, 0:0:0);
	(RCLK => RD7) = (0:0:0, 0:0:0);
	(RCLK => RD8) = (0:0:0, 0:0:0);
	(RCLK => RD9) = (0:0:0, 0:0:0);
	(RCLK => RD10) = (0:0:0, 0:0:0);
	(RCLK => RD11) = (0:0:0, 0:0:0);
	(RCLK => RD12) = (0:0:0, 0:0:0);
	(RCLK => RD13) = (0:0:0, 0:0:0);
	(RCLK => RD14) = (0:0:0, 0:0:0);
	(RCLK => RD15) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);
	(RST => RD8) = (0:0:0, 0:0:0);
	(RST => RD9) = (0:0:0, 0:0:0);
	(RST => RD10) = (0:0:0, 0:0:0);
	(RST => RD11) = (0:0:0, 0:0:0);
	(RST => RD12) = (0:0:0, 0:0:0);
	(RST => RD13) = (0:0:0, 0:0:0);
	(RST => RD14) = (0:0:0, 0:0:0);
	(RST => RD15) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16K_WX4_RX32(WCEN,WCLK,WCS0,WCS1,WE,
                    RCEN,RCLK,RST,
                    WD0,WD1,WD2,WD3,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,
                    RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15,
                    RD16,RD17,RD18,RD19,RD20,RD21,RD22,RD23,
                    RD24,RD25,RD26,RD27,RD28,RD29,RD30,RD31,
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RCEN,RCLK,RST;
input  WD0,WD1,WD2,WD3;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7;
output  RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15;
output  RD16,RD17,RD18,RD19,RD20,RD21,RD22,RD23;
output  RD24,RD25,RD26,RD27,RD28,RD29,RD30,RD31;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [11:0] wad;
wire [8:0]  rad;
wire [1:0]  wcs;
wire [3:0]  wd;
wire [31:0] rd;

reg notifier;

assign wad = {WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd = {WD3,WD2,WD1,WD0};
//assign {RD31,RD30,RD29,RD28,RD27,RD26,RD25,RD24,RD23,RD22,RD21,RD20,RD19,RD18,RD17,RD16,RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
buf INSXQ8 (RD8,rd[8]);
buf INSXQ9 (RD9,rd[9]);

buf INSXQ10 (RD10,rd[10]);
buf INSXQ11 (RD11,rd[11]);
buf INSXQ12 (RD12,rd[12]);
buf INSXQ13 (RD13,rd[13]);
buf INSXQ14 (RD14,rd[14]);
buf INSXQ15 (RD15,rd[15]);
buf INSXQ16 (RD16,rd[16]);
buf INSXQ17 (RD17,rd[17]);
buf INSXQ18 (RD18,rd[18]);
buf INSXQ19 (RD19,rd[19]);

buf INSXQ20 (RD20,rd[20]);
buf INSXQ21 (RD21,rd[21]);
buf INSXQ22 (RD22,rd[22]);
buf INSXQ23 (RD23,rd[23]);
buf INSXQ24 (RD24,rd[24]);
buf INSXQ25 (RD25,rd[25]);
buf INSXQ26 (RD26,rd[26]);
buf INSXQ27 (RD27,rd[27]);
buf INSXQ28 (RD28,rd[28]);
buf INSXQ29 (RD29,rd[29]);

buf INSXQ30 (RD30,rd[30]);
buf INSXQ31 (RD31,rd[31]);

defparam RAM_U0.WADDR_WIDTH=12;
defparam RAM_U0.WDATA_WIDTH=4;
defparam RAM_U0.RADDR_WIDTH=9;
defparam RAM_U0.RDATA_WIDTH=32;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));


specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);
	(RCLK => RD2) = (0:0:0, 0:0:0);
	(RCLK => RD3) = (0:0:0, 0:0:0);
	(RCLK => RD4) = (0:0:0, 0:0:0);
	(RCLK => RD5) = (0:0:0, 0:0:0);
	(RCLK => RD6) = (0:0:0, 0:0:0);
	(RCLK => RD7) = (0:0:0, 0:0:0);
	(RCLK => RD8) = (0:0:0, 0:0:0);
	(RCLK => RD9) = (0:0:0, 0:0:0);
	(RCLK => RD10) = (0:0:0, 0:0:0);
	(RCLK => RD11) = (0:0:0, 0:0:0);
	(RCLK => RD12) = (0:0:0, 0:0:0);
	(RCLK => RD13) = (0:0:0, 0:0:0);
	(RCLK => RD14) = (0:0:0, 0:0:0);
	(RCLK => RD15) = (0:0:0, 0:0:0);
	(RCLK => RD16) = (0:0:0, 0:0:0);
	(RCLK => RD17) = (0:0:0, 0:0:0);
	(RCLK => RD18) = (0:0:0, 0:0:0);
	(RCLK => RD19) = (0:0:0, 0:0:0);
	(RCLK => RD20) = (0:0:0, 0:0:0);
	(RCLK => RD21) = (0:0:0, 0:0:0);
	(RCLK => RD22) = (0:0:0, 0:0:0);
	(RCLK => RD23) = (0:0:0, 0:0:0);
	(RCLK => RD24) = (0:0:0, 0:0:0);
	(RCLK => RD25) = (0:0:0, 0:0:0);
	(RCLK => RD26) = (0:0:0, 0:0:0);
	(RCLK => RD27) = (0:0:0, 0:0:0);
	(RCLK => RD28) = (0:0:0, 0:0:0);
	(RCLK => RD29) = (0:0:0, 0:0:0);
	(RCLK => RD30) = (0:0:0, 0:0:0);
	(RCLK => RD31) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);
	(RST => RD8) = (0:0:0, 0:0:0);
	(RST => RD9) = (0:0:0, 0:0:0);
	(RST => RD10) = (0:0:0, 0:0:0);
	(RST => RD11) = (0:0:0, 0:0:0);
	(RST => RD12) = (0:0:0, 0:0:0);
	(RST => RD13) = (0:0:0, 0:0:0);
	(RST => RD14) = (0:0:0, 0:0:0);
	(RST => RD15) = (0:0:0, 0:0:0);
	(RST => RD16) = (0:0:0, 0:0:0);
	(RST => RD17) = (0:0:0, 0:0:0);
	(RST => RD18) = (0:0:0, 0:0:0);
	(RST => RD19) = (0:0:0, 0:0:0);
	(RST => RD20) = (0:0:0, 0:0:0);
	(RST => RD21) = (0:0:0, 0:0:0);
	(RST => RD22) = (0:0:0, 0:0:0);
	(RST => RD23) = (0:0:0, 0:0:0);
	(RST => RD24) = (0:0:0, 0:0:0);
	(RST => RD25) = (0:0:0, 0:0:0);
	(RST => RD26) = (0:0:0, 0:0:0);
	(RST => RD27) = (0:0:0, 0:0:0);
	(RST => RD28) = (0:0:0, 0:0:0);
	(RST => RD29) = (0:0:0, 0:0:0);
	(RST => RD30) = (0:0:0, 0:0:0);
	(RST => RD31) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16K_WX8_RX8(WCEN,WCLK,WCS0,WCS1,WE,
                    RCEN,RCLK,RST,
                    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RCEN,RCLK,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [10:0] wad;
wire [10:0]  rad;
wire [1:0]  wcs;
wire [7:0]  wd;
wire [7:0] rd;
reg notifier;

assign wad = {WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd  = {WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);

defparam RAM_U0.WADDR_WIDTH=11;
defparam RAM_U0.WDATA_WIDTH=8;
defparam RAM_U0.RADDR_WIDTH=11;
defparam RAM_U0.RDATA_WIDTH=8;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));


specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);
	$setuphold  (posedge RCLK, RAD10, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);
	(RCLK => RD2) = (0:0:0, 0:0:0);
	(RCLK => RD3) = (0:0:0, 0:0:0);
	(RCLK => RD4) = (0:0:0, 0:0:0);
	(RCLK => RD5) = (0:0:0, 0:0:0);
	(RCLK => RD6) = (0:0:0, 0:0:0);
	(RCLK => RD7) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16K_WX8_RX16(WCEN,WCLK,WCS0,WCS1,WE,
                    RCEN,RCLK,RST,
                    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,
                    RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RCEN,RCLK,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7;
output  RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [10:0] wad;
wire [9:0]  rad;
wire [1:0]  wcs;
wire [7:0]  wd;
wire [15:0] rd;
reg notifier;

assign wad = {WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd = {WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
buf INSXQ8 (RD8,rd[8]);
buf INSXQ9 (RD9,rd[9]);

buf INSXQ10 (RD10,rd[10]);
buf INSXQ11 (RD11,rd[11]);
buf INSXQ12 (RD12,rd[12]);
buf INSXQ13 (RD13,rd[13]);
buf INSXQ14 (RD14,rd[14]);
buf INSXQ15 (RD15,rd[15]);

defparam RAM_U0.WADDR_WIDTH=11;
defparam RAM_U0.WDATA_WIDTH=8;
defparam RAM_U0.RADDR_WIDTH=10;
defparam RAM_U0.RDATA_WIDTH=16;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);
	(RCLK => RD2) = (0:0:0, 0:0:0);
	(RCLK => RD3) = (0:0:0, 0:0:0);
	(RCLK => RD4) = (0:0:0, 0:0:0);
	(RCLK => RD5) = (0:0:0, 0:0:0);
	(RCLK => RD6) = (0:0:0, 0:0:0);
	(RCLK => RD7) = (0:0:0, 0:0:0);
	(RCLK => RD8) = (0:0:0, 0:0:0);
	(RCLK => RD9) = (0:0:0, 0:0:0);
	(RCLK => RD10) = (0:0:0, 0:0:0);
	(RCLK => RD11) = (0:0:0, 0:0:0);
	(RCLK => RD12) = (0:0:0, 0:0:0);
	(RCLK => RD13) = (0:0:0, 0:0:0);
	(RCLK => RD14) = (0:0:0, 0:0:0);
	(RCLK => RD15) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);
	(RST => RD8) = (0:0:0, 0:0:0);
	(RST => RD9) = (0:0:0, 0:0:0);
	(RST => RD10) = (0:0:0, 0:0:0);
	(RST => RD11) = (0:0:0, 0:0:0);
	(RST => RD12) = (0:0:0, 0:0:0);
	(RST => RD13) = (0:0:0, 0:0:0);
	(RST => RD14) = (0:0:0, 0:0:0);
	(RST => RD15) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16K_WX8_RX32(WCEN,WCLK,WCS0,WCS1,WE,
                    RCEN,RCLK,RST,
                    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,
                    RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15,
                    RD16,RD17,RD18,RD19,RD20,RD21,RD22,RD23,
                    RD24,RD25,RD26,RD27,RD28,RD29,RD30,RD31);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RCEN,RCLK,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7;
output  RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15;
output  RD16,RD17,RD18,RD19,RD20,RD21,RD22,RD23;
output  RD24,RD25,RD26,RD27,RD28,RD29,RD30,RD31;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [10:0] wad;
wire [8:0]  rad;
wire [1:0]  wcs;
wire [7:0]  wd;
wire [31:0] rd;
reg notifier;

assign wad = {WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd = {WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign  {RD31,RD30,RD29,RD28,RD27,RD26,RD25,RD24,RD23,RD22,RD21,RD20,RD19,RD18,RD17,RD16,RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
buf INSXQ8 (RD8,rd[8]);
buf INSXQ9 (RD9,rd[9]);

buf INSXQ10 (RD10,rd[10]);
buf INSXQ11 (RD11,rd[11]);
buf INSXQ12 (RD12,rd[12]);
buf INSXQ13 (RD13,rd[13]);
buf INSXQ14 (RD14,rd[14]);
buf INSXQ15 (RD15,rd[15]);
buf INSXQ16 (RD16,rd[16]);
buf INSXQ17 (RD17,rd[17]);
buf INSXQ18 (RD18,rd[18]);
buf INSXQ19 (RD19,rd[19]);

buf INSXQ20 (RD20,rd[20]);
buf INSXQ21 (RD21,rd[21]);
buf INSXQ22 (RD22,rd[22]);
buf INSXQ23 (RD23,rd[23]);
buf INSXQ24 (RD24,rd[24]);
buf INSXQ25 (RD25,rd[25]);
buf INSXQ26 (RD26,rd[26]);
buf INSXQ27 (RD27,rd[27]);
buf INSXQ28 (RD28,rd[28]);
buf INSXQ29 (RD29,rd[29]);

buf INSXQ30 (RD30,rd[30]);
buf INSXQ31 (RD31,rd[31]);

defparam RAM_U0.WADDR_WIDTH=11;
defparam RAM_U0.WDATA_WIDTH=8;
defparam RAM_U0.RADDR_WIDTH=9;
defparam RAM_U0.RDATA_WIDTH=32;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));


specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);
	(RCLK => RD2) = (0:0:0, 0:0:0);
	(RCLK => RD3) = (0:0:0, 0:0:0);
	(RCLK => RD4) = (0:0:0, 0:0:0);
	(RCLK => RD5) = (0:0:0, 0:0:0);
	(RCLK => RD6) = (0:0:0, 0:0:0);
	(RCLK => RD7) = (0:0:0, 0:0:0);
	(RCLK => RD8) = (0:0:0, 0:0:0);
	(RCLK => RD9) = (0:0:0, 0:0:0);
	(RCLK => RD10) = (0:0:0, 0:0:0);
	(RCLK => RD11) = (0:0:0, 0:0:0);
	(RCLK => RD12) = (0:0:0, 0:0:0);
	(RCLK => RD13) = (0:0:0, 0:0:0);
	(RCLK => RD14) = (0:0:0, 0:0:0);
	(RCLK => RD15) = (0:0:0, 0:0:0);
	(RCLK => RD16) = (0:0:0, 0:0:0);
	(RCLK => RD17) = (0:0:0, 0:0:0);
	(RCLK => RD18) = (0:0:0, 0:0:0);
	(RCLK => RD19) = (0:0:0, 0:0:0);
	(RCLK => RD20) = (0:0:0, 0:0:0);
	(RCLK => RD21) = (0:0:0, 0:0:0);
	(RCLK => RD22) = (0:0:0, 0:0:0);
	(RCLK => RD23) = (0:0:0, 0:0:0);
	(RCLK => RD24) = (0:0:0, 0:0:0);
	(RCLK => RD25) = (0:0:0, 0:0:0);
	(RCLK => RD26) = (0:0:0, 0:0:0);
	(RCLK => RD27) = (0:0:0, 0:0:0);
	(RCLK => RD28) = (0:0:0, 0:0:0);
	(RCLK => RD29) = (0:0:0, 0:0:0);
	(RCLK => RD30) = (0:0:0, 0:0:0);
	(RCLK => RD31) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);
	(RST => RD8) = (0:0:0, 0:0:0);
	(RST => RD9) = (0:0:0, 0:0:0);
	(RST => RD10) = (0:0:0, 0:0:0);
	(RST => RD11) = (0:0:0, 0:0:0);
	(RST => RD12) = (0:0:0, 0:0:0);
	(RST => RD13) = (0:0:0, 0:0:0);
	(RST => RD14) = (0:0:0, 0:0:0);
	(RST => RD15) = (0:0:0, 0:0:0);
	(RST => RD16) = (0:0:0, 0:0:0);
	(RST => RD17) = (0:0:0, 0:0:0);
	(RST => RD18) = (0:0:0, 0:0:0);
	(RST => RD19) = (0:0:0, 0:0:0);
	(RST => RD20) = (0:0:0, 0:0:0);
	(RST => RD21) = (0:0:0, 0:0:0);
	(RST => RD22) = (0:0:0, 0:0:0);
	(RST => RD23) = (0:0:0, 0:0:0);
	(RST => RD24) = (0:0:0, 0:0:0);
	(RST => RD25) = (0:0:0, 0:0:0);
	(RST => RD26) = (0:0:0, 0:0:0);
	(RST => RD27) = (0:0:0, 0:0:0);
	(RST => RD28) = (0:0:0, 0:0:0);
	(RST => RD29) = (0:0:0, 0:0:0);
	(RST => RD30) = (0:0:0, 0:0:0);
	(RST => RD31) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16K_WX16_RX16(WCEN,WCLK,WCS0,WCS1,WE,
                    RCEN,RCLK,RST,
                    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,
                    WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,
                    RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RCEN,RCLK,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7;
input  WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7;
output  RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [9:0] wad;
wire [9:0]  rad;
wire [1:0]  wcs;
wire [15:0] wd;
wire [15:0] rd;
reg notifier;

assign wad = {WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd = {WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
buf INSXQ8 (RD8,rd[8]);
buf INSXQ9 (RD9,rd[9]);

buf INSXQ10 (RD10,rd[10]);
buf INSXQ11 (RD11,rd[11]);
buf INSXQ12 (RD12,rd[12]);
buf INSXQ13 (RD13,rd[13]);
buf INSXQ14 (RD14,rd[14]);
buf INSXQ15 (RD15,rd[15]);

defparam RAM_U0.WADDR_WIDTH=10;
defparam RAM_U0.WDATA_WIDTH=16;
defparam RAM_U0.RADDR_WIDTH=10;
defparam RAM_U0.RDATA_WIDTH=16;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);
	$setuphold  (posedge WCLK, WD8, 1, 0);
	$setuphold  (posedge WCLK, WD9, 1, 0);
	$setuphold  (posedge WCLK, WD10, 1, 0);
	$setuphold  (posedge WCLK, WD11, 1, 0);
	$setuphold  (posedge WCLK, WD12, 1, 0);
	$setuphold  (posedge WCLK, WD13, 1, 0);
	$setuphold  (posedge WCLK, WD14, 1, 0);
	$setuphold  (posedge WCLK, WD15, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);
	(RCLK => RD2) = (0:0:0, 0:0:0);
	(RCLK => RD3) = (0:0:0, 0:0:0);
	(RCLK => RD4) = (0:0:0, 0:0:0);
	(RCLK => RD5) = (0:0:0, 0:0:0);
	(RCLK => RD6) = (0:0:0, 0:0:0);
	(RCLK => RD7) = (0:0:0, 0:0:0);
	(RCLK => RD8) = (0:0:0, 0:0:0);
	(RCLK => RD9) = (0:0:0, 0:0:0);
	(RCLK => RD10) = (0:0:0, 0:0:0);
	(RCLK => RD11) = (0:0:0, 0:0:0);
	(RCLK => RD12) = (0:0:0, 0:0:0);
	(RCLK => RD13) = (0:0:0, 0:0:0);
	(RCLK => RD14) = (0:0:0, 0:0:0);
	(RCLK => RD15) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);
	(RST => RD8) = (0:0:0, 0:0:0);
	(RST => RD9) = (0:0:0, 0:0:0);
	(RST => RD10) = (0:0:0, 0:0:0);
	(RST => RD11) = (0:0:0, 0:0:0);
	(RST => RD12) = (0:0:0, 0:0:0);
	(RST => RD13) = (0:0:0, 0:0:0);
	(RST => RD14) = (0:0:0, 0:0:0);
	(RST => RD15) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16K_WX16_RX32(WCEN,WCLK,WCS0,WCS1,WE,
                    RCEN,RCLK,RST,
                    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,
                    WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,
                    RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15,
                    RD16,RD17,RD18,RD19,RD20,RD21,RD22,RD23,
                    RD24,RD25,RD26,RD27,RD28,RD29,RD30,RD31
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RCEN,RCLK,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7;
input  WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7;
output  RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15;
output  RD16,RD17,RD18,RD19,RD20,RD21,RD22,RD23;
output  RD24,RD25,RD26,RD27,RD28,RD29,RD30,RD31;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [9:0] wad;
wire [8:0]  rad;
wire [1:0]  wcs;
wire [15:0] wd;
wire [31:0] rd;
reg notifier;

assign wad = {WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd = {WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD31,RD30,RD29,RD28,RD27,RD26,RD25,RD24,RD23,RD22,RD21,RD20,RD19,RD18,RD17,RD16,RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
buf INSXQ8 (RD8,rd[8]);
buf INSXQ9 (RD9,rd[9]);

buf INSXQ10 (RD10,rd[10]);
buf INSXQ11 (RD11,rd[11]);
buf INSXQ12 (RD12,rd[12]);
buf INSXQ13 (RD13,rd[13]);
buf INSXQ14 (RD14,rd[14]);
buf INSXQ15 (RD15,rd[15]);
buf INSXQ16 (RD16,rd[16]);
buf INSXQ17 (RD17,rd[17]);
buf INSXQ18 (RD18,rd[18]);
buf INSXQ19 (RD19,rd[19]);

buf INSXQ20 (RD20,rd[20]);
buf INSXQ21 (RD21,rd[21]);
buf INSXQ22 (RD22,rd[22]);
buf INSXQ23 (RD23,rd[23]);
buf INSXQ24 (RD24,rd[24]);
buf INSXQ25 (RD25,rd[25]);
buf INSXQ26 (RD26,rd[26]);
buf INSXQ27 (RD27,rd[27]);
buf INSXQ28 (RD28,rd[28]);
buf INSXQ29 (RD29,rd[29]);

buf INSXQ30 (RD30,rd[30]);
buf INSXQ31 (RD31,rd[31]);

defparam RAM_U0.WADDR_WIDTH=10;
defparam RAM_U0.WDATA_WIDTH=16;
defparam RAM_U0.RADDR_WIDTH=9;
defparam RAM_U0.RDATA_WIDTH=32;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));


specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);
	$setuphold  (posedge WCLK, WD8, 1, 0);
	$setuphold  (posedge WCLK, WD9, 1, 0);
	$setuphold  (posedge WCLK, WD10, 1, 0);
	$setuphold  (posedge WCLK, WD11, 1, 0);
	$setuphold  (posedge WCLK, WD12, 1, 0);
	$setuphold  (posedge WCLK, WD13, 1, 0);
	$setuphold  (posedge WCLK, WD14, 1, 0);
	$setuphold  (posedge WCLK, WD15, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);
	(RCLK => RD2) = (0:0:0, 0:0:0);
	(RCLK => RD3) = (0:0:0, 0:0:0);
	(RCLK => RD4) = (0:0:0, 0:0:0);
	(RCLK => RD5) = (0:0:0, 0:0:0);
	(RCLK => RD6) = (0:0:0, 0:0:0);
	(RCLK => RD7) = (0:0:0, 0:0:0);
	(RCLK => RD8) = (0:0:0, 0:0:0);
	(RCLK => RD9) = (0:0:0, 0:0:0);
	(RCLK => RD10) = (0:0:0, 0:0:0);
	(RCLK => RD11) = (0:0:0, 0:0:0);
	(RCLK => RD12) = (0:0:0, 0:0:0);
	(RCLK => RD13) = (0:0:0, 0:0:0);
	(RCLK => RD14) = (0:0:0, 0:0:0);
	(RCLK => RD15) = (0:0:0, 0:0:0);
	(RCLK => RD16) = (0:0:0, 0:0:0);
	(RCLK => RD17) = (0:0:0, 0:0:0);
	(RCLK => RD18) = (0:0:0, 0:0:0);
	(RCLK => RD19) = (0:0:0, 0:0:0);
	(RCLK => RD20) = (0:0:0, 0:0:0);
	(RCLK => RD21) = (0:0:0, 0:0:0);
	(RCLK => RD22) = (0:0:0, 0:0:0);
	(RCLK => RD23) = (0:0:0, 0:0:0);
	(RCLK => RD24) = (0:0:0, 0:0:0);
	(RCLK => RD25) = (0:0:0, 0:0:0);
	(RCLK => RD26) = (0:0:0, 0:0:0);
	(RCLK => RD27) = (0:0:0, 0:0:0);
	(RCLK => RD28) = (0:0:0, 0:0:0);
	(RCLK => RD29) = (0:0:0, 0:0:0);
	(RCLK => RD30) = (0:0:0, 0:0:0);
	(RCLK => RD31) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);
	(RST => RD8) = (0:0:0, 0:0:0);
	(RST => RD9) = (0:0:0, 0:0:0);
	(RST => RD10) = (0:0:0, 0:0:0);
	(RST => RD11) = (0:0:0, 0:0:0);
	(RST => RD12) = (0:0:0, 0:0:0);
	(RST => RD13) = (0:0:0, 0:0:0);
	(RST => RD14) = (0:0:0, 0:0:0);
	(RST => RD15) = (0:0:0, 0:0:0);
	(RST => RD16) = (0:0:0, 0:0:0);
	(RST => RD17) = (0:0:0, 0:0:0);
	(RST => RD18) = (0:0:0, 0:0:0);
	(RST => RD19) = (0:0:0, 0:0:0);
	(RST => RD20) = (0:0:0, 0:0:0);
	(RST => RD21) = (0:0:0, 0:0:0);
	(RST => RD22) = (0:0:0, 0:0:0);
	(RST => RD23) = (0:0:0, 0:0:0);
	(RST => RD24) = (0:0:0, 0:0:0);
	(RST => RD25) = (0:0:0, 0:0:0);
	(RST => RD26) = (0:0:0, 0:0:0);
	(RST => RD27) = (0:0:0, 0:0:0);
	(RST => RD28) = (0:0:0, 0:0:0);
	(RST => RD29) = (0:0:0, 0:0:0);
	(RST => RD30) = (0:0:0, 0:0:0);
	(RST => RD31) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16K_WX32_RX32 (WCEN,WCLK,WCS0,WCS1,WE,
                    RCEN,RCLK,RST,
                    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,
                    WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,
                    WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23,
                    WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,
                    RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15,
                    RD16,RD17,RD18,RD19,RD20,RD21,RD22,RD23,
                    RD24,RD25,RD26,RD27,RD28,RD29,RD30,RD31
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RCEN,RCLK,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7;
input  WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15;
input  WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23;
input  WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7;
output  RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15;
output  RD16,RD17,RD18,RD19,RD20,RD21,RD22,RD23;
output  RD24,RD25,RD26,RD27,RD28,RD29,RD30,RD31;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [8:0] wad;
wire [8:0]  rad;
wire [1:0]  wcs;
wire [31:0] wd;
wire [31:0] rd;
reg notifier;

assign wad = {WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd = {WD31,WD30,WD29,WD28,WD27,WD26,WD25,WD24,WD23,WD22,WD21,WD20,WD19,WD18,WD17,WD16,WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD31,RD30,RD29,RD28,RD27,RD26,RD25,RD24,RD23,RD22,RD21,RD20,RD19,RD18,RD17,RD16,RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
buf INSXQ8 (RD8,rd[8]);
buf INSXQ9 (RD9,rd[9]);

buf INSXQ10 (RD10,rd[10]);
buf INSXQ11 (RD11,rd[11]);
buf INSXQ12 (RD12,rd[12]);
buf INSXQ13 (RD13,rd[13]);
buf INSXQ14 (RD14,rd[14]);
buf INSXQ15 (RD15,rd[15]);
buf INSXQ16 (RD16,rd[16]);
buf INSXQ17 (RD17,rd[17]);
buf INSXQ18 (RD18,rd[18]);
buf INSXQ19 (RD19,rd[19]);

buf INSXQ20 (RD20,rd[20]);
buf INSXQ21 (RD21,rd[21]);
buf INSXQ22 (RD22,rd[22]);
buf INSXQ23 (RD23,rd[23]);
buf INSXQ24 (RD24,rd[24]);
buf INSXQ25 (RD25,rd[25]);
buf INSXQ26 (RD26,rd[26]);
buf INSXQ27 (RD27,rd[27]);
buf INSXQ28 (RD28,rd[28]);
buf INSXQ29 (RD29,rd[29]);

buf INSXQ30 (RD30,rd[30]);
buf INSXQ31 (RD31,rd[31]);

defparam RAM_U0.WADDR_WIDTH=9;
defparam RAM_U0.WDATA_WIDTH=32;
defparam RAM_U0.RADDR_WIDTH=9;
defparam RAM_U0.RDATA_WIDTH=32;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));



specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);
	$setuphold  (posedge WCLK, WD8, 1, 0);
	$setuphold  (posedge WCLK, WD9, 1, 0);
	$setuphold  (posedge WCLK, WD10, 1, 0);
	$setuphold  (posedge WCLK, WD11, 1, 0);
	$setuphold  (posedge WCLK, WD12, 1, 0);
	$setuphold  (posedge WCLK, WD13, 1, 0);
	$setuphold  (posedge WCLK, WD14, 1, 0);
	$setuphold  (posedge WCLK, WD15, 1, 0);
	$setuphold  (posedge WCLK, WD16, 1, 0);
	$setuphold  (posedge WCLK, WD17, 1, 0);
	$setuphold  (posedge WCLK, WD18, 1, 0);
	$setuphold  (posedge WCLK, WD19, 1, 0);
	$setuphold  (posedge WCLK, WD20, 1, 0);
	$setuphold  (posedge WCLK, WD21, 1, 0);
	$setuphold  (posedge WCLK, WD22, 1, 0);
	$setuphold  (posedge WCLK, WD23, 1, 0);
	$setuphold  (posedge WCLK, WD24, 1, 0);
	$setuphold  (posedge WCLK, WD25, 1, 0);
	$setuphold  (posedge WCLK, WD26, 1, 0);
	$setuphold  (posedge WCLK, WD27, 1, 0);
	$setuphold  (posedge WCLK, WD28, 1, 0);
	$setuphold  (posedge WCLK, WD29, 1, 0);
	$setuphold  (posedge WCLK, WD30, 1, 0);
	$setuphold  (posedge WCLK, WD31, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);
	(RCLK => RD2) = (0:0:0, 0:0:0);
	(RCLK => RD3) = (0:0:0, 0:0:0);
	(RCLK => RD4) = (0:0:0, 0:0:0);
	(RCLK => RD5) = (0:0:0, 0:0:0);
	(RCLK => RD6) = (0:0:0, 0:0:0);
	(RCLK => RD7) = (0:0:0, 0:0:0);
	(RCLK => RD8) = (0:0:0, 0:0:0);
	(RCLK => RD9) = (0:0:0, 0:0:0);
	(RCLK => RD10) = (0:0:0, 0:0:0);
	(RCLK => RD11) = (0:0:0, 0:0:0);
	(RCLK => RD12) = (0:0:0, 0:0:0);
	(RCLK => RD13) = (0:0:0, 0:0:0);
	(RCLK => RD14) = (0:0:0, 0:0:0);
	(RCLK => RD15) = (0:0:0, 0:0:0);
	(RCLK => RD16) = (0:0:0, 0:0:0);
	(RCLK => RD17) = (0:0:0, 0:0:0);
	(RCLK => RD18) = (0:0:0, 0:0:0);
	(RCLK => RD19) = (0:0:0, 0:0:0);
	(RCLK => RD20) = (0:0:0, 0:0:0);
	(RCLK => RD21) = (0:0:0, 0:0:0);
	(RCLK => RD22) = (0:0:0, 0:0:0);
	(RCLK => RD23) = (0:0:0, 0:0:0);
	(RCLK => RD24) = (0:0:0, 0:0:0);
	(RCLK => RD25) = (0:0:0, 0:0:0);
	(RCLK => RD26) = (0:0:0, 0:0:0);
	(RCLK => RD27) = (0:0:0, 0:0:0);
	(RCLK => RD28) = (0:0:0, 0:0:0);
	(RCLK => RD29) = (0:0:0, 0:0:0);
	(RCLK => RD30) = (0:0:0, 0:0:0);
	(RCLK => RD31) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);
	(RST => RD8) = (0:0:0, 0:0:0);
	(RST => RD9) = (0:0:0, 0:0:0);
	(RST => RD10) = (0:0:0, 0:0:0);
	(RST => RD11) = (0:0:0, 0:0:0);
	(RST => RD12) = (0:0:0, 0:0:0);
	(RST => RD13) = (0:0:0, 0:0:0);
	(RST => RD14) = (0:0:0, 0:0:0);
	(RST => RD15) = (0:0:0, 0:0:0);
	(RST => RD16) = (0:0:0, 0:0:0);
	(RST => RD17) = (0:0:0, 0:0:0);
	(RST => RD18) = (0:0:0, 0:0:0);
	(RST => RD19) = (0:0:0, 0:0:0);
	(RST => RD20) = (0:0:0, 0:0:0);
	(RST => RD21) = (0:0:0, 0:0:0);
	(RST => RD22) = (0:0:0, 0:0:0);
	(RST => RD23) = (0:0:0, 0:0:0);
	(RST => RD24) = (0:0:0, 0:0:0);
	(RST => RD25) = (0:0:0, 0:0:0);
	(RST => RD26) = (0:0:0, 0:0:0);
	(RST => RD27) = (0:0:0, 0:0:0);
	(RST => RD28) = (0:0:0, 0:0:0);
	(RST => RD29) = (0:0:0, 0:0:0);
	(RST => RD30) = (0:0:0, 0:0:0);
	(RST => RD31) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16K_X1(CEN,CLK,WR,CS0,CS1,RST,DI0,AD0,AD1,AD2,AD3,AD4,AD5,AD6,AD7,AD8,AD9,AD10,AD11,AD12,AD13,DO0);

parameter RAM_INIT_FILE = "";

input  CEN;
input  CLK;
input  WR;
input  CS0;
input  CS1;
input  RST;
input  AD13,AD12,AD11,AD10,AD9,AD8,AD7,AD6,AD5,AD4,AD3,AD2,AD1,AD0;

input  DI0;

output DO0;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [0:0] di;
wire [0:0] do;
wire [13:0] ad;
wire [1:0] cs;
reg notifier;

assign di = {DI0};
//assign {DO0} = do;
buf INSXQ (DO0,do);
assign ad = {AD13,AD12,AD11,AD10,AD9,AD8,AD7,AD6,AD5,AD4,AD3,AD2,AD1,AD0};
assign cs = {CS1,CS0};

defparam RAM_U0.ADDR_WIDTH = 14;
defparam RAM_U0.DATA_WIDTH = 1;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_SPRAM_16K RAM_U0(
		.CEN(CEN),
		.CLK(CLK),
		.WR(WR),
		.CS(cs),
		.RST(RST),
		.DI(di),
		.AD(ad),
		.DO(do)
		);


specify
	$width (posedge CLK, 1, 0, notifier);
	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge CLK, WR, 1, 0);
	$setuphold  (posedge CLK, CEN, 1, 0);
	$setuphold  (posedge CLK, CS0, 1, 0);
	$setuphold  (posedge CLK, CS1, 1, 0);

	$setuphold  (posedge CLK, DI0, 1, 0);

	$setuphold  (posedge CLK, AD0, 1, 0);
	$setuphold  (posedge CLK, AD1, 1, 0);
	$setuphold  (posedge CLK, AD2, 1, 0);
	$setuphold  (posedge CLK, AD3, 1, 0);
	$setuphold  (posedge CLK, AD4, 1, 0);
	$setuphold  (posedge CLK, AD5, 1, 0);
	$setuphold  (posedge CLK, AD6, 1, 0);
	$setuphold  (posedge CLK, AD7, 1, 0);
	$setuphold  (posedge CLK, AD8, 1, 0);
	$setuphold  (posedge CLK, AD9, 1, 0);
	$setuphold  (posedge CLK, AD10, 1, 0);
	$setuphold  (posedge CLK, AD11, 1, 0);
	$setuphold  (posedge CLK, AD12, 1, 0);
	$setuphold  (posedge CLK, AD13, 1, 0);

        $recovery(posedge RST, posedge CLK, 1); 

	(CLK => DO0) = (0:0:0, 0:0:0);
	(RST => DO0) = (0:0:0, 0:0:0);


endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16K_X2(CEN,CLK,WR,CS0,CS1,RST,
                  DI0,DI1,
                  AD0,AD1,AD2,AD3,AD4,AD5,AD6,AD7,AD8,AD9,AD10,AD11,AD12,
                  DO0,DO1);

parameter RAM_INIT_FILE = "";

input  CEN;
input  CLK;
input  WR;
input  CS0;
input  CS1;
input  RST;
input  AD0;
input  AD1;
input  AD2;
input  AD3;
input  AD4;
input  AD5;
input  AD6;
input  AD7;
input  AD8;
input  AD9;
input  AD10;
input  AD11;
input  AD12;
input  DI0;
input  DI1;

output DO0;
output DO1;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [1:0] di;
wire [1:0] do;
wire [12:0] ad;
wire [1:0] cs;
reg notifier;

assign cs = {CS1,CS0};

assign di = {DI1,DI0};
//assign {DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
assign ad = {AD12,AD11,AD10,AD9,AD8,AD7,AD6,AD5,AD4,AD3,AD2,AD1,AD0};

defparam RAM_U0.ADDR_WIDTH = 13;
defparam RAM_U0.DATA_WIDTH = 2;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_SPRAM_16K RAM_U0(
		.CEN(CEN),
		.CLK(CLK),
		.WR(WR),
		.CS(cs),
		.RST(RST),
		.DI(di),
		.AD(ad),
		.DO(do)
		);

specify
	$width (posedge CLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge CLK, WR, 1, 0);
	$setuphold  (posedge CLK, CEN, 1, 0);
	$setuphold  (posedge CLK, CS0, 1, 0);
	$setuphold  (posedge CLK, CS1, 1, 0);

	$setuphold  (posedge CLK, DI0, 1, 0);
	$setuphold  (posedge CLK, DI1, 1, 0);

	$setuphold  (posedge CLK, AD0, 1, 0);
	$setuphold  (posedge CLK, AD1, 1, 0);
	$setuphold  (posedge CLK, AD2, 1, 0);
	$setuphold  (posedge CLK, AD3, 1, 0);
	$setuphold  (posedge CLK, AD4, 1, 0);
	$setuphold  (posedge CLK, AD5, 1, 0);
	$setuphold  (posedge CLK, AD6, 1, 0);
	$setuphold  (posedge CLK, AD7, 1, 0);
	$setuphold  (posedge CLK, AD8, 1, 0);
	$setuphold  (posedge CLK, AD9, 1, 0);
	$setuphold  (posedge CLK, AD10, 1, 0);
	$setuphold  (posedge CLK, AD11, 1, 0);
	$setuphold  (posedge CLK, AD12, 1, 0);

        $recovery(posedge RST, posedge CLK, 1); 

	(CLK => DO0) = (0:0:0, 0:0:0);
	(CLK => DO1) = (0:0:0, 0:0:0);

	(RST => DO0) = (0:0:0, 0:0:0);
	(RST => DO1) = (0:0:0, 0:0:0);


endspecify
endmodule
`endcelldefine
`celldefine
`timescale 1 ns/ 100 ps
module RAMB16K_X4(CEN,CLK,WR,CS0,CS1,RST,
                  DI0,DI1,DI2,DI3,
                  AD0,AD1,AD2,AD3,AD4,AD5,AD6,AD7,AD8,AD9,AD10,AD11,
                  DO0,DO1,DO2,DO3);

parameter RAM_INIT_FILE = "";

input  CEN;
input  CLK;
input  WR;
input  CS0;
input  CS1;
input  RST;
input  AD0;
input  AD1;
input  AD2;
input  AD3;
input  AD4;
input  AD5;
input  AD6;
input  AD7;
input  AD8;
input  AD9;
input  AD10;
input  AD11;
input  DI0;
input  DI1;
input  DI2;
input  DI3;

output DO0;
output DO1;
output DO2;
output DO3;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [3:0] di;
wire [3:0] do;
wire [11:0] ad;
wire [1:0] cs;
reg notifier;

assign cs = {CS1,CS0};
assign di = {DI3,DI2,DI1,DI0};
//assign {DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
assign ad = {AD11,AD10,AD9,AD8,AD7,AD6,AD5,AD4,AD3,AD2,AD1,AD0};

defparam RAM_U0.ADDR_WIDTH = 12;
defparam RAM_U0.DATA_WIDTH = 4;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_SPRAM_16K RAM_U0(
		.CEN(CEN),
		.CLK(CLK),
		.WR(WR),
		.CS(cs),
		.RST(RST),
		.DI(di),
		.AD(ad),
		.DO(do)
		);

specify
	(CLK => DO0) = (0:0:0, 0:0:0);
	(CLK => DO1) = (0:0:0, 0:0:0);
	(CLK => DO2) = (0:0:0, 0:0:0);
	(CLK => DO3) = (0:0:0, 0:0:0);

	(RST => DO0) = (0:0:0, 0:0:0);
	(RST => DO1) = (0:0:0, 0:0:0);
	(RST => DO2) = (0:0:0, 0:0:0);
	(RST => DO3) = (0:0:0, 0:0:0);


	$width (posedge CLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge CLK, WR, 1, 0);
	$setuphold  (posedge CLK, CEN, 1, 0);
	$setuphold  (posedge CLK, CS0, 1, 0);
	$setuphold  (posedge CLK, CS1, 1, 0);

	$setuphold  (posedge CLK, DI0, 1, 0);
	$setuphold  (posedge CLK, DI1, 1, 0);
	$setuphold  (posedge CLK, DI2, 1, 0);
	$setuphold  (posedge CLK, DI3, 1, 0);

	$setuphold  (posedge CLK, AD0, 1, 0);
	$setuphold  (posedge CLK, AD1, 1, 0);
	$setuphold  (posedge CLK, AD2, 1, 0);
	$setuphold  (posedge CLK, AD3, 1, 0);
	$setuphold  (posedge CLK, AD4, 1, 0);
	$setuphold  (posedge CLK, AD5, 1, 0);
	$setuphold  (posedge CLK, AD6, 1, 0);
	$setuphold  (posedge CLK, AD7, 1, 0);
	$setuphold  (posedge CLK, AD8, 1, 0);
	$setuphold  (posedge CLK, AD9, 1, 0);
	$setuphold  (posedge CLK, AD10, 1, 0);
	$setuphold  (posedge CLK, AD11, 1, 0);

        $recovery(posedge RST, posedge CLK, 1); 



endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16K_X8(CEN,CLK,WR,CS0,CS1,RST,
                  DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,
                  AD0,AD1,AD2,AD3,AD4,AD5,AD6,AD7,AD8,AD9,AD10,
                  DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7
 );

parameter RAM_INIT_FILE = "";

input  CEN;
input  CLK;
input  WR;
input  CS0;
input  CS1;
input  RST;
input  AD0;
input  AD1;
input  AD2;
input  AD3;
input  AD4;
input  AD5;
input  AD6;
input  AD7;
input  AD8;
input  AD9;
input  AD10;
input  DI0;
input  DI1;
input  DI2;
input  DI3;
input  DI4;
input  DI5;
input  DI6;
input  DI7;

output DO0;
output DO1;
output DO2;
output DO3;
output DO4;
output DO5;
output DO6;
output DO7;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [7:0] di;
wire [7:0] do;
wire [10:0] ad;
wire [1:0] cs;
reg notifier;

assign cs = {CS1,CS0};
assign di = {DI7,DI6,DI5,DI4,DI3,DI2,DI1,DI0};
//assign {DO7,DO6,DO5,DO4,DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
buf INSXQ4 (DO4,do[4]);
buf INSXQ5 (DO5,do[5]);
buf INSXQ6 (DO6,do[6]);
buf INSXQ7 (DO7,do[7]);
assign ad = {AD10,AD9,AD8,AD7,AD6,AD5,AD4,AD3,AD2,AD1,AD0};

defparam RAM_U0.ADDR_WIDTH = 11;
defparam RAM_U0.DATA_WIDTH = 8;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_SPRAM_16K RAM_U0(
		.CEN(CEN),
		.CLK(CLK),
		.WR(WR),
		.CS(cs),
		.RST(RST),
		.DI(di),
		.AD(ad),
		.DO(do)
		);


specify
	$width (posedge CLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge CLK, DI0, 1, 0);
	$setuphold  (posedge CLK, DI1, 1, 0);
	$setuphold  (posedge CLK, DI2, 1, 0);
	$setuphold  (posedge CLK, DI3, 1, 0);
	$setuphold  (posedge CLK, DI4, 1, 0);
	$setuphold  (posedge CLK, DI5, 1, 0);
	$setuphold  (posedge CLK, DI6, 1, 0);
	$setuphold  (posedge CLK, DI7, 1, 0);

	$setuphold  (posedge CLK, WR, 1, 0);
	$setuphold  (posedge CLK, CEN, 1, 0);
	$setuphold  (posedge CLK, CS0, 1, 0);
	$setuphold  (posedge CLK, CS1, 1, 0);

	$setuphold  (posedge CLK, AD0, 1, 0);
	$setuphold  (posedge CLK, AD1, 1, 0);
	$setuphold  (posedge CLK, AD2, 1, 0);
	$setuphold  (posedge CLK, AD3, 1, 0);
	$setuphold  (posedge CLK, AD4, 1, 0);
	$setuphold  (posedge CLK, AD5, 1, 0);
	$setuphold  (posedge CLK, AD6, 1, 0);
	$setuphold  (posedge CLK, AD7, 1, 0);
	$setuphold  (posedge CLK, AD8, 1, 0);
	$setuphold  (posedge CLK, AD9, 1, 0);
	$setuphold  (posedge CLK, AD10, 1, 0);

        $recovery(posedge RST, posedge CLK, 1); 

	(CLK => DO0) = (0:0:0, 0:0:0);
	(CLK => DO1) = (0:0:0, 0:0:0);
	(CLK => DO2) = (0:0:0, 0:0:0);
	(CLK => DO3) = (0:0:0, 0:0:0);
	(CLK => DO4) = (0:0:0, 0:0:0);
	(CLK => DO5) = (0:0:0, 0:0:0);
	(CLK => DO6) = (0:0:0, 0:0:0);
	(CLK => DO7) = (0:0:0, 0:0:0);

	(RST => DO0) = (0:0:0, 0:0:0);
	(RST => DO1) = (0:0:0, 0:0:0);
	(RST => DO2) = (0:0:0, 0:0:0);
	(RST => DO3) = (0:0:0, 0:0:0);
	(RST => DO4) = (0:0:0, 0:0:0);
	(RST => DO5) = (0:0:0, 0:0:0);
	(RST => DO6) = (0:0:0, 0:0:0);
	(RST => DO7) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16K_X16(CEN,CLK,WR,CS0,CS1,RST,
                  DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,
                  DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15,
                  AD0,AD1,AD2,AD3,AD4,AD5,AD6,AD7,AD8,AD9,
                  DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,
                  DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15
 );

parameter RAM_INIT_FILE = "";

input  CEN;
input  CLK;
input  WR;
input  CS0;
input  CS1;
input  RST;
input  AD0;
input  AD1;
input  AD2;
input  AD3;
input  AD4;
input  AD5;
input  AD6;
input  AD7;
input  AD8;
input  AD9;
input  DI0;
input  DI1;
input  DI2;
input  DI3;
input  DI4;
input  DI5;
input  DI6;
input  DI7;
input  DI8;
input  DI9;
input  DI10;
input  DI11;
input  DI12;
input  DI13;
input  DI14;
input  DI15;

output DO0;
output DO1;
output DO2;
output DO3;
output DO4;
output DO5;
output DO6;
output DO7;
output DO8;
output DO9;
output DO10;
output DO11;
output DO12;
output DO13;
output DO14;
output DO15;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [15:0] di;
wire [15:0] do;
wire [9:0] ad;
wire [1:0] cs;
reg notifier;

assign di = {DI15,DI14,DI13,DI12,DI11,DI10,DI9,DI8,DI7,DI6,DI5,DI4,DI3,DI2,DI1,DI0};
//assign {DO15,DO14,DO13,DO12,DO11,DO10,DO9,DO8,DO7,DO6,DO5,DO4,DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
buf INSXQ4 (DO4,do[4]);
buf INSXQ5 (DO5,do[5]);
buf INSXQ6 (DO6,do[6]);
buf INSXQ7 (DO7,do[7]);
buf INSXQ8 (DO8,do[8]);
buf INSXQ9 (DO9,do[9]);
buf INSXQ10 (DO10,do[10]);
buf INSXQ11 (DO11,do[11]);
buf INSXQ12 (DO12,do[12]);
buf INSXQ13 (DO13,do[13]);
buf INSXQ14 (DO14,do[14]);
buf INSXQ15 (DO15,do[15]);

assign ad = {AD9,AD8,AD7,AD6,AD5,AD4,AD3,AD2,AD1,AD0};
assign cs = {CS1,CS0};

defparam RAM_U0.ADDR_WIDTH = 10;
defparam RAM_U0.DATA_WIDTH = 16;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_SPRAM_16K RAM_U0(
		.CEN(CEN),
		.CLK(CLK),
		.WR(WR),
		.CS(cs),
		.RST(RST),
		.DI(di),
		.AD(ad),
		.DO(do)
		);

specify
	$width (posedge CLK, 1, 0, notifier);
	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge CLK, DI0, 1, 0);
	$setuphold  (posedge CLK, DI1, 1, 0);
	$setuphold  (posedge CLK, DI2, 1, 0);
	$setuphold  (posedge CLK, DI3, 1, 0);
	$setuphold  (posedge CLK, DI4, 1, 0);
	$setuphold  (posedge CLK, DI5, 1, 0);
	$setuphold  (posedge CLK, DI6, 1, 0);
	$setuphold  (posedge CLK, DI7, 1, 0);
	$setuphold  (posedge CLK, DI8, 1, 0);
	$setuphold  (posedge CLK, DI9, 1, 0);
	$setuphold  (posedge CLK, DI10, 1, 0);
	$setuphold  (posedge CLK, DI11, 1, 0);
	$setuphold  (posedge CLK, DI12, 1, 0);
	$setuphold  (posedge CLK, DI13, 1, 0);
	$setuphold  (posedge CLK, DI14, 1, 0);
	$setuphold  (posedge CLK, DI15, 1, 0);

	$setuphold  (posedge CLK, WR, 1, 0);
	$setuphold  (posedge CLK, CEN, 1, 0);
	$setuphold  (posedge CLK, CS0, 1, 0);
	$setuphold  (posedge CLK, CS1, 1, 0);

	$setuphold  (posedge CLK, AD0, 1, 0);
	$setuphold  (posedge CLK, AD1, 1, 0);
	$setuphold  (posedge CLK, AD2, 1, 0);
	$setuphold  (posedge CLK, AD3, 1, 0);
	$setuphold  (posedge CLK, AD4, 1, 0);
	$setuphold  (posedge CLK, AD5, 1, 0);
	$setuphold  (posedge CLK, AD6, 1, 0);
	$setuphold  (posedge CLK, AD7, 1, 0);
	$setuphold  (posedge CLK, AD8, 1, 0);
	$setuphold  (posedge CLK, AD9, 1, 0);

        $recovery(posedge RST, posedge CLK, 1); 

	(CLK => DO0) = (0:0:0, 0:0:0);
	(CLK => DO1) = (0:0:0, 0:0:0);
	(CLK => DO2) = (0:0:0, 0:0:0);
	(CLK => DO3) = (0:0:0, 0:0:0);
	(CLK => DO4) = (0:0:0, 0:0:0);
	(CLK => DO5) = (0:0:0, 0:0:0);
	(CLK => DO6) = (0:0:0, 0:0:0);
	(CLK => DO7) = (0:0:0, 0:0:0);
	(CLK => DO8) = (0:0:0, 0:0:0);
	(CLK => DO9) = (0:0:0, 0:0:0);
	(CLK => DO10) = (0:0:0, 0:0:0);
	(CLK => DO11) = (0:0:0, 0:0:0);
	(CLK => DO12) = (0:0:0, 0:0:0);
	(CLK => DO13) = (0:0:0, 0:0:0);
	(CLK => DO14) = (0:0:0, 0:0:0);
	(CLK => DO15) = (0:0:0, 0:0:0);

	(RST => DO0) = (0:0:0, 0:0:0);
	(RST => DO1) = (0:0:0, 0:0:0);
	(RST => DO2) = (0:0:0, 0:0:0);
	(RST => DO3) = (0:0:0, 0:0:0);
	(RST => DO4) = (0:0:0, 0:0:0);
	(RST => DO5) = (0:0:0, 0:0:0);
	(RST => DO6) = (0:0:0, 0:0:0);
	(RST => DO7) = (0:0:0, 0:0:0);
	(RST => DO8) = (0:0:0, 0:0:0);
	(RST => DO9) = (0:0:0, 0:0:0);
	(RST => DO10) = (0:0:0, 0:0:0);
	(RST => DO11) = (0:0:0, 0:0:0);
	(RST => DO12) = (0:0:0, 0:0:0);
	(RST => DO13) = (0:0:0, 0:0:0);
	(RST => DO14) = (0:0:0, 0:0:0);
	(RST => DO15) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16K_X32(CEN,CLK,WR,CS0,CS1,RST,
                  DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,
                  DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15,
                  DI16,DI17,DI18,DI19,DI20,DI21,DI22,DI23,
                  DI24,DI25,DI26,DI27,DI28,DI29,DI30,DI31,
                  AD0,AD1,AD2,AD3,AD4,AD5,AD6,AD7,AD8,
                  DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,
                  DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15,
                  DO16,DO17,DO18,DO19,DO20,DO21,DO22,DO23,
                  DO24,DO25,DO26,DO27,DO28,DO29,DO30,DO31
 );

parameter RAM_INIT_FILE = "";

input  CEN;
input  CLK;
input  WR;
input  CS0;
input  CS1;
input  RST;
input  AD0;
input  AD1;
input  AD2;
input  AD3;
input  AD4;
input  AD5;
input  AD6;
input  AD7;
input  AD8;
input  DI0;
input  DI1;
input  DI2;
input  DI3;
input  DI4;
input  DI5;
input  DI6;
input  DI7;
input  DI8;
input  DI9;
input  DI10;
input  DI11;
input  DI12;
input  DI13;
input  DI14;
input  DI15;
input  DI16;
input  DI17;
input  DI18;
input  DI19;
input  DI20;
input  DI21;
input  DI22;
input  DI23;
input  DI24;
input  DI25;
input  DI26;
input  DI27;
input  DI28;
input  DI29;
input  DI30;
input  DI31;

output DO0;
output DO1;
output DO2;
output DO3;
output DO4;
output DO5;
output DO6;
output DO7;
output DO8;
output DO9;
output DO10;
output DO11;
output DO12;
output DO13;
output DO14;
output DO15;
output DO16;
output DO17;
output DO18;
output DO19;
output DO20;
output DO21;
output DO22;
output DO23;
output DO24;
output DO25;
output DO26;
output DO27;
output DO28;
output DO29;
output DO30;
output DO31;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [31:0] di;
wire [31:0] do;
wire [8:0] ad;
wire [1:0] cs;
reg notifier;

assign cs = {CS1,CS0};

assign di = {DI31,DI30,DI29,DI28,DI27,DI26,DI25,DI24,DI23,DI22,DI21,DI20,DI19,DI18,DI17,DI16,DI15,DI14,DI13,DI12,DI11,DI10,DI9,DI8,DI7,DI6,DI5,DI4,DI3,DI2,DI1,DI0};
//assign {DO31,DO30,DO29,DO28,DO27,DO26,DO25,DO24,DO23,DO22,DO21,DO20,DO19,DO18,DO17,DO16,DO15,DO14,DO13,DO12,DO11,DO10,DO9,DO8,DO7,DO6,DO5,DO4,DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
buf INSXQ4 (DO4,do[4]);
buf INSXQ5 (DO5,do[5]);
buf INSXQ6 (DO6,do[6]);
buf INSXQ7 (DO7,do[7]);
buf INSXQ8 (DO8,do[8]);
buf INSXQ9 (DO9,do[9]);

buf INSXQ10 (DO10,do[10]);
buf INSXQ11 (DO11,do[11]);
buf INSXQ12 (DO12,do[12]);
buf INSXQ13 (DO13,do[13]);
buf INSXQ14 (DO14,do[14]);
buf INSXQ15 (DO15,do[15]);
buf INSXQ16 (DO16,do[16]);
buf INSXQ17 (DO17,do[17]);
buf INSXQ18 (DO18,do[18]);
buf INSXQ19 (DO19,do[19]);

buf INSXQ20 (DO20,do[20]);
buf INSXQ21 (DO21,do[21]);
buf INSXQ22 (DO22,do[22]);
buf INSXQ23 (DO23,do[23]);
buf INSXQ24 (DO24,do[24]);
buf INSXQ25 (DO25,do[25]);
buf INSXQ26 (DO26,do[26]);
buf INSXQ27 (DO27,do[27]);
buf INSXQ28 (DO28,do[28]);
buf INSXQ29 (DO29,do[29]);

buf INSXQ30 (DO30,do[30]);
buf INSXQ31 (DO31,do[31]);

assign ad = {AD8,AD7,AD6,AD5,AD4,AD3,AD2,AD1,AD0};

defparam RAM_U0.ADDR_WIDTH = 9;
defparam RAM_U0.DATA_WIDTH = 32;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_SPRAM_16K RAM_U0(
		.CEN(CEN),
		.CLK(CLK),
		.WR(WR),
		.CS(cs),
		.RST(RST),
		.DI(di),
		.AD(ad),
		.DO(do)
		);


specify
	$width (posedge CLK, 1, 0, notifier);
	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge CLK, DI0, 1, 0);
	$setuphold  (posedge CLK, DI1, 1, 0);
	$setuphold  (posedge CLK, DI2, 1, 0);
	$setuphold  (posedge CLK, DI3, 1, 0);
	$setuphold  (posedge CLK, DI4, 1, 0);
	$setuphold  (posedge CLK, DI5, 1, 0);
	$setuphold  (posedge CLK, DI6, 1, 0);
	$setuphold  (posedge CLK, DI7, 1, 0);
	$setuphold  (posedge CLK, DI8, 1, 0);
	$setuphold  (posedge CLK, DI9, 1, 0);
	$setuphold  (posedge CLK, DI10, 1, 0);
	$setuphold  (posedge CLK, DI11, 1, 0);
	$setuphold  (posedge CLK, DI12, 1, 0);
	$setuphold  (posedge CLK, DI13, 1, 0);
	$setuphold  (posedge CLK, DI14, 1, 0);
	$setuphold  (posedge CLK, DI15, 1, 0);
	$setuphold  (posedge CLK, DI16, 1, 0);
	$setuphold  (posedge CLK, DI17, 1, 0);
	$setuphold  (posedge CLK, DI18, 1, 0);
	$setuphold  (posedge CLK, DI19, 1, 0);
	$setuphold  (posedge CLK, DI20, 1, 0);
	$setuphold  (posedge CLK, DI21, 1, 0);
	$setuphold  (posedge CLK, DI22, 1, 0);
	$setuphold  (posedge CLK, DI23, 1, 0);
	$setuphold  (posedge CLK, DI24, 1, 0);
	$setuphold  (posedge CLK, DI25, 1, 0);
	$setuphold  (posedge CLK, DI26, 1, 0);
	$setuphold  (posedge CLK, DI27, 1, 0);
	$setuphold  (posedge CLK, DI28, 1, 0);
	$setuphold  (posedge CLK, DI29, 1, 0);
	$setuphold  (posedge CLK, DI30, 1, 0);
	$setuphold  (posedge CLK, DI31, 1, 0);

	$setuphold  (posedge CLK, WR, 1, 0);
	$setuphold  (posedge CLK, CEN, 1, 0);
	$setuphold  (posedge CLK, CS0, 1, 0);
	$setuphold  (posedge CLK, CS1, 1, 0);

	$setuphold  (posedge CLK, AD0, 1, 0);
	$setuphold  (posedge CLK, AD1, 1, 0);
	$setuphold  (posedge CLK, AD2, 1, 0);
	$setuphold  (posedge CLK, AD3, 1, 0);
	$setuphold  (posedge CLK, AD4, 1, 0);
	$setuphold  (posedge CLK, AD5, 1, 0);
	$setuphold  (posedge CLK, AD6, 1, 0);
	$setuphold  (posedge CLK, AD7, 1, 0);
	$setuphold  (posedge CLK, AD8, 1, 0);

        $recovery(posedge RST, posedge CLK, 1); 

	(CLK => DO0) = (0:0:0, 0:0:0);
	(CLK => DO1) = (0:0:0, 0:0:0);
	(CLK => DO2) = (0:0:0, 0:0:0);
	(CLK => DO3) = (0:0:0, 0:0:0);
	(CLK => DO4) = (0:0:0, 0:0:0);
	(CLK => DO5) = (0:0:0, 0:0:0);
	(CLK => DO6) = (0:0:0, 0:0:0);
	(CLK => DO7) = (0:0:0, 0:0:0);
	(CLK => DO8) = (0:0:0, 0:0:0);
	(CLK => DO9) = (0:0:0, 0:0:0);
	(CLK => DO10) = (0:0:0, 0:0:0);
	(CLK => DO11) = (0:0:0, 0:0:0);
	(CLK => DO12) = (0:0:0, 0:0:0);
	(CLK => DO13) = (0:0:0, 0:0:0);
	(CLK => DO14) = (0:0:0, 0:0:0);
	(CLK => DO15) = (0:0:0, 0:0:0);
	(CLK => DO16) = (0:0:0, 0:0:0);
	(CLK => DO17) = (0:0:0, 0:0:0);
	(CLK => DO18) = (0:0:0, 0:0:0);
	(CLK => DO19) = (0:0:0, 0:0:0);
	(CLK => DO20) = (0:0:0, 0:0:0);
	(CLK => DO21) = (0:0:0, 0:0:0);
	(CLK => DO22) = (0:0:0, 0:0:0);
	(CLK => DO23) = (0:0:0, 0:0:0);
	(CLK => DO24) = (0:0:0, 0:0:0);
	(CLK => DO25) = (0:0:0, 0:0:0);
	(CLK => DO26) = (0:0:0, 0:0:0);
	(CLK => DO27) = (0:0:0, 0:0:0);
	(CLK => DO28) = (0:0:0, 0:0:0);
	(CLK => DO29) = (0:0:0, 0:0:0);
	(CLK => DO30) = (0:0:0, 0:0:0);
	(CLK => DO31) = (0:0:0, 0:0:0);

	(RST => DO0) = (0:0:0, 0:0:0);
	(RST => DO1) = (0:0:0, 0:0:0);
	(RST => DO2) = (0:0:0, 0:0:0);
	(RST => DO3) = (0:0:0, 0:0:0);
	(RST => DO4) = (0:0:0, 0:0:0);
	(RST => DO5) = (0:0:0, 0:0:0);
	(RST => DO6) = (0:0:0, 0:0:0);
	(RST => DO7) = (0:0:0, 0:0:0);
	(RST => DO8) = (0:0:0, 0:0:0);
	(RST => DO9) = (0:0:0, 0:0:0);
	(RST => DO10) = (0:0:0, 0:0:0);
	(RST => DO11) = (0:0:0, 0:0:0);
	(RST => DO12) = (0:0:0, 0:0:0);
	(RST => DO13) = (0:0:0, 0:0:0);
	(RST => DO14) = (0:0:0, 0:0:0);
	(RST => DO15) = (0:0:0, 0:0:0);
	(RST => DO16) = (0:0:0, 0:0:0);
	(RST => DO17) = (0:0:0, 0:0:0);
	(RST => DO18) = (0:0:0, 0:0:0);
	(RST => DO19) = (0:0:0, 0:0:0);
	(RST => DO20) = (0:0:0, 0:0:0);
	(RST => DO21) = (0:0:0, 0:0:0);
	(RST => DO22) = (0:0:0, 0:0:0);
	(RST => DO23) = (0:0:0, 0:0:0);
	(RST => DO24) = (0:0:0, 0:0:0);
	(RST => DO25) = (0:0:0, 0:0:0);
	(RST => DO26) = (0:0:0, 0:0:0);
	(RST => DO27) = (0:0:0, 0:0:0);
	(RST => DO28) = (0:0:0, 0:0:0);
	(RST => DO29) = (0:0:0, 0:0:0);
	(RST => DO30) = (0:0:0, 0:0:0);
	(RST => DO31) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB8K_X1_X1(CENA,CLKA,WRA,CSA0,CSA1,RSTA,
                    CENB,CLKB,WRB,CSB0,CSB1,RSTB,
                    DIA0,
                    ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,ADA10,ADA11,ADA12,
                    DIB0,
                    ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8,ADB9,ADB10,ADB11,ADB12,
                    DOA0,
                    DOB0
);

parameter RAM_INIT_FILE = "";

input  CENA,CLKA,WRA,CSA0,CSA1,RSTA;
input  CENB,CLKB,WRB,CSB0,CSB1,RSTB;
input  DIA0;
input  ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,ADA10,ADA11,ADA12;
input  DIB0;
input  ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8,ADB9,ADB10,ADB11,ADB12;

output  DOA0;
output  DOB0;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [0:0] dia;
wire [0:0] doa;

wire [12:0] ada;
wire [12:0] adb;

wire [0:0] dib;
wire [0:0] dob;

wire [1:0] CSA, CSB;
reg notifier;

assign CSA  = { CSA1, CSA0};
assign CSB  = { CSB1, CSB0};

assign dia  = {DIA0};
//assign {DOA0} = doa;

assign dib  = {DIB0};
//assign {DOB0} = dob;
buf INSXQA (DOA0,doa);
buf INSXQB (DOB0,dob);
assign ada = {ADA12,ADA11,ADA10,ADA9,ADA8,ADA7,ADA6,ADA5,ADA4,ADA3,ADA2,ADA1,ADA0};
assign adb = {ADB12,ADB11,ADB10,ADB9,ADB8,ADB7,ADB6,ADB5,ADB4,ADB3,ADB2,ADB1,ADB0};

defparam RAM_U0.ADDR_WIDTH_A = 13;
defparam RAM_U0.DATA_WIDTH_A = 1;

defparam RAM_U0.ADDR_WIDTH_B = 13;
defparam RAM_U0.DATA_WIDTH_B = 1;

defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;


SC_DPRAM_16K RAM_U0(
		.CENA(CENA),
		.CLKA(CLKA),
		.WRA(WRA),
		.CSA(CSA),
		.RSTA(RSTA),
		.DIA(dia),
		.ADA(ada),
		.DOA(doa),
		.CENB(CENB),
		.CLKB(CLKB),
		.WRB(WRB),
		.CSB(CSB),
		.RSTB(RSTB),
		.DIB(dib),
		.ADB(adb),
		.DOB(dob)
	     );



specify
	$width (posedge CLKA, 1, 0, notifier);
	$width (posedge CLKB, 1, 0, notifier);

	$width (posedge RSTA, 1, 0, notifier);
	$width (posedge RSTB, 1, 0, notifier);

	$setuphold  (posedge CLKA, DIA0, 1, 0);

	$setuphold  (posedge CLKA, CENA, 1, 0);
	$setuphold  (posedge CLKA, WRA, 1, 0);
	$setuphold  (posedge CLKA, CSA0, 1, 0);
	$setuphold  (posedge CLKA, CSA1, 1, 0);

	$setuphold  (posedge CLKA, ADA0, 1, 0);
	$setuphold  (posedge CLKA, ADA1, 1, 0);
	$setuphold  (posedge CLKA, ADA2, 1, 0);
	$setuphold  (posedge CLKA, ADA3, 1, 0);
	$setuphold  (posedge CLKA, ADA4, 1, 0);
	$setuphold  (posedge CLKA, ADA5, 1, 0);
	$setuphold  (posedge CLKA, ADA6, 1, 0);
	$setuphold  (posedge CLKA, ADA7, 1, 0);
	$setuphold  (posedge CLKA, ADA8, 1, 0);
	$setuphold  (posedge CLKA, ADA9, 1, 0);
	$setuphold  (posedge CLKA, ADA10, 1, 0);
	$setuphold  (posedge CLKA, ADA11, 1, 0);
	$setuphold  (posedge CLKA, ADA12, 1, 0);

        $recovery(posedge RSTA, posedge CLKA, 1); 

	$setuphold  (posedge CLKB, DIB0, 1, 0);

	$setuphold  (posedge CLKB, CENB, 1, 0);
	$setuphold  (posedge CLKB, WRB, 1, 0);
	$setuphold  (posedge CLKB, CSB0, 1, 0);
	$setuphold  (posedge CLKB, CSB1, 1, 0);

	$setuphold  (posedge CLKB, ADB0, 1, 0);
	$setuphold  (posedge CLKB, ADB1, 1, 0);
	$setuphold  (posedge CLKB, ADB2, 1, 0);
	$setuphold  (posedge CLKB, ADB3, 1, 0);
	$setuphold  (posedge CLKB, ADB4, 1, 0);
	$setuphold  (posedge CLKB, ADB5, 1, 0);
	$setuphold  (posedge CLKB, ADB6, 1, 0);
	$setuphold  (posedge CLKB, ADB7, 1, 0);
	$setuphold  (posedge CLKB, ADB8, 1, 0);
	$setuphold  (posedge CLKB, ADB9, 1, 0);
	$setuphold  (posedge CLKB, ADB10, 1, 0);
	$setuphold  (posedge CLKB, ADB11, 1, 0);
	$setuphold  (posedge CLKB, ADB12, 1, 0);

        $recovery(posedge RSTB, posedge CLKB, 1); 

	(CLKA => DOA0) = (0:0:0, 0:0:0);
	(RSTA => DOA0) = (0:0:0, 0:0:0);

	(CLKB => DOB0) = (0:0:0, 0:0:0);
	(RSTB => DOB0) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB8K_X1_X2(CENA,CLKA,WRA,CSA0,CSA1,RSTA,
                    CENB,CLKB,WRB,CSB0,CSB1,RSTB,
                    DIA0,
                    ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,ADA10,ADA11,ADA12,
                    DIB0,DIB1,
                    ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8,ADB9,ADB10,ADB11,
                    DOA0,
                    DOB0,DOB1
);

parameter RAM_INIT_FILE = "";

input  CENA,CLKA,WRA,CSA0,CSA1,RSTA;
input  CENB,CLKB,WRB,CSB0,CSB1,RSTB;
input  DIA0;
input  ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,ADA10,ADA11,ADA12;
input  DIB0,DIB1;
input  ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8,ADB9,ADB10,ADB11;

output  DOA0;
output  DOB0,DOB1;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [0:0] dia;
wire [0:0] doa;

wire [12:0] ada;
wire [11:0] adb;

wire [1:0] dib;
wire [1:0] dob;

wire [1:0] CSA, CSB;
reg notifier;

assign CSA  = { CSA1, CSA0};
assign CSB  = { CSB1, CSB0};

assign dia  = {DIA0};
//assign {DOA0} = doa;

assign dib  = {DIB1,DIB0};
//assign {DOB1,DOB0} = dob;
buf INSXQA (DOA0,doa);
buf INSXQB0 (DOB0,dob[0]);
buf INSXQB1 (DOB1,dob[1]);
assign ada = {ADA12,ADA11,ADA10,ADA9,ADA8,ADA7,ADA6,ADA5,ADA4,ADA3,ADA2,ADA1,ADA0};
assign adb = {ADB11,ADB10,ADB9,ADB8,ADB7,ADB6,ADB5,ADB4,ADB3,ADB2,ADB1,ADB0};

defparam RAM_U0.ADDR_WIDTH_A = 13;
defparam RAM_U0.DATA_WIDTH_A = 1;

defparam RAM_U0.ADDR_WIDTH_B = 12;
defparam RAM_U0.DATA_WIDTH_B = 2;

defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_DPRAM_16K RAM_U0(
		.CENA(CENA),
		.CLKA(CLKA),
		.WRA(WRA),
		.CSA(CSA),
		.RSTA(RSTA),
		.DIA(dia),
		.ADA(ada),
		.DOA(doa),
		.CENB(CENB),
		.CLKB(CLKB),
		.WRB(WRB),
		.CSB(CSB),
		.RSTB(RSTB),
		.DIB(dib),
		.ADB(adb),
		.DOB(dob)
	     );


specify
	$width (posedge CLKA, 1, 0, notifier);
	$width (posedge CLKB, 1, 0, notifier);

	$width (posedge RSTA, 1, 0, notifier);
	$width (posedge RSTB, 1, 0, notifier);

	$setuphold  (posedge CLKA, DIA0, 1, 0);

	$setuphold  (posedge CLKA, CENA, 1, 0);
	$setuphold  (posedge CLKA, WRA, 1, 0);
	$setuphold  (posedge CLKA, CSA0, 1, 0);
	$setuphold  (posedge CLKA, CSA1, 1, 0);

	$setuphold  (posedge CLKA, ADA0, 1, 0);
	$setuphold  (posedge CLKA, ADA1, 1, 0);
	$setuphold  (posedge CLKA, ADA2, 1, 0);
	$setuphold  (posedge CLKA, ADA3, 1, 0);
	$setuphold  (posedge CLKA, ADA4, 1, 0);
	$setuphold  (posedge CLKA, ADA5, 1, 0);
	$setuphold  (posedge CLKA, ADA6, 1, 0);
	$setuphold  (posedge CLKA, ADA7, 1, 0);
	$setuphold  (posedge CLKA, ADA8, 1, 0);
	$setuphold  (posedge CLKA, ADA9, 1, 0);
	$setuphold  (posedge CLKA, ADA10, 1, 0);
	$setuphold  (posedge CLKA, ADA11, 1, 0);
	$setuphold  (posedge CLKA, ADA12, 1, 0);

        $recovery(posedge RSTA, posedge CLKA, 1); 

	$setuphold  (posedge CLKB, DIB0, 1, 0);
	$setuphold  (posedge CLKB, DIB1, 1, 0);

	$setuphold  (posedge CLKB, CENB, 1, 0);

	$setuphold  (posedge CLKB, WRB, 1, 0);
	$setuphold  (posedge CLKB, CSB0, 1, 0);
	$setuphold  (posedge CLKB, CSB1, 1, 0);

	$setuphold  (posedge CLKB, ADB0, 1, 0);
	$setuphold  (posedge CLKB, ADB1, 1, 0);
	$setuphold  (posedge CLKB, ADB2, 1, 0);
	$setuphold  (posedge CLKB, ADB3, 1, 0);
	$setuphold  (posedge CLKB, ADB4, 1, 0);
	$setuphold  (posedge CLKB, ADB5, 1, 0);
	$setuphold  (posedge CLKB, ADB6, 1, 0);
	$setuphold  (posedge CLKB, ADB7, 1, 0);
	$setuphold  (posedge CLKB, ADB8, 1, 0);
	$setuphold  (posedge CLKB, ADB9, 1, 0);
	$setuphold  (posedge CLKB, ADB10, 1, 0);
	$setuphold  (posedge CLKB, ADB11, 1, 0);

        $recovery(posedge RSTB, posedge CLKB, 1); 

	(CLKA => DOA0) = (0:0:0, 0:0:0);
	(RSTA => DOA0) = (0:0:0, 0:0:0);

	(CLKB => DOB0) = (0:0:0, 0:0:0);
	(RSTB => DOB0) = (0:0:0, 0:0:0);
	(CLKB => DOB1) = (0:0:0, 0:0:0);
	(RSTB => DOB1) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB8K_X1_X4(CENA,CLKA,WRA,CSA0,CSA1,RSTA,
                    CENB,CLKB,WRB,CSB0,CSB1,RSTB,
                    DIA0,
                    ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,ADA10,ADA11,ADA12,
                    DIB0,DIB1,DIB2,DIB3,
                    ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8,ADB9,ADB10,
                    DOA0,
                    DOB0,DOB1,DOB2,DOB3
);

parameter RAM_INIT_FILE = "";

input  CENA,CLKA,WRA,CSA0,CSA1,RSTA;
input  CENB,CLKB,WRB,CSB0,CSB1,RSTB;
input  DIA0;
input  ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,ADA10,ADA11,ADA12;
input  DIB0,DIB1,DIB2,DIB3;
input  ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8,ADB9,ADB10;

output  DOA0;
output  DOB0,DOB1,DOB2,DOB3;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [0:0] dia;
wire [0:0] doa;

wire [12:0] ada;
wire [10:0] adb;

wire [3:0] dib;
wire [3:0] dob;

wire [1:0] CSA, CSB;
reg notifier;

assign CSA  = { CSA1, CSA0};
assign CSB  = { CSB1, CSB0};

assign dia  = {DIA0};
//assign {DOA0} = doa;

assign dib  = {DIB3,DIB2,DIB1,DIB0};
//assign {DOB3,DOB2,DOB1,DOB0} = dob;
buf INSXQA (DOA0,doa);
buf INSXQB0 (DOB0,dob[0]);
buf INSXQB1 (DOB1,dob[1]);
buf INSXQB2 (DOB2,dob[2]);
buf INSXQB3 (DOB3,dob[3]);

assign ada = {ADA12,ADA11,ADA10,ADA9,ADA8,ADA7,ADA6,ADA5,ADA4,ADA3,ADA2,ADA1,ADA0};
assign adb = {ADB10,ADB9,ADB8,ADB7,ADB6,ADB5,ADB4,ADB3,ADB2,ADB1,ADB0};

defparam RAM_U0.ADDR_WIDTH_A = 13;
defparam RAM_U0.DATA_WIDTH_A = 1;

defparam RAM_U0.ADDR_WIDTH_B = 11;
defparam RAM_U0.DATA_WIDTH_B = 4;

defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_DPRAM_16K RAM_U0(
		.CENA(CENA),
		.CLKA(CLKA),
		.WRA(WRA),
		.CSA(CSA),
		.RSTA(RSTA),
		.DIA(dia),
		.ADA(ada),
		.DOA(doa),
		.CENB(CENB),
		.CLKB(CLKB),
		.WRB(WRB),
		.CSB(CSB),
		.RSTB(RSTB),
		.DIB(dib),
		.ADB(adb),
		.DOB(dob)
	     );


specify
	$width (posedge CLKA, 1, 0, notifier);
	$width (posedge CLKB, 1, 0, notifier);

	$width (posedge RSTA, 1, 0, notifier);
	$width (posedge RSTB, 1, 0, notifier);

	$setuphold  (posedge CLKA, DIA0, 1, 0);

	$setuphold  (posedge CLKA, CENA, 1, 0);
	$setuphold  (posedge CLKA, WRA, 1, 0);
	$setuphold  (posedge CLKA, CSA0, 1, 0);
	$setuphold  (posedge CLKA, CSA1, 1, 0);

	$setuphold  (posedge CLKA, ADA0, 1, 0);
	$setuphold  (posedge CLKA, ADA1, 1, 0);
	$setuphold  (posedge CLKA, ADA2, 1, 0);
	$setuphold  (posedge CLKA, ADA3, 1, 0);
	$setuphold  (posedge CLKA, ADA4, 1, 0);
	$setuphold  (posedge CLKA, ADA5, 1, 0);
	$setuphold  (posedge CLKA, ADA6, 1, 0);
	$setuphold  (posedge CLKA, ADA7, 1, 0);
	$setuphold  (posedge CLKA, ADA8, 1, 0);
	$setuphold  (posedge CLKA, ADA9, 1, 0);
	$setuphold  (posedge CLKA, ADA10, 1, 0);
	$setuphold  (posedge CLKA, ADA11, 1, 0);
	$setuphold  (posedge CLKA, ADA12, 1, 0);

        $recovery(posedge RSTA, posedge CLKA, 1); 

	$setuphold  (posedge CLKB, DIB0, 1, 0);
	$setuphold  (posedge CLKB, DIB1, 1, 0);
	$setuphold  (posedge CLKB, DIB2, 1, 0);
	$setuphold  (posedge CLKB, DIB3, 1, 0);

	$setuphold  (posedge CLKB, CENB, 1, 0);
	$setuphold  (posedge CLKB, WRB, 1, 0);
	$setuphold  (posedge CLKB, CSB0, 1, 0);
	$setuphold  (posedge CLKB, CSB1, 1, 0);

	$setuphold  (posedge CLKB, ADB0, 1, 0);
	$setuphold  (posedge CLKB, ADB1, 1, 0);
	$setuphold  (posedge CLKB, ADB2, 1, 0);
	$setuphold  (posedge CLKB, ADB3, 1, 0);
	$setuphold  (posedge CLKB, ADB4, 1, 0);
	$setuphold  (posedge CLKB, ADB5, 1, 0);
	$setuphold  (posedge CLKB, ADB6, 1, 0);
	$setuphold  (posedge CLKB, ADB7, 1, 0);
	$setuphold  (posedge CLKB, ADB8, 1, 0);
	$setuphold  (posedge CLKB, ADB9, 1, 0);
	$setuphold  (posedge CLKB, ADB10, 1, 0);

        $recovery(posedge RSTB, posedge CLKB, 1); 

	(CLKA => DOA0) = (0:0:0, 0:0:0);
	(RSTA => DOA0) = (0:0:0, 0:0:0);

	(CLKB => DOB0) = (0:0:0, 0:0:0);
	(RSTB => DOB0) = (0:0:0, 0:0:0);
	(CLKB => DOB1) = (0:0:0, 0:0:0);
	(RSTB => DOB1) = (0:0:0, 0:0:0);
	(CLKB => DOB2) = (0:0:0, 0:0:0);
	(RSTB => DOB2) = (0:0:0, 0:0:0);
	(CLKB => DOB3) = (0:0:0, 0:0:0);
	(RSTB => DOB3) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB8K_X1_X8(CENA,CLKA,WRA,CSA0,CSA1,RSTA,
                    CENB,CLKB,WRB,CSB0,CSB1,RSTB,
                    DIA0,
                    ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,ADA10,ADA11,ADA12,
                    DIB0,DIB1,DIB2,DIB3,DIB4,DIB5,DIB6,DIB7,
                    ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8,ADB9,
                    DOA0,
                    DOB0,DOB1,DOB2,DOB3,DOB4,DOB5,DOB6,DOB7
);

parameter RAM_INIT_FILE = "";

input  CENA,CLKA,WRA,CSA0,CSA1,RSTA;
input  CENB,CLKB,WRB,CSB0,CSB1,RSTB;
input  DIA0;
input  ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,ADA10,ADA11,ADA12;
input  DIB0,DIB1,DIB2,DIB3,DIB4,DIB5,DIB6,DIB7;
input  ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8,ADB9;

output  DOA0;
output  DOB0,DOB1,DOB2,DOB3,DOB4,DOB5,DOB6,DOB7;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [0:0] dia;
wire [0:0] doa;

wire [12:0] ada;
wire [9:0] adb;

wire [7:0] dib;
wire [7:0] dob;

wire [1:0] CSA, CSB;
reg notifier;

assign CSA  = { CSA1, CSA0};
assign CSB  = { CSB1, CSB0};

assign dia  = {DIA0};
//assign {DOA0} = doa;

assign dib  = {DIB7,DIB6,DIB5,DIB4,DIB3,DIB2,DIB1,DIB0};
//assign {DOB7,DOB6,DOB5,DOB4,DOB3,DOB2,DOB1,DOB0} = dob;
buf INSXQA (DOA0,doa);
buf INSXQB0 (DOB0,dob[0]);
buf INSXQB1 (DOB1,dob[1]);
buf INSXQB2 (DOB2,dob[2]);
buf INSXQB3 (DOB3,dob[3]);
buf INSXQB4 (DOB4,dob[4]);
buf INSXQB5 (DOB5,dob[5]);
buf INSXQB6 (DOB6,dob[6]);
buf INSXQB7 (DOB7,dob[7]);

assign ada = {ADA12,ADA11,ADA10,ADA9,ADA8,ADA7,ADA6,ADA5,ADA4,ADA3,ADA2,ADA1,ADA0};
assign adb = {ADB9,ADB8,ADB7,ADB6,ADB5,ADB4,ADB3,ADB2,ADB1,ADB0};

defparam RAM_U0.ADDR_WIDTH_A = 13;
defparam RAM_U0.DATA_WIDTH_A = 1;

defparam RAM_U0.ADDR_WIDTH_B = 10;
defparam RAM_U0.DATA_WIDTH_B = 8;

defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_DPRAM_16K RAM_U0(
		.CENA(CENA),
		.CLKA(CLKA),
		.WRA(WRA),
		.CSA(CSA),
		.RSTA(RSTA),
		.DIA(dia),
		.ADA(ada),
		.DOA(doa),
		.CENB(CENB),
		.CLKB(CLKB),
		.WRB(WRB),
		.CSB(CSB),
		.RSTB(RSTB),
		.DIB(dib),
		.ADB(adb),
		.DOB(dob)
	     );


specify
	$width (posedge CLKA, 1, 0, notifier);
	$width (posedge CLKB, 1, 0, notifier);

	$width (posedge RSTA, 1, 0, notifier);
	$width (posedge RSTB, 1, 0, notifier);

	$setuphold  (posedge CLKA, DIA0, 1, 0);

	$setuphold  (posedge CLKA, CENA, 1, 0);
	$setuphold  (posedge CLKA, WRA, 1, 0);
	$setuphold  (posedge CLKA, CSA0, 1, 0);
	$setuphold  (posedge CLKA, CSA1, 1, 0);

	$setuphold  (posedge CLKA, ADA0, 1, 0);
	$setuphold  (posedge CLKA, ADA1, 1, 0);
	$setuphold  (posedge CLKA, ADA2, 1, 0);
	$setuphold  (posedge CLKA, ADA3, 1, 0);
	$setuphold  (posedge CLKA, ADA4, 1, 0);
	$setuphold  (posedge CLKA, ADA5, 1, 0);
	$setuphold  (posedge CLKA, ADA6, 1, 0);
	$setuphold  (posedge CLKA, ADA7, 1, 0);
	$setuphold  (posedge CLKA, ADA8, 1, 0);
	$setuphold  (posedge CLKA, ADA9, 1, 0);
	$setuphold  (posedge CLKA, ADA10, 1, 0);
	$setuphold  (posedge CLKA, ADA11, 1, 0);
	$setuphold  (posedge CLKA, ADA12, 1, 0);

        $recovery(posedge RSTA, posedge CLKA, 1); 

	$setuphold  (posedge CLKB, DIB0, 1, 0);
	$setuphold  (posedge CLKB, DIB1, 1, 0);
	$setuphold  (posedge CLKB, DIB2, 1, 0);
	$setuphold  (posedge CLKB, DIB3, 1, 0);
	$setuphold  (posedge CLKB, DIB4, 1, 0);
	$setuphold  (posedge CLKB, DIB5, 1, 0);
	$setuphold  (posedge CLKB, DIB6, 1, 0);
	$setuphold  (posedge CLKB, DIB7, 1, 0);

	$setuphold  (posedge CLKB, CENB, 1, 0);
	$setuphold  (posedge CLKB, WRB, 1, 0);
	$setuphold  (posedge CLKB, CSB0, 1, 0);
	$setuphold  (posedge CLKB, CSB1, 1, 0);

	$setuphold  (posedge CLKB, ADB0, 1, 0);
	$setuphold  (posedge CLKB, ADB1, 1, 0);
	$setuphold  (posedge CLKB, ADB2, 1, 0);
	$setuphold  (posedge CLKB, ADB3, 1, 0);
	$setuphold  (posedge CLKB, ADB4, 1, 0);
	$setuphold  (posedge CLKB, ADB5, 1, 0);
	$setuphold  (posedge CLKB, ADB6, 1, 0);
	$setuphold  (posedge CLKB, ADB7, 1, 0);
	$setuphold  (posedge CLKB, ADB8, 1, 0);
	$setuphold  (posedge CLKB, ADB9, 1, 0);

        $recovery(posedge RSTB, posedge CLKB, 1); 

	(CLKA => DOA0) = (0:0:0, 0:0:0);
	(RSTA => DOA0) = (0:0:0, 0:0:0);

	(CLKB => DOB0) = (0:0:0, 0:0:0);
	(RSTB => DOB0) = (0:0:0, 0:0:0);
	(CLKB => DOB1) = (0:0:0, 0:0:0);
	(RSTB => DOB1) = (0:0:0, 0:0:0);
	(CLKB => DOB2) = (0:0:0, 0:0:0);
	(RSTB => DOB2) = (0:0:0, 0:0:0);
	(CLKB => DOB3) = (0:0:0, 0:0:0);
	(RSTB => DOB3) = (0:0:0, 0:0:0);
	(CLKB => DOB4) = (0:0:0, 0:0:0);
	(RSTB => DOB4) = (0:0:0, 0:0:0);
	(CLKB => DOB5) = (0:0:0, 0:0:0);
	(RSTB => DOB5) = (0:0:0, 0:0:0);
	(CLKB => DOB6) = (0:0:0, 0:0:0);
	(RSTB => DOB6) = (0:0:0, 0:0:0);
	(CLKB => DOB7) = (0:0:0, 0:0:0);
	(RSTB => DOB7) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB8K_X1_X16(CENA,CLKA,WRA,CSA0,CSA1,RSTA,
                    CENB,CLKB,WRB,CSB0,CSB1,RSTB,
                    DIA0,
                    ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,ADA10,ADA11,ADA12,
                    DIB0,DIB1,DIB2,DIB3,DIB4,DIB5,DIB6,DIB7,
                    DIB8,DIB9,DIB10,DIB11,DIB12,DIB13,DIB14,DIB15,
                    ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8,
                    DOA0,
                    DOB0,DOB1,DOB2,DOB3,DOB4,DOB5,DOB6,DOB7,
                    DOB8,DOB9,DOB10,DOB11,DOB12,DOB13,DOB14,DOB15
);

parameter RAM_INIT_FILE = "";

input  CENA,CLKA,WRA,CSA0,CSA1,RSTA;
input  CENB,CLKB,WRB,CSB0,CSB1,RSTB;
input  DIA0;
input  ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,ADA10,ADA11,ADA12;
input  DIB0,DIB1,DIB2,DIB3,DIB4,DIB5,DIB6,DIB7;
input  DIB8,DIB9,DIB10,DIB11,DIB12,DIB13,DIB14,DIB15;
input  ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8;

output  DOA0;
output  DOB0,DOB1,DOB2,DOB3,DOB4,DOB5,DOB6,DOB7;
output  DOB8,DOB9,DOB10,DOB11,DOB12,DOB13,DOB14,DOB15;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [0:0] dia;
wire [0:0] doa;

wire [12:0] ada;
wire [8:0] adb;

wire [15:0] dib;
wire [15:0] dob;

wire [1:0] CSA, CSB;
reg notifier;

assign CSA  = { CSA1, CSA0};
assign CSB  = { CSB1, CSB0};

assign dia  = {DIA0};
//assign {DOA0} = doa;

assign dib  = {DIB15,DIB14,DIB13,DIB12,DIB11,DIB10,DIB9,DIB8,DIB7,DIB6,DIB5,DIB4,DIB3,DIB2,DIB1,DIB0};
//assign {DOB15,DOB14,DOB13,DOB12,DOB11,DOB10,DOB9,DOB8,DOB7,DOB6,DOB5,DOB4,DOB3,DOB2,DOB1,DOB0} = dob;
buf INSXQA (DOA0,doa);
buf INSXQB0 (DOB0,dob[0]);
buf INSXQB1 (DOB1,dob[1]);
buf INSXQB2 (DOB2,dob[2]);
buf INSXQB3 (DOB3,dob[3]);
buf INSXQB4 (DOB4,dob[4]);
buf INSXQB5 (DOB5,dob[5]);
buf INSXQB6 (DOB6,dob[6]);
buf INSXQB7 (DOB7,dob[7]);
buf INSXQB8 (DOB8,dob[8]);
buf INSXQB9 (DOB9,dob[9]);

buf INSXQB10 (DOB10,dob[10]);
buf INSXQB11 (DOB11,dob[11]);
buf INSXQB12 (DOB12,dob[12]);
buf INSXQB13 (DOB13,dob[13]);
buf INSXQB14 (DOB14,dob[14]);
buf INSXQB15 (DOB15,dob[15]);

assign ada = {ADA12,ADA11,ADA10,ADA9,ADA8,ADA7,ADA6,ADA5,ADA4,ADA3,ADA2,ADA1,ADA0};
assign adb = {ADB8,ADB7,ADB6,ADB5,ADB4,ADB3,ADB2,ADB1,ADB0};

defparam RAM_U0.ADDR_WIDTH_A = 13;
defparam RAM_U0.DATA_WIDTH_A = 1;

defparam RAM_U0.ADDR_WIDTH_B = 9;
defparam RAM_U0.DATA_WIDTH_B = 16;

defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_DPRAM_16K RAM_U0(
		.CENA(CENA),
		.CLKA(CLKA),
		.WRA(WRA),
		.CSA(CSA),
		.RSTA(RSTA),
		.DIA(dia),
		.ADA(ada),
		.DOA(doa),
		.CENB(CENB),
		.CLKB(CLKB),
		.WRB(WRB),
		.CSB(CSB),
		.RSTB(RSTB),
		.DIB(dib),
		.ADB(adb),
		.DOB(dob)
	     );

specify
	$width (posedge CLKA, 1, 0, notifier);
	$width (posedge CLKB, 1, 0, notifier);

	$width (posedge RSTA, 1, 0, notifier);
	$width (posedge RSTB, 1, 0, notifier);

	$setuphold  (posedge CLKA, DIA0, 1, 0);

	$setuphold  (posedge CLKA, CENA, 1, 0);
	$setuphold  (posedge CLKA, WRA, 1, 0);
	$setuphold  (posedge CLKA, CSA0, 1, 0);
	$setuphold  (posedge CLKA, CSA1, 1, 0);

	$setuphold  (posedge CLKA, ADA0, 1, 0);
	$setuphold  (posedge CLKA, ADA1, 1, 0);
	$setuphold  (posedge CLKA, ADA2, 1, 0);
	$setuphold  (posedge CLKA, ADA3, 1, 0);
	$setuphold  (posedge CLKA, ADA4, 1, 0);
	$setuphold  (posedge CLKA, ADA5, 1, 0);
	$setuphold  (posedge CLKA, ADA6, 1, 0);
	$setuphold  (posedge CLKA, ADA7, 1, 0);
	$setuphold  (posedge CLKA, ADA8, 1, 0);
	$setuphold  (posedge CLKA, ADA9, 1, 0);
	$setuphold  (posedge CLKA, ADA10, 1, 0);
	$setuphold  (posedge CLKA, ADA11, 1, 0);
	$setuphold  (posedge CLKA, ADA12, 1, 0);

        $recovery(posedge RSTA, posedge CLKA, 1); 

	$setuphold  (posedge CLKB, DIB0, 1, 0);
	$setuphold  (posedge CLKB, DIB1, 1, 0);
	$setuphold  (posedge CLKB, DIB2, 1, 0);
	$setuphold  (posedge CLKB, DIB3, 1, 0);
	$setuphold  (posedge CLKB, DIB4, 1, 0);
	$setuphold  (posedge CLKB, DIB5, 1, 0);
	$setuphold  (posedge CLKB, DIB6, 1, 0);
	$setuphold  (posedge CLKB, DIB7, 1, 0);
	$setuphold  (posedge CLKB, DIB8, 1, 0);
	$setuphold  (posedge CLKB, DIB9, 1, 0);
	$setuphold  (posedge CLKB, DIB10, 1, 0);
	$setuphold  (posedge CLKB, DIB11, 1, 0);
	$setuphold  (posedge CLKB, DIB12, 1, 0);
	$setuphold  (posedge CLKB, DIB13, 1, 0);
	$setuphold  (posedge CLKB, DIB14, 1, 0);
	$setuphold  (posedge CLKB, DIB15, 1, 0);

	$setuphold  (posedge CLKB, CENB, 1, 0);
	$setuphold  (posedge CLKB, WRB, 1, 0);
	$setuphold  (posedge CLKB, CSB0, 1, 0);
	$setuphold  (posedge CLKB, CSB1, 1, 0);

	$setuphold  (posedge CLKB, ADB0, 1, 0);
	$setuphold  (posedge CLKB, ADB1, 1, 0);
	$setuphold  (posedge CLKB, ADB2, 1, 0);
	$setuphold  (posedge CLKB, ADB3, 1, 0);
	$setuphold  (posedge CLKB, ADB4, 1, 0);
	$setuphold  (posedge CLKB, ADB5, 1, 0);
	$setuphold  (posedge CLKB, ADB6, 1, 0);
	$setuphold  (posedge CLKB, ADB7, 1, 0);
	$setuphold  (posedge CLKB, ADB8, 1, 0);

        $recovery(posedge RSTB, posedge CLKB, 1); 

	(CLKA => DOA0) = (0:0:0, 0:0:0);
	(RSTA => DOA0) = (0:0:0, 0:0:0);

	(CLKB => DOB0) = (0:0:0, 0:0:0);
	(RSTB => DOB0) = (0:0:0, 0:0:0);
	(CLKB => DOB1) = (0:0:0, 0:0:0);
	(RSTB => DOB1) = (0:0:0, 0:0:0);
	(CLKB => DOB2) = (0:0:0, 0:0:0);
	(RSTB => DOB2) = (0:0:0, 0:0:0);
	(CLKB => DOB3) = (0:0:0, 0:0:0);
	(RSTB => DOB3) = (0:0:0, 0:0:0);
	(CLKB => DOB4) = (0:0:0, 0:0:0);
	(RSTB => DOB4) = (0:0:0, 0:0:0);
	(CLKB => DOB5) = (0:0:0, 0:0:0);
	(RSTB => DOB5) = (0:0:0, 0:0:0);
	(CLKB => DOB6) = (0:0:0, 0:0:0);
	(RSTB => DOB6) = (0:0:0, 0:0:0);
	(CLKB => DOB7) = (0:0:0, 0:0:0);
	(RSTB => DOB7) = (0:0:0, 0:0:0);
	(CLKB => DOB8) = (0:0:0, 0:0:0);
	(RSTB => DOB8) = (0:0:0, 0:0:0);
	(CLKB => DOB9) = (0:0:0, 0:0:0);
	(RSTB => DOB9) = (0:0:0, 0:0:0);
	(CLKB => DOB10) = (0:0:0, 0:0:0);
	(RSTB => DOB10) = (0:0:0, 0:0:0);
	(CLKB => DOB11) = (0:0:0, 0:0:0);
	(RSTB => DOB11) = (0:0:0, 0:0:0);
	(CLKB => DOB12) = (0:0:0, 0:0:0);
	(RSTB => DOB12) = (0:0:0, 0:0:0);
	(CLKB => DOB13) = (0:0:0, 0:0:0);
	(RSTB => DOB13) = (0:0:0, 0:0:0);
	(CLKB => DOB14) = (0:0:0, 0:0:0);
	(RSTB => DOB14) = (0:0:0, 0:0:0);
	(CLKB => DOB15) = (0:0:0, 0:0:0);
	(RSTB => DOB15) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB8K_X2_X2(CENA,CLKA,WRA,CSA0,CSA1,RSTA,
                    CENB,CLKB,WRB,CSB0,CSB1,RSTB,
                    DIA0,DIA1,
                    ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,ADA10,ADA11,
                    DIB0,DIB1,
                    ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8,ADB9,ADB10,ADB11,
                    DOA0,DOA1,
                    DOB0,DOB1
);

parameter RAM_INIT_FILE = "";

input  CENA,CLKA,WRA,CSA0,CSA1,RSTA;
input  CENB,CLKB,WRB,CSB0,CSB1,RSTB;
input  DIA0,DIA1;
input  ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,ADA10,ADA11;
input  DIB0,DIB1;
input  ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8,ADB9,ADB10,ADB11;

output  DOA0,DOA1;
output  DOB0,DOB1;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [1:0] dia;
wire [1:0] doa;

wire [11:0] ada;
wire [11:0] adb;

wire [1:0] dib;
wire [1:0] dob;

wire [1:0] CSA, CSB;
reg notifier;

assign CSA  = { CSA1, CSA0};
assign CSB  = { CSB1, CSB0};

assign dia  = {DIA1,DIA0};
//assign {DOA1,DOA0} = doa;

assign dib  = {DIB1,DIB0};
//assign {DOB1,DOB0} = dob;
buf INSXQA0 (DOA0,doa[0]);
buf INSXQA1 (DOA1,doa[1]);
buf INSXQB0 (DOB0,dob[0]);
buf INSXQB1 (DOB1,dob[1]);

assign ada = {ADA11,ADA10,ADA9,ADA8,ADA7,ADA6,ADA5,ADA4,ADA3,ADA2,ADA1,ADA0};
assign adb = {ADB11,ADB10,ADB9,ADB8,ADB7,ADB6,ADB5,ADB4,ADB3,ADB2,ADB1,ADB0};

defparam RAM_U0.ADDR_WIDTH_A = 12;
defparam RAM_U0.DATA_WIDTH_A = 2;

defparam RAM_U0.ADDR_WIDTH_B = 12;
defparam RAM_U0.DATA_WIDTH_B = 2;

defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_DPRAM_16K RAM_U0(
		.CENA(CENA),
		.CLKA(CLKA),
		.WRA(WRA),
		.CSA(CSA),
		.RSTA(RSTA),
		.DIA(dia),
		.ADA(ada),
		.DOA(doa),
		.CENB(CENB),
		.CLKB(CLKB),
		.WRB(WRB),
		.CSB(CSB),
		.RSTB(RSTB),
		.DIB(dib),
		.ADB(adb),
		.DOB(dob)
	     );


specify
	$width (posedge CLKA, 1, 0, notifier);
	$width (posedge CLKB, 1, 0, notifier);

	$width (posedge RSTA, 1, 0, notifier);
	$width (posedge RSTB, 1, 0, notifier);

	$setuphold  (posedge CLKA, DIA0, 1, 0);
	$setuphold  (posedge CLKA, DIA1, 1, 0);

	$setuphold  (posedge CLKA, CENA, 1, 0);
	$setuphold  (posedge CLKA, WRA, 1, 0);
	$setuphold  (posedge CLKA, CSA0, 1, 0);
	$setuphold  (posedge CLKA, CSA1, 1, 0);

	$setuphold  (posedge CLKA, ADA0, 1, 0);
	$setuphold  (posedge CLKA, ADA1, 1, 0);
	$setuphold  (posedge CLKA, ADA2, 1, 0);
	$setuphold  (posedge CLKA, ADA3, 1, 0);
	$setuphold  (posedge CLKA, ADA4, 1, 0);
	$setuphold  (posedge CLKA, ADA5, 1, 0);
	$setuphold  (posedge CLKA, ADA6, 1, 0);
	$setuphold  (posedge CLKA, ADA7, 1, 0);
	$setuphold  (posedge CLKA, ADA8, 1, 0);
	$setuphold  (posedge CLKA, ADA9, 1, 0);
	$setuphold  (posedge CLKA, ADA10, 1, 0);
	$setuphold  (posedge CLKA, ADA11, 1, 0);

        $recovery(posedge RSTA, posedge CLKA, 1); 

	$setuphold  (posedge CLKB, DIB0, 1, 0);
	$setuphold  (posedge CLKB, DIB1, 1, 0);

	$setuphold  (posedge CLKB, CENB, 1, 0);
	$setuphold  (posedge CLKB, WRB, 1, 0);
	$setuphold  (posedge CLKB, CSB0, 1, 0);
	$setuphold  (posedge CLKB, CSB1, 1, 0);

	$setuphold  (posedge CLKB, ADB0, 1, 0);
	$setuphold  (posedge CLKB, ADB1, 1, 0);
	$setuphold  (posedge CLKB, ADB2, 1, 0);
	$setuphold  (posedge CLKB, ADB3, 1, 0);
	$setuphold  (posedge CLKB, ADB4, 1, 0);
	$setuphold  (posedge CLKB, ADB5, 1, 0);
	$setuphold  (posedge CLKB, ADB6, 1, 0);
	$setuphold  (posedge CLKB, ADB7, 1, 0);
	$setuphold  (posedge CLKB, ADB8, 1, 0);
	$setuphold  (posedge CLKB, ADB9, 1, 0);
	$setuphold  (posedge CLKB, ADB10, 1, 0);
	$setuphold  (posedge CLKB, ADB11, 1, 0);

        $recovery(posedge RSTB, posedge CLKB, 1); 

	(CLKA => DOA0) = (0:0:0, 0:0:0);
	(CLKA => DOA1) = (0:0:0, 0:0:0);

	(RSTA => DOA0) = (0:0:0, 0:0:0);
	(RSTA => DOA1) = (0:0:0, 0:0:0);

	(CLKB => DOB0) = (0:0:0, 0:0:0);
	(CLKB => DOB1) = (0:0:0, 0:0:0);

	(RSTB => DOB0) = (0:0:0, 0:0:0);
	(RSTB => DOB1) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB8K_X2_X4(CENA,CLKA,WRA,CSA0,CSA1,RSTA,
                    CENB,CLKB,WRB,CSB0,CSB1,RSTB,
                    DIA0,DIA1,
                    ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,ADA10,ADA11,
                    DIB0,DIB1,DIB2,DIB3,
                    ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8,ADB9,ADB10,
                    DOA0,DOA1,
                    DOB0,DOB1,DOB2,DOB3,
);

parameter RAM_INIT_FILE = "";

input  CENA,CLKA,WRA,CSA0,CSA1,RSTA;
input  CENB,CLKB,WRB,CSB0,CSB1,RSTB;
input  DIA0,DIA1;
input  ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,ADA10,ADA11;
input  DIB0,DIB1,DIB2,DIB3;
input  ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8,ADB9,ADB10;

output  DOA0,DOA1;
output  DOB0,DOB1,DOB2,DOB3;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [1:0] dia;
wire [1:0] doa;

wire [11:0] ada;
wire [10:0] adb;

wire [3:0] dib;
wire [3:0] dob;

wire [1:0] CSA, CSB;
reg notifier;

assign CSA  = { CSA1, CSA0};
assign CSB  = { CSB1, CSB0};

assign dia  = {DIA1,DIA0};
//assign {DOA1,DOA0} = doa;

assign dib  = {DIB3,DIB2,DIB1,DIB0};
//assign {DOB3,DOB2,DOB1,DOB0} = dob;
buf INSXQA0 (DOA0,doa[0]);
buf INSXQA1 (DOA1,doa[1]);
buf INSXQB0 (DOB0,dob[0]);
buf INSXQB1 (DOB1,dob[1]);
buf INSXQB2 (DOB2,dob[2]);
buf INSXQB3 (DOB3,dob[3]);

assign ada = {ADA11,ADA10,ADA9,ADA8,ADA7,ADA6,ADA5,ADA4,ADA3,ADA2,ADA1,ADA0};
assign adb = {ADB10,ADB9,ADB8,ADB7,ADB6,ADB5,ADB4,ADB3,ADB2,ADB1,ADB0};

defparam RAM_U0.ADDR_WIDTH_A = 12;
defparam RAM_U0.DATA_WIDTH_A = 2;

defparam RAM_U0.ADDR_WIDTH_B = 11;
defparam RAM_U0.DATA_WIDTH_B = 4;

defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_DPRAM_16K RAM_U0(
		.CENA(CENA),
		.CLKA(CLKA),
		.WRA(WRA),
		.CSA(CSA),
		.RSTA(RSTA),
		.DIA(dia),
		.ADA(ada),
		.DOA(doa),
		.CENB(CENB),
		.CLKB(CLKB),
		.WRB(WRB),
		.CSB(CSB),
		.RSTB(RSTB),
		.DIB(dib),
		.ADB(adb),
		.DOB(dob)
	     );


specify
	$width (posedge CLKA, 1, 0, notifier);
	$width (posedge CLKB, 1, 0, notifier);

	$width (posedge RSTA, 1, 0, notifier);
	$width (posedge RSTB, 1, 0, notifier);

	$setuphold  (posedge CLKA, DIA0, 1, 0);
	$setuphold  (posedge CLKA, DIA1, 1, 0);

	$setuphold  (posedge CLKA, CENA, 1, 0);
	$setuphold  (posedge CLKA, WRA, 1, 0);
	$setuphold  (posedge CLKA, CSA0, 1, 0);
	$setuphold  (posedge CLKA, CSA1, 1, 0);

	$setuphold  (posedge CLKA, ADA0, 1, 0);
	$setuphold  (posedge CLKA, ADA1, 1, 0);
	$setuphold  (posedge CLKA, ADA2, 1, 0);
	$setuphold  (posedge CLKA, ADA3, 1, 0);
	$setuphold  (posedge CLKA, ADA4, 1, 0);
	$setuphold  (posedge CLKA, ADA5, 1, 0);
	$setuphold  (posedge CLKA, ADA6, 1, 0);
	$setuphold  (posedge CLKA, ADA7, 1, 0);
	$setuphold  (posedge CLKA, ADA8, 1, 0);
	$setuphold  (posedge CLKA, ADA9, 1, 0);
	$setuphold  (posedge CLKA, ADA10, 1, 0);
	$setuphold  (posedge CLKA, ADA11, 1, 0);

        $recovery(posedge RSTA, posedge CLKA, 1); 

	$setuphold  (posedge CLKB, DIB0, 1, 0);
	$setuphold  (posedge CLKB, DIB1, 1, 0);
	$setuphold  (posedge CLKB, DIB2, 1, 0);
	$setuphold  (posedge CLKB, DIB3, 1, 0);

	$setuphold  (posedge CLKB, CENB, 1, 0);
	$setuphold  (posedge CLKB, WRB, 1, 0);
	$setuphold  (posedge CLKB, CSB0, 1, 0);
	$setuphold  (posedge CLKB, CSB1, 1, 0);

	$setuphold  (posedge CLKB, ADB0, 1, 0);
	$setuphold  (posedge CLKB, ADB1, 1, 0);
	$setuphold  (posedge CLKB, ADB2, 1, 0);
	$setuphold  (posedge CLKB, ADB3, 1, 0);
	$setuphold  (posedge CLKB, ADB4, 1, 0);
	$setuphold  (posedge CLKB, ADB5, 1, 0);
	$setuphold  (posedge CLKB, ADB6, 1, 0);
	$setuphold  (posedge CLKB, ADB7, 1, 0);
	$setuphold  (posedge CLKB, ADB8, 1, 0);
	$setuphold  (posedge CLKB, ADB9, 1, 0);
	$setuphold  (posedge CLKB, ADB10, 1, 0);

        $recovery(posedge RSTB, posedge CLKB, 1); 

	(CLKA => DOA0) = (0:0:0, 0:0:0);
	(CLKA => DOA1) = (0:0:0, 0:0:0);

	(RSTA => DOA0) = (0:0:0, 0:0:0);
	(RSTA => DOA1) = (0:0:0, 0:0:0);

	(CLKB => DOB0) = (0:0:0, 0:0:0);
	(CLKB => DOB1) = (0:0:0, 0:0:0);
	(CLKB => DOB2) = (0:0:0, 0:0:0);
	(CLKB => DOB3) = (0:0:0, 0:0:0);

	(RSTB => DOB0) = (0:0:0, 0:0:0);
	(RSTB => DOB1) = (0:0:0, 0:0:0);
	(RSTB => DOB2) = (0:0:0, 0:0:0);
	(RSTB => DOB3) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB8K_X2_X8(CENA,CLKA,WRA,CSA0,CSA1,RSTA,
                    CENB,CLKB,WRB,CSB0,CSB1,RSTB,
                    DIA0,DIA1,
                    ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,ADA10,ADA11,
                    DIB0,DIB1,DIB2,DIB3,DIB4,DIB5,DIB6,DIB7,
                    ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8,ADB9,
                    DOA0,DOA1,
                    DOB0,DOB1,DOB2,DOB3,DOB4,DOB5,DOB6,DOB7
);

parameter RAM_INIT_FILE = "";

input  CENA,CLKA,WRA,CSA0,CSA1,RSTA;
input  CENB,CLKB,WRB,CSB0,CSB1,RSTB;
input  DIA0,DIA1;
input  ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,ADA10,ADA11;
input  DIB0,DIB1,DIB2,DIB3,DIB4,DIB5,DIB6,DIB7;
input  ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8,ADB9;

output  DOA0,DOA1;
output  DOB0,DOB1,DOB2,DOB3,DOB4,DOB5,DOB6,DOB7;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [1:0] dia;
wire [1:0] doa;

wire [11:0] ada;
wire [9:0] adb;

wire [7:0] dib;
wire [7:0] dob;

wire [1:0] CSA, CSB;
reg notifier;

assign CSA  = { CSA1, CSA0};
assign CSB  = { CSB1, CSB0};

assign dia  = {DIA1,DIA0};
//assign {DOA1,DOA0} = doa;

assign dib  = {DIB7,DIB6,DIB5,DIB4,DIB3,DIB2,DIB1,DIB0};
//assign {DOB7,DOB6,DOB5,DOB4,DOB3,DOB2,DOB1,DOB0} = dob;
buf INSXQA0 (DOA0,doa[0]);
buf INSXQA1 (DOA1,doa[1]);
buf INSXQB0 (DOB0,dob[0]);
buf INSXQB1 (DOB1,dob[1]);
buf INSXQB2 (DOB2,dob[2]);
buf INSXQB3 (DOB3,dob[3]);
buf INSXQB4 (DOB4,dob[4]);
buf INSXQB5 (DOB5,dob[5]);
buf INSXQB6 (DOB6,dob[6]);
buf INSXQB7 (DOB7,dob[7]);

assign ada = {ADA11,ADA10,ADA9,ADA8,ADA7,ADA6,ADA5,ADA4,ADA3,ADA2,ADA1,ADA0};
assign adb = {ADB9,ADB8,ADB7,ADB6,ADB5,ADB4,ADB3,ADB2,ADB1,ADB0};

defparam RAM_U0.ADDR_WIDTH_A = 12;
defparam RAM_U0.DATA_WIDTH_A = 2;

defparam RAM_U0.ADDR_WIDTH_B = 10;
defparam RAM_U0.DATA_WIDTH_B = 8;

defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_DPRAM_16K RAM_U0(
		.CENA(CENA),
		.CLKA(CLKA),
		.WRA(WRA),
		.CSA(CSA),
		.RSTA(RSTA),
		.DIA(dia),
		.ADA(ada),
		.DOA(doa),
		.CENB(CENB),
		.CLKB(CLKB),
		.WRB(WRB),
		.CSB(CSB),
		.RSTB(RSTB),
		.DIB(dib),
		.ADB(adb),
		.DOB(dob)
	     );

specify
	$width (posedge CLKA, 1, 0, notifier);
	$width (posedge CLKB, 1, 0, notifier);

	$width (posedge RSTA, 1, 0, notifier);
	$width (posedge RSTB, 1, 0, notifier);

	$setuphold  (posedge CLKA, DIA0, 1, 0);
	$setuphold  (posedge CLKA, DIA1, 1, 0);

	$setuphold  (posedge CLKA, CENA, 1, 0);
	$setuphold  (posedge CLKA, WRA, 1, 0);
	$setuphold  (posedge CLKA, CSA0, 1, 0);
	$setuphold  (posedge CLKA, CSA1, 1, 0);

	$setuphold  (posedge CLKA, ADA0, 1, 0);
	$setuphold  (posedge CLKA, ADA1, 1, 0);
	$setuphold  (posedge CLKA, ADA2, 1, 0);
	$setuphold  (posedge CLKA, ADA3, 1, 0);
	$setuphold  (posedge CLKA, ADA4, 1, 0);
	$setuphold  (posedge CLKA, ADA5, 1, 0);
	$setuphold  (posedge CLKA, ADA6, 1, 0);
	$setuphold  (posedge CLKA, ADA7, 1, 0);
	$setuphold  (posedge CLKA, ADA8, 1, 0);
	$setuphold  (posedge CLKA, ADA9, 1, 0);
	$setuphold  (posedge CLKA, ADA10, 1, 0);
	$setuphold  (posedge CLKA, ADA11, 1, 0);

        $recovery(posedge RSTA, posedge CLKA, 1); 

	$setuphold  (posedge CLKB, DIB0, 1, 0);
	$setuphold  (posedge CLKB, DIB1, 1, 0);
	$setuphold  (posedge CLKB, DIB2, 1, 0);
	$setuphold  (posedge CLKB, DIB3, 1, 0);
	$setuphold  (posedge CLKB, DIB4, 1, 0);
	$setuphold  (posedge CLKB, DIB5, 1, 0);
	$setuphold  (posedge CLKB, DIB6, 1, 0);
	$setuphold  (posedge CLKB, DIB7, 1, 0);

	$setuphold  (posedge CLKB, CENB, 1, 0);
	$setuphold  (posedge CLKB, WRB, 1, 0);
	$setuphold  (posedge CLKB, CSB0, 1, 0);
	$setuphold  (posedge CLKB, CSB1, 1, 0);

	$setuphold  (posedge CLKB, ADB0, 1, 0);
	$setuphold  (posedge CLKB, ADB1, 1, 0);
	$setuphold  (posedge CLKB, ADB2, 1, 0);
	$setuphold  (posedge CLKB, ADB3, 1, 0);
	$setuphold  (posedge CLKB, ADB4, 1, 0);
	$setuphold  (posedge CLKB, ADB5, 1, 0);
	$setuphold  (posedge CLKB, ADB6, 1, 0);
	$setuphold  (posedge CLKB, ADB7, 1, 0);
	$setuphold  (posedge CLKB, ADB8, 1, 0);
	$setuphold  (posedge CLKB, ADB9, 1, 0);

        $recovery(posedge RSTB, posedge CLKB, 1); 

	(CLKA => DOA0) = (0:0:0, 0:0:0);
	(CLKA => DOA1) = (0:0:0, 0:0:0);

	(RSTA => DOA0) = (0:0:0, 0:0:0);
	(RSTA => DOA1) = (0:0:0, 0:0:0);

	(CLKB => DOB0) = (0:0:0, 0:0:0);
	(CLKB => DOB1) = (0:0:0, 0:0:0);
	(CLKB => DOB2) = (0:0:0, 0:0:0);
	(CLKB => DOB3) = (0:0:0, 0:0:0);
	(CLKB => DOB4) = (0:0:0, 0:0:0);
	(CLKB => DOB5) = (0:0:0, 0:0:0);
	(CLKB => DOB6) = (0:0:0, 0:0:0);
	(CLKB => DOB7) = (0:0:0, 0:0:0);

	(RSTB => DOB0) = (0:0:0, 0:0:0);
	(RSTB => DOB1) = (0:0:0, 0:0:0);
	(RSTB => DOB2) = (0:0:0, 0:0:0);
	(RSTB => DOB3) = (0:0:0, 0:0:0);
	(RSTB => DOB4) = (0:0:0, 0:0:0);
	(RSTB => DOB5) = (0:0:0, 0:0:0);
	(RSTB => DOB6) = (0:0:0, 0:0:0);
	(RSTB => DOB7) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB8K_X2_X16(CENA,CLKA,WRA,CSA0,CSA1,RSTA,
                    CENB,CLKB,WRB,CSB0,CSB1,RSTB,
                    DIA0,DIA1,
                    ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,ADA10,ADA11,
                    DIB0,DIB1,DIB2,DIB3,DIB4,DIB5,DIB6,DIB7,
                    DIB8,DIB9,DIB10,DIB11,DIB12,DIB13,DIB14,DIB15,
                    ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8,
                    DOA0,DOA1,
                    DOB0,DOB1,DOB2,DOB3,DOB4,DOB5,DOB6,DOB7,
                    DOB8,DOB9,DOB10,DOB11,DOB12,DOB13,DOB14,DOB15
);

parameter RAM_INIT_FILE = "";

input  CENA,CLKA,WRA,CSA0,CSA1,RSTA;
input  CENB,CLKB,WRB,CSB0,CSB1,RSTB;
input  DIA0,DIA1;
input  ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,ADA10,ADA11;
input  DIB0,DIB1,DIB2,DIB3,DIB4,DIB5,DIB6,DIB7;
input  DIB8,DIB9,DIB10,DIB11,DIB12,DIB13,DIB14,DIB15;
input  ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8;

output  DOA0,DOA1;
output  DOB0,DOB1,DOB2,DOB3,DOB4,DOB5,DOB6,DOB7;
output  DOB8,DOB9,DOB10,DOB11,DOB12,DOB13,DOB14,DOB15;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [1:0] dia;
wire [1:0] doa;

wire [11:0] ada;
wire [8:0] adb;

wire [15:0] dib;
wire [15:0] dob;

wire [1:0] CSA, CSB;
reg notifier;

assign CSA  = { CSA1, CSA0};
assign CSB  = { CSB1, CSB0};

assign dia  = {DIA1,DIA0};
//assign {DOA1,DOA0} = doa;

assign dib  = {DIB15,DIB14,DIB13,DIB12,DIB11,DIB10,DIB9,DIB8,DIB7,DIB6,DIB5,DIB4,DIB3,DIB2,DIB1,DIB0};
//assign {DOB15,DOB14,DOB13,DOB12,DOB11,DOB10,DOB9,DOB8,DOB7,DOB6,DOB5,DOB4,DOB3,DOB2,DOB1,DOB0} = dob;
buf INSXQA0 (DOA0,doa[0]);
buf INSXQA1 (DOA1,doa[1]);
buf INSXQB0 (DOB0,dob[0]);
buf INSXQB1 (DOB1,dob[1]);
buf INSXQB2 (DOB2,dob[2]);
buf INSXQB3 (DOB3,dob[3]);
buf INSXQB4 (DOB4,dob[4]);
buf INSXQB5 (DOB5,dob[5]);
buf INSXQB6 (DOB6,dob[6]);
buf INSXQB7 (DOB7,dob[7]);
buf INSXQB8 (DOB8,dob[8]);
buf INSXQB9 (DOB9,dob[9]);

buf INSXQB10 (DOB10,dob[10]);
buf INSXQB11 (DOB11,dob[11]);
buf INSXQB12 (DOB12,dob[12]);
buf INSXQB13 (DOB13,dob[13]);
buf INSXQB14 (DOB14,dob[14]);
buf INSXQB15 (DOB15,dob[15]);

assign ada = {ADA11,ADA10,ADA9,ADA8,ADA7,ADA6,ADA5,ADA4,ADA3,ADA2,ADA1,ADA0};
assign adb = {ADB8,ADB7,ADB6,ADB5,ADB4,ADB3,ADB2,ADB1,ADB0};

defparam RAM_U0.ADDR_WIDTH_A = 12;
defparam RAM_U0.DATA_WIDTH_A = 2;

defparam RAM_U0.ADDR_WIDTH_B = 9;
defparam RAM_U0.DATA_WIDTH_B = 16;

defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_DPRAM_16K RAM_U0(
		.CENA(CENA),
		.CLKA(CLKA),
		.WRA(WRA),
		.CSA(CSA),
		.RSTA(RSTA),
		.DIA(dia),
		.ADA(ada),
		.DOA(doa),
		.CENB(CENB),
		.CLKB(CLKB),
		.WRB(WRB),
		.CSB(CSB),
		.RSTB(RSTB),
		.DIB(dib),
		.ADB(adb),
		.DOB(dob)
	     );


specify
	$width (posedge CLKA, 1, 0, notifier);
	$width (posedge CLKB, 1, 0, notifier);

	$width (posedge RSTA, 1, 0, notifier);
	$width (posedge RSTB, 1, 0, notifier);

	$setuphold  (posedge CLKA, DIA0, 1, 0);
	$setuphold  (posedge CLKA, DIA1, 1, 0);

	$setuphold  (posedge CLKA, CENA, 1, 0);
	$setuphold  (posedge CLKA, WRA, 1, 0);
	$setuphold  (posedge CLKA, CSA0, 1, 0);
	$setuphold  (posedge CLKA, CSA1, 1, 0);

	$setuphold  (posedge CLKA, ADA0, 1, 0);
	$setuphold  (posedge CLKA, ADA1, 1, 0);
	$setuphold  (posedge CLKA, ADA2, 1, 0);
	$setuphold  (posedge CLKA, ADA3, 1, 0);
	$setuphold  (posedge CLKA, ADA4, 1, 0);
	$setuphold  (posedge CLKA, ADA5, 1, 0);
	$setuphold  (posedge CLKA, ADA6, 1, 0);
	$setuphold  (posedge CLKA, ADA7, 1, 0);
	$setuphold  (posedge CLKA, ADA8, 1, 0);
	$setuphold  (posedge CLKA, ADA9, 1, 0);
	$setuphold  (posedge CLKA, ADA10, 1, 0);
	$setuphold  (posedge CLKA, ADA11, 1, 0);

        $recovery(posedge RSTA, posedge CLKA, 1); 

	$setuphold  (posedge CLKB, DIB0, 1, 0);
	$setuphold  (posedge CLKB, DIB1, 1, 0);
	$setuphold  (posedge CLKB, DIB2, 1, 0);
	$setuphold  (posedge CLKB, DIB3, 1, 0);
	$setuphold  (posedge CLKB, DIB4, 1, 0);
	$setuphold  (posedge CLKB, DIB5, 1, 0);
	$setuphold  (posedge CLKB, DIB6, 1, 0);
	$setuphold  (posedge CLKB, DIB7, 1, 0);
	$setuphold  (posedge CLKB, DIB8, 1, 0);
	$setuphold  (posedge CLKB, DIB9, 1, 0);
	$setuphold  (posedge CLKB, DIB10, 1, 0);
	$setuphold  (posedge CLKB, DIB11, 1, 0);
	$setuphold  (posedge CLKB, DIB12, 1, 0);
	$setuphold  (posedge CLKB, DIB13, 1, 0);
	$setuphold  (posedge CLKB, DIB14, 1, 0);
	$setuphold  (posedge CLKB, DIB15, 1, 0);

	$setuphold  (posedge CLKB, CENB, 1, 0);
	$setuphold  (posedge CLKB, WRB, 1, 0);
	$setuphold  (posedge CLKB, CSB0, 1, 0);
	$setuphold  (posedge CLKB, CSB1, 1, 0);

	$setuphold  (posedge CLKB, ADB0, 1, 0);
	$setuphold  (posedge CLKB, ADB1, 1, 0);
	$setuphold  (posedge CLKB, ADB2, 1, 0);
	$setuphold  (posedge CLKB, ADB3, 1, 0);
	$setuphold  (posedge CLKB, ADB4, 1, 0);
	$setuphold  (posedge CLKB, ADB5, 1, 0);
	$setuphold  (posedge CLKB, ADB6, 1, 0);
	$setuphold  (posedge CLKB, ADB7, 1, 0);
	$setuphold  (posedge CLKB, ADB8, 1, 0);

        $recovery(posedge RSTB, posedge CLKB, 1); 

	(CLKA => DOA0) = (0:0:0, 0:0:0);
	(CLKA => DOA1) = (0:0:0, 0:0:0);

	(RSTA => DOA0) = (0:0:0, 0:0:0);
	(RSTA => DOA1) = (0:0:0, 0:0:0);

	(CLKB => DOB0) = (0:0:0, 0:0:0);
	(CLKB => DOB1) = (0:0:0, 0:0:0);
	(CLKB => DOB2) = (0:0:0, 0:0:0);
	(CLKB => DOB3) = (0:0:0, 0:0:0);
	(CLKB => DOB4) = (0:0:0, 0:0:0);
	(CLKB => DOB5) = (0:0:0, 0:0:0);
	(CLKB => DOB6) = (0:0:0, 0:0:0);
	(CLKB => DOB7) = (0:0:0, 0:0:0);
	(CLKB => DOB8) = (0:0:0, 0:0:0);
	(CLKB => DOB9) = (0:0:0, 0:0:0);
	(CLKB => DOB10) = (0:0:0, 0:0:0);
	(CLKB => DOB11) = (0:0:0, 0:0:0);
	(CLKB => DOB12) = (0:0:0, 0:0:0);
	(CLKB => DOB13) = (0:0:0, 0:0:0);
	(CLKB => DOB14) = (0:0:0, 0:0:0);
	(CLKB => DOB15) = (0:0:0, 0:0:0);

	(RSTB => DOB0) = (0:0:0, 0:0:0);
	(RSTB => DOB1) = (0:0:0, 0:0:0);
	(RSTB => DOB2) = (0:0:0, 0:0:0);
	(RSTB => DOB3) = (0:0:0, 0:0:0);
	(RSTB => DOB4) = (0:0:0, 0:0:0);
	(RSTB => DOB5) = (0:0:0, 0:0:0);
	(RSTB => DOB6) = (0:0:0, 0:0:0);
	(RSTB => DOB7) = (0:0:0, 0:0:0);
	(RSTB => DOB8) = (0:0:0, 0:0:0);
	(RSTB => DOB9) = (0:0:0, 0:0:0);
	(RSTB => DOB10) = (0:0:0, 0:0:0);
	(RSTB => DOB11) = (0:0:0, 0:0:0);
	(RSTB => DOB12) = (0:0:0, 0:0:0);
	(RSTB => DOB13) = (0:0:0, 0:0:0);
	(RSTB => DOB14) = (0:0:0, 0:0:0);
	(RSTB => DOB15) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB8K_X4_X4(CENA,CLKA,WRA,CSA0,CSA1,RSTA,
                    CENB,CLKB,WRB,CSB0,CSB1,RSTB,
                    DIA0,DIA1,DIA2,DIA3,
                    ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,ADA10,
                    DIB0,DIB1,DIB2,DIB3,
                    ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8,ADB9,ADB10,
                    DOA0,DOA1,DOA2,DOA3,
                    DOB0,DOB1,DOB2,DOB3
);

parameter RAM_INIT_FILE = "";

input  CENA,CLKA,WRA,CSA0,CSA1,RSTA;
input  CENB,CLKB,WRB,CSB0,CSB1,RSTB;
input  DIA0,DIA1,DIA2,DIA3;
input  ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,ADA10;
input  DIB0,DIB1,DIB2,DIB3;
input  ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8,ADB9,ADB10;

output  DOA0,DOA1,DOA2,DOA3;
output  DOB0,DOB1,DOB2,DOB3;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [3:0] dia;
wire [3:0] doa;

wire [10:0] ada;
wire [10:0] adb;

wire [3:0] dib;
wire [3:0] dob;

wire [1:0] CSA, CSB;
reg notifier;

assign CSA  = { CSA1, CSA0};
assign CSB  = { CSB1, CSB0};

assign dia  = {DIA3,DIA2,DIA1,DIA0};
//assign {DOA3,DOA2,DOA1,DOA0} = doa;

assign dib  = {DIB3,DIB2,DIB1,DIB0};
//assign {DOB3,DOB2,DOB1,DOB0} = dob;
buf INSXQA0 (DOA0,doa[0]);
buf INSXQA1 (DOA1,doa[1]);
buf INSXQA2 (DOA2,doa[2]);
buf INSXQA3 (DOA3,doa[3]);
buf INSXQB0 (DOB0,dob[0]);
buf INSXQB1 (DOB1,dob[1]);
buf INSXQB2 (DOB2,dob[2]);
buf INSXQB3 (DOB3,dob[3]);

assign ada = {ADA10,ADA9,ADA8,ADA7,ADA6,ADA5,ADA4,ADA3,ADA2,ADA1,ADA0};
assign adb = {ADB10,ADB9,ADB8,ADB7,ADB6,ADB5,ADB4,ADB3,ADB2,ADB1,ADB0};

defparam RAM_U0.ADDR_WIDTH_A = 11;
defparam RAM_U0.DATA_WIDTH_A = 4;

defparam RAM_U0.ADDR_WIDTH_B = 11;
defparam RAM_U0.DATA_WIDTH_B = 4;

defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_DPRAM_16K RAM_U0(
		.CENA(CENA),
		.CLKA(CLKA),
		.WRA(WRA),
		.CSA(CSA),
		.RSTA(RSTA),
		.DIA(dia),
		.ADA(ada),
		.DOA(doa),
		.CENB(CENB),
		.CLKB(CLKB),
		.WRB(WRB),
		.CSB(CSB),
		.RSTB(RSTB),
		.DIB(dib),
		.ADB(adb),
		.DOB(dob)
	     );


specify
	$width (posedge CLKA, 1, 0, notifier);
	$width (posedge CLKB, 1, 0, notifier);

	$width (posedge RSTA, 1, 0, notifier);
	$width (posedge RSTB, 1, 0, notifier);

	$setuphold  (posedge CLKA, DIA0, 1, 0);
	$setuphold  (posedge CLKA, DIA1, 1, 0);
	$setuphold  (posedge CLKA, DIA2, 1, 0);
	$setuphold  (posedge CLKA, DIA3, 1, 0);

	$setuphold  (posedge CLKA, CENA, 1, 0);
	$setuphold  (posedge CLKA, WRA, 1, 0);
	$setuphold  (posedge CLKA, CSA0, 1, 0);
	$setuphold  (posedge CLKA, CSA1, 1, 0);

	$setuphold  (posedge CLKA, ADA0, 1, 0);
	$setuphold  (posedge CLKA, ADA1, 1, 0);
	$setuphold  (posedge CLKA, ADA2, 1, 0);
	$setuphold  (posedge CLKA, ADA3, 1, 0);
	$setuphold  (posedge CLKA, ADA4, 1, 0);
	$setuphold  (posedge CLKA, ADA5, 1, 0);
	$setuphold  (posedge CLKA, ADA6, 1, 0);
	$setuphold  (posedge CLKA, ADA7, 1, 0);
	$setuphold  (posedge CLKA, ADA8, 1, 0);
	$setuphold  (posedge CLKA, ADA9, 1, 0);
	$setuphold  (posedge CLKA, ADA10, 1, 0);

        $recovery(posedge RSTA, posedge CLKA, 1); 

	$setuphold  (posedge CLKB, DIB0, 1, 0);
	$setuphold  (posedge CLKB, DIB1, 1, 0);
	$setuphold  (posedge CLKB, DIB2, 1, 0);
	$setuphold  (posedge CLKB, DIB3, 1, 0);

	$setuphold  (posedge CLKB, CENB, 1, 0);
	$setuphold  (posedge CLKB, WRB, 1, 0);
	$setuphold  (posedge CLKB, CSB0, 1, 0);
	$setuphold  (posedge CLKB, CSB1, 1, 0);

	$setuphold  (posedge CLKB, ADB0, 1, 0);
	$setuphold  (posedge CLKB, ADB1, 1, 0);
	$setuphold  (posedge CLKB, ADB2, 1, 0);
	$setuphold  (posedge CLKB, ADB3, 1, 0);
	$setuphold  (posedge CLKB, ADB4, 1, 0);
	$setuphold  (posedge CLKB, ADB5, 1, 0);
	$setuphold  (posedge CLKB, ADB6, 1, 0);
	$setuphold  (posedge CLKB, ADB7, 1, 0);
	$setuphold  (posedge CLKB, ADB8, 1, 0);
	$setuphold  (posedge CLKB, ADB9, 1, 0);
	$setuphold  (posedge CLKB, ADB10, 1, 0);

        $recovery(posedge RSTB, posedge CLKB, 1); 

	(CLKA => DOA0) = (0:0:0, 0:0:0);
	(CLKA => DOA1) = (0:0:0, 0:0:0);
	(CLKA => DOA2) = (0:0:0, 0:0:0);
	(CLKA => DOA3) = (0:0:0, 0:0:0);

	(RSTA => DOA0) = (0:0:0, 0:0:0);
	(RSTA => DOA1) = (0:0:0, 0:0:0);
	(RSTA => DOA2) = (0:0:0, 0:0:0);
	(RSTA => DOA3) = (0:0:0, 0:0:0);

	(CLKB => DOB0) = (0:0:0, 0:0:0);
	(CLKB => DOB1) = (0:0:0, 0:0:0);
	(CLKB => DOB2) = (0:0:0, 0:0:0);
	(CLKB => DOB3) = (0:0:0, 0:0:0);

	(RSTB => DOB0) = (0:0:0, 0:0:0);
	(RSTB => DOB1) = (0:0:0, 0:0:0);
	(RSTB => DOB2) = (0:0:0, 0:0:0);
	(RSTB => DOB3) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB8K_X4_X8(CENA,CLKA,WRA,CSA0,CSA1,RSTA,
                    CENB,CLKB,WRB,CSB0,CSB1,RSTB,
                    DIA0,DIA1,DIA2,DIA3,
                    ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,ADA10,
                    DIB0,DIB1,DIB2,DIB3,DIB4,DIB5,DIB6,DIB7,
                    ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8,ADB9,
                    DOA0,DOA1,DOA2,DOA3,
                    DOB0,DOB1,DOB2,DOB3,DOB4,DOB5,DOB6,DOB7
);


parameter RAM_INIT_FILE = "";


input  CENA,CLKA,WRA,CSA0,CSA1,RSTA;
input  CENB,CLKB,WRB,CSB0,CSB1,RSTB;
input  DIA0,DIA1,DIA2,DIA3;
input  ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,ADA10;
input  DIB0,DIB1,DIB2,DIB3,DIB4,DIB5,DIB6,DIB7;
input  ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8,ADB9;

output  DOA0,DOA1,DOA2,DOA3;
output  DOB0,DOB1,DOB2,DOB3,DOB4,DOB5,DOB6,DOB7;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [3:0] dia;
wire [3:0] doa;

wire [10:0] ada;
wire [9:0] adb;

wire [7:0] dib;
wire [7:0] dob;

wire [1:0] CSA, CSB;
reg notifier;

assign CSA  = { CSA1, CSA0};
assign CSB  = { CSB1, CSB0};

assign dia  = {DIA3,DIA2,DIA1,DIA0};
//assign {DOA3,DOA2,DOA1,DOA0} = doa;

assign dib  = {DIB7,DIB6,DIB5,DIB4,DIB3,DIB2,DIB1,DIB0};
//assign {DOB7,DOB6,DOB5,DOB4,DOB3,DOB2,DOB1,DOB0} = dob;
buf INSXQA0 (DOA0,doa[0]);
buf INSXQA1 (DOA1,doa[1]);
buf INSXQA2 (DOA2,doa[2]);
buf INSXQA3 (DOA3,doa[3]);
buf INSXQB0 (DOB0,dob[0]);
buf INSXQB1 (DOB1,dob[1]);
buf INSXQB2 (DOB2,dob[2]);
buf INSXQB3 (DOB3,dob[3]);
buf INSXQB4 (DOB4,dob[4]);
buf INSXQB5 (DOB5,dob[5]);
buf INSXQB6 (DOB6,dob[6]);
buf INSXQB7 (DOB7,dob[7]);

assign ada = {ADA10,ADA9,ADA8,ADA7,ADA6,ADA5,ADA4,ADA3,ADA2,ADA1,ADA0};
assign adb = {ADB9,ADB8,ADB7,ADB6,ADB5,ADB4,ADB3,ADB2,ADB1,ADB0};

defparam RAM_U0.ADDR_WIDTH_A = 11;
defparam RAM_U0.DATA_WIDTH_A = 4;

defparam RAM_U0.ADDR_WIDTH_B = 10;
defparam RAM_U0.DATA_WIDTH_B = 8;

defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;


SC_DPRAM_16K RAM_U0(
		.CENA(CENA),
		.CLKA(CLKA),
		.WRA(WRA),
		.CSA(CSA),
		.RSTA(RSTA),
		.DIA(dia),
		.ADA(ada),
		.DOA(doa),
		.CENB(CENB),
		.CLKB(CLKB),
		.WRB(WRB),
		.CSB(CSB),
		.RSTB(RSTB),
		.DIB(dib),
		.ADB(adb),
		.DOB(dob)
	     );

specify
	$width (posedge CLKA, 1, 0, notifier);
	$width (posedge CLKB, 1, 0, notifier);

	$width (posedge RSTA, 1, 0, notifier);
	$width (posedge RSTB, 1, 0, notifier);

	$setuphold  (posedge CLKA, DIA0, 1, 0);
	$setuphold  (posedge CLKA, DIA1, 1, 0);
	$setuphold  (posedge CLKA, DIA2, 1, 0);
	$setuphold  (posedge CLKA, DIA3, 1, 0);

	$setuphold  (posedge CLKA, CENA, 1, 0);
	$setuphold  (posedge CLKA, WRA, 1, 0);
	$setuphold  (posedge CLKA, CSA0, 1, 0);
	$setuphold  (posedge CLKA, CSA1, 1, 0);

	$setuphold  (posedge CLKA, ADA0, 1, 0);
	$setuphold  (posedge CLKA, ADA1, 1, 0);
	$setuphold  (posedge CLKA, ADA2, 1, 0);
	$setuphold  (posedge CLKA, ADA3, 1, 0);
	$setuphold  (posedge CLKA, ADA4, 1, 0);
	$setuphold  (posedge CLKA, ADA5, 1, 0);
	$setuphold  (posedge CLKA, ADA6, 1, 0);
	$setuphold  (posedge CLKA, ADA7, 1, 0);
	$setuphold  (posedge CLKA, ADA8, 1, 0);
	$setuphold  (posedge CLKA, ADA9, 1, 0);
	$setuphold  (posedge CLKA, ADA10, 1, 0);

        $recovery(posedge RSTA, posedge CLKA, 1); 

	$setuphold  (posedge CLKB, DIB0, 1, 0);
	$setuphold  (posedge CLKB, DIB1, 1, 0);
	$setuphold  (posedge CLKB, DIB2, 1, 0);
	$setuphold  (posedge CLKB, DIB3, 1, 0);
	$setuphold  (posedge CLKB, DIB4, 1, 0);
	$setuphold  (posedge CLKB, DIB5, 1, 0);
	$setuphold  (posedge CLKB, DIB6, 1, 0);
	$setuphold  (posedge CLKB, DIB7, 1, 0);

	$setuphold  (posedge CLKB, CENB, 1, 0);
	$setuphold  (posedge CLKB, WRB, 1, 0);
	$setuphold  (posedge CLKB, CSB0, 1, 0);
	$setuphold  (posedge CLKB, CSB1, 1, 0);

	$setuphold  (posedge CLKB, ADB0, 1, 0);
	$setuphold  (posedge CLKB, ADB1, 1, 0);
	$setuphold  (posedge CLKB, ADB2, 1, 0);
	$setuphold  (posedge CLKB, ADB3, 1, 0);
	$setuphold  (posedge CLKB, ADB4, 1, 0);
	$setuphold  (posedge CLKB, ADB5, 1, 0);
	$setuphold  (posedge CLKB, ADB6, 1, 0);
	$setuphold  (posedge CLKB, ADB7, 1, 0);
	$setuphold  (posedge CLKB, ADB8, 1, 0);
	$setuphold  (posedge CLKB, ADB9, 1, 0);

        $recovery(posedge RSTB, posedge CLKB, 1); 

	(CLKA => DOA0) = (0:0:0, 0:0:0);
	(CLKA => DOA1) = (0:0:0, 0:0:0);
	(CLKA => DOA2) = (0:0:0, 0:0:0);
	(CLKA => DOA3) = (0:0:0, 0:0:0);

	(RSTA => DOA0) = (0:0:0, 0:0:0);
	(RSTA => DOA1) = (0:0:0, 0:0:0);
	(RSTA => DOA2) = (0:0:0, 0:0:0);
	(RSTA => DOA3) = (0:0:0, 0:0:0);

	(CLKB => DOB0) = (0:0:0, 0:0:0);
	(CLKB => DOB1) = (0:0:0, 0:0:0);
	(CLKB => DOB2) = (0:0:0, 0:0:0);
	(CLKB => DOB3) = (0:0:0, 0:0:0);
	(CLKB => DOB4) = (0:0:0, 0:0:0);
	(CLKB => DOB5) = (0:0:0, 0:0:0);
	(CLKB => DOB6) = (0:0:0, 0:0:0);
	(CLKB => DOB7) = (0:0:0, 0:0:0);

	(RSTB => DOB0) = (0:0:0, 0:0:0);
	(RSTB => DOB1) = (0:0:0, 0:0:0);
	(RSTB => DOB2) = (0:0:0, 0:0:0);
	(RSTB => DOB3) = (0:0:0, 0:0:0);
	(RSTB => DOB4) = (0:0:0, 0:0:0);
	(RSTB => DOB5) = (0:0:0, 0:0:0);
	(RSTB => DOB6) = (0:0:0, 0:0:0);
	(RSTB => DOB7) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB8K_X4_X16(CENA,CLKA,WRA,CSA0,CSA1,RSTA,
                    CENB,CLKB,WRB,CSB0,CSB1,RSTB,
                    DIA0,DIA1,DIA2,DIA3,
                    ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,ADA10,
                    DIB0,DIB1,DIB2,DIB3,DIB4,DIB5,DIB6,DIB7,
                    DIB8,DIB9,DIB10,DIB11,DIB12,DIB13,DIB14,DIB15,
                    ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8,
                    DOA0,DOA1,DOA2,DOA3,
                    DOB0,DOB1,DOB2,DOB3,DOB4,DOB5,DOB6,DOB7,
                    DOB8,DOB9,DOB10,DOB11,DOB12,DOB13,DOB14,DOB15
);

parameter RAM_INIT_FILE = "";

input  CENA,CLKA,WRA,CSA0,CSA1,RSTA;
input  CENB,CLKB,WRB,CSB0,CSB1,RSTB;
input  DIA0,DIA1,DIA2,DIA3;
input  ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,ADA10;
input  DIB0,DIB1,DIB2,DIB3,DIB4,DIB5,DIB6,DIB7,DIB8,DIB9,DIB10,DIB11,DIB12,DIB13,DIB14,DIB15;
input  ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8;

output  DOA0,DOA1,DOA2,DOA3;
output  DOB0,DOB1,DOB2,DOB3,DOB4,DOB5,DOB6,DOB7,DOB8,DOB9,DOB10,DOB11,DOB12,DOB13,DOB14,DOB15;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [3:0] dia;
wire [3:0] doa;

wire [10:0] ada;
wire [8:0] adb;

wire [15:0] dib;
wire [15:0] dob;

wire [1:0] CSA, CSB;
reg notifier;

assign CSA  = { CSA1, CSA0};
assign CSB  = { CSB1, CSB0};

assign dia  = {DIA3,DIA2,DIA1,DIA0};
//assign {DOA3,DOA2,DOA1,DOA0} = doa;

assign dib  = {DIB15,DIB14,DIB13,DIB12,DIB11,DIB10,DIB9,DIB8,DIB7,DIB6,DIB5,DIB4,DIB3,DIB2,DIB1,DIB0};
//assign {DOB15,DOB14,DOB13,DOB12,DOB11,DOB10,DOB9,DOB8,DOB7,DOB6,DOB5,DOB4,DOB3,DOB2,DOB1,DOB0} = dob;
buf INSXQA0 (DOA0,doa[0]);
buf INSXQA1 (DOA1,doa[1]);
buf INSXQA2 (DOA2,doa[2]);
buf INSXQA3 (DOA3,doa[3]);
buf INSXQB0 (DOB0,dob[0]);
buf INSXQB1 (DOB1,dob[1]);
buf INSXQB2 (DOB2,dob[2]);
buf INSXQB3 (DOB3,dob[3]);
buf INSXQB4 (DOB4,dob[4]);
buf INSXQB5 (DOB5,dob[5]);
buf INSXQB6 (DOB6,dob[6]);
buf INSXQB7 (DOB7,dob[7]);
buf INSXQB8 (DOB8,dob[8]);
buf INSXQB9 (DOB9,dob[9]);

buf INSXQB10 (DOB10,dob[10]);
buf INSXQB11 (DOB11,dob[11]);
buf INSXQB12 (DOB12,dob[12]);
buf INSXQB13 (DOB13,dob[13]);
buf INSXQB14 (DOB14,dob[14]);
buf INSXQB15 (DOB15,dob[15]);
assign ada = {ADA10,ADA9,ADA8,ADA7,ADA6,ADA5,ADA4,ADA3,ADA2,ADA1,ADA0};
assign adb = {ADB8,ADB7,ADB6,ADB5,ADB4,ADB3,ADB2,ADB1,ADB0};

defparam RAM_U0.ADDR_WIDTH_A = 11;
defparam RAM_U0.DATA_WIDTH_A = 4;

defparam RAM_U0.ADDR_WIDTH_B = 9;
defparam RAM_U0.DATA_WIDTH_B = 16;

defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_DPRAM_16K RAM_U0(
		.CENA(CENA),
		.CLKA(CLKA),
		.WRA(WRA),
		.CSA(CSA),
		.RSTA(RSTA),
		.DIA(dia),
		.ADA(ada),
		.DOA(doa),
		.CENB(CENB),
		.CLKB(CLKB),
		.WRB(WRB),
		.CSB(CSB),
		.RSTB(RSTB),
		.DIB(dib),
		.ADB(adb),
		.DOB(dob)
	     );

specify
	$width (posedge CLKA, 1, 0, notifier);
	$width (posedge CLKB, 1, 0, notifier);

	$width (posedge RSTA, 1, 0, notifier);
	$width (posedge RSTB, 1, 0, notifier);

	$setuphold  (posedge CLKA, DIA0, 1, 0);
	$setuphold  (posedge CLKA, DIA1, 1, 0);
	$setuphold  (posedge CLKA, DIA2, 1, 0);
	$setuphold  (posedge CLKA, DIA3, 1, 0);

	$setuphold  (posedge CLKA, CENA, 1, 0);
	$setuphold  (posedge CLKA, WRA, 1, 0);
	$setuphold  (posedge CLKA, CSA0, 1, 0);
	$setuphold  (posedge CLKA, CSA1, 1, 0);

	$setuphold  (posedge CLKA, ADA0, 1, 0);
	$setuphold  (posedge CLKA, ADA1, 1, 0);
	$setuphold  (posedge CLKA, ADA2, 1, 0);
	$setuphold  (posedge CLKA, ADA3, 1, 0);
	$setuphold  (posedge CLKA, ADA4, 1, 0);
	$setuphold  (posedge CLKA, ADA5, 1, 0);
	$setuphold  (posedge CLKA, ADA6, 1, 0);
	$setuphold  (posedge CLKA, ADA7, 1, 0);
	$setuphold  (posedge CLKA, ADA8, 1, 0);
	$setuphold  (posedge CLKA, ADA9, 1, 0);
	$setuphold  (posedge CLKA, ADA10, 1, 0);

        $recovery(posedge RSTA, posedge CLKA, 1); 

	$setuphold  (posedge CLKB, DIB0, 1, 0);
	$setuphold  (posedge CLKB, DIB1, 1, 0);
	$setuphold  (posedge CLKB, DIB2, 1, 0);
	$setuphold  (posedge CLKB, DIB3, 1, 0);
	$setuphold  (posedge CLKB, DIB4, 1, 0);
	$setuphold  (posedge CLKB, DIB5, 1, 0);
	$setuphold  (posedge CLKB, DIB6, 1, 0);
	$setuphold  (posedge CLKB, DIB7, 1, 0);
	$setuphold  (posedge CLKB, DIB8, 1, 0);
	$setuphold  (posedge CLKB, DIB9, 1, 0);
	$setuphold  (posedge CLKB, DIB10, 1, 0);
	$setuphold  (posedge CLKB, DIB11, 1, 0);
	$setuphold  (posedge CLKB, DIB12, 1, 0);
	$setuphold  (posedge CLKB, DIB13, 1, 0);
	$setuphold  (posedge CLKB, DIB14, 1, 0);
	$setuphold  (posedge CLKB, DIB15, 1, 0);

	$setuphold  (posedge CLKB, CENB, 1, 0);
	$setuphold  (posedge CLKB, WRB, 1, 0);
	$setuphold  (posedge CLKB, CSB0, 1, 0);
	$setuphold  (posedge CLKB, CSB1, 1, 0);

	$setuphold  (posedge CLKB, ADB0, 1, 0);
	$setuphold  (posedge CLKB, ADB1, 1, 0);
	$setuphold  (posedge CLKB, ADB2, 1, 0);
	$setuphold  (posedge CLKB, ADB3, 1, 0);
	$setuphold  (posedge CLKB, ADB4, 1, 0);
	$setuphold  (posedge CLKB, ADB5, 1, 0);
	$setuphold  (posedge CLKB, ADB6, 1, 0);
	$setuphold  (posedge CLKB, ADB7, 1, 0);
	$setuphold  (posedge CLKB, ADB8, 1, 0);

        $recovery(posedge RSTB, posedge CLKB, 1); 

	(CLKA => DOA0) = (0:0:0, 0:0:0);
	(CLKA => DOA1) = (0:0:0, 0:0:0);
	(CLKA => DOA2) = (0:0:0, 0:0:0);
	(CLKA => DOA3) = (0:0:0, 0:0:0);

	(RSTA => DOA0) = (0:0:0, 0:0:0);
	(RSTA => DOA1) = (0:0:0, 0:0:0);
	(RSTA => DOA2) = (0:0:0, 0:0:0);
	(RSTA => DOA3) = (0:0:0, 0:0:0);

	(CLKB => DOB0) = (0:0:0, 0:0:0);
	(CLKB => DOB1) = (0:0:0, 0:0:0);
	(CLKB => DOB2) = (0:0:0, 0:0:0);
	(CLKB => DOB3) = (0:0:0, 0:0:0);
	(CLKB => DOB4) = (0:0:0, 0:0:0);
	(CLKB => DOB5) = (0:0:0, 0:0:0);
	(CLKB => DOB6) = (0:0:0, 0:0:0);
	(CLKB => DOB7) = (0:0:0, 0:0:0);
	(CLKB => DOB8) = (0:0:0, 0:0:0);
	(CLKB => DOB9) = (0:0:0, 0:0:0);
	(CLKB => DOB10) = (0:0:0, 0:0:0);
	(CLKB => DOB11) = (0:0:0, 0:0:0);
	(CLKB => DOB12) = (0:0:0, 0:0:0);
	(CLKB => DOB13) = (0:0:0, 0:0:0);
	(CLKB => DOB14) = (0:0:0, 0:0:0);
	(CLKB => DOB15) = (0:0:0, 0:0:0);

	(RSTB => DOB0) = (0:0:0, 0:0:0);
	(RSTB => DOB1) = (0:0:0, 0:0:0);
	(RSTB => DOB2) = (0:0:0, 0:0:0);
	(RSTB => DOB3) = (0:0:0, 0:0:0);
	(RSTB => DOB4) = (0:0:0, 0:0:0);
	(RSTB => DOB5) = (0:0:0, 0:0:0);
	(RSTB => DOB6) = (0:0:0, 0:0:0);
	(RSTB => DOB7) = (0:0:0, 0:0:0);
	(RSTB => DOB8) = (0:0:0, 0:0:0);
	(RSTB => DOB9) = (0:0:0, 0:0:0);
	(RSTB => DOB10) = (0:0:0, 0:0:0);
	(RSTB => DOB11) = (0:0:0, 0:0:0);
	(RSTB => DOB12) = (0:0:0, 0:0:0);
	(RSTB => DOB13) = (0:0:0, 0:0:0);
	(RSTB => DOB14) = (0:0:0, 0:0:0);
	(RSTB => DOB15) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB8K_X8_X8(CENA,CLKA,WRA,CSA0,CSA1,RSTA,
                    CENB,CLKB,WRB,CSB0,CSB1,RSTB,
                    DIA0,DIA1,DIA2,DIA3,DIA4,DIA5,DIA6,DIA7,
                    ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,
                    DIB0,DIB1,DIB2,DIB3,DIB4,DIB5,DIB6,DIB7,
                    ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8,ADB9,
                    DOA0,DOA1,DOA2,DOA3,DOA4,DOA5,DOA6,DOA7,
                    DOB0,DOB1,DOB2,DOB3,DOB4,DOB5,DOB6,DOB7
);

parameter RAM_INIT_FILE = "";


input  CENA,CLKA,WRA,CSA0,CSA1,RSTA;
input  CENB,CLKB,WRB,CSB0,CSB1,RSTB;
input  DIA0,DIA1,DIA2,DIA3,DIA4,DIA5,DIA6,DIA7;
input  ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9;
input  DIB0,DIB1,DIB2,DIB3,DIB4,DIB5,DIB6,DIB7;
input  ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8,ADB9;

output  DOA0,DOA1,DOA2,DOA3,DOA4,DOA5,DOA6,DOA7;
output  DOB0,DOB1,DOB2,DOB3,DOB4,DOB5,DOB6,DOB7;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [7:0] dia;
wire [7:0] doa;

wire [9:0] ada;
wire [9:0] adb;

wire [7:0] dib;
wire [7:0] dob;

wire [1:0] CSA, CSB;
reg notifier;

assign CSA  = { CSA1, CSA0};
assign CSB  = { CSB1, CSB0};

assign dia  = {DIA7,DIA6,DIA5,DIA4,DIA3,DIA2,DIA1,DIA0};
//assign {DOA7,DOA6,DOA5,DOA4,DOA3,DOA2,DOA1,DOA0} = doa;

assign dib  = {DIB7,DIB6,DIB5,DIB4,DIB3,DIB2,DIB1,DIB0};
//assign {DOB7,DOB6,DOB5,DOB4,DOB3,DOB2,DOB1,DOB0} = dob;
buf INSXQA0 (DOA0,doa[0]);
buf INSXQA1 (DOA1,doa[1]);
buf INSXQA2 (DOA2,doa[2]);
buf INSXQA3 (DOA3,doa[3]); 
buf INSXQA4 (DOA4,doa[4]);
buf INSXQA5 (DOA5,doa[5]);
buf INSXQA6 (DOA6,doa[6]);
buf INSXQA7 (DOA7,doa[7]);

buf INSXQB0 (DOB0,dob[0]);
buf INSXQB1 (DOB1,dob[1]);
buf INSXQB2 (DOB2,dob[2]);
buf INSXQB3 (DOB3,dob[3]);
buf INSXQB4 (DOB4,dob[4]);
buf INSXQB5 (DOB5,dob[5]);
buf INSXQB6 (DOB6,dob[6]);
buf INSXQB7 (DOB7,dob[7]);

assign ada = {ADA9,ADA8,ADA7,ADA6,ADA5,ADA4,ADA3,ADA2,ADA1,ADA0};
assign adb = {ADB9,ADB8,ADB7,ADB6,ADB5,ADB4,ADB3,ADB2,ADB1,ADB0};

defparam RAM_U0.ADDR_WIDTH_A = 10;
defparam RAM_U0.DATA_WIDTH_A = 8;

defparam RAM_U0.ADDR_WIDTH_B = 10;
defparam RAM_U0.DATA_WIDTH_B = 8;

defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_DPRAM_16K RAM_U0(
		.CENA(CENA),
		.CLKA(CLKA),
		.WRA(WRA),
		.CSA(CSA),
		.RSTA(RSTA),
		.DIA(dia),
		.ADA(ada),
		.DOA(doa),
		.CENB(CENB),
		.CLKB(CLKB),
		.WRB(WRB),
		.CSB(CSB),
		.RSTB(RSTB),
		.DIB(dib),
		.ADB(adb),
		.DOB(dob)
	     );

specify
	$width (posedge CLKA, 1, 0, notifier);
	$width (posedge CLKB, 1, 0, notifier);

	$width (posedge RSTA, 1, 0, notifier);
	$width (posedge RSTB, 1, 0, notifier);

	$setuphold  (posedge CLKA, DIA0, 1, 0);
	$setuphold  (posedge CLKA, DIA1, 1, 0);
	$setuphold  (posedge CLKA, DIA2, 1, 0);
	$setuphold  (posedge CLKA, DIA3, 1, 0);
	$setuphold  (posedge CLKA, DIA4, 1, 0);
	$setuphold  (posedge CLKA, DIA5, 1, 0);
	$setuphold  (posedge CLKA, DIA6, 1, 0);
	$setuphold  (posedge CLKA, DIA7, 1, 0);

	$setuphold  (posedge CLKA, CENA, 1, 0);
	$setuphold  (posedge CLKA, WRA, 1, 0);
	$setuphold  (posedge CLKA, CSA0, 1, 0);
	$setuphold  (posedge CLKA, CSA1, 1, 0);

	$setuphold  (posedge CLKA, ADA0, 1, 0);
	$setuphold  (posedge CLKA, ADA1, 1, 0);
	$setuphold  (posedge CLKA, ADA2, 1, 0);
	$setuphold  (posedge CLKA, ADA3, 1, 0);
	$setuphold  (posedge CLKA, ADA4, 1, 0);
	$setuphold  (posedge CLKA, ADA5, 1, 0);
	$setuphold  (posedge CLKA, ADA6, 1, 0);
	$setuphold  (posedge CLKA, ADA7, 1, 0);
	$setuphold  (posedge CLKA, ADA8, 1, 0);
	$setuphold  (posedge CLKA, ADA9, 1, 0);

        $recovery(posedge RSTA, posedge CLKA, 1); 

	$setuphold  (posedge CLKB, DIB0, 1, 0);
	$setuphold  (posedge CLKB, DIB1, 1, 0);
	$setuphold  (posedge CLKB, DIB2, 1, 0);
	$setuphold  (posedge CLKB, DIB3, 1, 0);
	$setuphold  (posedge CLKB, DIB4, 1, 0);
	$setuphold  (posedge CLKB, DIB5, 1, 0);
	$setuphold  (posedge CLKB, DIB6, 1, 0);
	$setuphold  (posedge CLKB, DIB7, 1, 0);

	$setuphold  (posedge CLKB, CENB, 1, 0);
	$setuphold  (posedge CLKB, WRB, 1, 0);
	$setuphold  (posedge CLKB, CSB0, 1, 0);
	$setuphold  (posedge CLKB, CSB1, 1, 0);

	$setuphold  (posedge CLKB, ADB0, 1, 0);
	$setuphold  (posedge CLKB, ADB1, 1, 0);
	$setuphold  (posedge CLKB, ADB2, 1, 0);
	$setuphold  (posedge CLKB, ADB3, 1, 0);
	$setuphold  (posedge CLKB, ADB4, 1, 0);
	$setuphold  (posedge CLKB, ADB5, 1, 0);
	$setuphold  (posedge CLKB, ADB6, 1, 0);
	$setuphold  (posedge CLKB, ADB7, 1, 0);
	$setuphold  (posedge CLKB, ADB8, 1, 0);
	$setuphold  (posedge CLKB, ADB9, 1, 0);

        $recovery(posedge RSTB, posedge CLKB, 1); 

	(CLKA => DOA0) = (0:0:0, 0:0:0);
	(CLKA => DOA1) = (0:0:0, 0:0:0);
	(CLKA => DOA2) = (0:0:0, 0:0:0);
	(CLKA => DOA3) = (0:0:0, 0:0:0);
	(CLKA => DOA4) = (0:0:0, 0:0:0);
	(CLKA => DOA5) = (0:0:0, 0:0:0);
	(CLKA => DOA6) = (0:0:0, 0:0:0);
	(CLKA => DOA7) = (0:0:0, 0:0:0);

	(RSTA => DOA0) = (0:0:0, 0:0:0);
	(RSTA => DOA1) = (0:0:0, 0:0:0);
	(RSTA => DOA2) = (0:0:0, 0:0:0);
	(RSTA => DOA3) = (0:0:0, 0:0:0);
	(RSTA => DOA4) = (0:0:0, 0:0:0);
	(RSTA => DOA5) = (0:0:0, 0:0:0);
	(RSTA => DOA6) = (0:0:0, 0:0:0);
	(RSTA => DOA7) = (0:0:0, 0:0:0);

	(CLKB => DOB0) = (0:0:0, 0:0:0);
	(CLKB => DOB1) = (0:0:0, 0:0:0);
	(CLKB => DOB2) = (0:0:0, 0:0:0);
	(CLKB => DOB3) = (0:0:0, 0:0:0);
	(CLKB => DOB4) = (0:0:0, 0:0:0);
	(CLKB => DOB5) = (0:0:0, 0:0:0);
	(CLKB => DOB6) = (0:0:0, 0:0:0);
	(CLKB => DOB7) = (0:0:0, 0:0:0);

	(RSTB => DOB0) = (0:0:0, 0:0:0);
	(RSTB => DOB1) = (0:0:0, 0:0:0);
	(RSTB => DOB2) = (0:0:0, 0:0:0);
	(RSTB => DOB3) = (0:0:0, 0:0:0);
	(RSTB => DOB4) = (0:0:0, 0:0:0);
	(RSTB => DOB5) = (0:0:0, 0:0:0);
	(RSTB => DOB6) = (0:0:0, 0:0:0);
	(RSTB => DOB7) = (0:0:0, 0:0:0);

endspecify
endmodule
`celldefine
module RAMB8K_X8_X16(CENA,CLKA,WRA,CSA0,CSA1,RSTA,
                    CENB,CLKB,WRB,CSB0,CSB1,RSTB,
                    DIA0,DIA1,DIA2,DIA3,DIA4,DIA5,DIA6,DIA7,
                    ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9,
                    DIB0,DIB1,DIB2,DIB3,DIB4,DIB5,DIB6,DIB7,
                    DIB8,DIB9,DIB10,DIB11,DIB12,DIB13,DIB14,DIB15,
                    ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8,
                    DOA0,DOA1,DOA2,DOA3,DOA4,DOA5,DOA6,DOA7,
                    DOB0,DOB1,DOB2,DOB3,DOB4,DOB5,DOB6,DOB7,
                    DOB8,DOB9,DOB10,DOB11,DOB12,DOB13,DOB14,DOB15
);

parameter RAM_INIT_FILE = "";


input  CENA,CLKA,WRA,CSA0,CSA1,RSTA;
input  CENB,CLKB,WRB,CSB0,CSB1,RSTB;
input  DIA0,DIA1,DIA2,DIA3,DIA4,DIA5,DIA6,DIA7;
input  ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,ADA9;
input  DIB0,DIB1,DIB2,DIB3,DIB4,DIB5,DIB6,DIB7;
input  DIB8,DIB9,DIB10,DIB11,DIB12,DIB13,DIB14,DIB15;
input  ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8;

output  DOA0,DOA1,DOA2,DOA3,DOA4,DOA5,DOA6,DOA7;
output  DOB0,DOB1,DOB2,DOB3,DOB4,DOB5,DOB6,DOB7;
output  DOB8,DOB9,DOB10,DOB11,DOB12,DOB13,DOB14,DOB15;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [7:0] dia;
wire [7:0] doa;

wire [9:0] ada;
wire [8:0] adb;

wire [15:0] dib;
wire [15:0] dob;

wire [1:0] CSA, CSB;
reg notifier;

assign CSA  = { CSA1, CSA0};
assign CSB  = { CSB1, CSB0};

assign dia  = {DIA7,DIA6,DIA5,DIA4,DIA3,DIA2,DIA1,DIA0};
//assign {DOA7,DOA6,DOA5,DOA4,DOA3,DOA2,DOA1,DOA0} = doa;

assign dib  = {DIB15,DIB14,DIB13,DIB12,DIB11,DIB10,DIB9,DIB8,DIB7,DIB6,DIB5,DIB4,DIB3,DIB2,DIB1,DIB0};
//assign {DOB15,DOB14,DOB13,DOB12,DOB11,DOB10,DOB9,DOB8,DOB7,DOB6,DOB5,DOB4,DOB3,DOB2,DOB1,DOB0} = dob;
buf INSXQA0 (DOA0,doa[0]);
buf INSXQA1 (DOA1,doa[1]);
buf INSXQA2 (DOA2,doa[2]);
buf INSXQA3 (DOA3,doa[3]); 
buf INSXQA4 (DOA4,doa[4]);
buf INSXQA5 (DOA5,doa[5]);
buf INSXQA6 (DOA6,doa[6]);
buf INSXQA7 (DOA7,doa[7]);

buf INSXQB0 (DOB0,dob[0]);
buf INSXQB1 (DOB1,dob[1]);
buf INSXQB2 (DOB2,dob[2]);
buf INSXQB3 (DOB3,dob[3]);
buf INSXQB4 (DOB4,dob[4]);
buf INSXQB5 (DOB5,dob[5]);
buf INSXQB6 (DOB6,dob[6]);
buf INSXQB7 (DOB7,dob[7]);
buf INSXQB8 (DOB8,dob[8]);
buf INSXQB9 (DOB9,dob[9]);

buf INSXQB10 (DOB10,dob[10]);
buf INSXQB11 (DOB11,dob[11]);
buf INSXQB12 (DOB12,dob[12]);
buf INSXQB13 (DOB13,dob[13]);
buf INSXQB14 (DOB14,dob[14]);
buf INSXQB15 (DOB15,dob[15]);
assign ada = {ADA9,ADA8,ADA7,ADA6,ADA5,ADA4,ADA3,ADA2,ADA1,ADA0};
assign adb = {ADB8,ADB7,ADB6,ADB5,ADB4,ADB3,ADB2,ADB1,ADB0};

defparam RAM_U0.ADDR_WIDTH_A = 10;
defparam RAM_U0.DATA_WIDTH_A = 8;

defparam RAM_U0.ADDR_WIDTH_B = 9;
defparam RAM_U0.DATA_WIDTH_B = 16;

defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_DPRAM_16K RAM_U0(
		.CENA(CENA),
		.CLKA(CLKA),
		.WRA(WRA),
		.CSA(CSA),
		.RSTA(RSTA),
		.DIA(dia),
		.ADA(ada),
		.DOA(doa),
		.CENB(CENB),
		.CLKB(CLKB),
		.WRB(WRB),
		.CSB(CSB),
		.RSTB(RSTB),
		.DIB(dib),
		.ADB(adb),
		.DOB(dob)
	     );


specify
	$width (posedge CLKA, 1, 0, notifier);
	$width (posedge CLKB, 1, 0, notifier);

	$width (posedge RSTA, 1, 0, notifier);
	$width (posedge RSTB, 1, 0, notifier);

	$setuphold  (posedge CLKA, DIA0, 1, 0);
	$setuphold  (posedge CLKA, DIA1, 1, 0);
	$setuphold  (posedge CLKA, DIA2, 1, 0);
	$setuphold  (posedge CLKA, DIA3, 1, 0);
	$setuphold  (posedge CLKA, DIA4, 1, 0);
	$setuphold  (posedge CLKA, DIA5, 1, 0);
	$setuphold  (posedge CLKA, DIA6, 1, 0);
	$setuphold  (posedge CLKA, DIA7, 1, 0);

	$setuphold  (posedge CLKA, CENA, 1, 0);
	$setuphold  (posedge CLKA, WRA, 1, 0);
	$setuphold  (posedge CLKA, CSA0, 1, 0);
	$setuphold  (posedge CLKA, CSA1, 1, 0);

	$setuphold  (posedge CLKA, ADA0, 1, 0);
	$setuphold  (posedge CLKA, ADA1, 1, 0);
	$setuphold  (posedge CLKA, ADA2, 1, 0);
	$setuphold  (posedge CLKA, ADA3, 1, 0);
	$setuphold  (posedge CLKA, ADA4, 1, 0);
	$setuphold  (posedge CLKA, ADA5, 1, 0);
	$setuphold  (posedge CLKA, ADA6, 1, 0);
	$setuphold  (posedge CLKA, ADA7, 1, 0);
	$setuphold  (posedge CLKA, ADA8, 1, 0);
	$setuphold  (posedge CLKA, ADA9, 1, 0);

        $recovery(posedge RSTA, posedge CLKA, 1); 

	$setuphold  (posedge CLKB, DIB0, 1, 0);
	$setuphold  (posedge CLKB, DIB1, 1, 0);
	$setuphold  (posedge CLKB, DIB2, 1, 0);
	$setuphold  (posedge CLKB, DIB3, 1, 0);
	$setuphold  (posedge CLKB, DIB4, 1, 0);
	$setuphold  (posedge CLKB, DIB5, 1, 0);
	$setuphold  (posedge CLKB, DIB6, 1, 0);
	$setuphold  (posedge CLKB, DIB7, 1, 0);
	$setuphold  (posedge CLKB, DIB8, 1, 0);
	$setuphold  (posedge CLKB, DIB9, 1, 0);
	$setuphold  (posedge CLKB, DIB10, 1, 0);
	$setuphold  (posedge CLKB, DIB11, 1, 0);
	$setuphold  (posedge CLKB, DIB12, 1, 0);
	$setuphold  (posedge CLKB, DIB13, 1, 0);
	$setuphold  (posedge CLKB, DIB14, 1, 0);
	$setuphold  (posedge CLKB, DIB15, 1, 0);

	$setuphold  (posedge CLKB, CENB, 1, 0);
	$setuphold  (posedge CLKB, WRB, 1, 0);
	$setuphold  (posedge CLKB, CSB0, 1, 0);
	$setuphold  (posedge CLKB, CSB1, 1, 0);

	$setuphold  (posedge CLKB, ADB0, 1, 0);
	$setuphold  (posedge CLKB, ADB1, 1, 0);
	$setuphold  (posedge CLKB, ADB2, 1, 0);
	$setuphold  (posedge CLKB, ADB3, 1, 0);
	$setuphold  (posedge CLKB, ADB4, 1, 0);
	$setuphold  (posedge CLKB, ADB5, 1, 0);
	$setuphold  (posedge CLKB, ADB6, 1, 0);
	$setuphold  (posedge CLKB, ADB7, 1, 0);
	$setuphold  (posedge CLKB, ADB8, 1, 0);

        $recovery(posedge RSTB, posedge CLKB, 1); 

	(CLKA => DOA0) = (0:0:0, 0:0:0);
	(CLKA => DOA1) = (0:0:0, 0:0:0);
	(CLKA => DOA2) = (0:0:0, 0:0:0);
	(CLKA => DOA3) = (0:0:0, 0:0:0);
	(CLKA => DOA4) = (0:0:0, 0:0:0);
	(CLKA => DOA5) = (0:0:0, 0:0:0);
	(CLKA => DOA6) = (0:0:0, 0:0:0);
	(CLKA => DOA7) = (0:0:0, 0:0:0);

	(RSTA => DOA0) = (0:0:0, 0:0:0);
	(RSTA => DOA1) = (0:0:0, 0:0:0);
	(RSTA => DOA2) = (0:0:0, 0:0:0);
	(RSTA => DOA3) = (0:0:0, 0:0:0);
	(RSTA => DOA4) = (0:0:0, 0:0:0);
	(RSTA => DOA5) = (0:0:0, 0:0:0);
	(RSTA => DOA6) = (0:0:0, 0:0:0);
	(RSTA => DOA7) = (0:0:0, 0:0:0);

	(CLKB => DOB0) = (0:0:0, 0:0:0);
	(CLKB => DOB1) = (0:0:0, 0:0:0);
	(CLKB => DOB2) = (0:0:0, 0:0:0);
	(CLKB => DOB3) = (0:0:0, 0:0:0);
	(CLKB => DOB4) = (0:0:0, 0:0:0);
	(CLKB => DOB5) = (0:0:0, 0:0:0);
	(CLKB => DOB6) = (0:0:0, 0:0:0);
	(CLKB => DOB7) = (0:0:0, 0:0:0);
	(CLKB => DOB8) = (0:0:0, 0:0:0);
	(CLKB => DOB9) = (0:0:0, 0:0:0);
	(CLKB => DOB10) = (0:0:0, 0:0:0);
	(CLKB => DOB11) = (0:0:0, 0:0:0);
	(CLKB => DOB12) = (0:0:0, 0:0:0);
	(CLKB => DOB13) = (0:0:0, 0:0:0);
	(CLKB => DOB14) = (0:0:0, 0:0:0);
	(CLKB => DOB15) = (0:0:0, 0:0:0);

	(RSTB => DOB0) = (0:0:0, 0:0:0);
	(RSTB => DOB1) = (0:0:0, 0:0:0);
	(RSTB => DOB2) = (0:0:0, 0:0:0);
	(RSTB => DOB3) = (0:0:0, 0:0:0);
	(RSTB => DOB4) = (0:0:0, 0:0:0);
	(RSTB => DOB5) = (0:0:0, 0:0:0);
	(RSTB => DOB6) = (0:0:0, 0:0:0);
	(RSTB => DOB7) = (0:0:0, 0:0:0);
	(RSTB => DOB8) = (0:0:0, 0:0:0);
	(RSTB => DOB9) = (0:0:0, 0:0:0);
	(RSTB => DOB10) = (0:0:0, 0:0:0);
	(RSTB => DOB11) = (0:0:0, 0:0:0);
	(RSTB => DOB12) = (0:0:0, 0:0:0);
	(RSTB => DOB13) = (0:0:0, 0:0:0);
	(RSTB => DOB14) = (0:0:0, 0:0:0);
	(RSTB => DOB15) = (0:0:0, 0:0:0);

endspecify
endmodule
`celldefine
module RAMB8K_X16_X16(CENA,CLKA,WRA,CSA0,CSA1,RSTA,
                    CENB,CLKB,WRB,CSB0,CSB1,RSTB,
                    DIA0,DIA1,DIA2,DIA3,DIA4,DIA5,DIA6,DIA7,
                    DIA8,DIA9,DIA10,DIA11,DIA12,DIA13,DIA14,DIA15,
                    ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8,
                    DIB0,DIB1,DIB2,DIB3,DIB4,DIB5,DIB6,DIB7,
                    DIB8,DIB9,DIB10,DIB11,DIB12,DIB13,DIB14,DIB15,
                    ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8,
                    DOA0,DOA1,DOA2,DOA3,DOA4,DOA5,DOA6,DOA7,
                    DOA8,DOA9,DOA10,DOA11,DOA12,DOA13,DOA14,DOA15,
                    DOB0,DOB1,DOB2,DOB3,DOB4,DOB5,DOB6,DOB7,
                    DOB8,DOB9,DOB10,DOB11,DOB12,DOB13,DOB14,DOB15
);

parameter RAM_INIT_FILE = "";


input  CENA,CLKA,WRA,CSA0,CSA1,RSTA;
input  CENB,CLKB,WRB,CSB0,CSB1,RSTB;
input  DIA0,DIA1,DIA2,DIA3,DIA4,DIA5,DIA6,DIA7;
input  DIA8,DIA9,DIA10,DIA11,DIA12,DIA13,DIA14,DIA15;
input  ADA0,ADA1,ADA2,ADA3,ADA4,ADA5,ADA6,ADA7,ADA8;
input  DIB0,DIB1,DIB2,DIB3,DIB4,DIB5,DIB6,DIB7;
input  DIB8,DIB9,DIB10,DIB11,DIB12,DIB13,DIB14,DIB15;
input  ADB0,ADB1,ADB2,ADB3,ADB4,ADB5,ADB6,ADB7,ADB8;

output  DOA0,DOA1,DOA2,DOA3,DOA4,DOA5,DOA6,DOA7;
output  DOA8,DOA9,DOA10,DOA11,DOA12,DOA13,DOA14,DOA15;
output  DOB0,DOB1,DOB2,DOB3,DOB4,DOB5,DOB6,DOB7;
output  DOB8,DOB9,DOB10,DOB11,DOB12,DOB13,DOB14,DOB15;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [15:0] dia;
wire [15:0] doa;

wire [8:0] ada;
wire [8:0] adb;

wire [15:0] dib;
wire [15:0] dob;

wire [1:0] CSA, CSB;
reg notifier;

assign CSA  = { CSA1, CSA0};
assign CSB  = { CSB1, CSB0};

assign dia  = {DIA15,DIA14,DIA13,DIA12,DIA11,DIA10,DIA9,DIA8,DIA7,DIA6,DIA5,DIA4,DIA3,DIA2,DIA1,DIA0};
//assign {DOA15,DOA14,DOA13,DOA12,DOA11,DOA10,DOA9,DOA8,DOA7,DOA6,DOA5,DOA4,DOA3,DOA2,DOA1,DOA0} = doa;

assign dib  = {DIB15,DIB14,DIB13,DIB12,DIB11,DIB10,DIB9,DIB8,DIB7,DIB6,DIB5,DIB4,DIB3,DIB2,DIB1,DIB0};
//assign {DOB15,DOB14,DOB13,DOB12,DOB11,DOB10,DOB9,DOB8,DOB7,DOB6,DOB5,DOB4,DOB3,DOB2,DOB1,DOB0} = dob;
buf INSXQA0 (DOA0,doa[0]);
buf INSXQA1 (DOA1,doa[1]);
buf INSXQA2 (DOA2,doa[2]);
buf INSXQA3 (DOA3,doa[3]); 
buf INSXQA4 (DOA4,doa[4]);
buf INSXQA5 (DOA5,doa[5]);
buf INSXQA6 (DOA6,doa[6]);
buf INSXQA7 (DOA7,doa[7]);	  
buf INSXQA8 (DOA8,doa[8]);
buf INSXQA9 (DOA9,doa[9]);

buf INSXQA10 (DOA10,doa[10]);
buf INSXQA11 (DOA11,doa[11]);
buf INSXQA12 (DOA12,doa[12]);
buf INSXQA13 (DOA13,doa[13]);
buf INSXQA14 (DOA14,doa[14]);
buf INSXQA15 (DOA15,doa[15]);

buf INSXQB0 (DOB0,dob[0]);
buf INSXQB1 (DOB1,dob[1]);
buf INSXQB2 (DOB2,dob[2]);
buf INSXQB3 (DOB3,dob[3]);
buf INSXQB4 (DOB4,dob[4]);
buf INSXQB5 (DOB5,dob[5]);
buf INSXQB6 (DOB6,dob[6]);
buf INSXQB7 (DOB7,dob[7]);
buf INSXQB8 (DOB8,dob[8]);
buf INSXQB9 (DOB9,dob[9]);

buf INSXQB10 (DOB10,dob[10]);
buf INSXQB11 (DOB11,dob[11]);
buf INSXQB12 (DOB12,dob[12]);
buf INSXQB13 (DOB13,dob[13]);
buf INSXQB14 (DOB14,dob[14]);
buf INSXQB15 (DOB15,dob[15]);
assign ada = {ADA8,ADA7,ADA6,ADA5,ADA4,ADA3,ADA2,ADA1,ADA0};
assign adb = {ADB8,ADB7,ADB6,ADB5,ADB4,ADB3,ADB2,ADB1,ADB0};

defparam RAM_U0.ADDR_WIDTH_A = 9;
defparam RAM_U0.DATA_WIDTH_A = 16;

defparam RAM_U0.ADDR_WIDTH_B = 9;
defparam RAM_U0.DATA_WIDTH_B = 16;

defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_DPRAM_16K RAM_U0(
		.CENA(CENA),
		.CLKA(CLKA),
		.WRA(WRA),
		.CSA(CSA),
		.RSTA(RSTA),
		.DIA(dia),
		.ADA(ada),
		.DOA(doa),
		.CENB(CENB),
		.CLKB(CLKB),
		.WRB(WRB),
		.CSB(CSB),
		.RSTB(RSTB),
		.DIB(dib),
		.ADB(adb),
		.DOB(dob)
	     );

specify
	$width (posedge CLKA, 1, 0, notifier);
	$width (posedge CLKB, 1, 0, notifier);

	$width (posedge RSTA, 1, 0, notifier);
	$width (posedge RSTB, 1, 0, notifier);

	$setuphold  (posedge CLKA, DIA0, 1, 0);
	$setuphold  (posedge CLKA, DIA1, 1, 0);
	$setuphold  (posedge CLKA, DIA2, 1, 0);
	$setuphold  (posedge CLKA, DIA3, 1, 0);
	$setuphold  (posedge CLKA, DIA4, 1, 0);
	$setuphold  (posedge CLKA, DIA5, 1, 0);
	$setuphold  (posedge CLKA, DIA6, 1, 0);
	$setuphold  (posedge CLKA, DIA7, 1, 0);
	$setuphold  (posedge CLKA, DIA8, 1, 0);
	$setuphold  (posedge CLKA, DIA9, 1, 0);
	$setuphold  (posedge CLKA, DIA10, 1, 0);
	$setuphold  (posedge CLKA, DIA11, 1, 0);
	$setuphold  (posedge CLKA, DIA12, 1, 0);
	$setuphold  (posedge CLKA, DIA13, 1, 0);
	$setuphold  (posedge CLKA, DIA14, 1, 0);
	$setuphold  (posedge CLKA, DIA15, 1, 0);

	$setuphold  (posedge CLKA, CENA, 1, 0);
	$setuphold  (posedge CLKA, WRA, 1, 0);
	$setuphold  (posedge CLKA, CSA0, 1, 0);
	$setuphold  (posedge CLKA, CSA1, 1, 0);

	$setuphold  (posedge CLKA, ADA0, 1, 0);
	$setuphold  (posedge CLKA, ADA1, 1, 0);
	$setuphold  (posedge CLKA, ADA2, 1, 0);
	$setuphold  (posedge CLKA, ADA3, 1, 0);
	$setuphold  (posedge CLKA, ADA4, 1, 0);
	$setuphold  (posedge CLKA, ADA5, 1, 0);
	$setuphold  (posedge CLKA, ADA6, 1, 0);
	$setuphold  (posedge CLKA, ADA7, 1, 0);
	$setuphold  (posedge CLKA, ADA8, 1, 0);

        $recovery(posedge RSTA, posedge CLKA, 1); 

	$setuphold  (posedge CLKB, DIB0, 1, 0);
	$setuphold  (posedge CLKB, DIB1, 1, 0);
	$setuphold  (posedge CLKB, DIB2, 1, 0);
	$setuphold  (posedge CLKB, DIB3, 1, 0);
	$setuphold  (posedge CLKB, DIB4, 1, 0);
	$setuphold  (posedge CLKB, DIB5, 1, 0);
	$setuphold  (posedge CLKB, DIB6, 1, 0);
	$setuphold  (posedge CLKB, DIB7, 1, 0);
	$setuphold  (posedge CLKB, DIB8, 1, 0);
	$setuphold  (posedge CLKB, DIB9, 1, 0);
	$setuphold  (posedge CLKB, DIB10, 1, 0);
	$setuphold  (posedge CLKB, DIB11, 1, 0);
	$setuphold  (posedge CLKB, DIB12, 1, 0);
	$setuphold  (posedge CLKB, DIB13, 1, 0);
	$setuphold  (posedge CLKB, DIB14, 1, 0);
	$setuphold  (posedge CLKB, DIB15, 1, 0);

	$setuphold  (posedge CLKB, CENB, 1, 0);
	$setuphold  (posedge CLKB, WRB, 1, 0);
	$setuphold  (posedge CLKB, CSB0, 1, 0);
	$setuphold  (posedge CLKB, CSB1, 1, 0);

	$setuphold  (posedge CLKB, ADB0, 1, 0);
	$setuphold  (posedge CLKB, ADB1, 1, 0);
	$setuphold  (posedge CLKB, ADB2, 1, 0);
	$setuphold  (posedge CLKB, ADB3, 1, 0);
	$setuphold  (posedge CLKB, ADB4, 1, 0);
	$setuphold  (posedge CLKB, ADB5, 1, 0);
	$setuphold  (posedge CLKB, ADB6, 1, 0);
	$setuphold  (posedge CLKB, ADB7, 1, 0);
	$setuphold  (posedge CLKB, ADB8, 1, 0);

        $recovery(posedge RSTB, posedge CLKB, 1); 

	(CLKA => DOA0) = (0:0:0, 0:0:0);
	(CLKA => DOA1) = (0:0:0, 0:0:0);
	(CLKA => DOA2) = (0:0:0, 0:0:0);
	(CLKA => DOA3) = (0:0:0, 0:0:0);
	(CLKA => DOA4) = (0:0:0, 0:0:0);
	(CLKA => DOA5) = (0:0:0, 0:0:0);
	(CLKA => DOA6) = (0:0:0, 0:0:0);
	(CLKA => DOA7) = (0:0:0, 0:0:0);
	(CLKA => DOA8) = (0:0:0, 0:0:0);
	(CLKA => DOA9) = (0:0:0, 0:0:0);
	(CLKA => DOA10) = (0:0:0, 0:0:0);
	(CLKA => DOA11) = (0:0:0, 0:0:0);
	(CLKA => DOA12) = (0:0:0, 0:0:0);
	(CLKA => DOA13) = (0:0:0, 0:0:0);
	(CLKA => DOA14) = (0:0:0, 0:0:0);
	(CLKA => DOA15) = (0:0:0, 0:0:0);

	(RSTA => DOA0) = (0:0:0, 0:0:0);
	(RSTA => DOA1) = (0:0:0, 0:0:0);
	(RSTA => DOA2) = (0:0:0, 0:0:0);
	(RSTA => DOA3) = (0:0:0, 0:0:0);
	(RSTA => DOA4) = (0:0:0, 0:0:0);
	(RSTA => DOA5) = (0:0:0, 0:0:0);
	(RSTA => DOA6) = (0:0:0, 0:0:0);
	(RSTA => DOA7) = (0:0:0, 0:0:0);
	(RSTA => DOA8) = (0:0:0, 0:0:0);
	(RSTA => DOA9) = (0:0:0, 0:0:0);
	(RSTA => DOA10) = (0:0:0, 0:0:0);
	(RSTA => DOA11) = (0:0:0, 0:0:0);
	(RSTA => DOA12) = (0:0:0, 0:0:0);
	(RSTA => DOA13) = (0:0:0, 0:0:0);
	(RSTA => DOA14) = (0:0:0, 0:0:0);
	(RSTA => DOA15) = (0:0:0, 0:0:0);

	(CLKB => DOB0) = (0:0:0, 0:0:0);
	(CLKB => DOB1) = (0:0:0, 0:0:0);
	(CLKB => DOB2) = (0:0:0, 0:0:0);
	(CLKB => DOB3) = (0:0:0, 0:0:0);
	(CLKB => DOB4) = (0:0:0, 0:0:0);
	(CLKB => DOB5) = (0:0:0, 0:0:0);
	(CLKB => DOB6) = (0:0:0, 0:0:0);
	(CLKB => DOB7) = (0:0:0, 0:0:0);
	(CLKB => DOB8) = (0:0:0, 0:0:0);
	(CLKB => DOB9) = (0:0:0, 0:0:0);
	(CLKB => DOB10) = (0:0:0, 0:0:0);
	(CLKB => DOB11) = (0:0:0, 0:0:0);
	(CLKB => DOB12) = (0:0:0, 0:0:0);
	(CLKB => DOB13) = (0:0:0, 0:0:0);
	(CLKB => DOB14) = (0:0:0, 0:0:0);
	(CLKB => DOB15) = (0:0:0, 0:0:0);

	(RSTB => DOB0) = (0:0:0, 0:0:0);
	(RSTB => DOB1) = (0:0:0, 0:0:0);
	(RSTB => DOB2) = (0:0:0, 0:0:0);
	(RSTB => DOB3) = (0:0:0, 0:0:0);
	(RSTB => DOB4) = (0:0:0, 0:0:0);
	(RSTB => DOB5) = (0:0:0, 0:0:0);
	(RSTB => DOB6) = (0:0:0, 0:0:0);
	(RSTB => DOB7) = (0:0:0, 0:0:0);
	(RSTB => DOB8) = (0:0:0, 0:0:0);
	(RSTB => DOB9) = (0:0:0, 0:0:0);
	(RSTB => DOB10) = (0:0:0, 0:0:0);
	(RSTB => DOB11) = (0:0:0, 0:0:0);
	(RSTB => DOB12) = (0:0:0, 0:0:0);
	(RSTB => DOB13) = (0:0:0, 0:0:0);
	(RSTB => DOB14) = (0:0:0, 0:0:0);
	(RSTB => DOB15) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16KA_WX1_RX1(WCEN,WCLK,WCS0,WCS1,WE,RST,
                    WD0,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,WAD13,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,RAD13,
                    RD0
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RST;
input  WD0;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,WAD13;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,RAD13;

output  RD0;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [13:0] wad;
wire [13:0] rad;
wire [1:0]  wcs; 
wire RD0_node;
reg notifier;

assign wad = {WAD13,WAD12,WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD13,RAD12,RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
buf INSXQ (RD0,RD0_node);
defparam RAM_U0.WADDR_WIDTH=14;
defparam RAM_U0.WDATA_WIDTH=1;
defparam RAM_U0.RADDR_WIDTH=14;
defparam RAM_U0.RDATA_WIDTH=1;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(WD0),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(RD0_node));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);
	$setuphold  (posedge WCLK, WAD12, 1, 0);
	$setuphold  (posedge WCLK, WAD13, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1); 

	(RST => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);
	(RAD9 => RD0) = (0:0:0, 0:0:0);
	(RAD10 => RD0) = (0:0:0, 0:0:0);
	(RAD11 => RD0) = (0:0:0, 0:0:0);
	(RAD12 => RD0) = (0:0:0, 0:0:0);
	(RAD13 => RD0) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16KA_WX1_RX2(WCEN,WCLK,WCS0,WCS1,WE,RST,
                    WD0,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,WAD13,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,
                    RD0,RD1
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RST;
input  WD0;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,WAD13;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12;

output  RD0,RD1;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [13:0] wad;
wire [12:0]  rad;
wire [1:0]  wcs;
wire [1:0] rd;
reg notifier;

assign wad = {WAD13,WAD12,WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD12,RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
//assign {RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);

defparam RAM_U0.WADDR_WIDTH=14;
defparam RAM_U0.WDATA_WIDTH=1;
defparam RAM_U0.RADDR_WIDTH=13;
defparam RAM_U0.RDATA_WIDTH=2;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(WD0),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);
	$setuphold  (posedge WCLK, WAD12, 1, 0);
	$setuphold  (posedge WCLK, WAD13, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1); 

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);

	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);
	(RAD9 => RD0) = (0:0:0, 0:0:0);
	(RAD10 => RD0) = (0:0:0, 0:0:0);
	(RAD11 => RD0) = (0:0:0, 0:0:0);
	(RAD12 => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD1) = (0:0:0, 0:0:0);
	(RAD1 => RD1) = (0:0:0, 0:0:0);
	(RAD2 => RD1) = (0:0:0, 0:0:0);
	(RAD3 => RD1) = (0:0:0, 0:0:0);
	(RAD4 => RD1) = (0:0:0, 0:0:0);
	(RAD5 => RD1) = (0:0:0, 0:0:0);
	(RAD6 => RD1) = (0:0:0, 0:0:0);
	(RAD7 => RD1) = (0:0:0, 0:0:0);
	(RAD8 => RD1) = (0:0:0, 0:0:0);
	(RAD9 => RD1) = (0:0:0, 0:0:0);
	(RAD10 => RD1) = (0:0:0, 0:0:0);
	(RAD11 => RD1) = (0:0:0, 0:0:0);
	(RAD12 => RD1) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16KA_WX1_RX4(WCEN,WCLK,WCS0,WCS1,WE,RST,
                    WD0,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,WAD13,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,
                    RD0,RD1,RD2,RD3
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RST;
input  WD0;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,WAD13;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11;

output  RD0,RD1,RD2,RD3;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [13:0] wad;
wire [11:0]  rad;
wire [1:0]  wcs;
wire [3:0] rd;
reg notifier;

assign wad = {WAD13,WAD12,WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
//assign {RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);

defparam RAM_U0.WADDR_WIDTH=14;
defparam RAM_U0.WDATA_WIDTH=1;
defparam RAM_U0.RADDR_WIDTH=12;
defparam RAM_U0.RDATA_WIDTH=4;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(WD0),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));


specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);
	$setuphold  (posedge WCLK, WAD12, 1, 0);
	$setuphold  (posedge WCLK, WAD13, 1, 0);

        $recovery(posedge RST, posedge 	WCLK, 1); 

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);

	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);
	(RAD9 => RD0) = (0:0:0, 0:0:0);
	(RAD10 => RD0) = (0:0:0, 0:0:0);
	(RAD11 => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD1) = (0:0:0, 0:0:0);
	(RAD1 => RD1) = (0:0:0, 0:0:0);
	(RAD2 => RD1) = (0:0:0, 0:0:0);
	(RAD3 => RD1) = (0:0:0, 0:0:0);
	(RAD4 => RD1) = (0:0:0, 0:0:0);
	(RAD5 => RD1) = (0:0:0, 0:0:0);
	(RAD6 => RD1) = (0:0:0, 0:0:0);
	(RAD7 => RD1) = (0:0:0, 0:0:0);
	(RAD8 => RD1) = (0:0:0, 0:0:0);
	(RAD9 => RD1) = (0:0:0, 0:0:0);
	(RAD10 => RD1) = (0:0:0, 0:0:0);
	(RAD11 => RD1) = (0:0:0, 0:0:0);

	(RAD0 => RD2) = (0:0:0, 0:0:0);
	(RAD1 => RD2) = (0:0:0, 0:0:0);
	(RAD2 => RD2) = (0:0:0, 0:0:0);
	(RAD3 => RD2) = (0:0:0, 0:0:0);
	(RAD4 => RD2) = (0:0:0, 0:0:0);
	(RAD5 => RD2) = (0:0:0, 0:0:0);
	(RAD6 => RD2) = (0:0:0, 0:0:0);
	(RAD7 => RD2) = (0:0:0, 0:0:0);
	(RAD8 => RD2) = (0:0:0, 0:0:0);
	(RAD9 => RD2) = (0:0:0, 0:0:0);
	(RAD10 => RD2) = (0:0:0, 0:0:0);
	(RAD11 => RD2) = (0:0:0, 0:0:0);

	(RAD0 => RD3) = (0:0:0, 0:0:0);
	(RAD1 => RD3) = (0:0:0, 0:0:0);
	(RAD2 => RD3) = (0:0:0, 0:0:0);
	(RAD3 => RD3) = (0:0:0, 0:0:0);
	(RAD4 => RD3) = (0:0:0, 0:0:0);
	(RAD5 => RD3) = (0:0:0, 0:0:0);
	(RAD6 => RD3) = (0:0:0, 0:0:0);
	(RAD7 => RD3) = (0:0:0, 0:0:0);
	(RAD8 => RD3) = (0:0:0, 0:0:0);
	(RAD9 => RD3) = (0:0:0, 0:0:0);
	(RAD10 => RD3) = (0:0:0, 0:0:0);
	(RAD11 => RD3) = (0:0:0, 0:0:0);


endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16KA_WX1_RX8(WCEN,WCLK,WCS0,WCS1,WE,RST,
                    WD0,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,WAD13,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RST;
input  WD0;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,WAD13;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [13:0] wad;
wire [10:0]  rad;
wire [1:0]  wcs;
wire [7:0] rd;
reg notifier;

assign wad = {WAD13,WAD12,WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
//assign {RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);

defparam RAM_U0.WADDR_WIDTH=14;
defparam RAM_U0.WDATA_WIDTH=1;
defparam RAM_U0.RADDR_WIDTH=11;
defparam RAM_U0.RDATA_WIDTH=8;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(WD0),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);
	$setuphold  (posedge WCLK, WAD12, 1, 0);
	$setuphold  (posedge WCLK, WAD13, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1); 

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);

	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);
	(RAD9 => RD0) = (0:0:0, 0:0:0);
	(RAD10 => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD1) = (0:0:0, 0:0:0);
	(RAD1 => RD1) = (0:0:0, 0:0:0);
	(RAD2 => RD1) = (0:0:0, 0:0:0);
	(RAD3 => RD1) = (0:0:0, 0:0:0);
	(RAD4 => RD1) = (0:0:0, 0:0:0);
	(RAD5 => RD1) = (0:0:0, 0:0:0);
	(RAD6 => RD1) = (0:0:0, 0:0:0);
	(RAD7 => RD1) = (0:0:0, 0:0:0);
	(RAD8 => RD1) = (0:0:0, 0:0:0);
	(RAD9 => RD1) = (0:0:0, 0:0:0);
	(RAD10 => RD1) = (0:0:0, 0:0:0);

	(RAD0 => RD2) = (0:0:0, 0:0:0);
	(RAD1 => RD2) = (0:0:0, 0:0:0);
	(RAD2 => RD2) = (0:0:0, 0:0:0);
	(RAD3 => RD2) = (0:0:0, 0:0:0);
	(RAD4 => RD2) = (0:0:0, 0:0:0);
	(RAD5 => RD2) = (0:0:0, 0:0:0);
	(RAD6 => RD2) = (0:0:0, 0:0:0);
	(RAD7 => RD2) = (0:0:0, 0:0:0);
	(RAD8 => RD2) = (0:0:0, 0:0:0);
	(RAD9 => RD2) = (0:0:0, 0:0:0);
	(RAD10 => RD2) = (0:0:0, 0:0:0);


	(RAD0 => RD3) = (0:0:0, 0:0:0);
	(RAD1 => RD3) = (0:0:0, 0:0:0);
	(RAD2 => RD3) = (0:0:0, 0:0:0);
	(RAD3 => RD3) = (0:0:0, 0:0:0);
	(RAD4 => RD3) = (0:0:0, 0:0:0);
	(RAD5 => RD3) = (0:0:0, 0:0:0);
	(RAD6 => RD3) = (0:0:0, 0:0:0);
	(RAD7 => RD3) = (0:0:0, 0:0:0);
	(RAD8 => RD3) = (0:0:0, 0:0:0);
	(RAD9 => RD3) = (0:0:0, 0:0:0);
	(RAD10 => RD3) = (0:0:0, 0:0:0);

	(RAD0 => RD4) = (0:0:0, 0:0:0);
	(RAD1 => RD4) = (0:0:0, 0:0:0);
	(RAD2 => RD4) = (0:0:0, 0:0:0);
	(RAD3 => RD4) = (0:0:0, 0:0:0);
	(RAD4 => RD4) = (0:0:0, 0:0:0);
	(RAD5 => RD4) = (0:0:0, 0:0:0);
	(RAD6 => RD4) = (0:0:0, 0:0:0);
	(RAD7 => RD4) = (0:0:0, 0:0:0);
	(RAD8 => RD4) = (0:0:0, 0:0:0);
	(RAD9 => RD4) = (0:0:0, 0:0:0);
	(RAD10 => RD4) = (0:0:0, 0:0:0);

	(RAD0 => RD5) = (0:0:0, 0:0:0);
	(RAD1 => RD5) = (0:0:0, 0:0:0);
	(RAD2 => RD5) = (0:0:0, 0:0:0);
	(RAD3 => RD5) = (0:0:0, 0:0:0);
	(RAD4 => RD5) = (0:0:0, 0:0:0);
	(RAD5 => RD5) = (0:0:0, 0:0:0);
	(RAD6 => RD5) = (0:0:0, 0:0:0);
	(RAD7 => RD5) = (0:0:0, 0:0:0);
	(RAD8 => RD5) = (0:0:0, 0:0:0);
	(RAD9 => RD5) = (0:0:0, 0:0:0);
	(RAD10 => RD5) = (0:0:0, 0:0:0);

	(RAD0 => RD6) = (0:0:0, 0:0:0);
	(RAD1 => RD6) = (0:0:0, 0:0:0);
	(RAD2 => RD6) = (0:0:0, 0:0:0);
	(RAD3 => RD6) = (0:0:0, 0:0:0);
	(RAD4 => RD6) = (0:0:0, 0:0:0);
	(RAD5 => RD6) = (0:0:0, 0:0:0);
	(RAD6 => RD6) = (0:0:0, 0:0:0);
	(RAD7 => RD6) = (0:0:0, 0:0:0);
	(RAD8 => RD6) = (0:0:0, 0:0:0);
	(RAD9 => RD6) = (0:0:0, 0:0:0);
	(RAD10 => RD6) = (0:0:0, 0:0:0);

	(RAD0 => RD7) = (0:0:0, 0:0:0);
	(RAD1 => RD7) = (0:0:0, 0:0:0);
	(RAD2 => RD7) = (0:0:0, 0:0:0);
	(RAD3 => RD7) = (0:0:0, 0:0:0);
	(RAD4 => RD7) = (0:0:0, 0:0:0);
	(RAD5 => RD7) = (0:0:0, 0:0:0);
	(RAD6 => RD7) = (0:0:0, 0:0:0);
	(RAD7 => RD7) = (0:0:0, 0:0:0);
	(RAD8 => RD7) = (0:0:0, 0:0:0);
	(RAD9 => RD7) = (0:0:0, 0:0:0);
	(RAD10 => RD7) = (0:0:0, 0:0:0);
endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16KA_WX1_RX16(WCEN,WCLK,WCS0,WCS1,WE,RST,
                    WD0,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,WAD13,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RST;
input  WD0;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,WAD13;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [13:0] wad;
wire [9:0]  rad;
wire [1:0]  wcs;
wire [15:0] rd;
reg notifier;

assign wad = {WAD13,WAD12,WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
//assign {RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
buf INSXQ8 (RD8,rd[8]);
buf INSXQ9 (RD9,rd[9]);

buf INSXQ10 (RD10,rd[10]);
buf INSXQ11 (RD11,rd[11]);
buf INSXQ12 (RD12,rd[12]);
buf INSXQ13 (RD13,rd[13]);
buf INSXQ14 (RD14,rd[14]);
buf INSXQ15 (RD15,rd[15]);
defparam RAM_U0.WADDR_WIDTH=14;
defparam RAM_U0.WDATA_WIDTH=1;
defparam RAM_U0.RADDR_WIDTH=10;
defparam RAM_U0.RDATA_WIDTH=16;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(WD0),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));


specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);
	$setuphold  (posedge WCLK, WAD12, 1, 0);
	$setuphold  (posedge WCLK, WAD13, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1); 

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);
	(RST => RD8) = (0:0:0, 0:0:0);
	(RST => RD9) = (0:0:0, 0:0:0);
	(RST => RD10) = (0:0:0, 0:0:0);
	(RST => RD11) = (0:0:0, 0:0:0);
	(RST => RD12) = (0:0:0, 0:0:0);
	(RST => RD13) = (0:0:0, 0:0:0);
	(RST => RD14) = (0:0:0, 0:0:0);
	(RST => RD15) = (0:0:0, 0:0:0);

	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);
	(RAD9 => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD1) = (0:0:0, 0:0:0);
	(RAD1 => RD1) = (0:0:0, 0:0:0);
	(RAD2 => RD1) = (0:0:0, 0:0:0);
	(RAD3 => RD1) = (0:0:0, 0:0:0);
	(RAD4 => RD1) = (0:0:0, 0:0:0);
	(RAD5 => RD1) = (0:0:0, 0:0:0);
	(RAD6 => RD1) = (0:0:0, 0:0:0);
	(RAD7 => RD1) = (0:0:0, 0:0:0);
	(RAD8 => RD1) = (0:0:0, 0:0:0);
	(RAD9 => RD1) = (0:0:0, 0:0:0);

	(RAD0 => RD2) = (0:0:0, 0:0:0);
	(RAD1 => RD2) = (0:0:0, 0:0:0);
	(RAD2 => RD2) = (0:0:0, 0:0:0);
	(RAD3 => RD2) = (0:0:0, 0:0:0);
	(RAD4 => RD2) = (0:0:0, 0:0:0);
	(RAD5 => RD2) = (0:0:0, 0:0:0);
	(RAD6 => RD2) = (0:0:0, 0:0:0);
	(RAD7 => RD2) = (0:0:0, 0:0:0);
	(RAD8 => RD2) = (0:0:0, 0:0:0);
	(RAD9 => RD2) = (0:0:0, 0:0:0);

	(RAD0 => RD3) = (0:0:0, 0:0:0);
	(RAD1 => RD3) = (0:0:0, 0:0:0);
	(RAD2 => RD3) = (0:0:0, 0:0:0);
	(RAD3 => RD3) = (0:0:0, 0:0:0);
	(RAD4 => RD3) = (0:0:0, 0:0:0);
	(RAD5 => RD3) = (0:0:0, 0:0:0);
	(RAD6 => RD3) = (0:0:0, 0:0:0);
	(RAD7 => RD3) = (0:0:0, 0:0:0);
	(RAD8 => RD3) = (0:0:0, 0:0:0);
	(RAD9 => RD3) = (0:0:0, 0:0:0);

	(RAD0 => RD4) = (0:0:0, 0:0:0);
	(RAD1 => RD4) = (0:0:0, 0:0:0);
	(RAD2 => RD4) = (0:0:0, 0:0:0);
	(RAD3 => RD4) = (0:0:0, 0:0:0);
	(RAD4 => RD4) = (0:0:0, 0:0:0);
	(RAD5 => RD4) = (0:0:0, 0:0:0);
	(RAD6 => RD4) = (0:0:0, 0:0:0);
	(RAD7 => RD4) = (0:0:0, 0:0:0);
	(RAD8 => RD4) = (0:0:0, 0:0:0);
	(RAD9 => RD4) = (0:0:0, 0:0:0);

	(RAD0 => RD5) = (0:0:0, 0:0:0);
	(RAD1 => RD5) = (0:0:0, 0:0:0);
	(RAD2 => RD5) = (0:0:0, 0:0:0);
	(RAD3 => RD5) = (0:0:0, 0:0:0);
	(RAD4 => RD5) = (0:0:0, 0:0:0);
	(RAD5 => RD5) = (0:0:0, 0:0:0);
	(RAD6 => RD5) = (0:0:0, 0:0:0);
	(RAD7 => RD5) = (0:0:0, 0:0:0);
	(RAD8 => RD5) = (0:0:0, 0:0:0);
	(RAD9 => RD5) = (0:0:0, 0:0:0);

	(RAD0 => RD6) = (0:0:0, 0:0:0);
	(RAD1 => RD6) = (0:0:0, 0:0:0);
	(RAD2 => RD6) = (0:0:0, 0:0:0);
	(RAD3 => RD6) = (0:0:0, 0:0:0);
	(RAD4 => RD6) = (0:0:0, 0:0:0);
	(RAD5 => RD6) = (0:0:0, 0:0:0);
	(RAD6 => RD6) = (0:0:0, 0:0:0);
	(RAD7 => RD6) = (0:0:0, 0:0:0);
	(RAD8 => RD6) = (0:0:0, 0:0:0);
	(RAD9 => RD6) = (0:0:0, 0:0:0);

	(RAD0 => RD7) = (0:0:0, 0:0:0);
	(RAD1 => RD7) = (0:0:0, 0:0:0);
	(RAD2 => RD7) = (0:0:0, 0:0:0);
	(RAD3 => RD7) = (0:0:0, 0:0:0);
	(RAD4 => RD7) = (0:0:0, 0:0:0);
	(RAD5 => RD7) = (0:0:0, 0:0:0);
	(RAD6 => RD7) = (0:0:0, 0:0:0);
	(RAD7 => RD7) = (0:0:0, 0:0:0);
	(RAD8 => RD7) = (0:0:0, 0:0:0);
	(RAD9 => RD7) = (0:0:0, 0:0:0);

	(RAD0 => RD8) = (0:0:0, 0:0:0);
	(RAD1 => RD8) = (0:0:0, 0:0:0);
	(RAD2 => RD8) = (0:0:0, 0:0:0);
	(RAD3 => RD8) = (0:0:0, 0:0:0);
	(RAD4 => RD8) = (0:0:0, 0:0:0);
	(RAD5 => RD8) = (0:0:0, 0:0:0);
	(RAD6 => RD8) = (0:0:0, 0:0:0);
	(RAD7 => RD8) = (0:0:0, 0:0:0);
	(RAD8 => RD8) = (0:0:0, 0:0:0);
	(RAD9 => RD8) = (0:0:0, 0:0:0);

	(RAD0 => RD9) = (0:0:0, 0:0:0);
	(RAD1 => RD9) = (0:0:0, 0:0:0);
	(RAD2 => RD9) = (0:0:0, 0:0:0);
	(RAD3 => RD9) = (0:0:0, 0:0:0);
	(RAD4 => RD9) = (0:0:0, 0:0:0);
	(RAD5 => RD9) = (0:0:0, 0:0:0);
	(RAD6 => RD9) = (0:0:0, 0:0:0);
	(RAD7 => RD9) = (0:0:0, 0:0:0);
	(RAD8 => RD9) = (0:0:0, 0:0:0);
	(RAD9 => RD9) = (0:0:0, 0:0:0);

	(RAD0 => RD10) = (0:0:0, 0:0:0);
	(RAD1 => RD10) = (0:0:0, 0:0:0);
	(RAD2 => RD10) = (0:0:0, 0:0:0);
	(RAD3 => RD10) = (0:0:0, 0:0:0);
	(RAD4 => RD10) = (0:0:0, 0:0:0);
	(RAD5 => RD10) = (0:0:0, 0:0:0);
	(RAD6 => RD10) = (0:0:0, 0:0:0);
	(RAD7 => RD10) = (0:0:0, 0:0:0);
	(RAD8 => RD10) = (0:0:0, 0:0:0);
	(RAD9 => RD10) = (0:0:0, 0:0:0);

	(RAD0 => RD11) = (0:0:0, 0:0:0);
	(RAD1 => RD11) = (0:0:0, 0:0:0);
	(RAD2 => RD11) = (0:0:0, 0:0:0);
	(RAD3 => RD11) = (0:0:0, 0:0:0);
	(RAD4 => RD11) = (0:0:0, 0:0:0);
	(RAD5 => RD11) = (0:0:0, 0:0:0);
	(RAD6 => RD11) = (0:0:0, 0:0:0);
	(RAD7 => RD11) = (0:0:0, 0:0:0);
	(RAD8 => RD11) = (0:0:0, 0:0:0);
	(RAD9 => RD11) = (0:0:0, 0:0:0);

	(RAD0 => RD12) = (0:0:0, 0:0:0);
	(RAD1 => RD12) = (0:0:0, 0:0:0);
	(RAD2 => RD12) = (0:0:0, 0:0:0);
	(RAD3 => RD12) = (0:0:0, 0:0:0);
	(RAD4 => RD12) = (0:0:0, 0:0:0);
	(RAD5 => RD12) = (0:0:0, 0:0:0);
	(RAD6 => RD12) = (0:0:0, 0:0:0);
	(RAD7 => RD12) = (0:0:0, 0:0:0);
	(RAD8 => RD12) = (0:0:0, 0:0:0);
	(RAD9 => RD12) = (0:0:0, 0:0:0);

	(RAD0 => RD13) = (0:0:0, 0:0:0);
	(RAD1 => RD13) = (0:0:0, 0:0:0);
	(RAD2 => RD13) = (0:0:0, 0:0:0);
	(RAD3 => RD13) = (0:0:0, 0:0:0);
	(RAD4 => RD13) = (0:0:0, 0:0:0);
	(RAD5 => RD13) = (0:0:0, 0:0:0);
	(RAD6 => RD13) = (0:0:0, 0:0:0);
	(RAD7 => RD13) = (0:0:0, 0:0:0);
	(RAD8 => RD13) = (0:0:0, 0:0:0);
	(RAD9 => RD13) = (0:0:0, 0:0:0);

	(RAD0 => RD14) = (0:0:0, 0:0:0);
	(RAD1 => RD14) = (0:0:0, 0:0:0);
	(RAD2 => RD14) = (0:0:0, 0:0:0);
	(RAD3 => RD14) = (0:0:0, 0:0:0);
	(RAD4 => RD14) = (0:0:0, 0:0:0);
	(RAD5 => RD14) = (0:0:0, 0:0:0);
	(RAD6 => RD14) = (0:0:0, 0:0:0);
	(RAD7 => RD14) = (0:0:0, 0:0:0);
	(RAD8 => RD14) = (0:0:0, 0:0:0);
	(RAD9 => RD14) = (0:0:0, 0:0:0);

	(RAD0 => RD15) = (0:0:0, 0:0:0);
	(RAD1 => RD15) = (0:0:0, 0:0:0);
	(RAD2 => RD15) = (0:0:0, 0:0:0);
	(RAD3 => RD15) = (0:0:0, 0:0:0);
	(RAD4 => RD15) = (0:0:0, 0:0:0);
	(RAD5 => RD15) = (0:0:0, 0:0:0);
	(RAD6 => RD15) = (0:0:0, 0:0:0);
	(RAD7 => RD15) = (0:0:0, 0:0:0);
	(RAD8 => RD15) = (0:0:0, 0:0:0);
	(RAD9 => RD15) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16KA_WX1_RX32(WCEN,WCLK,WCS0,WCS1,WE,RST,
                    WD0,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,WAD13,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15,
		    RD16,RD17,RD18,RD19,RD20,RD21,RD22,RD23,RD24,RD25,RD26,RD27,RD28,RD29,RD30,RD31
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RST;
input  WD0;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,WAD13;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15;
output  RD16,RD17,RD18,RD19,RD20,RD21,RD22,RD23,RD24,RD25,RD26,RD27,RD28,RD29,RD30,RD31;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [13:0] wad;
wire [8:0]  rad;
wire [1:0]  wcs;
wire [31:0] rd;
reg notifier;

assign wad = {WAD13,WAD12,WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
//assign {RD31,RD30,RD29,RD28,RD27,RD26,RD25,RD24,RD23,RD22,RD21,RD20,RD19,RD18,RD17,RD16,RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
buf INSXQ8 (RD8,rd[8]);
buf INSXQ9 (RD9,rd[9]);

buf INSXQ10 (RD10,rd[10]);
buf INSXQ11 (RD11,rd[11]);
buf INSXQ12 (RD12,rd[12]);
buf INSXQ13 (RD13,rd[13]);
buf INSXQ14 (RD14,rd[14]);
buf INSXQ15 (RD15,rd[15]);
buf INSXQ16 (RD16,rd[16]);
buf INSXQ17 (RD17,rd[17]);
buf INSXQ18 (RD18,rd[18]);
buf INSXQ19 (RD19,rd[19]);

buf INSXQ20 (RD20,rd[20]);
buf INSXQ21 (RD21,rd[21]);
buf INSXQ22 (RD22,rd[22]);
buf INSXQ23 (RD23,rd[23]);
buf INSXQ24 (RD24,rd[24]);
buf INSXQ25 (RD25,rd[25]);
buf INSXQ26 (RD26,rd[26]);
buf INSXQ27 (RD27,rd[27]);
buf INSXQ28 (RD28,rd[28]);
buf INSXQ29 (RD29,rd[29]);

buf INSXQ30 (RD30,rd[30]);
buf INSXQ31 (RD31,rd[31]);

defparam RAM_U0.WADDR_WIDTH=14;
defparam RAM_U0.WDATA_WIDTH=1;
defparam RAM_U0.RADDR_WIDTH=9;
defparam RAM_U0.RDATA_WIDTH=32;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(WD0),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));


specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);
	$setuphold  (posedge WCLK, WAD12, 1, 0);
	$setuphold  (posedge WCLK, WAD13, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1); 

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);
	(RST => RD8) = (0:0:0, 0:0:0);
	(RST => RD9) = (0:0:0, 0:0:0);
	(RST => RD10) = (0:0:0, 0:0:0);
	(RST => RD11) = (0:0:0, 0:0:0);
	(RST => RD12) = (0:0:0, 0:0:0);
	(RST => RD13) = (0:0:0, 0:0:0);
	(RST => RD14) = (0:0:0, 0:0:0);
	(RST => RD15) = (0:0:0, 0:0:0);
	(RST => RD16) = (0:0:0, 0:0:0);
	(RST => RD17) = (0:0:0, 0:0:0);
	(RST => RD18) = (0:0:0, 0:0:0);
	(RST => RD19) = (0:0:0, 0:0:0);
	(RST => RD20) = (0:0:0, 0:0:0);
	(RST => RD21) = (0:0:0, 0:0:0);
	(RST => RD22) = (0:0:0, 0:0:0);
	(RST => RD23) = (0:0:0, 0:0:0);
	(RST => RD24) = (0:0:0, 0:0:0);
	(RST => RD25) = (0:0:0, 0:0:0);
	(RST => RD26) = (0:0:0, 0:0:0);
	(RST => RD27) = (0:0:0, 0:0:0);
	(RST => RD28) = (0:0:0, 0:0:0);
	(RST => RD29) = (0:0:0, 0:0:0);
	(RST => RD30) = (0:0:0, 0:0:0);
	(RST => RD31) = (0:0:0, 0:0:0);

	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD1) = (0:0:0, 0:0:0);
	(RAD1 => RD1) = (0:0:0, 0:0:0);
	(RAD2 => RD1) = (0:0:0, 0:0:0);
	(RAD3 => RD1) = (0:0:0, 0:0:0);
	(RAD4 => RD1) = (0:0:0, 0:0:0);
	(RAD5 => RD1) = (0:0:0, 0:0:0);
	(RAD6 => RD1) = (0:0:0, 0:0:0);
	(RAD7 => RD1) = (0:0:0, 0:0:0);
	(RAD8 => RD1) = (0:0:0, 0:0:0);

	(RAD0 => RD2) = (0:0:0, 0:0:0);
	(RAD1 => RD2) = (0:0:0, 0:0:0);
	(RAD2 => RD2) = (0:0:0, 0:0:0);
	(RAD3 => RD2) = (0:0:0, 0:0:0);
	(RAD4 => RD2) = (0:0:0, 0:0:0);
	(RAD5 => RD2) = (0:0:0, 0:0:0);
	(RAD6 => RD2) = (0:0:0, 0:0:0);
	(RAD7 => RD2) = (0:0:0, 0:0:0);
	(RAD8 => RD2) = (0:0:0, 0:0:0);

	(RAD0 => RD3) = (0:0:0, 0:0:0);
	(RAD1 => RD3) = (0:0:0, 0:0:0);
	(RAD2 => RD3) = (0:0:0, 0:0:0);
	(RAD3 => RD3) = (0:0:0, 0:0:0);
	(RAD4 => RD3) = (0:0:0, 0:0:0);
	(RAD5 => RD3) = (0:0:0, 0:0:0);
	(RAD6 => RD3) = (0:0:0, 0:0:0);
	(RAD7 => RD3) = (0:0:0, 0:0:0);
	(RAD8 => RD3) = (0:0:0, 0:0:0);

	(RAD0 => RD4) = (0:0:0, 0:0:0);
	(RAD1 => RD4) = (0:0:0, 0:0:0);
	(RAD2 => RD4) = (0:0:0, 0:0:0);
	(RAD3 => RD4) = (0:0:0, 0:0:0);
	(RAD4 => RD4) = (0:0:0, 0:0:0);
	(RAD5 => RD4) = (0:0:0, 0:0:0);
	(RAD6 => RD4) = (0:0:0, 0:0:0);
	(RAD7 => RD4) = (0:0:0, 0:0:0);
	(RAD8 => RD4) = (0:0:0, 0:0:0);

	(RAD0 => RD5) = (0:0:0, 0:0:0);
	(RAD1 => RD5) = (0:0:0, 0:0:0);
	(RAD2 => RD5) = (0:0:0, 0:0:0);
	(RAD3 => RD5) = (0:0:0, 0:0:0);
	(RAD4 => RD5) = (0:0:0, 0:0:0);
	(RAD5 => RD5) = (0:0:0, 0:0:0);
	(RAD6 => RD5) = (0:0:0, 0:0:0);
	(RAD7 => RD5) = (0:0:0, 0:0:0);
	(RAD8 => RD5) = (0:0:0, 0:0:0);

	(RAD0 => RD6) = (0:0:0, 0:0:0);
	(RAD1 => RD6) = (0:0:0, 0:0:0);
	(RAD2 => RD6) = (0:0:0, 0:0:0);
	(RAD3 => RD6) = (0:0:0, 0:0:0);
	(RAD4 => RD6) = (0:0:0, 0:0:0);
	(RAD5 => RD6) = (0:0:0, 0:0:0);
	(RAD6 => RD6) = (0:0:0, 0:0:0);
	(RAD7 => RD6) = (0:0:0, 0:0:0);
	(RAD8 => RD6) = (0:0:0, 0:0:0);

	(RAD0 => RD7) = (0:0:0, 0:0:0);
	(RAD1 => RD7) = (0:0:0, 0:0:0);
	(RAD2 => RD7) = (0:0:0, 0:0:0);
	(RAD3 => RD7) = (0:0:0, 0:0:0);
	(RAD4 => RD7) = (0:0:0, 0:0:0);
	(RAD5 => RD7) = (0:0:0, 0:0:0);
	(RAD6 => RD7) = (0:0:0, 0:0:0);
	(RAD7 => RD7) = (0:0:0, 0:0:0);
	(RAD8 => RD7) = (0:0:0, 0:0:0);

	(RAD0 => RD8) = (0:0:0, 0:0:0);
	(RAD1 => RD8) = (0:0:0, 0:0:0);
	(RAD2 => RD8) = (0:0:0, 0:0:0);
	(RAD3 => RD8) = (0:0:0, 0:0:0);
	(RAD4 => RD8) = (0:0:0, 0:0:0);
	(RAD5 => RD8) = (0:0:0, 0:0:0);
	(RAD6 => RD8) = (0:0:0, 0:0:0);
	(RAD7 => RD8) = (0:0:0, 0:0:0);
	(RAD8 => RD8) = (0:0:0, 0:0:0);

	(RAD0 => RD9) = (0:0:0, 0:0:0);
	(RAD1 => RD9) = (0:0:0, 0:0:0);
	(RAD2 => RD9) = (0:0:0, 0:0:0);
	(RAD3 => RD9) = (0:0:0, 0:0:0);
	(RAD4 => RD9) = (0:0:0, 0:0:0);
	(RAD5 => RD9) = (0:0:0, 0:0:0);
	(RAD6 => RD9) = (0:0:0, 0:0:0);
	(RAD7 => RD9) = (0:0:0, 0:0:0);
	(RAD8 => RD9) = (0:0:0, 0:0:0);

	(RAD0 => RD10) = (0:0:0, 0:0:0);
	(RAD1 => RD10) = (0:0:0, 0:0:0);
	(RAD2 => RD10) = (0:0:0, 0:0:0);
	(RAD3 => RD10) = (0:0:0, 0:0:0);
	(RAD4 => RD10) = (0:0:0, 0:0:0);
	(RAD5 => RD10) = (0:0:0, 0:0:0);
	(RAD6 => RD10) = (0:0:0, 0:0:0);
	(RAD7 => RD10) = (0:0:0, 0:0:0);
	(RAD8 => RD10) = (0:0:0, 0:0:0);

	(RAD0 => RD11) = (0:0:0, 0:0:0);
	(RAD1 => RD11) = (0:0:0, 0:0:0);
	(RAD2 => RD11) = (0:0:0, 0:0:0);
	(RAD3 => RD11) = (0:0:0, 0:0:0);
	(RAD4 => RD11) = (0:0:0, 0:0:0);
	(RAD5 => RD11) = (0:0:0, 0:0:0);
	(RAD6 => RD11) = (0:0:0, 0:0:0);
	(RAD7 => RD11) = (0:0:0, 0:0:0);
	(RAD8 => RD11) = (0:0:0, 0:0:0);

	(RAD0 => RD12) = (0:0:0, 0:0:0);
	(RAD1 => RD12) = (0:0:0, 0:0:0);
	(RAD2 => RD12) = (0:0:0, 0:0:0);
	(RAD3 => RD12) = (0:0:0, 0:0:0);
	(RAD4 => RD12) = (0:0:0, 0:0:0);
	(RAD5 => RD12) = (0:0:0, 0:0:0);
	(RAD6 => RD12) = (0:0:0, 0:0:0);
	(RAD7 => RD12) = (0:0:0, 0:0:0);
	(RAD8 => RD12) = (0:0:0, 0:0:0);

	(RAD0 => RD13) = (0:0:0, 0:0:0);
	(RAD1 => RD13) = (0:0:0, 0:0:0);
	(RAD2 => RD13) = (0:0:0, 0:0:0);
	(RAD3 => RD13) = (0:0:0, 0:0:0);
	(RAD4 => RD13) = (0:0:0, 0:0:0);
	(RAD5 => RD13) = (0:0:0, 0:0:0);
	(RAD6 => RD13) = (0:0:0, 0:0:0);
	(RAD7 => RD13) = (0:0:0, 0:0:0);
	(RAD8 => RD13) = (0:0:0, 0:0:0);

	(RAD0 => RD14) = (0:0:0, 0:0:0);
	(RAD1 => RD14) = (0:0:0, 0:0:0);
	(RAD2 => RD14) = (0:0:0, 0:0:0);
	(RAD3 => RD14) = (0:0:0, 0:0:0);
	(RAD4 => RD14) = (0:0:0, 0:0:0);
	(RAD5 => RD14) = (0:0:0, 0:0:0);
	(RAD6 => RD14) = (0:0:0, 0:0:0);
	(RAD7 => RD14) = (0:0:0, 0:0:0);
	(RAD8 => RD14) = (0:0:0, 0:0:0);

	(RAD0 => RD15) = (0:0:0, 0:0:0);
	(RAD1 => RD15) = (0:0:0, 0:0:0);
	(RAD2 => RD15) = (0:0:0, 0:0:0);
	(RAD3 => RD15) = (0:0:0, 0:0:0);
	(RAD4 => RD15) = (0:0:0, 0:0:0);
	(RAD5 => RD15) = (0:0:0, 0:0:0);
	(RAD6 => RD15) = (0:0:0, 0:0:0);
	(RAD7 => RD15) = (0:0:0, 0:0:0);
	(RAD8 => RD15) = (0:0:0, 0:0:0);

	(RAD0 => RD16) = (0:0:0, 0:0:0);
	(RAD1 => RD16) = (0:0:0, 0:0:0);
	(RAD2 => RD16) = (0:0:0, 0:0:0);
	(RAD3 => RD16) = (0:0:0, 0:0:0);
	(RAD4 => RD16) = (0:0:0, 0:0:0);
	(RAD5 => RD16) = (0:0:0, 0:0:0);
	(RAD6 => RD16) = (0:0:0, 0:0:0);
	(RAD7 => RD16) = (0:0:0, 0:0:0);
	(RAD8 => RD16) = (0:0:0, 0:0:0);

	(RAD0 => RD17) = (0:0:0, 0:0:0);
	(RAD1 => RD17) = (0:0:0, 0:0:0);
	(RAD2 => RD17) = (0:0:0, 0:0:0);
	(RAD3 => RD17) = (0:0:0, 0:0:0);
	(RAD4 => RD17) = (0:0:0, 0:0:0);
	(RAD5 => RD17) = (0:0:0, 0:0:0);
	(RAD6 => RD17) = (0:0:0, 0:0:0);
	(RAD7 => RD17) = (0:0:0, 0:0:0);
	(RAD8 => RD17) = (0:0:0, 0:0:0);

	(RAD0 => RD18) = (0:0:0, 0:0:0);
	(RAD1 => RD18) = (0:0:0, 0:0:0);
	(RAD2 => RD18) = (0:0:0, 0:0:0);
	(RAD3 => RD18) = (0:0:0, 0:0:0);
	(RAD4 => RD18) = (0:0:0, 0:0:0);
	(RAD5 => RD18) = (0:0:0, 0:0:0);
	(RAD6 => RD18) = (0:0:0, 0:0:0);
	(RAD7 => RD18) = (0:0:0, 0:0:0);
	(RAD8 => RD18) = (0:0:0, 0:0:0);

	(RAD0 => RD19) = (0:0:0, 0:0:0);
	(RAD1 => RD19) = (0:0:0, 0:0:0);
	(RAD2 => RD19) = (0:0:0, 0:0:0);
	(RAD3 => RD19) = (0:0:0, 0:0:0);
	(RAD4 => RD19) = (0:0:0, 0:0:0);
	(RAD5 => RD19) = (0:0:0, 0:0:0);
	(RAD6 => RD19) = (0:0:0, 0:0:0);
	(RAD7 => RD19) = (0:0:0, 0:0:0);
	(RAD8 => RD19) = (0:0:0, 0:0:0);

	(RAD0 => RD20) = (0:0:0, 0:0:0);
	(RAD1 => RD20) = (0:0:0, 0:0:0);
	(RAD2 => RD20) = (0:0:0, 0:0:0);
	(RAD3 => RD20) = (0:0:0, 0:0:0);
	(RAD4 => RD20) = (0:0:0, 0:0:0);
	(RAD5 => RD20) = (0:0:0, 0:0:0);
	(RAD6 => RD20) = (0:0:0, 0:0:0);
	(RAD7 => RD20) = (0:0:0, 0:0:0);
	(RAD8 => RD20) = (0:0:0, 0:0:0);

	(RAD0 => RD21) = (0:0:0, 0:0:0);
	(RAD1 => RD21) = (0:0:0, 0:0:0);
	(RAD2 => RD21) = (0:0:0, 0:0:0);
	(RAD3 => RD21) = (0:0:0, 0:0:0);
	(RAD4 => RD21) = (0:0:0, 0:0:0);
	(RAD5 => RD21) = (0:0:0, 0:0:0);
	(RAD6 => RD21) = (0:0:0, 0:0:0);
	(RAD7 => RD21) = (0:0:0, 0:0:0);
	(RAD8 => RD21) = (0:0:0, 0:0:0);

	(RAD0 => RD22) = (0:0:0, 0:0:0);
	(RAD1 => RD22) = (0:0:0, 0:0:0);
	(RAD2 => RD22) = (0:0:0, 0:0:0);
	(RAD3 => RD22) = (0:0:0, 0:0:0);
	(RAD4 => RD22) = (0:0:0, 0:0:0);
	(RAD5 => RD22) = (0:0:0, 0:0:0);
	(RAD6 => RD22) = (0:0:0, 0:0:0);
	(RAD7 => RD22) = (0:0:0, 0:0:0);
	(RAD8 => RD22) = (0:0:0, 0:0:0);

	(RAD0 => RD23) = (0:0:0, 0:0:0);
	(RAD1 => RD23) = (0:0:0, 0:0:0);
	(RAD2 => RD23) = (0:0:0, 0:0:0);
	(RAD3 => RD23) = (0:0:0, 0:0:0);
	(RAD4 => RD23) = (0:0:0, 0:0:0);
	(RAD5 => RD23) = (0:0:0, 0:0:0);
	(RAD6 => RD23) = (0:0:0, 0:0:0);
	(RAD7 => RD23) = (0:0:0, 0:0:0);
	(RAD8 => RD23) = (0:0:0, 0:0:0);

	(RAD0 => RD24) = (0:0:0, 0:0:0);
	(RAD1 => RD24) = (0:0:0, 0:0:0);
	(RAD2 => RD24) = (0:0:0, 0:0:0);
	(RAD3 => RD24) = (0:0:0, 0:0:0);
	(RAD4 => RD24) = (0:0:0, 0:0:0);
	(RAD5 => RD24) = (0:0:0, 0:0:0);
	(RAD6 => RD24) = (0:0:0, 0:0:0);
	(RAD7 => RD24) = (0:0:0, 0:0:0);
	(RAD8 => RD24) = (0:0:0, 0:0:0);

	(RAD0 => RD25) = (0:0:0, 0:0:0);
	(RAD1 => RD25) = (0:0:0, 0:0:0);
	(RAD2 => RD25) = (0:0:0, 0:0:0);
	(RAD3 => RD25) = (0:0:0, 0:0:0);
	(RAD4 => RD25) = (0:0:0, 0:0:0);
	(RAD5 => RD25) = (0:0:0, 0:0:0);
	(RAD6 => RD25) = (0:0:0, 0:0:0);
	(RAD7 => RD25) = (0:0:0, 0:0:0);
	(RAD8 => RD25) = (0:0:0, 0:0:0);

	(RAD0 => RD26) = (0:0:0, 0:0:0);
	(RAD1 => RD26) = (0:0:0, 0:0:0);
	(RAD2 => RD26) = (0:0:0, 0:0:0);
	(RAD3 => RD26) = (0:0:0, 0:0:0);
	(RAD4 => RD26) = (0:0:0, 0:0:0);
	(RAD5 => RD26) = (0:0:0, 0:0:0);
	(RAD6 => RD26) = (0:0:0, 0:0:0);
	(RAD7 => RD26) = (0:0:0, 0:0:0);
	(RAD8 => RD26) = (0:0:0, 0:0:0);

	(RAD0 => RD27) = (0:0:0, 0:0:0);
	(RAD1 => RD27) = (0:0:0, 0:0:0);
	(RAD2 => RD27) = (0:0:0, 0:0:0);
	(RAD3 => RD27) = (0:0:0, 0:0:0);
	(RAD4 => RD27) = (0:0:0, 0:0:0);
	(RAD5 => RD27) = (0:0:0, 0:0:0);
	(RAD6 => RD27) = (0:0:0, 0:0:0);
	(RAD7 => RD27) = (0:0:0, 0:0:0);
	(RAD8 => RD27) = (0:0:0, 0:0:0);

	(RAD0 => RD28) = (0:0:0, 0:0:0);
	(RAD1 => RD28) = (0:0:0, 0:0:0);
	(RAD2 => RD28) = (0:0:0, 0:0:0);
	(RAD3 => RD28) = (0:0:0, 0:0:0);
	(RAD4 => RD28) = (0:0:0, 0:0:0);
	(RAD5 => RD28) = (0:0:0, 0:0:0);
	(RAD6 => RD28) = (0:0:0, 0:0:0);
	(RAD7 => RD28) = (0:0:0, 0:0:0);
	(RAD8 => RD28) = (0:0:0, 0:0:0);

	(RAD0 => RD29) = (0:0:0, 0:0:0);
	(RAD1 => RD29) = (0:0:0, 0:0:0);
	(RAD2 => RD29) = (0:0:0, 0:0:0);
	(RAD3 => RD29) = (0:0:0, 0:0:0);
	(RAD4 => RD29) = (0:0:0, 0:0:0);
	(RAD5 => RD29) = (0:0:0, 0:0:0);
	(RAD6 => RD29) = (0:0:0, 0:0:0);
	(RAD7 => RD29) = (0:0:0, 0:0:0);
	(RAD8 => RD29) = (0:0:0, 0:0:0);

	(RAD0 => RD30) = (0:0:0, 0:0:0);
	(RAD1 => RD30) = (0:0:0, 0:0:0);
	(RAD2 => RD30) = (0:0:0, 0:0:0);
	(RAD3 => RD30) = (0:0:0, 0:0:0);
	(RAD4 => RD30) = (0:0:0, 0:0:0);
	(RAD5 => RD30) = (0:0:0, 0:0:0);
	(RAD6 => RD30) = (0:0:0, 0:0:0);
	(RAD7 => RD30) = (0:0:0, 0:0:0);
	(RAD8 => RD30) = (0:0:0, 0:0:0);

	(RAD0 => RD31) = (0:0:0, 0:0:0);
	(RAD1 => RD31) = (0:0:0, 0:0:0);
	(RAD2 => RD31) = (0:0:0, 0:0:0);
	(RAD3 => RD31) = (0:0:0, 0:0:0);
	(RAD4 => RD31) = (0:0:0, 0:0:0);
	(RAD5 => RD31) = (0:0:0, 0:0:0);
	(RAD6 => RD31) = (0:0:0, 0:0:0);
	(RAD7 => RD31) = (0:0:0, 0:0:0);
	(RAD8 => RD31) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16KA_WX2_RX2(WCEN,WCLK,WCS0,WCS1,WE,RST,
                    WD0,WD1,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,
                    RD0,RD1
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RST;
input  WD0,WD1;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12;

output  RD0,RD1;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [12:0] wad;
wire [12:0]  rad;
wire [1:0]  wcs;
wire [1:0]  wd;
wire [1:0] rd;
reg notifier;

assign wad = {WAD12,WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD12,RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd  = {WD1,WD0};
//assign {RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);

defparam RAM_U0.WADDR_WIDTH=13;
defparam RAM_U0.WDATA_WIDTH=2;
defparam RAM_U0.RADDR_WIDTH=13;
defparam RAM_U0.RDATA_WIDTH=2;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));


specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);
	$setuphold  (posedge WCLK, WAD12, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1); 

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);

	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);
	(RAD9 => RD0) = (0:0:0, 0:0:0);
	(RAD10 => RD0) = (0:0:0, 0:0:0);
	(RAD11 => RD0) = (0:0:0, 0:0:0);
	(RAD12 => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD1) = (0:0:0, 0:0:0);
	(RAD1 => RD1) = (0:0:0, 0:0:0);
	(RAD2 => RD1) = (0:0:0, 0:0:0);
	(RAD3 => RD1) = (0:0:0, 0:0:0);
	(RAD4 => RD1) = (0:0:0, 0:0:0);
	(RAD5 => RD1) = (0:0:0, 0:0:0);
	(RAD6 => RD1) = (0:0:0, 0:0:0);
	(RAD7 => RD1) = (0:0:0, 0:0:0);
	(RAD8 => RD1) = (0:0:0, 0:0:0);
	(RAD9 => RD1) = (0:0:0, 0:0:0);
	(RAD10 => RD1) = (0:0:0, 0:0:0);
	(RAD11 => RD1) = (0:0:0, 0:0:0);
	(RAD12 => RD1) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16KA_WX2_RX4(WCEN,WCLK,WCS0,WCS1,WE,RST,
                    WD0,WD1,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,
                    RD0,RD1,RD2,RD3
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RST;
input  WD0,WD1;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11;

output  RD0,RD1,RD2,RD3;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [12:0] wad;
wire [11:0]  rad;
wire [1:0]  wcs;
wire [1:0]  wd;
wire [3:0] rd;
reg notifier;

assign wad = {WAD12,WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd  = {WD1,WD0};
//assign {RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);

defparam RAM_U0.WADDR_WIDTH=13;
defparam RAM_U0.WDATA_WIDTH=2;
defparam RAM_U0.RADDR_WIDTH=12;
defparam RAM_U0.RDATA_WIDTH=4;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);
	$setuphold  (posedge WCLK, WAD12, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1); 

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);

	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);
	(RAD9 => RD0) = (0:0:0, 0:0:0);
	(RAD10 => RD0) = (0:0:0, 0:0:0);
	(RAD11 => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD1) = (0:0:0, 0:0:0);
	(RAD1 => RD1) = (0:0:0, 0:0:0);
	(RAD2 => RD1) = (0:0:0, 0:0:0);
	(RAD3 => RD1) = (0:0:0, 0:0:0);
	(RAD4 => RD1) = (0:0:0, 0:0:0);
	(RAD5 => RD1) = (0:0:0, 0:0:0);
	(RAD6 => RD1) = (0:0:0, 0:0:0);
	(RAD7 => RD1) = (0:0:0, 0:0:0);
	(RAD8 => RD1) = (0:0:0, 0:0:0);
	(RAD9 => RD1) = (0:0:0, 0:0:0);
	(RAD10 => RD1) = (0:0:0, 0:0:0);
	(RAD11 => RD1) = (0:0:0, 0:0:0);

	(RAD0 => RD2) = (0:0:0, 0:0:0);
	(RAD1 => RD2) = (0:0:0, 0:0:0);
	(RAD2 => RD2) = (0:0:0, 0:0:0);
	(RAD3 => RD2) = (0:0:0, 0:0:0);
	(RAD4 => RD2) = (0:0:0, 0:0:0);
	(RAD5 => RD2) = (0:0:0, 0:0:0);
	(RAD6 => RD2) = (0:0:0, 0:0:0);
	(RAD7 => RD2) = (0:0:0, 0:0:0);
	(RAD8 => RD2) = (0:0:0, 0:0:0);
	(RAD9 => RD2) = (0:0:0, 0:0:0);
	(RAD10 => RD2) = (0:0:0, 0:0:0);
	(RAD11 => RD2) = (0:0:0, 0:0:0);

	(RAD0 => RD3) = (0:0:0, 0:0:0);
	(RAD1 => RD3) = (0:0:0, 0:0:0);
	(RAD2 => RD3) = (0:0:0, 0:0:0);
	(RAD3 => RD3) = (0:0:0, 0:0:0);
	(RAD4 => RD3) = (0:0:0, 0:0:0);
	(RAD5 => RD3) = (0:0:0, 0:0:0);
	(RAD6 => RD3) = (0:0:0, 0:0:0);
	(RAD7 => RD3) = (0:0:0, 0:0:0);
	(RAD8 => RD3) = (0:0:0, 0:0:0);
	(RAD9 => RD3) = (0:0:0, 0:0:0);
	(RAD10 => RD3) = (0:0:0, 0:0:0);
	(RAD11 => RD3) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16KA_WX2_RX8(WCEN,WCLK,WCS0,WCS1,WE,RST,
                    WD0,WD1,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RST;
input  WD0,WD1;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [12:0] wad;
wire [10:0]  rad;
wire [1:0]  wcs;
wire [1:0]  wd;
wire [7:0] rd;
reg notifier;

assign wad = {WAD12,WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd  = {WD1,WD0};
//assign {RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);

defparam RAM_U0.WADDR_WIDTH=13;
defparam RAM_U0.WDATA_WIDTH=2;
defparam RAM_U0.RADDR_WIDTH=11;
defparam RAM_U0.RDATA_WIDTH=8;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));


specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);
	$setuphold  (posedge WCLK, WAD12, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1); 

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);

	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);
	(RAD9 => RD0) = (0:0:0, 0:0:0);
	(RAD10 => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD1) = (0:0:0, 0:0:0);
	(RAD1 => RD1) = (0:0:0, 0:0:0);
	(RAD2 => RD1) = (0:0:0, 0:0:0);
	(RAD3 => RD1) = (0:0:0, 0:0:0);
	(RAD4 => RD1) = (0:0:0, 0:0:0);
	(RAD5 => RD1) = (0:0:0, 0:0:0);
	(RAD6 => RD1) = (0:0:0, 0:0:0);
	(RAD7 => RD1) = (0:0:0, 0:0:0);
	(RAD8 => RD1) = (0:0:0, 0:0:0);
	(RAD9 => RD1) = (0:0:0, 0:0:0);
	(RAD10 => RD1) = (0:0:0, 0:0:0);

	(RAD0 => RD2) = (0:0:0, 0:0:0);
	(RAD1 => RD2) = (0:0:0, 0:0:0);
	(RAD2 => RD2) = (0:0:0, 0:0:0);
	(RAD3 => RD2) = (0:0:0, 0:0:0);
	(RAD4 => RD2) = (0:0:0, 0:0:0);
	(RAD5 => RD2) = (0:0:0, 0:0:0);
	(RAD6 => RD2) = (0:0:0, 0:0:0);
	(RAD7 => RD2) = (0:0:0, 0:0:0);
	(RAD8 => RD2) = (0:0:0, 0:0:0);
	(RAD9 => RD2) = (0:0:0, 0:0:0);
	(RAD10 => RD2) = (0:0:0, 0:0:0);

	(RAD0 => RD3) = (0:0:0, 0:0:0);
	(RAD1 => RD3) = (0:0:0, 0:0:0);
	(RAD2 => RD3) = (0:0:0, 0:0:0);
	(RAD3 => RD3) = (0:0:0, 0:0:0);
	(RAD4 => RD3) = (0:0:0, 0:0:0);
	(RAD5 => RD3) = (0:0:0, 0:0:0);
	(RAD6 => RD3) = (0:0:0, 0:0:0);
	(RAD7 => RD3) = (0:0:0, 0:0:0);
	(RAD8 => RD3) = (0:0:0, 0:0:0);
	(RAD9 => RD3) = (0:0:0, 0:0:0);
	(RAD10 => RD3) = (0:0:0, 0:0:0);

	(RAD0 => RD4) = (0:0:0, 0:0:0);
	(RAD1 => RD4) = (0:0:0, 0:0:0);
	(RAD2 => RD4) = (0:0:0, 0:0:0);
	(RAD3 => RD4) = (0:0:0, 0:0:0);
	(RAD4 => RD4) = (0:0:0, 0:0:0);
	(RAD5 => RD4) = (0:0:0, 0:0:0);
	(RAD6 => RD4) = (0:0:0, 0:0:0);
	(RAD7 => RD4) = (0:0:0, 0:0:0);
	(RAD8 => RD4) = (0:0:0, 0:0:0);
	(RAD9 => RD4) = (0:0:0, 0:0:0);
	(RAD10 => RD4) = (0:0:0, 0:0:0);

	(RAD0 => RD5) = (0:0:0, 0:0:0);
	(RAD1 => RD5) = (0:0:0, 0:0:0);
	(RAD2 => RD5) = (0:0:0, 0:0:0);
	(RAD3 => RD5) = (0:0:0, 0:0:0);
	(RAD4 => RD5) = (0:0:0, 0:0:0);
	(RAD5 => RD5) = (0:0:0, 0:0:0);
	(RAD6 => RD5) = (0:0:0, 0:0:0);
	(RAD7 => RD5) = (0:0:0, 0:0:0);
	(RAD8 => RD5) = (0:0:0, 0:0:0);
	(RAD9 => RD5) = (0:0:0, 0:0:0);
	(RAD10 => RD5) = (0:0:0, 0:0:0);

	(RAD0 => RD6) = (0:0:0, 0:0:0);
	(RAD1 => RD6) = (0:0:0, 0:0:0);
	(RAD2 => RD6) = (0:0:0, 0:0:0);
	(RAD3 => RD6) = (0:0:0, 0:0:0);
	(RAD4 => RD6) = (0:0:0, 0:0:0);
	(RAD5 => RD6) = (0:0:0, 0:0:0);
	(RAD6 => RD6) = (0:0:0, 0:0:0);
	(RAD7 => RD6) = (0:0:0, 0:0:0);
	(RAD8 => RD6) = (0:0:0, 0:0:0);
	(RAD9 => RD6) = (0:0:0, 0:0:0);
	(RAD10 => RD6) = (0:0:0, 0:0:0);

	(RAD0 => RD7) = (0:0:0, 0:0:0);
	(RAD1 => RD7) = (0:0:0, 0:0:0);
	(RAD2 => RD7) = (0:0:0, 0:0:0);
	(RAD3 => RD7) = (0:0:0, 0:0:0);
	(RAD4 => RD7) = (0:0:0, 0:0:0);
	(RAD5 => RD7) = (0:0:0, 0:0:0);
	(RAD6 => RD7) = (0:0:0, 0:0:0);
	(RAD7 => RD7) = (0:0:0, 0:0:0);
	(RAD8 => RD7) = (0:0:0, 0:0:0);
	(RAD9 => RD7) = (0:0:0, 0:0:0);
	(RAD10 => RD7) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16KA_WX2_RX16(WCEN,WCLK,WCS0,WCS1,WE,RST,
                    WD0,WD1,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RST;
input  WD0,WD1;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [12:0] wad;
wire [9:0]  rad;
wire [1:0]  wcs;
wire [1:0]  wd;
wire [15:0] rd;
reg notifier;

assign wad = {WAD12,WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd = {WD1,WD0};
//assign {RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
buf INSXQ8 (RD8,rd[8]);
buf INSXQ9 (RD9,rd[9]);

buf INSXQ10 (RD10,rd[10]);
buf INSXQ11 (RD11,rd[11]);
buf INSXQ12 (RD12,rd[12]);
buf INSXQ13 (RD13,rd[13]);
buf INSXQ14 (RD14,rd[14]);
buf INSXQ15 (RD15,rd[15]);

defparam RAM_U0.WADDR_WIDTH=13;
defparam RAM_U0.WDATA_WIDTH=2;
defparam RAM_U0.RADDR_WIDTH=10;
defparam RAM_U0.RDATA_WIDTH=16;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);
	$setuphold  (posedge WCLK, WAD12, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1); 

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);
	(RST => RD8) = (0:0:0, 0:0:0);
	(RST => RD9) = (0:0:0, 0:0:0);
	(RST => RD10) = (0:0:0, 0:0:0);
	(RST => RD11) = (0:0:0, 0:0:0);
	(RST => RD12) = (0:0:0, 0:0:0);
	(RST => RD13) = (0:0:0, 0:0:0);
	(RST => RD14) = (0:0:0, 0:0:0);
	(RST => RD15) = (0:0:0, 0:0:0);

	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);
	(RAD9 => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD1) = (0:0:0, 0:0:0);
	(RAD1 => RD1) = (0:0:0, 0:0:0);
	(RAD2 => RD1) = (0:0:0, 0:0:0);
	(RAD3 => RD1) = (0:0:0, 0:0:0);
	(RAD4 => RD1) = (0:0:0, 0:0:0);
	(RAD5 => RD1) = (0:0:0, 0:0:0);
	(RAD6 => RD1) = (0:0:0, 0:0:0);
	(RAD7 => RD1) = (0:0:0, 0:0:0);
	(RAD8 => RD1) = (0:0:0, 0:0:0);
	(RAD9 => RD1) = (0:0:0, 0:0:0);

	(RAD0 => RD2) = (0:0:0, 0:0:0);
	(RAD1 => RD2) = (0:0:0, 0:0:0);
	(RAD2 => RD2) = (0:0:0, 0:0:0);
	(RAD3 => RD2) = (0:0:0, 0:0:0);
	(RAD4 => RD2) = (0:0:0, 0:0:0);
	(RAD5 => RD2) = (0:0:0, 0:0:0);
	(RAD6 => RD2) = (0:0:0, 0:0:0);
	(RAD7 => RD2) = (0:0:0, 0:0:0);
	(RAD8 => RD2) = (0:0:0, 0:0:0);
	(RAD9 => RD2) = (0:0:0, 0:0:0);

	(RAD0 => RD3) = (0:0:0, 0:0:0);
	(RAD1 => RD3) = (0:0:0, 0:0:0);
	(RAD2 => RD3) = (0:0:0, 0:0:0);
	(RAD3 => RD3) = (0:0:0, 0:0:0);
	(RAD4 => RD3) = (0:0:0, 0:0:0);
	(RAD5 => RD3) = (0:0:0, 0:0:0);
	(RAD6 => RD3) = (0:0:0, 0:0:0);
	(RAD7 => RD3) = (0:0:0, 0:0:0);
	(RAD8 => RD3) = (0:0:0, 0:0:0);
	(RAD9 => RD3) = (0:0:0, 0:0:0);

	(RAD0 => RD4) = (0:0:0, 0:0:0);
	(RAD1 => RD4) = (0:0:0, 0:0:0);
	(RAD2 => RD4) = (0:0:0, 0:0:0);
	(RAD3 => RD4) = (0:0:0, 0:0:0);
	(RAD4 => RD4) = (0:0:0, 0:0:0);
	(RAD5 => RD4) = (0:0:0, 0:0:0);
	(RAD6 => RD4) = (0:0:0, 0:0:0);
	(RAD7 => RD4) = (0:0:0, 0:0:0);
	(RAD8 => RD4) = (0:0:0, 0:0:0);
	(RAD9 => RD4) = (0:0:0, 0:0:0);

	(RAD0 => RD5) = (0:0:0, 0:0:0);
	(RAD1 => RD5) = (0:0:0, 0:0:0);
	(RAD2 => RD5) = (0:0:0, 0:0:0);
	(RAD3 => RD5) = (0:0:0, 0:0:0);
	(RAD4 => RD5) = (0:0:0, 0:0:0);
	(RAD5 => RD5) = (0:0:0, 0:0:0);
	(RAD6 => RD5) = (0:0:0, 0:0:0);
	(RAD7 => RD5) = (0:0:0, 0:0:0);
	(RAD8 => RD5) = (0:0:0, 0:0:0);
	(RAD9 => RD5) = (0:0:0, 0:0:0);

	(RAD0 => RD6) = (0:0:0, 0:0:0);
	(RAD1 => RD6) = (0:0:0, 0:0:0);
	(RAD2 => RD6) = (0:0:0, 0:0:0);
	(RAD3 => RD6) = (0:0:0, 0:0:0);
	(RAD4 => RD6) = (0:0:0, 0:0:0);
	(RAD5 => RD6) = (0:0:0, 0:0:0);
	(RAD6 => RD6) = (0:0:0, 0:0:0);
	(RAD7 => RD6) = (0:0:0, 0:0:0);
	(RAD8 => RD6) = (0:0:0, 0:0:0);
	(RAD9 => RD6) = (0:0:0, 0:0:0);

	(RAD0 => RD7) = (0:0:0, 0:0:0);
	(RAD1 => RD7) = (0:0:0, 0:0:0);
	(RAD2 => RD7) = (0:0:0, 0:0:0);
	(RAD3 => RD7) = (0:0:0, 0:0:0);
	(RAD4 => RD7) = (0:0:0, 0:0:0);
	(RAD5 => RD7) = (0:0:0, 0:0:0);
	(RAD6 => RD7) = (0:0:0, 0:0:0);
	(RAD7 => RD7) = (0:0:0, 0:0:0);
	(RAD8 => RD7) = (0:0:0, 0:0:0);
	(RAD9 => RD7) = (0:0:0, 0:0:0);

	(RAD0 => RD8) = (0:0:0, 0:0:0);
	(RAD1 => RD8) = (0:0:0, 0:0:0);
	(RAD2 => RD8) = (0:0:0, 0:0:0);
	(RAD3 => RD8) = (0:0:0, 0:0:0);
	(RAD4 => RD8) = (0:0:0, 0:0:0);
	(RAD5 => RD8) = (0:0:0, 0:0:0);
	(RAD6 => RD8) = (0:0:0, 0:0:0);
	(RAD7 => RD8) = (0:0:0, 0:0:0);
	(RAD8 => RD8) = (0:0:0, 0:0:0);
	(RAD9 => RD8) = (0:0:0, 0:0:0);

	(RAD0 => RD9) = (0:0:0, 0:0:0);
	(RAD1 => RD9) = (0:0:0, 0:0:0);
	(RAD2 => RD9) = (0:0:0, 0:0:0);
	(RAD3 => RD9) = (0:0:0, 0:0:0);
	(RAD4 => RD9) = (0:0:0, 0:0:0);
	(RAD5 => RD9) = (0:0:0, 0:0:0);
	(RAD6 => RD9) = (0:0:0, 0:0:0);
	(RAD7 => RD9) = (0:0:0, 0:0:0);
	(RAD8 => RD9) = (0:0:0, 0:0:0);
	(RAD9 => RD9) = (0:0:0, 0:0:0);

	(RAD0 => RD10) = (0:0:0, 0:0:0);
	(RAD1 => RD10) = (0:0:0, 0:0:0);
	(RAD2 => RD10) = (0:0:0, 0:0:0);
	(RAD3 => RD10) = (0:0:0, 0:0:0);
	(RAD4 => RD10) = (0:0:0, 0:0:0);
	(RAD5 => RD10) = (0:0:0, 0:0:0);
	(RAD6 => RD10) = (0:0:0, 0:0:0);
	(RAD7 => RD10) = (0:0:0, 0:0:0);
	(RAD8 => RD10) = (0:0:0, 0:0:0);
	(RAD9 => RD10) = (0:0:0, 0:0:0);

	(RAD0 => RD11) = (0:0:0, 0:0:0);
	(RAD1 => RD11) = (0:0:0, 0:0:0);
	(RAD2 => RD11) = (0:0:0, 0:0:0);
	(RAD3 => RD11) = (0:0:0, 0:0:0);
	(RAD4 => RD11) = (0:0:0, 0:0:0);
	(RAD5 => RD11) = (0:0:0, 0:0:0);
	(RAD6 => RD11) = (0:0:0, 0:0:0);
	(RAD7 => RD11) = (0:0:0, 0:0:0);
	(RAD8 => RD11) = (0:0:0, 0:0:0);
	(RAD9 => RD11) = (0:0:0, 0:0:0);

	(RAD0 => RD12) = (0:0:0, 0:0:0);
	(RAD1 => RD12) = (0:0:0, 0:0:0);
	(RAD2 => RD12) = (0:0:0, 0:0:0);
	(RAD3 => RD12) = (0:0:0, 0:0:0);
	(RAD4 => RD12) = (0:0:0, 0:0:0);
	(RAD5 => RD12) = (0:0:0, 0:0:0);
	(RAD6 => RD12) = (0:0:0, 0:0:0);
	(RAD7 => RD12) = (0:0:0, 0:0:0);
	(RAD8 => RD12) = (0:0:0, 0:0:0);
	(RAD9 => RD12) = (0:0:0, 0:0:0);

	(RAD0 => RD13) = (0:0:0, 0:0:0);
	(RAD1 => RD13) = (0:0:0, 0:0:0);
	(RAD2 => RD13) = (0:0:0, 0:0:0);
	(RAD3 => RD13) = (0:0:0, 0:0:0);
	(RAD4 => RD13) = (0:0:0, 0:0:0);
	(RAD5 => RD13) = (0:0:0, 0:0:0);
	(RAD6 => RD13) = (0:0:0, 0:0:0);
	(RAD7 => RD13) = (0:0:0, 0:0:0);
	(RAD8 => RD13) = (0:0:0, 0:0:0);
	(RAD9 => RD13) = (0:0:0, 0:0:0);

	(RAD0 => RD14) = (0:0:0, 0:0:0);
	(RAD1 => RD14) = (0:0:0, 0:0:0);
	(RAD2 => RD14) = (0:0:0, 0:0:0);
	(RAD3 => RD14) = (0:0:0, 0:0:0);
	(RAD4 => RD14) = (0:0:0, 0:0:0);
	(RAD5 => RD14) = (0:0:0, 0:0:0);
	(RAD6 => RD14) = (0:0:0, 0:0:0);
	(RAD7 => RD14) = (0:0:0, 0:0:0);
	(RAD8 => RD14) = (0:0:0, 0:0:0);
	(RAD9 => RD14) = (0:0:0, 0:0:0);

	(RAD0 => RD15) = (0:0:0, 0:0:0);
	(RAD1 => RD15) = (0:0:0, 0:0:0);
	(RAD2 => RD15) = (0:0:0, 0:0:0);
	(RAD3 => RD15) = (0:0:0, 0:0:0);
	(RAD4 => RD15) = (0:0:0, 0:0:0);
	(RAD5 => RD15) = (0:0:0, 0:0:0);
	(RAD6 => RD15) = (0:0:0, 0:0:0);
	(RAD7 => RD15) = (0:0:0, 0:0:0);
	(RAD8 => RD15) = (0:0:0, 0:0:0);
	(RAD9 => RD15) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16KA_WX2_RX32(WCEN,WCLK,WCS0,WCS1,WE,RST,
                    WD0,WD1,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15,
                    RD16,RD17,RD18,RD19,RD20,RD21,RD22,RD23,RD24,RD25,RD26,RD27,RD28,RD29,RD30,RD31
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RST;
input  WD0,WD1;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15;
output  RD16,RD17,RD18,RD19,RD20,RD21,RD22,RD23,RD24,RD25,RD26,RD27,RD28,RD29,RD30,RD31;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [12:0] wad;
wire [8:0]  rad;
wire [1:0]  wcs;
wire [1:0]  wd;
wire [31:0] rd;
reg notifier;

assign wad = {WAD12,WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd = {WD1,WD0};
//assign  {RD31,RD30,RD29,RD28,RD27,RD26,RD25,RD24,RD23,RD22,RD21,RD20,RD19,RD18,RD17,RD16,RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
buf INSXQ8 (RD8,rd[8]);
buf INSXQ9 (RD9,rd[9]);

buf INSXQ10 (RD10,rd[10]);
buf INSXQ11 (RD11,rd[11]);
buf INSXQ12 (RD12,rd[12]);
buf INSXQ13 (RD13,rd[13]);
buf INSXQ14 (RD14,rd[14]);
buf INSXQ15 (RD15,rd[15]);
buf INSXQ16 (RD16,rd[16]);
buf INSXQ17 (RD17,rd[17]);
buf INSXQ18 (RD18,rd[18]);
buf INSXQ19 (RD19,rd[19]);

buf INSXQ20 (RD20,rd[20]);
buf INSXQ21 (RD21,rd[21]);
buf INSXQ22 (RD22,rd[22]);
buf INSXQ23 (RD23,rd[23]);
buf INSXQ24 (RD24,rd[24]);
buf INSXQ25 (RD25,rd[25]);
buf INSXQ26 (RD26,rd[26]);
buf INSXQ27 (RD27,rd[27]);
buf INSXQ28 (RD28,rd[28]);
buf INSXQ29 (RD29,rd[29]);

buf INSXQ30 (RD30,rd[30]);
buf INSXQ31 (RD31,rd[31]);

defparam RAM_U0.WADDR_WIDTH=13;
defparam RAM_U0.WDATA_WIDTH=2;
defparam RAM_U0.RADDR_WIDTH=9;
defparam RAM_U0.RDATA_WIDTH=32;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);
	$setuphold  (posedge WCLK, WAD12, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1); 

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);
	(RST => RD8) = (0:0:0, 0:0:0);
	(RST => RD9) = (0:0:0, 0:0:0);
	(RST => RD10) = (0:0:0, 0:0:0);
	(RST => RD11) = (0:0:0, 0:0:0);
	(RST => RD12) = (0:0:0, 0:0:0);
	(RST => RD13) = (0:0:0, 0:0:0);
	(RST => RD14) = (0:0:0, 0:0:0);
	(RST => RD15) = (0:0:0, 0:0:0);
	(RST => RD16) = (0:0:0, 0:0:0);
	(RST => RD17) = (0:0:0, 0:0:0);
	(RST => RD18) = (0:0:0, 0:0:0);
	(RST => RD19) = (0:0:0, 0:0:0);
	(RST => RD20) = (0:0:0, 0:0:0);
	(RST => RD21) = (0:0:0, 0:0:0);
	(RST => RD22) = (0:0:0, 0:0:0);
	(RST => RD23) = (0:0:0, 0:0:0);
	(RST => RD24) = (0:0:0, 0:0:0);
	(RST => RD25) = (0:0:0, 0:0:0);
	(RST => RD26) = (0:0:0, 0:0:0);
	(RST => RD27) = (0:0:0, 0:0:0);
	(RST => RD28) = (0:0:0, 0:0:0);
	(RST => RD29) = (0:0:0, 0:0:0);
	(RST => RD30) = (0:0:0, 0:0:0);
	(RST => RD31) = (0:0:0, 0:0:0);

	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD1) = (0:0:0, 0:0:0);
	(RAD1 => RD1) = (0:0:0, 0:0:0);
	(RAD2 => RD1) = (0:0:0, 0:0:0);
	(RAD3 => RD1) = (0:0:0, 0:0:0);
	(RAD4 => RD1) = (0:0:0, 0:0:0);
	(RAD5 => RD1) = (0:0:0, 0:0:0);
	(RAD6 => RD1) = (0:0:0, 0:0:0);
	(RAD7 => RD1) = (0:0:0, 0:0:0);
	(RAD8 => RD1) = (0:0:0, 0:0:0);

	(RAD0 => RD2) = (0:0:0, 0:0:0);
	(RAD1 => RD2) = (0:0:0, 0:0:0);
	(RAD2 => RD2) = (0:0:0, 0:0:0);
	(RAD3 => RD2) = (0:0:0, 0:0:0);
	(RAD4 => RD2) = (0:0:0, 0:0:0);
	(RAD5 => RD2) = (0:0:0, 0:0:0);
	(RAD6 => RD2) = (0:0:0, 0:0:0);
	(RAD7 => RD2) = (0:0:0, 0:0:0);
	(RAD8 => RD2) = (0:0:0, 0:0:0);

	(RAD0 => RD3) = (0:0:0, 0:0:0);
	(RAD1 => RD3) = (0:0:0, 0:0:0);
	(RAD2 => RD3) = (0:0:0, 0:0:0);
	(RAD3 => RD3) = (0:0:0, 0:0:0);
	(RAD4 => RD3) = (0:0:0, 0:0:0);
	(RAD5 => RD3) = (0:0:0, 0:0:0);
	(RAD6 => RD3) = (0:0:0, 0:0:0);
	(RAD7 => RD3) = (0:0:0, 0:0:0);
	(RAD8 => RD3) = (0:0:0, 0:0:0);

	(RAD0 => RD4) = (0:0:0, 0:0:0);
	(RAD1 => RD4) = (0:0:0, 0:0:0);
	(RAD2 => RD4) = (0:0:0, 0:0:0);
	(RAD3 => RD4) = (0:0:0, 0:0:0);
	(RAD4 => RD4) = (0:0:0, 0:0:0);
	(RAD5 => RD4) = (0:0:0, 0:0:0);
	(RAD6 => RD4) = (0:0:0, 0:0:0);
	(RAD7 => RD4) = (0:0:0, 0:0:0);
	(RAD8 => RD4) = (0:0:0, 0:0:0);

	(RAD0 => RD5) = (0:0:0, 0:0:0);
	(RAD1 => RD5) = (0:0:0, 0:0:0);
	(RAD2 => RD5) = (0:0:0, 0:0:0);
	(RAD3 => RD5) = (0:0:0, 0:0:0);
	(RAD4 => RD5) = (0:0:0, 0:0:0);
	(RAD5 => RD5) = (0:0:0, 0:0:0);
	(RAD6 => RD5) = (0:0:0, 0:0:0);
	(RAD7 => RD5) = (0:0:0, 0:0:0);
	(RAD8 => RD5) = (0:0:0, 0:0:0);

	(RAD0 => RD6) = (0:0:0, 0:0:0);
	(RAD1 => RD6) = (0:0:0, 0:0:0);
	(RAD2 => RD6) = (0:0:0, 0:0:0);
	(RAD3 => RD6) = (0:0:0, 0:0:0);
	(RAD4 => RD6) = (0:0:0, 0:0:0);
	(RAD5 => RD6) = (0:0:0, 0:0:0);
	(RAD6 => RD6) = (0:0:0, 0:0:0);
	(RAD7 => RD6) = (0:0:0, 0:0:0);
	(RAD8 => RD6) = (0:0:0, 0:0:0);

	(RAD0 => RD7) = (0:0:0, 0:0:0);
	(RAD1 => RD7) = (0:0:0, 0:0:0);
	(RAD2 => RD7) = (0:0:0, 0:0:0);
	(RAD3 => RD7) = (0:0:0, 0:0:0);
	(RAD4 => RD7) = (0:0:0, 0:0:0);
	(RAD5 => RD7) = (0:0:0, 0:0:0);
	(RAD6 => RD7) = (0:0:0, 0:0:0);
	(RAD7 => RD7) = (0:0:0, 0:0:0);
	(RAD8 => RD7) = (0:0:0, 0:0:0);

	(RAD0 => RD8) = (0:0:0, 0:0:0);
	(RAD1 => RD8) = (0:0:0, 0:0:0);
	(RAD2 => RD8) = (0:0:0, 0:0:0);
	(RAD3 => RD8) = (0:0:0, 0:0:0);
	(RAD4 => RD8) = (0:0:0, 0:0:0);
	(RAD5 => RD8) = (0:0:0, 0:0:0);
	(RAD6 => RD8) = (0:0:0, 0:0:0);
	(RAD7 => RD8) = (0:0:0, 0:0:0);
	(RAD8 => RD8) = (0:0:0, 0:0:0);

	(RAD0 => RD9) = (0:0:0, 0:0:0);
	(RAD1 => RD9) = (0:0:0, 0:0:0);
	(RAD2 => RD9) = (0:0:0, 0:0:0);
	(RAD3 => RD9) = (0:0:0, 0:0:0);
	(RAD4 => RD9) = (0:0:0, 0:0:0);
	(RAD5 => RD9) = (0:0:0, 0:0:0);
	(RAD6 => RD9) = (0:0:0, 0:0:0);
	(RAD7 => RD9) = (0:0:0, 0:0:0);
	(RAD8 => RD9) = (0:0:0, 0:0:0);

	(RAD0 => RD10) = (0:0:0, 0:0:0);
	(RAD1 => RD10) = (0:0:0, 0:0:0);
	(RAD2 => RD10) = (0:0:0, 0:0:0);
	(RAD3 => RD10) = (0:0:0, 0:0:0);
	(RAD4 => RD10) = (0:0:0, 0:0:0);
	(RAD5 => RD10) = (0:0:0, 0:0:0);
	(RAD6 => RD10) = (0:0:0, 0:0:0);
	(RAD7 => RD10) = (0:0:0, 0:0:0);
	(RAD8 => RD10) = (0:0:0, 0:0:0);

	(RAD0 => RD11) = (0:0:0, 0:0:0);
	(RAD1 => RD11) = (0:0:0, 0:0:0);
	(RAD2 => RD11) = (0:0:0, 0:0:0);
	(RAD3 => RD11) = (0:0:0, 0:0:0);
	(RAD4 => RD11) = (0:0:0, 0:0:0);
	(RAD5 => RD11) = (0:0:0, 0:0:0);
	(RAD6 => RD11) = (0:0:0, 0:0:0);
	(RAD7 => RD11) = (0:0:0, 0:0:0);
	(RAD8 => RD11) = (0:0:0, 0:0:0);

	(RAD0 => RD12) = (0:0:0, 0:0:0);
	(RAD1 => RD12) = (0:0:0, 0:0:0);
	(RAD2 => RD12) = (0:0:0, 0:0:0);
	(RAD3 => RD12) = (0:0:0, 0:0:0);
	(RAD4 => RD12) = (0:0:0, 0:0:0);
	(RAD5 => RD12) = (0:0:0, 0:0:0);
	(RAD6 => RD12) = (0:0:0, 0:0:0);
	(RAD7 => RD12) = (0:0:0, 0:0:0);
	(RAD8 => RD12) = (0:0:0, 0:0:0);

	(RAD0 => RD13) = (0:0:0, 0:0:0);
	(RAD1 => RD13) = (0:0:0, 0:0:0);
	(RAD2 => RD13) = (0:0:0, 0:0:0);
	(RAD3 => RD13) = (0:0:0, 0:0:0);
	(RAD4 => RD13) = (0:0:0, 0:0:0);
	(RAD5 => RD13) = (0:0:0, 0:0:0);
	(RAD6 => RD13) = (0:0:0, 0:0:0);
	(RAD7 => RD13) = (0:0:0, 0:0:0);
	(RAD8 => RD13) = (0:0:0, 0:0:0);

	(RAD0 => RD14) = (0:0:0, 0:0:0);
	(RAD1 => RD14) = (0:0:0, 0:0:0);
	(RAD2 => RD14) = (0:0:0, 0:0:0);
	(RAD3 => RD14) = (0:0:0, 0:0:0);
	(RAD4 => RD14) = (0:0:0, 0:0:0);
	(RAD5 => RD14) = (0:0:0, 0:0:0);
	(RAD6 => RD14) = (0:0:0, 0:0:0);
	(RAD7 => RD14) = (0:0:0, 0:0:0);
	(RAD8 => RD14) = (0:0:0, 0:0:0);

	(RAD0 => RD15) = (0:0:0, 0:0:0);
	(RAD1 => RD15) = (0:0:0, 0:0:0);
	(RAD2 => RD15) = (0:0:0, 0:0:0);
	(RAD3 => RD15) = (0:0:0, 0:0:0);
	(RAD4 => RD15) = (0:0:0, 0:0:0);
	(RAD5 => RD15) = (0:0:0, 0:0:0);
	(RAD6 => RD15) = (0:0:0, 0:0:0);
	(RAD7 => RD15) = (0:0:0, 0:0:0);
	(RAD8 => RD15) = (0:0:0, 0:0:0);

	(RAD0 => RD16) = (0:0:0, 0:0:0);
	(RAD1 => RD16) = (0:0:0, 0:0:0);
	(RAD2 => RD16) = (0:0:0, 0:0:0);
	(RAD3 => RD16) = (0:0:0, 0:0:0);
	(RAD4 => RD16) = (0:0:0, 0:0:0);
	(RAD5 => RD16) = (0:0:0, 0:0:0);
	(RAD6 => RD16) = (0:0:0, 0:0:0);
	(RAD7 => RD16) = (0:0:0, 0:0:0);
	(RAD8 => RD16) = (0:0:0, 0:0:0);

	(RAD0 => RD17) = (0:0:0, 0:0:0);
	(RAD1 => RD17) = (0:0:0, 0:0:0);
	(RAD2 => RD17) = (0:0:0, 0:0:0);
	(RAD3 => RD17) = (0:0:0, 0:0:0);
	(RAD4 => RD17) = (0:0:0, 0:0:0);
	(RAD5 => RD17) = (0:0:0, 0:0:0);
	(RAD6 => RD17) = (0:0:0, 0:0:0);
	(RAD7 => RD17) = (0:0:0, 0:0:0);
	(RAD8 => RD17) = (0:0:0, 0:0:0);

	(RAD0 => RD18) = (0:0:0, 0:0:0);
	(RAD1 => RD18) = (0:0:0, 0:0:0);
	(RAD2 => RD18) = (0:0:0, 0:0:0);
	(RAD3 => RD18) = (0:0:0, 0:0:0);
	(RAD4 => RD18) = (0:0:0, 0:0:0);
	(RAD5 => RD18) = (0:0:0, 0:0:0);
	(RAD6 => RD18) = (0:0:0, 0:0:0);
	(RAD7 => RD18) = (0:0:0, 0:0:0);
	(RAD8 => RD18) = (0:0:0, 0:0:0);

	(RAD0 => RD19) = (0:0:0, 0:0:0);
	(RAD1 => RD19) = (0:0:0, 0:0:0);
	(RAD2 => RD19) = (0:0:0, 0:0:0);
	(RAD3 => RD19) = (0:0:0, 0:0:0);
	(RAD4 => RD19) = (0:0:0, 0:0:0);
	(RAD5 => RD19) = (0:0:0, 0:0:0);
	(RAD6 => RD19) = (0:0:0, 0:0:0);
	(RAD7 => RD19) = (0:0:0, 0:0:0);
	(RAD8 => RD19) = (0:0:0, 0:0:0);

	(RAD0 => RD20) = (0:0:0, 0:0:0);
	(RAD1 => RD20) = (0:0:0, 0:0:0);
	(RAD2 => RD20) = (0:0:0, 0:0:0);
	(RAD3 => RD20) = (0:0:0, 0:0:0);
	(RAD4 => RD20) = (0:0:0, 0:0:0);
	(RAD5 => RD20) = (0:0:0, 0:0:0);
	(RAD6 => RD20) = (0:0:0, 0:0:0);
	(RAD7 => RD20) = (0:0:0, 0:0:0);
	(RAD8 => RD20) = (0:0:0, 0:0:0);

	(RAD0 => RD21) = (0:0:0, 0:0:0);
	(RAD1 => RD21) = (0:0:0, 0:0:0);
	(RAD2 => RD21) = (0:0:0, 0:0:0);
	(RAD3 => RD21) = (0:0:0, 0:0:0);
	(RAD4 => RD21) = (0:0:0, 0:0:0);
	(RAD5 => RD21) = (0:0:0, 0:0:0);
	(RAD6 => RD21) = (0:0:0, 0:0:0);
	(RAD7 => RD21) = (0:0:0, 0:0:0);
	(RAD8 => RD21) = (0:0:0, 0:0:0);

	(RAD0 => RD22) = (0:0:0, 0:0:0);
	(RAD1 => RD22) = (0:0:0, 0:0:0);
	(RAD2 => RD22) = (0:0:0, 0:0:0);
	(RAD3 => RD22) = (0:0:0, 0:0:0);
	(RAD4 => RD22) = (0:0:0, 0:0:0);
	(RAD5 => RD22) = (0:0:0, 0:0:0);
	(RAD6 => RD22) = (0:0:0, 0:0:0);
	(RAD7 => RD22) = (0:0:0, 0:0:0);
	(RAD8 => RD22) = (0:0:0, 0:0:0);

	(RAD0 => RD23) = (0:0:0, 0:0:0);
	(RAD1 => RD23) = (0:0:0, 0:0:0);
	(RAD2 => RD23) = (0:0:0, 0:0:0);
	(RAD3 => RD23) = (0:0:0, 0:0:0);
	(RAD4 => RD23) = (0:0:0, 0:0:0);
	(RAD5 => RD23) = (0:0:0, 0:0:0);
	(RAD6 => RD23) = (0:0:0, 0:0:0);
	(RAD7 => RD23) = (0:0:0, 0:0:0);
	(RAD8 => RD23) = (0:0:0, 0:0:0);

	(RAD0 => RD24) = (0:0:0, 0:0:0);
	(RAD1 => RD24) = (0:0:0, 0:0:0);
	(RAD2 => RD24) = (0:0:0, 0:0:0);
	(RAD3 => RD24) = (0:0:0, 0:0:0);
	(RAD4 => RD24) = (0:0:0, 0:0:0);
	(RAD5 => RD24) = (0:0:0, 0:0:0);
	(RAD6 => RD24) = (0:0:0, 0:0:0);
	(RAD7 => RD24) = (0:0:0, 0:0:0);
	(RAD8 => RD24) = (0:0:0, 0:0:0);

	(RAD0 => RD25) = (0:0:0, 0:0:0);
	(RAD1 => RD25) = (0:0:0, 0:0:0);
	(RAD2 => RD25) = (0:0:0, 0:0:0);
	(RAD3 => RD25) = (0:0:0, 0:0:0);
	(RAD4 => RD25) = (0:0:0, 0:0:0);
	(RAD5 => RD25) = (0:0:0, 0:0:0);
	(RAD6 => RD25) = (0:0:0, 0:0:0);
	(RAD7 => RD25) = (0:0:0, 0:0:0);
	(RAD8 => RD25) = (0:0:0, 0:0:0);

	(RAD0 => RD26) = (0:0:0, 0:0:0);
	(RAD1 => RD26) = (0:0:0, 0:0:0);
	(RAD2 => RD26) = (0:0:0, 0:0:0);
	(RAD3 => RD26) = (0:0:0, 0:0:0);
	(RAD4 => RD26) = (0:0:0, 0:0:0);
	(RAD5 => RD26) = (0:0:0, 0:0:0);
	(RAD6 => RD26) = (0:0:0, 0:0:0);
	(RAD7 => RD26) = (0:0:0, 0:0:0);
	(RAD8 => RD26) = (0:0:0, 0:0:0);

	(RAD0 => RD27) = (0:0:0, 0:0:0);
	(RAD1 => RD27) = (0:0:0, 0:0:0);
	(RAD2 => RD27) = (0:0:0, 0:0:0);
	(RAD3 => RD27) = (0:0:0, 0:0:0);
	(RAD4 => RD27) = (0:0:0, 0:0:0);
	(RAD5 => RD27) = (0:0:0, 0:0:0);
	(RAD6 => RD27) = (0:0:0, 0:0:0);
	(RAD7 => RD27) = (0:0:0, 0:0:0);
	(RAD8 => RD27) = (0:0:0, 0:0:0);

	(RAD0 => RD28) = (0:0:0, 0:0:0);
	(RAD1 => RD28) = (0:0:0, 0:0:0);
	(RAD2 => RD28) = (0:0:0, 0:0:0);
	(RAD3 => RD28) = (0:0:0, 0:0:0);
	(RAD4 => RD28) = (0:0:0, 0:0:0);
	(RAD5 => RD28) = (0:0:0, 0:0:0);
	(RAD6 => RD28) = (0:0:0, 0:0:0);
	(RAD7 => RD28) = (0:0:0, 0:0:0);
	(RAD8 => RD28) = (0:0:0, 0:0:0);

	(RAD0 => RD29) = (0:0:0, 0:0:0);
	(RAD1 => RD29) = (0:0:0, 0:0:0);
	(RAD2 => RD29) = (0:0:0, 0:0:0);
	(RAD3 => RD29) = (0:0:0, 0:0:0);
	(RAD4 => RD29) = (0:0:0, 0:0:0);
	(RAD5 => RD29) = (0:0:0, 0:0:0);
	(RAD6 => RD29) = (0:0:0, 0:0:0);
	(RAD7 => RD29) = (0:0:0, 0:0:0);
	(RAD8 => RD29) = (0:0:0, 0:0:0);

	(RAD0 => RD30) = (0:0:0, 0:0:0);
	(RAD1 => RD30) = (0:0:0, 0:0:0);
	(RAD2 => RD30) = (0:0:0, 0:0:0);
	(RAD3 => RD30) = (0:0:0, 0:0:0);
	(RAD4 => RD30) = (0:0:0, 0:0:0);
	(RAD5 => RD30) = (0:0:0, 0:0:0);
	(RAD6 => RD30) = (0:0:0, 0:0:0);
	(RAD7 => RD30) = (0:0:0, 0:0:0);
	(RAD8 => RD30) = (0:0:0, 0:0:0);

	(RAD0 => RD31) = (0:0:0, 0:0:0);
	(RAD1 => RD31) = (0:0:0, 0:0:0);
	(RAD2 => RD31) = (0:0:0, 0:0:0);
	(RAD3 => RD31) = (0:0:0, 0:0:0);
	(RAD4 => RD31) = (0:0:0, 0:0:0);
	(RAD5 => RD31) = (0:0:0, 0:0:0);
	(RAD6 => RD31) = (0:0:0, 0:0:0);
	(RAD7 => RD31) = (0:0:0, 0:0:0);
	(RAD8 => RD31) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16KA_WX4_RX4(WCEN,WCLK,WCS0,WCS1,WE,RST,
                    WD0,WD1,WD2,WD3,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,
                    RD0,RD1,RD2,RD3
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RST;
input  WD0,WD1,WD2,WD3;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11;

output  RD0,RD1,RD2,RD3;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [11:0] wad;
wire [11:0]  rad;
wire [1:0]  wcs;
wire [3:0]  wd;
wire [3:0] rd;
reg notifier;

assign wad = {WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd  = {WD3,WD2,WD1,WD0};
//assign {RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);

defparam RAM_U0.WADDR_WIDTH=12;
defparam RAM_U0.WDATA_WIDTH=4;
defparam RAM_U0.RADDR_WIDTH=12;
defparam RAM_U0.RDATA_WIDTH=4;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1); 

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);

	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);
	(RAD9 => RD0) = (0:0:0, 0:0:0);
	(RAD10 => RD0) = (0:0:0, 0:0:0);
	(RAD11 => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD1) = (0:0:0, 0:0:0);
	(RAD1 => RD1) = (0:0:0, 0:0:0);
	(RAD2 => RD1) = (0:0:0, 0:0:0);
	(RAD3 => RD1) = (0:0:0, 0:0:0);
	(RAD4 => RD1) = (0:0:0, 0:0:0);
	(RAD5 => RD1) = (0:0:0, 0:0:0);
	(RAD6 => RD1) = (0:0:0, 0:0:0);
	(RAD7 => RD1) = (0:0:0, 0:0:0);
	(RAD8 => RD1) = (0:0:0, 0:0:0);
	(RAD9 => RD1) = (0:0:0, 0:0:0);
	(RAD10 => RD1) = (0:0:0, 0:0:0);
	(RAD11 => RD1) = (0:0:0, 0:0:0);

	(RAD0 => RD2) = (0:0:0, 0:0:0);
	(RAD1 => RD2) = (0:0:0, 0:0:0);
	(RAD2 => RD2) = (0:0:0, 0:0:0);
	(RAD3 => RD2) = (0:0:0, 0:0:0);
	(RAD4 => RD2) = (0:0:0, 0:0:0);
	(RAD5 => RD2) = (0:0:0, 0:0:0);
	(RAD6 => RD2) = (0:0:0, 0:0:0);
	(RAD7 => RD2) = (0:0:0, 0:0:0);
	(RAD8 => RD2) = (0:0:0, 0:0:0);
	(RAD9 => RD2) = (0:0:0, 0:0:0);
	(RAD10 => RD2) = (0:0:0, 0:0:0);
	(RAD11 => RD2) = (0:0:0, 0:0:0);

	(RAD0 => RD3) = (0:0:0, 0:0:0);
	(RAD1 => RD3) = (0:0:0, 0:0:0);
	(RAD2 => RD3) = (0:0:0, 0:0:0);
	(RAD3 => RD3) = (0:0:0, 0:0:0);
	(RAD4 => RD3) = (0:0:0, 0:0:0);
	(RAD5 => RD3) = (0:0:0, 0:0:0);
	(RAD6 => RD3) = (0:0:0, 0:0:0);
	(RAD7 => RD3) = (0:0:0, 0:0:0);
	(RAD8 => RD3) = (0:0:0, 0:0:0);
	(RAD9 => RD3) = (0:0:0, 0:0:0);
	(RAD10 => RD3) = (0:0:0, 0:0:0);
	(RAD11 => RD3) = (0:0:0, 0:0:0);

endspecify

endmodule
`endcelldefine
`celldefine
module RAMB16KA_WX4_RX8(WCEN,WCLK,WCS0,WCS1,WE,RST,
                    WD0,WD1,WD2,WD3,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RST;
input  WD0,WD1,WD2,WD3;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [11:0] wad;
wire [10:0]  rad;
wire [1:0]  wcs;
wire [3:0]  wd;
wire [7:0] rd;
reg notifier;

assign wad = {WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd  = {WD3,WD2,WD1,WD0};
//assign {RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);

defparam RAM_U0.WADDR_WIDTH=12;
defparam RAM_U0.WDATA_WIDTH=4;
defparam RAM_U0.RADDR_WIDTH=11;
defparam RAM_U0.RDATA_WIDTH=8;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));


specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1); 

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);

	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);
	(RAD9 => RD0) = (0:0:0, 0:0:0);
	(RAD10 => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD1) = (0:0:0, 0:0:0);
	(RAD1 => RD1) = (0:0:0, 0:0:0);
	(RAD2 => RD1) = (0:0:0, 0:0:0);
	(RAD3 => RD1) = (0:0:0, 0:0:0);
	(RAD4 => RD1) = (0:0:0, 0:0:0);
	(RAD5 => RD1) = (0:0:0, 0:0:0);
	(RAD6 => RD1) = (0:0:0, 0:0:0);
	(RAD7 => RD1) = (0:0:0, 0:0:0);
	(RAD8 => RD1) = (0:0:0, 0:0:0);
	(RAD9 => RD1) = (0:0:0, 0:0:0);
	(RAD10 => RD1) = (0:0:0, 0:0:0);

	(RAD0 => RD2) = (0:0:0, 0:0:0);
	(RAD1 => RD2) = (0:0:0, 0:0:0);
	(RAD2 => RD2) = (0:0:0, 0:0:0);
	(RAD3 => RD2) = (0:0:0, 0:0:0);
	(RAD4 => RD2) = (0:0:0, 0:0:0);
	(RAD5 => RD2) = (0:0:0, 0:0:0);
	(RAD6 => RD2) = (0:0:0, 0:0:0);
	(RAD7 => RD2) = (0:0:0, 0:0:0);
	(RAD8 => RD2) = (0:0:0, 0:0:0);
	(RAD9 => RD2) = (0:0:0, 0:0:0);
	(RAD10 => RD2) = (0:0:0, 0:0:0);

	(RAD0 => RD3) = (0:0:0, 0:0:0);
	(RAD1 => RD3) = (0:0:0, 0:0:0);
	(RAD2 => RD3) = (0:0:0, 0:0:0);
	(RAD3 => RD3) = (0:0:0, 0:0:0);
	(RAD4 => RD3) = (0:0:0, 0:0:0);
	(RAD5 => RD3) = (0:0:0, 0:0:0);
	(RAD6 => RD3) = (0:0:0, 0:0:0);
	(RAD7 => RD3) = (0:0:0, 0:0:0);
	(RAD8 => RD3) = (0:0:0, 0:0:0);
	(RAD9 => RD3) = (0:0:0, 0:0:0);
	(RAD10 => RD3) = (0:0:0, 0:0:0);

	(RAD0 => RD4) = (0:0:0, 0:0:0);
	(RAD1 => RD4) = (0:0:0, 0:0:0);
	(RAD2 => RD4) = (0:0:0, 0:0:0);
	(RAD3 => RD4) = (0:0:0, 0:0:0);
	(RAD4 => RD4) = (0:0:0, 0:0:0);
	(RAD5 => RD4) = (0:0:0, 0:0:0);
	(RAD6 => RD4) = (0:0:0, 0:0:0);
	(RAD7 => RD4) = (0:0:0, 0:0:0);
	(RAD8 => RD4) = (0:0:0, 0:0:0);
	(RAD9 => RD4) = (0:0:0, 0:0:0);
	(RAD10 => RD4) = (0:0:0, 0:0:0);

	(RAD0 => RD5) = (0:0:0, 0:0:0);
	(RAD1 => RD5) = (0:0:0, 0:0:0);
	(RAD2 => RD5) = (0:0:0, 0:0:0);
	(RAD3 => RD5) = (0:0:0, 0:0:0);
	(RAD4 => RD5) = (0:0:0, 0:0:0);
	(RAD5 => RD5) = (0:0:0, 0:0:0);
	(RAD6 => RD5) = (0:0:0, 0:0:0);
	(RAD7 => RD5) = (0:0:0, 0:0:0);
	(RAD8 => RD5) = (0:0:0, 0:0:0);
	(RAD9 => RD5) = (0:0:0, 0:0:0);
	(RAD10 => RD5) = (0:0:0, 0:0:0);

	(RAD0 => RD6) = (0:0:0, 0:0:0);
	(RAD1 => RD6) = (0:0:0, 0:0:0);
	(RAD2 => RD6) = (0:0:0, 0:0:0);
	(RAD3 => RD6) = (0:0:0, 0:0:0);
	(RAD4 => RD6) = (0:0:0, 0:0:0);
	(RAD5 => RD6) = (0:0:0, 0:0:0);
	(RAD6 => RD6) = (0:0:0, 0:0:0);
	(RAD7 => RD6) = (0:0:0, 0:0:0);
	(RAD8 => RD6) = (0:0:0, 0:0:0);
	(RAD9 => RD6) = (0:0:0, 0:0:0);
	(RAD10 => RD6) = (0:0:0, 0:0:0);

	(RAD0 => RD7) = (0:0:0, 0:0:0);
	(RAD1 => RD7) = (0:0:0, 0:0:0);
	(RAD2 => RD7) = (0:0:0, 0:0:0);
	(RAD3 => RD7) = (0:0:0, 0:0:0);
	(RAD4 => RD7) = (0:0:0, 0:0:0);
	(RAD5 => RD7) = (0:0:0, 0:0:0);
	(RAD6 => RD7) = (0:0:0, 0:0:0);
	(RAD7 => RD7) = (0:0:0, 0:0:0);
	(RAD8 => RD7) = (0:0:0, 0:0:0);
	(RAD9 => RD7) = (0:0:0, 0:0:0);
	(RAD10 => RD7) = (0:0:0, 0:0:0);

endspecify

endmodule
`endcelldefine
`celldefine
module RAMB16KA_WX4_RX16(WCEN,WCLK,WCS0,WCS1,WE,RST,
                    WD0,WD1,WD2,WD3,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,
                    RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RST;
input  WD0,WD1,WD2,WD3;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7;
output  RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [11:0] wad;
wire [9:0]  rad;
wire [1:0]  wcs;
wire [3:0]  wd;
wire [15:0] rd;
reg notifier;

assign wad = {WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd = {WD3,WD2,WD1,WD0};
//assign {RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} =rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
buf INSXQ8 (RD8,rd[8]);
buf INSXQ9 (RD9,rd[9]);

buf INSXQ10 (RD10,rd[10]);
buf INSXQ11 (RD11,rd[11]);
buf INSXQ12 (RD12,rd[12]);
buf INSXQ13 (RD13,rd[13]);
buf INSXQ14 (RD14,rd[14]);
buf INSXQ15 (RD15,rd[15]);

defparam RAM_U0.WADDR_WIDTH=12;
defparam RAM_U0.WDATA_WIDTH=4;
defparam RAM_U0.RADDR_WIDTH=10;
defparam RAM_U0.RDATA_WIDTH=16;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));


specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1); 

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);
	(RST => RD8) = (0:0:0, 0:0:0);
	(RST => RD9) = (0:0:0, 0:0:0);
	(RST => RD10) = (0:0:0, 0:0:0);
	(RST => RD11) = (0:0:0, 0:0:0);
	(RST => RD12) = (0:0:0, 0:0:0);
	(RST => RD13) = (0:0:0, 0:0:0);
	(RST => RD14) = (0:0:0, 0:0:0);
	(RST => RD15) = (0:0:0, 0:0:0);

	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);
	(RAD9 => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD1) = (0:0:0, 0:0:0);
	(RAD1 => RD1) = (0:0:0, 0:0:0);
	(RAD2 => RD1) = (0:0:0, 0:0:0);
	(RAD3 => RD1) = (0:0:0, 0:0:0);
	(RAD4 => RD1) = (0:0:0, 0:0:0);
	(RAD5 => RD1) = (0:0:0, 0:0:0);
	(RAD6 => RD1) = (0:0:0, 0:0:0);
	(RAD7 => RD1) = (0:0:0, 0:0:0);
	(RAD8 => RD1) = (0:0:0, 0:0:0);
	(RAD9 => RD1) = (0:0:0, 0:0:0);

	(RAD0 => RD2) = (0:0:0, 0:0:0);
	(RAD1 => RD2) = (0:0:0, 0:0:0);
	(RAD2 => RD2) = (0:0:0, 0:0:0);
	(RAD3 => RD2) = (0:0:0, 0:0:0);
	(RAD4 => RD2) = (0:0:0, 0:0:0);
	(RAD5 => RD2) = (0:0:0, 0:0:0);
	(RAD6 => RD2) = (0:0:0, 0:0:0);
	(RAD7 => RD2) = (0:0:0, 0:0:0);
	(RAD8 => RD2) = (0:0:0, 0:0:0);
	(RAD9 => RD2) = (0:0:0, 0:0:0);

	(RAD0 => RD3) = (0:0:0, 0:0:0);
	(RAD1 => RD3) = (0:0:0, 0:0:0);
	(RAD2 => RD3) = (0:0:0, 0:0:0);
	(RAD3 => RD3) = (0:0:0, 0:0:0);
	(RAD4 => RD3) = (0:0:0, 0:0:0);
	(RAD5 => RD3) = (0:0:0, 0:0:0);
	(RAD6 => RD3) = (0:0:0, 0:0:0);
	(RAD7 => RD3) = (0:0:0, 0:0:0);
	(RAD8 => RD3) = (0:0:0, 0:0:0);
	(RAD9 => RD3) = (0:0:0, 0:0:0);

	(RAD0 => RD4) = (0:0:0, 0:0:0);
	(RAD1 => RD4) = (0:0:0, 0:0:0);
	(RAD2 => RD4) = (0:0:0, 0:0:0);
	(RAD3 => RD4) = (0:0:0, 0:0:0);
	(RAD4 => RD4) = (0:0:0, 0:0:0);
	(RAD5 => RD4) = (0:0:0, 0:0:0);
	(RAD6 => RD4) = (0:0:0, 0:0:0);
	(RAD7 => RD4) = (0:0:0, 0:0:0);
	(RAD8 => RD4) = (0:0:0, 0:0:0);
	(RAD9 => RD4) = (0:0:0, 0:0:0);

	(RAD0 => RD5) = (0:0:0, 0:0:0);
	(RAD1 => RD5) = (0:0:0, 0:0:0);
	(RAD2 => RD5) = (0:0:0, 0:0:0);
	(RAD3 => RD5) = (0:0:0, 0:0:0);
	(RAD4 => RD5) = (0:0:0, 0:0:0);
	(RAD5 => RD5) = (0:0:0, 0:0:0);
	(RAD6 => RD5) = (0:0:0, 0:0:0);
	(RAD7 => RD5) = (0:0:0, 0:0:0);
	(RAD8 => RD5) = (0:0:0, 0:0:0);
	(RAD9 => RD5) = (0:0:0, 0:0:0);

	(RAD0 => RD6) = (0:0:0, 0:0:0);
	(RAD1 => RD6) = (0:0:0, 0:0:0);
	(RAD2 => RD6) = (0:0:0, 0:0:0);
	(RAD3 => RD6) = (0:0:0, 0:0:0);
	(RAD4 => RD6) = (0:0:0, 0:0:0);
	(RAD5 => RD6) = (0:0:0, 0:0:0);
	(RAD6 => RD6) = (0:0:0, 0:0:0);
	(RAD7 => RD6) = (0:0:0, 0:0:0);
	(RAD8 => RD6) = (0:0:0, 0:0:0);
	(RAD9 => RD6) = (0:0:0, 0:0:0);

	(RAD0 => RD7) = (0:0:0, 0:0:0);
	(RAD1 => RD7) = (0:0:0, 0:0:0);
	(RAD2 => RD7) = (0:0:0, 0:0:0);
	(RAD3 => RD7) = (0:0:0, 0:0:0);
	(RAD4 => RD7) = (0:0:0, 0:0:0);
	(RAD5 => RD7) = (0:0:0, 0:0:0);
	(RAD6 => RD7) = (0:0:0, 0:0:0);
	(RAD7 => RD7) = (0:0:0, 0:0:0);
	(RAD8 => RD7) = (0:0:0, 0:0:0);
	(RAD9 => RD7) = (0:0:0, 0:0:0);

	(RAD0 => RD8) = (0:0:0, 0:0:0);
	(RAD1 => RD8) = (0:0:0, 0:0:0);
	(RAD2 => RD8) = (0:0:0, 0:0:0);
	(RAD3 => RD8) = (0:0:0, 0:0:0);
	(RAD4 => RD8) = (0:0:0, 0:0:0);
	(RAD5 => RD8) = (0:0:0, 0:0:0);
	(RAD6 => RD8) = (0:0:0, 0:0:0);
	(RAD7 => RD8) = (0:0:0, 0:0:0);
	(RAD8 => RD8) = (0:0:0, 0:0:0);
	(RAD9 => RD8) = (0:0:0, 0:0:0);

	(RAD0 => RD9) = (0:0:0, 0:0:0);
	(RAD1 => RD9) = (0:0:0, 0:0:0);
	(RAD2 => RD9) = (0:0:0, 0:0:0);
	(RAD3 => RD9) = (0:0:0, 0:0:0);
	(RAD4 => RD9) = (0:0:0, 0:0:0);
	(RAD5 => RD9) = (0:0:0, 0:0:0);
	(RAD6 => RD9) = (0:0:0, 0:0:0);
	(RAD7 => RD9) = (0:0:0, 0:0:0);
	(RAD8 => RD9) = (0:0:0, 0:0:0);
	(RAD9 => RD9) = (0:0:0, 0:0:0);

	(RAD0 => RD10) = (0:0:0, 0:0:0);
	(RAD1 => RD10) = (0:0:0, 0:0:0);
	(RAD2 => RD10) = (0:0:0, 0:0:0);
	(RAD3 => RD10) = (0:0:0, 0:0:0);
	(RAD4 => RD10) = (0:0:0, 0:0:0);
	(RAD5 => RD10) = (0:0:0, 0:0:0);
	(RAD6 => RD10) = (0:0:0, 0:0:0);
	(RAD7 => RD10) = (0:0:0, 0:0:0);
	(RAD8 => RD10) = (0:0:0, 0:0:0);
	(RAD9 => RD10) = (0:0:0, 0:0:0);

	(RAD0 => RD11) = (0:0:0, 0:0:0);
	(RAD1 => RD11) = (0:0:0, 0:0:0);
	(RAD2 => RD11) = (0:0:0, 0:0:0);
	(RAD3 => RD11) = (0:0:0, 0:0:0);
	(RAD4 => RD11) = (0:0:0, 0:0:0);
	(RAD5 => RD11) = (0:0:0, 0:0:0);
	(RAD6 => RD11) = (0:0:0, 0:0:0);
	(RAD7 => RD11) = (0:0:0, 0:0:0);
	(RAD8 => RD11) = (0:0:0, 0:0:0);
	(RAD9 => RD11) = (0:0:0, 0:0:0);

	(RAD0 => RD12) = (0:0:0, 0:0:0);
	(RAD1 => RD12) = (0:0:0, 0:0:0);
	(RAD2 => RD12) = (0:0:0, 0:0:0);
	(RAD3 => RD12) = (0:0:0, 0:0:0);
	(RAD4 => RD12) = (0:0:0, 0:0:0);
	(RAD5 => RD12) = (0:0:0, 0:0:0);
	(RAD6 => RD12) = (0:0:0, 0:0:0);
	(RAD7 => RD12) = (0:0:0, 0:0:0);
	(RAD8 => RD12) = (0:0:0, 0:0:0);
	(RAD9 => RD12) = (0:0:0, 0:0:0);

	(RAD0 => RD13) = (0:0:0, 0:0:0);
	(RAD1 => RD13) = (0:0:0, 0:0:0);
	(RAD2 => RD13) = (0:0:0, 0:0:0);
	(RAD3 => RD13) = (0:0:0, 0:0:0);
	(RAD4 => RD13) = (0:0:0, 0:0:0);
	(RAD5 => RD13) = (0:0:0, 0:0:0);
	(RAD6 => RD13) = (0:0:0, 0:0:0);
	(RAD7 => RD13) = (0:0:0, 0:0:0);
	(RAD8 => RD13) = (0:0:0, 0:0:0);
	(RAD9 => RD13) = (0:0:0, 0:0:0);

	(RAD0 => RD14) = (0:0:0, 0:0:0);
	(RAD1 => RD14) = (0:0:0, 0:0:0);
	(RAD2 => RD14) = (0:0:0, 0:0:0);
	(RAD3 => RD14) = (0:0:0, 0:0:0);
	(RAD4 => RD14) = (0:0:0, 0:0:0);
	(RAD5 => RD14) = (0:0:0, 0:0:0);
	(RAD6 => RD14) = (0:0:0, 0:0:0);
	(RAD7 => RD14) = (0:0:0, 0:0:0);
	(RAD8 => RD14) = (0:0:0, 0:0:0);
	(RAD9 => RD14) = (0:0:0, 0:0:0);

	(RAD0 => RD15) = (0:0:0, 0:0:0);
	(RAD1 => RD15) = (0:0:0, 0:0:0);
	(RAD2 => RD15) = (0:0:0, 0:0:0);
	(RAD3 => RD15) = (0:0:0, 0:0:0);
	(RAD4 => RD15) = (0:0:0, 0:0:0);
	(RAD5 => RD15) = (0:0:0, 0:0:0);
	(RAD6 => RD15) = (0:0:0, 0:0:0);
	(RAD7 => RD15) = (0:0:0, 0:0:0);
	(RAD8 => RD15) = (0:0:0, 0:0:0);
	(RAD9 => RD15) = (0:0:0, 0:0:0);

endspecify

endmodule
`endcelldefine
`celldefine
module RAMB16KA_WX4_RX32(WCEN,WCLK,WCS0,WCS1,WE,RST,
                    WD0,WD1,WD2,WD3,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,
                    RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15,
		    RD16,RD17,RD18,RD19,RD20,RD21,RD22,RD23,RD24,RD25,RD26,RD27,RD28,RD29,RD30,RD31
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RST;
input  WD0,WD1,WD2,WD3;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7;
output  RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15;
output  RD16,RD17,RD18,RD19,RD20,RD21,RD22,RD23,RD24,RD25,RD26,RD27,RD28,RD29,RD30,RD31;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [11:0] wad;
wire [8:0]  rad;
wire [1:0]  wcs;
wire [3:0]  wd;
wire [31:0] rd;
reg notifier;

assign wad = {WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd = {WD3,WD2,WD1,WD0};
//assign {RD31,RD30,RD29,RD28,RD27,RD26,RD25,RD24,RD23,RD22,RD21,RD20,RD19,RD18,RD17,RD16,RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
buf INSXQ8 (RD8,rd[8]);
buf INSXQ9 (RD9,rd[9]);

buf INSXQ10 (RD10,rd[10]);
buf INSXQ11 (RD11,rd[11]);
buf INSXQ12 (RD12,rd[12]);
buf INSXQ13 (RD13,rd[13]);
buf INSXQ14 (RD14,rd[14]);
buf INSXQ15 (RD15,rd[15]);
buf INSXQ16 (RD16,rd[16]);
buf INSXQ17 (RD17,rd[17]);
buf INSXQ18 (RD18,rd[18]);
buf INSXQ19 (RD19,rd[19]);

buf INSXQ20 (RD20,rd[20]);
buf INSXQ21 (RD21,rd[21]);
buf INSXQ22 (RD22,rd[22]);
buf INSXQ23 (RD23,rd[23]);
buf INSXQ24 (RD24,rd[24]);
buf INSXQ25 (RD25,rd[25]);
buf INSXQ26 (RD26,rd[26]);
buf INSXQ27 (RD27,rd[27]);
buf INSXQ28 (RD28,rd[28]);
buf INSXQ29 (RD29,rd[29]);

buf INSXQ30 (RD30,rd[30]);
buf INSXQ31 (RD31,rd[31]);

defparam RAM_U0.WADDR_WIDTH=12;
defparam RAM_U0.WDATA_WIDTH=4;
defparam RAM_U0.RADDR_WIDTH=9;
defparam RAM_U0.RDATA_WIDTH=32;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));


specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1); 

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);
	(RST => RD8) = (0:0:0, 0:0:0);
	(RST => RD9) = (0:0:0, 0:0:0);
	(RST => RD10) = (0:0:0, 0:0:0);
	(RST => RD11) = (0:0:0, 0:0:0);
	(RST => RD12) = (0:0:0, 0:0:0);
	(RST => RD13) = (0:0:0, 0:0:0);
	(RST => RD14) = (0:0:0, 0:0:0);
	(RST => RD15) = (0:0:0, 0:0:0);
	(RST => RD16) = (0:0:0, 0:0:0);
	(RST => RD17) = (0:0:0, 0:0:0);
	(RST => RD18) = (0:0:0, 0:0:0);
	(RST => RD19) = (0:0:0, 0:0:0);
	(RST => RD20) = (0:0:0, 0:0:0);
	(RST => RD21) = (0:0:0, 0:0:0);
	(RST => RD22) = (0:0:0, 0:0:0);
	(RST => RD23) = (0:0:0, 0:0:0);
	(RST => RD24) = (0:0:0, 0:0:0);
	(RST => RD25) = (0:0:0, 0:0:0);
	(RST => RD26) = (0:0:0, 0:0:0);
	(RST => RD27) = (0:0:0, 0:0:0);
	(RST => RD28) = (0:0:0, 0:0:0);
	(RST => RD29) = (0:0:0, 0:0:0);
	(RST => RD30) = (0:0:0, 0:0:0);
	(RST => RD31) = (0:0:0, 0:0:0);

	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD1) = (0:0:0, 0:0:0);
	(RAD1 => RD1) = (0:0:0, 0:0:0);
	(RAD2 => RD1) = (0:0:0, 0:0:0);
	(RAD3 => RD1) = (0:0:0, 0:0:0);
	(RAD4 => RD1) = (0:0:0, 0:0:0);
	(RAD5 => RD1) = (0:0:0, 0:0:0);
	(RAD6 => RD1) = (0:0:0, 0:0:0);
	(RAD7 => RD1) = (0:0:0, 0:0:0);
	(RAD8 => RD1) = (0:0:0, 0:0:0);

	(RAD0 => RD2) = (0:0:0, 0:0:0);
	(RAD1 => RD2) = (0:0:0, 0:0:0);
	(RAD2 => RD2) = (0:0:0, 0:0:0);
	(RAD3 => RD2) = (0:0:0, 0:0:0);
	(RAD4 => RD2) = (0:0:0, 0:0:0);
	(RAD5 => RD2) = (0:0:0, 0:0:0);
	(RAD6 => RD2) = (0:0:0, 0:0:0);
	(RAD7 => RD2) = (0:0:0, 0:0:0);
	(RAD8 => RD2) = (0:0:0, 0:0:0);

	(RAD0 => RD3) = (0:0:0, 0:0:0);
	(RAD1 => RD3) = (0:0:0, 0:0:0);
	(RAD2 => RD3) = (0:0:0, 0:0:0);
	(RAD3 => RD3) = (0:0:0, 0:0:0);
	(RAD4 => RD3) = (0:0:0, 0:0:0);
	(RAD5 => RD3) = (0:0:0, 0:0:0);
	(RAD6 => RD3) = (0:0:0, 0:0:0);
	(RAD7 => RD3) = (0:0:0, 0:0:0);
	(RAD8 => RD3) = (0:0:0, 0:0:0);

	(RAD0 => RD4) = (0:0:0, 0:0:0);
	(RAD1 => RD4) = (0:0:0, 0:0:0);
	(RAD2 => RD4) = (0:0:0, 0:0:0);
	(RAD3 => RD4) = (0:0:0, 0:0:0);
	(RAD4 => RD4) = (0:0:0, 0:0:0);
	(RAD5 => RD4) = (0:0:0, 0:0:0);
	(RAD6 => RD4) = (0:0:0, 0:0:0);
	(RAD7 => RD4) = (0:0:0, 0:0:0);
	(RAD8 => RD4) = (0:0:0, 0:0:0);

	(RAD0 => RD5) = (0:0:0, 0:0:0);
	(RAD1 => RD5) = (0:0:0, 0:0:0);
	(RAD2 => RD5) = (0:0:0, 0:0:0);
	(RAD3 => RD5) = (0:0:0, 0:0:0);
	(RAD4 => RD5) = (0:0:0, 0:0:0);
	(RAD5 => RD5) = (0:0:0, 0:0:0);
	(RAD6 => RD5) = (0:0:0, 0:0:0);
	(RAD7 => RD5) = (0:0:0, 0:0:0);
	(RAD8 => RD5) = (0:0:0, 0:0:0);

	(RAD0 => RD6) = (0:0:0, 0:0:0);
	(RAD1 => RD6) = (0:0:0, 0:0:0);
	(RAD2 => RD6) = (0:0:0, 0:0:0);
	(RAD3 => RD6) = (0:0:0, 0:0:0);
	(RAD4 => RD6) = (0:0:0, 0:0:0);
	(RAD5 => RD6) = (0:0:0, 0:0:0);
	(RAD6 => RD6) = (0:0:0, 0:0:0);
	(RAD7 => RD6) = (0:0:0, 0:0:0);
	(RAD8 => RD6) = (0:0:0, 0:0:0);

	(RAD0 => RD7) = (0:0:0, 0:0:0);
	(RAD1 => RD7) = (0:0:0, 0:0:0);
	(RAD2 => RD7) = (0:0:0, 0:0:0);
	(RAD3 => RD7) = (0:0:0, 0:0:0);
	(RAD4 => RD7) = (0:0:0, 0:0:0);
	(RAD5 => RD7) = (0:0:0, 0:0:0);
	(RAD6 => RD7) = (0:0:0, 0:0:0);
	(RAD7 => RD7) = (0:0:0, 0:0:0);
	(RAD8 => RD7) = (0:0:0, 0:0:0);

	(RAD0 => RD8) = (0:0:0, 0:0:0);
	(RAD1 => RD8) = (0:0:0, 0:0:0);
	(RAD2 => RD8) = (0:0:0, 0:0:0);
	(RAD3 => RD8) = (0:0:0, 0:0:0);
	(RAD4 => RD8) = (0:0:0, 0:0:0);
	(RAD5 => RD8) = (0:0:0, 0:0:0);
	(RAD6 => RD8) = (0:0:0, 0:0:0);
	(RAD7 => RD8) = (0:0:0, 0:0:0);
	(RAD8 => RD8) = (0:0:0, 0:0:0);

	(RAD0 => RD9) = (0:0:0, 0:0:0);
	(RAD1 => RD9) = (0:0:0, 0:0:0);
	(RAD2 => RD9) = (0:0:0, 0:0:0);
	(RAD3 => RD9) = (0:0:0, 0:0:0);
	(RAD4 => RD9) = (0:0:0, 0:0:0);
	(RAD5 => RD9) = (0:0:0, 0:0:0);
	(RAD6 => RD9) = (0:0:0, 0:0:0);
	(RAD7 => RD9) = (0:0:0, 0:0:0);
	(RAD8 => RD9) = (0:0:0, 0:0:0);

	(RAD0 => RD10) = (0:0:0, 0:0:0);
	(RAD1 => RD10) = (0:0:0, 0:0:0);
	(RAD2 => RD10) = (0:0:0, 0:0:0);
	(RAD3 => RD10) = (0:0:0, 0:0:0);
	(RAD4 => RD10) = (0:0:0, 0:0:0);
	(RAD5 => RD10) = (0:0:0, 0:0:0);
	(RAD6 => RD10) = (0:0:0, 0:0:0);
	(RAD7 => RD10) = (0:0:0, 0:0:0);
	(RAD8 => RD10) = (0:0:0, 0:0:0);

	(RAD0 => RD11) = (0:0:0, 0:0:0);
	(RAD1 => RD11) = (0:0:0, 0:0:0);
	(RAD2 => RD11) = (0:0:0, 0:0:0);
	(RAD3 => RD11) = (0:0:0, 0:0:0);
	(RAD4 => RD11) = (0:0:0, 0:0:0);
	(RAD5 => RD11) = (0:0:0, 0:0:0);
	(RAD6 => RD11) = (0:0:0, 0:0:0);
	(RAD7 => RD11) = (0:0:0, 0:0:0);
	(RAD8 => RD11) = (0:0:0, 0:0:0);

	(RAD0 => RD12) = (0:0:0, 0:0:0);
	(RAD1 => RD12) = (0:0:0, 0:0:0);
	(RAD2 => RD12) = (0:0:0, 0:0:0);
	(RAD3 => RD12) = (0:0:0, 0:0:0);
	(RAD4 => RD12) = (0:0:0, 0:0:0);
	(RAD5 => RD12) = (0:0:0, 0:0:0);
	(RAD6 => RD12) = (0:0:0, 0:0:0);
	(RAD7 => RD12) = (0:0:0, 0:0:0);
	(RAD8 => RD12) = (0:0:0, 0:0:0);

	(RAD0 => RD13) = (0:0:0, 0:0:0);
	(RAD1 => RD13) = (0:0:0, 0:0:0);
	(RAD2 => RD13) = (0:0:0, 0:0:0);
	(RAD3 => RD13) = (0:0:0, 0:0:0);
	(RAD4 => RD13) = (0:0:0, 0:0:0);
	(RAD5 => RD13) = (0:0:0, 0:0:0);
	(RAD6 => RD13) = (0:0:0, 0:0:0);
	(RAD7 => RD13) = (0:0:0, 0:0:0);
	(RAD8 => RD13) = (0:0:0, 0:0:0);

	(RAD0 => RD14) = (0:0:0, 0:0:0);
	(RAD1 => RD14) = (0:0:0, 0:0:0);
	(RAD2 => RD14) = (0:0:0, 0:0:0);
	(RAD3 => RD14) = (0:0:0, 0:0:0);
	(RAD4 => RD14) = (0:0:0, 0:0:0);
	(RAD5 => RD14) = (0:0:0, 0:0:0);
	(RAD6 => RD14) = (0:0:0, 0:0:0);
	(RAD7 => RD14) = (0:0:0, 0:0:0);
	(RAD8 => RD14) = (0:0:0, 0:0:0);

	(RAD0 => RD15) = (0:0:0, 0:0:0);
	(RAD1 => RD15) = (0:0:0, 0:0:0);
	(RAD2 => RD15) = (0:0:0, 0:0:0);
	(RAD3 => RD15) = (0:0:0, 0:0:0);
	(RAD4 => RD15) = (0:0:0, 0:0:0);
	(RAD5 => RD15) = (0:0:0, 0:0:0);
	(RAD6 => RD15) = (0:0:0, 0:0:0);
	(RAD7 => RD15) = (0:0:0, 0:0:0);
	(RAD8 => RD15) = (0:0:0, 0:0:0);

	(RAD0 => RD16) = (0:0:0, 0:0:0);
	(RAD1 => RD16) = (0:0:0, 0:0:0);
	(RAD2 => RD16) = (0:0:0, 0:0:0);
	(RAD3 => RD16) = (0:0:0, 0:0:0);
	(RAD4 => RD16) = (0:0:0, 0:0:0);
	(RAD5 => RD16) = (0:0:0, 0:0:0);
	(RAD6 => RD16) = (0:0:0, 0:0:0);
	(RAD7 => RD16) = (0:0:0, 0:0:0);
	(RAD8 => RD16) = (0:0:0, 0:0:0);

	(RAD0 => RD17) = (0:0:0, 0:0:0);
	(RAD1 => RD17) = (0:0:0, 0:0:0);
	(RAD2 => RD17) = (0:0:0, 0:0:0);
	(RAD3 => RD17) = (0:0:0, 0:0:0);
	(RAD4 => RD17) = (0:0:0, 0:0:0);
	(RAD5 => RD17) = (0:0:0, 0:0:0);
	(RAD6 => RD17) = (0:0:0, 0:0:0);
	(RAD7 => RD17) = (0:0:0, 0:0:0);
	(RAD8 => RD17) = (0:0:0, 0:0:0);

	(RAD0 => RD18) = (0:0:0, 0:0:0);
	(RAD1 => RD18) = (0:0:0, 0:0:0);
	(RAD2 => RD18) = (0:0:0, 0:0:0);
	(RAD3 => RD18) = (0:0:0, 0:0:0);
	(RAD4 => RD18) = (0:0:0, 0:0:0);
	(RAD5 => RD18) = (0:0:0, 0:0:0);
	(RAD6 => RD18) = (0:0:0, 0:0:0);
	(RAD7 => RD18) = (0:0:0, 0:0:0);
	(RAD8 => RD18) = (0:0:0, 0:0:0);

	(RAD0 => RD19) = (0:0:0, 0:0:0);
	(RAD1 => RD19) = (0:0:0, 0:0:0);
	(RAD2 => RD19) = (0:0:0, 0:0:0);
	(RAD3 => RD19) = (0:0:0, 0:0:0);
	(RAD4 => RD19) = (0:0:0, 0:0:0);
	(RAD5 => RD19) = (0:0:0, 0:0:0);
	(RAD6 => RD19) = (0:0:0, 0:0:0);
	(RAD7 => RD19) = (0:0:0, 0:0:0);
	(RAD8 => RD19) = (0:0:0, 0:0:0);

	(RAD0 => RD20) = (0:0:0, 0:0:0);
	(RAD1 => RD20) = (0:0:0, 0:0:0);
	(RAD2 => RD20) = (0:0:0, 0:0:0);
	(RAD3 => RD20) = (0:0:0, 0:0:0);
	(RAD4 => RD20) = (0:0:0, 0:0:0);
	(RAD5 => RD20) = (0:0:0, 0:0:0);
	(RAD6 => RD20) = (0:0:0, 0:0:0);
	(RAD7 => RD20) = (0:0:0, 0:0:0);
	(RAD8 => RD20) = (0:0:0, 0:0:0);

	(RAD0 => RD21) = (0:0:0, 0:0:0);
	(RAD1 => RD21) = (0:0:0, 0:0:0);
	(RAD2 => RD21) = (0:0:0, 0:0:0);
	(RAD3 => RD21) = (0:0:0, 0:0:0);
	(RAD4 => RD21) = (0:0:0, 0:0:0);
	(RAD5 => RD21) = (0:0:0, 0:0:0);
	(RAD6 => RD21) = (0:0:0, 0:0:0);
	(RAD7 => RD21) = (0:0:0, 0:0:0);
	(RAD8 => RD21) = (0:0:0, 0:0:0);

	(RAD0 => RD22) = (0:0:0, 0:0:0);
	(RAD1 => RD22) = (0:0:0, 0:0:0);
	(RAD2 => RD22) = (0:0:0, 0:0:0);
	(RAD3 => RD22) = (0:0:0, 0:0:0);
	(RAD4 => RD22) = (0:0:0, 0:0:0);
	(RAD5 => RD22) = (0:0:0, 0:0:0);
	(RAD6 => RD22) = (0:0:0, 0:0:0);
	(RAD7 => RD22) = (0:0:0, 0:0:0);
	(RAD8 => RD22) = (0:0:0, 0:0:0);

	(RAD0 => RD23) = (0:0:0, 0:0:0);
	(RAD1 => RD23) = (0:0:0, 0:0:0);
	(RAD2 => RD23) = (0:0:0, 0:0:0);
	(RAD3 => RD23) = (0:0:0, 0:0:0);
	(RAD4 => RD23) = (0:0:0, 0:0:0);
	(RAD5 => RD23) = (0:0:0, 0:0:0);
	(RAD6 => RD23) = (0:0:0, 0:0:0);
	(RAD7 => RD23) = (0:0:0, 0:0:0);
	(RAD8 => RD23) = (0:0:0, 0:0:0);

	(RAD0 => RD24) = (0:0:0, 0:0:0);
	(RAD1 => RD24) = (0:0:0, 0:0:0);
	(RAD2 => RD24) = (0:0:0, 0:0:0);
	(RAD3 => RD24) = (0:0:0, 0:0:0);
	(RAD4 => RD24) = (0:0:0, 0:0:0);
	(RAD5 => RD24) = (0:0:0, 0:0:0);
	(RAD6 => RD24) = (0:0:0, 0:0:0);
	(RAD7 => RD24) = (0:0:0, 0:0:0);
	(RAD8 => RD24) = (0:0:0, 0:0:0);

	(RAD0 => RD25) = (0:0:0, 0:0:0);
	(RAD1 => RD25) = (0:0:0, 0:0:0);
	(RAD2 => RD25) = (0:0:0, 0:0:0);
	(RAD3 => RD25) = (0:0:0, 0:0:0);
	(RAD4 => RD25) = (0:0:0, 0:0:0);
	(RAD5 => RD25) = (0:0:0, 0:0:0);
	(RAD6 => RD25) = (0:0:0, 0:0:0);
	(RAD7 => RD25) = (0:0:0, 0:0:0);
	(RAD8 => RD25) = (0:0:0, 0:0:0);

	(RAD0 => RD26) = (0:0:0, 0:0:0);
	(RAD1 => RD26) = (0:0:0, 0:0:0);
	(RAD2 => RD26) = (0:0:0, 0:0:0);
	(RAD3 => RD26) = (0:0:0, 0:0:0);
	(RAD4 => RD26) = (0:0:0, 0:0:0);
	(RAD5 => RD26) = (0:0:0, 0:0:0);
	(RAD6 => RD26) = (0:0:0, 0:0:0);
	(RAD7 => RD26) = (0:0:0, 0:0:0);
	(RAD8 => RD26) = (0:0:0, 0:0:0);

	(RAD0 => RD27) = (0:0:0, 0:0:0);
	(RAD1 => RD27) = (0:0:0, 0:0:0);
	(RAD2 => RD27) = (0:0:0, 0:0:0);
	(RAD3 => RD27) = (0:0:0, 0:0:0);
	(RAD4 => RD27) = (0:0:0, 0:0:0);
	(RAD5 => RD27) = (0:0:0, 0:0:0);
	(RAD6 => RD27) = (0:0:0, 0:0:0);
	(RAD7 => RD27) = (0:0:0, 0:0:0);
	(RAD8 => RD27) = (0:0:0, 0:0:0);

	(RAD0 => RD28) = (0:0:0, 0:0:0);
	(RAD1 => RD28) = (0:0:0, 0:0:0);
	(RAD2 => RD28) = (0:0:0, 0:0:0);
	(RAD3 => RD28) = (0:0:0, 0:0:0);
	(RAD4 => RD28) = (0:0:0, 0:0:0);
	(RAD5 => RD28) = (0:0:0, 0:0:0);
	(RAD6 => RD28) = (0:0:0, 0:0:0);
	(RAD7 => RD28) = (0:0:0, 0:0:0);
	(RAD8 => RD28) = (0:0:0, 0:0:0);

	(RAD0 => RD29) = (0:0:0, 0:0:0);
	(RAD1 => RD29) = (0:0:0, 0:0:0);
	(RAD2 => RD29) = (0:0:0, 0:0:0);
	(RAD3 => RD29) = (0:0:0, 0:0:0);
	(RAD4 => RD29) = (0:0:0, 0:0:0);
	(RAD5 => RD29) = (0:0:0, 0:0:0);
	(RAD6 => RD29) = (0:0:0, 0:0:0);
	(RAD7 => RD29) = (0:0:0, 0:0:0);
	(RAD8 => RD29) = (0:0:0, 0:0:0);

	(RAD0 => RD30) = (0:0:0, 0:0:0);
	(RAD1 => RD30) = (0:0:0, 0:0:0);
	(RAD2 => RD30) = (0:0:0, 0:0:0);
	(RAD3 => RD30) = (0:0:0, 0:0:0);
	(RAD4 => RD30) = (0:0:0, 0:0:0);
	(RAD5 => RD30) = (0:0:0, 0:0:0);
	(RAD6 => RD30) = (0:0:0, 0:0:0);
	(RAD7 => RD30) = (0:0:0, 0:0:0);
	(RAD8 => RD30) = (0:0:0, 0:0:0);

	(RAD0 => RD31) = (0:0:0, 0:0:0);
	(RAD1 => RD31) = (0:0:0, 0:0:0);
	(RAD2 => RD31) = (0:0:0, 0:0:0);
	(RAD3 => RD31) = (0:0:0, 0:0:0);
	(RAD4 => RD31) = (0:0:0, 0:0:0);
	(RAD5 => RD31) = (0:0:0, 0:0:0);
	(RAD6 => RD31) = (0:0:0, 0:0:0);
	(RAD7 => RD31) = (0:0:0, 0:0:0);
	(RAD8 => RD31) = (0:0:0, 0:0:0);


endspecify

endmodule
`endcelldefine
`celldefine
module RAMB16KA_WX8_RX8(WCEN,WCLK,WCS0,WCS1,WE,RST,
                    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [10:0] wad;
wire [10:0]  rad;
wire [1:0]  wcs;
wire [7:0]  wd;
wire [7:0] rd;
reg notifier;

assign wad = {WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd  = {WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);

defparam RAM_U0.WADDR_WIDTH=11;
defparam RAM_U0.WDATA_WIDTH=8;
defparam RAM_U0.RADDR_WIDTH=11;
defparam RAM_U0.RDATA_WIDTH=8;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1); 

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);

	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);
	(RAD9 => RD0) = (0:0:0, 0:0:0);
	(RAD10 => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD1) = (0:0:0, 0:0:0);
	(RAD1 => RD1) = (0:0:0, 0:0:0);
	(RAD2 => RD1) = (0:0:0, 0:0:0);
	(RAD3 => RD1) = (0:0:0, 0:0:0);
	(RAD4 => RD1) = (0:0:0, 0:0:0);
	(RAD5 => RD1) = (0:0:0, 0:0:0);
	(RAD6 => RD1) = (0:0:0, 0:0:0);
	(RAD7 => RD1) = (0:0:0, 0:0:0);
	(RAD8 => RD1) = (0:0:0, 0:0:0);
	(RAD9 => RD1) = (0:0:0, 0:0:0);
	(RAD10 => RD1) = (0:0:0, 0:0:0);

	(RAD0 => RD2) = (0:0:0, 0:0:0);
	(RAD1 => RD2) = (0:0:0, 0:0:0);
	(RAD2 => RD2) = (0:0:0, 0:0:0);
	(RAD3 => RD2) = (0:0:0, 0:0:0);
	(RAD4 => RD2) = (0:0:0, 0:0:0);
	(RAD5 => RD2) = (0:0:0, 0:0:0);
	(RAD6 => RD2) = (0:0:0, 0:0:0);
	(RAD7 => RD2) = (0:0:0, 0:0:0);
	(RAD8 => RD2) = (0:0:0, 0:0:0);
	(RAD9 => RD2) = (0:0:0, 0:0:0);
	(RAD10 => RD2) = (0:0:0, 0:0:0);

	(RAD0 => RD3) = (0:0:0, 0:0:0);
	(RAD1 => RD3) = (0:0:0, 0:0:0);
	(RAD2 => RD3) = (0:0:0, 0:0:0);
	(RAD3 => RD3) = (0:0:0, 0:0:0);
	(RAD4 => RD3) = (0:0:0, 0:0:0);
	(RAD5 => RD3) = (0:0:0, 0:0:0);
	(RAD6 => RD3) = (0:0:0, 0:0:0);
	(RAD7 => RD3) = (0:0:0, 0:0:0);
	(RAD8 => RD3) = (0:0:0, 0:0:0);
	(RAD9 => RD3) = (0:0:0, 0:0:0);
	(RAD10 => RD3) = (0:0:0, 0:0:0);

	(RAD0 => RD4) = (0:0:0, 0:0:0);
	(RAD1 => RD4) = (0:0:0, 0:0:0);
	(RAD2 => RD4) = (0:0:0, 0:0:0);
	(RAD3 => RD4) = (0:0:0, 0:0:0);
	(RAD4 => RD4) = (0:0:0, 0:0:0);
	(RAD5 => RD4) = (0:0:0, 0:0:0);
	(RAD6 => RD4) = (0:0:0, 0:0:0);
	(RAD7 => RD4) = (0:0:0, 0:0:0);
	(RAD8 => RD4) = (0:0:0, 0:0:0);
	(RAD9 => RD4) = (0:0:0, 0:0:0);
	(RAD10 => RD4) = (0:0:0, 0:0:0);

	(RAD0 => RD5) = (0:0:0, 0:0:0);
	(RAD1 => RD5) = (0:0:0, 0:0:0);
	(RAD2 => RD5) = (0:0:0, 0:0:0);
	(RAD3 => RD5) = (0:0:0, 0:0:0);
	(RAD4 => RD5) = (0:0:0, 0:0:0);
	(RAD5 => RD5) = (0:0:0, 0:0:0);
	(RAD6 => RD5) = (0:0:0, 0:0:0);
	(RAD7 => RD5) = (0:0:0, 0:0:0);
	(RAD8 => RD5) = (0:0:0, 0:0:0);
	(RAD9 => RD5) = (0:0:0, 0:0:0);
	(RAD10 => RD5) = (0:0:0, 0:0:0);

	(RAD0 => RD6) = (0:0:0, 0:0:0);
	(RAD1 => RD6) = (0:0:0, 0:0:0);
	(RAD2 => RD6) = (0:0:0, 0:0:0);
	(RAD3 => RD6) = (0:0:0, 0:0:0);
	(RAD4 => RD6) = (0:0:0, 0:0:0);
	(RAD5 => RD6) = (0:0:0, 0:0:0);
	(RAD6 => RD6) = (0:0:0, 0:0:0);
	(RAD7 => RD6) = (0:0:0, 0:0:0);
	(RAD8 => RD6) = (0:0:0, 0:0:0);
	(RAD9 => RD6) = (0:0:0, 0:0:0);
	(RAD10 => RD6) = (0:0:0, 0:0:0);

	(RAD0 => RD7) = (0:0:0, 0:0:0);
	(RAD1 => RD7) = (0:0:0, 0:0:0);
	(RAD2 => RD7) = (0:0:0, 0:0:0);
	(RAD3 => RD7) = (0:0:0, 0:0:0);
	(RAD4 => RD7) = (0:0:0, 0:0:0);
	(RAD5 => RD7) = (0:0:0, 0:0:0);
	(RAD6 => RD7) = (0:0:0, 0:0:0);
	(RAD7 => RD7) = (0:0:0, 0:0:0);
	(RAD8 => RD7) = (0:0:0, 0:0:0);
	(RAD9 => RD7) = (0:0:0, 0:0:0);
	(RAD10 => RD7) = (0:0:0, 0:0:0);

endspecify

endmodule
`endcelldefine
`celldefine
module RAMB16KA_WX8_RX16(WCEN,WCLK,WCS0,WCS1,WE,RST,
                    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,
		    RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [10:0] wad;
wire [9:0]  rad;
wire [1:0]  wcs;
wire [7:0]  wd;
wire [15:0] rd;
reg notifier;

assign wad = {WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd = {WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
buf INSXQ8 (RD8,rd[8]);
buf INSXQ9 (RD9,rd[9]);

buf INSXQ10 (RD10,rd[10]);
buf INSXQ11 (RD11,rd[11]);
buf INSXQ12 (RD12,rd[12]);
buf INSXQ13 (RD13,rd[13]);
buf INSXQ14 (RD14,rd[14]);
buf INSXQ15 (RD15,rd[15]);

defparam RAM_U0.WADDR_WIDTH=11;
defparam RAM_U0.WDATA_WIDTH=8;
defparam RAM_U0.RADDR_WIDTH=10;
defparam RAM_U0.RDATA_WIDTH=16;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1); 

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);
	(RST => RD8) = (0:0:0, 0:0:0);
	(RST => RD9) = (0:0:0, 0:0:0);
	(RST => RD10) = (0:0:0, 0:0:0);
	(RST => RD11) = (0:0:0, 0:0:0);
	(RST => RD12) = (0:0:0, 0:0:0);
	(RST => RD13) = (0:0:0, 0:0:0);
	(RST => RD14) = (0:0:0, 0:0:0);
	(RST => RD15) = (0:0:0, 0:0:0);

	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);
	(RAD9 => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD1) = (0:0:0, 0:0:0);
	(RAD1 => RD1) = (0:0:0, 0:0:0);
	(RAD2 => RD1) = (0:0:0, 0:0:0);
	(RAD3 => RD1) = (0:0:0, 0:0:0);
	(RAD4 => RD1) = (0:0:0, 0:0:0);
	(RAD5 => RD1) = (0:0:0, 0:0:0);
	(RAD6 => RD1) = (0:0:0, 0:0:0);
	(RAD7 => RD1) = (0:0:0, 0:0:0);
	(RAD8 => RD1) = (0:0:0, 0:0:0);
	(RAD9 => RD1) = (0:0:0, 0:0:0);

	(RAD0 => RD2) = (0:0:0, 0:0:0);
	(RAD1 => RD2) = (0:0:0, 0:0:0);
	(RAD2 => RD2) = (0:0:0, 0:0:0);
	(RAD3 => RD2) = (0:0:0, 0:0:0);
	(RAD4 => RD2) = (0:0:0, 0:0:0);
	(RAD5 => RD2) = (0:0:0, 0:0:0);
	(RAD6 => RD2) = (0:0:0, 0:0:0);
	(RAD7 => RD2) = (0:0:0, 0:0:0);
	(RAD8 => RD2) = (0:0:0, 0:0:0);
	(RAD9 => RD2) = (0:0:0, 0:0:0);

	(RAD0 => RD3) = (0:0:0, 0:0:0);
	(RAD1 => RD3) = (0:0:0, 0:0:0);
	(RAD2 => RD3) = (0:0:0, 0:0:0);
	(RAD3 => RD3) = (0:0:0, 0:0:0);
	(RAD4 => RD3) = (0:0:0, 0:0:0);
	(RAD5 => RD3) = (0:0:0, 0:0:0);
	(RAD6 => RD3) = (0:0:0, 0:0:0);
	(RAD7 => RD3) = (0:0:0, 0:0:0);
	(RAD8 => RD3) = (0:0:0, 0:0:0);
	(RAD9 => RD3) = (0:0:0, 0:0:0);

	(RAD0 => RD4) = (0:0:0, 0:0:0);
	(RAD1 => RD4) = (0:0:0, 0:0:0);
	(RAD2 => RD4) = (0:0:0, 0:0:0);
	(RAD3 => RD4) = (0:0:0, 0:0:0);
	(RAD4 => RD4) = (0:0:0, 0:0:0);
	(RAD5 => RD4) = (0:0:0, 0:0:0);
	(RAD6 => RD4) = (0:0:0, 0:0:0);
	(RAD7 => RD4) = (0:0:0, 0:0:0);
	(RAD8 => RD4) = (0:0:0, 0:0:0);
	(RAD9 => RD4) = (0:0:0, 0:0:0);

	(RAD0 => RD5) = (0:0:0, 0:0:0);
	(RAD1 => RD5) = (0:0:0, 0:0:0);
	(RAD2 => RD5) = (0:0:0, 0:0:0);
	(RAD3 => RD5) = (0:0:0, 0:0:0);
	(RAD4 => RD5) = (0:0:0, 0:0:0);
	(RAD5 => RD5) = (0:0:0, 0:0:0);
	(RAD6 => RD5) = (0:0:0, 0:0:0);
	(RAD7 => RD5) = (0:0:0, 0:0:0);
	(RAD8 => RD5) = (0:0:0, 0:0:0);
	(RAD9 => RD5) = (0:0:0, 0:0:0);

	(RAD0 => RD6) = (0:0:0, 0:0:0);
	(RAD1 => RD6) = (0:0:0, 0:0:0);
	(RAD2 => RD6) = (0:0:0, 0:0:0);
	(RAD3 => RD6) = (0:0:0, 0:0:0);
	(RAD4 => RD6) = (0:0:0, 0:0:0);
	(RAD5 => RD6) = (0:0:0, 0:0:0);
	(RAD6 => RD6) = (0:0:0, 0:0:0);
	(RAD7 => RD6) = (0:0:0, 0:0:0);
	(RAD8 => RD6) = (0:0:0, 0:0:0);
	(RAD9 => RD6) = (0:0:0, 0:0:0);

	(RAD0 => RD7) = (0:0:0, 0:0:0);
	(RAD1 => RD7) = (0:0:0, 0:0:0);
	(RAD2 => RD7) = (0:0:0, 0:0:0);
	(RAD3 => RD7) = (0:0:0, 0:0:0);
	(RAD4 => RD7) = (0:0:0, 0:0:0);
	(RAD5 => RD7) = (0:0:0, 0:0:0);
	(RAD6 => RD7) = (0:0:0, 0:0:0);
	(RAD7 => RD7) = (0:0:0, 0:0:0);
	(RAD8 => RD7) = (0:0:0, 0:0:0);
	(RAD9 => RD7) = (0:0:0, 0:0:0);

	(RAD0 => RD8) = (0:0:0, 0:0:0);
	(RAD1 => RD8) = (0:0:0, 0:0:0);
	(RAD2 => RD8) = (0:0:0, 0:0:0);
	(RAD3 => RD8) = (0:0:0, 0:0:0);
	(RAD4 => RD8) = (0:0:0, 0:0:0);
	(RAD5 => RD8) = (0:0:0, 0:0:0);
	(RAD6 => RD8) = (0:0:0, 0:0:0);
	(RAD7 => RD8) = (0:0:0, 0:0:0);
	(RAD8 => RD8) = (0:0:0, 0:0:0);
	(RAD9 => RD8) = (0:0:0, 0:0:0);

	(RAD0 => RD9) = (0:0:0, 0:0:0);
	(RAD1 => RD9) = (0:0:0, 0:0:0);
	(RAD2 => RD9) = (0:0:0, 0:0:0);
	(RAD3 => RD9) = (0:0:0, 0:0:0);
	(RAD4 => RD9) = (0:0:0, 0:0:0);
	(RAD5 => RD9) = (0:0:0, 0:0:0);
	(RAD6 => RD9) = (0:0:0, 0:0:0);
	(RAD7 => RD9) = (0:0:0, 0:0:0);
	(RAD8 => RD9) = (0:0:0, 0:0:0);
	(RAD9 => RD9) = (0:0:0, 0:0:0);

	(RAD0 => RD10) = (0:0:0, 0:0:0);
	(RAD1 => RD10) = (0:0:0, 0:0:0);
	(RAD2 => RD10) = (0:0:0, 0:0:0);
	(RAD3 => RD10) = (0:0:0, 0:0:0);
	(RAD4 => RD10) = (0:0:0, 0:0:0);
	(RAD5 => RD10) = (0:0:0, 0:0:0);
	(RAD6 => RD10) = (0:0:0, 0:0:0);
	(RAD7 => RD10) = (0:0:0, 0:0:0);
	(RAD8 => RD10) = (0:0:0, 0:0:0);
	(RAD9 => RD10) = (0:0:0, 0:0:0);

	(RAD0 => RD11) = (0:0:0, 0:0:0);
	(RAD1 => RD11) = (0:0:0, 0:0:0);
	(RAD2 => RD11) = (0:0:0, 0:0:0);
	(RAD3 => RD11) = (0:0:0, 0:0:0);
	(RAD4 => RD11) = (0:0:0, 0:0:0);
	(RAD5 => RD11) = (0:0:0, 0:0:0);
	(RAD6 => RD11) = (0:0:0, 0:0:0);
	(RAD7 => RD11) = (0:0:0, 0:0:0);
	(RAD8 => RD11) = (0:0:0, 0:0:0);
	(RAD9 => RD11) = (0:0:0, 0:0:0);

	(RAD0 => RD12) = (0:0:0, 0:0:0);
	(RAD1 => RD12) = (0:0:0, 0:0:0);
	(RAD2 => RD12) = (0:0:0, 0:0:0);
	(RAD3 => RD12) = (0:0:0, 0:0:0);
	(RAD4 => RD12) = (0:0:0, 0:0:0);
	(RAD5 => RD12) = (0:0:0, 0:0:0);
	(RAD6 => RD12) = (0:0:0, 0:0:0);
	(RAD7 => RD12) = (0:0:0, 0:0:0);
	(RAD8 => RD12) = (0:0:0, 0:0:0);
	(RAD9 => RD12) = (0:0:0, 0:0:0);

	(RAD0 => RD13) = (0:0:0, 0:0:0);
	(RAD1 => RD13) = (0:0:0, 0:0:0);
	(RAD2 => RD13) = (0:0:0, 0:0:0);
	(RAD3 => RD13) = (0:0:0, 0:0:0);
	(RAD4 => RD13) = (0:0:0, 0:0:0);
	(RAD5 => RD13) = (0:0:0, 0:0:0);
	(RAD6 => RD13) = (0:0:0, 0:0:0);
	(RAD7 => RD13) = (0:0:0, 0:0:0);
	(RAD8 => RD13) = (0:0:0, 0:0:0);
	(RAD9 => RD13) = (0:0:0, 0:0:0);

	(RAD0 => RD14) = (0:0:0, 0:0:0);
	(RAD1 => RD14) = (0:0:0, 0:0:0);
	(RAD2 => RD14) = (0:0:0, 0:0:0);
	(RAD3 => RD14) = (0:0:0, 0:0:0);
	(RAD4 => RD14) = (0:0:0, 0:0:0);
	(RAD5 => RD14) = (0:0:0, 0:0:0);
	(RAD6 => RD14) = (0:0:0, 0:0:0);
	(RAD7 => RD14) = (0:0:0, 0:0:0);
	(RAD8 => RD14) = (0:0:0, 0:0:0);
	(RAD9 => RD14) = (0:0:0, 0:0:0);

	(RAD0 => RD15) = (0:0:0, 0:0:0);
	(RAD1 => RD15) = (0:0:0, 0:0:0);
	(RAD2 => RD15) = (0:0:0, 0:0:0);
	(RAD3 => RD15) = (0:0:0, 0:0:0);
	(RAD4 => RD15) = (0:0:0, 0:0:0);
	(RAD5 => RD15) = (0:0:0, 0:0:0);
	(RAD6 => RD15) = (0:0:0, 0:0:0);
	(RAD7 => RD15) = (0:0:0, 0:0:0);
	(RAD8 => RD15) = (0:0:0, 0:0:0);
	(RAD9 => RD15) = (0:0:0, 0:0:0);

endspecify

endmodule
`endcelldefine
`celldefine
module RAMB16KA_WX8_RX32(WCEN,WCLK,WCS0,WCS1,WE,RST,
                    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,
		    RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15,
		    RD16,RD17,RD18,RD19,RD20,RD21,RD22,RD23,RD24,RD25,RD26,RD27,RD28,RD29,RD30,RD31
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15;
output  RD16,RD17,RD18,RD19,RD20,RD21,RD22,RD23,RD24,RD25,RD26,RD27,RD28,RD29,RD30,RD31;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [10:0] wad;
wire [8:0]  rad;
wire [1:0]  wcs;
wire [7:0]  wd;
wire [31:0] rd;
reg notifier;

assign wad = {WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd = {WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign  {RD31,RD30,RD29,RD28,RD27,RD26,RD25,RD24,RD23,RD22,RD21,RD20,RD19,RD18,RD17,RD16,RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
buf INSXQ8 (RD8,rd[8]);
buf INSXQ9 (RD9,rd[9]);

buf INSXQ10 (RD10,rd[10]);
buf INSXQ11 (RD11,rd[11]);
buf INSXQ12 (RD12,rd[12]);
buf INSXQ13 (RD13,rd[13]);
buf INSXQ14 (RD14,rd[14]);
buf INSXQ15 (RD15,rd[15]);
buf INSXQ16 (RD16,rd[16]);
buf INSXQ17 (RD17,rd[17]);
buf INSXQ18 (RD18,rd[18]);
buf INSXQ19 (RD19,rd[19]);

buf INSXQ20 (RD20,rd[20]);
buf INSXQ21 (RD21,rd[21]);
buf INSXQ22 (RD22,rd[22]);
buf INSXQ23 (RD23,rd[23]);
buf INSXQ24 (RD24,rd[24]);
buf INSXQ25 (RD25,rd[25]);
buf INSXQ26 (RD26,rd[26]);
buf INSXQ27 (RD27,rd[27]);
buf INSXQ28 (RD28,rd[28]);
buf INSXQ29 (RD29,rd[29]);

buf INSXQ30 (RD30,rd[30]);
buf INSXQ31 (RD31,rd[31]);

defparam RAM_U0.WADDR_WIDTH=11;
defparam RAM_U0.WDATA_WIDTH=8;
defparam RAM_U0.RADDR_WIDTH=9;
defparam RAM_U0.RDATA_WIDTH=32;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1); 

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);
	(RST => RD8) = (0:0:0, 0:0:0);
	(RST => RD9) = (0:0:0, 0:0:0);
	(RST => RD10) = (0:0:0, 0:0:0);
	(RST => RD11) = (0:0:0, 0:0:0);
	(RST => RD12) = (0:0:0, 0:0:0);
	(RST => RD13) = (0:0:0, 0:0:0);
	(RST => RD14) = (0:0:0, 0:0:0);
	(RST => RD15) = (0:0:0, 0:0:0);
	(RST => RD16) = (0:0:0, 0:0:0);
	(RST => RD17) = (0:0:0, 0:0:0);
	(RST => RD18) = (0:0:0, 0:0:0);
	(RST => RD19) = (0:0:0, 0:0:0);
	(RST => RD20) = (0:0:0, 0:0:0);
	(RST => RD21) = (0:0:0, 0:0:0);
	(RST => RD22) = (0:0:0, 0:0:0);
	(RST => RD23) = (0:0:0, 0:0:0);
	(RST => RD24) = (0:0:0, 0:0:0);
	(RST => RD25) = (0:0:0, 0:0:0);
	(RST => RD26) = (0:0:0, 0:0:0);
	(RST => RD27) = (0:0:0, 0:0:0);
	(RST => RD28) = (0:0:0, 0:0:0);
	(RST => RD29) = (0:0:0, 0:0:0);
	(RST => RD30) = (0:0:0, 0:0:0);
	(RST => RD31) = (0:0:0, 0:0:0);


	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD1) = (0:0:0, 0:0:0);
	(RAD1 => RD1) = (0:0:0, 0:0:0);
	(RAD2 => RD1) = (0:0:0, 0:0:0);
	(RAD3 => RD1) = (0:0:0, 0:0:0);
	(RAD4 => RD1) = (0:0:0, 0:0:0);
	(RAD5 => RD1) = (0:0:0, 0:0:0);
	(RAD6 => RD1) = (0:0:0, 0:0:0);
	(RAD7 => RD1) = (0:0:0, 0:0:0);
	(RAD8 => RD1) = (0:0:0, 0:0:0);

	(RAD0 => RD2) = (0:0:0, 0:0:0);
	(RAD1 => RD2) = (0:0:0, 0:0:0);
	(RAD2 => RD2) = (0:0:0, 0:0:0);
	(RAD3 => RD2) = (0:0:0, 0:0:0);
	(RAD4 => RD2) = (0:0:0, 0:0:0);
	(RAD5 => RD2) = (0:0:0, 0:0:0);
	(RAD6 => RD2) = (0:0:0, 0:0:0);
	(RAD7 => RD2) = (0:0:0, 0:0:0);
	(RAD8 => RD2) = (0:0:0, 0:0:0);

	(RAD0 => RD3) = (0:0:0, 0:0:0);
	(RAD1 => RD3) = (0:0:0, 0:0:0);
	(RAD2 => RD3) = (0:0:0, 0:0:0);
	(RAD3 => RD3) = (0:0:0, 0:0:0);
	(RAD4 => RD3) = (0:0:0, 0:0:0);
	(RAD5 => RD3) = (0:0:0, 0:0:0);
	(RAD6 => RD3) = (0:0:0, 0:0:0);
	(RAD7 => RD3) = (0:0:0, 0:0:0);
	(RAD8 => RD3) = (0:0:0, 0:0:0);

	(RAD0 => RD4) = (0:0:0, 0:0:0);
	(RAD1 => RD4) = (0:0:0, 0:0:0);
	(RAD2 => RD4) = (0:0:0, 0:0:0);
	(RAD3 => RD4) = (0:0:0, 0:0:0);
	(RAD4 => RD4) = (0:0:0, 0:0:0);
	(RAD5 => RD4) = (0:0:0, 0:0:0);
	(RAD6 => RD4) = (0:0:0, 0:0:0);
	(RAD7 => RD4) = (0:0:0, 0:0:0);
	(RAD8 => RD4) = (0:0:0, 0:0:0);

	(RAD0 => RD5) = (0:0:0, 0:0:0);
	(RAD1 => RD5) = (0:0:0, 0:0:0);
	(RAD2 => RD5) = (0:0:0, 0:0:0);
	(RAD3 => RD5) = (0:0:0, 0:0:0);
	(RAD4 => RD5) = (0:0:0, 0:0:0);
	(RAD5 => RD5) = (0:0:0, 0:0:0);
	(RAD6 => RD5) = (0:0:0, 0:0:0);
	(RAD7 => RD5) = (0:0:0, 0:0:0);
	(RAD8 => RD5) = (0:0:0, 0:0:0);

	(RAD0 => RD6) = (0:0:0, 0:0:0);
	(RAD1 => RD6) = (0:0:0, 0:0:0);
	(RAD2 => RD6) = (0:0:0, 0:0:0);
	(RAD3 => RD6) = (0:0:0, 0:0:0);
	(RAD4 => RD6) = (0:0:0, 0:0:0);
	(RAD5 => RD6) = (0:0:0, 0:0:0);
	(RAD6 => RD6) = (0:0:0, 0:0:0);
	(RAD7 => RD6) = (0:0:0, 0:0:0);
	(RAD8 => RD6) = (0:0:0, 0:0:0);

	(RAD0 => RD7) = (0:0:0, 0:0:0);
	(RAD1 => RD7) = (0:0:0, 0:0:0);
	(RAD2 => RD7) = (0:0:0, 0:0:0);
	(RAD3 => RD7) = (0:0:0, 0:0:0);
	(RAD4 => RD7) = (0:0:0, 0:0:0);
	(RAD5 => RD7) = (0:0:0, 0:0:0);
	(RAD6 => RD7) = (0:0:0, 0:0:0);
	(RAD7 => RD7) = (0:0:0, 0:0:0);
	(RAD8 => RD7) = (0:0:0, 0:0:0);

	(RAD0 => RD8) = (0:0:0, 0:0:0);
	(RAD1 => RD8) = (0:0:0, 0:0:0);
	(RAD2 => RD8) = (0:0:0, 0:0:0);
	(RAD3 => RD8) = (0:0:0, 0:0:0);
	(RAD4 => RD8) = (0:0:0, 0:0:0);
	(RAD5 => RD8) = (0:0:0, 0:0:0);
	(RAD6 => RD8) = (0:0:0, 0:0:0);
	(RAD7 => RD8) = (0:0:0, 0:0:0);
	(RAD8 => RD8) = (0:0:0, 0:0:0);

	(RAD0 => RD9) = (0:0:0, 0:0:0);
	(RAD1 => RD9) = (0:0:0, 0:0:0);
	(RAD2 => RD9) = (0:0:0, 0:0:0);
	(RAD3 => RD9) = (0:0:0, 0:0:0);
	(RAD4 => RD9) = (0:0:0, 0:0:0);
	(RAD5 => RD9) = (0:0:0, 0:0:0);
	(RAD6 => RD9) = (0:0:0, 0:0:0);
	(RAD7 => RD9) = (0:0:0, 0:0:0);
	(RAD8 => RD9) = (0:0:0, 0:0:0);

	(RAD0 => RD10) = (0:0:0, 0:0:0);
	(RAD1 => RD10) = (0:0:0, 0:0:0);
	(RAD2 => RD10) = (0:0:0, 0:0:0);
	(RAD3 => RD10) = (0:0:0, 0:0:0);
	(RAD4 => RD10) = (0:0:0, 0:0:0);
	(RAD5 => RD10) = (0:0:0, 0:0:0);
	(RAD6 => RD10) = (0:0:0, 0:0:0);
	(RAD7 => RD10) = (0:0:0, 0:0:0);
	(RAD8 => RD10) = (0:0:0, 0:0:0);

	(RAD0 => RD11) = (0:0:0, 0:0:0);
	(RAD1 => RD11) = (0:0:0, 0:0:0);
	(RAD2 => RD11) = (0:0:0, 0:0:0);
	(RAD3 => RD11) = (0:0:0, 0:0:0);
	(RAD4 => RD11) = (0:0:0, 0:0:0);
	(RAD5 => RD11) = (0:0:0, 0:0:0);
	(RAD6 => RD11) = (0:0:0, 0:0:0);
	(RAD7 => RD11) = (0:0:0, 0:0:0);
	(RAD8 => RD11) = (0:0:0, 0:0:0);

	(RAD0 => RD12) = (0:0:0, 0:0:0);
	(RAD1 => RD12) = (0:0:0, 0:0:0);
	(RAD2 => RD12) = (0:0:0, 0:0:0);
	(RAD3 => RD12) = (0:0:0, 0:0:0);
	(RAD4 => RD12) = (0:0:0, 0:0:0);
	(RAD5 => RD12) = (0:0:0, 0:0:0);
	(RAD6 => RD12) = (0:0:0, 0:0:0);
	(RAD7 => RD12) = (0:0:0, 0:0:0);
	(RAD8 => RD12) = (0:0:0, 0:0:0);

	(RAD0 => RD13) = (0:0:0, 0:0:0);
	(RAD1 => RD13) = (0:0:0, 0:0:0);
	(RAD2 => RD13) = (0:0:0, 0:0:0);
	(RAD3 => RD13) = (0:0:0, 0:0:0);
	(RAD4 => RD13) = (0:0:0, 0:0:0);
	(RAD5 => RD13) = (0:0:0, 0:0:0);
	(RAD6 => RD13) = (0:0:0, 0:0:0);
	(RAD7 => RD13) = (0:0:0, 0:0:0);
	(RAD8 => RD13) = (0:0:0, 0:0:0);

	(RAD0 => RD14) = (0:0:0, 0:0:0);
	(RAD1 => RD14) = (0:0:0, 0:0:0);
	(RAD2 => RD14) = (0:0:0, 0:0:0);
	(RAD3 => RD14) = (0:0:0, 0:0:0);
	(RAD4 => RD14) = (0:0:0, 0:0:0);
	(RAD5 => RD14) = (0:0:0, 0:0:0);
	(RAD6 => RD14) = (0:0:0, 0:0:0);
	(RAD7 => RD14) = (0:0:0, 0:0:0);
	(RAD8 => RD14) = (0:0:0, 0:0:0);

	(RAD0 => RD15) = (0:0:0, 0:0:0);
	(RAD1 => RD15) = (0:0:0, 0:0:0);
	(RAD2 => RD15) = (0:0:0, 0:0:0);
	(RAD3 => RD15) = (0:0:0, 0:0:0);
	(RAD4 => RD15) = (0:0:0, 0:0:0);
	(RAD5 => RD15) = (0:0:0, 0:0:0);
	(RAD6 => RD15) = (0:0:0, 0:0:0);
	(RAD7 => RD15) = (0:0:0, 0:0:0);
	(RAD8 => RD15) = (0:0:0, 0:0:0);

	(RAD0 => RD16) = (0:0:0, 0:0:0);
	(RAD1 => RD16) = (0:0:0, 0:0:0);
	(RAD2 => RD16) = (0:0:0, 0:0:0);
	(RAD3 => RD16) = (0:0:0, 0:0:0);
	(RAD4 => RD16) = (0:0:0, 0:0:0);
	(RAD5 => RD16) = (0:0:0, 0:0:0);
	(RAD6 => RD16) = (0:0:0, 0:0:0);
	(RAD7 => RD16) = (0:0:0, 0:0:0);
	(RAD8 => RD16) = (0:0:0, 0:0:0);

	(RAD0 => RD17) = (0:0:0, 0:0:0);
	(RAD1 => RD17) = (0:0:0, 0:0:0);
	(RAD2 => RD17) = (0:0:0, 0:0:0);
	(RAD3 => RD17) = (0:0:0, 0:0:0);
	(RAD4 => RD17) = (0:0:0, 0:0:0);
	(RAD5 => RD17) = (0:0:0, 0:0:0);
	(RAD6 => RD17) = (0:0:0, 0:0:0);
	(RAD7 => RD17) = (0:0:0, 0:0:0);
	(RAD8 => RD17) = (0:0:0, 0:0:0);

	(RAD0 => RD18) = (0:0:0, 0:0:0);
	(RAD1 => RD18) = (0:0:0, 0:0:0);
	(RAD2 => RD18) = (0:0:0, 0:0:0);
	(RAD3 => RD18) = (0:0:0, 0:0:0);
	(RAD4 => RD18) = (0:0:0, 0:0:0);
	(RAD5 => RD18) = (0:0:0, 0:0:0);
	(RAD6 => RD18) = (0:0:0, 0:0:0);
	(RAD7 => RD18) = (0:0:0, 0:0:0);
	(RAD8 => RD18) = (0:0:0, 0:0:0);

	(RAD0 => RD19) = (0:0:0, 0:0:0);
	(RAD1 => RD19) = (0:0:0, 0:0:0);
	(RAD2 => RD19) = (0:0:0, 0:0:0);
	(RAD3 => RD19) = (0:0:0, 0:0:0);
	(RAD4 => RD19) = (0:0:0, 0:0:0);
	(RAD5 => RD19) = (0:0:0, 0:0:0);
	(RAD6 => RD19) = (0:0:0, 0:0:0);
	(RAD7 => RD19) = (0:0:0, 0:0:0);
	(RAD8 => RD19) = (0:0:0, 0:0:0);

	(RAD0 => RD20) = (0:0:0, 0:0:0);
	(RAD1 => RD20) = (0:0:0, 0:0:0);
	(RAD2 => RD20) = (0:0:0, 0:0:0);
	(RAD3 => RD20) = (0:0:0, 0:0:0);
	(RAD4 => RD20) = (0:0:0, 0:0:0);
	(RAD5 => RD20) = (0:0:0, 0:0:0);
	(RAD6 => RD20) = (0:0:0, 0:0:0);
	(RAD7 => RD20) = (0:0:0, 0:0:0);
	(RAD8 => RD20) = (0:0:0, 0:0:0);

	(RAD0 => RD21) = (0:0:0, 0:0:0);
	(RAD1 => RD21) = (0:0:0, 0:0:0);
	(RAD2 => RD21) = (0:0:0, 0:0:0);
	(RAD3 => RD21) = (0:0:0, 0:0:0);
	(RAD4 => RD21) = (0:0:0, 0:0:0);
	(RAD5 => RD21) = (0:0:0, 0:0:0);
	(RAD6 => RD21) = (0:0:0, 0:0:0);
	(RAD7 => RD21) = (0:0:0, 0:0:0);
	(RAD8 => RD21) = (0:0:0, 0:0:0);

	(RAD0 => RD22) = (0:0:0, 0:0:0);
	(RAD1 => RD22) = (0:0:0, 0:0:0);
	(RAD2 => RD22) = (0:0:0, 0:0:0);
	(RAD3 => RD22) = (0:0:0, 0:0:0);
	(RAD4 => RD22) = (0:0:0, 0:0:0);
	(RAD5 => RD22) = (0:0:0, 0:0:0);
	(RAD6 => RD22) = (0:0:0, 0:0:0);
	(RAD7 => RD22) = (0:0:0, 0:0:0);
	(RAD8 => RD22) = (0:0:0, 0:0:0);

	(RAD0 => RD23) = (0:0:0, 0:0:0);
	(RAD1 => RD23) = (0:0:0, 0:0:0);
	(RAD2 => RD23) = (0:0:0, 0:0:0);
	(RAD3 => RD23) = (0:0:0, 0:0:0);
	(RAD4 => RD23) = (0:0:0, 0:0:0);
	(RAD5 => RD23) = (0:0:0, 0:0:0);
	(RAD6 => RD23) = (0:0:0, 0:0:0);
	(RAD7 => RD23) = (0:0:0, 0:0:0);
	(RAD8 => RD23) = (0:0:0, 0:0:0);

	(RAD0 => RD24) = (0:0:0, 0:0:0);
	(RAD1 => RD24) = (0:0:0, 0:0:0);
	(RAD2 => RD24) = (0:0:0, 0:0:0);
	(RAD3 => RD24) = (0:0:0, 0:0:0);
	(RAD4 => RD24) = (0:0:0, 0:0:0);
	(RAD5 => RD24) = (0:0:0, 0:0:0);
	(RAD6 => RD24) = (0:0:0, 0:0:0);
	(RAD7 => RD24) = (0:0:0, 0:0:0);
	(RAD8 => RD24) = (0:0:0, 0:0:0);

	(RAD0 => RD25) = (0:0:0, 0:0:0);
	(RAD1 => RD25) = (0:0:0, 0:0:0);
	(RAD2 => RD25) = (0:0:0, 0:0:0);
	(RAD3 => RD25) = (0:0:0, 0:0:0);
	(RAD4 => RD25) = (0:0:0, 0:0:0);
	(RAD5 => RD25) = (0:0:0, 0:0:0);
	(RAD6 => RD25) = (0:0:0, 0:0:0);
	(RAD7 => RD25) = (0:0:0, 0:0:0);
	(RAD8 => RD25) = (0:0:0, 0:0:0);

	(RAD0 => RD26) = (0:0:0, 0:0:0);
	(RAD1 => RD26) = (0:0:0, 0:0:0);
	(RAD2 => RD26) = (0:0:0, 0:0:0);
	(RAD3 => RD26) = (0:0:0, 0:0:0);
	(RAD4 => RD26) = (0:0:0, 0:0:0);
	(RAD5 => RD26) = (0:0:0, 0:0:0);
	(RAD6 => RD26) = (0:0:0, 0:0:0);
	(RAD7 => RD26) = (0:0:0, 0:0:0);
	(RAD8 => RD26) = (0:0:0, 0:0:0);

	(RAD0 => RD27) = (0:0:0, 0:0:0);
	(RAD1 => RD27) = (0:0:0, 0:0:0);
	(RAD2 => RD27) = (0:0:0, 0:0:0);
	(RAD3 => RD27) = (0:0:0, 0:0:0);
	(RAD4 => RD27) = (0:0:0, 0:0:0);
	(RAD5 => RD27) = (0:0:0, 0:0:0);
	(RAD6 => RD27) = (0:0:0, 0:0:0);
	(RAD7 => RD27) = (0:0:0, 0:0:0);
	(RAD8 => RD27) = (0:0:0, 0:0:0);

	(RAD0 => RD28) = (0:0:0, 0:0:0);
	(RAD1 => RD28) = (0:0:0, 0:0:0);
	(RAD2 => RD28) = (0:0:0, 0:0:0);
	(RAD3 => RD28) = (0:0:0, 0:0:0);
	(RAD4 => RD28) = (0:0:0, 0:0:0);
	(RAD5 => RD28) = (0:0:0, 0:0:0);
	(RAD6 => RD28) = (0:0:0, 0:0:0);
	(RAD7 => RD28) = (0:0:0, 0:0:0);
	(RAD8 => RD28) = (0:0:0, 0:0:0);

	(RAD0 => RD29) = (0:0:0, 0:0:0);
	(RAD1 => RD29) = (0:0:0, 0:0:0);
	(RAD2 => RD29) = (0:0:0, 0:0:0);
	(RAD3 => RD29) = (0:0:0, 0:0:0);
	(RAD4 => RD29) = (0:0:0, 0:0:0);
	(RAD5 => RD29) = (0:0:0, 0:0:0);
	(RAD6 => RD29) = (0:0:0, 0:0:0);
	(RAD7 => RD29) = (0:0:0, 0:0:0);
	(RAD8 => RD29) = (0:0:0, 0:0:0);

	(RAD0 => RD30) = (0:0:0, 0:0:0);
	(RAD1 => RD30) = (0:0:0, 0:0:0);
	(RAD2 => RD30) = (0:0:0, 0:0:0);
	(RAD3 => RD30) = (0:0:0, 0:0:0);
	(RAD4 => RD30) = (0:0:0, 0:0:0);
	(RAD5 => RD30) = (0:0:0, 0:0:0);
	(RAD6 => RD30) = (0:0:0, 0:0:0);
	(RAD7 => RD30) = (0:0:0, 0:0:0);
	(RAD8 => RD30) = (0:0:0, 0:0:0);

	(RAD0 => RD31) = (0:0:0, 0:0:0);
	(RAD1 => RD31) = (0:0:0, 0:0:0);
	(RAD2 => RD31) = (0:0:0, 0:0:0);
	(RAD3 => RD31) = (0:0:0, 0:0:0);
	(RAD4 => RD31) = (0:0:0, 0:0:0);
	(RAD5 => RD31) = (0:0:0, 0:0:0);
	(RAD6 => RD31) = (0:0:0, 0:0:0);
	(RAD7 => RD31) = (0:0:0, 0:0:0);
	(RAD8 => RD31) = (0:0:0, 0:0:0);

endspecify

endmodule
`endcelldefine
`celldefine
module RAMB16KA_WX16_RX16(WCEN,WCLK,WCS0,WCS1,WE,RST,
                    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,
                    WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,
                    RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7;
input  WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7;
output  RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [9:0] wad;
wire [9:0]  rad;
wire [1:0]  wcs;
wire [15:0] wd;
wire [15:0] rd;
reg notifier;

assign wad = {WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd = {WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
buf INSXQ8 (RD8,rd[8]);
buf INSXQ9 (RD9,rd[9]);

buf INSXQ10 (RD10,rd[10]);
buf INSXQ11 (RD11,rd[11]);
buf INSXQ12 (RD12,rd[12]);
buf INSXQ13 (RD13,rd[13]);
buf INSXQ14 (RD14,rd[14]);
buf INSXQ15 (RD15,rd[15]);

defparam RAM_U0.WADDR_WIDTH=10;
defparam RAM_U0.WDATA_WIDTH=16;
defparam RAM_U0.RADDR_WIDTH=10;
defparam RAM_U0.RDATA_WIDTH=16;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));


specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);
	$setuphold  (posedge WCLK, WD8, 1, 0);
	$setuphold  (posedge WCLK, WD9, 1, 0);
	$setuphold  (posedge WCLK, WD10, 1, 0);
	$setuphold  (posedge WCLK, WD11, 1, 0);
	$setuphold  (posedge WCLK, WD12, 1, 0);
	$setuphold  (posedge WCLK, WD13, 1, 0);
	$setuphold  (posedge WCLK, WD14, 1, 0);
	$setuphold  (posedge WCLK, WD15, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1); 

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);
	(RST => RD8) = (0:0:0, 0:0:0);
	(RST => RD9) = (0:0:0, 0:0:0);
	(RST => RD10) = (0:0:0, 0:0:0);
	(RST => RD11) = (0:0:0, 0:0:0);
	(RST => RD12) = (0:0:0, 0:0:0);
	(RST => RD13) = (0:0:0, 0:0:0);
	(RST => RD14) = (0:0:0, 0:0:0);
	(RST => RD15) = (0:0:0, 0:0:0);


	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);
	(RAD9 => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD1) = (0:0:0, 0:0:0);
	(RAD1 => RD1) = (0:0:0, 0:0:0);
	(RAD2 => RD1) = (0:0:0, 0:0:0);
	(RAD3 => RD1) = (0:0:0, 0:0:0);
	(RAD4 => RD1) = (0:0:0, 0:0:0);
	(RAD5 => RD1) = (0:0:0, 0:0:0);
	(RAD6 => RD1) = (0:0:0, 0:0:0);
	(RAD7 => RD1) = (0:0:0, 0:0:0);
	(RAD8 => RD1) = (0:0:0, 0:0:0);
	(RAD9 => RD1) = (0:0:0, 0:0:0);

	(RAD0 => RD2) = (0:0:0, 0:0:0);
	(RAD1 => RD2) = (0:0:0, 0:0:0);
	(RAD2 => RD2) = (0:0:0, 0:0:0);
	(RAD3 => RD2) = (0:0:0, 0:0:0);
	(RAD4 => RD2) = (0:0:0, 0:0:0);
	(RAD5 => RD2) = (0:0:0, 0:0:0);
	(RAD6 => RD2) = (0:0:0, 0:0:0);
	(RAD7 => RD2) = (0:0:0, 0:0:0);
	(RAD8 => RD2) = (0:0:0, 0:0:0);
	(RAD9 => RD2) = (0:0:0, 0:0:0);

	(RAD0 => RD3) = (0:0:0, 0:0:0);
	(RAD1 => RD3) = (0:0:0, 0:0:0);
	(RAD2 => RD3) = (0:0:0, 0:0:0);
	(RAD3 => RD3) = (0:0:0, 0:0:0);
	(RAD4 => RD3) = (0:0:0, 0:0:0);
	(RAD5 => RD3) = (0:0:0, 0:0:0);
	(RAD6 => RD3) = (0:0:0, 0:0:0);
	(RAD7 => RD3) = (0:0:0, 0:0:0);
	(RAD8 => RD3) = (0:0:0, 0:0:0);
	(RAD9 => RD3) = (0:0:0, 0:0:0);

	(RAD0 => RD4) = (0:0:0, 0:0:0);
	(RAD1 => RD4) = (0:0:0, 0:0:0);
	(RAD2 => RD4) = (0:0:0, 0:0:0);
	(RAD3 => RD4) = (0:0:0, 0:0:0);
	(RAD4 => RD4) = (0:0:0, 0:0:0);
	(RAD5 => RD4) = (0:0:0, 0:0:0);
	(RAD6 => RD4) = (0:0:0, 0:0:0);
	(RAD7 => RD4) = (0:0:0, 0:0:0);
	(RAD8 => RD4) = (0:0:0, 0:0:0);
	(RAD9 => RD4) = (0:0:0, 0:0:0);

	(RAD0 => RD5) = (0:0:0, 0:0:0);
	(RAD1 => RD5) = (0:0:0, 0:0:0);
	(RAD2 => RD5) = (0:0:0, 0:0:0);
	(RAD3 => RD5) = (0:0:0, 0:0:0);
	(RAD4 => RD5) = (0:0:0, 0:0:0);
	(RAD5 => RD5) = (0:0:0, 0:0:0);
	(RAD6 => RD5) = (0:0:0, 0:0:0);
	(RAD7 => RD5) = (0:0:0, 0:0:0);
	(RAD8 => RD5) = (0:0:0, 0:0:0);
	(RAD9 => RD5) = (0:0:0, 0:0:0);

	(RAD0 => RD6) = (0:0:0, 0:0:0);
	(RAD1 => RD6) = (0:0:0, 0:0:0);
	(RAD2 => RD6) = (0:0:0, 0:0:0);
	(RAD3 => RD6) = (0:0:0, 0:0:0);
	(RAD4 => RD6) = (0:0:0, 0:0:0);
	(RAD5 => RD6) = (0:0:0, 0:0:0);
	(RAD6 => RD6) = (0:0:0, 0:0:0);
	(RAD7 => RD6) = (0:0:0, 0:0:0);
	(RAD8 => RD6) = (0:0:0, 0:0:0);
	(RAD9 => RD6) = (0:0:0, 0:0:0);

	(RAD0 => RD7) = (0:0:0, 0:0:0);
	(RAD1 => RD7) = (0:0:0, 0:0:0);
	(RAD2 => RD7) = (0:0:0, 0:0:0);
	(RAD3 => RD7) = (0:0:0, 0:0:0);
	(RAD4 => RD7) = (0:0:0, 0:0:0);
	(RAD5 => RD7) = (0:0:0, 0:0:0);
	(RAD6 => RD7) = (0:0:0, 0:0:0);
	(RAD7 => RD7) = (0:0:0, 0:0:0);
	(RAD8 => RD7) = (0:0:0, 0:0:0);
	(RAD9 => RD7) = (0:0:0, 0:0:0);

	(RAD0 => RD8) = (0:0:0, 0:0:0);
	(RAD1 => RD8) = (0:0:0, 0:0:0);
	(RAD2 => RD8) = (0:0:0, 0:0:0);
	(RAD3 => RD8) = (0:0:0, 0:0:0);
	(RAD4 => RD8) = (0:0:0, 0:0:0);
	(RAD5 => RD8) = (0:0:0, 0:0:0);
	(RAD6 => RD8) = (0:0:0, 0:0:0);
	(RAD7 => RD8) = (0:0:0, 0:0:0);
	(RAD8 => RD8) = (0:0:0, 0:0:0);
	(RAD9 => RD8) = (0:0:0, 0:0:0);

	(RAD0 => RD9) = (0:0:0, 0:0:0);
	(RAD1 => RD9) = (0:0:0, 0:0:0);
	(RAD2 => RD9) = (0:0:0, 0:0:0);
	(RAD3 => RD9) = (0:0:0, 0:0:0);
	(RAD4 => RD9) = (0:0:0, 0:0:0);
	(RAD5 => RD9) = (0:0:0, 0:0:0);
	(RAD6 => RD9) = (0:0:0, 0:0:0);
	(RAD7 => RD9) = (0:0:0, 0:0:0);
	(RAD8 => RD9) = (0:0:0, 0:0:0);
	(RAD9 => RD9) = (0:0:0, 0:0:0);

	(RAD0 => RD10) = (0:0:0, 0:0:0);
	(RAD1 => RD10) = (0:0:0, 0:0:0);
	(RAD2 => RD10) = (0:0:0, 0:0:0);
	(RAD3 => RD10) = (0:0:0, 0:0:0);
	(RAD4 => RD10) = (0:0:0, 0:0:0);
	(RAD5 => RD10) = (0:0:0, 0:0:0);
	(RAD6 => RD10) = (0:0:0, 0:0:0);
	(RAD7 => RD10) = (0:0:0, 0:0:0);
	(RAD8 => RD10) = (0:0:0, 0:0:0);
	(RAD9 => RD10) = (0:0:0, 0:0:0);

	(RAD0 => RD11) = (0:0:0, 0:0:0);
	(RAD1 => RD11) = (0:0:0, 0:0:0);
	(RAD2 => RD11) = (0:0:0, 0:0:0);
	(RAD3 => RD11) = (0:0:0, 0:0:0);
	(RAD4 => RD11) = (0:0:0, 0:0:0);
	(RAD5 => RD11) = (0:0:0, 0:0:0);
	(RAD6 => RD11) = (0:0:0, 0:0:0);
	(RAD7 => RD11) = (0:0:0, 0:0:0);
	(RAD8 => RD11) = (0:0:0, 0:0:0);
	(RAD9 => RD11) = (0:0:0, 0:0:0);

	(RAD0 => RD12) = (0:0:0, 0:0:0);
	(RAD1 => RD12) = (0:0:0, 0:0:0);
	(RAD2 => RD12) = (0:0:0, 0:0:0);
	(RAD3 => RD12) = (0:0:0, 0:0:0);
	(RAD4 => RD12) = (0:0:0, 0:0:0);
	(RAD5 => RD12) = (0:0:0, 0:0:0);
	(RAD6 => RD12) = (0:0:0, 0:0:0);
	(RAD7 => RD12) = (0:0:0, 0:0:0);
	(RAD8 => RD12) = (0:0:0, 0:0:0);
	(RAD9 => RD12) = (0:0:0, 0:0:0);

	(RAD0 => RD13) = (0:0:0, 0:0:0);
	(RAD1 => RD13) = (0:0:0, 0:0:0);
	(RAD2 => RD13) = (0:0:0, 0:0:0);
	(RAD3 => RD13) = (0:0:0, 0:0:0);
	(RAD4 => RD13) = (0:0:0, 0:0:0);
	(RAD5 => RD13) = (0:0:0, 0:0:0);
	(RAD6 => RD13) = (0:0:0, 0:0:0);
	(RAD7 => RD13) = (0:0:0, 0:0:0);
	(RAD8 => RD13) = (0:0:0, 0:0:0);
	(RAD9 => RD13) = (0:0:0, 0:0:0);

	(RAD0 => RD14) = (0:0:0, 0:0:0);
	(RAD1 => RD14) = (0:0:0, 0:0:0);
	(RAD2 => RD14) = (0:0:0, 0:0:0);
	(RAD3 => RD14) = (0:0:0, 0:0:0);
	(RAD4 => RD14) = (0:0:0, 0:0:0);
	(RAD5 => RD14) = (0:0:0, 0:0:0);
	(RAD6 => RD14) = (0:0:0, 0:0:0);
	(RAD7 => RD14) = (0:0:0, 0:0:0);
	(RAD8 => RD14) = (0:0:0, 0:0:0);
	(RAD9 => RD14) = (0:0:0, 0:0:0);

	(RAD0 => RD15) = (0:0:0, 0:0:0);
	(RAD1 => RD15) = (0:0:0, 0:0:0);
	(RAD2 => RD15) = (0:0:0, 0:0:0);
	(RAD3 => RD15) = (0:0:0, 0:0:0);
	(RAD4 => RD15) = (0:0:0, 0:0:0);
	(RAD5 => RD15) = (0:0:0, 0:0:0);
	(RAD6 => RD15) = (0:0:0, 0:0:0);
	(RAD7 => RD15) = (0:0:0, 0:0:0);
	(RAD8 => RD15) = (0:0:0, 0:0:0);
	(RAD9 => RD15) = (0:0:0, 0:0:0);

endspecify

endmodule
`endcelldefine
`celldefine
module RAMB16KA_WX16_RX32 (
    WCEN,WCLK,WCS0,WCS1,WE,RST,
    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,
    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,
    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,
    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15,RD16,RD17,RD18,RD19,RD20,RD21,RD22,RD23,RD24,RD25,RD26,RD27,RD28,RD29,RD30,RD31);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8;
output RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15,RD16,RD17,RD18,RD19,RD20,RD21,RD22,RD23,RD24,RD25,RD26,RD27,RD28,RD29,RD30,RD31;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [9:0] wad;
wire [8:0] rad;
wire [1:0] wcs;
wire [15:0] wd;
wire [31:0] rd;
reg notifier;

assign wad = {WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};

assign wcs = {WCS1,WCS0};
assign wd = {WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD31,RD30,RD29,RD28,RD27,RD26,RD25,RD24,RD23,RD22,RD21,RD20,RD19,RD18,RD17,RD16,RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
buf INSXQ8 (RD8,rd[8]);
buf INSXQ9 (RD9,rd[9]);

buf INSXQ10 (RD10,rd[10]);
buf INSXQ11 (RD11,rd[11]);
buf INSXQ12 (RD12,rd[12]);
buf INSXQ13 (RD13,rd[13]);
buf INSXQ14 (RD14,rd[14]);
buf INSXQ15 (RD15,rd[15]);
buf INSXQ16 (RD16,rd[16]);
buf INSXQ17 (RD17,rd[17]);
buf INSXQ18 (RD18,rd[18]);
buf INSXQ19 (RD19,rd[19]);

buf INSXQ20 (RD20,rd[20]);
buf INSXQ21 (RD21,rd[21]);
buf INSXQ22 (RD22,rd[22]);
buf INSXQ23 (RD23,rd[23]);
buf INSXQ24 (RD24,rd[24]);
buf INSXQ25 (RD25,rd[25]);
buf INSXQ26 (RD26,rd[26]);
buf INSXQ27 (RD27,rd[27]);
buf INSXQ28 (RD28,rd[28]);
buf INSXQ29 (RD29,rd[29]);

buf INSXQ30 (RD30,rd[30]);
buf INSXQ31 (RD31,rd[31]);

defparam RAM_U0.WDATA_WIDTH=16;
defparam RAM_U0.WADDR_WIDTH=10;
defparam RAM_U0.RDATA_WIDTH=32;
defparam RAM_U0.RADDR_WIDTH=9;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);
	$setuphold  (posedge WCLK, WD8, 1, 0);
	$setuphold  (posedge WCLK, WD9, 1, 0);
	$setuphold  (posedge WCLK, WD10, 1, 0);
	$setuphold  (posedge WCLK, WD11, 1, 0);
	$setuphold  (posedge WCLK, WD12, 1, 0);
	$setuphold  (posedge WCLK, WD13, 1, 0);
	$setuphold  (posedge WCLK, WD14, 1, 0);
	$setuphold  (posedge WCLK, WD15, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);
	(RST => RD8) = (0:0:0, 0:0:0);
	(RST => RD9) = (0:0:0, 0:0:0);
	(RST => RD10) = (0:0:0, 0:0:0);
	(RST => RD11) = (0:0:0, 0:0:0);
	(RST => RD12) = (0:0:0, 0:0:0);
	(RST => RD13) = (0:0:0, 0:0:0);
	(RST => RD14) = (0:0:0, 0:0:0);
	(RST => RD15) = (0:0:0, 0:0:0);
	(RST => RD16) = (0:0:0, 0:0:0);
	(RST => RD17) = (0:0:0, 0:0:0);
	(RST => RD18) = (0:0:0, 0:0:0);
	(RST => RD19) = (0:0:0, 0:0:0);
	(RST => RD20) = (0:0:0, 0:0:0);
	(RST => RD21) = (0:0:0, 0:0:0);
	(RST => RD22) = (0:0:0, 0:0:0);
	(RST => RD23) = (0:0:0, 0:0:0);
	(RST => RD24) = (0:0:0, 0:0:0);
	(RST => RD25) = (0:0:0, 0:0:0);
	(RST => RD26) = (0:0:0, 0:0:0);
	(RST => RD27) = (0:0:0, 0:0:0);
	(RST => RD28) = (0:0:0, 0:0:0);
	(RST => RD29) = (0:0:0, 0:0:0);
	(RST => RD30) = (0:0:0, 0:0:0);
	(RST => RD31) = (0:0:0, 0:0:0);

	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD1) = (0:0:0, 0:0:0);
	(RAD1 => RD1) = (0:0:0, 0:0:0);
	(RAD2 => RD1) = (0:0:0, 0:0:0);
	(RAD3 => RD1) = (0:0:0, 0:0:0);
	(RAD4 => RD1) = (0:0:0, 0:0:0);
	(RAD5 => RD1) = (0:0:0, 0:0:0);
	(RAD6 => RD1) = (0:0:0, 0:0:0);
	(RAD7 => RD1) = (0:0:0, 0:0:0);
	(RAD8 => RD1) = (0:0:0, 0:0:0);

	(RAD0 => RD2) = (0:0:0, 0:0:0);
	(RAD1 => RD2) = (0:0:0, 0:0:0);
	(RAD2 => RD2) = (0:0:0, 0:0:0);
	(RAD3 => RD2) = (0:0:0, 0:0:0);
	(RAD4 => RD2) = (0:0:0, 0:0:0);
	(RAD5 => RD2) = (0:0:0, 0:0:0);
	(RAD6 => RD2) = (0:0:0, 0:0:0);
	(RAD7 => RD2) = (0:0:0, 0:0:0);
	(RAD8 => RD2) = (0:0:0, 0:0:0);

	(RAD0 => RD3) = (0:0:0, 0:0:0);
	(RAD1 => RD3) = (0:0:0, 0:0:0);
	(RAD2 => RD3) = (0:0:0, 0:0:0);
	(RAD3 => RD3) = (0:0:0, 0:0:0);
	(RAD4 => RD3) = (0:0:0, 0:0:0);
	(RAD5 => RD3) = (0:0:0, 0:0:0);
	(RAD6 => RD3) = (0:0:0, 0:0:0);
	(RAD7 => RD3) = (0:0:0, 0:0:0);
	(RAD8 => RD3) = (0:0:0, 0:0:0);

	(RAD0 => RD4) = (0:0:0, 0:0:0);
	(RAD1 => RD4) = (0:0:0, 0:0:0);
	(RAD2 => RD4) = (0:0:0, 0:0:0);
	(RAD3 => RD4) = (0:0:0, 0:0:0);
	(RAD4 => RD4) = (0:0:0, 0:0:0);
	(RAD5 => RD4) = (0:0:0, 0:0:0);
	(RAD6 => RD4) = (0:0:0, 0:0:0);
	(RAD7 => RD4) = (0:0:0, 0:0:0);
	(RAD8 => RD4) = (0:0:0, 0:0:0);

	(RAD0 => RD5) = (0:0:0, 0:0:0);
	(RAD1 => RD5) = (0:0:0, 0:0:0);
	(RAD2 => RD5) = (0:0:0, 0:0:0);
	(RAD3 => RD5) = (0:0:0, 0:0:0);
	(RAD4 => RD5) = (0:0:0, 0:0:0);
	(RAD5 => RD5) = (0:0:0, 0:0:0);
	(RAD6 => RD5) = (0:0:0, 0:0:0);
	(RAD7 => RD5) = (0:0:0, 0:0:0);
	(RAD8 => RD5) = (0:0:0, 0:0:0);

	(RAD0 => RD6) = (0:0:0, 0:0:0);
	(RAD1 => RD6) = (0:0:0, 0:0:0);
	(RAD2 => RD6) = (0:0:0, 0:0:0);
	(RAD3 => RD6) = (0:0:0, 0:0:0);
	(RAD4 => RD6) = (0:0:0, 0:0:0);
	(RAD5 => RD6) = (0:0:0, 0:0:0);
	(RAD6 => RD6) = (0:0:0, 0:0:0);
	(RAD7 => RD6) = (0:0:0, 0:0:0);
	(RAD8 => RD6) = (0:0:0, 0:0:0);

	(RAD0 => RD7) = (0:0:0, 0:0:0);
	(RAD1 => RD7) = (0:0:0, 0:0:0);
	(RAD2 => RD7) = (0:0:0, 0:0:0);
	(RAD3 => RD7) = (0:0:0, 0:0:0);
	(RAD4 => RD7) = (0:0:0, 0:0:0);
	(RAD5 => RD7) = (0:0:0, 0:0:0);
	(RAD6 => RD7) = (0:0:0, 0:0:0);
	(RAD7 => RD7) = (0:0:0, 0:0:0);
	(RAD8 => RD7) = (0:0:0, 0:0:0);

	(RAD0 => RD8) = (0:0:0, 0:0:0);
	(RAD1 => RD8) = (0:0:0, 0:0:0);
	(RAD2 => RD8) = (0:0:0, 0:0:0);
	(RAD3 => RD8) = (0:0:0, 0:0:0);
	(RAD4 => RD8) = (0:0:0, 0:0:0);
	(RAD5 => RD8) = (0:0:0, 0:0:0);
	(RAD6 => RD8) = (0:0:0, 0:0:0);
	(RAD7 => RD8) = (0:0:0, 0:0:0);
	(RAD8 => RD8) = (0:0:0, 0:0:0);

	(RAD0 => RD9) = (0:0:0, 0:0:0);
	(RAD1 => RD9) = (0:0:0, 0:0:0);
	(RAD2 => RD9) = (0:0:0, 0:0:0);
	(RAD3 => RD9) = (0:0:0, 0:0:0);
	(RAD4 => RD9) = (0:0:0, 0:0:0);
	(RAD5 => RD9) = (0:0:0, 0:0:0);
	(RAD6 => RD9) = (0:0:0, 0:0:0);
	(RAD7 => RD9) = (0:0:0, 0:0:0);
	(RAD8 => RD9) = (0:0:0, 0:0:0);

	(RAD0 => RD10) = (0:0:0, 0:0:0);
	(RAD1 => RD10) = (0:0:0, 0:0:0);
	(RAD2 => RD10) = (0:0:0, 0:0:0);
	(RAD3 => RD10) = (0:0:0, 0:0:0);
	(RAD4 => RD10) = (0:0:0, 0:0:0);
	(RAD5 => RD10) = (0:0:0, 0:0:0);
	(RAD6 => RD10) = (0:0:0, 0:0:0);
	(RAD7 => RD10) = (0:0:0, 0:0:0);
	(RAD8 => RD10) = (0:0:0, 0:0:0);

	(RAD0 => RD11) = (0:0:0, 0:0:0);
	(RAD1 => RD11) = (0:0:0, 0:0:0);
	(RAD2 => RD11) = (0:0:0, 0:0:0);
	(RAD3 => RD11) = (0:0:0, 0:0:0);
	(RAD4 => RD11) = (0:0:0, 0:0:0);
	(RAD5 => RD11) = (0:0:0, 0:0:0);
	(RAD6 => RD11) = (0:0:0, 0:0:0);
	(RAD7 => RD11) = (0:0:0, 0:0:0);
	(RAD8 => RD11) = (0:0:0, 0:0:0);

	(RAD0 => RD12) = (0:0:0, 0:0:0);
	(RAD1 => RD12) = (0:0:0, 0:0:0);
	(RAD2 => RD12) = (0:0:0, 0:0:0);
	(RAD3 => RD12) = (0:0:0, 0:0:0);
	(RAD4 => RD12) = (0:0:0, 0:0:0);
	(RAD5 => RD12) = (0:0:0, 0:0:0);
	(RAD6 => RD12) = (0:0:0, 0:0:0);
	(RAD7 => RD12) = (0:0:0, 0:0:0);
	(RAD8 => RD12) = (0:0:0, 0:0:0);

	(RAD0 => RD13) = (0:0:0, 0:0:0);
	(RAD1 => RD13) = (0:0:0, 0:0:0);
	(RAD2 => RD13) = (0:0:0, 0:0:0);
	(RAD3 => RD13) = (0:0:0, 0:0:0);
	(RAD4 => RD13) = (0:0:0, 0:0:0);
	(RAD5 => RD13) = (0:0:0, 0:0:0);
	(RAD6 => RD13) = (0:0:0, 0:0:0);
	(RAD7 => RD13) = (0:0:0, 0:0:0);
	(RAD8 => RD13) = (0:0:0, 0:0:0);

	(RAD0 => RD14) = (0:0:0, 0:0:0);
	(RAD1 => RD14) = (0:0:0, 0:0:0);
	(RAD2 => RD14) = (0:0:0, 0:0:0);
	(RAD3 => RD14) = (0:0:0, 0:0:0);
	(RAD4 => RD14) = (0:0:0, 0:0:0);
	(RAD5 => RD14) = (0:0:0, 0:0:0);
	(RAD6 => RD14) = (0:0:0, 0:0:0);
	(RAD7 => RD14) = (0:0:0, 0:0:0);
	(RAD8 => RD14) = (0:0:0, 0:0:0);

	(RAD0 => RD15) = (0:0:0, 0:0:0);
	(RAD1 => RD15) = (0:0:0, 0:0:0);
	(RAD2 => RD15) = (0:0:0, 0:0:0);
	(RAD3 => RD15) = (0:0:0, 0:0:0);
	(RAD4 => RD15) = (0:0:0, 0:0:0);
	(RAD5 => RD15) = (0:0:0, 0:0:0);
	(RAD6 => RD15) = (0:0:0, 0:0:0);
	(RAD7 => RD15) = (0:0:0, 0:0:0);
	(RAD8 => RD15) = (0:0:0, 0:0:0);

	(RAD0 => RD16) = (0:0:0, 0:0:0);
	(RAD1 => RD16) = (0:0:0, 0:0:0);
	(RAD2 => RD16) = (0:0:0, 0:0:0);
	(RAD3 => RD16) = (0:0:0, 0:0:0);
	(RAD4 => RD16) = (0:0:0, 0:0:0);
	(RAD5 => RD16) = (0:0:0, 0:0:0);
	(RAD6 => RD16) = (0:0:0, 0:0:0);
	(RAD7 => RD16) = (0:0:0, 0:0:0);
	(RAD8 => RD16) = (0:0:0, 0:0:0);

	(RAD0 => RD17) = (0:0:0, 0:0:0);
	(RAD1 => RD17) = (0:0:0, 0:0:0);
	(RAD2 => RD17) = (0:0:0, 0:0:0);
	(RAD3 => RD17) = (0:0:0, 0:0:0);
	(RAD4 => RD17) = (0:0:0, 0:0:0);
	(RAD5 => RD17) = (0:0:0, 0:0:0);
	(RAD6 => RD17) = (0:0:0, 0:0:0);
	(RAD7 => RD17) = (0:0:0, 0:0:0);
	(RAD8 => RD17) = (0:0:0, 0:0:0);

	(RAD0 => RD18) = (0:0:0, 0:0:0);
	(RAD1 => RD18) = (0:0:0, 0:0:0);
	(RAD2 => RD18) = (0:0:0, 0:0:0);
	(RAD3 => RD18) = (0:0:0, 0:0:0);
	(RAD4 => RD18) = (0:0:0, 0:0:0);
	(RAD5 => RD18) = (0:0:0, 0:0:0);
	(RAD6 => RD18) = (0:0:0, 0:0:0);
	(RAD7 => RD18) = (0:0:0, 0:0:0);
	(RAD8 => RD18) = (0:0:0, 0:0:0);

	(RAD0 => RD19) = (0:0:0, 0:0:0);
	(RAD1 => RD19) = (0:0:0, 0:0:0);
	(RAD2 => RD19) = (0:0:0, 0:0:0);
	(RAD3 => RD19) = (0:0:0, 0:0:0);
	(RAD4 => RD19) = (0:0:0, 0:0:0);
	(RAD5 => RD19) = (0:0:0, 0:0:0);
	(RAD6 => RD19) = (0:0:0, 0:0:0);
	(RAD7 => RD19) = (0:0:0, 0:0:0);
	(RAD8 => RD19) = (0:0:0, 0:0:0);

	(RAD0 => RD20) = (0:0:0, 0:0:0);
	(RAD1 => RD20) = (0:0:0, 0:0:0);
	(RAD2 => RD20) = (0:0:0, 0:0:0);
	(RAD3 => RD20) = (0:0:0, 0:0:0);
	(RAD4 => RD20) = (0:0:0, 0:0:0);
	(RAD5 => RD20) = (0:0:0, 0:0:0);
	(RAD6 => RD20) = (0:0:0, 0:0:0);
	(RAD7 => RD20) = (0:0:0, 0:0:0);
	(RAD8 => RD20) = (0:0:0, 0:0:0);

	(RAD0 => RD21) = (0:0:0, 0:0:0);
	(RAD1 => RD21) = (0:0:0, 0:0:0);
	(RAD2 => RD21) = (0:0:0, 0:0:0);
	(RAD3 => RD21) = (0:0:0, 0:0:0);
	(RAD4 => RD21) = (0:0:0, 0:0:0);
	(RAD5 => RD21) = (0:0:0, 0:0:0);
	(RAD6 => RD21) = (0:0:0, 0:0:0);
	(RAD7 => RD21) = (0:0:0, 0:0:0);
	(RAD8 => RD21) = (0:0:0, 0:0:0);

	(RAD0 => RD22) = (0:0:0, 0:0:0);
	(RAD1 => RD22) = (0:0:0, 0:0:0);
	(RAD2 => RD22) = (0:0:0, 0:0:0);
	(RAD3 => RD22) = (0:0:0, 0:0:0);
	(RAD4 => RD22) = (0:0:0, 0:0:0);
	(RAD5 => RD22) = (0:0:0, 0:0:0);
	(RAD6 => RD22) = (0:0:0, 0:0:0);
	(RAD7 => RD22) = (0:0:0, 0:0:0);
	(RAD8 => RD22) = (0:0:0, 0:0:0);

	(RAD0 => RD23) = (0:0:0, 0:0:0);
	(RAD1 => RD23) = (0:0:0, 0:0:0);
	(RAD2 => RD23) = (0:0:0, 0:0:0);
	(RAD3 => RD23) = (0:0:0, 0:0:0);
	(RAD4 => RD23) = (0:0:0, 0:0:0);
	(RAD5 => RD23) = (0:0:0, 0:0:0);
	(RAD6 => RD23) = (0:0:0, 0:0:0);
	(RAD7 => RD23) = (0:0:0, 0:0:0);
	(RAD8 => RD23) = (0:0:0, 0:0:0);

	(RAD0 => RD24) = (0:0:0, 0:0:0);
	(RAD1 => RD24) = (0:0:0, 0:0:0);
	(RAD2 => RD24) = (0:0:0, 0:0:0);
	(RAD3 => RD24) = (0:0:0, 0:0:0);
	(RAD4 => RD24) = (0:0:0, 0:0:0);
	(RAD5 => RD24) = (0:0:0, 0:0:0);
	(RAD6 => RD24) = (0:0:0, 0:0:0);
	(RAD7 => RD24) = (0:0:0, 0:0:0);
	(RAD8 => RD24) = (0:0:0, 0:0:0);

	(RAD0 => RD25) = (0:0:0, 0:0:0);
	(RAD1 => RD25) = (0:0:0, 0:0:0);
	(RAD2 => RD25) = (0:0:0, 0:0:0);
	(RAD3 => RD25) = (0:0:0, 0:0:0);
	(RAD4 => RD25) = (0:0:0, 0:0:0);
	(RAD5 => RD25) = (0:0:0, 0:0:0);
	(RAD6 => RD25) = (0:0:0, 0:0:0);
	(RAD7 => RD25) = (0:0:0, 0:0:0);
	(RAD8 => RD25) = (0:0:0, 0:0:0);

	(RAD0 => RD26) = (0:0:0, 0:0:0);
	(RAD1 => RD26) = (0:0:0, 0:0:0);
	(RAD2 => RD26) = (0:0:0, 0:0:0);
	(RAD3 => RD26) = (0:0:0, 0:0:0);
	(RAD4 => RD26) = (0:0:0, 0:0:0);
	(RAD5 => RD26) = (0:0:0, 0:0:0);
	(RAD6 => RD26) = (0:0:0, 0:0:0);
	(RAD7 => RD26) = (0:0:0, 0:0:0);
	(RAD8 => RD26) = (0:0:0, 0:0:0);

	(RAD0 => RD27) = (0:0:0, 0:0:0);
	(RAD1 => RD27) = (0:0:0, 0:0:0);
	(RAD2 => RD27) = (0:0:0, 0:0:0);
	(RAD3 => RD27) = (0:0:0, 0:0:0);
	(RAD4 => RD27) = (0:0:0, 0:0:0);
	(RAD5 => RD27) = (0:0:0, 0:0:0);
	(RAD6 => RD27) = (0:0:0, 0:0:0);
	(RAD7 => RD27) = (0:0:0, 0:0:0);
	(RAD8 => RD27) = (0:0:0, 0:0:0);

	(RAD0 => RD28) = (0:0:0, 0:0:0);
	(RAD1 => RD28) = (0:0:0, 0:0:0);
	(RAD2 => RD28) = (0:0:0, 0:0:0);
	(RAD3 => RD28) = (0:0:0, 0:0:0);
	(RAD4 => RD28) = (0:0:0, 0:0:0);
	(RAD5 => RD28) = (0:0:0, 0:0:0);
	(RAD6 => RD28) = (0:0:0, 0:0:0);
	(RAD7 => RD28) = (0:0:0, 0:0:0);
	(RAD8 => RD28) = (0:0:0, 0:0:0);

	(RAD0 => RD29) = (0:0:0, 0:0:0);
	(RAD1 => RD29) = (0:0:0, 0:0:0);
	(RAD2 => RD29) = (0:0:0, 0:0:0);
	(RAD3 => RD29) = (0:0:0, 0:0:0);
	(RAD4 => RD29) = (0:0:0, 0:0:0);
	(RAD5 => RD29) = (0:0:0, 0:0:0);
	(RAD6 => RD29) = (0:0:0, 0:0:0);
	(RAD7 => RD29) = (0:0:0, 0:0:0);
	(RAD8 => RD29) = (0:0:0, 0:0:0);

	(RAD0 => RD30) = (0:0:0, 0:0:0);
	(RAD1 => RD30) = (0:0:0, 0:0:0);
	(RAD2 => RD30) = (0:0:0, 0:0:0);
	(RAD3 => RD30) = (0:0:0, 0:0:0);
	(RAD4 => RD30) = (0:0:0, 0:0:0);
	(RAD5 => RD30) = (0:0:0, 0:0:0);
	(RAD6 => RD30) = (0:0:0, 0:0:0);
	(RAD7 => RD30) = (0:0:0, 0:0:0);
	(RAD8 => RD30) = (0:0:0, 0:0:0);

	(RAD0 => RD31) = (0:0:0, 0:0:0);
	(RAD1 => RD31) = (0:0:0, 0:0:0);
	(RAD2 => RD31) = (0:0:0, 0:0:0);
	(RAD3 => RD31) = (0:0:0, 0:0:0);
	(RAD4 => RD31) = (0:0:0, 0:0:0);
	(RAD5 => RD31) = (0:0:0, 0:0:0);
	(RAD6 => RD31) = (0:0:0, 0:0:0);
	(RAD7 => RD31) = (0:0:0, 0:0:0);
	(RAD8 => RD31) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB16KA_WX32_RX32(WCEN,WCLK,WCS0,WCS1,WE,RST,
                    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,
                    WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,
                    WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23,
                    WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,
                    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,
                    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,
                    RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15,
                    RD16,RD17,RD18,RD19,RD20,RD21,RD22,RD23,
                    RD24,RD25,RD26,RD27,RD28,RD29,RD30,RD31
);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE;
input  RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7;
input  WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15;
input  WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23;
input  WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8;

output  RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7;
output  RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15;
output  RD16,RD17,RD18,RD19,RD20,RD21,RD22,RD23;
output  RD24,RD25,RD26,RD27,RD28,RD29,RD30,RD31;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [8:0] wad;
wire [8:0]  rad;
wire [1:0]  wcs;
wire [31:0] wd;
wire [31:0] rd;
reg notifier;

assign wad = {WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};
assign wcs = {WCS1,WCS0};
assign wd = {WD31,WD30,WD29,WD28,WD27,WD26,WD25,WD24,WD23,WD22,WD21,WD20,WD19,WD18,WD17,WD16,WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD31,RD30,RD29,RD28,RD27,RD26,RD25,RD24,RD23,RD22,RD21,RD20,RD19,RD18,RD17,RD16,RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
buf INSXQ8 (RD8,rd[8]);
buf INSXQ9 (RD9,rd[9]);

buf INSXQ10 (RD10,rd[10]);
buf INSXQ11 (RD11,rd[11]);
buf INSXQ12 (RD12,rd[12]);
buf INSXQ13 (RD13,rd[13]);
buf INSXQ14 (RD14,rd[14]);
buf INSXQ15 (RD15,rd[15]);
buf INSXQ16 (RD16,rd[16]);
buf INSXQ17 (RD17,rd[17]);
buf INSXQ18 (RD18,rd[18]);
buf INSXQ19 (RD19,rd[19]);

buf INSXQ20 (RD20,rd[20]);
buf INSXQ21 (RD21,rd[21]);
buf INSXQ22 (RD22,rd[22]);
buf INSXQ23 (RD23,rd[23]);
buf INSXQ24 (RD24,rd[24]);
buf INSXQ25 (RD25,rd[25]);
buf INSXQ26 (RD26,rd[26]);
buf INSXQ27 (RD27,rd[27]);
buf INSXQ28 (RD28,rd[28]);
buf INSXQ29 (RD29,rd[29]);

buf INSXQ30 (RD30,rd[30]);
buf INSXQ31 (RD31,rd[31]);

defparam RAM_U0.WADDR_WIDTH=9;
defparam RAM_U0.WDATA_WIDTH=32;
defparam RAM_U0.RADDR_WIDTH=9;
defparam RAM_U0.RDATA_WIDTH=32;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));


specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);
	$setuphold  (posedge WCLK, WD8, 1, 0);
	$setuphold  (posedge WCLK, WD9, 1, 0);
	$setuphold  (posedge WCLK, WD10, 1, 0);
	$setuphold  (posedge WCLK, WD11, 1, 0);
	$setuphold  (posedge WCLK, WD12, 1, 0);
	$setuphold  (posedge WCLK, WD13, 1, 0);
	$setuphold  (posedge WCLK, WD14, 1, 0);
	$setuphold  (posedge WCLK, WD15, 1, 0);
	$setuphold  (posedge WCLK, WD16, 1, 0);
	$setuphold  (posedge WCLK, WD17, 1, 0);
	$setuphold  (posedge WCLK, WD18, 1, 0);
	$setuphold  (posedge WCLK, WD19, 1, 0);
	$setuphold  (posedge WCLK, WD20, 1, 0);
	$setuphold  (posedge WCLK, WD21, 1, 0);
	$setuphold  (posedge WCLK, WD22, 1, 0);
	$setuphold  (posedge WCLK, WD23, 1, 0);
	$setuphold  (posedge WCLK, WD24, 1, 0);
	$setuphold  (posedge WCLK, WD25, 1, 0);
	$setuphold  (posedge WCLK, WD26, 1, 0);
	$setuphold  (posedge WCLK, WD27, 1, 0);
	$setuphold  (posedge WCLK, WD28, 1, 0);
	$setuphold  (posedge WCLK, WD29, 1, 0);
	$setuphold  (posedge WCLK, WD30, 1, 0);
	$setuphold  (posedge WCLK, WD31, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1); 

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);
	(RST => RD8) = (0:0:0, 0:0:0);
	(RST => RD9) = (0:0:0, 0:0:0);
	(RST => RD10) = (0:0:0, 0:0:0);
	(RST => RD11) = (0:0:0, 0:0:0);
	(RST => RD12) = (0:0:0, 0:0:0);
	(RST => RD13) = (0:0:0, 0:0:0);
	(RST => RD14) = (0:0:0, 0:0:0);
	(RST => RD15) = (0:0:0, 0:0:0);
	(RST => RD16) = (0:0:0, 0:0:0);
	(RST => RD17) = (0:0:0, 0:0:0);
	(RST => RD18) = (0:0:0, 0:0:0);
	(RST => RD19) = (0:0:0, 0:0:0);
	(RST => RD20) = (0:0:0, 0:0:0);
	(RST => RD21) = (0:0:0, 0:0:0);
	(RST => RD22) = (0:0:0, 0:0:0);
	(RST => RD23) = (0:0:0, 0:0:0);
	(RST => RD24) = (0:0:0, 0:0:0);
	(RST => RD25) = (0:0:0, 0:0:0);
	(RST => RD26) = (0:0:0, 0:0:0);
	(RST => RD27) = (0:0:0, 0:0:0);
	(RST => RD28) = (0:0:0, 0:0:0);
	(RST => RD29) = (0:0:0, 0:0:0);
	(RST => RD30) = (0:0:0, 0:0:0);
	(RST => RD31) = (0:0:0, 0:0:0);


	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD1) = (0:0:0, 0:0:0);
	(RAD1 => RD1) = (0:0:0, 0:0:0);
	(RAD2 => RD1) = (0:0:0, 0:0:0);
	(RAD3 => RD1) = (0:0:0, 0:0:0);
	(RAD4 => RD1) = (0:0:0, 0:0:0);
	(RAD5 => RD1) = (0:0:0, 0:0:0);
	(RAD6 => RD1) = (0:0:0, 0:0:0);
	(RAD7 => RD1) = (0:0:0, 0:0:0);
	(RAD8 => RD1) = (0:0:0, 0:0:0);

	(RAD0 => RD2) = (0:0:0, 0:0:0);
	(RAD1 => RD2) = (0:0:0, 0:0:0);
	(RAD2 => RD2) = (0:0:0, 0:0:0);
	(RAD3 => RD2) = (0:0:0, 0:0:0);
	(RAD4 => RD2) = (0:0:0, 0:0:0);
	(RAD5 => RD2) = (0:0:0, 0:0:0);
	(RAD6 => RD2) = (0:0:0, 0:0:0);
	(RAD7 => RD2) = (0:0:0, 0:0:0);
	(RAD8 => RD2) = (0:0:0, 0:0:0);

	(RAD0 => RD3) = (0:0:0, 0:0:0);
	(RAD1 => RD3) = (0:0:0, 0:0:0);
	(RAD2 => RD3) = (0:0:0, 0:0:0);
	(RAD3 => RD3) = (0:0:0, 0:0:0);
	(RAD4 => RD3) = (0:0:0, 0:0:0);
	(RAD5 => RD3) = (0:0:0, 0:0:0);
	(RAD6 => RD3) = (0:0:0, 0:0:0);
	(RAD7 => RD3) = (0:0:0, 0:0:0);
	(RAD8 => RD3) = (0:0:0, 0:0:0);

	(RAD0 => RD4) = (0:0:0, 0:0:0);
	(RAD1 => RD4) = (0:0:0, 0:0:0);
	(RAD2 => RD4) = (0:0:0, 0:0:0);
	(RAD3 => RD4) = (0:0:0, 0:0:0);
	(RAD4 => RD4) = (0:0:0, 0:0:0);
	(RAD5 => RD4) = (0:0:0, 0:0:0);
	(RAD6 => RD4) = (0:0:0, 0:0:0);
	(RAD7 => RD4) = (0:0:0, 0:0:0);
	(RAD8 => RD4) = (0:0:0, 0:0:0);

	(RAD0 => RD5) = (0:0:0, 0:0:0);
	(RAD1 => RD5) = (0:0:0, 0:0:0);
	(RAD2 => RD5) = (0:0:0, 0:0:0);
	(RAD3 => RD5) = (0:0:0, 0:0:0);
	(RAD4 => RD5) = (0:0:0, 0:0:0);
	(RAD5 => RD5) = (0:0:0, 0:0:0);
	(RAD6 => RD5) = (0:0:0, 0:0:0);
	(RAD7 => RD5) = (0:0:0, 0:0:0);
	(RAD8 => RD5) = (0:0:0, 0:0:0);

	(RAD0 => RD6) = (0:0:0, 0:0:0);
	(RAD1 => RD6) = (0:0:0, 0:0:0);
	(RAD2 => RD6) = (0:0:0, 0:0:0);
	(RAD3 => RD6) = (0:0:0, 0:0:0);
	(RAD4 => RD6) = (0:0:0, 0:0:0);
	(RAD5 => RD6) = (0:0:0, 0:0:0);
	(RAD6 => RD6) = (0:0:0, 0:0:0);
	(RAD7 => RD6) = (0:0:0, 0:0:0);
	(RAD8 => RD6) = (0:0:0, 0:0:0);

	(RAD0 => RD7) = (0:0:0, 0:0:0);
	(RAD1 => RD7) = (0:0:0, 0:0:0);
	(RAD2 => RD7) = (0:0:0, 0:0:0);
	(RAD3 => RD7) = (0:0:0, 0:0:0);
	(RAD4 => RD7) = (0:0:0, 0:0:0);
	(RAD5 => RD7) = (0:0:0, 0:0:0);
	(RAD6 => RD7) = (0:0:0, 0:0:0);
	(RAD7 => RD7) = (0:0:0, 0:0:0);
	(RAD8 => RD7) = (0:0:0, 0:0:0);

	(RAD0 => RD8) = (0:0:0, 0:0:0);
	(RAD1 => RD8) = (0:0:0, 0:0:0);
	(RAD2 => RD8) = (0:0:0, 0:0:0);
	(RAD3 => RD8) = (0:0:0, 0:0:0);
	(RAD4 => RD8) = (0:0:0, 0:0:0);
	(RAD5 => RD8) = (0:0:0, 0:0:0);
	(RAD6 => RD8) = (0:0:0, 0:0:0);
	(RAD7 => RD8) = (0:0:0, 0:0:0);
	(RAD8 => RD8) = (0:0:0, 0:0:0);

	(RAD0 => RD9) = (0:0:0, 0:0:0);
	(RAD1 => RD9) = (0:0:0, 0:0:0);
	(RAD2 => RD9) = (0:0:0, 0:0:0);
	(RAD3 => RD9) = (0:0:0, 0:0:0);
	(RAD4 => RD9) = (0:0:0, 0:0:0);
	(RAD5 => RD9) = (0:0:0, 0:0:0);
	(RAD6 => RD9) = (0:0:0, 0:0:0);
	(RAD7 => RD9) = (0:0:0, 0:0:0);
	(RAD8 => RD9) = (0:0:0, 0:0:0);

	(RAD0 => RD10) = (0:0:0, 0:0:0);
	(RAD1 => RD10) = (0:0:0, 0:0:0);
	(RAD2 => RD10) = (0:0:0, 0:0:0);
	(RAD3 => RD10) = (0:0:0, 0:0:0);
	(RAD4 => RD10) = (0:0:0, 0:0:0);
	(RAD5 => RD10) = (0:0:0, 0:0:0);
	(RAD6 => RD10) = (0:0:0, 0:0:0);
	(RAD7 => RD10) = (0:0:0, 0:0:0);
	(RAD8 => RD10) = (0:0:0, 0:0:0);

	(RAD0 => RD11) = (0:0:0, 0:0:0);
	(RAD1 => RD11) = (0:0:0, 0:0:0);
	(RAD2 => RD11) = (0:0:0, 0:0:0);
	(RAD3 => RD11) = (0:0:0, 0:0:0);
	(RAD4 => RD11) = (0:0:0, 0:0:0);
	(RAD5 => RD11) = (0:0:0, 0:0:0);
	(RAD6 => RD11) = (0:0:0, 0:0:0);
	(RAD7 => RD11) = (0:0:0, 0:0:0);
	(RAD8 => RD11) = (0:0:0, 0:0:0);

	(RAD0 => RD12) = (0:0:0, 0:0:0);
	(RAD1 => RD12) = (0:0:0, 0:0:0);
	(RAD2 => RD12) = (0:0:0, 0:0:0);
	(RAD3 => RD12) = (0:0:0, 0:0:0);
	(RAD4 => RD12) = (0:0:0, 0:0:0);
	(RAD5 => RD12) = (0:0:0, 0:0:0);
	(RAD6 => RD12) = (0:0:0, 0:0:0);
	(RAD7 => RD12) = (0:0:0, 0:0:0);
	(RAD8 => RD12) = (0:0:0, 0:0:0);

	(RAD0 => RD13) = (0:0:0, 0:0:0);
	(RAD1 => RD13) = (0:0:0, 0:0:0);
	(RAD2 => RD13) = (0:0:0, 0:0:0);
	(RAD3 => RD13) = (0:0:0, 0:0:0);
	(RAD4 => RD13) = (0:0:0, 0:0:0);
	(RAD5 => RD13) = (0:0:0, 0:0:0);
	(RAD6 => RD13) = (0:0:0, 0:0:0);
	(RAD7 => RD13) = (0:0:0, 0:0:0);
	(RAD8 => RD13) = (0:0:0, 0:0:0);

	(RAD0 => RD14) = (0:0:0, 0:0:0);
	(RAD1 => RD14) = (0:0:0, 0:0:0);
	(RAD2 => RD14) = (0:0:0, 0:0:0);
	(RAD3 => RD14) = (0:0:0, 0:0:0);
	(RAD4 => RD14) = (0:0:0, 0:0:0);
	(RAD5 => RD14) = (0:0:0, 0:0:0);
	(RAD6 => RD14) = (0:0:0, 0:0:0);
	(RAD7 => RD14) = (0:0:0, 0:0:0);
	(RAD8 => RD14) = (0:0:0, 0:0:0);

	(RAD0 => RD15) = (0:0:0, 0:0:0);
	(RAD1 => RD15) = (0:0:0, 0:0:0);
	(RAD2 => RD15) = (0:0:0, 0:0:0);
	(RAD3 => RD15) = (0:0:0, 0:0:0);
	(RAD4 => RD15) = (0:0:0, 0:0:0);
	(RAD5 => RD15) = (0:0:0, 0:0:0);
	(RAD6 => RD15) = (0:0:0, 0:0:0);
	(RAD7 => RD15) = (0:0:0, 0:0:0);
	(RAD8 => RD15) = (0:0:0, 0:0:0);

	(RAD0 => RD16) = (0:0:0, 0:0:0);
	(RAD1 => RD16) = (0:0:0, 0:0:0);
	(RAD2 => RD16) = (0:0:0, 0:0:0);
	(RAD3 => RD16) = (0:0:0, 0:0:0);
	(RAD4 => RD16) = (0:0:0, 0:0:0);
	(RAD5 => RD16) = (0:0:0, 0:0:0);
	(RAD6 => RD16) = (0:0:0, 0:0:0);
	(RAD7 => RD16) = (0:0:0, 0:0:0);
	(RAD8 => RD16) = (0:0:0, 0:0:0);

	(RAD0 => RD15) = (0:0:0, 0:0:0);
	(RAD1 => RD15) = (0:0:0, 0:0:0);
	(RAD2 => RD15) = (0:0:0, 0:0:0);
	(RAD3 => RD15) = (0:0:0, 0:0:0);
	(RAD4 => RD15) = (0:0:0, 0:0:0);
	(RAD5 => RD15) = (0:0:0, 0:0:0);
	(RAD6 => RD15) = (0:0:0, 0:0:0);
	(RAD7 => RD15) = (0:0:0, 0:0:0);
	(RAD8 => RD15) = (0:0:0, 0:0:0);

	(RAD0 => RD17) = (0:0:0, 0:0:0);
	(RAD1 => RD17) = (0:0:0, 0:0:0);
	(RAD2 => RD17) = (0:0:0, 0:0:0);
	(RAD3 => RD17) = (0:0:0, 0:0:0);
	(RAD4 => RD17) = (0:0:0, 0:0:0);
	(RAD5 => RD17) = (0:0:0, 0:0:0);
	(RAD6 => RD17) = (0:0:0, 0:0:0);
	(RAD7 => RD17) = (0:0:0, 0:0:0);
	(RAD8 => RD17) = (0:0:0, 0:0:0);

	(RAD0 => RD18) = (0:0:0, 0:0:0);
	(RAD1 => RD18) = (0:0:0, 0:0:0);
	(RAD2 => RD18) = (0:0:0, 0:0:0);
	(RAD3 => RD18) = (0:0:0, 0:0:0);
	(RAD4 => RD18) = (0:0:0, 0:0:0);
	(RAD5 => RD18) = (0:0:0, 0:0:0);
	(RAD6 => RD18) = (0:0:0, 0:0:0);
	(RAD7 => RD18) = (0:0:0, 0:0:0);
	(RAD8 => RD18) = (0:0:0, 0:0:0);

	(RAD0 => RD19) = (0:0:0, 0:0:0);
	(RAD1 => RD19) = (0:0:0, 0:0:0);
	(RAD2 => RD19) = (0:0:0, 0:0:0);
	(RAD3 => RD19) = (0:0:0, 0:0:0);
	(RAD4 => RD19) = (0:0:0, 0:0:0);
	(RAD5 => RD19) = (0:0:0, 0:0:0);
	(RAD6 => RD19) = (0:0:0, 0:0:0);
	(RAD7 => RD19) = (0:0:0, 0:0:0);
	(RAD8 => RD19) = (0:0:0, 0:0:0);

	(RAD0 => RD20) = (0:0:0, 0:0:0);
	(RAD1 => RD20) = (0:0:0, 0:0:0);
	(RAD2 => RD20) = (0:0:0, 0:0:0);
	(RAD3 => RD20) = (0:0:0, 0:0:0);
	(RAD4 => RD20) = (0:0:0, 0:0:0);
	(RAD5 => RD20) = (0:0:0, 0:0:0);
	(RAD6 => RD20) = (0:0:0, 0:0:0);
	(RAD7 => RD20) = (0:0:0, 0:0:0);
	(RAD8 => RD20) = (0:0:0, 0:0:0);

	(RAD0 => RD21) = (0:0:0, 0:0:0);
	(RAD1 => RD21) = (0:0:0, 0:0:0);
	(RAD2 => RD21) = (0:0:0, 0:0:0);
	(RAD3 => RD21) = (0:0:0, 0:0:0);
	(RAD4 => RD21) = (0:0:0, 0:0:0);
	(RAD5 => RD21) = (0:0:0, 0:0:0);
	(RAD6 => RD21) = (0:0:0, 0:0:0);
	(RAD7 => RD21) = (0:0:0, 0:0:0);
	(RAD8 => RD21) = (0:0:0, 0:0:0);

	(RAD0 => RD22) = (0:0:0, 0:0:0);
	(RAD1 => RD22) = (0:0:0, 0:0:0);
	(RAD2 => RD22) = (0:0:0, 0:0:0);
	(RAD3 => RD22) = (0:0:0, 0:0:0);
	(RAD4 => RD22) = (0:0:0, 0:0:0);
	(RAD5 => RD22) = (0:0:0, 0:0:0);
	(RAD6 => RD22) = (0:0:0, 0:0:0);
	(RAD7 => RD22) = (0:0:0, 0:0:0);
	(RAD8 => RD22) = (0:0:0, 0:0:0);

	(RAD0 => RD23) = (0:0:0, 0:0:0);
	(RAD1 => RD23) = (0:0:0, 0:0:0);
	(RAD2 => RD23) = (0:0:0, 0:0:0);
	(RAD3 => RD23) = (0:0:0, 0:0:0);
	(RAD4 => RD23) = (0:0:0, 0:0:0);
	(RAD5 => RD23) = (0:0:0, 0:0:0);
	(RAD6 => RD23) = (0:0:0, 0:0:0);
	(RAD7 => RD23) = (0:0:0, 0:0:0);
	(RAD8 => RD23) = (0:0:0, 0:0:0);

	(RAD0 => RD24) = (0:0:0, 0:0:0);
	(RAD1 => RD24) = (0:0:0, 0:0:0);
	(RAD2 => RD24) = (0:0:0, 0:0:0);
	(RAD3 => RD24) = (0:0:0, 0:0:0);
	(RAD4 => RD24) = (0:0:0, 0:0:0);
	(RAD5 => RD24) = (0:0:0, 0:0:0);
	(RAD6 => RD24) = (0:0:0, 0:0:0);
	(RAD7 => RD24) = (0:0:0, 0:0:0);
	(RAD8 => RD24) = (0:0:0, 0:0:0);

	(RAD0 => RD25) = (0:0:0, 0:0:0);
	(RAD1 => RD25) = (0:0:0, 0:0:0);
	(RAD2 => RD25) = (0:0:0, 0:0:0);
	(RAD3 => RD25) = (0:0:0, 0:0:0);
	(RAD4 => RD25) = (0:0:0, 0:0:0);
	(RAD5 => RD25) = (0:0:0, 0:0:0);
	(RAD6 => RD25) = (0:0:0, 0:0:0);
	(RAD7 => RD25) = (0:0:0, 0:0:0);
	(RAD8 => RD25) = (0:0:0, 0:0:0);

	(RAD0 => RD26) = (0:0:0, 0:0:0);
	(RAD1 => RD26) = (0:0:0, 0:0:0);
	(RAD2 => RD26) = (0:0:0, 0:0:0);
	(RAD3 => RD26) = (0:0:0, 0:0:0);
	(RAD4 => RD26) = (0:0:0, 0:0:0);
	(RAD5 => RD26) = (0:0:0, 0:0:0);
	(RAD6 => RD26) = (0:0:0, 0:0:0);
	(RAD7 => RD26) = (0:0:0, 0:0:0);
	(RAD8 => RD26) = (0:0:0, 0:0:0);

	(RAD0 => RD27) = (0:0:0, 0:0:0);
	(RAD1 => RD27) = (0:0:0, 0:0:0);
	(RAD2 => RD27) = (0:0:0, 0:0:0);
	(RAD3 => RD27) = (0:0:0, 0:0:0);
	(RAD4 => RD27) = (0:0:0, 0:0:0);
	(RAD5 => RD27) = (0:0:0, 0:0:0);
	(RAD6 => RD27) = (0:0:0, 0:0:0);
	(RAD7 => RD27) = (0:0:0, 0:0:0);
	(RAD8 => RD27) = (0:0:0, 0:0:0);

	(RAD0 => RD28) = (0:0:0, 0:0:0);
	(RAD1 => RD28) = (0:0:0, 0:0:0);
	(RAD2 => RD28) = (0:0:0, 0:0:0);
	(RAD3 => RD28) = (0:0:0, 0:0:0);
	(RAD4 => RD28) = (0:0:0, 0:0:0);
	(RAD5 => RD28) = (0:0:0, 0:0:0);
	(RAD6 => RD28) = (0:0:0, 0:0:0);
	(RAD7 => RD28) = (0:0:0, 0:0:0);
	(RAD8 => RD28) = (0:0:0, 0:0:0);

	(RAD0 => RD29) = (0:0:0, 0:0:0);
	(RAD1 => RD29) = (0:0:0, 0:0:0);
	(RAD2 => RD29) = (0:0:0, 0:0:0);
	(RAD3 => RD29) = (0:0:0, 0:0:0);
	(RAD4 => RD29) = (0:0:0, 0:0:0);
	(RAD5 => RD29) = (0:0:0, 0:0:0);
	(RAD6 => RD29) = (0:0:0, 0:0:0);
	(RAD7 => RD29) = (0:0:0, 0:0:0);
	(RAD8 => RD29) = (0:0:0, 0:0:0);

	(RAD0 => RD30) = (0:0:0, 0:0:0);
	(RAD1 => RD30) = (0:0:0, 0:0:0);
	(RAD2 => RD30) = (0:0:0, 0:0:0);
	(RAD3 => RD30) = (0:0:0, 0:0:0);
	(RAD4 => RD30) = (0:0:0, 0:0:0);
	(RAD5 => RD30) = (0:0:0, 0:0:0);
	(RAD6 => RD30) = (0:0:0, 0:0:0);
	(RAD7 => RD30) = (0:0:0, 0:0:0);
	(RAD8 => RD30) = (0:0:0, 0:0:0);

	(RAD0 => RD31) = (0:0:0, 0:0:0);
	(RAD1 => RD31) = (0:0:0, 0:0:0);
	(RAD2 => RD31) = (0:0:0, 0:0:0);
	(RAD3 => RD31) = (0:0:0, 0:0:0);
	(RAD4 => RD31) = (0:0:0, 0:0:0);
	(RAD5 => RD31) = (0:0:0, 0:0:0);
	(RAD6 => RD31) = (0:0:0, 0:0:0);
	(RAD7 => RD31) = (0:0:0, 0:0:0);
	(RAD8 => RD31) = (0:0:0, 0:0:0);

endspecify

endmodule
`endcelldefine
`celldefine
module RAMB16KA_X1(CEN,CLK,WR,CS0,CS1,RST,DI0,AD0,AD1,AD2,AD3,AD4,AD5,AD6,AD7,AD8,AD9,AD10,AD11,AD12,AD13,DO0);

parameter RAM_INIT_FILE = "";

input  CEN;
input  CLK;
input  WR;
input  CS0;
input  CS1;
input  RST;
input  AD0;
input  AD1;
input  AD2;
input  AD3;
input  AD4;
input  AD5;
input  AD6;
input  AD7;
input  AD8;
input  AD9;
input  AD10;
input  AD11;
input  AD12;
input  AD13;
input  DI0;

output DO0;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [0:0] di;
wire [0:0] do;
wire [13:0] ad;
wire [1:0] cs;
reg notifier;

assign di = {DI0};
//assign {DO0} = do;
buf INSXQ (DO0,do);
assign ad = {AD13,AD12,AD11,AD10,AD9,AD8,AD7,AD6,AD5,AD4,AD3,AD2,AD1,AD0};
assign cs = {CS1,CS0};

defparam RAM_U0.ADDR_WIDTH = 14;
defparam RAM_U0.DATA_WIDTH = 1;

defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_SPRAMA_16K RAM_U0(
		.CEN(CEN),
		.CLK(CLK),
		.WR(WR),
		.CS(cs),
		.RST(RST),
		.DI(di),
		.AD(ad),
		.DO(do)
		);

specify
	$width (posedge CLK, 1, 0, notifier);
	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge CLK, DI0, 1, 0);

	$setuphold  (posedge CLK, WR, 1, 0);
	$setuphold  (posedge CLK, CEN, 1, 0);
	$setuphold  (posedge CLK, CS0, 1, 0);
	$setuphold  (posedge CLK, CS1, 1, 0);

	$setuphold  (posedge CLK, AD0, 1, 0);
	$setuphold  (posedge CLK, AD1, 1, 0);
	$setuphold  (posedge CLK, AD2, 1, 0);
	$setuphold  (posedge CLK, AD3, 1, 0);
	$setuphold  (posedge CLK, AD4, 1, 0);
	$setuphold  (posedge CLK, AD5, 1, 0);
	$setuphold  (posedge CLK, AD6, 1, 0);
	$setuphold  (posedge CLK, AD7, 1, 0);
	$setuphold  (posedge CLK, AD8, 1, 0);
	$setuphold  (posedge CLK, AD9, 1, 0);
	$setuphold  (posedge CLK, AD10, 1, 0);
	$setuphold  (posedge CLK, AD11, 1, 0);
	$setuphold  (posedge CLK, AD12, 1, 0);
	$setuphold  (posedge CLK, AD13, 1, 0);

        $recovery(posedge RST, posedge CLK, 1); 

	(AD0 => DO0) = (0:0:0, 0:0:0);
	(AD1 => DO0) = (0:0:0, 0:0:0);
	(AD2 => DO0) = (0:0:0, 0:0:0);
	(AD3 => DO0) = (0:0:0, 0:0:0);
	(AD4 => DO0) = (0:0:0, 0:0:0);
	(AD5 => DO0) = (0:0:0, 0:0:0);
	(AD6 => DO0) = (0:0:0, 0:0:0);
	(AD7 => DO0) = (0:0:0, 0:0:0);
	(AD8 => DO0) = (0:0:0, 0:0:0);
	(AD9 => DO0) = (0:0:0, 0:0:0);
	(AD10 => DO0) = (0:0:0, 0:0:0);
	(AD11 => DO0) = (0:0:0, 0:0:0);
	(AD12 => DO0) = (0:0:0, 0:0:0);
	(AD13 => DO0) = (0:0:0, 0:0:0);

	(RST => DO0) = (0:0:0, 0:0:0);
	(CLK => DO0) = (2:2:2, 2:2:2);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16KA_X2(CEN,CLK,WR,CS0,CS1,RST,
                  DI0,DI1,
                  AD0,AD1,AD2,AD3,AD4,AD5,AD6,AD7,AD8,AD9,AD10,AD11,AD12,
                  DO0,DO1);

parameter RAM_INIT_FILE = "";

input  CEN;
input  CLK;
input  WR;
input  CS0;
input  CS1;
input  RST;
input  AD0;
input  AD1;
input  AD2;
input  AD3;
input  AD4;
input  AD5;
input  AD6;
input  AD7;
input  AD8;
input  AD9;
input  AD10;
input  AD11;
input  AD12;
input  DI0;
input  DI1;

output DO0;
output DO1;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [1:0] di;
wire [1:0] do;
wire [12:0] ad;
wire [1:0] cs;
reg notifier;

assign cs = {CS1,CS0};

assign di = {DI1,DI0};
//assign {DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
assign ad = {AD12,AD11,AD10,AD9,AD8,AD7,AD6,AD5,AD4,AD3,AD2,AD1,AD0};

defparam RAM_U0.ADDR_WIDTH = 13;
defparam RAM_U0.DATA_WIDTH = 2;

defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_SPRAMA_16K RAM_U0(
		.CEN(CEN),
		.CLK(CLK),
		.WR(WR),
		.CS(cs),
		.RST(RST),
		.DI(di),
		.AD(ad),
		.DO(do)
		);


specify
	$width (posedge CLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge CLK, DI0, 1, 0);
	$setuphold  (posedge CLK, DI1, 1, 0);

	$setuphold  (posedge CLK, WR, 1, 0);
	$setuphold  (posedge CLK, CEN, 1, 0);
	$setuphold  (posedge CLK, CS0, 1, 0);
	$setuphold  (posedge CLK, CS1, 1, 0);

	$setuphold  (posedge CLK, AD0, 1, 0);
	$setuphold  (posedge CLK, AD1, 1, 0);
	$setuphold  (posedge CLK, AD2, 1, 0);
	$setuphold  (posedge CLK, AD3, 1, 0);
	$setuphold  (posedge CLK, AD4, 1, 0);
	$setuphold  (posedge CLK, AD5, 1, 0);
	$setuphold  (posedge CLK, AD6, 1, 0);
	$setuphold  (posedge CLK, AD7, 1, 0);
	$setuphold  (posedge CLK, AD8, 1, 0);
	$setuphold  (posedge CLK, AD9, 1, 0);
	$setuphold  (posedge CLK, AD10, 1, 0);
	$setuphold  (posedge CLK, AD11, 1, 0);
	$setuphold  (posedge CLK, AD12, 1, 0);

        $recovery(posedge RST, posedge CLK, 1); 

	(AD0 => DO0) = (0:0:0, 0:0:0);
	(AD1 => DO0) = (0:0:0, 0:0:0);
	(AD2 => DO0) = (0:0:0, 0:0:0);
	(AD3 => DO0) = (0:0:0, 0:0:0);
	(AD4 => DO0) = (0:0:0, 0:0:0);
	(AD5 => DO0) = (0:0:0, 0:0:0);
	(AD6 => DO0) = (0:0:0, 0:0:0);
	(AD7 => DO0) = (0:0:0, 0:0:0);
	(AD8 => DO0) = (0:0:0, 0:0:0);
	(AD9 => DO0) = (0:0:0, 0:0:0);
	(AD10 => DO0) = (0:0:0, 0:0:0);
	(AD11 => DO0) = (0:0:0, 0:0:0);
	(AD12 => DO0) = (0:0:0, 0:0:0);

	(AD0 => DO1) = (0:0:0, 0:0:0);
	(AD1 => DO1) = (0:0:0, 0:0:0);
	(AD2 => DO1) = (0:0:0, 0:0:0);
	(AD3 => DO1) = (0:0:0, 0:0:0);
	(AD4 => DO1) = (0:0:0, 0:0:0);
	(AD5 => DO1) = (0:0:0, 0:0:0);
	(AD6 => DO1) = (0:0:0, 0:0:0);
	(AD7 => DO1) = (0:0:0, 0:0:0);
	(AD8 => DO1) = (0:0:0, 0:0:0);
	(AD9 => DO1) = (0:0:0, 0:0:0);
	(AD10 => DO1) = (0:0:0, 0:0:0);
	(AD11 => DO1) = (0:0:0, 0:0:0);
	(AD12 => DO1) = (0:0:0, 0:0:0);

	(RST => DO0) = (0:0:0, 0:0:0);
	(RST => DO1) = (0:0:0, 0:0:0);

	(CLK => DO0) = (2:2:2, 2:2:2);
	(CLK => DO1) = (2:2:2, 2:2:2);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16KA_X4(CEN,CLK,WR,CS0,CS1,RST,
                  DI0,DI1,DI2,DI3,
                  AD0,AD1,AD2,AD3,AD4,AD5,AD6,AD7,AD8,AD9,AD10,AD11,
                  DO0,DO1,DO2,DO3);

parameter RAM_INIT_FILE = "";

input  CEN;
input  CLK;
input  WR;
input  CS0;
input  CS1;
input  RST;
input  AD0;
input  AD1;
input  AD2;
input  AD3;
input  AD4;
input  AD5;
input  AD6;
input  AD7;
input  AD8;
input  AD9;
input  AD10;
input  AD11;
input  DI0;
input  DI1;
input  DI2;
input  DI3;

output DO0;
output DO1;
output DO2;
output DO3;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [3:0] di;
wire [3:0] do;
wire [11:0] ad;
wire [1:0] cs;
reg notifier;

assign cs = {CS1,CS0};
assign di = {DI3,DI2,DI1,DI0};
//assign {DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]); 
assign ad = {AD11,AD10,AD9,AD8,AD7,AD6,AD5,AD4,AD3,AD2,AD1,AD0};

defparam RAM_U0.ADDR_WIDTH = 12;
defparam RAM_U0.DATA_WIDTH = 4;

defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_SPRAMA_16K RAM_U0(
		.CEN(CEN),
		.CLK(CLK),
		.WR(WR),
		.CS(cs),
		.RST(RST),
		.DI(di),
		.AD(ad),
		.DO(do)
		);

specify
	$width (posedge CLK, 1, 0, notifier);
	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge CLK, DI0, 1, 0);
	$setuphold  (posedge CLK, DI1, 1, 0);
	$setuphold  (posedge CLK, DI2, 1, 0);
	$setuphold  (posedge CLK, DI3, 1, 0);

	$setuphold  (posedge CLK, WR, 1, 0);
	$setuphold  (posedge CLK, CEN, 1, 0);
	$setuphold  (posedge CLK, CS0, 1, 0);
	$setuphold  (posedge CLK, CS1, 1, 0);

	$setuphold  (posedge CLK, AD0, 1, 0);
	$setuphold  (posedge CLK, AD1, 1, 0);
	$setuphold  (posedge CLK, AD2, 1, 0);
	$setuphold  (posedge CLK, AD3, 1, 0);
	$setuphold  (posedge CLK, AD4, 1, 0);
	$setuphold  (posedge CLK, AD5, 1, 0);
	$setuphold  (posedge CLK, AD6, 1, 0);
	$setuphold  (posedge CLK, AD7, 1, 0);
	$setuphold  (posedge CLK, AD8, 1, 0);
	$setuphold  (posedge CLK, AD9, 1, 0);
	$setuphold  (posedge CLK, AD10, 1, 0);
	$setuphold  (posedge CLK, AD11, 1, 0);

        $recovery(posedge RST, posedge CLK, 1); 

	(AD0 => DO0) = (0:0:0, 0:0:0);
	(AD1 => DO0) = (0:0:0, 0:0:0);
	(AD2 => DO0) = (0:0:0, 0:0:0);
	(AD3 => DO0) = (0:0:0, 0:0:0);
	(AD4 => DO0) = (0:0:0, 0:0:0);
	(AD5 => DO0) = (0:0:0, 0:0:0);
	(AD6 => DO0) = (0:0:0, 0:0:0);
	(AD7 => DO0) = (0:0:0, 0:0:0);
	(AD8 => DO0) = (0:0:0, 0:0:0);
	(AD9 => DO0) = (0:0:0, 0:0:0);
	(AD10 => DO0) = (0:0:0, 0:0:0);
	(AD11 => DO0) = (0:0:0, 0:0:0);

	(AD0 => DO1) = (0:0:0, 0:0:0);
	(AD1 => DO1) = (0:0:0, 0:0:0);
	(AD2 => DO1) = (0:0:0, 0:0:0);
	(AD3 => DO1) = (0:0:0, 0:0:0);
	(AD4 => DO1) = (0:0:0, 0:0:0);
	(AD5 => DO1) = (0:0:0, 0:0:0);
	(AD6 => DO1) = (0:0:0, 0:0:0);
	(AD7 => DO1) = (0:0:0, 0:0:0);
	(AD8 => DO1) = (0:0:0, 0:0:0);
	(AD9 => DO1) = (0:0:0, 0:0:0);
	(AD10 => DO1) = (0:0:0, 0:0:0);
	(AD11 => DO1) = (0:0:0, 0:0:0);

	(AD0 => DO2) = (0:0:0, 0:0:0);
	(AD1 => DO2) = (0:0:0, 0:0:0);
	(AD2 => DO2) = (0:0:0, 0:0:0);
	(AD3 => DO2) = (0:0:0, 0:0:0);
	(AD4 => DO2) = (0:0:0, 0:0:0);
	(AD5 => DO2) = (0:0:0, 0:0:0);
	(AD6 => DO2) = (0:0:0, 0:0:0);
	(AD7 => DO2) = (0:0:0, 0:0:0);
	(AD8 => DO2) = (0:0:0, 0:0:0);
	(AD9 => DO2) = (0:0:0, 0:0:0);
	(AD10 => DO2) = (0:0:0, 0:0:0);
	(AD11 => DO2) = (0:0:0, 0:0:0);

	(AD0 => DO3) = (0:0:0, 0:0:0);
	(AD1 => DO3) = (0:0:0, 0:0:0);
	(AD2 => DO3) = (0:0:0, 0:0:0);
	(AD3 => DO3) = (0:0:0, 0:0:0);
	(AD4 => DO3) = (0:0:0, 0:0:0);
	(AD5 => DO3) = (0:0:0, 0:0:0);
	(AD6 => DO3) = (0:0:0, 0:0:0);
	(AD7 => DO3) = (0:0:0, 0:0:0);
	(AD8 => DO3) = (0:0:0, 0:0:0);
	(AD9 => DO3) = (0:0:0, 0:0:0);
	(AD10 => DO3) = (0:0:0, 0:0:0);
	(AD11 => DO3) = (0:0:0, 0:0:0);

	(RST => DO0) = (0:0:0, 0:0:0);
	(RST => DO1) = (0:0:0, 0:0:0);
	(RST => DO2) = (0:0:0, 0:0:0);
	(RST => DO3) = (0:0:0, 0:0:0);

	(CLK => DO0) = (0:0:0, 0:0:0);
	(CLK => DO1) = (0:0:0, 0:0:0);
	(CLK => DO2) = (0:0:0, 0:0:0);
	(CLK => DO3) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16KA_X8(CEN,CLK,WR,CS0,CS1,RST,
                  DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,
                  AD0,AD1,AD2,AD3,AD4,AD5,AD6,AD7,AD8,AD9,AD10,
                  DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7
 );

parameter RAM_INIT_FILE = "";

input  CEN;
input  CLK;
input  WR;
input  CS0;
input  CS1;
input  RST;
input  AD0;
input  AD1;
input  AD2;
input  AD3;
input  AD4;
input  AD5;
input  AD6;
input  AD7;
input  AD8;
input  AD9;
input  AD10;
input  DI0;
input  DI1;
input  DI2;
input  DI3;
input  DI4;
input  DI5;
input  DI6;
input  DI7;

output DO0;
output DO1;
output DO2;
output DO3;
output DO4;
output DO5;
output DO6;
output DO7;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [7:0] di;
wire [7:0] do;
wire [10:0] ad;
wire [1:0] cs;
reg notifier;

assign cs = {CS1,CS0};
assign di = {DI7,DI6,DI5,DI4,DI3,DI2,DI1,DI0};
//assign {DO7,DO6,DO5,DO4,DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]); 
buf INSXQ4 (DO4,do[4]);
buf INSXQ5 (DO5,do[5]);
buf INSXQ6 (DO6,do[6]);
buf INSXQ7 (DO7,do[7]);	  

assign ad = {AD10,AD9,AD8,AD7,AD6,AD5,AD4,AD3,AD2,AD1,AD0};

defparam RAM_U0.ADDR_WIDTH = 11;
defparam RAM_U0.DATA_WIDTH = 8;

defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_SPRAMA_16K RAM_U0(
		.CEN(CEN),
		.CLK(CLK),
		.WR(WR),
		.CS(cs),
		.RST(RST),
		.DI(di),
		.AD(ad),
		.DO(do)
		);

specify
	$width (posedge CLK, 1, 0, notifier);
	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge CLK, DI0, 1, 0);
	$setuphold  (posedge CLK, DI1, 1, 0);
	$setuphold  (posedge CLK, DI2, 1, 0);
	$setuphold  (posedge CLK, DI3, 1, 0);
	$setuphold  (posedge CLK, DI4, 1, 0);
	$setuphold  (posedge CLK, DI5, 1, 0);
	$setuphold  (posedge CLK, DI6, 1, 0);
	$setuphold  (posedge CLK, DI7, 1, 0);

	$setuphold  (posedge CLK, WR, 1, 0);
	$setuphold  (posedge CLK, CEN, 1, 0);
	$setuphold  (posedge CLK, CS0, 1, 0);
	$setuphold  (posedge CLK, CS1, 1, 0);

	$setuphold  (posedge CLK, AD0, 1, 0);
	$setuphold  (posedge CLK, AD1, 1, 0);
	$setuphold  (posedge CLK, AD2, 1, 0);
	$setuphold  (posedge CLK, AD3, 1, 0);
	$setuphold  (posedge CLK, AD4, 1, 0);
	$setuphold  (posedge CLK, AD5, 1, 0);
	$setuphold  (posedge CLK, AD6, 1, 0);
	$setuphold  (posedge CLK, AD7, 1, 0);
	$setuphold  (posedge CLK, AD8, 1, 0);
	$setuphold  (posedge CLK, AD9, 1, 0);
	$setuphold  (posedge CLK, AD10, 1, 0);

        $recovery(posedge RST, posedge CLK, 1); 

	(AD0 => DO0) = (0:0:0, 0:0:0);
	(AD1 => DO0) = (0:0:0, 0:0:0);
	(AD2 => DO0) = (0:0:0, 0:0:0);
	(AD3 => DO0) = (0:0:0, 0:0:0);
	(AD4 => DO0) = (0:0:0, 0:0:0);
	(AD5 => DO0) = (0:0:0, 0:0:0);
	(AD6 => DO0) = (0:0:0, 0:0:0);
	(AD7 => DO0) = (0:0:0, 0:0:0);
	(AD8 => DO0) = (0:0:0, 0:0:0);
	(AD9 => DO0) = (0:0:0, 0:0:0);
	(AD10 => DO0) = (0:0:0, 0:0:0);

	(AD0 => DO1) = (0:0:0, 0:0:0);
	(AD1 => DO1) = (0:0:0, 0:0:0);
	(AD2 => DO1) = (0:0:0, 0:0:0);
	(AD3 => DO1) = (0:0:0, 0:0:0);
	(AD4 => DO1) = (0:0:0, 0:0:0);
	(AD5 => DO1) = (0:0:0, 0:0:0);
	(AD6 => DO1) = (0:0:0, 0:0:0);
	(AD7 => DO1) = (0:0:0, 0:0:0);
	(AD8 => DO1) = (0:0:0, 0:0:0);
	(AD9 => DO1) = (0:0:0, 0:0:0);
	(AD10 => DO1) = (0:0:0, 0:0:0);

	(AD0 => DO1) = (0:0:0, 0:0:0);
	(AD1 => DO1) = (0:0:0, 0:0:0);
	(AD2 => DO1) = (0:0:0, 0:0:0);
	(AD3 => DO1) = (0:0:0, 0:0:0);
	(AD4 => DO1) = (0:0:0, 0:0:0);
	(AD5 => DO1) = (0:0:0, 0:0:0);
	(AD6 => DO1) = (0:0:0, 0:0:0);
	(AD7 => DO1) = (0:0:0, 0:0:0);
	(AD8 => DO1) = (0:0:0, 0:0:0);
	(AD9 => DO1) = (0:0:0, 0:0:0);
	(AD10 => DO1) = (0:0:0, 0:0:0);

	(AD0 => DO2) = (0:0:0, 0:0:0);
	(AD1 => DO2) = (0:0:0, 0:0:0);
	(AD2 => DO2) = (0:0:0, 0:0:0);
	(AD3 => DO2) = (0:0:0, 0:0:0);
	(AD4 => DO2) = (0:0:0, 0:0:0);
	(AD5 => DO2) = (0:0:0, 0:0:0);
	(AD6 => DO2) = (0:0:0, 0:0:0);
	(AD7 => DO2) = (0:0:0, 0:0:0);
	(AD8 => DO2) = (0:0:0, 0:0:0);
	(AD9 => DO2) = (0:0:0, 0:0:0);
	(AD10 => DO2) = (0:0:0, 0:0:0);

	(AD0 => DO3) = (0:0:0, 0:0:0);
	(AD1 => DO3) = (0:0:0, 0:0:0);
	(AD2 => DO3) = (0:0:0, 0:0:0);
	(AD3 => DO3) = (0:0:0, 0:0:0);
	(AD4 => DO3) = (0:0:0, 0:0:0);
	(AD5 => DO3) = (0:0:0, 0:0:0);
	(AD6 => DO3) = (0:0:0, 0:0:0);
	(AD7 => DO3) = (0:0:0, 0:0:0);
	(AD8 => DO3) = (0:0:0, 0:0:0);
	(AD9 => DO3) = (0:0:0, 0:0:0);
	(AD10 => DO3) = (0:0:0, 0:0:0);

	(AD0 => DO4) = (0:0:0, 0:0:0);
	(AD1 => DO4) = (0:0:0, 0:0:0);
	(AD2 => DO4) = (0:0:0, 0:0:0);
	(AD3 => DO4) = (0:0:0, 0:0:0);
	(AD4 => DO4) = (0:0:0, 0:0:0);
	(AD5 => DO4) = (0:0:0, 0:0:0);
	(AD6 => DO4) = (0:0:0, 0:0:0);
	(AD7 => DO4) = (0:0:0, 0:0:0);
	(AD8 => DO4) = (0:0:0, 0:0:0);
	(AD9 => DO4) = (0:0:0, 0:0:0);
	(AD10 => DO4) = (0:0:0, 0:0:0);

	(AD0 => DO5) = (0:0:0, 0:0:0);
	(AD1 => DO5) = (0:0:0, 0:0:0);
	(AD2 => DO5) = (0:0:0, 0:0:0);
	(AD3 => DO5) = (0:0:0, 0:0:0);
	(AD4 => DO5) = (0:0:0, 0:0:0);
	(AD5 => DO5) = (0:0:0, 0:0:0);
	(AD6 => DO5) = (0:0:0, 0:0:0);
	(AD7 => DO5) = (0:0:0, 0:0:0);
	(AD8 => DO5) = (0:0:0, 0:0:0);
	(AD9 => DO5) = (0:0:0, 0:0:0);
	(AD10 => DO5) = (0:0:0, 0:0:0);

	(AD0 => DO6) = (0:0:0, 0:0:0);
	(AD1 => DO6) = (0:0:0, 0:0:0);
	(AD2 => DO6) = (0:0:0, 0:0:0);
	(AD3 => DO6) = (0:0:0, 0:0:0);
	(AD4 => DO6) = (0:0:0, 0:0:0);
	(AD5 => DO6) = (0:0:0, 0:0:0);
	(AD6 => DO6) = (0:0:0, 0:0:0);
	(AD7 => DO6) = (0:0:0, 0:0:0);
	(AD8 => DO6) = (0:0:0, 0:0:0);
	(AD9 => DO6) = (0:0:0, 0:0:0);
	(AD10 => DO6) = (0:0:0, 0:0:0);

	(AD0 => DO7) = (0:0:0, 0:0:0);
	(AD1 => DO7) = (0:0:0, 0:0:0);
	(AD2 => DO7) = (0:0:0, 0:0:0);
	(AD3 => DO7) = (0:0:0, 0:0:0);
	(AD4 => DO7) = (0:0:0, 0:0:0);
	(AD5 => DO7) = (0:0:0, 0:0:0);
	(AD6 => DO7) = (0:0:0, 0:0:0);
	(AD7 => DO7) = (0:0:0, 0:0:0);
	(AD8 => DO7) = (0:0:0, 0:0:0);
	(AD9 => DO7) = (0:0:0, 0:0:0);
	(AD10 => DO7) = (0:0:0, 0:0:0);

	(RST => DO0) = (0:0:0, 0:0:0);
	(RST => DO1) = (0:0:0, 0:0:0);
	(RST => DO2) = (0:0:0, 0:0:0);
	(RST => DO3) = (0:0:0, 0:0:0);
	(RST => DO4) = (0:0:0, 0:0:0);
	(RST => DO5) = (0:0:0, 0:0:0);
	(RST => DO6) = (0:0:0, 0:0:0);
	(RST => DO7) = (0:0:0, 0:0:0);

	(CLK => DO0) = (0:0:0, 0:0:0);
	(CLK => DO1) = (0:0:0, 0:0:0);
	(CLK => DO2) = (0:0:0, 0:0:0);
	(CLK => DO3) = (0:0:0, 0:0:0);
	(CLK => DO4) = (0:0:0, 0:0:0);
	(CLK => DO5) = (0:0:0, 0:0:0);
	(CLK => DO6) = (0:0:0, 0:0:0);
	(CLK => DO7) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16KA_X16(CEN,CLK,WR,CS0,CS1,RST,
                  DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,
                  DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15,
                  AD0,AD1,AD2,AD3,AD4,AD5,AD6,AD7,AD8,AD9,
                  DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,
                  DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15
 );

parameter RAM_INIT_FILE = "";

input  CEN;
input  CLK;
input  WR;
input  CS0;
input  CS1;
input  RST;
input  AD0;
input  AD1;
input  AD2;
input  AD3;
input  AD4;
input  AD5;
input  AD6;
input  AD7;
input  AD8;
input  AD9;
input  DI0;
input  DI1;
input  DI2;
input  DI3;
input  DI4;
input  DI5;
input  DI6;
input  DI7;
input  DI8;
input  DI9;
input  DI10;
input  DI11;
input  DI12;
input  DI13;
input  DI14;
input  DI15;

output DO0;
output DO1;
output DO2;
output DO3;
output DO4;
output DO5;
output DO6;
output DO7;
output DO8;
output DO9;
output DO10;
output DO11;
output DO12;
output DO13;
output DO14;
output DO15;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [15:0] di;
wire [15:0] do;
wire [9:0] ad;
wire [1:0] cs;
reg notifier;

assign di = {DI15,DI14,DI13,DI12,DI11,DI10,DI9,DI8,DI7,DI6,DI5,DI4,DI3,DI2,DI1,DI0};
//assign {DO15,DO14,DO13,DO12,DO11,DO10,DO9,DO8,DO7,DO6,DO5,DO4,DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]); 
buf INSXQ4 (DO4,do[4]);
buf INSXQ5 (DO5,do[5]);
buf INSXQ6 (DO6,do[6]);
buf INSXQ7 (DO7,do[7]);	  
buf INSXQ8 (DO8,do[8]);
buf INSXQ9 (DO9,do[9]);

buf INSXQ10 (DO10,do[10]);
buf INSXQ11 (DO11,do[11]);
buf INSXQ12 (DO12,do[12]);
buf INSXQ13 (DO13,do[13]);
buf INSXQ14 (DO14,do[14]);
buf INSXQ15 (DO15,do[15]);
assign ad = {AD9,AD8,AD7,AD6,AD5,AD4,AD3,AD2,AD1,AD0};
assign cs = {CS1,CS0};

defparam RAM_U0.ADDR_WIDTH = 10;
defparam RAM_U0.DATA_WIDTH = 16;

defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_SPRAMA_16K RAM_U0(
		.CEN(CEN),
		.CLK(CLK),
		.WR(WR),
		.CS(cs),
		.RST(RST),
		.DI(di),
		.AD(ad),
		.DO(do)
		);

specify
	$width (posedge CLK, 1, 0, notifier);
	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge CLK, DI0, 1, 0);
	$setuphold  (posedge CLK, DI1, 1, 0);
	$setuphold  (posedge CLK, DI2, 1, 0);
	$setuphold  (posedge CLK, DI3, 1, 0);
	$setuphold  (posedge CLK, DI4, 1, 0);
	$setuphold  (posedge CLK, DI5, 1, 0);
	$setuphold  (posedge CLK, DI6, 1, 0);
	$setuphold  (posedge CLK, DI7, 1, 0);
	$setuphold  (posedge CLK, DI8, 1, 0);
	$setuphold  (posedge CLK, DI9, 1, 0);
	$setuphold  (posedge CLK, DI10, 1, 0);
	$setuphold  (posedge CLK, DI11, 1, 0);
	$setuphold  (posedge CLK, DI12, 1, 0);
	$setuphold  (posedge CLK, DI13, 1, 0);
	$setuphold  (posedge CLK, DI14, 1, 0);
	$setuphold  (posedge CLK, DI15, 1, 0);

	$setuphold  (posedge CLK, WR, 1, 0);
	$setuphold  (posedge CLK, CEN, 1, 0);
	$setuphold  (posedge CLK, CS0, 1, 0);
	$setuphold  (posedge CLK, CS1, 1, 0);
	$setuphold  (posedge CLK, AD0, 1, 0);

	$setuphold  (posedge CLK, AD1, 1, 0);
	$setuphold  (posedge CLK, AD2, 1, 0);
	$setuphold  (posedge CLK, AD3, 1, 0);
	$setuphold  (posedge CLK, AD4, 1, 0);
	$setuphold  (posedge CLK, AD5, 1, 0);
	$setuphold  (posedge CLK, AD6, 1, 0);
	$setuphold  (posedge CLK, AD7, 1, 0);
	$setuphold  (posedge CLK, AD8, 1, 0);
	$setuphold  (posedge CLK, AD9, 1, 0);

        $recovery(posedge RST, posedge CLK, 1); 

	(AD0 => DO0) = (0:0:0, 0:0:0);
	(AD1 => DO0) = (0:0:0, 0:0:0);
	(AD2 => DO0) = (0:0:0, 0:0:0);
	(AD3 => DO0) = (0:0:0, 0:0:0);
	(AD4 => DO0) = (0:0:0, 0:0:0);
	(AD5 => DO0) = (0:0:0, 0:0:0);
	(AD6 => DO0) = (0:0:0, 0:0:0);
	(AD7 => DO0) = (0:0:0, 0:0:0);
	(AD8 => DO0) = (0:0:0, 0:0:0);
	(AD9 => DO0) = (0:0:0, 0:0:0);

	(AD0 => DO1) = (0:0:0, 0:0:0);
	(AD1 => DO1) = (0:0:0, 0:0:0);
	(AD2 => DO1) = (0:0:0, 0:0:0);
	(AD3 => DO1) = (0:0:0, 0:0:0);
	(AD4 => DO1) = (0:0:0, 0:0:0);
	(AD5 => DO1) = (0:0:0, 0:0:0);
	(AD6 => DO1) = (0:0:0, 0:0:0);
	(AD7 => DO1) = (0:0:0, 0:0:0);
	(AD8 => DO1) = (0:0:0, 0:0:0);
	(AD9 => DO1) = (0:0:0, 0:0:0);

	(AD0 => DO2) = (0:0:0, 0:0:0);
	(AD1 => DO2) = (0:0:0, 0:0:0);
	(AD2 => DO2) = (0:0:0, 0:0:0);
	(AD3 => DO2) = (0:0:0, 0:0:0);
	(AD4 => DO2) = (0:0:0, 0:0:0);
	(AD5 => DO2) = (0:0:0, 0:0:0);
	(AD6 => DO2) = (0:0:0, 0:0:0);
	(AD7 => DO2) = (0:0:0, 0:0:0);
	(AD8 => DO2) = (0:0:0, 0:0:0);
	(AD9 => DO2) = (0:0:0, 0:0:0);

	(AD0 => DO3) = (0:0:0, 0:0:0);
	(AD1 => DO3) = (0:0:0, 0:0:0);
	(AD2 => DO3) = (0:0:0, 0:0:0);
	(AD3 => DO3) = (0:0:0, 0:0:0);
	(AD4 => DO3) = (0:0:0, 0:0:0);
	(AD5 => DO3) = (0:0:0, 0:0:0);
	(AD6 => DO3) = (0:0:0, 0:0:0);
	(AD7 => DO3) = (0:0:0, 0:0:0);
	(AD8 => DO3) = (0:0:0, 0:0:0);
	(AD9 => DO3) = (0:0:0, 0:0:0);

	(AD0 => DO4) = (0:0:0, 0:0:0);
	(AD1 => DO4) = (0:0:0, 0:0:0);
	(AD2 => DO4) = (0:0:0, 0:0:0);
	(AD3 => DO4) = (0:0:0, 0:0:0);
	(AD4 => DO4) = (0:0:0, 0:0:0);
	(AD5 => DO4) = (0:0:0, 0:0:0);
	(AD6 => DO4) = (0:0:0, 0:0:0);
	(AD7 => DO4) = (0:0:0, 0:0:0);
	(AD8 => DO4) = (0:0:0, 0:0:0);
	(AD9 => DO4) = (0:0:0, 0:0:0);

	(AD0 => DO5) = (0:0:0, 0:0:0);
	(AD1 => DO5) = (0:0:0, 0:0:0);
	(AD2 => DO5) = (0:0:0, 0:0:0);
	(AD3 => DO5) = (0:0:0, 0:0:0);
	(AD4 => DO5) = (0:0:0, 0:0:0);
	(AD5 => DO5) = (0:0:0, 0:0:0);
	(AD6 => DO5) = (0:0:0, 0:0:0);
	(AD7 => DO5) = (0:0:0, 0:0:0);
	(AD8 => DO5) = (0:0:0, 0:0:0);
	(AD9 => DO5) = (0:0:0, 0:0:0);

	(AD0 => DO6) = (0:0:0, 0:0:0);
	(AD1 => DO6) = (0:0:0, 0:0:0);
	(AD2 => DO6) = (0:0:0, 0:0:0);
	(AD3 => DO6) = (0:0:0, 0:0:0);
	(AD4 => DO6) = (0:0:0, 0:0:0);
	(AD5 => DO6) = (0:0:0, 0:0:0);
	(AD6 => DO6) = (0:0:0, 0:0:0);
	(AD7 => DO6) = (0:0:0, 0:0:0);
	(AD8 => DO6) = (0:0:0, 0:0:0);
	(AD9 => DO6) = (0:0:0, 0:0:0);

	(AD0 => DO7) = (0:0:0, 0:0:0);
	(AD1 => DO7) = (0:0:0, 0:0:0);
	(AD2 => DO7) = (0:0:0, 0:0:0);
	(AD3 => DO7) = (0:0:0, 0:0:0);
	(AD4 => DO7) = (0:0:0, 0:0:0);
	(AD5 => DO7) = (0:0:0, 0:0:0);
	(AD6 => DO7) = (0:0:0, 0:0:0);
	(AD7 => DO7) = (0:0:0, 0:0:0);
	(AD8 => DO7) = (0:0:0, 0:0:0);
	(AD9 => DO7) = (0:0:0, 0:0:0);

	(AD0 => DO8) = (0:0:0, 0:0:0);
	(AD1 => DO8) = (0:0:0, 0:0:0);
	(AD2 => DO8) = (0:0:0, 0:0:0);
	(AD3 => DO8) = (0:0:0, 0:0:0);
	(AD4 => DO8) = (0:0:0, 0:0:0);
	(AD5 => DO8) = (0:0:0, 0:0:0);
	(AD6 => DO8) = (0:0:0, 0:0:0);
	(AD7 => DO8) = (0:0:0, 0:0:0);
	(AD8 => DO8) = (0:0:0, 0:0:0);
	(AD9 => DO8) = (0:0:0, 0:0:0);

	(AD0 => DO9) = (0:0:0, 0:0:0);
	(AD1 => DO9) = (0:0:0, 0:0:0);
	(AD2 => DO9) = (0:0:0, 0:0:0);
	(AD3 => DO9) = (0:0:0, 0:0:0);
	(AD4 => DO9) = (0:0:0, 0:0:0);
	(AD5 => DO9) = (0:0:0, 0:0:0);
	(AD6 => DO9) = (0:0:0, 0:0:0);
	(AD7 => DO9) = (0:0:0, 0:0:0);
	(AD8 => DO9) = (0:0:0, 0:0:0);
	(AD9 => DO9) = (0:0:0, 0:0:0);

	(AD0 => DO10) = (0:0:0, 0:0:0);
	(AD1 => DO10) = (0:0:0, 0:0:0);
	(AD2 => DO10) = (0:0:0, 0:0:0);
	(AD3 => DO10) = (0:0:0, 0:0:0);
	(AD4 => DO10) = (0:0:0, 0:0:0);
	(AD5 => DO10) = (0:0:0, 0:0:0);
	(AD6 => DO10) = (0:0:0, 0:0:0);
	(AD7 => DO10) = (0:0:0, 0:0:0);
	(AD8 => DO10) = (0:0:0, 0:0:0);
	(AD9 => DO10) = (0:0:0, 0:0:0);

	(AD0 => DO11) = (0:0:0, 0:0:0);
	(AD1 => DO11) = (0:0:0, 0:0:0);
	(AD2 => DO11) = (0:0:0, 0:0:0);
	(AD3 => DO11) = (0:0:0, 0:0:0);
	(AD4 => DO11) = (0:0:0, 0:0:0);
	(AD5 => DO11) = (0:0:0, 0:0:0);
	(AD6 => DO11) = (0:0:0, 0:0:0);
	(AD7 => DO11) = (0:0:0, 0:0:0);
	(AD8 => DO11) = (0:0:0, 0:0:0);
	(AD9 => DO11) = (0:0:0, 0:0:0);

	(AD0 => DO12) = (0:0:0, 0:0:0);
	(AD1 => DO12) = (0:0:0, 0:0:0);
	(AD2 => DO12) = (0:0:0, 0:0:0);
	(AD3 => DO12) = (0:0:0, 0:0:0);
	(AD4 => DO12) = (0:0:0, 0:0:0);
	(AD5 => DO12) = (0:0:0, 0:0:0);
	(AD6 => DO12) = (0:0:0, 0:0:0);
	(AD7 => DO12) = (0:0:0, 0:0:0);
	(AD8 => DO12) = (0:0:0, 0:0:0);
	(AD9 => DO12) = (0:0:0, 0:0:0);

	(AD0 => DO13) = (0:0:0, 0:0:0);
	(AD1 => DO13) = (0:0:0, 0:0:0);
	(AD2 => DO13) = (0:0:0, 0:0:0);
	(AD3 => DO13) = (0:0:0, 0:0:0);
	(AD4 => DO13) = (0:0:0, 0:0:0);
	(AD5 => DO13) = (0:0:0, 0:0:0);
	(AD6 => DO13) = (0:0:0, 0:0:0);
	(AD7 => DO13) = (0:0:0, 0:0:0);
	(AD8 => DO13) = (0:0:0, 0:0:0);
	(AD9 => DO13) = (0:0:0, 0:0:0);

	(AD0 => DO14) = (0:0:0, 0:0:0);
	(AD1 => DO14) = (0:0:0, 0:0:0);
	(AD2 => DO14) = (0:0:0, 0:0:0);
	(AD3 => DO14) = (0:0:0, 0:0:0);
	(AD4 => DO14) = (0:0:0, 0:0:0);
	(AD5 => DO14) = (0:0:0, 0:0:0);
	(AD6 => DO14) = (0:0:0, 0:0:0);
	(AD7 => DO14) = (0:0:0, 0:0:0);
	(AD8 => DO14) = (0:0:0, 0:0:0);
	(AD9 => DO14) = (0:0:0, 0:0:0);

	(AD0 => DO15) = (0:0:0, 0:0:0);
	(AD1 => DO15) = (0:0:0, 0:0:0);
	(AD2 => DO15) = (0:0:0, 0:0:0);
	(AD3 => DO15) = (0:0:0, 0:0:0);
	(AD4 => DO15) = (0:0:0, 0:0:0);
	(AD5 => DO15) = (0:0:0, 0:0:0);
	(AD6 => DO15) = (0:0:0, 0:0:0);
	(AD7 => DO15) = (0:0:0, 0:0:0);
	(AD8 => DO15) = (0:0:0, 0:0:0);
	(AD9 => DO15) = (0:0:0, 0:0:0);

	(RST => DO0) = (0:0:0, 0:0:0);
	(RST => DO1) = (0:0:0, 0:0:0);
	(RST => DO2) = (0:0:0, 0:0:0);
	(RST => DO3) = (0:0:0, 0:0:0);
	(RST => DO4) = (0:0:0, 0:0:0);
	(RST => DO5) = (0:0:0, 0:0:0);
	(RST => DO6) = (0:0:0, 0:0:0);
	(RST => DO7) = (0:0:0, 0:0:0);
	(RST => DO8) = (0:0:0, 0:0:0);
	(RST => DO9) = (0:0:0, 0:0:0);
	(RST => DO10) = (0:0:0, 0:0:0);
	(RST => DO11) = (0:0:0, 0:0:0);
	(RST => DO12) = (0:0:0, 0:0:0);
	(RST => DO13) = (0:0:0, 0:0:0);
	(RST => DO14) = (0:0:0, 0:0:0);
	(RST => DO15) = (0:0:0, 0:0:0);

	(CLK => DO0) = (2:2:2, 2:2:2);
	(CLK => DO1) = (2:2:2, 2:2:2);
	(CLK => DO2) = (2:2:2, 2:2:2);
	(CLK => DO3) = (2:2:2, 2:2:2);
	(CLK => DO4) = (2:2:2, 2:2:2);
	(CLK => DO5) = (2:2:2, 2:2:2);
	(CLK => DO6) = (2:2:2, 2:2:2);
	(CLK => DO7) = (2:2:2, 2:2:2);
	(CLK => DO8) = (2:2:2, 2:2:2);
	(CLK => DO9) = (2:2:2, 2:2:2);
	(CLK => DO10) = (2:2:2, 2:2:2);
	(CLK => DO11) = (2:2:2, 2:2:2);
	(CLK => DO12) = (2:2:2, 2:2:2);
	(CLK => DO13) = (2:2:2, 2:2:2);
	(CLK => DO14) = (2:2:2, 2:2:2);
	(CLK => DO15) = (2:2:2, 2:2:2);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMB16KA_X32(CEN,CLK,WR,CS0,CS1,RST,
                  DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,
                  DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15,
                  DI16,DI17,DI18,DI19,DI20,DI21,DI22,DI23,
                  DI24,DI25,DI26,DI27,DI28,DI29,DI30,DI31,
                  AD0,AD1,AD2,AD3,AD4,AD5,AD6,AD7,AD8,
                  DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,
                  DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15,
                  DO16,DO17,DO18,DO19,DO20,DO21,DO22,DO23,
                  DO24,DO25,DO26,DO27,DO28,DO29,DO30,DO31
 );

parameter RAM_INIT_FILE = "";

input  CEN;
input  CLK;
input  WR;
input  CS0;
input  CS1;
input  RST;
input  AD0;
input  AD1;
input  AD2;
input  AD3;
input  AD4;
input  AD5;
input  AD6;
input  AD7;
input  AD8;
input  DI0;
input  DI1;
input  DI2;
input  DI3;
input  DI4;
input  DI5;
input  DI6;
input  DI7;
input  DI8;
input  DI9;
input  DI10;
input  DI11;
input  DI12;
input  DI13;
input  DI14;
input  DI15;
input  DI16;
input  DI17;
input  DI18;
input  DI19;
input  DI20;
input  DI21;
input  DI22;
input  DI23;
input  DI24;
input  DI25;
input  DI26;
input  DI27;
input  DI28;
input  DI29;
input  DI30;
input  DI31;

output DO0;
output DO1;
output DO2;
output DO3;
output DO4;
output DO5;
output DO6;
output DO7;
output DO8;
output DO9;
output DO10;
output DO11;
output DO12;
output DO13;
output DO14;
output DO15;
output DO16;
output DO17;
output DO18;
output DO19;
output DO20;
output DO21;
output DO22;
output DO23;
output DO24;
output DO25;
output DO26;
output DO27;
output DO28;
output DO29;
output DO30;
output DO31;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [31:0] di;
wire [31:0] do;
wire [8:0] ad;
wire [1:0] cs;
reg notifier;

assign cs = {CS1,CS0};

assign di = {DI31,DI30,DI29,DI28,DI27,DI26,DI25,DI24,DI23,DI22,DI21,DI20,DI19,DI18,DI17,DI16,DI15,DI14,DI13,DI12,DI11,DI10,DI9,DI8,DI7,DI6,DI5,DI4,DI3,DI2,DI1,DI0};
//assign {DO31,DO30,DO29,DO28,DO27,DO26,DO25,DO24,DO23,DO22,DO21,DO20,DO19,DO18,DO17,DO16,DO15,DO14,DO13,DO12,DO11,DO10,DO9,DO8,DO7,DO6,DO5,DO4,DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]); 
buf INSXQ4 (DO4,do[4]);
buf INSXQ5 (DO5,do[5]);
buf INSXQ6 (DO6,do[6]);
buf INSXQ7 (DO7,do[7]);	  
buf INSXQ8 (DO8,do[8]);
buf INSXQ9 (DO9,do[9]);

buf INSXQ10 (DO10,do[10]);
buf INSXQ11 (DO11,do[11]);
buf INSXQ12 (DO12,do[12]);
buf INSXQ13 (DO13,do[13]);
buf INSXQ14 (DO14,do[14]);
buf INSXQ15 (DO15,do[15]);
buf INSXQ16 (DO16,do[16]);
buf INSXQ17 (DO17,do[17]);
buf INSXQ18 (DO18,do[18]);
buf INSXQ19 (DO19,do[19]); 

buf INSXQ20 (DO20,do[20]);
buf INSXQ21 (DO21,do[21]);
buf INSXQ22 (DO22,do[22]);
buf INSXQ23 (DO23,do[23]);
buf INSXQ24 (DO24,do[24]);
buf INSXQ25 (DO25,do[25]);
buf INSXQ26 (DO26,do[26]);
buf INSXQ27 (DO27,do[27]);
buf INSXQ28 (DO28,do[28]);
buf INSXQ29 (DO29,do[29]); 

buf INSXQ30 (DO30,do[30]);
buf INSXQ31 (DO31,do[31]);

assign ad = {AD8,AD7,AD6,AD5,AD4,AD3,AD2,AD1,AD0};

defparam RAM_U0.ADDR_WIDTH = 9;
defparam RAM_U0.DATA_WIDTH = 32;

defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_SPRAMA_16K RAM_U0(
		.CEN(CEN),
		.CLK(CLK),
		.WR(WR),
		.CS(cs),
		.RST(RST),
		.DI(di),
		.AD(ad),
		.DO(do)
		);

specify
	$width (posedge CLK, 1, 0, notifier);
	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge CLK, DI0, 1, 0);
	$setuphold  (posedge CLK, DI1, 1, 0);
	$setuphold  (posedge CLK, DI2, 1, 0);
	$setuphold  (posedge CLK, DI3, 1, 0);
	$setuphold  (posedge CLK, DI4, 1, 0);
	$setuphold  (posedge CLK, DI5, 1, 0);
	$setuphold  (posedge CLK, DI6, 1, 0);
	$setuphold  (posedge CLK, DI7, 1, 0);
	$setuphold  (posedge CLK, DI8, 1, 0);
	$setuphold  (posedge CLK, DI9, 1, 0);
	$setuphold  (posedge CLK, DI10, 1, 0);
	$setuphold  (posedge CLK, DI11, 1, 0);
	$setuphold  (posedge CLK, DI12, 1, 0);
	$setuphold  (posedge CLK, DI13, 1, 0);
	$setuphold  (posedge CLK, DI14, 1, 0);
	$setuphold  (posedge CLK, DI15, 1, 0);
	$setuphold  (posedge CLK, DI16, 1, 0);
	$setuphold  (posedge CLK, DI17, 1, 0);
	$setuphold  (posedge CLK, DI18, 1, 0);
	$setuphold  (posedge CLK, DI19, 1, 0);
	$setuphold  (posedge CLK, DI20, 1, 0);
	$setuphold  (posedge CLK, DI21, 1, 0);
	$setuphold  (posedge CLK, DI22, 1, 0);
	$setuphold  (posedge CLK, DI23, 1, 0);
	$setuphold  (posedge CLK, DI24, 1, 0);
	$setuphold  (posedge CLK, DI25, 1, 0);
	$setuphold  (posedge CLK, DI26, 1, 0);
	$setuphold  (posedge CLK, DI27, 1, 0);
	$setuphold  (posedge CLK, DI28, 1, 0);
	$setuphold  (posedge CLK, DI29, 1, 0);
	$setuphold  (posedge CLK, DI30, 1, 0);
	$setuphold  (posedge CLK, DI31, 1, 0);

	$setuphold  (posedge CLK, WR, 1, 0);
	$setuphold  (posedge CLK, CEN, 1, 0);
	$setuphold  (posedge CLK, CS0, 1, 0);
	$setuphold  (posedge CLK, CS1, 1, 0);

	$setuphold  (posedge CLK, AD0, 1, 0);
	$setuphold  (posedge CLK, AD1, 1, 0);
	$setuphold  (posedge CLK, AD2, 1, 0);
	$setuphold  (posedge CLK, AD3, 1, 0);
	$setuphold  (posedge CLK, AD4, 1, 0);
	$setuphold  (posedge CLK, AD5, 1, 0);
	$setuphold  (posedge CLK, AD6, 1, 0);
	$setuphold  (posedge CLK, AD7, 1, 0);
	$setuphold  (posedge CLK, AD8, 1, 0);

        $recovery(posedge RST, posedge CLK, 1); 

	(AD0 => DO0) = (0:0:0, 0:0:0);
	(AD1 => DO0) = (0:0:0, 0:0:0);
	(AD2 => DO0) = (0:0:0, 0:0:0);
	(AD3 => DO0) = (0:0:0, 0:0:0);
	(AD4 => DO0) = (0:0:0, 0:0:0);
	(AD5 => DO0) = (0:0:0, 0:0:0);
	(AD6 => DO0) = (0:0:0, 0:0:0);
	(AD7 => DO0) = (0:0:0, 0:0:0);
	(AD8 => DO0) = (0:0:0, 0:0:0);

	(AD0 => DO1) = (0:0:0, 0:0:0);
	(AD1 => DO1) = (0:0:0, 0:0:0);
	(AD2 => DO1) = (0:0:0, 0:0:0);
	(AD3 => DO1) = (0:0:0, 0:0:0);
	(AD4 => DO1) = (0:0:0, 0:0:0);
	(AD5 => DO1) = (0:0:0, 0:0:0);
	(AD6 => DO1) = (0:0:0, 0:0:0);
	(AD7 => DO1) = (0:0:0, 0:0:0);
	(AD8 => DO1) = (0:0:0, 0:0:0);

	(AD0 => DO2) = (0:0:0, 0:0:0);
	(AD1 => DO2) = (0:0:0, 0:0:0);
	(AD2 => DO2) = (0:0:0, 0:0:0);
	(AD3 => DO2) = (0:0:0, 0:0:0);
	(AD4 => DO2) = (0:0:0, 0:0:0);
	(AD5 => DO2) = (0:0:0, 0:0:0);
	(AD6 => DO2) = (0:0:0, 0:0:0);
	(AD7 => DO2) = (0:0:0, 0:0:0);
	(AD8 => DO2) = (0:0:0, 0:0:0);

	(AD0 => DO3) = (0:0:0, 0:0:0);
	(AD1 => DO3) = (0:0:0, 0:0:0);
	(AD2 => DO3) = (0:0:0, 0:0:0);
	(AD3 => DO3) = (0:0:0, 0:0:0);
	(AD4 => DO3) = (0:0:0, 0:0:0);
	(AD5 => DO3) = (0:0:0, 0:0:0);
	(AD6 => DO3) = (0:0:0, 0:0:0);
	(AD7 => DO3) = (0:0:0, 0:0:0);
	(AD8 => DO3) = (0:0:0, 0:0:0);

	(AD0 => DO4) = (0:0:0, 0:0:0);
	(AD1 => DO4) = (0:0:0, 0:0:0);
	(AD2 => DO4) = (0:0:0, 0:0:0);
	(AD3 => DO4) = (0:0:0, 0:0:0);
	(AD4 => DO4) = (0:0:0, 0:0:0);
	(AD5 => DO4) = (0:0:0, 0:0:0);
	(AD6 => DO4) = (0:0:0, 0:0:0);
	(AD7 => DO4) = (0:0:0, 0:0:0);
	(AD8 => DO4) = (0:0:0, 0:0:0);

	(AD0 => DO5) = (0:0:0, 0:0:0);
	(AD1 => DO5) = (0:0:0, 0:0:0);
	(AD2 => DO5) = (0:0:0, 0:0:0);
	(AD3 => DO5) = (0:0:0, 0:0:0);
	(AD4 => DO5) = (0:0:0, 0:0:0);
	(AD5 => DO5) = (0:0:0, 0:0:0);
	(AD6 => DO5) = (0:0:0, 0:0:0);
	(AD7 => DO5) = (0:0:0, 0:0:0);
	(AD8 => DO5) = (0:0:0, 0:0:0);

	(AD0 => DO6) = (0:0:0, 0:0:0);
	(AD1 => DO6) = (0:0:0, 0:0:0);
	(AD2 => DO6) = (0:0:0, 0:0:0);
	(AD3 => DO6) = (0:0:0, 0:0:0);
	(AD4 => DO6) = (0:0:0, 0:0:0);
	(AD5 => DO6) = (0:0:0, 0:0:0);
	(AD6 => DO6) = (0:0:0, 0:0:0);
	(AD7 => DO6) = (0:0:0, 0:0:0);
	(AD8 => DO6) = (0:0:0, 0:0:0);

	(AD0 => DO7) = (0:0:0, 0:0:0);
	(AD1 => DO7) = (0:0:0, 0:0:0);
	(AD2 => DO7) = (0:0:0, 0:0:0);
	(AD3 => DO7) = (0:0:0, 0:0:0);
	(AD4 => DO7) = (0:0:0, 0:0:0);
	(AD5 => DO7) = (0:0:0, 0:0:0);
	(AD6 => DO7) = (0:0:0, 0:0:0);
	(AD7 => DO7) = (0:0:0, 0:0:0);
	(AD8 => DO7) = (0:0:0, 0:0:0);

	(AD0 => DO8) = (0:0:0, 0:0:0);
	(AD1 => DO8) = (0:0:0, 0:0:0);
	(AD2 => DO8) = (0:0:0, 0:0:0);
	(AD3 => DO8) = (0:0:0, 0:0:0);
	(AD4 => DO8) = (0:0:0, 0:0:0);
	(AD5 => DO8) = (0:0:0, 0:0:0);
	(AD6 => DO8) = (0:0:0, 0:0:0);
	(AD7 => DO8) = (0:0:0, 0:0:0);
	(AD8 => DO8) = (0:0:0, 0:0:0);

	(AD0 => DO9) = (0:0:0, 0:0:0);
	(AD1 => DO9) = (0:0:0, 0:0:0);
	(AD2 => DO9) = (0:0:0, 0:0:0);
	(AD3 => DO9) = (0:0:0, 0:0:0);
	(AD4 => DO9) = (0:0:0, 0:0:0);
	(AD5 => DO9) = (0:0:0, 0:0:0);
	(AD6 => DO9) = (0:0:0, 0:0:0);
	(AD7 => DO9) = (0:0:0, 0:0:0);
	(AD8 => DO9) = (0:0:0, 0:0:0);

	(AD0 => DO10) = (0:0:0, 0:0:0);
	(AD1 => DO10) = (0:0:0, 0:0:0);
	(AD2 => DO10) = (0:0:0, 0:0:0);
	(AD3 => DO10) = (0:0:0, 0:0:0);
	(AD4 => DO10) = (0:0:0, 0:0:0);
	(AD5 => DO10) = (0:0:0, 0:0:0);
	(AD6 => DO10) = (0:0:0, 0:0:0);
	(AD7 => DO10) = (0:0:0, 0:0:0);
	(AD8 => DO10) = (0:0:0, 0:0:0);

	(AD0 => DO11) = (0:0:0, 0:0:0);
	(AD1 => DO11) = (0:0:0, 0:0:0);
	(AD2 => DO11) = (0:0:0, 0:0:0);
	(AD3 => DO11) = (0:0:0, 0:0:0);
	(AD4 => DO11) = (0:0:0, 0:0:0);
	(AD5 => DO11) = (0:0:0, 0:0:0);
	(AD6 => DO11) = (0:0:0, 0:0:0);
	(AD7 => DO11) = (0:0:0, 0:0:0);
	(AD8 => DO11) = (0:0:0, 0:0:0);

	(AD0 => DO12) = (0:0:0, 0:0:0);
	(AD1 => DO12) = (0:0:0, 0:0:0);
	(AD2 => DO12) = (0:0:0, 0:0:0);
	(AD3 => DO12) = (0:0:0, 0:0:0);
	(AD4 => DO12) = (0:0:0, 0:0:0);
	(AD5 => DO12) = (0:0:0, 0:0:0);
	(AD6 => DO12) = (0:0:0, 0:0:0);
	(AD7 => DO12) = (0:0:0, 0:0:0);
	(AD8 => DO12) = (0:0:0, 0:0:0);

	(AD0 => DO13) = (0:0:0, 0:0:0);
	(AD1 => DO13) = (0:0:0, 0:0:0);
	(AD2 => DO13) = (0:0:0, 0:0:0);
	(AD3 => DO13) = (0:0:0, 0:0:0);
	(AD4 => DO13) = (0:0:0, 0:0:0);
	(AD5 => DO13) = (0:0:0, 0:0:0);
	(AD6 => DO13) = (0:0:0, 0:0:0);
	(AD7 => DO13) = (0:0:0, 0:0:0);
	(AD8 => DO13) = (0:0:0, 0:0:0);

	(AD0 => DO14) = (0:0:0, 0:0:0);
	(AD1 => DO14) = (0:0:0, 0:0:0);
	(AD2 => DO14) = (0:0:0, 0:0:0);
	(AD3 => DO14) = (0:0:0, 0:0:0);
	(AD4 => DO14) = (0:0:0, 0:0:0);
	(AD5 => DO14) = (0:0:0, 0:0:0);
	(AD6 => DO14) = (0:0:0, 0:0:0);
	(AD7 => DO14) = (0:0:0, 0:0:0);
	(AD8 => DO14) = (0:0:0, 0:0:0);

	(AD0 => DO15) = (0:0:0, 0:0:0);
	(AD1 => DO15) = (0:0:0, 0:0:0);
	(AD2 => DO15) = (0:0:0, 0:0:0);
	(AD3 => DO15) = (0:0:0, 0:0:0);
	(AD4 => DO15) = (0:0:0, 0:0:0);
	(AD5 => DO15) = (0:0:0, 0:0:0);
	(AD6 => DO15) = (0:0:0, 0:0:0);
	(AD7 => DO15) = (0:0:0, 0:0:0);
	(AD8 => DO15) = (0:0:0, 0:0:0);

	(AD0 => DO16) = (0:0:0, 0:0:0);
	(AD1 => DO16) = (0:0:0, 0:0:0);
	(AD2 => DO16) = (0:0:0, 0:0:0);
	(AD3 => DO16) = (0:0:0, 0:0:0);
	(AD4 => DO16) = (0:0:0, 0:0:0);
	(AD5 => DO16) = (0:0:0, 0:0:0);
	(AD6 => DO16) = (0:0:0, 0:0:0);
	(AD7 => DO16) = (0:0:0, 0:0:0);
	(AD8 => DO16) = (0:0:0, 0:0:0);

	(AD0 => DO17) = (0:0:0, 0:0:0);
	(AD1 => DO17) = (0:0:0, 0:0:0);
	(AD2 => DO17) = (0:0:0, 0:0:0);
	(AD3 => DO17) = (0:0:0, 0:0:0);
	(AD4 => DO17) = (0:0:0, 0:0:0);
	(AD5 => DO17) = (0:0:0, 0:0:0);
	(AD6 => DO17) = (0:0:0, 0:0:0);
	(AD7 => DO17) = (0:0:0, 0:0:0);
	(AD8 => DO17) = (0:0:0, 0:0:0);

	(AD0 => DO18) = (0:0:0, 0:0:0);
	(AD1 => DO18) = (0:0:0, 0:0:0);
	(AD2 => DO18) = (0:0:0, 0:0:0);
	(AD3 => DO18) = (0:0:0, 0:0:0);
	(AD4 => DO18) = (0:0:0, 0:0:0);
	(AD5 => DO18) = (0:0:0, 0:0:0);
	(AD6 => DO18) = (0:0:0, 0:0:0);
	(AD7 => DO18) = (0:0:0, 0:0:0);
	(AD8 => DO18) = (0:0:0, 0:0:0);

	(AD0 => DO19) = (0:0:0, 0:0:0);
	(AD1 => DO19) = (0:0:0, 0:0:0);
	(AD2 => DO19) = (0:0:0, 0:0:0);
	(AD3 => DO19) = (0:0:0, 0:0:0);
	(AD4 => DO19) = (0:0:0, 0:0:0);
	(AD5 => DO19) = (0:0:0, 0:0:0);
	(AD6 => DO19) = (0:0:0, 0:0:0);
	(AD7 => DO19) = (0:0:0, 0:0:0);
	(AD8 => DO19) = (0:0:0, 0:0:0);

	(AD0 => DO20) = (0:0:0, 0:0:0);
	(AD1 => DO20) = (0:0:0, 0:0:0);
	(AD2 => DO20) = (0:0:0, 0:0:0);
	(AD3 => DO20) = (0:0:0, 0:0:0);
	(AD4 => DO20) = (0:0:0, 0:0:0);
	(AD5 => DO20) = (0:0:0, 0:0:0);
	(AD6 => DO20) = (0:0:0, 0:0:0);
	(AD7 => DO20) = (0:0:0, 0:0:0);
	(AD8 => DO20) = (0:0:0, 0:0:0);

	(AD0 => DO21) = (0:0:0, 0:0:0);
	(AD1 => DO21) = (0:0:0, 0:0:0);
	(AD2 => DO21) = (0:0:0, 0:0:0);
	(AD3 => DO21) = (0:0:0, 0:0:0);
	(AD4 => DO21) = (0:0:0, 0:0:0);
	(AD5 => DO21) = (0:0:0, 0:0:0);
	(AD6 => DO21) = (0:0:0, 0:0:0);
	(AD7 => DO21) = (0:0:0, 0:0:0);
	(AD8 => DO21) = (0:0:0, 0:0:0);

	(AD0 => DO22) = (0:0:0, 0:0:0);
	(AD1 => DO22) = (0:0:0, 0:0:0);
	(AD2 => DO22) = (0:0:0, 0:0:0);
	(AD3 => DO22) = (0:0:0, 0:0:0);
	(AD4 => DO22) = (0:0:0, 0:0:0);
	(AD5 => DO22) = (0:0:0, 0:0:0);
	(AD6 => DO22) = (0:0:0, 0:0:0);
	(AD7 => DO22) = (0:0:0, 0:0:0);
	(AD8 => DO22) = (0:0:0, 0:0:0);

	(AD0 => DO23) = (0:0:0, 0:0:0);
	(AD1 => DO23) = (0:0:0, 0:0:0);
	(AD2 => DO23) = (0:0:0, 0:0:0);
	(AD3 => DO23) = (0:0:0, 0:0:0);
	(AD4 => DO23) = (0:0:0, 0:0:0);
	(AD5 => DO23) = (0:0:0, 0:0:0);
	(AD6 => DO23) = (0:0:0, 0:0:0);
	(AD7 => DO23) = (0:0:0, 0:0:0);
	(AD8 => DO23) = (0:0:0, 0:0:0);

	(AD0 => DO24) = (0:0:0, 0:0:0);
	(AD1 => DO24) = (0:0:0, 0:0:0);
	(AD2 => DO24) = (0:0:0, 0:0:0);
	(AD3 => DO24) = (0:0:0, 0:0:0);
	(AD4 => DO24) = (0:0:0, 0:0:0);
	(AD5 => DO24) = (0:0:0, 0:0:0);
	(AD6 => DO24) = (0:0:0, 0:0:0);
	(AD7 => DO24) = (0:0:0, 0:0:0);
	(AD8 => DO24) = (0:0:0, 0:0:0);

	(AD0 => DO25) = (0:0:0, 0:0:0);
	(AD1 => DO25) = (0:0:0, 0:0:0);
	(AD2 => DO25) = (0:0:0, 0:0:0);
	(AD3 => DO25) = (0:0:0, 0:0:0);
	(AD4 => DO25) = (0:0:0, 0:0:0);
	(AD5 => DO25) = (0:0:0, 0:0:0);
	(AD6 => DO25) = (0:0:0, 0:0:0);
	(AD7 => DO25) = (0:0:0, 0:0:0);
	(AD8 => DO25) = (0:0:0, 0:0:0);

	(AD0 => DO26) = (0:0:0, 0:0:0);
	(AD1 => DO26) = (0:0:0, 0:0:0);
	(AD2 => DO26) = (0:0:0, 0:0:0);
	(AD3 => DO26) = (0:0:0, 0:0:0);
	(AD4 => DO26) = (0:0:0, 0:0:0);
	(AD5 => DO26) = (0:0:0, 0:0:0);
	(AD6 => DO26) = (0:0:0, 0:0:0);
	(AD7 => DO26) = (0:0:0, 0:0:0);
	(AD8 => DO26) = (0:0:0, 0:0:0);

	(AD0 => DO27) = (0:0:0, 0:0:0);
	(AD1 => DO27) = (0:0:0, 0:0:0);
	(AD2 => DO27) = (0:0:0, 0:0:0);
	(AD3 => DO27) = (0:0:0, 0:0:0);
	(AD4 => DO27) = (0:0:0, 0:0:0);
	(AD5 => DO27) = (0:0:0, 0:0:0);
	(AD6 => DO27) = (0:0:0, 0:0:0);
	(AD7 => DO27) = (0:0:0, 0:0:0);
	(AD8 => DO27) = (0:0:0, 0:0:0);

	(AD0 => DO28) = (0:0:0, 0:0:0);
	(AD1 => DO28) = (0:0:0, 0:0:0);
	(AD2 => DO28) = (0:0:0, 0:0:0);
	(AD3 => DO28) = (0:0:0, 0:0:0);
	(AD4 => DO28) = (0:0:0, 0:0:0);
	(AD5 => DO28) = (0:0:0, 0:0:0);
	(AD6 => DO28) = (0:0:0, 0:0:0);
	(AD7 => DO28) = (0:0:0, 0:0:0);
	(AD8 => DO28) = (0:0:0, 0:0:0);

	(AD0 => DO29) = (0:0:0, 0:0:0);
	(AD1 => DO29) = (0:0:0, 0:0:0);
	(AD2 => DO29) = (0:0:0, 0:0:0);
	(AD3 => DO29) = (0:0:0, 0:0:0);
	(AD4 => DO29) = (0:0:0, 0:0:0);
	(AD5 => DO29) = (0:0:0, 0:0:0);
	(AD6 => DO29) = (0:0:0, 0:0:0);
	(AD7 => DO29) = (0:0:0, 0:0:0);
	(AD8 => DO29) = (0:0:0, 0:0:0);

	(AD0 => DO30) = (0:0:0, 0:0:0);
	(AD1 => DO30) = (0:0:0, 0:0:0);
	(AD2 => DO30) = (0:0:0, 0:0:0);
	(AD3 => DO30) = (0:0:0, 0:0:0);
	(AD4 => DO30) = (0:0:0, 0:0:0);
	(AD5 => DO30) = (0:0:0, 0:0:0);
	(AD6 => DO30) = (0:0:0, 0:0:0);
	(AD7 => DO30) = (0:0:0, 0:0:0);
	(AD8 => DO30) = (0:0:0, 0:0:0);

	(AD0 => DO31) = (0:0:0, 0:0:0);
	(AD1 => DO31) = (0:0:0, 0:0:0);
	(AD2 => DO31) = (0:0:0, 0:0:0);
	(AD3 => DO31) = (0:0:0, 0:0:0);
	(AD4 => DO31) = (0:0:0, 0:0:0);
	(AD5 => DO31) = (0:0:0, 0:0:0);
	(AD6 => DO31) = (0:0:0, 0:0:0);
	(AD7 => DO31) = (0:0:0, 0:0:0);
	(AD8 => DO31) = (0:0:0, 0:0:0);

	(RST => DO0) = (0:0:0, 0:0:0);
	(RST => DO1) = (0:0:0, 0:0:0);
	(RST => DO2) = (0:0:0, 0:0:0);
	(RST => DO3) = (0:0:0, 0:0:0);
	(RST => DO4) = (0:0:0, 0:0:0);
	(RST => DO5) = (0:0:0, 0:0:0);
	(RST => DO6) = (0:0:0, 0:0:0);
	(RST => DO7) = (0:0:0, 0:0:0);
	(RST => DO8) = (0:0:0, 0:0:0);
	(RST => DO9) = (0:0:0, 0:0:0);
	(RST => DO10) = (0:0:0, 0:0:0);
	(RST => DO11) = (0:0:0, 0:0:0);
	(RST => DO12) = (0:0:0, 0:0:0);
	(RST => DO13) = (0:0:0, 0:0:0);
	(RST => DO14) = (0:0:0, 0:0:0);
	(RST => DO15) = (0:0:0, 0:0:0);
	(RST => DO16) = (0:0:0, 0:0:0);
	(RST => DO17) = (0:0:0, 0:0:0);
	(RST => DO18) = (0:0:0, 0:0:0);
	(RST => DO19) = (0:0:0, 0:0:0);
	(RST => DO20) = (0:0:0, 0:0:0);
	(RST => DO21) = (0:0:0, 0:0:0);
	(RST => DO22) = (0:0:0, 0:0:0);
	(RST => DO23) = (0:0:0, 0:0:0);
	(RST => DO24) = (0:0:0, 0:0:0);
	(RST => DO25) = (0:0:0, 0:0:0);
	(RST => DO26) = (0:0:0, 0:0:0);
	(RST => DO27) = (0:0:0, 0:0:0);
	(RST => DO28) = (0:0:0, 0:0:0);
	(RST => DO29) = (0:0:0, 0:0:0);
	(RST => DO30) = (0:0:0, 0:0:0);
	(RST => DO31) = (0:0:0, 0:0:0);

	(CLK => DO0) = (0:0:0, 0:0:0);
	(CLK => DO1) = (0:0:0, 0:0:0);
	(CLK => DO2) = (0:0:0, 0:0:0);
	(CLK => DO3) = (0:0:0, 0:0:0);
	(CLK => DO4) = (0:0:0, 0:0:0);
	(CLK => DO5) = (0:0:0, 0:0:0);
	(CLK => DO6) = (0:0:0, 0:0:0);
	(CLK => DO7) = (0:0:0, 0:0:0);
	(CLK => DO8) = (0:0:0, 0:0:0);
	(CLK => DO9) = (0:0:0, 0:0:0);
	(CLK => DO10) = (0:0:0, 0:0:0);
	(CLK => DO11) = (0:0:0, 0:0:0);
	(CLK => DO12) = (0:0:0, 0:0:0);
	(CLK => DO13) = (0:0:0, 0:0:0);
	(CLK => DO14) = (0:0:0, 0:0:0);
	(CLK => DO15) = (0:0:0, 0:0:0);
	(CLK => DO16) = (0:0:0, 0:0:0);
	(CLK => DO17) = (0:0:0, 0:0:0);
	(CLK => DO18) = (0:0:0, 0:0:0);
	(CLK => DO19) = (0:0:0, 0:0:0);
	(CLK => DO20) = (0:0:0, 0:0:0);
	(CLK => DO21) = (0:0:0, 0:0:0);
	(CLK => DO22) = (0:0:0, 0:0:0);
	(CLK => DO23) = (0:0:0, 0:0:0);
	(CLK => DO24) = (0:0:0, 0:0:0);
	(CLK => DO25) = (0:0:0, 0:0:0);
	(CLK => DO26) = (0:0:0, 0:0:0);
	(CLK => DO27) = (0:0:0, 0:0:0);
	(CLK => DO28) = (0:0:0, 0:0:0);
	(CLK => DO29) = (0:0:0, 0:0:0);
	(CLK => DO30) = (0:0:0, 0:0:0);
	(CLK => DO31) = (0:0:0, 0:0:0);


endspecify
endmodule
`endcelldefine
`celldefine
module RAMBFIFO16KX1A(WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
                    DI0,
                    DO0,
                    FULL,AMFULL,EMPTY,AMEMPTY
);

parameter FIFO_FULL_FLAG = 16384;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;



input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0;
output DO0;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [0:0] di;
wire [0:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ1 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ2 (EMPTY,EMPTY_sig);
buf INSXQ3 (AMFULL,AMFULL_node);
buf INSXQ4 (AMEMPTY,AMEMPTY_node);
assign di = {DI0};
//assign {DO0} = do;
buf INSXQ0 (DO0,do);

defparam FIFO_U0.ADDR_WIDTH = 14;
defparam FIFO_U0.DATA_WIDTH = 1;
defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));


specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

	(RCLK => DO0)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);

	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

	(RST  => DO0)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);

	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);


endspecify
endmodule
`endcelldefine
`celldefine
module RAMBFIFO8KX2A(WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
                    DI0,DI1,
                    DO0,DO1,
                    FULL,AMFULL,EMPTY,AMEMPTY
);

parameter FIFO_FULL_FLAG = 8192;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;


input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1;
output DO0,DO1;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [1:0] di;
wire [1:0] do;
wire FULL_sig, EMPTY_sig;		
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ2 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ3 (EMPTY,EMPTY_sig);
buf INSXQ4 (AMFULL,AMFULL_node);
buf INSXQ5 (AMEMPTY,AMEMPTY_node);
assign di = {DI1,DI0};
//assign {DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
defparam FIFO_U0.ADDR_WIDTH = 13;
defparam FIFO_U0.DATA_WIDTH = 2;
defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;


SC_FIFO_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));


specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

	(RCLK => DO0)    = (0:0:0, 0:0:0);
	(RCLK => DO1)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);

	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

	(RST  => DO0)    = (0:0:0, 0:0:0);
	(RST  => DO1)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);

	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMBFIFO4KX4A(WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
                    DI0,DI1,DI2,DI3,
                    DO0,DO1,DO2,DO3,
                    FULL,AMFULL,EMPTY,AMEMPTY
);

parameter FIFO_FULL_FLAG = 4096;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1,DI2,DI3;
output DO0,DO1,DO2,DO3;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [3:0] di;
wire [3:0] do;
wire FULL_sig, EMPTY_sig;	  
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ4 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ5 (EMPTY,EMPTY_sig);
buf INSXQ6 (AMFULL,AMFULL_node);
buf INSXQ7 (AMEMPTY,AMEMPTY_node);
assign di = {DI3,DI2,DI1,DI0};
//assign {DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
defparam FIFO_U0.ADDR_WIDTH = 12;
defparam FIFO_U0.DATA_WIDTH = 4;
defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);
	$setuphold  (posedge WCLK, DI2, 1, 0);
	$setuphold  (posedge WCLK, DI3, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

	(RCLK => DO0)    = (0:0:0, 0:0:0);
	(RCLK => DO1)    = (0:0:0, 0:0:0);
	(RCLK => DO2)    = (0:0:0, 0:0:0);
	(RCLK => DO3)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);

	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

	(RST  => DO0)    = (0:0:0, 0:0:0);
	(RST  => DO1)    = (0:0:0, 0:0:0);
	(RST  => DO2)    = (0:0:0, 0:0:0);
	(RST  => DO3)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);

	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMBFIFO2KX8A(WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
                    DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,
                    DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,
                    FULL,AMFULL,EMPTY,AMEMPTY
);

parameter FIFO_FULL_FLAG = 2048;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;


input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7;
output DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [7:0] di;
wire [7:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ8 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ9 (EMPTY,EMPTY_sig);
buf INSXQ10 (AMFULL,AMFULL_node);
buf INSXQ11 (AMEMPTY,AMEMPTY_node);

assign di = {DI7,DI6,DI5,DI4,DI3,DI2,DI1,DI0};
//assign {DO7,DO6,DO5,DO4,DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
buf INSXQ4 (DO4,do[4]);
buf INSXQ5 (DO5,do[5]);
buf INSXQ6 (DO6,do[6]);
buf INSXQ7 (DO7,do[7]);
defparam FIFO_U0.ADDR_WIDTH = 11;
defparam FIFO_U0.DATA_WIDTH = 8;
defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);
	$setuphold  (posedge WCLK, DI2, 1, 0);
	$setuphold  (posedge WCLK, DI3, 1, 0);
	$setuphold  (posedge WCLK, DI4, 1, 0);
	$setuphold  (posedge WCLK, DI5, 1, 0);
	$setuphold  (posedge WCLK, DI6, 1, 0);
	$setuphold  (posedge WCLK, DI7, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

	(RCLK => DO0)    = (0:0:0, 0:0:0);
	(RCLK => DO1)    = (0:0:0, 0:0:0);
	(RCLK => DO2)    = (0:0:0, 0:0:0);
	(RCLK => DO3)    = (0:0:0, 0:0:0);
	(RCLK => DO4)    = (0:0:0, 0:0:0);
	(RCLK => DO5)    = (0:0:0, 0:0:0);
	(RCLK => DO6)    = (0:0:0, 0:0:0);
	(RCLK => DO7)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);

	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

	(RST  => DO0)    = (0:0:0, 0:0:0);
	(RST  => DO1)    = (0:0:0, 0:0:0);
	(RST  => DO2)    = (0:0:0, 0:0:0);
	(RST  => DO3)    = (0:0:0, 0:0:0);
	(RST  => DO4)    = (0:0:0, 0:0:0);
	(RST  => DO5)    = (0:0:0, 0:0:0);
	(RST  => DO6)    = (0:0:0, 0:0:0);
	(RST  => DO7)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);

	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMBFIFO1KX16A(WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
                    DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,
                    DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15,
                    DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,
                    DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15,
                    FULL,AMFULL,EMPTY,AMEMPTY
);

parameter FIFO_FULL_FLAG = 1024;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7;
input  DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15;
output DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7;
output DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [15:0] di;
wire [15:0] do;

wire FULL_sig, EMPTY_sig;		 
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ16 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ17 (EMPTY,EMPTY_sig);
buf INSXQ18 (AMFULL,AMFULL_node);
buf INSXQ19 (AMEMPTY,AMEMPTY_node);

assign di = {DI15,DI14,DI13,DI12,DI11,DI10,DI9,DI8,DI7,DI6,DI5,DI4,DI3,DI2,DI1,DI0};
//assign {DO15,DO14,DO13,DO12,DO11,DO10,DO9,DO8,DO7,DO6,DO5,DO4,DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
buf INSXQ4 (DO4,do[4]);
buf INSXQ5 (DO5,do[5]);
buf INSXQ6 (DO6,do[6]);
buf INSXQ7 (DO7,do[7]);
buf INSXQ8 (DO8,do[8]);
buf INSXQ9 (DO9,do[9]);
buf INSXQ10 (DO10,do[10]);
buf INSXQ11 (DO11,do[11]);
buf INSXQ12 (DO12,do[12]);
buf INSXQ13 (DO13,do[13]);
buf INSXQ14 (DO14,do[14]);
buf INSXQ15 (DO15,do[15]);
defparam FIFO_U0.ADDR_WIDTH = 10;
defparam FIFO_U0.DATA_WIDTH = 16;
defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);
	$setuphold  (posedge WCLK, DI2, 1, 0);
	$setuphold  (posedge WCLK, DI3, 1, 0);
	$setuphold  (posedge WCLK, DI4, 1, 0);
	$setuphold  (posedge WCLK, DI5, 1, 0);
	$setuphold  (posedge WCLK, DI6, 1, 0);
	$setuphold  (posedge WCLK, DI7, 1, 0);
	$setuphold  (posedge WCLK, DI8, 1, 0);
	$setuphold  (posedge WCLK, DI9, 1, 0);
	$setuphold  (posedge WCLK, DI10, 1, 0);
	$setuphold  (posedge WCLK, DI11, 1, 0);
	$setuphold  (posedge WCLK, DI12, 1, 0);
	$setuphold  (posedge WCLK, DI13, 1, 0);
	$setuphold  (posedge WCLK, DI14, 1, 0);
	$setuphold  (posedge WCLK, DI15, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

	(RCLK => DO0)    = (0:0:0, 0:0:0);
	(RCLK => DO1)    = (0:0:0, 0:0:0);
	(RCLK => DO2)    = (0:0:0, 0:0:0);
	(RCLK => DO3)    = (0:0:0, 0:0:0);
	(RCLK => DO4)    = (0:0:0, 0:0:0);
	(RCLK => DO5)    = (0:0:0, 0:0:0);
	(RCLK => DO6)    = (0:0:0, 0:0:0);
	(RCLK => DO7)    = (0:0:0, 0:0:0);
	(RCLK => DO8)    = (0:0:0, 0:0:0);
	(RCLK => DO9)    = (0:0:0, 0:0:0);
	(RCLK => DO10)    = (0:0:0, 0:0:0);
	(RCLK => DO11)    = (0:0:0, 0:0:0);
	(RCLK => DO12)    = (0:0:0, 0:0:0);
	(RCLK => DO13)    = (0:0:0, 0:0:0);
	(RCLK => DO14)    = (0:0:0, 0:0:0);
	(RCLK => DO15)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);

	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

	(RST  => DO0)    = (0:0:0, 0:0:0);
	(RST  => DO1)    = (0:0:0, 0:0:0);
	(RST  => DO2)    = (0:0:0, 0:0:0);
	(RST  => DO3)    = (0:0:0, 0:0:0);
	(RST  => DO4)    = (0:0:0, 0:0:0);
	(RST  => DO5)    = (0:0:0, 0:0:0);
	(RST  => DO6)    = (0:0:0, 0:0:0);
	(RST  => DO7)    = (0:0:0, 0:0:0);
	(RST  => DO8)    = (0:0:0, 0:0:0);
	(RST  => DO9)    = (0:0:0, 0:0:0);
	(RST  => DO10)    = (0:0:0, 0:0:0);
	(RST  => DO11)    = (0:0:0, 0:0:0);
	(RST  => DO12)    = (0:0:0, 0:0:0);
	(RST  => DO13)    = (0:0:0, 0:0:0);
	(RST  => DO14)    = (0:0:0, 0:0:0);
	(RST  => DO15)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMBFIFO512X28A(WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
                    DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,
                    DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15,
                    DI16,DI17,DI18,DI19,DI20,DI21,DI22,DI23,
                    DI24,DI25,DI26,DI27,
                    DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,
                    DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15,
                    DO16,DO17,DO18,DO19,DO20,DO21,DO22,DO23,
                    DO24,DO25,DO26,DO27,
                    FULL,AMFULL,EMPTY,AMEMPTY
);

parameter FIFO_FULL_FLAG = 512;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7;
input  DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15;
input  DI16,DI17,DI18,DI19,DI20,DI21,DI22,DI23;
input  DI24,DI25,DI26,DI27;
output DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7;
output DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15;
output DO16,DO17,DO18,DO19,DO20,DO21,DO22,DO23;
output DO24,DO25,DO26,DO27;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [27:0] di;
wire [27:0] do;
wire FULL_sig, EMPTY_sig;		
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ28 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ29 (EMPTY,EMPTY_sig);
buf INSXQ30 (AMFULL,AMFULL_node);
buf INSXQ31 (AMEMPTY,AMEMPTY_node);

assign di = {DI27,DI26,DI25,DI24,DI23,DI22,DI21,DI20,DI19,DI18,DI17,DI16,DI15,DI14,DI13,DI12,DI11,DI10,DI9,DI8,DI7,DI6,DI5,DI4,DI3,DI2,DI1,DI0};
//assign {DO27,DO26,DO25,DO24,DO23,DO22,DO21,DO20,DO19,DO18,DO17,DO16,DO15,DO14,DO13,DO12,DO11,DO10,DO9,DO8,DO7,DO6,DO5,DO4,DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
buf INSXQ4 (DO4,do[4]);
buf INSXQ5 (DO5,do[5]);
buf INSXQ6 (DO6,do[6]);
buf INSXQ7 (DO7,do[7]);
buf INSXQ8 (DO8,do[8]);
buf INSXQ9 (DO9,do[9]);

buf INSXQ10 (DO10,do[10]);
buf INSXQ11 (DO11,do[11]);
buf INSXQ12 (DO12,do[12]);
buf INSXQ13 (DO13,do[13]);
buf INSXQ14 (DO14,do[14]);
buf INSXQ15 (DO15,do[15]);
buf INSXQ16 (DO16,do[16]);
buf INSXQ17 (DO17,do[17]);
buf INSXQ18 (DO18,do[18]);
buf INSXQ19 (DO19,do[19]);

buf INSXQ20 (DO20,do[20]);
buf INSXQ21 (DO21,do[21]);
buf INSXQ22 (DO22,do[22]);
buf INSXQ23 (DO23,do[23]);
buf INSXQ24 (DO24,do[24]);
buf INSXQ25 (DO25,do[25]);
buf INSXQ26 (DO26,do[26]);
buf INSXQ27 (DO27,do[27]);
defparam FIFO_U0.ADDR_WIDTH = 9;
defparam FIFO_U0.DATA_WIDTH = 28;
defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);
	$setuphold  (posedge WCLK, DI2, 1, 0);
	$setuphold  (posedge WCLK, DI3, 1, 0);
	$setuphold  (posedge WCLK, DI4, 1, 0);
	$setuphold  (posedge WCLK, DI5, 1, 0);
	$setuphold  (posedge WCLK, DI6, 1, 0);
	$setuphold  (posedge WCLK, DI7, 1, 0);
	$setuphold  (posedge WCLK, DI8, 1, 0);
	$setuphold  (posedge WCLK, DI9, 1, 0);
	$setuphold  (posedge WCLK, DI10, 1, 0);
	$setuphold  (posedge WCLK, DI11, 1, 0);
	$setuphold  (posedge WCLK, DI12, 1, 0);
	$setuphold  (posedge WCLK, DI13, 1, 0);
	$setuphold  (posedge WCLK, DI14, 1, 0);
	$setuphold  (posedge WCLK, DI15, 1, 0);
	$setuphold  (posedge WCLK, DI16, 1, 0);
	$setuphold  (posedge WCLK, DI17, 1, 0);
	$setuphold  (posedge WCLK, DI18, 1, 0);
	$setuphold  (posedge WCLK, DI19, 1, 0);
	$setuphold  (posedge WCLK, DI20, 1, 0);
	$setuphold  (posedge WCLK, DI21, 1, 0);
	$setuphold  (posedge WCLK, DI22, 1, 0);
	$setuphold  (posedge WCLK, DI23, 1, 0);
	$setuphold  (posedge WCLK, DI24, 1, 0);
	$setuphold  (posedge WCLK, DI25, 1, 0);
	$setuphold  (posedge WCLK, DI26, 1, 0);
	$setuphold  (posedge WCLK, DI27, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

	(RCLK => DO0)    = (0:0:0, 0:0:0);
	(RCLK => DO1)    = (0:0:0, 0:0:0);
	(RCLK => DO2)    = (0:0:0, 0:0:0);
	(RCLK => DO3)    = (0:0:0, 0:0:0);
	(RCLK => DO4)    = (0:0:0, 0:0:0);
	(RCLK => DO5)    = (0:0:0, 0:0:0);
	(RCLK => DO6)    = (0:0:0, 0:0:0);
	(RCLK => DO7)    = (0:0:0, 0:0:0);
	(RCLK => DO8)    = (0:0:0, 0:0:0);
	(RCLK => DO9)    = (0:0:0, 0:0:0);
	(RCLK => DO10)    = (0:0:0, 0:0:0);
	(RCLK => DO11)    = (0:0:0, 0:0:0);
	(RCLK => DO12)    = (0:0:0, 0:0:0);
	(RCLK => DO13)    = (0:0:0, 0:0:0);
	(RCLK => DO14)    = (0:0:0, 0:0:0);
	(RCLK => DO15)    = (0:0:0, 0:0:0);
	(RCLK => DO16)    = (0:0:0, 0:0:0);
	(RCLK => DO17)    = (0:0:0, 0:0:0);
	(RCLK => DO18)    = (0:0:0, 0:0:0);
	(RCLK => DO19)    = (0:0:0, 0:0:0);
	(RCLK => DO20)    = (0:0:0, 0:0:0);
	(RCLK => DO21)    = (0:0:0, 0:0:0);
	(RCLK => DO22)    = (0:0:0, 0:0:0);
	(RCLK => DO23)    = (0:0:0, 0:0:0);
	(RCLK => DO24)    = (0:0:0, 0:0:0);
	(RCLK => DO25)    = (0:0:0, 0:0:0);
	(RCLK => DO26)    = (0:0:0, 0:0:0);
	(RCLK => DO27)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);

	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

	(RST  => DO0)    = (0:0:0, 0:0:0);
	(RST  => DO1)    = (0:0:0, 0:0:0);
	(RST  => DO2)    = (0:0:0, 0:0:0);
	(RST  => DO3)    = (0:0:0, 0:0:0);
	(RST  => DO4)    = (0:0:0, 0:0:0);
	(RST  => DO5)    = (0:0:0, 0:0:0);
	(RST  => DO6)    = (0:0:0, 0:0:0);
	(RST  => DO7)    = (0:0:0, 0:0:0);
	(RST  => DO8)    = (0:0:0, 0:0:0);
	(RST  => DO9)    = (0:0:0, 0:0:0);
	(RST  => DO10)    = (0:0:0, 0:0:0);
	(RST  => DO11)    = (0:0:0, 0:0:0);
	(RST  => DO12)    = (0:0:0, 0:0:0);
	(RST  => DO13)    = (0:0:0, 0:0:0);
	(RST  => DO14)    = (0:0:0, 0:0:0);
	(RST  => DO15)    = (0:0:0, 0:0:0);
	(RST  => DO16)    = (0:0:0, 0:0:0);
	(RST  => DO17)    = (0:0:0, 0:0:0);
	(RST  => DO18)    = (0:0:0, 0:0:0);
	(RST  => DO19)    = (0:0:0, 0:0:0);
	(RST  => DO20)    = (0:0:0, 0:0:0);
	(RST  => DO21)    = (0:0:0, 0:0:0);
	(RST  => DO22)    = (0:0:0, 0:0:0);
	(RST  => DO23)    = (0:0:0, 0:0:0);
	(RST  => DO24)    = (0:0:0, 0:0:0);
	(RST  => DO25)    = (0:0:0, 0:0:0);
	(RST  => DO26)    = (0:0:0, 0:0:0);
	(RST  => DO27)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);

	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMBFIFO512X32A(WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
                    DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,
                    DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15,
                    DI16,DI17,DI18,DI19,DI20,DI21,DI22,DI23,
                    DI24,DI25,DI26,DI27,DI28,DI29,DI30,DI31,
                    DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,
                    DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15,
                    DO16,DO17,DO18,DO19,DO20,DO21,DO22,DO23,
                    DO24,DO25,DO26,DO27,DO28,DO29,DO30,DO31,
                    FULL,AMFULL,EMPTY,AMEMPTY
);

parameter FIFO_FULL_FLAG = 512;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7;
input  DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15;
input  DI16,DI17,DI18,DI19,DI20,DI21,DI22,DI23;
input  DI24,DI25,DI26,DI27,DI28,DI29,DI30,DI31;
output DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7;
output DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15;
output DO16,DO17,DO18,DO19,DO20,DO21,DO22,DO23;
output DO24,DO25,DO26,DO27,DO28,DO29,DO30,DO31;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [31:0] di;
wire [31:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ32 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ33 (EMPTY,EMPTY_sig);
buf INSXQ34 (AMFULL,AMFULL_node);
buf INSXQ35 (AMEMPTY,AMEMPTY_node);

assign di = {DI31,DI30,DI29,DI28,DI27,DI26,DI25,DI24,DI23,DI22,DI21,DI20,DI19,DI18,DI17,DI16,DI15,DI14,DI13,DI12,DI11,DI10,DI9,DI8,DI7,DI6,DI5,DI4,DI3,DI2,DI1,DI0};
//assign {DO31,DO30,DO29,DO28,DO27,DO26,DO25,DO24,DO23,DO22,DO21,DO20,DO19,DO18,DO17,DO16,DO15,DO14,DO13,DO12,DO11,DO10,DO9,DO8,DO7,DO6,DO5,DO4,DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
buf INSXQ4 (DO4,do[4]);
buf INSXQ5 (DO5,do[5]);
buf INSXQ6 (DO6,do[6]);
buf INSXQ7 (DO7,do[7]);
buf INSXQ8 (DO8,do[8]);
buf INSXQ9 (DO9,do[9]);

buf INSXQ10 (DO10,do[10]);
buf INSXQ11 (DO11,do[11]);
buf INSXQ12 (DO12,do[12]);
buf INSXQ13 (DO13,do[13]);
buf INSXQ14 (DO14,do[14]);
buf INSXQ15 (DO15,do[15]);
buf INSXQ16 (DO16,do[16]);
buf INSXQ17 (DO17,do[17]);
buf INSXQ18 (DO18,do[18]);
buf INSXQ19 (DO19,do[19]);

buf INSXQ20 (DO20,do[20]);
buf INSXQ21 (DO21,do[21]);
buf INSXQ22 (DO22,do[22]);
buf INSXQ23 (DO23,do[23]);
buf INSXQ24 (DO24,do[24]);
buf INSXQ25 (DO25,do[25]);
buf INSXQ26 (DO26,do[26]);
buf INSXQ27 (DO27,do[27]);
buf INSXQ28 (DO28,do[28]);
buf INSXQ29 (DO29,do[29]);

buf INSXQ30 (DO30,do[30]);
buf INSXQ31 (DO31,do[31]);
defparam FIFO_U0.ADDR_WIDTH = 9;
defparam FIFO_U0.DATA_WIDTH = 32;
defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);
	$setuphold  (posedge WCLK, DI2, 1, 0);
	$setuphold  (posedge WCLK, DI3, 1, 0);
	$setuphold  (posedge WCLK, DI4, 1, 0);
	$setuphold  (posedge WCLK, DI5, 1, 0);
	$setuphold  (posedge WCLK, DI6, 1, 0);
	$setuphold  (posedge WCLK, DI7, 1, 0);
	$setuphold  (posedge WCLK, DI8, 1, 0);
	$setuphold  (posedge WCLK, DI9, 1, 0);
	$setuphold  (posedge WCLK, DI10, 1, 0);
	$setuphold  (posedge WCLK, DI11, 1, 0);
	$setuphold  (posedge WCLK, DI12, 1, 0);
	$setuphold  (posedge WCLK, DI13, 1, 0);
	$setuphold  (posedge WCLK, DI14, 1, 0);
	$setuphold  (posedge WCLK, DI15, 1, 0);
	$setuphold  (posedge WCLK, DI16, 1, 0);
	$setuphold  (posedge WCLK, DI17, 1, 0);
	$setuphold  (posedge WCLK, DI18, 1, 0);
	$setuphold  (posedge WCLK, DI19, 1, 0);
	$setuphold  (posedge WCLK, DI20, 1, 0);
	$setuphold  (posedge WCLK, DI21, 1, 0);
	$setuphold  (posedge WCLK, DI22, 1, 0);
	$setuphold  (posedge WCLK, DI23, 1, 0);
	$setuphold  (posedge WCLK, DI24, 1, 0);
	$setuphold  (posedge WCLK, DI25, 1, 0);
	$setuphold  (posedge WCLK, DI26, 1, 0);
	$setuphold  (posedge WCLK, DI27, 1, 0);
	$setuphold  (posedge WCLK, DI28, 1, 0);
	$setuphold  (posedge WCLK, DI29, 1, 0);
	$setuphold  (posedge WCLK, DI30, 1, 0);
	$setuphold  (posedge WCLK, DI31, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

	(RCLK => DO0)    = (0:0:0, 0:0:0);
	(RCLK => DO1)    = (0:0:0, 0:0:0);
	(RCLK => DO2)    = (0:0:0, 0:0:0);
	(RCLK => DO3)    = (0:0:0, 0:0:0);
	(RCLK => DO4)    = (0:0:0, 0:0:0);
	(RCLK => DO5)    = (0:0:0, 0:0:0);
	(RCLK => DO6)    = (0:0:0, 0:0:0);
	(RCLK => DO7)    = (0:0:0, 0:0:0);
	(RCLK => DO8)    = (0:0:0, 0:0:0);
	(RCLK => DO9)    = (0:0:0, 0:0:0);
	(RCLK => DO10)    = (0:0:0, 0:0:0);
	(RCLK => DO11)    = (0:0:0, 0:0:0);
	(RCLK => DO12)    = (0:0:0, 0:0:0);
	(RCLK => DO13)    = (0:0:0, 0:0:0);
	(RCLK => DO14)    = (0:0:0, 0:0:0);
	(RCLK => DO15)    = (0:0:0, 0:0:0);
	(RCLK => DO16)    = (0:0:0, 0:0:0);
	(RCLK => DO17)    = (0:0:0, 0:0:0);
	(RCLK => DO18)    = (0:0:0, 0:0:0);
	(RCLK => DO19)    = (0:0:0, 0:0:0);
	(RCLK => DO20)    = (0:0:0, 0:0:0);
	(RCLK => DO21)    = (0:0:0, 0:0:0);
	(RCLK => DO22)    = (0:0:0, 0:0:0);
	(RCLK => DO23)    = (0:0:0, 0:0:0);
	(RCLK => DO24)    = (0:0:0, 0:0:0);
	(RCLK => DO25)    = (0:0:0, 0:0:0);
	(RCLK => DO26)    = (0:0:0, 0:0:0);
	(RCLK => DO27)    = (0:0:0, 0:0:0);
	(RCLK => DO28)    = (0:0:0, 0:0:0);
	(RCLK => DO29)    = (0:0:0, 0:0:0);
	(RCLK => DO30)    = (0:0:0, 0:0:0);
	(RCLK => DO31)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);

	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

	(RST  => DO0)    = (0:0:0, 0:0:0);
	(RST  => DO1)    = (0:0:0, 0:0:0);
	(RST  => DO2)    = (0:0:0, 0:0:0);
	(RST  => DO3)    = (0:0:0, 0:0:0);
	(RST  => DO4)    = (0:0:0, 0:0:0);
	(RST  => DO5)    = (0:0:0, 0:0:0);
	(RST  => DO6)    = (0:0:0, 0:0:0);
	(RST  => DO7)    = (0:0:0, 0:0:0);
	(RST  => DO8)    = (0:0:0, 0:0:0);
	(RST  => DO9)    = (0:0:0, 0:0:0);
	(RST  => DO10)    = (0:0:0, 0:0:0);
	(RST  => DO11)    = (0:0:0, 0:0:0);
	(RST  => DO12)    = (0:0:0, 0:0:0);
	(RST  => DO13)    = (0:0:0, 0:0:0);
	(RST  => DO14)    = (0:0:0, 0:0:0);
	(RST  => DO15)    = (0:0:0, 0:0:0);
	(RST  => DO16)    = (0:0:0, 0:0:0);
	(RST  => DO17)    = (0:0:0, 0:0:0);
	(RST  => DO18)    = (0:0:0, 0:0:0);
	(RST  => DO19)    = (0:0:0, 0:0:0);
	(RST  => DO20)    = (0:0:0, 0:0:0);
	(RST  => DO21)    = (0:0:0, 0:0:0);
	(RST  => DO22)    = (0:0:0, 0:0:0);
	(RST  => DO23)    = (0:0:0, 0:0:0);
	(RST  => DO24)    = (0:0:0, 0:0:0);
	(RST  => DO25)    = (0:0:0, 0:0:0);
	(RST  => DO26)    = (0:0:0, 0:0:0);
	(RST  => DO27)    = (0:0:0, 0:0:0);
	(RST  => DO28)    = (0:0:0, 0:0:0);
	(RST  => DO29)    = (0:0:0, 0:0:0);
	(RST  => DO30)    = (0:0:0, 0:0:0);
	(RST  => DO31)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);

	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMBFIFO512X32A_FLAG(WE,WCLK,RE,RCLK,RST,RPRST,
                    FULL,AMFULL,EMPTY,AMEMPTY
);

parameter FIFO_FULL_FLAG = 512;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;


input  WE,WCLK,RE,RCLK,RST,RPRST;

output FULL,AMFULL,EMPTY,AMEMPTY;

wire [31:0] di;
wire [31:0] do;
wire FULLIN,EMPTYIN;
wire FULL_node,AMFULL_node,EMPTY_node,AMEMPTY_node;
reg notifier;

assign FULLIN = 0;
assign EMPTYIN = 0;
assign di = 0;

defparam FIFO_U0.ADDR_WIDTH = 9;
defparam FIFO_U0.DATA_WIDTH = 32;
defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_node),
		.EMPTY(EMPTY_node),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));						   
		
buf INSXQ1 (FULL,FULL_node);
buf INSXQ2 (EMPTY,EMPTY_node);
buf INSXQ3 (AMFULL,AMFULL_node);
buf INSXQ4 (AMEMPTY,AMEMPTY_node);		

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);

	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);

	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMBFIFO16KA_WX1_RX32_FLAG(WE,WCLK,RE,RCLK,RST,RPRST,
                    FULL,AMFULL,EMPTY,AMEMPTY
);

parameter FIFO_FULL_FLAG = 512;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;


input  WE,WCLK,RE,RCLK,RST,RPRST;

output FULL,AMFULL,EMPTY,AMEMPTY;

wire [31:0] di;
wire [31:0] do;
wire FULLIN,EMPTYIN;
wire FULL_node,AMFULL_node,EMPTY_node,AMEMPTY_node;
reg notifier;

assign FULLIN = 0;
assign EMPTYIN = 0;
assign di = 0;

defparam FIFO_U0.ADDR_WIDTH = 9;
defparam FIFO_U0.DATA_WIDTH = 32;
defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_node),
		.EMPTY(EMPTY_node),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));
buf INSXQ1 (FULL,FULL_node);
buf INSXQ2 (EMPTY,EMPTY_node);
buf INSXQ3 (AMFULL,AMFULL_node);
buf INSXQ4 (AMEMPTY,AMEMPTY_node);
specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);

	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);

	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMBFIFO16KA_WX2_RX32_FLAG(WE,WCLK,RE,RCLK,RST,RPRST,
                    FULL,AMFULL,EMPTY,AMEMPTY
);

parameter FIFO_FULL_FLAG = 512;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;


input  WE,WCLK,RE,RCLK,RST,RPRST;

output FULL,AMFULL,EMPTY,AMEMPTY;

wire [31:0] di;
wire [31:0] do;
wire FULLIN,EMPTYIN;
wire FULL_node,AMFULL_node,EMPTY_node,AMEMPTY_node;
reg notifier;

assign FULLIN = 0;
assign EMPTYIN = 0;
assign di = 0;

defparam FIFO_U0.ADDR_WIDTH = 9;
defparam FIFO_U0.DATA_WIDTH = 32;
defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_node),
		.EMPTY(EMPTY_node),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));
buf INSXQ1 (FULL,FULL_node);
buf INSXQ2 (EMPTY,EMPTY_node);
buf INSXQ3 (AMFULL,AMFULL_node);
buf INSXQ4 (AMEMPTY,AMEMPTY_node);
specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);

	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);

	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMBFIFO16KA_WX4_RX32_FLAG(WE,WCLK,RE,RCLK,RST,RPRST,
                    FULL,AMFULL,EMPTY,AMEMPTY
);

parameter FIFO_FULL_FLAG = 512;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;


input  WE,WCLK,RE,RCLK,RST,RPRST;

output FULL,AMFULL,EMPTY,AMEMPTY;

wire [31:0] di;
wire [31:0] do;
wire FULLIN,EMPTYIN;
wire FULL_node,AMFULL_node,EMPTY_node,AMEMPTY_node;
reg notifier;

assign FULLIN = 0;
assign EMPTYIN = 0;
assign di = 0;

defparam FIFO_U0.ADDR_WIDTH = 9;
defparam FIFO_U0.DATA_WIDTH = 32;
defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_node),
		.EMPTY(EMPTY_node),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));
buf INSXQ1 (FULL,FULL_node);
buf INSXQ2 (EMPTY,EMPTY_node);
buf INSXQ3 (AMFULL,AMFULL_node);
buf INSXQ4 (AMEMPTY,AMEMPTY_node);
specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);

	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);

	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMBFIFO16KA_WX8_RX32_FLAG(WE,WCLK,RE,RCLK,RST,RPRST,
                    FULL,AMFULL,EMPTY,AMEMPTY
);

parameter FIFO_FULL_FLAG = 512;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;


input  WE,WCLK,RE,RCLK,RST,RPRST;

output FULL,AMFULL,EMPTY,AMEMPTY;

wire [31:0] di;
wire [31:0] do;
wire FULLIN,EMPTYIN;
wire FULL_node,AMFULL_node,EMPTY_node,AMEMPTY_node;
reg notifier;

assign FULLIN = 0;
assign EMPTYIN = 0;
assign di = 0;

defparam FIFO_U0.ADDR_WIDTH = 9;
defparam FIFO_U0.DATA_WIDTH = 32;
defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_node),
		.EMPTY(EMPTY_node),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));
buf INSXQ1 (FULL,FULL_node);
buf INSXQ2 (EMPTY,EMPTY_node);
buf INSXQ3 (AMFULL,AMFULL_node);
buf INSXQ4 (AMEMPTY,AMEMPTY_node);
specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);

	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);

	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMBFIFO16KA_WX16_RX32_FLAG(WE,WCLK,RE,RCLK,RST,RPRST,
                    FULL,AMFULL,EMPTY,AMEMPTY
);

parameter FIFO_FULL_FLAG = 512;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;


input  WE,WCLK,RE,RCLK,RST,RPRST;

output FULL,AMFULL,EMPTY,AMEMPTY;

wire [31:0] di;
wire [31:0] do;
wire FULLIN,EMPTYIN;
wire FULL_node,AMFULL_node,EMPTY_node,AMEMPTY_node;
reg notifier;

assign FULLIN = 0;
assign EMPTYIN = 0;
assign di = 0;

defparam FIFO_U0.ADDR_WIDTH = 9;
defparam FIFO_U0.DATA_WIDTH = 32;
defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_node),
		.EMPTY(EMPTY_node),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));
buf INSXQ1 (FULL,FULL_node);
buf INSXQ2 (EMPTY,EMPTY_node);
buf INSXQ3 (AMFULL,AMFULL_node);
buf INSXQ4 (AMEMPTY,AMEMPTY_node);
specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);

	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);

	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module RAMBFIFO16KA_WX32_RX32_FLAG(WE,WCLK,RE,RCLK,RST,RPRST,
                    FULL,AMFULL,EMPTY,AMEMPTY
);

parameter FIFO_FULL_FLAG = 512;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;


input  WE,WCLK,RE,RCLK,RST,RPRST;

output FULL,AMFULL,EMPTY,AMEMPTY;

wire [31:0] di;
wire [31:0] do;
wire FULLIN,EMPTYIN;
wire FULL_node,AMFULL_node,EMPTY_node,AMEMPTY_node;
reg notifier;

assign FULLIN = 0;
assign EMPTYIN = 0;
assign di = 0;

defparam FIFO_U0.ADDR_WIDTH = 9;
defparam FIFO_U0.DATA_WIDTH = 32;
defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_node),
		.EMPTY(EMPTY_node),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));
buf INSXQ1 (FULL,FULL_node);
buf INSXQ2 (EMPTY,EMPTY_node);
buf INSXQ3 (AMFULL,AMFULL_node);
buf INSXQ4 (AMEMPTY,AMEMPTY_node);
specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);

	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);

	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module CAM128X48(CE,WE,CLK,EN_MASK,WR_MASK,WR_DC,RST,CS0,CS1,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,
                    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,
                    WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,
                    WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23,
                    WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31,
                    WD32,WD33,WD34,WD35,WD36,WD37,WD38,WD39,
                    WD40,WD41,WD42,WD43,WD44,WD45,WD46,WD47,
                    CO0,CO1,CO2,CO3,CO4,CO5,CO6,
                    MATCH,MUL_MATCH
);

parameter RAM_INIT_FILE = "";

input  CE,WE,CLK,EN_MASK,WR_MASK,WR_DC,RST,CS0,CS1;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7;
input  WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15;
input  WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23;
input  WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31;
input  WD32,WD33,WD34,WD35,WD36,WD37,WD38,WD39;
input  WD40,WD41,WD42,WD43,WD44,WD45,WD46,WD47;
output CO0,CO1,CO2,CO3,CO4,CO5,CO6;
output MATCH,MUL_MATCH;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [1:0] cs;
wire [6:0] wad;
wire [47:0] wd;
wire [6:0] co;	 
wire MATCH_node,MUL_MATCH_node;
reg notifier;

assign cs  = {CS1, CS0};
assign wad = {WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign wd  = {WD47,WD46,WD45,WD44,WD43,WD42,WD41,WD40,WD39,WD38,WD37,WD36,WD35,WD34,WD33,WD32,WD31,WD30,WD29,WD28,WD27,WD26,WD25,WD24,WD23,WD22,WD21,WD20,WD19,WD18,WD17,WD16,WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {CO6,CO5,CO4,CO3,CO2,CO1,CO0} = co;
buf INSXQ0 (CO0,co[0]);
buf INSXQ1 (CO1,co[1]);
buf INSXQ2 (CO2,co[2]);
buf INSXQ3 (CO3,co[3]);
buf INSXQ4 (CO4,co[4]);
buf INSXQ5 (CO5,co[5]);
buf INSXQ6 (CO6,co[6]);	  
buf INSXQ7 (MATCH,MATCH_node);
buf INSXQ8 (MUL_MATCH,MUL_MATCH_node);
defparam CAM_U0.ADDR_WIDTH = 7;
defparam CAM_U0.DATA_WIDTH = 48;
defparam CAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam CAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_CAM_16K CAM_U0(
		.CE(CE),
		.WE(WE),
		.CLK(CLK),
		.EN_MASK(EN_MASK),
		.WR_MASK(WR_MASK),
		.WR_DC(WR_DC),
		.RST(RST),
		.CS(cs),
		.WAD(wad),
		.WD(wd),
		.CO(co),
		.MATCH(MATCH_node),
		.MUL_MATCH(MUL_MATCH_node)
		);


specify
	$width (posedge CLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge CLK, CE, 1, 0);
	$setuphold  (posedge CLK, WE, 1, 0);
	$setuphold  (posedge CLK, EN_MASK, 1, 0);
	$setuphold  (posedge CLK, WR_MASK, 1, 0);
	$setuphold  (posedge CLK, WR_DC, 1, 0);
	$setuphold  (posedge CLK, CS0, 1, 0);
	$setuphold  (posedge CLK, CS1, 1, 0);

	$setuphold  (posedge CLK, WAD0, 1, 0);
	$setuphold  (posedge CLK, WAD1, 1, 0);
	$setuphold  (posedge CLK, WAD2, 1, 0);
	$setuphold  (posedge CLK, WAD3, 1, 0);
	$setuphold  (posedge CLK, WAD4, 1, 0);
	$setuphold  (posedge CLK, WAD5, 1, 0);
	$setuphold  (posedge CLK, WAD6, 1, 0);

	$setuphold  (posedge CLK, WD0, 1, 0);
	$setuphold  (posedge CLK, WD1, 1, 0);
	$setuphold  (posedge CLK, WD2, 1, 0);
	$setuphold  (posedge CLK, WD3, 1, 0);
	$setuphold  (posedge CLK, WD4, 1, 0);
	$setuphold  (posedge CLK, WD5, 1, 0);
	$setuphold  (posedge CLK, WD6, 1, 0);
	$setuphold  (posedge CLK, WD7, 1, 0);
	$setuphold  (posedge CLK, WD8, 1, 0);
	$setuphold  (posedge CLK, WD9, 1, 0);
	$setuphold  (posedge CLK, WD10, 1, 0);
	$setuphold  (posedge CLK, WD11, 1, 0);
	$setuphold  (posedge CLK, WD12, 1, 0);
	$setuphold  (posedge CLK, WD13, 1, 0);
	$setuphold  (posedge CLK, WD14, 1, 0);
	$setuphold  (posedge CLK, WD15, 1, 0);
	$setuphold  (posedge CLK, WD16, 1, 0);
	$setuphold  (posedge CLK, WD17, 1, 0);
	$setuphold  (posedge CLK, WD18, 1, 0);
	$setuphold  (posedge CLK, WD19, 1, 0);
	$setuphold  (posedge CLK, WD20, 1, 0);
	$setuphold  (posedge CLK, WD21, 1, 0);
	$setuphold  (posedge CLK, WD22, 1, 0);
	$setuphold  (posedge CLK, WD23, 1, 0);
	$setuphold  (posedge CLK, WD24, 1, 0);
	$setuphold  (posedge CLK, WD25, 1, 0);
	$setuphold  (posedge CLK, WD26, 1, 0);
	$setuphold  (posedge CLK, WD27, 1, 0);
	$setuphold  (posedge CLK, WD28, 1, 0);
	$setuphold  (posedge CLK, WD29, 1, 0);
	$setuphold  (posedge CLK, WD30, 1, 0);
	$setuphold  (posedge CLK, WD31, 1, 0);
	$setuphold  (posedge CLK, WD32, 1, 0);
	$setuphold  (posedge CLK, WD33, 1, 0);
	$setuphold  (posedge CLK, WD34, 1, 0);
	$setuphold  (posedge CLK, WD35, 1, 0);
	$setuphold  (posedge CLK, WD36, 1, 0);
	$setuphold  (posedge CLK, WD37, 1, 0);
	$setuphold  (posedge CLK, WD38, 1, 0);
	$setuphold  (posedge CLK, WD39, 1, 0);
	$setuphold  (posedge CLK, WD40, 1, 0);
	$setuphold  (posedge CLK, WD41, 1, 0);
	$setuphold  (posedge CLK, WD42, 1, 0);
	$setuphold  (posedge CLK, WD43, 1, 0);
	$setuphold  (posedge CLK, WD44, 1, 0);
	$setuphold  (posedge CLK, WD45, 1, 0);
	$setuphold  (posedge CLK, WD46, 1, 0);
	$setuphold  (posedge CLK, WD47, 1, 0);

        $recovery(posedge RST, posedge CLK, 1); 

	(CLK => CO0)    = (0:0:0, 0:0:0);
	(CLK => CO1)    = (0:0:0, 0:0:0);
	(CLK => CO2)    = (0:0:0, 0:0:0);
	(CLK => CO3)    = (0:0:0, 0:0:0);
	(CLK => CO4)    = (0:0:0, 0:0:0);
	(CLK => CO5)    = (0:0:0, 0:0:0);
	(CLK => CO6)    = (0:0:0, 0:0:0);
	(CLK => MATCH)        = (0:0:0, 0:0:0);
	(CLK => MUL_MATCH)    = (0:0:0, 0:0:0);

	(RST  => CO0)    = (0:0:0, 0:0:0);
	(RST  => CO1)    = (0:0:0, 0:0:0);
	(RST  => CO2)    = (0:0:0, 0:0:0);
	(RST  => CO3)    = (0:0:0, 0:0:0);
	(RST  => CO4)    = (0:0:0, 0:0:0);
	(RST  => CO5)    = (0:0:0, 0:0:0);
	(RST  => CO6)    = (0:0:0, 0:0:0);

	(RST => MATCH)        = (0:0:0, 0:0:0);
	(RST => MUL_MATCH)    = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module CAM128X48CL(CE,WE,CLK,EN_MASK,WR_MASK,WR_DC,RST,CS0,CS1,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,
                    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,
                    WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,
                    WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23,
                    WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31,
                    WD32,WD33,WD34,WD35,WD36,WD37,WD38,WD39,
                    WD40,WD41,WD42,WD43,WD44,WD45,WD46,WD47,
                    CMO0,CMO1,CMO2,CMO3,CMO4,CMO5,CMO6,CMO7,
                    CMO8,CMO9,CMO10,CMO11,CMO12,CMO13,CMO14,CMO15,
                    CMO16,CMO17,CMO18,CMO19,CMO20,CMO21,CMO22,CMO23,
                    CMO24,CMO25,CMO26,CMO27,CMO28,CMO29,CMO30,CMO31,
                    CMO32,CMO33,CMO34,CMO35,CMO36,CMO37,CMO38,CMO39,
                    CMO40,CMO41,CMO42,CMO43,CMO44,CMO45,CMO46,CMO47,
                    CMO48,CMO49,CMO50,CMO51,CMO52,CMO53,CMO54,CMO55,
                    CMO56,CMO57,CMO58,CMO59,CMO60,CMO61,CMO62,CMO63,
                    CMO64,CMO65,CMO66,CMO67,CMO68,CMO69,CMO70,CMO71,
                    CMO72,CMO73,CMO74,CMO75,CMO76,CMO77,CMO78,CMO79,
                    CMO80,CMO81,CMO82,CMO83,CMO84,CMO85,CMO86,CMO87,
                    CMO88,CMO89,CMO90,CMO91,CMO92,CMO93,CMO94,CMO95,
                    CMO96,CMO97,CMO98,CMO99,CMO100,CMO101,CMO102,CMO103,
                    CMO104,CMO105,CMO106,CMO107,CMO108,CMO109,CMO110,CMO111,
                    CMO112,CMO113,CMO114,CMO115,CMO116,CMO117,CMO118,CMO119,
                    CMO120,CMO121,CMO122,CMO123,CMO124,CMO125,CMO126,CMO127
);

parameter RAM_INIT_FILE = "";

input  CE,WE,CLK,EN_MASK,WR_MASK,WR_DC,RST,CS0,CS1;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7;
input  WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15;
input  WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23;
input  WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31;
input  WD32,WD33,WD34,WD35,WD36,WD37,WD38,WD39;
input  WD40,WD41,WD42,WD43,WD44,WD45,WD46,WD47;
output CMO0,CMO1,CMO2,CMO3,CMO4,CMO5,CMO6,CMO7;
output CMO8,CMO9,CMO10,CMO11,CMO12,CMO13,CMO14,CMO15;
output CMO16,CMO17,CMO18,CMO19,CMO20,CMO21,CMO22,CMO23;
output CMO24,CMO25,CMO26,CMO27,CMO28,CMO29,CMO30,CMO31;
output CMO32,CMO33,CMO34,CMO35,CMO36,CMO37,CMO38,CMO39;
output CMO40,CMO41,CMO42,CMO43,CMO44,CMO45,CMO46,CMO47;
output CMO48,CMO49,CMO50,CMO51,CMO52,CMO53,CMO54,CMO55;
output CMO56,CMO57,CMO58,CMO59,CMO60,CMO61,CMO62,CMO63;
output CMO64,CMO65,CMO66,CMO67,CMO68,CMO69,CMO70,CMO71;
output CMO72,CMO73,CMO74,CMO75,CMO76,CMO77,CMO78,CMO79;
output CMO80,CMO81,CMO82,CMO83,CMO84,CMO85,CMO86,CMO87;
output CMO88,CMO89,CMO90,CMO91,CMO92,CMO93,CMO94,CMO95;
output CMO96,CMO97,CMO98,CMO99,CMO100,CMO101,CMO102,CMO103;
output CMO104,CMO105,CMO106,CMO107,CMO108,CMO109,CMO110,CMO111;
output CMO112,CMO113,CMO114,CMO115,CMO116,CMO117,CMO118,CMO119;
output CMO120,CMO121,CMO122,CMO123,CMO124,CMO125,CMO126,CMO127;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [1:0] cs;
wire [6:0] wad;
wire [47:0] wd;
wire [127:0] cmo;
reg notifier;

assign cs  = {CS1, CS0};
assign wad = {WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign wd  = {WD47,WD46,WD45,WD44,WD43,WD42,WD41,WD40,WD39,WD38,WD37,WD36,WD35,WD34,WD33,WD32,WD31,WD30,WD29,WD28,WD27,WD26,WD25,WD24,WD23,WD22,WD21,WD20,WD19,WD18,WD17,WD16,WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {CMO127,CMO126,CMO125,CMO124,CMO123,CMO122,CMO121,CMO120,CMO119,CMO118,CMO117,CMO116,CMO115,CMO114,CMO113,CMO112,CMO111,CMO110,CMO109,CMO108,CMO107,CMO106,CMO105,CMO104,CMO103,CMO102,CMO101,CMO100,CMO99,CMO98,CMO97,CMO96,CMO95,CMO94,CMO93,CMO92,CMO91,CMO90,CMO89,CMO88,CMO87,CMO86,CMO85,CMO84,CMO83,CMO82,CMO81,CMO80,CMO79,CMO78,CMO77,CMO76,CMO75,CMO74,CMO73,CMO72,CMO71,CMO70,CMO69,CMO68,CMO67,CMO66,CMO65,CMO64,CMO63,CMO62,CMO61,CMO60,CMO59,CMO58,CMO57,CMO56,CMO55,CMO54,CMO53,CMO52,CMO51,CMO50,CMO49,CMO48,CMO47,CMO46,CMO45,CMO44,CMO43,CMO42,CMO41,CMO40,CMO39,CMO38,CMO37,CMO36,CMO35,CMO34,CMO33,CMO32,CMO31,CMO30,CMO29,CMO28,CMO27,CMO26,CMO25,CMO24,CMO23,CMO22,CMO21,CMO20,CMO19,CMO18,CMO17,CMO16,CMO15,CMO14,CMO13,CMO12,CMO11,CMO10,CMO9,CMO8,CMO7,CMO6,CMO5,CMO4,CMO3,CMO2,CMO1,CMO0} = cmo;
buf INSXQ0 (CMO0,cmo[0]);
buf INSXQ1 (CMO1,cmo[1]);
buf INSXQ2 (CMO2,cmo[2]);
buf INSXQ3 (CMO3,cmo[3]);
buf INSXQ4 (CMO4,cmo[4]);
buf INSXQ5 (CMO5,cmo[5]);
buf INSXQ6 (CMO6,cmo[6]);
buf INSXQ7 (CMO7,cmo[7]);
buf INSXQ8 (CMO8,cmo[8]);
buf INSXQ9 (CMO9,cmo[9]);

buf INSXQ10 (CMO10,cmo[10]);
buf INSXQ11 (CMO11,cmo[11]);
buf INSXQ12 (CMO12,cmo[12]);
buf INSXQ13 (CMO13,cmo[13]);
buf INSXQ14 (CMO14,cmo[14]);
buf INSXQ15 (CMO15,cmo[15]);
buf INSXQ16 (CMO16,cmo[16]);
buf INSXQ17 (CMO17,cmo[17]);
buf INSXQ18 (CMO18,cmo[18]);
buf INSXQ19 (CMO19,cmo[19]);

buf INSXQ20 (CMO20,cmo[20]);
buf INSXQ21 (CMO21,cmo[21]);
buf INSXQ22 (CMO22,cmo[22]);
buf INSXQ23 (CMO23,cmo[23]);
buf INSXQ24 (CMO24,cmo[24]);
buf INSXQ25 (CMO25,cmo[25]);
buf INSXQ26 (CMO26,cmo[26]);
buf INSXQ27 (CMO27,cmo[27]);
buf INSXQ28 (CMO28,cmo[28]);
buf INSXQ29 (CMO29,cmo[29]);

buf INSXQ30 (CMO30,cmo[30]);
buf INSXQ31 (CMO31,cmo[31]);
buf INSXQ32 (CMO32,cmo[32]);
buf INSXQ33 (CMO33,cmo[33]);
buf INSXQ34 (CMO34,cmo[34]);
buf INSXQ35 (CMO35,cmo[35]);
buf INSXQ36 (CMO36,cmo[36]);
buf INSXQ37 (CMO37,cmo[37]);
buf INSXQ38 (CMO38,cmo[38]);
buf INSXQ39 (CMO39,cmo[39]);

buf INSXQ40 (CMO40,cmo[40]);
buf INSXQ41 (CMO41,cmo[41]);
buf INSXQ42 (CMO42,cmo[42]);
buf INSXQ43 (CMO43,cmo[43]);
buf INSXQ44 (CMO44,cmo[44]);
buf INSXQ45 (CMO45,cmo[45]);
buf INSXQ46 (CMO46,cmo[46]);
buf INSXQ47 (CMO47,cmo[47]);
buf INSXQ48 (CMO48,cmo[48]);
buf INSXQ49 (CMO49,cmo[49]);

buf INSXQ50 (CMO50,cmo[50]);
buf INSXQ51 (CMO51,cmo[51]);
buf INSXQ52 (CMO52,cmo[52]);
buf INSXQ53 (CMO53,cmo[53]);
buf INSXQ54 (CMO54,cmo[54]);
buf INSXQ55 (CMO55,cmo[55]);
buf INSXQ56 (CMO56,cmo[56]);
buf INSXQ57 (CMO57,cmo[57]);
buf INSXQ58 (CMO58,cmo[58]);
buf INSXQ59 (CMO59,cmo[59]);

buf INSXQ60 (CMO60,cmo[60]);
buf INSXQ61 (CMO61,cmo[61]);
buf INSXQ62 (CMO62,cmo[62]);
buf INSXQ63 (CMO63,cmo[63]);
buf INSXQ64 (CMO64,cmo[64]);
buf INSXQ65 (CMO65,cmo[65]);
buf INSXQ66 (CMO66,cmo[66]);
buf INSXQ67 (CMO67,cmo[67]);
buf INSXQ68 (CMO68,cmo[68]);
buf INSXQ69 (CMO69,cmo[69]);

buf INSXQ70 (CMO70,cmo[70]);
buf INSXQ71 (CMO71,cmo[71]);
buf INSXQ72 (CMO72,cmo[72]);
buf INSXQ73 (CMO73,cmo[73]);
buf INSXQ74 (CMO74,cmo[74]);
buf INSXQ75 (CMO75,cmo[75]);
buf INSXQ76 (CMO76,cmo[76]);
buf INSXQ77 (CMO77,cmo[77]);
buf INSXQ78 (CMO78,cmo[78]);
buf INSXQ79 (CMO79,cmo[79]);

buf INSXQ80 (CMO80,cmo[80]);
buf INSXQ81 (CMO81,cmo[81]);
buf INSXQ82 (CMO82,cmo[82]);
buf INSXQ83 (CMO83,cmo[83]);
buf INSXQ84 (CMO84,cmo[84]);
buf INSXQ85 (CMO85,cmo[85]);
buf INSXQ86 (CMO86,cmo[86]);
buf INSXQ87 (CMO87,cmo[87]);
buf INSXQ88 (CMO88,cmo[88]);
buf INSXQ89 (CMO89,cmo[89]);

buf INSXQ90 (CMO90,cmo[90]);
buf INSXQ91 (CMO91,cmo[91]);
buf INSXQ92 (CMO92,cmo[92]);
buf INSXQ93 (CMO93,cmo[93]);
buf INSXQ94 (CMO94,cmo[94]);
buf INSXQ95 (CMO95,cmo[95]);
buf INSXQ96 (CMO96,cmo[96]);
buf INSXQ97 (CMO97,cmo[97]);
buf INSXQ98 (CMO98,cmo[98]);
buf INSXQ99 (CMO99,cmo[99]);

buf INSXQ100 (CMO100,cmo[100]);
buf INSXQ101 (CMO101,cmo[101]);
buf INSXQ102 (CMO102,cmo[102]);
buf INSXQ103 (CMO103,cmo[103]);
buf INSXQ104 (CMO104,cmo[104]);
buf INSXQ105 (CMO105,cmo[105]);
buf INSXQ106 (CMO106,cmo[106]);
buf INSXQ107 (CMO107,cmo[107]);
buf INSXQ108 (CMO108,cmo[108]);
buf INSXQ109 (CMO109,cmo[109]);

buf INSXQ110 (CMO110,cmo[110]);
buf INSXQ111 (CMO111,cmo[111]);
buf INSXQ112 (CMO112,cmo[112]);
buf INSXQ113 (CMO113,cmo[113]);
buf INSXQ114 (CMO114,cmo[114]);
buf INSXQ115 (CMO115,cmo[115]);
buf INSXQ116 (CMO116,cmo[116]);
buf INSXQ117 (CMO117,cmo[117]);
buf INSXQ118 (CMO118,cmo[118]);
buf INSXQ119 (CMO119,cmo[119]);

buf INSXQ120 (CMO120,cmo[120]);
buf INSXQ121 (CMO121,cmo[121]);
buf INSXQ122 (CMO122,cmo[122]);
buf INSXQ123 (CMO123,cmo[123]);
buf INSXQ124 (CMO124,cmo[124]);
buf INSXQ125 (CMO125,cmo[125]);
buf INSXQ126 (CMO126,cmo[126]);
buf INSXQ127 (CMO127,cmo[127]);

defparam CAM_U0.ADDR_WIDTH = 7;
defparam CAM_U0.DATA_WIDTH = 48;
defparam CAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam CAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_CAMCL_16K CAM_U0(
		.CE(CE),
		.WE(WE),
		.CLK(CLK),
		.EN_MASK(EN_MASK),
		.WR_MASK(WR_MASK),
		.WR_DC(WR_DC),
		.RST(RST),
		.CS(cs),
		.WAD(wad),
		.WD(wd),
		.CLO(cmo)
		);

specify
	$width (posedge CLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge CLK, CE, 1, 0);
	$setuphold  (posedge CLK, WE, 1, 0);
	$setuphold  (posedge CLK, EN_MASK, 1, 0);
	$setuphold  (posedge CLK, WR_MASK, 1, 0);
	$setuphold  (posedge CLK, WR_DC, 1, 0);
	$setuphold  (posedge CLK, CS0, 1, 0);
	$setuphold  (posedge CLK, CS1, 1, 0);

	$setuphold  (posedge CLK, WAD0, 1, 0);
	$setuphold  (posedge CLK, WAD1, 1, 0);
	$setuphold  (posedge CLK, WAD2, 1, 0);
	$setuphold  (posedge CLK, WAD3, 1, 0);
	$setuphold  (posedge CLK, WAD4, 1, 0);
	$setuphold  (posedge CLK, WAD5, 1, 0);
	$setuphold  (posedge CLK, WAD6, 1, 0);

	$setuphold  (posedge CLK, WD0, 1, 0);
	$setuphold  (posedge CLK, WD1, 1, 0);
	$setuphold  (posedge CLK, WD2, 1, 0);
	$setuphold  (posedge CLK, WD3, 1, 0);
	$setuphold  (posedge CLK, WD4, 1, 0);
	$setuphold  (posedge CLK, WD5, 1, 0);
	$setuphold  (posedge CLK, WD6, 1, 0);
	$setuphold  (posedge CLK, WD7, 1, 0);
	$setuphold  (posedge CLK, WD8, 1, 0);
	$setuphold  (posedge CLK, WD9, 1, 0);
	$setuphold  (posedge CLK, WD10, 1, 0);
	$setuphold  (posedge CLK, WD11, 1, 0);
	$setuphold  (posedge CLK, WD12, 1, 0);
	$setuphold  (posedge CLK, WD13, 1, 0);
	$setuphold  (posedge CLK, WD14, 1, 0);
	$setuphold  (posedge CLK, WD15, 1, 0);
	$setuphold  (posedge CLK, WD16, 1, 0);
	$setuphold  (posedge CLK, WD17, 1, 0);
	$setuphold  (posedge CLK, WD18, 1, 0);
	$setuphold  (posedge CLK, WD19, 1, 0);
	$setuphold  (posedge CLK, WD20, 1, 0);
	$setuphold  (posedge CLK, WD21, 1, 0);
	$setuphold  (posedge CLK, WD22, 1, 0);
	$setuphold  (posedge CLK, WD23, 1, 0);
	$setuphold  (posedge CLK, WD24, 1, 0);
	$setuphold  (posedge CLK, WD25, 1, 0);
	$setuphold  (posedge CLK, WD26, 1, 0);
	$setuphold  (posedge CLK, WD27, 1, 0);
	$setuphold  (posedge CLK, WD28, 1, 0);
	$setuphold  (posedge CLK, WD29, 1, 0);
	$setuphold  (posedge CLK, WD30, 1, 0);
	$setuphold  (posedge CLK, WD31, 1, 0);
	$setuphold  (posedge CLK, WD32, 1, 0);
	$setuphold  (posedge CLK, WD33, 1, 0);
	$setuphold  (posedge CLK, WD34, 1, 0);
	$setuphold  (posedge CLK, WD35, 1, 0);
	$setuphold  (posedge CLK, WD36, 1, 0);
	$setuphold  (posedge CLK, WD37, 1, 0);
	$setuphold  (posedge CLK, WD38, 1, 0);
	$setuphold  (posedge CLK, WD39, 1, 0);
	$setuphold  (posedge CLK, WD40, 1, 0);
	$setuphold  (posedge CLK, WD41, 1, 0);
	$setuphold  (posedge CLK, WD42, 1, 0);
	$setuphold  (posedge CLK, WD43, 1, 0);
	$setuphold  (posedge CLK, WD44, 1, 0);
	$setuphold  (posedge CLK, WD45, 1, 0);
	$setuphold  (posedge CLK, WD46, 1, 0);
	$setuphold  (posedge CLK, WD47, 1, 0);

        $recovery(posedge RST, posedge CLK, 1); 

	(CLK => CMO0)    = (0:0:0, 0:0:0);
	(CLK => CMO1)    = (0:0:0, 0:0:0);
	(CLK => CMO2)    = (0:0:0, 0:0:0);
	(CLK => CMO3)    = (0:0:0, 0:0:0);
	(CLK => CMO4)    = (0:0:0, 0:0:0);
	(CLK => CMO5)    = (0:0:0, 0:0:0);
	(CLK => CMO6)    = (0:0:0, 0:0:0);
	(CLK => CMO7)    = (0:0:0, 0:0:0);
	(CLK => CMO8)    = (0:0:0, 0:0:0);
	(CLK => CMO9)    = (0:0:0, 0:0:0);
	(CLK => CMO10)   = (0:0:0, 0:0:0);
	(CLK => CMO11)   = (0:0:0, 0:0:0);
	(CLK => CMO12)   = (0:0:0, 0:0:0);
	(CLK => CMO13)   = (0:0:0, 0:0:0);
	(CLK => CMO14)   = (0:0:0, 0:0:0);
	(CLK => CMO15)   = (0:0:0, 0:0:0);
	(CLK => CMO16)   = (0:0:0, 0:0:0);
	(CLK => CMO17)   = (0:0:0, 0:0:0);
	(CLK => CMO18)   = (0:0:0, 0:0:0);
	(CLK => CMO19)   = (0:0:0, 0:0:0);
	(CLK => CMO20)   = (0:0:0, 0:0:0);
	(CLK => CMO21)   = (0:0:0, 0:0:0);
	(CLK => CMO22)   = (0:0:0, 0:0:0);
	(CLK => CMO23)   = (0:0:0, 0:0:0);
	(CLK => CMO24)   = (0:0:0, 0:0:0);
	(CLK => CMO25)   = (0:0:0, 0:0:0);
	(CLK => CMO26)   = (0:0:0, 0:0:0);
	(CLK => CMO27)   = (0:0:0, 0:0:0);
	(CLK => CMO28)   = (0:0:0, 0:0:0);
	(CLK => CMO29)   = (0:0:0, 0:0:0);
	(CLK => CMO30)   = (0:0:0, 0:0:0);
	(CLK => CMO31)   = (0:0:0, 0:0:0);
	(CLK => CMO32)   = (0:0:0, 0:0:0);
	(CLK => CMO33)   = (0:0:0, 0:0:0);
	(CLK => CMO34)   = (0:0:0, 0:0:0);
	(CLK => CMO35)   = (0:0:0, 0:0:0);
	(CLK => CMO36)   = (0:0:0, 0:0:0);
	(CLK => CMO37)   = (0:0:0, 0:0:0);
	(CLK => CMO38)   = (0:0:0, 0:0:0);
	(CLK => CMO39)   = (0:0:0, 0:0:0);
	(CLK => CMO40)   = (0:0:0, 0:0:0);
	(CLK => CMO41)   = (0:0:0, 0:0:0);
	(CLK => CMO42)   = (0:0:0, 0:0:0);
	(CLK => CMO43)   = (0:0:0, 0:0:0);
	(CLK => CMO44)   = (0:0:0, 0:0:0);
	(CLK => CMO45)   = (0:0:0, 0:0:0);
	(CLK => CMO46)   = (0:0:0, 0:0:0);
	(CLK => CMO47)   = (0:0:0, 0:0:0);
	(CLK => CMO48)   = (0:0:0, 0:0:0);
	(CLK => CMO49)   = (0:0:0, 0:0:0);
	(CLK => CMO50)   = (0:0:0, 0:0:0);
	(CLK => CMO51)   = (0:0:0, 0:0:0);
	(CLK => CMO52)   = (0:0:0, 0:0:0);
	(CLK => CMO53)   = (0:0:0, 0:0:0);
	(CLK => CMO54)   = (0:0:0, 0:0:0);
	(CLK => CMO55)   = (0:0:0, 0:0:0);
	(CLK => CMO56)   = (0:0:0, 0:0:0);
	(CLK => CMO57)   = (0:0:0, 0:0:0);
	(CLK => CMO58)   = (0:0:0, 0:0:0);
	(CLK => CMO59)   = (0:0:0, 0:0:0);
	(CLK => CMO60)   = (0:0:0, 0:0:0);
	(CLK => CMO61)   = (0:0:0, 0:0:0);
	(CLK => CMO62)   = (0:0:0, 0:0:0);
	(CLK => CMO63)   = (0:0:0, 0:0:0);
	(CLK => CMO64)   = (0:0:0, 0:0:0);
	(CLK => CMO65)   = (0:0:0, 0:0:0);
	(CLK => CMO66)   = (0:0:0, 0:0:0);
	(CLK => CMO67)   = (0:0:0, 0:0:0);
	(CLK => CMO68)   = (0:0:0, 0:0:0);
	(CLK => CMO69)   = (0:0:0, 0:0:0);
	(CLK => CMO70)   = (0:0:0, 0:0:0);
	(CLK => CMO71)   = (0:0:0, 0:0:0);
	(CLK => CMO72)   = (0:0:0, 0:0:0);
	(CLK => CMO73)   = (0:0:0, 0:0:0);
	(CLK => CMO74)   = (0:0:0, 0:0:0);
	(CLK => CMO75)   = (0:0:0, 0:0:0);
	(CLK => CMO76)   = (0:0:0, 0:0:0);
	(CLK => CMO77)   = (0:0:0, 0:0:0);
	(CLK => CMO78)   = (0:0:0, 0:0:0);
	(CLK => CMO79)   = (0:0:0, 0:0:0);
	(CLK => CMO80)   = (0:0:0, 0:0:0);
	(CLK => CMO81)   = (0:0:0, 0:0:0);
	(CLK => CMO82)   = (0:0:0, 0:0:0);
	(CLK => CMO83)   = (0:0:0, 0:0:0);
	(CLK => CMO84)   = (0:0:0, 0:0:0);
	(CLK => CMO85)   = (0:0:0, 0:0:0);
	(CLK => CMO86)   = (0:0:0, 0:0:0);
	(CLK => CMO87)   = (0:0:0, 0:0:0);
	(CLK => CMO88)   = (0:0:0, 0:0:0);
	(CLK => CMO89)   = (0:0:0, 0:0:0);
	(CLK => CMO90)   = (0:0:0, 0:0:0);
	(CLK => CMO91)   = (0:0:0, 0:0:0);
	(CLK => CMO92)   = (0:0:0, 0:0:0);
	(CLK => CMO93)   = (0:0:0, 0:0:0);
	(CLK => CMO94)   = (0:0:0, 0:0:0);
	(CLK => CMO95)   = (0:0:0, 0:0:0);
	(CLK => CMO96)   = (0:0:0, 0:0:0);
	(CLK => CMO97)   = (0:0:0, 0:0:0);
	(CLK => CMO98)   = (0:0:0, 0:0:0);
	(CLK => CMO99)   = (0:0:0, 0:0:0);
	(CLK => CMO100)   = (0:0:0, 0:0:0);
	(CLK => CMO101)   = (0:0:0, 0:0:0);
	(CLK => CMO102)   = (0:0:0, 0:0:0);
	(CLK => CMO103)   = (0:0:0, 0:0:0);
	(CLK => CMO104)   = (0:0:0, 0:0:0);
	(CLK => CMO105)   = (0:0:0, 0:0:0);
	(CLK => CMO106)   = (0:0:0, 0:0:0);
	(CLK => CMO107)   = (0:0:0, 0:0:0);
	(CLK => CMO108)   = (0:0:0, 0:0:0);
	(CLK => CMO109)   = (0:0:0, 0:0:0);
	(CLK => CMO110)   = (0:0:0, 0:0:0);
	(CLK => CMO111)   = (0:0:0, 0:0:0);
	(CLK => CMO112)   = (0:0:0, 0:0:0);
	(CLK => CMO113)   = (0:0:0, 0:0:0);
	(CLK => CMO114)   = (0:0:0, 0:0:0);
	(CLK => CMO115)   = (0:0:0, 0:0:0);
	(CLK => CMO116)   = (0:0:0, 0:0:0);
	(CLK => CMO117)   = (0:0:0, 0:0:0);
	(CLK => CMO118)   = (0:0:0, 0:0:0);
	(CLK => CMO119)   = (0:0:0, 0:0:0);
	(CLK => CMO120)   = (0:0:0, 0:0:0);
	(CLK => CMO121)   = (0:0:0, 0:0:0);
	(CLK => CMO122)   = (0:0:0, 0:0:0);
	(CLK => CMO123)   = (0:0:0, 0:0:0);
	(CLK => CMO124)   = (0:0:0, 0:0:0);
	(CLK => CMO125)   = (0:0:0, 0:0:0);
	(CLK => CMO126)   = (0:0:0, 0:0:0);
	(CLK => CMO127)   = (0:0:0, 0:0:0);

	(RST  => CMO0)    = (0:0:0, 0:0:0);
	(RST  => CMO1)    = (0:0:0, 0:0:0);
	(RST  => CMO2)    = (0:0:0, 0:0:0);
	(RST  => CMO3)    = (0:0:0, 0:0:0);
	(RST  => CMO4)    = (0:0:0, 0:0:0);
	(RST  => CMO5)    = (0:0:0, 0:0:0);
	(RST  => CMO6)    = (0:0:0, 0:0:0);
	(RST  => CMO7)    = (0:0:0, 0:0:0);
	(RST => CMO8)    = (0:0:0, 0:0:0);
	(RST => CMO9)    = (0:0:0, 0:0:0);
	(RST => CMO10)   = (0:0:0, 0:0:0);
	(RST => CMO11)   = (0:0:0, 0:0:0);
	(RST => CMO12)   = (0:0:0, 0:0:0);
	(RST => CMO13)   = (0:0:0, 0:0:0);
	(RST => CMO14)   = (0:0:0, 0:0:0);
	(RST => CMO15)   = (0:0:0, 0:0:0);
	(RST => CMO16)   = (0:0:0, 0:0:0);
	(RST => CMO17)   = (0:0:0, 0:0:0);
	(RST => CMO18)   = (0:0:0, 0:0:0);
	(RST => CMO19)   = (0:0:0, 0:0:0);
	(RST => CMO20)   = (0:0:0, 0:0:0);
	(RST => CMO21)   = (0:0:0, 0:0:0);
	(RST => CMO22)   = (0:0:0, 0:0:0);
	(RST => CMO23)   = (0:0:0, 0:0:0);
	(RST => CMO24)   = (0:0:0, 0:0:0);
	(RST => CMO25)   = (0:0:0, 0:0:0);
	(RST => CMO26)   = (0:0:0, 0:0:0);
	(RST => CMO27)   = (0:0:0, 0:0:0);
	(RST => CMO28)   = (0:0:0, 0:0:0);
	(RST => CMO29)   = (0:0:0, 0:0:0);
	(RST => CMO30)   = (0:0:0, 0:0:0);
	(RST => CMO31)   = (0:0:0, 0:0:0);
	(RST => CMO32)   = (0:0:0, 0:0:0);
	(RST => CMO33)   = (0:0:0, 0:0:0);
	(RST => CMO34)   = (0:0:0, 0:0:0);
	(RST => CMO35)   = (0:0:0, 0:0:0);
	(RST => CMO36)   = (0:0:0, 0:0:0);
	(RST => CMO37)   = (0:0:0, 0:0:0);
	(RST => CMO38)   = (0:0:0, 0:0:0);
	(RST => CMO39)   = (0:0:0, 0:0:0);
	(RST => CMO40)   = (0:0:0, 0:0:0);
	(RST => CMO41)   = (0:0:0, 0:0:0);
	(RST => CMO42)   = (0:0:0, 0:0:0);
	(RST => CMO43)   = (0:0:0, 0:0:0);
	(RST => CMO44)   = (0:0:0, 0:0:0);
	(RST => CMO45)   = (0:0:0, 0:0:0);
	(RST => CMO46)   = (0:0:0, 0:0:0);
	(RST => CMO47)   = (0:0:0, 0:0:0);
	(RST => CMO48)   = (0:0:0, 0:0:0);
	(RST => CMO49)   = (0:0:0, 0:0:0);
	(RST => CMO50)   = (0:0:0, 0:0:0);
	(RST => CMO51)   = (0:0:0, 0:0:0);
	(RST => CMO52)   = (0:0:0, 0:0:0);
	(RST => CMO53)   = (0:0:0, 0:0:0);
	(RST => CMO54)   = (0:0:0, 0:0:0);
	(RST => CMO55)   = (0:0:0, 0:0:0);
	(RST => CMO56)   = (0:0:0, 0:0:0);
	(RST => CMO57)   = (0:0:0, 0:0:0);
	(RST => CMO58)   = (0:0:0, 0:0:0);
	(RST => CMO59)   = (0:0:0, 0:0:0);
	(RST => CMO60)   = (0:0:0, 0:0:0);
	(RST => CMO61)   = (0:0:0, 0:0:0);
	(RST => CMO62)   = (0:0:0, 0:0:0);
	(RST => CMO63)   = (0:0:0, 0:0:0);
	(RST => CMO64)   = (0:0:0, 0:0:0);
	(RST => CMO65)   = (0:0:0, 0:0:0);
	(RST => CMO66)   = (0:0:0, 0:0:0);
	(RST => CMO67)   = (0:0:0, 0:0:0);
	(RST => CMO68)   = (0:0:0, 0:0:0);
	(RST => CMO69)   = (0:0:0, 0:0:0);
	(RST => CMO70)   = (0:0:0, 0:0:0);
	(RST => CMO71)   = (0:0:0, 0:0:0);
	(RST => CMO72)   = (0:0:0, 0:0:0);
	(RST => CMO73)   = (0:0:0, 0:0:0);
	(RST => CMO74)   = (0:0:0, 0:0:0);
	(RST => CMO75)   = (0:0:0, 0:0:0);
	(RST => CMO76)   = (0:0:0, 0:0:0);
	(RST => CMO77)   = (0:0:0, 0:0:0);
	(RST => CMO78)   = (0:0:0, 0:0:0);
	(RST => CMO79)   = (0:0:0, 0:0:0);
	(RST => CMO80)   = (0:0:0, 0:0:0);
	(RST => CMO81)   = (0:0:0, 0:0:0);
	(RST => CMO82)   = (0:0:0, 0:0:0);
	(RST => CMO83)   = (0:0:0, 0:0:0);
	(RST => CMO84)   = (0:0:0, 0:0:0);
	(RST => CMO85)   = (0:0:0, 0:0:0);
	(RST => CMO86)   = (0:0:0, 0:0:0);
	(RST => CMO87)   = (0:0:0, 0:0:0);
	(RST => CMO88)   = (0:0:0, 0:0:0);
	(RST => CMO89)   = (0:0:0, 0:0:0);
	(RST => CMO90)   = (0:0:0, 0:0:0);
	(RST => CMO91)   = (0:0:0, 0:0:0);
	(RST => CMO92)   = (0:0:0, 0:0:0);
	(RST => CMO93)   = (0:0:0, 0:0:0);
	(RST => CMO94)   = (0:0:0, 0:0:0);
	(RST => CMO95)   = (0:0:0, 0:0:0);
	(RST => CMO96)   = (0:0:0, 0:0:0);
	(RST => CMO97)   = (0:0:0, 0:0:0);
	(RST => CMO98)   = (0:0:0, 0:0:0);
	(RST => CMO99)   = (0:0:0, 0:0:0);
	(RST => CMO100)   = (0:0:0, 0:0:0);
	(RST => CMO101)   = (0:0:0, 0:0:0);
	(RST => CMO102)   = (0:0:0, 0:0:0);
	(RST => CMO103)   = (0:0:0, 0:0:0);
	(RST => CMO104)   = (0:0:0, 0:0:0);
	(RST => CMO105)   = (0:0:0, 0:0:0);
	(RST => CMO106)   = (0:0:0, 0:0:0);
	(RST => CMO107)   = (0:0:0, 0:0:0);
	(RST => CMO108)   = (0:0:0, 0:0:0);
	(RST => CMO109)   = (0:0:0, 0:0:0);
	(RST => CMO110)   = (0:0:0, 0:0:0);
	(RST => CMO111)   = (0:0:0, 0:0:0);
	(RST => CMO112)   = (0:0:0, 0:0:0);
	(RST => CMO113)   = (0:0:0, 0:0:0);
	(RST => CMO114)   = (0:0:0, 0:0:0);
	(RST => CMO115)   = (0:0:0, 0:0:0);
	(RST => CMO116)   = (0:0:0, 0:0:0);
	(RST => CMO117)   = (0:0:0, 0:0:0);
	(RST => CMO118)   = (0:0:0, 0:0:0);
	(RST => CMO119)   = (0:0:0, 0:0:0);
	(RST => CMO120)   = (0:0:0, 0:0:0);
	(RST => CMO121)   = (0:0:0, 0:0:0);
	(RST => CMO122)   = (0:0:0, 0:0:0);
	(RST => CMO123)   = (0:0:0, 0:0:0);
	(RST => CMO124)   = (0:0:0, 0:0:0);
	(RST => CMO125)   = (0:0:0, 0:0:0);
	(RST => CMO126)   = (0:0:0, 0:0:0);
	(RST => CMO127)   = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module CAM128X48CM(CE,WE,CLK,EN_MASK,WR_MASK,WR_DC,RST,CS0,CS1,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,
                    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,
                    WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,
                    WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23,
                    WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31,
                    WD32,WD33,WD34,WD35,WD36,WD37,WD38,WD39,
                    WD40,WD41,WD42,WD43,WD44,WD45,WD46,WD47,
                    CMI0,CMI1,CMI2,CMI3,CMI4,CMI5,CMI6,CMI7,
                    CMI8,CMI9,CMI10,CMI11,CMI12,CMI13,CMI14,CMI15,
                    CMI16,CMI17,CMI18,CMI19,CMI20,CMI21,CMI22,CMI23,
                    CMI24,CMI25,CMI26,CMI27,CMI28,CMI29,CMI30,CMI31,
                    CMI32,CMI33,CMI34,CMI35,CMI36,CMI37,CMI38,CMI39,
                    CMI40,CMI41,CMI42,CMI43,CMI44,CMI45,CMI46,CMI47,
                    CMI48,CMI49,CMI50,CMI51,CMI52,CMI53,CMI54,CMI55,
                    CMI56,CMI57,CMI58,CMI59,CMI60,CMI61,CMI62,CMI63,
                    CMI64,CMI65,CMI66,CMI67,CMI68,CMI69,CMI70,CMI71,
                    CMI72,CMI73,CMI74,CMI75,CMI76,CMI77,CMI78,CMI79,
                    CMI80,CMI81,CMI82,CMI83,CMI84,CMI85,CMI86,CMI87,
                    CMI88,CMI89,CMI90,CMI91,CMI92,CMI93,CMI94,CMI95,
                    CMI96,CMI97,CMI98,CMI99,CMI100,CMI101,CMI102,CMI103,
                    CMI104,CMI105,CMI106,CMI107,CMI108,CMI109,CMI110,CMI111,
                    CMI112,CMI113,CMI114,CMI115,CMI116,CMI117,CMI118,CMI119,
                    CMI120,CMI121,CMI122,CMI123,CMI124,CMI125,CMI126,CMI127,
                    CMO0,CMO1,CMO2,CMO3,CMO4,CMO5,CMO6,CMO7,
                    CMO8,CMO9,CMO10,CMO11,CMO12,CMO13,CMO14,CMO15,
                    CMO16,CMO17,CMO18,CMO19,CMO20,CMO21,CMO22,CMO23,
                    CMO24,CMO25,CMO26,CMO27,CMO28,CMO29,CMO30,CMO31,
                    CMO32,CMO33,CMO34,CMO35,CMO36,CMO37,CMO38,CMO39,
                    CMO40,CMO41,CMO42,CMO43,CMO44,CMO45,CMO46,CMO47,
                    CMO48,CMO49,CMO50,CMO51,CMO52,CMO53,CMO54,CMO55,
                    CMO56,CMO57,CMO58,CMO59,CMO60,CMO61,CMO62,CMO63,
                    CMO64,CMO65,CMO66,CMO67,CMO68,CMO69,CMO70,CMO71,
                    CMO72,CMO73,CMO74,CMO75,CMO76,CMO77,CMO78,CMO79,
                    CMO80,CMO81,CMO82,CMO83,CMO84,CMO85,CMO86,CMO87,
                    CMO88,CMO89,CMO90,CMO91,CMO92,CMO93,CMO94,CMO95,
                    CMO96,CMO97,CMO98,CMO99,CMO100,CMO101,CMO102,CMO103,
                    CMO104,CMO105,CMO106,CMO107,CMO108,CMO109,CMO110,CMO111,
                    CMO112,CMO113,CMO114,CMO115,CMO116,CMO117,CMO118,CMO119,
                    CMO120,CMO121,CMO122,CMO123,CMO124,CMO125,CMO126,CMO127
);

parameter RAM_INIT_FILE = "";

input  CE,WE,CLK,EN_MASK,WR_MASK,WR_DC,RST,CS0,CS1;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7;
input  WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15;
input  WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23;
input  WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31;
input  WD32,WD33,WD34,WD35,WD36,WD37,WD38,WD39;
input  WD40,WD41,WD42,WD43,WD44,WD45,WD46,WD47;
input  CMI0,CMI1,CMI2,CMI3,CMI4,CMI5,CMI6,CMI7;
input  CMI8,CMI9,CMI10,CMI11,CMI12,CMI13,CMI14,CMI15;
input  CMI16,CMI17,CMI18,CMI19,CMI20,CMI21,CMI22,CMI23;
input  CMI24,CMI25,CMI26,CMI27,CMI28,CMI29,CMI30,CMI31;
input  CMI32,CMI33,CMI34,CMI35,CMI36,CMI37,CMI38,CMI39;
input  CMI40,CMI41,CMI42,CMI43,CMI44,CMI45,CMI46,CMI47;
input  CMI48,CMI49,CMI50,CMI51,CMI52,CMI53,CMI54,CMI55;
input  CMI56,CMI57,CMI58,CMI59,CMI60,CMI61,CMI62,CMI63;
input  CMI64,CMI65,CMI66,CMI67,CMI68,CMI69,CMI70,CMI71;
input  CMI72,CMI73,CMI74,CMI75,CMI76,CMI77,CMI78,CMI79;
input  CMI80,CMI81,CMI82,CMI83,CMI84,CMI85,CMI86,CMI87;
input  CMI88,CMI89,CMI90,CMI91,CMI92,CMI93,CMI94,CMI95;
input  CMI96,CMI97,CMI98,CMI99,CMI100,CMI101,CMI102,CMI103;
input  CMI104,CMI105,CMI106,CMI107,CMI108,CMI109,CMI110,CMI111;
input  CMI112,CMI113,CMI114,CMI115,CMI116,CMI117,CMI118,CMI119;
input  CMI120,CMI121,CMI122,CMI123,CMI124,CMI125,CMI126,CMI127;
output CMO0,CMO1,CMO2,CMO3,CMO4,CMO5,CMO6,CMO7;
output CMO8,CMO9,CMO10,CMO11,CMO12,CMO13,CMO14,CMO15;
output CMO16,CMO17,CMO18,CMO19,CMO20,CMO21,CMO22,CMO23;
output CMO24,CMO25,CMO26,CMO27,CMO28,CMO29,CMO30,CMO31;
output CMO32,CMO33,CMO34,CMO35,CMO36,CMO37,CMO38,CMO39;
output CMO40,CMO41,CMO42,CMO43,CMO44,CMO45,CMO46,CMO47;
output CMO48,CMO49,CMO50,CMO51,CMO52,CMO53,CMO54,CMO55;
output CMO56,CMO57,CMO58,CMO59,CMO60,CMO61,CMO62,CMO63;
output CMO64,CMO65,CMO66,CMO67,CMO68,CMO69,CMO70,CMO71;
output CMO72,CMO73,CMO74,CMO75,CMO76,CMO77,CMO78,CMO79;
output CMO80,CMO81,CMO82,CMO83,CMO84,CMO85,CMO86,CMO87;
output CMO88,CMO89,CMO90,CMO91,CMO92,CMO93,CMO94,CMO95;
output CMO96,CMO97,CMO98,CMO99,CMO100,CMO101,CMO102,CMO103;
output CMO104,CMO105,CMO106,CMO107,CMO108,CMO109,CMO110,CMO111;
output CMO112,CMO113,CMO114,CMO115,CMO116,CMO117,CMO118,CMO119;
output CMO120,CMO121,CMO122,CMO123,CMO124,CMO125,CMO126,CMO127;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [1:0] cs;
wire [6:0] wad;
wire [47:0] wd;
wire [127:0] cmo;
wire [127:0] cmi;
reg notifier;

assign cs  = {CS1, CS0};
assign wad = {WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign wd  = {WD47,WD46,WD45,WD44,WD43,WD42,WD41,WD40,WD39,WD38,WD37,WD36,WD35,WD34,WD33,WD32,WD31,WD30,WD29,WD28,WD27,WD26,WD25,WD24,WD23,WD22,WD21,WD20,WD19,WD18,WD17,WD16,WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};

//assign  {CMO127,CMO126,CMO125,CMO124,CMO123,CMO122,CMO121,CMO120,CMO119,CMO118,CMO117,CMO116,CMO115,CMO114,CMO113,CMO112,CMO111,CMO110,CMO109,CMO108,CMO107,CMO106,CMO105,CMO104,CMO103,CMO102,CMO101,CMO100,CMO99,CMO98,CMO97,CMO96,CMO95,CMO94,CMO93,CMO92,CMO91,CMO90,CMO89,CMO88,CMO87,CMO86,CMO85,CMO84,CMO83,CMO82,CMO81,CMO80,CMO79,CMO78,CMO77,CMO76,CMO75,CMO74,CMO73,CMO72,CMO71,CMO70,CMO69,CMO68,CMO67,CMO66,CMO65,CMO64,CMO63,CMO62,CMO61,CMO60,CMO59,CMO58,CMO57,CMO56,CMO55,CMO54,CMO53,CMO52,CMO51,CMO50,CMO49,CMO48,CMO47,CMO46,CMO45,CMO44,CMO43,CMO42,CMO41,CMO40,CMO39,CMO38,CMO37,CMO36,CMO35,CMO34,CMO33,CMO32,CMO31,CMO30,CMO29,CMO28,CMO27,CMO26,CMO25,CMO24,CMO23,CMO22,CMO21,CMO20,CMO19,CMO18,CMO17,CMO16,CMO15,CMO14,CMO13,CMO12,CMO11,CMO10,CMO9,CMO8,CMO7,CMO6,CMO5,CMO4,CMO3,CMO2,CMO1,CMO0} = cmo;
buf INSXQ0 (CMO0,cmo[0]);
buf INSXQ1 (CMO1,cmo[1]);
buf INSXQ2 (CMO2,cmo[2]);
buf INSXQ3 (CMO3,cmo[3]);
buf INSXQ4 (CMO4,cmo[4]);
buf INSXQ5 (CMO5,cmo[5]);
buf INSXQ6 (CMO6,cmo[6]);
buf INSXQ7 (CMO7,cmo[7]);
buf INSXQ8 (CMO8,cmo[8]);
buf INSXQ9 (CMO9,cmo[9]);

buf INSXQ10 (CMO10,cmo[10]);
buf INSXQ11 (CMO11,cmo[11]);
buf INSXQ12 (CMO12,cmo[12]);
buf INSXQ13 (CMO13,cmo[13]);
buf INSXQ14 (CMO14,cmo[14]);
buf INSXQ15 (CMO15,cmo[15]);
buf INSXQ16 (CMO16,cmo[16]);
buf INSXQ17 (CMO17,cmo[17]);
buf INSXQ18 (CMO18,cmo[18]);
buf INSXQ19 (CMO19,cmo[19]);

buf INSXQ20 (CMO20,cmo[20]);
buf INSXQ21 (CMO21,cmo[21]);
buf INSXQ22 (CMO22,cmo[22]);
buf INSXQ23 (CMO23,cmo[23]);
buf INSXQ24 (CMO24,cmo[24]);
buf INSXQ25 (CMO25,cmo[25]);
buf INSXQ26 (CMO26,cmo[26]);
buf INSXQ27 (CMO27,cmo[27]);
buf INSXQ28 (CMO28,cmo[28]);
buf INSXQ29 (CMO29,cmo[29]);

buf INSXQ30 (CMO30,cmo[30]);
buf INSXQ31 (CMO31,cmo[31]);
buf INSXQ32 (CMO32,cmo[32]);
buf INSXQ33 (CMO33,cmo[33]);
buf INSXQ34 (CMO34,cmo[34]);
buf INSXQ35 (CMO35,cmo[35]);
buf INSXQ36 (CMO36,cmo[36]);
buf INSXQ37 (CMO37,cmo[37]);
buf INSXQ38 (CMO38,cmo[38]);
buf INSXQ39 (CMO39,cmo[39]);

buf INSXQ40 (CMO40,cmo[40]);
buf INSXQ41 (CMO41,cmo[41]);
buf INSXQ42 (CMO42,cmo[42]);
buf INSXQ43 (CMO43,cmo[43]);
buf INSXQ44 (CMO44,cmo[44]);
buf INSXQ45 (CMO45,cmo[45]);
buf INSXQ46 (CMO46,cmo[46]);
buf INSXQ47 (CMO47,cmo[47]);
buf INSXQ48 (CMO48,cmo[48]);
buf INSXQ49 (CMO49,cmo[49]);

buf INSXQ50 (CMO50,cmo[50]);
buf INSXQ51 (CMO51,cmo[51]);
buf INSXQ52 (CMO52,cmo[52]);
buf INSXQ53 (CMO53,cmo[53]);
buf INSXQ54 (CMO54,cmo[54]);
buf INSXQ55 (CMO55,cmo[55]);
buf INSXQ56 (CMO56,cmo[56]);
buf INSXQ57 (CMO57,cmo[57]);
buf INSXQ58 (CMO58,cmo[58]);
buf INSXQ59 (CMO59,cmo[59]);

buf INSXQ60 (CMO60,cmo[60]);
buf INSXQ61 (CMO61,cmo[61]);
buf INSXQ62 (CMO62,cmo[62]);
buf INSXQ63 (CMO63,cmo[63]);
buf INSXQ64 (CMO64,cmo[64]);
buf INSXQ65 (CMO65,cmo[65]);
buf INSXQ66 (CMO66,cmo[66]);
buf INSXQ67 (CMO67,cmo[67]);
buf INSXQ68 (CMO68,cmo[68]);
buf INSXQ69 (CMO69,cmo[69]);

buf INSXQ70 (CMO70,cmo[70]);
buf INSXQ71 (CMO71,cmo[71]);
buf INSXQ72 (CMO72,cmo[72]);
buf INSXQ73 (CMO73,cmo[73]);
buf INSXQ74 (CMO74,cmo[74]);
buf INSXQ75 (CMO75,cmo[75]);
buf INSXQ76 (CMO76,cmo[76]);
buf INSXQ77 (CMO77,cmo[77]);
buf INSXQ78 (CMO78,cmo[78]);
buf INSXQ79 (CMO79,cmo[79]);

buf INSXQ80 (CMO80,cmo[80]);
buf INSXQ81 (CMO81,cmo[81]);
buf INSXQ82 (CMO82,cmo[82]);
buf INSXQ83 (CMO83,cmo[83]);
buf INSXQ84 (CMO84,cmo[84]);
buf INSXQ85 (CMO85,cmo[85]);
buf INSXQ86 (CMO86,cmo[86]);
buf INSXQ87 (CMO87,cmo[87]);
buf INSXQ88 (CMO88,cmo[88]);
buf INSXQ89 (CMO89,cmo[89]);

buf INSXQ90 (CMO90,cmo[90]);
buf INSXQ91 (CMO91,cmo[91]);
buf INSXQ92 (CMO92,cmo[92]);
buf INSXQ93 (CMO93,cmo[93]);
buf INSXQ94 (CMO94,cmo[94]);
buf INSXQ95 (CMO95,cmo[95]);
buf INSXQ96 (CMO96,cmo[96]);
buf INSXQ97 (CMO97,cmo[97]);
buf INSXQ98 (CMO98,cmo[98]);
buf INSXQ99 (CMO99,cmo[99]);

buf INSXQ100 (CMO100,cmo[100]);
buf INSXQ101 (CMO101,cmo[101]);
buf INSXQ102 (CMO102,cmo[102]);
buf INSXQ103 (CMO103,cmo[103]);
buf INSXQ104 (CMO104,cmo[104]);
buf INSXQ105 (CMO105,cmo[105]);
buf INSXQ106 (CMO106,cmo[106]);
buf INSXQ107 (CMO107,cmo[107]);
buf INSXQ108 (CMO108,cmo[108]);
buf INSXQ109 (CMO109,cmo[109]);

buf INSXQ110 (CMO110,cmo[110]);
buf INSXQ111 (CMO111,cmo[111]);
buf INSXQ112 (CMO112,cmo[112]);
buf INSXQ113 (CMO113,cmo[113]);
buf INSXQ114 (CMO114,cmo[114]);
buf INSXQ115 (CMO115,cmo[115]);
buf INSXQ116 (CMO116,cmo[116]);
buf INSXQ117 (CMO117,cmo[117]);
buf INSXQ118 (CMO118,cmo[118]);
buf INSXQ119 (CMO119,cmo[119]);

buf INSXQ120 (CMO120,cmo[120]);
buf INSXQ121 (CMO121,cmo[121]);
buf INSXQ122 (CMO122,cmo[122]);
buf INSXQ123 (CMO123,cmo[123]);
buf INSXQ124 (CMO124,cmo[124]);
buf INSXQ125 (CMO125,cmo[125]);
buf INSXQ126 (CMO126,cmo[126]);
buf INSXQ127 (CMO127,cmo[127]);
assign cmi ={CMI127,CMI126,CMI125,CMI124,CMI123,CMI122,CMI121,CMI120,CMI119,CMI118,CMI117,CMI116,CMI115,CMI114,CMI113,CMI112,CMI111,CMI110,CMI109,CMI108,CMI107,CMI106,CMI105,CMI104,CMI103,CMI102,CMI101,CMI100,CMI99,CMI98,CMI97,CMI96,CMI95,CMI94,CMI93,CMI92,CMI91,CMI90,CMI89,CMI88,CMI87,CMI86,CMI85,CMI84,CMI83,CMI82,CMI81,CMI80,CMI79,CMI78,CMI77,CMI76,CMI75,CMI74,CMI73,CMI72,CMI71,CMI70,CMI69,CMI68,CMI67,CMI66,CMI65,CMI64,CMI63,CMI62,CMI61,CMI60,CMI59,CMI58,CMI57,CMI56,CMI55,CMI54,CMI53,CMI52,CMI51,CMI50,CMI49,CMI48,CMI47,CMI46,CMI45,CMI44,CMI43,CMI42,CMI41,CMI40,CMI39,CMI38,CMI37,CMI36,CMI35,CMI34,CMI33,CMI32,CMI31,CMI30,CMI29,CMI28,CMI27,CMI26,CMI25,CMI24,CMI23,CMI22,CMI21,CMI20,CMI19,CMI18,CMI17,CMI16,CMI15,CMI14,CMI13,CMI12,CMI11,CMI10,CMI9,CMI8,CMI7,CMI6,CMI5,CMI4,CMI3,CMI2,CMI1,CMI0};


defparam CAM_U0.ADDR_WIDTH = 7;
defparam CAM_U0.DATA_WIDTH = 48;
defparam CAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam CAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_CAMCM_16K CAM_U0(
		.CE(CE),
		.WE(WE),
		.CLK(CLK),
		.EN_MASK(EN_MASK),
		.WR_MASK(WR_MASK),
		.WR_DC(WR_DC),
		.RST(RST),
		.CS(cs),
		.WAD(wad),
		.WD(wd),
		.CMI(cmi),
		.CMO(cmo)
		);

specify
	$width (posedge CLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge CLK, CE, 1, 0);
	$setuphold  (posedge CLK, WE, 1, 0);
	$setuphold  (posedge CLK, EN_MASK, 1, 0);
	$setuphold  (posedge CLK, WR_MASK, 1, 0);
	$setuphold  (posedge CLK, WR_DC, 1, 0);
	$setuphold  (posedge CLK, CS0, 1, 0);
	$setuphold  (posedge CLK, CS1, 1, 0);

	$setuphold  (posedge CLK, WAD0, 1, 0);
	$setuphold  (posedge CLK, WAD1, 1, 0);
	$setuphold  (posedge CLK, WAD2, 1, 0);
	$setuphold  (posedge CLK, WAD3, 1, 0);
	$setuphold  (posedge CLK, WAD4, 1, 0);
	$setuphold  (posedge CLK, WAD5, 1, 0);
	$setuphold  (posedge CLK, WAD6, 1, 0);

	$setuphold  (posedge CLK, WD0, 1, 0);
	$setuphold  (posedge CLK, WD1, 1, 0);
	$setuphold  (posedge CLK, WD2, 1, 0);
	$setuphold  (posedge CLK, WD3, 1, 0);
	$setuphold  (posedge CLK, WD4, 1, 0);
	$setuphold  (posedge CLK, WD5, 1, 0);
	$setuphold  (posedge CLK, WD6, 1, 0);
	$setuphold  (posedge CLK, WD7, 1, 0);
	$setuphold  (posedge CLK, WD8, 1, 0);
	$setuphold  (posedge CLK, WD9, 1, 0);
	$setuphold  (posedge CLK, WD10, 1, 0);
	$setuphold  (posedge CLK, WD11, 1, 0);
	$setuphold  (posedge CLK, WD12, 1, 0);
	$setuphold  (posedge CLK, WD13, 1, 0);
	$setuphold  (posedge CLK, WD14, 1, 0);
	$setuphold  (posedge CLK, WD15, 1, 0);
	$setuphold  (posedge CLK, WD16, 1, 0);
	$setuphold  (posedge CLK, WD17, 1, 0);
	$setuphold  (posedge CLK, WD18, 1, 0);
	$setuphold  (posedge CLK, WD19, 1, 0);
	$setuphold  (posedge CLK, WD20, 1, 0);
	$setuphold  (posedge CLK, WD21, 1, 0);
	$setuphold  (posedge CLK, WD22, 1, 0);
	$setuphold  (posedge CLK, WD23, 1, 0);
	$setuphold  (posedge CLK, WD24, 1, 0);
	$setuphold  (posedge CLK, WD25, 1, 0);
	$setuphold  (posedge CLK, WD26, 1, 0);
	$setuphold  (posedge CLK, WD27, 1, 0);
	$setuphold  (posedge CLK, WD28, 1, 0);
	$setuphold  (posedge CLK, WD29, 1, 0);
	$setuphold  (posedge CLK, WD30, 1, 0);
	$setuphold  (posedge CLK, WD31, 1, 0);
	$setuphold  (posedge CLK, WD32, 1, 0);
	$setuphold  (posedge CLK, WD33, 1, 0);
	$setuphold  (posedge CLK, WD34, 1, 0);
	$setuphold  (posedge CLK, WD35, 1, 0);
	$setuphold  (posedge CLK, WD36, 1, 0);
	$setuphold  (posedge CLK, WD37, 1, 0);
	$setuphold  (posedge CLK, WD38, 1, 0);
	$setuphold  (posedge CLK, WD39, 1, 0);
	$setuphold  (posedge CLK, WD40, 1, 0);
	$setuphold  (posedge CLK, WD41, 1, 0);
	$setuphold  (posedge CLK, WD42, 1, 0);
	$setuphold  (posedge CLK, WD43, 1, 0);
	$setuphold  (posedge CLK, WD44, 1, 0);
	$setuphold  (posedge CLK, WD45, 1, 0);
	$setuphold  (posedge CLK, WD46, 1, 0);
	$setuphold  (posedge CLK, WD47, 1, 0);

        $recovery(posedge RST, posedge CLK, 1); 

	(CLK => CMO0)    = (0:0:0, 0:0:0);
	(CLK => CMO1)    = (0:0:0, 0:0:0);
	(CLK => CMO2)    = (0:0:0, 0:0:0);
	(CLK => CMO3)    = (0:0:0, 0:0:0);
	(CLK => CMO4)    = (0:0:0, 0:0:0);
	(CLK => CMO5)    = (0:0:0, 0:0:0);
	(CLK => CMO6)    = (0:0:0, 0:0:0);
	(CLK => CMO7)    = (0:0:0, 0:0:0);
	(CLK => CMO8)    = (0:0:0, 0:0:0);
	(CLK => CMO9)    = (0:0:0, 0:0:0);
	(CLK => CMO10)   = (0:0:0, 0:0:0);
	(CLK => CMO11)   = (0:0:0, 0:0:0);
	(CLK => CMO12)   = (0:0:0, 0:0:0);
	(CLK => CMO13)   = (0:0:0, 0:0:0);
	(CLK => CMO14)   = (0:0:0, 0:0:0);
	(CLK => CMO15)   = (0:0:0, 0:0:0);
	(CLK => CMO16)   = (0:0:0, 0:0:0);
	(CLK => CMO17)   = (0:0:0, 0:0:0);
	(CLK => CMO18)   = (0:0:0, 0:0:0);
	(CLK => CMO19)   = (0:0:0, 0:0:0);
	(CLK => CMO20)   = (0:0:0, 0:0:0);
	(CLK => CMO21)   = (0:0:0, 0:0:0);
	(CLK => CMO22)   = (0:0:0, 0:0:0);
	(CLK => CMO23)   = (0:0:0, 0:0:0);
	(CLK => CMO24)   = (0:0:0, 0:0:0);
	(CLK => CMO25)   = (0:0:0, 0:0:0);
	(CLK => CMO26)   = (0:0:0, 0:0:0);
	(CLK => CMO27)   = (0:0:0, 0:0:0);
	(CLK => CMO28)   = (0:0:0, 0:0:0);
	(CLK => CMO29)   = (0:0:0, 0:0:0);
	(CLK => CMO30)   = (0:0:0, 0:0:0);
	(CLK => CMO31)   = (0:0:0, 0:0:0);
	(CLK => CMO32)   = (0:0:0, 0:0:0);
	(CLK => CMO33)   = (0:0:0, 0:0:0);
	(CLK => CMO34)   = (0:0:0, 0:0:0);
	(CLK => CMO35)   = (0:0:0, 0:0:0);
	(CLK => CMO36)   = (0:0:0, 0:0:0);
	(CLK => CMO37)   = (0:0:0, 0:0:0);
	(CLK => CMO38)   = (0:0:0, 0:0:0);
	(CLK => CMO39)   = (0:0:0, 0:0:0);
	(CLK => CMO40)   = (0:0:0, 0:0:0);
	(CLK => CMO41)   = (0:0:0, 0:0:0);
	(CLK => CMO42)   = (0:0:0, 0:0:0);
	(CLK => CMO43)   = (0:0:0, 0:0:0);
	(CLK => CMO44)   = (0:0:0, 0:0:0);
	(CLK => CMO45)   = (0:0:0, 0:0:0);
	(CLK => CMO46)   = (0:0:0, 0:0:0);
	(CLK => CMO47)   = (0:0:0, 0:0:0);
	(CLK => CMO48)   = (0:0:0, 0:0:0);
	(CLK => CMO49)   = (0:0:0, 0:0:0);
	(CLK => CMO50)   = (0:0:0, 0:0:0);
	(CLK => CMO51)   = (0:0:0, 0:0:0);
	(CLK => CMO52)   = (0:0:0, 0:0:0);
	(CLK => CMO53)   = (0:0:0, 0:0:0);
	(CLK => CMO54)   = (0:0:0, 0:0:0);
	(CLK => CMO55)   = (0:0:0, 0:0:0);
	(CLK => CMO56)   = (0:0:0, 0:0:0);
	(CLK => CMO57)   = (0:0:0, 0:0:0);
	(CLK => CMO58)   = (0:0:0, 0:0:0);
	(CLK => CMO59)   = (0:0:0, 0:0:0);
	(CLK => CMO60)   = (0:0:0, 0:0:0);
	(CLK => CMO61)   = (0:0:0, 0:0:0);
	(CLK => CMO62)   = (0:0:0, 0:0:0);
	(CLK => CMO63)   = (0:0:0, 0:0:0);
	(CLK => CMO64)   = (0:0:0, 0:0:0);
	(CLK => CMO65)   = (0:0:0, 0:0:0);
	(CLK => CMO66)   = (0:0:0, 0:0:0);
	(CLK => CMO67)   = (0:0:0, 0:0:0);
	(CLK => CMO68)   = (0:0:0, 0:0:0);
	(CLK => CMO69)   = (0:0:0, 0:0:0);
	(CLK => CMO70)   = (0:0:0, 0:0:0);
	(CLK => CMO71)   = (0:0:0, 0:0:0);
	(CLK => CMO72)   = (0:0:0, 0:0:0);
	(CLK => CMO73)   = (0:0:0, 0:0:0);
	(CLK => CMO74)   = (0:0:0, 0:0:0);
	(CLK => CMO75)   = (0:0:0, 0:0:0);
	(CLK => CMO76)   = (0:0:0, 0:0:0);
	(CLK => CMO77)   = (0:0:0, 0:0:0);
	(CLK => CMO78)   = (0:0:0, 0:0:0);
	(CLK => CMO79)   = (0:0:0, 0:0:0);
	(CLK => CMO80)   = (0:0:0, 0:0:0);
	(CLK => CMO81)   = (0:0:0, 0:0:0);
	(CLK => CMO82)   = (0:0:0, 0:0:0);
	(CLK => CMO83)   = (0:0:0, 0:0:0);
	(CLK => CMO84)   = (0:0:0, 0:0:0);
	(CLK => CMO85)   = (0:0:0, 0:0:0);
	(CLK => CMO86)   = (0:0:0, 0:0:0);
	(CLK => CMO87)   = (0:0:0, 0:0:0);
	(CLK => CMO88)   = (0:0:0, 0:0:0);
	(CLK => CMO89)   = (0:0:0, 0:0:0);
	(CLK => CMO90)   = (0:0:0, 0:0:0);
	(CLK => CMO91)   = (0:0:0, 0:0:0);
	(CLK => CMO92)   = (0:0:0, 0:0:0);
	(CLK => CMO93)   = (0:0:0, 0:0:0);
	(CLK => CMO94)   = (0:0:0, 0:0:0);
	(CLK => CMO95)   = (0:0:0, 0:0:0);
	(CLK => CMO96)   = (0:0:0, 0:0:0);
	(CLK => CMO97)   = (0:0:0, 0:0:0);
	(CLK => CMO98)   = (0:0:0, 0:0:0);
	(CLK => CMO99)   = (0:0:0, 0:0:0);
	(CLK => CMO100)   = (0:0:0, 0:0:0);
	(CLK => CMO101)   = (0:0:0, 0:0:0);
	(CLK => CMO102)   = (0:0:0, 0:0:0);
	(CLK => CMO103)   = (0:0:0, 0:0:0);
	(CLK => CMO104)   = (0:0:0, 0:0:0);
	(CLK => CMO105)   = (0:0:0, 0:0:0);
	(CLK => CMO106)   = (0:0:0, 0:0:0);
	(CLK => CMO107)   = (0:0:0, 0:0:0);
	(CLK => CMO108)   = (0:0:0, 0:0:0);
	(CLK => CMO109)   = (0:0:0, 0:0:0);
	(CLK => CMO110)   = (0:0:0, 0:0:0);
	(CLK => CMO111)   = (0:0:0, 0:0:0);
	(CLK => CMO112)   = (0:0:0, 0:0:0);
	(CLK => CMO113)   = (0:0:0, 0:0:0);
	(CLK => CMO114)   = (0:0:0, 0:0:0);
	(CLK => CMO115)   = (0:0:0, 0:0:0);
	(CLK => CMO116)   = (0:0:0, 0:0:0);
	(CLK => CMO117)   = (0:0:0, 0:0:0);
	(CLK => CMO118)   = (0:0:0, 0:0:0);
	(CLK => CMO119)   = (0:0:0, 0:0:0);
	(CLK => CMO120)   = (0:0:0, 0:0:0);
	(CLK => CMO121)   = (0:0:0, 0:0:0);
	(CLK => CMO122)   = (0:0:0, 0:0:0);
	(CLK => CMO123)   = (0:0:0, 0:0:0);
	(CLK => CMO124)   = (0:0:0, 0:0:0);
	(CLK => CMO125)   = (0:0:0, 0:0:0);
	(CLK => CMO126)   = (0:0:0, 0:0:0);
	(CLK => CMO127)   = (0:0:0, 0:0:0);

	(RST  => CMO0)    = (0:0:0, 0:0:0);
	(RST  => CMO1)    = (0:0:0, 0:0:0);
	(RST  => CMO2)    = (0:0:0, 0:0:0);
	(RST  => CMO3)    = (0:0:0, 0:0:0);
	(RST  => CMO4)    = (0:0:0, 0:0:0);
	(RST  => CMO5)    = (0:0:0, 0:0:0);
	(RST  => CMO6)    = (0:0:0, 0:0:0);
	(RST  => CMO7)    = (0:0:0, 0:0:0);
	(RST => CMO8)    = (0:0:0, 0:0:0);
	(RST => CMO9)    = (0:0:0, 0:0:0);
	(RST => CMO10)   = (0:0:0, 0:0:0);
	(RST => CMO11)   = (0:0:0, 0:0:0);
	(RST => CMO12)   = (0:0:0, 0:0:0);
	(RST => CMO13)   = (0:0:0, 0:0:0);
	(RST => CMO14)   = (0:0:0, 0:0:0);
	(RST => CMO15)   = (0:0:0, 0:0:0);
	(RST => CMO16)   = (0:0:0, 0:0:0);
	(RST => CMO17)   = (0:0:0, 0:0:0);
	(RST => CMO18)   = (0:0:0, 0:0:0);
	(RST => CMO19)   = (0:0:0, 0:0:0);
	(RST => CMO20)   = (0:0:0, 0:0:0);
	(RST => CMO21)   = (0:0:0, 0:0:0);
	(RST => CMO22)   = (0:0:0, 0:0:0);
	(RST => CMO23)   = (0:0:0, 0:0:0);
	(RST => CMO24)   = (0:0:0, 0:0:0);
	(RST => CMO25)   = (0:0:0, 0:0:0);
	(RST => CMO26)   = (0:0:0, 0:0:0);
	(RST => CMO27)   = (0:0:0, 0:0:0);
	(RST => CMO28)   = (0:0:0, 0:0:0);
	(RST => CMO29)   = (0:0:0, 0:0:0);
	(RST => CMO30)   = (0:0:0, 0:0:0);
	(RST => CMO31)   = (0:0:0, 0:0:0);
	(RST => CMO32)   = (0:0:0, 0:0:0);
	(RST => CMO33)   = (0:0:0, 0:0:0);
	(RST => CMO34)   = (0:0:0, 0:0:0);
	(RST => CMO35)   = (0:0:0, 0:0:0);
	(RST => CMO36)   = (0:0:0, 0:0:0);
	(RST => CMO37)   = (0:0:0, 0:0:0);
	(RST => CMO38)   = (0:0:0, 0:0:0);
	(RST => CMO39)   = (0:0:0, 0:0:0);
	(RST => CMO40)   = (0:0:0, 0:0:0);
	(RST => CMO41)   = (0:0:0, 0:0:0);
	(RST => CMO42)   = (0:0:0, 0:0:0);
	(RST => CMO43)   = (0:0:0, 0:0:0);
	(RST => CMO44)   = (0:0:0, 0:0:0);
	(RST => CMO45)   = (0:0:0, 0:0:0);
	(RST => CMO46)   = (0:0:0, 0:0:0);
	(RST => CMO47)   = (0:0:0, 0:0:0);
	(RST => CMO48)   = (0:0:0, 0:0:0);
	(RST => CMO49)   = (0:0:0, 0:0:0);
	(RST => CMO50)   = (0:0:0, 0:0:0);
	(RST => CMO51)   = (0:0:0, 0:0:0);
	(RST => CMO52)   = (0:0:0, 0:0:0);
	(RST => CMO53)   = (0:0:0, 0:0:0);
	(RST => CMO54)   = (0:0:0, 0:0:0);
	(RST => CMO55)   = (0:0:0, 0:0:0);
	(RST => CMO56)   = (0:0:0, 0:0:0);
	(RST => CMO57)   = (0:0:0, 0:0:0);
	(RST => CMO58)   = (0:0:0, 0:0:0);
	(RST => CMO59)   = (0:0:0, 0:0:0);
	(RST => CMO60)   = (0:0:0, 0:0:0);
	(RST => CMO61)   = (0:0:0, 0:0:0);
	(RST => CMO62)   = (0:0:0, 0:0:0);
	(RST => CMO63)   = (0:0:0, 0:0:0);
	(RST => CMO64)   = (0:0:0, 0:0:0);
	(RST => CMO65)   = (0:0:0, 0:0:0);
	(RST => CMO66)   = (0:0:0, 0:0:0);
	(RST => CMO67)   = (0:0:0, 0:0:0);
	(RST => CMO68)   = (0:0:0, 0:0:0);
	(RST => CMO69)   = (0:0:0, 0:0:0);
	(RST => CMO70)   = (0:0:0, 0:0:0);
	(RST => CMO71)   = (0:0:0, 0:0:0);
	(RST => CMO72)   = (0:0:0, 0:0:0);
	(RST => CMO73)   = (0:0:0, 0:0:0);
	(RST => CMO74)   = (0:0:0, 0:0:0);
	(RST => CMO75)   = (0:0:0, 0:0:0);
	(RST => CMO76)   = (0:0:0, 0:0:0);
	(RST => CMO77)   = (0:0:0, 0:0:0);
	(RST => CMO78)   = (0:0:0, 0:0:0);
	(RST => CMO79)   = (0:0:0, 0:0:0);
	(RST => CMO80)   = (0:0:0, 0:0:0);
	(RST => CMO81)   = (0:0:0, 0:0:0);
	(RST => CMO82)   = (0:0:0, 0:0:0);
	(RST => CMO83)   = (0:0:0, 0:0:0);
	(RST => CMO84)   = (0:0:0, 0:0:0);
	(RST => CMO85)   = (0:0:0, 0:0:0);
	(RST => CMO86)   = (0:0:0, 0:0:0);
	(RST => CMO87)   = (0:0:0, 0:0:0);
	(RST => CMO88)   = (0:0:0, 0:0:0);
	(RST => CMO89)   = (0:0:0, 0:0:0);
	(RST => CMO90)   = (0:0:0, 0:0:0);
	(RST => CMO91)   = (0:0:0, 0:0:0);
	(RST => CMO92)   = (0:0:0, 0:0:0);
	(RST => CMO93)   = (0:0:0, 0:0:0);
	(RST => CMO94)   = (0:0:0, 0:0:0);
	(RST => CMO95)   = (0:0:0, 0:0:0);
	(RST => CMO96)   = (0:0:0, 0:0:0);
	(RST => CMO97)   = (0:0:0, 0:0:0);
	(RST => CMO98)   = (0:0:0, 0:0:0);
	(RST => CMO99)   = (0:0:0, 0:0:0);
	(RST => CMO100)   = (0:0:0, 0:0:0);
	(RST => CMO101)   = (0:0:0, 0:0:0);
	(RST => CMO102)   = (0:0:0, 0:0:0);
	(RST => CMO103)   = (0:0:0, 0:0:0);
	(RST => CMO104)   = (0:0:0, 0:0:0);
	(RST => CMO105)   = (0:0:0, 0:0:0);
	(RST => CMO106)   = (0:0:0, 0:0:0);
	(RST => CMO107)   = (0:0:0, 0:0:0);
	(RST => CMO108)   = (0:0:0, 0:0:0);
	(RST => CMO109)   = (0:0:0, 0:0:0);
	(RST => CMO110)   = (0:0:0, 0:0:0);
	(RST => CMO111)   = (0:0:0, 0:0:0);
	(RST => CMO112)   = (0:0:0, 0:0:0);
	(RST => CMO113)   = (0:0:0, 0:0:0);
	(RST => CMO114)   = (0:0:0, 0:0:0);
	(RST => CMO115)   = (0:0:0, 0:0:0);
	(RST => CMO116)   = (0:0:0, 0:0:0);
	(RST => CMO117)   = (0:0:0, 0:0:0);
	(RST => CMO118)   = (0:0:0, 0:0:0);
	(RST => CMO119)   = (0:0:0, 0:0:0);
	(RST => CMO120)   = (0:0:0, 0:0:0);
	(RST => CMO121)   = (0:0:0, 0:0:0);
	(RST => CMO122)   = (0:0:0, 0:0:0);
	(RST => CMO123)   = (0:0:0, 0:0:0);
	(RST => CMO124)   = (0:0:0, 0:0:0);
	(RST => CMO125)   = (0:0:0, 0:0:0);
	(RST => CMO126)   = (0:0:0, 0:0:0);
	(RST => CMO127)   = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine
`celldefine
module CAM128X48CR(CE,WE,CLK,EN_MASK,WR_MASK,WR_DC,RST,CS0,CS1,
                    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,
                    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,
                    WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,
                    WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23,
                    WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31,
                    WD32,WD33,WD34,WD35,WD36,WD37,WD38,WD39,
                    WD40,WD41,WD42,WD43,WD44,WD45,WD46,WD47,
                    CMI0,CMI1,CMI2,CMI3,CMI4,CMI5,CMI6,CMI7,
                    CMI8,CMI9,CMI10,CMI11,CMI12,CMI13,CMI14,CMI15,
                    CMI16,CMI17,CMI18,CMI19,CMI20,CMI21,CMI22,CMI23,
                    CMI24,CMI25,CMI26,CMI27,CMI28,CMI29,CMI30,CMI31,
                    CMI32,CMI33,CMI34,CMI35,CMI36,CMI37,CMI38,CMI39,
                    CMI40,CMI41,CMI42,CMI43,CMI44,CMI45,CMI46,CMI47,
                    CMI48,CMI49,CMI50,CMI51,CMI52,CMI53,CMI54,CMI55,
                    CMI56,CMI57,CMI58,CMI59,CMI60,CMI61,CMI62,CMI63,
                    CMI64,CMI65,CMI66,CMI67,CMI68,CMI69,CMI70,CMI71,
                    CMI72,CMI73,CMI74,CMI75,CMI76,CMI77,CMI78,CMI79,
                    CMI80,CMI81,CMI82,CMI83,CMI84,CMI85,CMI86,CMI87,
                    CMI88,CMI89,CMI90,CMI91,CMI92,CMI93,CMI94,CMI95,
                    CMI96,CMI97,CMI98,CMI99,CMI100,CMI101,CMI102,CMI103,
                    CMI104,CMI105,CMI106,CMI107,CMI108,CMI109,CMI110,CMI111,
                    CMI112,CMI113,CMI114,CMI115,CMI116,CMI117,CMI118,CMI119,
                    CMI120,CMI121,CMI122,CMI123,CMI124,CMI125,CMI126,CMI127,
                    CO0,CO1,CO2,CO3,CO4,CO5,CO6,MATCH,MUL_MATCH
);

parameter RAM_INIT_FILE = "";

input  CE,WE,CLK,EN_MASK,WR_MASK,WR_DC,RST,CS0,CS1;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7;
input  WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15;
input  WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23;
input  WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31;
input  WD32,WD33,WD34,WD35,WD36,WD37,WD38,WD39;
input  WD40,WD41,WD42,WD43,WD44,WD45,WD46,WD47;
input  CMI0,CMI1,CMI2,CMI3,CMI4,CMI5,CMI6,CMI7;
input  CMI8,CMI9,CMI10,CMI11,CMI12,CMI13,CMI14,CMI15;
input  CMI16,CMI17,CMI18,CMI19,CMI20,CMI21,CMI22,CMI23;
input  CMI24,CMI25,CMI26,CMI27,CMI28,CMI29,CMI30,CMI31;
input  CMI32,CMI33,CMI34,CMI35,CMI36,CMI37,CMI38,CMI39;
input  CMI40,CMI41,CMI42,CMI43,CMI44,CMI45,CMI46,CMI47;
input  CMI48,CMI49,CMI50,CMI51,CMI52,CMI53,CMI54,CMI55;
input  CMI56,CMI57,CMI58,CMI59,CMI60,CMI61,CMI62,CMI63;
input  CMI64,CMI65,CMI66,CMI67,CMI68,CMI69,CMI70,CMI71;
input  CMI72,CMI73,CMI74,CMI75,CMI76,CMI77,CMI78,CMI79;
input  CMI80,CMI81,CMI82,CMI83,CMI84,CMI85,CMI86,CMI87;
input  CMI88,CMI89,CMI90,CMI91,CMI92,CMI93,CMI94,CMI95;
input  CMI96,CMI97,CMI98,CMI99,CMI100,CMI101,CMI102,CMI103;
input  CMI104,CMI105,CMI106,CMI107,CMI108,CMI109,CMI110,CMI111;
input  CMI112,CMI113,CMI114,CMI115,CMI116,CMI117,CMI118,CMI119;
input  CMI120,CMI121,CMI122,CMI123,CMI124,CMI125,CMI126,CMI127;
output CO0,CO1,CO2,CO3,CO4,CO5,CO6,MATCH,MUL_MATCH;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [1:0] cs;
wire [6:0] wad;
wire [47:0] wd;
wire [6:0] co;
wire [127:0] cmi;
wire MATCH_node,MUL_MATCH_node;
reg notifier;

assign cs  = {CS1, CS0};
assign wad = {WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign wd  = {WD47,WD46,WD45,WD44,WD43,WD42,WD41,WD40,WD39,WD38,WD37,WD36,WD35,WD34,WD33,WD32,WD31,WD30,WD29,WD28,WD27,WD26,WD25,WD24,WD23,WD22,WD21,WD20,WD19,WD18,WD17,WD16,WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {CO6,CO5,CO4,CO3,CO2,CO1,CO0} = co;
buf INSXQ0 (CO0,co[0]);
buf INSXQ1 (CO1,co[1]);
buf INSXQ2 (CO2,co[2]);
buf INSXQ3 (CO3,co[3]);
buf INSXQ4 (CO4,co[4]);
buf INSXQ5 (CO5,co[5]);
buf INSXQ6 (CO6,co[6]);
buf INSXQ7 (MATCH,MATCH_node);
buf INSXQ8 (MUL_MATCH,MUL_MATCH_node);
assign cmi = {CMI127,CMI126,CMI125,CMI124,CMI123,CMI122,CMI121,CMI120,CMI119,CMI118,CMI117,CMI116,CMI115,CMI114,CMI113,CMI112,CMI111,CMI110,CMI109,CMI108,CMI107,CMI106,CMI105,CMI104,CMI103,CMI102,CMI101,CMI100,CMI99,CMI98,CMI97,CMI96,CMI95,CMI94,CMI93,CMI92,CMI91,CMI90,CMI89,CMI88,CMI87,CMI86,CMI85,CMI84,CMI83,CMI82,CMI81,CMI80,CMI79,CMI78,CMI77,CMI76,CMI75,CMI74,CMI73,CMI72,CMI71,CMI70,CMI69,CMI68,CMI67,CMI66,CMI65,CMI64,CMI63,CMI62,CMI61,CMI60,CMI59,CMI58,CMI57,CMI56,CMI55,CMI54,CMI53,CMI52,CMI51,CMI50,CMI49,CMI48,CMI47,CMI46,CMI45,CMI44,CMI43,CMI42,CMI41,CMI40,CMI39,CMI38,CMI37,CMI36,CMI35,CMI34,CMI33,CMI32,CMI31,CMI30,CMI29,CMI28,CMI27,CMI26,CMI25,CMI24,CMI23,CMI22,CMI21,CMI20,CMI19,CMI18,CMI17,CMI16,CMI15,CMI14,CMI13,CMI12,CMI11,CMI10,CMI9,CMI8,CMI7,CMI6,CMI5,CMI4,CMI3,CMI2,CMI1,CMI0};

defparam CAM_U0.ADDR_WIDTH = 7;
defparam CAM_U0.DATA_WIDTH = 48;
defparam CAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam CAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_CAMCR_16K CAM_U0(
		.CE(CE),
		.WE(WE),
		.CLK(CLK),
		.EN_MASK(EN_MASK),
		.WR_MASK(WR_MASK),
		.WR_DC(WR_DC),
		.RST(RST),
		.CS(cs),
		.WAD(wad),
		.WD(wd),
		.CMI(cmi),
		.CO(co),
		.MATCH(MATCH_node),
		.MUL_MATCH(MUL_MATCH_node)
		);

specify
	$width (posedge CLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge CLK, CE, 1, 0);
	$setuphold  (posedge CLK, WE, 1, 0);
	$setuphold  (posedge CLK, EN_MASK, 1, 0);
	$setuphold  (posedge CLK, WR_MASK, 1, 0);
	$setuphold  (posedge CLK, WR_DC, 1, 0);
	$setuphold  (posedge CLK, CS0, 1, 0);
	$setuphold  (posedge CLK, CS1, 1, 0);

	$setuphold  (posedge CLK, WAD0, 1, 0);
	$setuphold  (posedge CLK, WAD1, 1, 0);
	$setuphold  (posedge CLK, WAD2, 1, 0);
	$setuphold  (posedge CLK, WAD3, 1, 0);
	$setuphold  (posedge CLK, WAD4, 1, 0);
	$setuphold  (posedge CLK, WAD5, 1, 0);
	$setuphold  (posedge CLK, WAD6, 1, 0);

	$setuphold  (posedge CLK, WD0, 1, 0);
	$setuphold  (posedge CLK, WD1, 1, 0);
	$setuphold  (posedge CLK, WD2, 1, 0);
	$setuphold  (posedge CLK, WD3, 1, 0);
	$setuphold  (posedge CLK, WD4, 1, 0);
	$setuphold  (posedge CLK, WD5, 1, 0);
	$setuphold  (posedge CLK, WD6, 1, 0);
	$setuphold  (posedge CLK, WD7, 1, 0);
	$setuphold  (posedge CLK, WD8, 1, 0);
	$setuphold  (posedge CLK, WD9, 1, 0);
	$setuphold  (posedge CLK, WD10, 1, 0);
	$setuphold  (posedge CLK, WD11, 1, 0);
	$setuphold  (posedge CLK, WD12, 1, 0);
	$setuphold  (posedge CLK, WD13, 1, 0);
	$setuphold  (posedge CLK, WD14, 1, 0);
	$setuphold  (posedge CLK, WD15, 1, 0);
	$setuphold  (posedge CLK, WD16, 1, 0);
	$setuphold  (posedge CLK, WD17, 1, 0);
	$setuphold  (posedge CLK, WD18, 1, 0);
	$setuphold  (posedge CLK, WD19, 1, 0);
	$setuphold  (posedge CLK, WD20, 1, 0);
	$setuphold  (posedge CLK, WD21, 1, 0);
	$setuphold  (posedge CLK, WD22, 1, 0);
	$setuphold  (posedge CLK, WD23, 1, 0);
	$setuphold  (posedge CLK, WD24, 1, 0);
	$setuphold  (posedge CLK, WD25, 1, 0);
	$setuphold  (posedge CLK, WD26, 1, 0);
	$setuphold  (posedge CLK, WD27, 1, 0);
	$setuphold  (posedge CLK, WD28, 1, 0);
	$setuphold  (posedge CLK, WD29, 1, 0);
	$setuphold  (posedge CLK, WD30, 1, 0);
	$setuphold  (posedge CLK, WD31, 1, 0);
	$setuphold  (posedge CLK, WD32, 1, 0);
	$setuphold  (posedge CLK, WD33, 1, 0);
	$setuphold  (posedge CLK, WD34, 1, 0);
	$setuphold  (posedge CLK, WD35, 1, 0);
	$setuphold  (posedge CLK, WD36, 1, 0);
	$setuphold  (posedge CLK, WD37, 1, 0);
	$setuphold  (posedge CLK, WD38, 1, 0);
	$setuphold  (posedge CLK, WD39, 1, 0);
	$setuphold  (posedge CLK, WD40, 1, 0);
	$setuphold  (posedge CLK, WD41, 1, 0);
	$setuphold  (posedge CLK, WD42, 1, 0);
	$setuphold  (posedge CLK, WD43, 1, 0);
	$setuphold  (posedge CLK, WD44, 1, 0);
	$setuphold  (posedge CLK, WD45, 1, 0);
	$setuphold  (posedge CLK, WD46, 1, 0);
	$setuphold  (posedge CLK, WD47, 1, 0);

        $recovery(posedge RST, posedge CLK, 1); 

	(CLK => CO0)    = (0:0:0, 0:0:0);
	(CLK => CO1)    = (0:0:0, 0:0:0);
	(CLK => CO2)    = (0:0:0, 0:0:0);
	(CLK => CO3)    = (0:0:0, 0:0:0);
	(CLK => CO4)    = (0:0:0, 0:0:0);
	(CLK => CO5)    = (0:0:0, 0:0:0);
	(CLK => CO6)    = (0:0:0, 0:0:0);

	(CLK => MATCH)    = (0:0:0, 0:0:0);
	(CLK => MUL_MATCH)    = (0:0:0, 0:0:0);

	(RST => CO0)    = (0:0:0, 0:0:0);
	(RST => CO1)    = (0:0:0, 0:0:0);
	(RST => CO2)    = (0:0:0, 0:0:0);
	(RST => CO3)    = (0:0:0, 0:0:0);
	(RST => CO4)    = (0:0:0, 0:0:0);
	(RST => CO5)    = (0:0:0, 0:0:0);
	(RST => CO6)    = (0:0:0, 0:0:0);

	(RST => MATCH)    = (0:0:0, 0:0:0);
	(RST => MUL_MATCH)    = (0:0:0, 0:0:0);


endspecify
endmodule
`endcelldefine

//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
// L_CAM
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
`celldefine

module L_CAM(Address,Match,MulMatch,WrAddress,Data,Clock,ClockEn,WE,EnMask,WrMask,WrDC,Reset);

	parameter lpm_type = "LPM_CAM";
	parameter lpm_width  = 1;
	parameter lpm_widthad  = 1;
	parameter lpm_numwords = 1;
	parameter lpm_hint = "UNUSED";
        parameter lpm_init_file = "";

	output [lpm_widthad-1:0] Address;
	output Match;
	output MulMatch;
	input  [lpm_width-1:0] Data;
	input  [lpm_widthad-1:0] WrAddress;
	input  Clock;
	input  ClockEn;
	input  WE;
	input  EnMask;
	input  WrMask;
	input  WrDC;
	input  Reset;
   
   parameter lpm_init_flag = (lpm_init_file == "") ? 0 : 1 ;

	reg	[3:0]	 cs0 ;
	wire	[1:0]	cs_0, cs_1, cs_2, cs_3; 
	wire	[6:0]	Address_0, Address_1, Address_2 , Address_3;
	
	reg	[6:0]	match_address , match_address_ff;
	wire		Match_0, Match_1, Match_2, Match_3;
	wire		MulMatch_0, MulMatch_1, MulMatch_2, MulMatch_3;
	reg Match;
	reg MulMatch;
	reg [lpm_widthad-1:0] Address;

//-----------------------------------------------------------------------
assign cs_0 = {1'b1, cs0[0]};
assign cs_1 = {1'b1, cs0[1]};
assign cs_2 = {1'b1, cs0[2]};
assign cs_3 = {1'b1, cs0[3]};
	
//-----------------------------------------------------------------------
SC_CAM_16K inst_0 ( 
   .CE(ClockEn), .WE(WE), .CLK(Clock), .EN_MASK(EnMask), .WR_MASK(WrMask),
   .WR_DC(WrDC), .RST(Reset), .CS(cs_0), .WAD(WrAddress[6:0]), .WD(Data),
   .CO(Address_0), .MATCH(Match_0), .MUL_MATCH(MulMatch_0) );

defparam inst_0.ADDR_WIDTH = 7;//lpm_widthad;
defparam inst_0.DATA_WIDTH = lpm_width;
defparam inst_0.MEM_INIT_FILE = lpm_init_file;
defparam inst_0.MEM_INIT_FLAG = lpm_init_flag;
//-----------------------------------------------------------------------
SC_CAM_16K inst_1 ( 
   .CE(ClockEn), .WE(WE), .CLK(Clock), .EN_MASK(EnMask), .WR_MASK(WrMask),
   .WR_DC(WrDC), .RST(Reset), .CS(cs_1), .WAD(WrAddress[6:0]), .WD(Data),
   .CO(Address_1), .MATCH(Match_1), .MUL_MATCH(MulMatch_1) );

defparam inst_1.ADDR_WIDTH = 7;
defparam inst_1.DATA_WIDTH = lpm_width;
defparam inst_1.MEM_INIT_FILE = lpm_init_file;
defparam inst_1.MEM_INIT_FLAG = lpm_init_flag;
//-----------------------------------------------------------------------
SC_CAM_16K inst_2 ( 
   .CE(ClockEn), .WE(WE), .CLK(Clock), .EN_MASK(EnMask), .WR_MASK(WrMask),
   .WR_DC(WrDC), .RST(Reset), .CS(cs_2), .WAD(WrAddress[6:0]), .WD(Data),
   .CO(Address_2), .MATCH(Match_2), .MUL_MATCH(MulMatch_2) );

defparam inst_2.ADDR_WIDTH = 7;
defparam inst_2.DATA_WIDTH = lpm_width;
defparam inst_2.MEM_INIT_FILE = lpm_init_file;
defparam inst_2.MEM_INIT_FLAG = lpm_init_flag;
//-----------------------------------------------------------------------
SC_CAM_16K inst_3 ( 
   .CE(ClockEn), .WE(WE), .CLK(Clock), .EN_MASK(EnMask), .WR_MASK(WrMask),
   .WR_DC(WrDC), .RST(Reset), .CS(cs_3), .WAD(WrAddress[6:0]), .WD(Data),
   .CO(Address_3), .MATCH(Match_3), .MUL_MATCH(MulMatch_3) );

defparam inst_3.ADDR_WIDTH = 7;
defparam inst_3.DATA_WIDTH = lpm_width;
defparam inst_3.MEM_INIT_FILE = lpm_init_file;
defparam inst_3.MEM_INIT_FLAG = lpm_init_flag;
//-----------------------------------------------------------------------

always @ (WrAddress or Match_0 or  Match_1, Match_2 or Match_3 or 
          MulMatch_0 or MulMatch_1 or MulMatch_2 or MulMatch_3,
          Address_0 or Address_1 or Address_2 or Address_3 or
          match_address or match_address_ff )
begin
   //----------------------------------------
   if (lpm_widthad == 7) begin//128
         cs0 = 4'b0001;
         Match = Match_0;
         MulMatch = MulMatch_0;
         match_address[6:0] = Address_0; 
         Address = Address_0;
   end
   //----------------------------------------
   else if (lpm_widthad == 8) begin //256
      cs0[0] = ~WrAddress[lpm_widthad - 1];
      cs0[1] = WrAddress[lpm_widthad - 1];
      cs0[3:2] = 2'b00;
      Match = Match_0 | Match_1;
      MulMatch = MulMatch_0 | MulMatch_1 | (Match_0 & Match_1); 
      match_address = Match_0 ? Address_0 : Match_1 ? Address_1 : 7'b0;  
      Address[6:0] = Match ? match_address : match_address_ff;
      Address[lpm_widthad - 1] = ~Match_0 & Match_1;
   end
   //----------------------------------------
   else if (lpm_widthad == 9) begin //512 (1024 not valid)
      cs0 = 4'b1 << WrAddress[lpm_widthad-1:lpm_widthad-2];
      Match = Match_0 | Match_1 | Match_2 | Match_3;
      MulMatch = MulMatch_0 | MulMatch_1 | MulMatch_2 | MulMatch_3 |
            (Match_0 | Match_1) | (Match_0 | Match_2) |
            (Match_0 | Match_3) | (Match_1 | Match_2) |
            (Match_1 | Match_3) | (Match_2 | Match_3) ;
      match_address = Match_0 ? Address_0 : Match_1 ? Address_1 : 
                      Match_2 ? Address_2 : 7'b0;
      Address[6:0] = Match ? match_address : match_address_ff;
      Address[lpm_widthad - 2] = 
            (~Match_0 & Match_1) |
            (~Match_0 & ~Match_1 & ~Match_2 & Match_3);
      Address[lpm_widthad - 1] =  
            (~Match_0 & ~Match_1 & Match_2) |
            (~Match_0 & ~Match_1 & ~Match_2 & Match_3);
    end
end

always @ (posedge Clock or posedge Reset)
begin
   if (Reset)
      match_address_ff <= 7'b0;
   else if (Match)
      match_address_ff <= match_address;
end


endmodule // lpm_cam

`endcelldefine

//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
// L_FIFO
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
`celldefine

module L_FIFO(Q,Full,Empty,AlmostFull,AlmostEmpty,Data,WrClock,WrEn,RdClock,RdEn,Reset,RPReset) ;

	parameter lpm_type = "LPM_FIFO_DC";
	parameter lpm_width  = 1;
	parameter lpm_widthu  = 1;
	parameter lpm_numwords = 2;
	parameter lpm_hint = "UNUSED";
	parameter lpm_amfull_flag = 1;
	parameter lpm_amempty_flag = 1;

	output [lpm_width-1:0] Q;
	output Full;
	output Empty;
	output AlmostFull;
	output AlmostEmpty;
	input  [lpm_width-1:0] Data;
	input  WrClock;
	input  WrEn;
	input  RdClock;
	input  RdEn;
	input  Reset;
	input  RPReset;

	wire Rst, FullIn, EmptyIn;

	          assign Rst=1'b0;
		  assign FullIn = 1'b0;
		  assign EmptyIn=1'b1;

SC_FIFO_16K_L Inst  (.WE(WrEn ),
		   .WCLK(WrClock ),
		   .RST(Reset ),
		   .RPRST(RPReset ),
		   .RE(RdEn ),
		   .RCLK(RdClock),
		   .FULLIN(FullIn ),
		   .EMPTYIN(EmptyIn ),
		   .DI(Data ),
		   .FULL(Full ),
		   .EMPTY(Empty ),
		   .AMFULL(AlmostFull ),
		   .AMEMPTY(AlmostEmpty ),
		   .DO(Q ));


//defparam Inst.lpm_width_A=lpm_width;
//defparam Inst.ADDR_WIDTH=lpm_width;
defparam Inst.DATA_WIDTH=lpm_width;
defparam Inst.ADDR_WIDTH=lpm_widthu;
defparam Inst.TERMINAL_COUNT = lpm_numwords - 1;
defparam Inst.ALMOST_FULL_X = lpm_amfull_flag;
defparam Inst.ALMOST_EMPTY_Y = lpm_amempty_flag;


endmodule // lpm_fifo

`endcelldefine
`celldefine

module L_RAMDP(
           QA,
           QB,
           DataInA,
           AddressA,
           DataInB,
           AddressB,
           ClockA,
           ClockEnA,
           ClockB,
           ClockEnB,
           WrA,
           WrB,
           ResetA,
           ResetB);

	   parameter lpm_type = "LPM_RAM_DP";
	   parameter lpm_widtha     = 1;
	   parameter lpm_widthada   = 1;
	   parameter lpm_numwordsa  = 1;
	   parameter lpm_widthb     = 1;
	   parameter lpm_widthadb   = 1;
   	   parameter lpm_numwordsb  = 1;
  	   parameter lpm_indata     = "REGISTERED";
	   parameter lpm_outdata    = "UNREGISTERED";
    	   parameter lpm_addressa_control  = "REGISTERED";
	   parameter lpm_addressb_control  = "REGISTERED";
	   parameter lpm_hint = "UNUSED";
	   parameter lpm_init_file = "";

           output [lpm_widtha-1:0] QA;
           output [lpm_widthb-1:0] QB;
           input [lpm_widtha-1:0] DataInA;
           input [lpm_widthada-1:0] AddressA;
           input [lpm_widthb-1:0] DataInB;
           input [lpm_widthadb-1:0] AddressB;
           input ClockA,ClockEnA,ClockB,ClockEnB,WrA,WrB,ResetA,ResetB;

           parameter module_init_flag = (lpm_init_file == "") ? 0 : 1 ;

           wire [lpm_widtha-1:0] QA_int;
           wire [lpm_widthb-1:0] QB_int;
           reg [lpm_widtha-1:0] QA_int_reg;
           reg [lpm_widthb-1:0] QB_int_reg;
           reg [lpm_widtha-1:0] QA;
           reg [lpm_widthb-1:0] QB;
           integer i;

           wire [1:0] csa,csb;
           assign csa = 2'b11;
           assign csb = 2'b11;

          always @ (posedge ClockA or posedge ResetA)
            begin
               if (ResetA)
                 QA_int_reg = 0;
               else if (ClockEnA == 1)
                 QA_int_reg = QA_int;
               else if (ClockEnA !== 0)
                  for(i=0;i<lpm_widtha;i=i+1)
                    QA_int_reg[i] = 1'bx;
                       
            end

          always @ (posedge ClockB or posedge ResetB)
            begin
               if (ResetB)
                 QB_int_reg = 0;
               else if (ClockEnB == 1)
                 QB_int_reg = QB_int;
               else if (ClockEnB !== 0)
                  for(i=0;i<lpm_widthb;i=i+1)
                    QB_int_reg[i] = 1'bx;
            end

          always @ (QA_int or QA_int_reg)
            begin
              if(lpm_outdata == "UNREGISTERED" && lpm_addressa_control == "REGISTERED")
                     QA = QA_int;
              else if(lpm_outdata == "REGISTERED" && lpm_addressa_control == "REGISTERED")
                     QA = QA_int_reg;
            end
     

          always @ (QB_int or QB_int_reg)
            begin
              if(lpm_outdata == "UNREGISTERED" && lpm_addressb_control == "REGISTERED")
                     QB = QB_int;
              else if(lpm_outdata == "REGISTERED" && lpm_addressb_control == "REGISTERED")
                     QB = QB_int_reg;
            end
                    

//	SC_DP_RAM INST_U0(.CENA(ClockEnA),
	SC_DPRAM_16K_L INST_U0(.CENA(ClockEnA),
                          .CLKA(ClockA),
                          .WRA(WrA),
                          .CSA(csa),
                          .RSTA(ResetA),
			  .DIA(DataInA),
                          .ADA(AddressA),
                          .DOA(QA_int),
                          .CENB(ClockEnB),
                          .CLKB(ClockB),
                          .WRB(WrB),
                          .CSB(csb),
                          .RSTB(ResetB),
                          .DIB(DataInB),
                          .ADB(AddressB),
                          .DOB(QB_int));

	defparam INST_U0.ADDR_WIDTH_A = lpm_widthada;
	defparam INST_U0.DATA_WIDTH_A = lpm_widtha;
	defparam INST_U0.ADDR_WIDTH_B = lpm_widthadb;
	defparam INST_U0.DATA_WIDTH_B = lpm_widthb;
	defparam INST_U0.MEM_INIT_FILE = lpm_init_file;
	defparam INST_U0.MEM_INIT_FLAG = module_init_flag;
        defparam INST_U0.ARRAY_SIZE=lpm_numwordsa*lpm_widtha;

endmodule // lpm_cam

`endcelldefine
`celldefine    
module L_RAMDPS(
           Q,
           Data,
           WrAddress,
           RdAddress,
           WrClock,
           WrClockEn,
           RdClock,
           RdClockEn,
           WE,
           Reset);

	   parameter lpm_type = "LPM_RAM_DP_PSEUDO";
	   parameter lpm_widthw     = 1;
	   parameter lpm_widthr     = 1;
	   parameter lpm_numwordsw  = 1;
	   parameter lpm_widthadw   = 1;
	   parameter lpm_widthadr   = 1;
   	   parameter lpm_numwordsr  = 1;
  	   parameter lpm_indata     = "REGISTERED";
	   parameter lpm_outdata    = "UNREGISTERED";
    	   parameter lpm_addressw_control  = "REGISTERED";
	   parameter lpm_addressr_control  = "REGISTERED";
	   parameter lpm_hint = "UNUSED";
	   parameter lpm_init_file = "";

           output [lpm_widthr-1:0] Q;
           input [lpm_widthw-1:0] Data;
           input [lpm_widthadw-1:0] WrAddress;
           input [lpm_widthadr-1:0] RdAddress;
           input WrClock,WrClockEn,RdClock,RdClockEn,WE,Reset;

           parameter module_init_flag = (lpm_init_file == "") ? 0 : 1 ;

           wire [lpm_widthr-1:0] Q_KA, Q_K;
           reg [lpm_widthr-1:0] Q_K_reg, Q_KA_reg, Q;
           integer i;

           wire [1:0]cs;
	   assign cs = 2'b11;


           always @ (posedge RdClock or posedge Reset)
              begin
                 if (Reset)
                    begin
                      Q_K_reg = 0;
                      Q_KA_reg = 0;
                    end
                 else if (RdClockEn == 1)
                    begin
                      Q_K_reg = Q_K;
                      Q_KA_reg = Q_KA;
                    end
                 else if (RdClockEn !== 0)
                    for (i=0;i<lpm_widthr;i=i+1)
                      begin
                       Q_K_reg[i] = 1'bx;
                       Q_KA_reg[i] = 1'bx;
                      end
              end

           always @ (Q_KA or Q_K or Q_K_reg or Q_KA_reg)
              begin
                 if (lpm_outdata == "UNREGISTERED" && lpm_addressr_control == "UNREGISTERED")
                     Q = Q_KA;
                 else if (lpm_outdata == "UNREGISTERED" && lpm_addressr_control == "REGISTERED") 
                     Q = Q_K;
                 else if (lpm_outdata == "REGISTERED" && lpm_addressr_control == "UNREGISTERED")
                     Q = Q_KA_reg;
                 else if (lpm_outdata == "REGISTERED" && lpm_addressr_control == "REGISTERED")
                     Q = Q_K_reg;
              end

//Instance
SC_PDPRAM_16K_L inst( .WCEN(WrClockEn ),
		    .WCLK(WrClock ),
		    .WE(WE ),
		    .WCS(cs ),
		    .RCLK(RdClock ),
		    .RCEN(RdClockEn ),
		    .RST(Reset ),
		    .WD(Data ),
		    .WAD(WrAddress ),
		    .RAD(RdAddress ),
		    .RD(Q_K ));

defparam inst.RDATA_WIDTH =lpm_widthr;
defparam inst.WDATA_WIDTH =lpm_widthw;
defparam inst.WADDR_WIDTH =lpm_widthadw;
defparam inst.RADDR_WIDTH =lpm_widthadr;
defparam inst.ARRAY_SIZE = lpm_numwordsr*lpm_widthr; 
defparam inst.MEM_INIT_FILE = lpm_init_file;
defparam inst.MEM_INIT_FLAG = module_init_flag;


SC_PDPRAMA_16K_L instA( .WCEN(WrClockEn ),
		    .WCLK(WrClock ),
		    .WE(WE ),
		    .WCS(cs ),
//		    .RCLK(RdClock ),
//		    .RCEN(RdClockEn ),
		    .RST(Reset ),
		    .WD(Data ),
		    .WAD(WrAddress ),
		    .RAD(RdAddress ),
		    .RD(Q_KA ));

defparam instA.RDATA_WIDTH =lpm_widthr;
defparam instA.WDATA_WIDTH =lpm_widthw;
defparam instA.WADDR_WIDTH =lpm_widthadw;
defparam instA.RADDR_WIDTH =lpm_widthadr;
defparam instA.ARRAY_SIZE = lpm_numwordsr*lpm_widthr; 
defparam instA.MEM_INIT_FILE = lpm_init_file;
defparam instA.MEM_INIT_FLAG = module_init_flag;



endmodule // lpm_ram_dp_pseudo

`endcelldefine
`celldefine

module L_RAMDQ(
           Q,
           Data,
           Address,
           Clock,
           ClockEn,
           WE,
           Reset);

	   parameter lpm_type = "LPM_RAM_DQ";
	   parameter lpm_width     = 1;
	   parameter lpm_numwords  = 1;
	   parameter lpm_widthad   = 1;
  	   parameter lpm_indata     = "REGISTERED";
	   parameter lpm_outdata    = "UNREGISTERED";
	   parameter lpm_address_control  = "REGISTERED";
	   parameter lpm_hint = "UNUSED";
	   parameter lpm_init_file = "";

           output [lpm_width-1:0] Q;
           input [lpm_width-1:0] Data;
           input [lpm_widthad-1:0] Address;
           input Clock,ClockEn,WE,Reset;

           parameter module_init_flag = (lpm_init_file == "") ? 0 : 1 ;

           wire [lpm_width-1:0] Q_K, Q_KA;
           reg [lpm_width-1:0] Q, Q_K_reg, Q_KA_reg;
           integer i;

           wire [1:0]cs;
	   assign cs = 2'b11;

           always @ (posedge Clock or posedge Reset)
              begin
                if(Reset)
                  begin
                    Q_K_reg = 0;
                    Q_KA_reg = 0;
                  end
                else if (ClockEn == 1)
                  begin
                    Q_K_reg = Q_K;
                    Q_KA_reg = Q_KA;
                  end
                else if (ClockEn !== 0)
                    for (i=0;i<lpm_width;i=i+1)
                      begin
                        Q_K_reg[i] = 1'bx;
                        Q_KA_reg[i] = 1'bx;
                      end
              end

           always @ (Q_K or Q_KA or Q_K_reg or Q_KA_reg)
              begin
                 if (lpm_outdata == "UNREGISTERED" && lpm_address_control == "UNREGISTERED")
                      Q = Q_KA;
                 else if (lpm_outdata == "UNREGISTERED" && lpm_address_control == "REGISTERED")
                      Q = Q_K;
                 else if (lpm_outdata == "REGISTERED" && lpm_address_control == "UNREGISTERED")
                      Q = Q_KA_reg;
                 else if (lpm_outdata == "REGISTERED" && lpm_address_control == "REGISTERED")
                      Q = Q_K_reg;
              end

SC_SPRAM_16K_L inst( .CEN(ClockEn ),
		   .CLK(Clock ),
		   .WR(WE ),
		   .CS(cs ),
		   .RST(Reset ),
		   .DI(Data ),
		   .AD(Address ),
		   .DO(Q_K ));

defparam inst.DATA_WIDTH=lpm_width;
defparam inst.ADDR_WIDTH=lpm_widthad;
defparam inst.ARRAY_SIZE=lpm_numwords* lpm_width;
defparam inst.MEM_INIT_FILE=lpm_init_file;
defparam inst.MEM_INIT_FLAG=module_init_flag;

SC_SPRAMA_16K_L instA( .CEN(ClockEn ),
		   .CLK(Clock ),
		   .WR(WE ),
		   .CS(cs ),
		   .RST(Reset ),
		   .DI(Data ),
		   .AD(Address ),
		   .DO(Q_KA ));

defparam instA.DATA_WIDTH=lpm_width;
defparam instA.ADDR_WIDTH=lpm_widthad;
defparam instA.ARRAY_SIZE=lpm_numwords * lpm_width;
defparam instA.MEM_INIT_FILE=lpm_init_file;
defparam instA.MEM_INIT_FLAG=module_init_flag;

endmodule // lpm_ram_dq

`endcelldefine

`celldefine
module L_ROM(
           Q,
           Address,
           OutClock,
           OutClockEn,
           Reset);

	   parameter lpm_type = "LPM_ROM";
	   parameter lpm_width     = 1;
	   parameter lpm_numwords  = 1;
	   parameter lpm_widthad   = 1;
	   parameter lpm_outdata    = "UNREGISTERED";
	   parameter lpm_address_control  = "REGISTERED";
	   parameter lpm_init_file = "init_file";
	   parameter lpm_hint = "UNUSED";

           output [lpm_width-1:0] Q;
           input [lpm_widthad-1:0] Address;
           input OutClock,OutClockEn,Reset;

           wire [lpm_width-1:0] Q_K, Q_KA;
           reg [lpm_width-1:0] Q, Q_K_reg, Q_KA_reg;

           wire [1:0]cs;
           assign cs = 2'b11;
           wire [lpm_width -1 :0] GND_sig = 0;
           wire WE;
           integer i;

	   assign WE=1'b0;

           always @ (posedge OutClock or posedge Reset)
              begin
                if(Reset)
                   begin
                      Q_K_reg = 0;
                      Q_KA_reg = 0;
                   end
                else if (OutClockEn == 1)
                   begin
                      Q_K_reg = Q_K;
                      Q_KA_reg = Q_KA;
                   end
                else if(OutClockEn !== 0)
                    begin
                      for (i=0;i<lpm_width;i=i+1)
                        begin
                         Q_K_reg[i] = 1'bx;
                         Q_KA_reg[i] = 1'bx;
                        end
                    end
              end

           always @ (Q_K or Q_KA or Q_K_reg or Q_KA_reg)
              begin
                 if (lpm_outdata == "UNREGISTERED" && lpm_address_control == "UNREGISTERED")
                      Q = Q_KA;
                 else if (lpm_outdata == "UNREGISTERED" && lpm_address_control == "REGISTERED")
                      Q = Q_K;
                 else if (lpm_outdata == "REGISTERED" && lpm_address_control == "UNREGISTERED")
                      Q = Q_KA_reg;
                 else if (lpm_outdata == "REGISTERED" && lpm_address_control == "REGISTERED")
                      Q = Q_K_reg;
              end

//Instance
SC_SPRAM_16K_L inst( .CEN(OutClockEn ),
                   .CLK(OutClock ),
                   .WR(WE ),
                   .CS(cs ),
                   .RST(Reset ),
                   .DI(GND_sig),
                   .AD(Address ),
                   .DO(Q_K ));
 
defparam inst.DATA_WIDTH=lpm_width;
defparam inst.ADDR_WIDTH=lpm_widthad;
defparam inst.ARRAY_SIZE=lpm_numwords * lpm_width;
defparam inst.MEM_INIT_FILE=lpm_init_file;

SC_SPRAMA_16K_L instA( .CEN(OutClockEn ),
                   .CLK(OutClock ),
                   .WR(WE ),
                   .CS(cs ),
                   .RST(Reset ),
                   .DI(GND_sig),
                   .AD(Address ),
                   .DO(Q_KA ));
 
defparam instA.DATA_WIDTH=lpm_width;
defparam instA.ADDR_WIDTH=lpm_widthad;
defparam instA.ARRAY_SIZE=lpm_numwords * lpm_width;
defparam instA.MEM_INIT_FILE=lpm_init_file;
 


endmodule // lpm_rom

`endcelldefine
`celldefine

module L_FIFODCX(Q,Full,Empty,AlmostFull,AlmostEmpty,Data,WrClock,WrEn,RdClock,RdEn,Reset,RPReset) ;

	parameter lpm_type = "LPM_FIFO_DCX";
	parameter lpm_widthw  = 1;
	parameter lpm_widthr  = 1;
	parameter lpm_widthuw  = 1;
	parameter lpm_widthur  = 1;
	parameter lpm_numwordsw = 2;
	parameter lpm_numwordsr = 2;
	parameter lpm_hint = "UNUSED";
	parameter lpm_amfull_flag = 1;
	parameter lpm_amempty_flag = 1;

	output [lpm_widthr-1:0] Q;
	output Full;
	output Empty;
	output AlmostFull;
	output AlmostEmpty;
	input  [lpm_widthw-1:0] Data;
	input  WrClock;
	input  WrEn;
	input  RdClock;
	input  RdEn;
	input  Reset;
	input  RPReset;

	wire FullIn, EmptyIn;

		  assign FullIn = 1'b0;
		  assign EmptyIn=1'b1;

SC_FIFO_V2_16K Inst  (.WE(WrEn ),
		   .WCLK(WrClock ),
		   .RST(Reset ),
		   .RPRST(RPReset ),
		   .RE(RdEn ),
		   .RCLK(RdClock),
		   .FULLIN(FullIn ),
		   .EMPTYIN(EmptyIn ),
		   .DI(Data ),
		   .FULL(Full ),
		   .EMPTY(Empty ),
		   .AMFULL(AlmostFull ),
		   .AMEMPTY(AlmostEmpty ),
		   .DO(Q ));


defparam Inst.RDATA_WIDTH=lpm_widthr;
defparam Inst.WDATA_WIDTH=lpm_widthw;
defparam Inst.RADDR_WIDTH=lpm_widthur;
defparam Inst.WADDR_WIDTH=lpm_widthuw;
defparam Inst.TERMINAL_COUNT = lpm_numwordsw - 1;
defparam Inst.ALMOST_FULL_X = lpm_amfull_flag;
defparam Inst.ALMOST_EMPTY_Y = lpm_amempty_flag;
//defparam Inst.ARRAY_SIZE = lpm_numwordsw * lpm_widthw;


endmodule // lpm_fifodcx

`endcelldefine
`celldefine
module RAMBFIFO16KA_WX32_RX16 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15,DI16,DI17,DI18,DI19,DI20,DI21,DI22,DI23,DI24,DI25,DI26,DI27,DI28,DI29,DI30,DI31,
    DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 512;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15,DI16,DI17,DI18,DI19,DI20,DI21,DI22,DI23,DI24,DI25,DI26,DI27,DI28,DI29,DI30,DI31;
output DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [31:0] di;
wire [15:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ16 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ17 (EMPTY,EMPTY_sig);	 
buf INSXQ18 (AMFULL,AMFULL_node);	 
buf INSXQ19 (AMEMPTY,AMEMPTY_node);	 
assign di = {DI31,DI30,DI29,DI28,DI27,DI26,DI25,DI24,DI23,DI22,DI21,DI20,DI19,DI18,DI17,DI16,DI15,DI14,DI13,DI12,DI11,DI10,DI9,DI8,DI7,DI6,DI5,DI4,DI3,DI2,DI1,DI0};
//assign {DO15,DO14,DO13,DO12,DO11,DO10,DO9,DO8,DO7,DO6,DO5,DO4,DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
buf INSXQ4 (DO4,do[4]);
buf INSXQ5 (DO5,do[5]);
buf INSXQ6 (DO6,do[6]);
buf INSXQ7 (DO7,do[7]);
buf INSXQ8 (DO8,do[8]);
buf INSXQ9 (DO9,do[9]);
buf INSXQ10 (DO10,do[10]);
buf INSXQ11 (DO11,do[11]);
buf INSXQ12 (DO12,do[12]);
buf INSXQ13 (DO13,do[13]);
buf INSXQ14 (DO14,do[14]);
buf INSXQ15 (DO15,do[15]);
defparam FIFO_U0.WADDR_WIDTH = 9;
defparam FIFO_U0.WDATA_WIDTH = 32;

defparam FIFO_U0.RADDR_WIDTH = 10;
defparam FIFO_U0.RDATA_WIDTH = 16;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);
	$setuphold  (posedge WCLK, DI2, 1, 0);
	$setuphold  (posedge WCLK, DI3, 1, 0);
	$setuphold  (posedge WCLK, DI4, 1, 0);
	$setuphold  (posedge WCLK, DI5, 1, 0);
	$setuphold  (posedge WCLK, DI6, 1, 0);
	$setuphold  (posedge WCLK, DI7, 1, 0);
	$setuphold  (posedge WCLK, DI8, 1, 0);
	$setuphold  (posedge WCLK, DI9, 1, 0);
	$setuphold  (posedge WCLK, DI10, 1, 0);
	$setuphold  (posedge WCLK, DI11, 1, 0);
	$setuphold  (posedge WCLK, DI12, 1, 0);
	$setuphold  (posedge WCLK, DI13, 1, 0);
	$setuphold  (posedge WCLK, DI14, 1, 0);
	$setuphold  (posedge WCLK, DI15, 1, 0);
	$setuphold  (posedge WCLK, DI16, 1, 0);
	$setuphold  (posedge WCLK, DI17, 1, 0);
	$setuphold  (posedge WCLK, DI18, 1, 0);
	$setuphold  (posedge WCLK, DI19, 1, 0);
	$setuphold  (posedge WCLK, DI20, 1, 0);
	$setuphold  (posedge WCLK, DI21, 1, 0);
	$setuphold  (posedge WCLK, DI22, 1, 0);
	$setuphold  (posedge WCLK, DI23, 1, 0);
	$setuphold  (posedge WCLK, DI24, 1, 0);
	$setuphold  (posedge WCLK, DI25, 1, 0);
	$setuphold  (posedge WCLK, DI26, 1, 0);
	$setuphold  (posedge WCLK, DI27, 1, 0);
	$setuphold  (posedge WCLK, DI28, 1, 0);
	$setuphold  (posedge WCLK, DI29, 1, 0);
	$setuphold  (posedge WCLK, DI30, 1, 0);
	$setuphold  (posedge WCLK, DI31, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);
        (RCLK => DO1)    = (0:0:0, 0:0:0);
        (RCLK => DO2)    = (0:0:0, 0:0:0);
        (RCLK => DO3)    = (0:0:0, 0:0:0);
        (RCLK => DO4)    = (0:0:0, 0:0:0);
        (RCLK => DO5)    = (0:0:0, 0:0:0);
        (RCLK => DO6)    = (0:0:0, 0:0:0);
        (RCLK => DO7)    = (0:0:0, 0:0:0);
        (RCLK => DO8)    = (0:0:0, 0:0:0);
        (RCLK => DO9)    = (0:0:0, 0:0:0);
        (RCLK => DO10)    = (0:0:0, 0:0:0);
        (RCLK => DO11)    = (0:0:0, 0:0:0);
        (RCLK => DO12)    = (0:0:0, 0:0:0);
        (RCLK => DO13)    = (0:0:0, 0:0:0);
        (RCLK => DO14)    = (0:0:0, 0:0:0);
        (RCLK => DO15)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);
        (RST => DO1)    = (0:0:0, 0:0:0);
        (RST => DO2)    = (0:0:0, 0:0:0);
        (RST => DO3)    = (0:0:0, 0:0:0);
        (RST => DO4)    = (0:0:0, 0:0:0);
        (RST => DO5)    = (0:0:0, 0:0:0);
        (RST => DO6)    = (0:0:0, 0:0:0);
        (RST => DO7)    = (0:0:0, 0:0:0);
        (RST => DO8)    = (0:0:0, 0:0:0);
        (RST => DO9)    = (0:0:0, 0:0:0);
        (RST => DO10)    = (0:0:0, 0:0:0);
        (RST => DO11)    = (0:0:0, 0:0:0);
        (RST => DO12)    = (0:0:0, 0:0:0);
        (RST => DO13)    = (0:0:0, 0:0:0);
        (RST => DO14)    = (0:0:0, 0:0:0);
        (RST => DO15)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX32_RX8 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15,DI16,DI17,DI18,DI19,DI20,DI21,DI22,DI23,DI24,DI25,DI26,DI27,DI28,DI29,DI30,DI31,
    DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 512;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15,DI16,DI17,DI18,DI19,DI20,DI21,DI22,DI23,DI24,DI25,DI26,DI27,DI28,DI29,DI30,DI31;
output DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [31:0] di;
wire [7:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ8 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ9 (EMPTY,EMPTY_sig);	 
buf INSXQ10 (AMFULL,AMFULL_node);	 
buf INSXQ11 (AMEMPTY,AMEMPTY_node);	
assign di = {DI31,DI30,DI29,DI28,DI27,DI26,DI25,DI24,DI23,DI22,DI21,DI20,DI19,DI18,DI17,DI16,DI15,DI14,DI13,DI12,DI11,DI10,DI9,DI8,DI7,DI6,DI5,DI4,DI3,DI2,DI1,DI0};
//assign {DO7,DO6,DO5,DO4,DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
buf INSXQ4 (DO4,do[4]);
buf INSXQ5 (DO5,do[5]);
buf INSXQ6 (DO6,do[6]);
buf INSXQ7 (DO7,do[7]);
defparam FIFO_U0.WADDR_WIDTH = 9;
defparam FIFO_U0.WDATA_WIDTH = 32;

defparam FIFO_U0.RADDR_WIDTH = 11;
defparam FIFO_U0.RDATA_WIDTH = 8;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);
	$setuphold  (posedge WCLK, DI2, 1, 0);
	$setuphold  (posedge WCLK, DI3, 1, 0);
	$setuphold  (posedge WCLK, DI4, 1, 0);
	$setuphold  (posedge WCLK, DI5, 1, 0);
	$setuphold  (posedge WCLK, DI6, 1, 0);
	$setuphold  (posedge WCLK, DI7, 1, 0);
	$setuphold  (posedge WCLK, DI8, 1, 0);
	$setuphold  (posedge WCLK, DI9, 1, 0);
	$setuphold  (posedge WCLK, DI10, 1, 0);
	$setuphold  (posedge WCLK, DI11, 1, 0);
	$setuphold  (posedge WCLK, DI12, 1, 0);
	$setuphold  (posedge WCLK, DI13, 1, 0);
	$setuphold  (posedge WCLK, DI14, 1, 0);
	$setuphold  (posedge WCLK, DI15, 1, 0);
	$setuphold  (posedge WCLK, DI16, 1, 0);
	$setuphold  (posedge WCLK, DI17, 1, 0);
	$setuphold  (posedge WCLK, DI18, 1, 0);
	$setuphold  (posedge WCLK, DI19, 1, 0);
	$setuphold  (posedge WCLK, DI20, 1, 0);
	$setuphold  (posedge WCLK, DI21, 1, 0);
	$setuphold  (posedge WCLK, DI22, 1, 0);
	$setuphold  (posedge WCLK, DI23, 1, 0);
	$setuphold  (posedge WCLK, DI24, 1, 0);
	$setuphold  (posedge WCLK, DI25, 1, 0);
	$setuphold  (posedge WCLK, DI26, 1, 0);
	$setuphold  (posedge WCLK, DI27, 1, 0);
	$setuphold  (posedge WCLK, DI28, 1, 0);
	$setuphold  (posedge WCLK, DI29, 1, 0);
	$setuphold  (posedge WCLK, DI30, 1, 0);
	$setuphold  (posedge WCLK, DI31, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);
        (RCLK => DO1)    = (0:0:0, 0:0:0);
        (RCLK => DO2)    = (0:0:0, 0:0:0);
        (RCLK => DO3)    = (0:0:0, 0:0:0);
        (RCLK => DO4)    = (0:0:0, 0:0:0);
        (RCLK => DO5)    = (0:0:0, 0:0:0);
        (RCLK => DO6)    = (0:0:0, 0:0:0);
        (RCLK => DO7)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);
        (RST => DO1)    = (0:0:0, 0:0:0);
        (RST => DO2)    = (0:0:0, 0:0:0);
        (RST => DO3)    = (0:0:0, 0:0:0);
        (RST => DO4)    = (0:0:0, 0:0:0);
        (RST => DO5)    = (0:0:0, 0:0:0);
        (RST => DO6)    = (0:0:0, 0:0:0);
        (RST => DO7)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX32_RX4 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15,DI16,DI17,DI18,DI19,DI20,DI21,DI22,DI23,DI24,DI25,DI26,DI27,DI28,DI29,DI30,DI31,
    DO0,DO1,DO2,DO3,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 512;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15,DI16,DI17,DI18,DI19,DI20,DI21,DI22,DI23,DI24,DI25,DI26,DI27,DI28,DI29,DI30,DI31;
output DO0,DO1,DO2,DO3;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [31:0] di;
wire [3:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ4 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ5 (EMPTY,EMPTY_sig);	 
buf INSXQ6 (AMFULL,AMFULL_node);	 
buf INSXQ7 (AMEMPTY,AMEMPTY_node);
assign di = {DI31,DI30,DI29,DI28,DI27,DI26,DI25,DI24,DI23,DI22,DI21,DI20,DI19,DI18,DI17,DI16,DI15,DI14,DI13,DI12,DI11,DI10,DI9,DI8,DI7,DI6,DI5,DI4,DI3,DI2,DI1,DI0};
//assign {DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
defparam FIFO_U0.WADDR_WIDTH = 9;
defparam FIFO_U0.WDATA_WIDTH = 32;

defparam FIFO_U0.RADDR_WIDTH = 12;
defparam FIFO_U0.RDATA_WIDTH = 4;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);
	$setuphold  (posedge WCLK, DI2, 1, 0);
	$setuphold  (posedge WCLK, DI3, 1, 0);
	$setuphold  (posedge WCLK, DI4, 1, 0);
	$setuphold  (posedge WCLK, DI5, 1, 0);
	$setuphold  (posedge WCLK, DI6, 1, 0);
	$setuphold  (posedge WCLK, DI7, 1, 0);
	$setuphold  (posedge WCLK, DI8, 1, 0);
	$setuphold  (posedge WCLK, DI9, 1, 0);
	$setuphold  (posedge WCLK, DI10, 1, 0);
	$setuphold  (posedge WCLK, DI11, 1, 0);
	$setuphold  (posedge WCLK, DI12, 1, 0);
	$setuphold  (posedge WCLK, DI13, 1, 0);
	$setuphold  (posedge WCLK, DI14, 1, 0);
	$setuphold  (posedge WCLK, DI15, 1, 0);
	$setuphold  (posedge WCLK, DI16, 1, 0);
	$setuphold  (posedge WCLK, DI17, 1, 0);
	$setuphold  (posedge WCLK, DI18, 1, 0);
	$setuphold  (posedge WCLK, DI19, 1, 0);
	$setuphold  (posedge WCLK, DI20, 1, 0);
	$setuphold  (posedge WCLK, DI21, 1, 0);
	$setuphold  (posedge WCLK, DI22, 1, 0);
	$setuphold  (posedge WCLK, DI23, 1, 0);
	$setuphold  (posedge WCLK, DI24, 1, 0);
	$setuphold  (posedge WCLK, DI25, 1, 0);
	$setuphold  (posedge WCLK, DI26, 1, 0);
	$setuphold  (posedge WCLK, DI27, 1, 0);
	$setuphold  (posedge WCLK, DI28, 1, 0);
	$setuphold  (posedge WCLK, DI29, 1, 0);
	$setuphold  (posedge WCLK, DI30, 1, 0);
	$setuphold  (posedge WCLK, DI31, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);
        (RCLK => DO1)    = (0:0:0, 0:0:0);
        (RCLK => DO2)    = (0:0:0, 0:0:0);
        (RCLK => DO3)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);
        (RST => DO1)    = (0:0:0, 0:0:0);
        (RST => DO2)    = (0:0:0, 0:0:0);
        (RST => DO3)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX32_RX2 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15,DI16,DI17,DI18,DI19,DI20,DI21,DI22,DI23,DI24,DI25,DI26,DI27,DI28,DI29,DI30,DI31,
    DO0,DO1,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 512;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15,DI16,DI17,DI18,DI19,DI20,DI21,DI22,DI23,DI24,DI25,DI26,DI27,DI28,DI29,DI30,DI31;
output DO0,DO1;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [31:0] di;
wire [1:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ2 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ3 (EMPTY,EMPTY_sig);	 
buf INSXQ4 (AMFULL,AMFULL_node);	 
buf INSXQ5 (AMEMPTY,AMEMPTY_node);	
assign di = {DI31,DI30,DI29,DI28,DI27,DI26,DI25,DI24,DI23,DI22,DI21,DI20,DI19,DI18,DI17,DI16,DI15,DI14,DI13,DI12,DI11,DI10,DI9,DI8,DI7,DI6,DI5,DI4,DI3,DI2,DI1,DI0};
//assign {DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);

defparam FIFO_U0.WADDR_WIDTH = 9;
defparam FIFO_U0.WDATA_WIDTH = 32;

defparam FIFO_U0.RADDR_WIDTH = 13;
defparam FIFO_U0.RDATA_WIDTH = 2;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);
	$setuphold  (posedge WCLK, DI2, 1, 0);
	$setuphold  (posedge WCLK, DI3, 1, 0);
	$setuphold  (posedge WCLK, DI4, 1, 0);
	$setuphold  (posedge WCLK, DI5, 1, 0);
	$setuphold  (posedge WCLK, DI6, 1, 0);
	$setuphold  (posedge WCLK, DI7, 1, 0);
	$setuphold  (posedge WCLK, DI8, 1, 0);
	$setuphold  (posedge WCLK, DI9, 1, 0);
	$setuphold  (posedge WCLK, DI10, 1, 0);
	$setuphold  (posedge WCLK, DI11, 1, 0);
	$setuphold  (posedge WCLK, DI12, 1, 0);
	$setuphold  (posedge WCLK, DI13, 1, 0);
	$setuphold  (posedge WCLK, DI14, 1, 0);
	$setuphold  (posedge WCLK, DI15, 1, 0);
	$setuphold  (posedge WCLK, DI16, 1, 0);
	$setuphold  (posedge WCLK, DI17, 1, 0);
	$setuphold  (posedge WCLK, DI18, 1, 0);
	$setuphold  (posedge WCLK, DI19, 1, 0);
	$setuphold  (posedge WCLK, DI20, 1, 0);
	$setuphold  (posedge WCLK, DI21, 1, 0);
	$setuphold  (posedge WCLK, DI22, 1, 0);
	$setuphold  (posedge WCLK, DI23, 1, 0);
	$setuphold  (posedge WCLK, DI24, 1, 0);
	$setuphold  (posedge WCLK, DI25, 1, 0);
	$setuphold  (posedge WCLK, DI26, 1, 0);
	$setuphold  (posedge WCLK, DI27, 1, 0);
	$setuphold  (posedge WCLK, DI28, 1, 0);
	$setuphold  (posedge WCLK, DI29, 1, 0);
	$setuphold  (posedge WCLK, DI30, 1, 0);
	$setuphold  (posedge WCLK, DI31, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);
        (RCLK => DO1)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);
        (RST => DO1)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX32_RX1 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15,DI16,DI17,DI18,DI19,DI20,DI21,DI22,DI23,DI24,DI25,DI26,DI27,DI28,DI29,DI30,DI31,
    DO0,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 512;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15,DI16,DI17,DI18,DI19,DI20,DI21,DI22,DI23,DI24,DI25,DI26,DI27,DI28,DI29,DI30,DI31;
output DO0;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [31:0] di;
wire [0:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ1 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ2 (EMPTY,EMPTY_sig);	 
buf INSXQ3 (AMFULL,AMFULL_node);	 
buf INSXQ4 (AMEMPTY,AMEMPTY_node);	
assign di = {DI31,DI30,DI29,DI28,DI27,DI26,DI25,DI24,DI23,DI22,DI21,DI20,DI19,DI18,DI17,DI16,DI15,DI14,DI13,DI12,DI11,DI10,DI9,DI8,DI7,DI6,DI5,DI4,DI3,DI2,DI1,DI0};
//assign {DO0} = do;
buf INSXQ0 (DO0,do);

defparam FIFO_U0.WADDR_WIDTH = 9;
defparam FIFO_U0.WDATA_WIDTH = 32;

defparam FIFO_U0.RADDR_WIDTH = 14;
defparam FIFO_U0.RDATA_WIDTH = 1;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);
	$setuphold  (posedge WCLK, DI2, 1, 0);
	$setuphold  (posedge WCLK, DI3, 1, 0);
	$setuphold  (posedge WCLK, DI4, 1, 0);
	$setuphold  (posedge WCLK, DI5, 1, 0);
	$setuphold  (posedge WCLK, DI6, 1, 0);
	$setuphold  (posedge WCLK, DI7, 1, 0);
	$setuphold  (posedge WCLK, DI8, 1, 0);
	$setuphold  (posedge WCLK, DI9, 1, 0);
	$setuphold  (posedge WCLK, DI10, 1, 0);
	$setuphold  (posedge WCLK, DI11, 1, 0);
	$setuphold  (posedge WCLK, DI12, 1, 0);
	$setuphold  (posedge WCLK, DI13, 1, 0);
	$setuphold  (posedge WCLK, DI14, 1, 0);
	$setuphold  (posedge WCLK, DI15, 1, 0);
	$setuphold  (posedge WCLK, DI16, 1, 0);
	$setuphold  (posedge WCLK, DI17, 1, 0);
	$setuphold  (posedge WCLK, DI18, 1, 0);
	$setuphold  (posedge WCLK, DI19, 1, 0);
	$setuphold  (posedge WCLK, DI20, 1, 0);
	$setuphold  (posedge WCLK, DI21, 1, 0);
	$setuphold  (posedge WCLK, DI22, 1, 0);
	$setuphold  (posedge WCLK, DI23, 1, 0);
	$setuphold  (posedge WCLK, DI24, 1, 0);
	$setuphold  (posedge WCLK, DI25, 1, 0);
	$setuphold  (posedge WCLK, DI26, 1, 0);
	$setuphold  (posedge WCLK, DI27, 1, 0);
	$setuphold  (posedge WCLK, DI28, 1, 0);
	$setuphold  (posedge WCLK, DI29, 1, 0);
	$setuphold  (posedge WCLK, DI30, 1, 0);
	$setuphold  (posedge WCLK, DI31, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX16_RX8 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15,
    DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 1024;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15;
output DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [15:0] di;
wire [7:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ8 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ9 (EMPTY,EMPTY_sig);	 
buf INSXQ10 (AMFULL,AMFULL_node);	 
buf INSXQ11 (AMEMPTY,AMEMPTY_node);	
assign di = {DI15,DI14,DI13,DI12,DI11,DI10,DI9,DI8,DI7,DI6,DI5,DI4,DI3,DI2,DI1,DI0};
//assign {DO7,DO6,DO5,DO4,DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
buf INSXQ4 (DO4,do[4]);
buf INSXQ5 (DO5,do[5]);
buf INSXQ6 (DO6,do[6]);
buf INSXQ7 (DO7,do[7]);
defparam FIFO_U0.WADDR_WIDTH = 10;
defparam FIFO_U0.WDATA_WIDTH = 16;

defparam FIFO_U0.RADDR_WIDTH = 11;
defparam FIFO_U0.RDATA_WIDTH = 8;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);
	$setuphold  (posedge WCLK, DI2, 1, 0);
	$setuphold  (posedge WCLK, DI3, 1, 0);
	$setuphold  (posedge WCLK, DI4, 1, 0);
	$setuphold  (posedge WCLK, DI5, 1, 0);
	$setuphold  (posedge WCLK, DI6, 1, 0);
	$setuphold  (posedge WCLK, DI7, 1, 0);
	$setuphold  (posedge WCLK, DI8, 1, 0);
	$setuphold  (posedge WCLK, DI9, 1, 0);
	$setuphold  (posedge WCLK, DI10, 1, 0);
	$setuphold  (posedge WCLK, DI11, 1, 0);
	$setuphold  (posedge WCLK, DI12, 1, 0);
	$setuphold  (posedge WCLK, DI13, 1, 0);
	$setuphold  (posedge WCLK, DI14, 1, 0);
	$setuphold  (posedge WCLK, DI15, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);
        (RCLK => DO1)    = (0:0:0, 0:0:0);
        (RCLK => DO2)    = (0:0:0, 0:0:0);
        (RCLK => DO3)    = (0:0:0, 0:0:0);
        (RCLK => DO4)    = (0:0:0, 0:0:0);
        (RCLK => DO5)    = (0:0:0, 0:0:0);
        (RCLK => DO6)    = (0:0:0, 0:0:0);
        (RCLK => DO7)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);
        (RST => DO1)    = (0:0:0, 0:0:0);
        (RST => DO2)    = (0:0:0, 0:0:0);
        (RST => DO3)    = (0:0:0, 0:0:0);
        (RST => DO4)    = (0:0:0, 0:0:0);
        (RST => DO5)    = (0:0:0, 0:0:0);
        (RST => DO6)    = (0:0:0, 0:0:0);
        (RST => DO7)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX16_RX4 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15,
    DO0,DO1,DO2,DO3,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 1024;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15;
output DO0,DO1,DO2,DO3;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [15:0] di;
wire [3:0] do;
wire FULL_sig, EMPTY_sig;	 
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ4 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ5 (EMPTY,EMPTY_sig);	 
buf INSXQ6 (AMFULL,AMFULL_node);	 
buf INSXQ7 (AMEMPTY,AMEMPTY_node);
assign di = {DI15,DI14,DI13,DI12,DI11,DI10,DI9,DI8,DI7,DI6,DI5,DI4,DI3,DI2,DI1,DI0};
//assign {DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
defparam FIFO_U0.WADDR_WIDTH = 10;
defparam FIFO_U0.WDATA_WIDTH = 16;

defparam FIFO_U0.RADDR_WIDTH = 12;
defparam FIFO_U0.RDATA_WIDTH = 4;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);
	$setuphold  (posedge WCLK, DI2, 1, 0);
	$setuphold  (posedge WCLK, DI3, 1, 0);
	$setuphold  (posedge WCLK, DI4, 1, 0);
	$setuphold  (posedge WCLK, DI5, 1, 0);
	$setuphold  (posedge WCLK, DI6, 1, 0);
	$setuphold  (posedge WCLK, DI7, 1, 0);
	$setuphold  (posedge WCLK, DI8, 1, 0);
	$setuphold  (posedge WCLK, DI9, 1, 0);
	$setuphold  (posedge WCLK, DI10, 1, 0);
	$setuphold  (posedge WCLK, DI11, 1, 0);
	$setuphold  (posedge WCLK, DI12, 1, 0);
	$setuphold  (posedge WCLK, DI13, 1, 0);
	$setuphold  (posedge WCLK, DI14, 1, 0);
	$setuphold  (posedge WCLK, DI15, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);
        (RCLK => DO1)    = (0:0:0, 0:0:0);
        (RCLK => DO2)    = (0:0:0, 0:0:0);
        (RCLK => DO3)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);
        (RST => DO1)    = (0:0:0, 0:0:0);
        (RST => DO2)    = (0:0:0, 0:0:0);
        (RST => DO3)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX16_RX2 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15,
    DO0,DO1,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 1024;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15;
output DO0,DO1;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [15:0] di;
wire [1:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ2 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ3 (EMPTY,EMPTY_sig);	 
buf INSXQ4 (AMFULL,AMFULL_node);	 
buf INSXQ5 (AMEMPTY,AMEMPTY_node);	
assign di = {DI15,DI14,DI13,DI12,DI11,DI10,DI9,DI8,DI7,DI6,DI5,DI4,DI3,DI2,DI1,DI0};
//assign {DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);

defparam FIFO_U0.WADDR_WIDTH = 10;
defparam FIFO_U0.WDATA_WIDTH = 16;

defparam FIFO_U0.RADDR_WIDTH = 13;
defparam FIFO_U0.RDATA_WIDTH = 2;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);
	$setuphold  (posedge WCLK, DI2, 1, 0);
	$setuphold  (posedge WCLK, DI3, 1, 0);
	$setuphold  (posedge WCLK, DI4, 1, 0);
	$setuphold  (posedge WCLK, DI5, 1, 0);
	$setuphold  (posedge WCLK, DI6, 1, 0);
	$setuphold  (posedge WCLK, DI7, 1, 0);
	$setuphold  (posedge WCLK, DI8, 1, 0);
	$setuphold  (posedge WCLK, DI9, 1, 0);
	$setuphold  (posedge WCLK, DI10, 1, 0);
	$setuphold  (posedge WCLK, DI11, 1, 0);
	$setuphold  (posedge WCLK, DI12, 1, 0);
	$setuphold  (posedge WCLK, DI13, 1, 0);
	$setuphold  (posedge WCLK, DI14, 1, 0);
	$setuphold  (posedge WCLK, DI15, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);
        (RCLK => DO1)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);
        (RST => DO1)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX16_RX1 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15,
    DO0,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 1024;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15;
output DO0;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [15:0] di;
wire [0:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ1 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ2 (EMPTY,EMPTY_sig);	 
buf INSXQ3 (AMFULL,AMFULL_node);	 
buf INSXQ4 (AMEMPTY,AMEMPTY_node);	
assign di = {DI15,DI14,DI13,DI12,DI11,DI10,DI9,DI8,DI7,DI6,DI5,DI4,DI3,DI2,DI1,DI0};
//assign {DO0} = do;
buf INSXQ0 (DO0,do);

defparam FIFO_U0.WADDR_WIDTH = 10;
defparam FIFO_U0.WDATA_WIDTH = 16;

defparam FIFO_U0.RADDR_WIDTH = 14;
defparam FIFO_U0.RDATA_WIDTH = 1;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);
	$setuphold  (posedge WCLK, DI2, 1, 0);
	$setuphold  (posedge WCLK, DI3, 1, 0);
	$setuphold  (posedge WCLK, DI4, 1, 0);
	$setuphold  (posedge WCLK, DI5, 1, 0);
	$setuphold  (posedge WCLK, DI6, 1, 0);
	$setuphold  (posedge WCLK, DI7, 1, 0);
	$setuphold  (posedge WCLK, DI8, 1, 0);
	$setuphold  (posedge WCLK, DI9, 1, 0);
	$setuphold  (posedge WCLK, DI10, 1, 0);
	$setuphold  (posedge WCLK, DI11, 1, 0);
	$setuphold  (posedge WCLK, DI12, 1, 0);
	$setuphold  (posedge WCLK, DI13, 1, 0);
	$setuphold  (posedge WCLK, DI14, 1, 0);
	$setuphold  (posedge WCLK, DI15, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX8_RX4 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,
    DO0,DO1,DO2,DO3,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 2048;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7;
output DO0,DO1,DO2,DO3;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [7:0] di;
wire [3:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ4 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ5 (EMPTY,EMPTY_sig);	 
buf INSXQ6 (AMFULL,AMFULL_node);	 
buf INSXQ7 (AMEMPTY,AMEMPTY_node);
assign di = {DI7,DI6,DI5,DI4,DI3,DI2,DI1,DI0};
//assign {DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
defparam FIFO_U0.WADDR_WIDTH = 11;
defparam FIFO_U0.WDATA_WIDTH = 8;

defparam FIFO_U0.RADDR_WIDTH = 12;
defparam FIFO_U0.RDATA_WIDTH = 4;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);
	$setuphold  (posedge WCLK, DI2, 1, 0);
	$setuphold  (posedge WCLK, DI3, 1, 0);
	$setuphold  (posedge WCLK, DI4, 1, 0);
	$setuphold  (posedge WCLK, DI5, 1, 0);
	$setuphold  (posedge WCLK, DI6, 1, 0);
	$setuphold  (posedge WCLK, DI7, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);
        (RCLK => DO1)    = (0:0:0, 0:0:0);
        (RCLK => DO2)    = (0:0:0, 0:0:0);
        (RCLK => DO3)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);
        (RST => DO1)    = (0:0:0, 0:0:0);
        (RST => DO2)    = (0:0:0, 0:0:0);
        (RST => DO3)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX8_RX2 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,
    DO0,DO1,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 2048;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7;
output DO0,DO1;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [7:0] di;
wire [1:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ2 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ3 (EMPTY,EMPTY_sig);	 
buf INSXQ4 (AMFULL,AMFULL_node);	 
buf INSXQ5 (AMEMPTY,AMEMPTY_node);	
assign di = {DI7,DI6,DI5,DI4,DI3,DI2,DI1,DI0};
//assign {DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);

defparam FIFO_U0.WADDR_WIDTH = 11;
defparam FIFO_U0.WDATA_WIDTH = 8;

defparam FIFO_U0.RADDR_WIDTH = 13;
defparam FIFO_U0.RDATA_WIDTH = 2;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);
	$setuphold  (posedge WCLK, DI2, 1, 0);
	$setuphold  (posedge WCLK, DI3, 1, 0);
	$setuphold  (posedge WCLK, DI4, 1, 0);
	$setuphold  (posedge WCLK, DI5, 1, 0);
	$setuphold  (posedge WCLK, DI6, 1, 0);
	$setuphold  (posedge WCLK, DI7, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);
        (RCLK => DO1)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);
        (RST => DO1)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX8_RX1 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,
    DO0,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 2048;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7;
output DO0;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [7:0] di;
wire [0:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ1 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ2 (EMPTY,EMPTY_sig);	 
buf INSXQ3 (AMFULL,AMFULL_node);	 
buf INSXQ4 (AMEMPTY,AMEMPTY_node);	
assign di = {DI7,DI6,DI5,DI4,DI3,DI2,DI1,DI0};
//assign {DO0} = do;
buf INSXQ0 (DO0,do);

defparam FIFO_U0.WADDR_WIDTH = 11;
defparam FIFO_U0.WDATA_WIDTH = 8;

defparam FIFO_U0.RADDR_WIDTH = 14;
defparam FIFO_U0.RDATA_WIDTH = 1;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);
	$setuphold  (posedge WCLK, DI2, 1, 0);
	$setuphold  (posedge WCLK, DI3, 1, 0);
	$setuphold  (posedge WCLK, DI4, 1, 0);
	$setuphold  (posedge WCLK, DI5, 1, 0);
	$setuphold  (posedge WCLK, DI6, 1, 0);
	$setuphold  (posedge WCLK, DI7, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX4_RX2 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,DI1,DI2,DI3,
    DO0,DO1,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 4096;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1,DI2,DI3;
output DO0,DO1;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [3:0] di;
wire [1:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ2 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ3 (EMPTY,EMPTY_sig);	 
buf INSXQ4 (AMFULL,AMFULL_node);	 
buf INSXQ5 (AMEMPTY,AMEMPTY_node);
assign di = {DI3,DI2,DI1,DI0};
//assign {DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
defparam FIFO_U0.WADDR_WIDTH = 12;
defparam FIFO_U0.WDATA_WIDTH = 4;

defparam FIFO_U0.RADDR_WIDTH = 13;
defparam FIFO_U0.RDATA_WIDTH = 2;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);
	$setuphold  (posedge WCLK, DI2, 1, 0);
	$setuphold  (posedge WCLK, DI3, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);
        (RCLK => DO1)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);
        (RST => DO1)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX4_RX1 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,DI1,DI2,DI3,
    DO0,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 4096;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1,DI2,DI3;
output DO0;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [3:0] di;
wire [0:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ1 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ2 (EMPTY,EMPTY_sig);	 
buf INSXQ3 (AMFULL,AMFULL_node);	 
buf INSXQ4 (AMEMPTY,AMEMPTY_node);	
assign di = {DI3,DI2,DI1,DI0};
//assign {DO0} = do;
buf INSXQ0 (DO0,do);
defparam FIFO_U0.WADDR_WIDTH = 12;
defparam FIFO_U0.WDATA_WIDTH = 4;

defparam FIFO_U0.RADDR_WIDTH = 14;
defparam FIFO_U0.RDATA_WIDTH = 1;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);
	$setuphold  (posedge WCLK, DI2, 1, 0);
	$setuphold  (posedge WCLK, DI3, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX2_RX1 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,DI1,
    DO0,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 8192;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1;
output DO0;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [1:0] di;
wire [0:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ1 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ2 (EMPTY,EMPTY_sig);	 
buf INSXQ3 (AMFULL,AMFULL_node);	 
buf INSXQ4 (AMEMPTY,AMEMPTY_node);	
assign di = {DI1,DI0};
//assign {DO0} = do;
buf INSXQ0 (DO0,do);
defparam FIFO_U0.WADDR_WIDTH = 13;
defparam FIFO_U0.WDATA_WIDTH = 2;

defparam FIFO_U0.RADDR_WIDTH = 14;
defparam FIFO_U0.RDATA_WIDTH = 1;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX16_RX32 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15,
    DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15,DO16,DO17,DO18,DO19,DO20,DO21,DO22,DO23,DO24,DO25,DO26,DO27,DO28,DO29,DO30,DO31,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 1024;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,DI8,DI9,DI10,DI11,DI12,DI13,DI14,DI15;
output DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15,DO16,DO17,DO18,DO19,DO20,DO21,DO22,DO23,DO24,DO25,DO26,DO27,DO28,DO29,DO30,DO31;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [15:0] di;
wire [31:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ32 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ33 (EMPTY,EMPTY_sig);	 
buf INSXQ34 (AMFULL,AMFULL_node);	 
buf INSXQ35 (AMEMPTY,AMEMPTY_node);
assign di = {DI15,DI14,DI13,DI12,DI11,DI10,DI9,DI8,DI7,DI6,DI5,DI4,DI3,DI2,DI1,DI0};
//assign {DO31,DO30,DO29,DO28,DO27,DO26,DO25,DO24,DO23,DO22,DO21,DO20,DO19,DO18,DO17,DO16,DO15,DO14,DO13,DO12,DO11,DO10,DO9,DO8,DO7,DO6,DO5,DO4,DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
buf INSXQ4 (DO4,do[4]);
buf INSXQ5 (DO5,do[5]);
buf INSXQ6 (DO6,do[6]);
buf INSXQ7 (DO7,do[7]);
buf INSXQ8 (DO8,do[8]);
buf INSXQ9 (DO9,do[9]);

buf INSXQ10 (DO10,do[10]);
buf INSXQ11 (DO11,do[11]);
buf INSXQ12 (DO12,do[12]);
buf INSXQ13 (DO13,do[13]);
buf INSXQ14 (DO14,do[14]);
buf INSXQ15 (DO15,do[15]);
buf INSXQ16 (DO16,do[16]);
buf INSXQ17 (DO17,do[17]);
buf INSXQ18 (DO18,do[18]);
buf INSXQ19 (DO19,do[19]);

buf INSXQ20 (DO20,do[20]);
buf INSXQ21 (DO21,do[21]);
buf INSXQ22 (DO22,do[22]);
buf INSXQ23 (DO23,do[23]);
buf INSXQ24 (DO24,do[24]);
buf INSXQ25 (DO25,do[25]);
buf INSXQ26 (DO26,do[26]);
buf INSXQ27 (DO27,do[27]);
buf INSXQ28 (DO28,do[28]);
buf INSXQ29 (DO29,do[29]);

buf INSXQ30 (DO30,do[30]);
buf INSXQ31 (DO31,do[31]);

defparam FIFO_U0.WADDR_WIDTH = 10;
defparam FIFO_U0.WDATA_WIDTH = 16;

defparam FIFO_U0.RADDR_WIDTH = 9;
defparam FIFO_U0.RDATA_WIDTH = 32;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);
	$setuphold  (posedge WCLK, DI2, 1, 0);
	$setuphold  (posedge WCLK, DI3, 1, 0);
	$setuphold  (posedge WCLK, DI4, 1, 0);
	$setuphold  (posedge WCLK, DI5, 1, 0);
	$setuphold  (posedge WCLK, DI6, 1, 0);
	$setuphold  (posedge WCLK, DI7, 1, 0);
	$setuphold  (posedge WCLK, DI8, 1, 0);
	$setuphold  (posedge WCLK, DI9, 1, 0);
	$setuphold  (posedge WCLK, DI10, 1, 0);
	$setuphold  (posedge WCLK, DI11, 1, 0);
	$setuphold  (posedge WCLK, DI12, 1, 0);
	$setuphold  (posedge WCLK, DI13, 1, 0);
	$setuphold  (posedge WCLK, DI14, 1, 0);
	$setuphold  (posedge WCLK, DI15, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);
        (RCLK => DO1)    = (0:0:0, 0:0:0);
        (RCLK => DO2)    = (0:0:0, 0:0:0);
        (RCLK => DO3)    = (0:0:0, 0:0:0);
        (RCLK => DO4)    = (0:0:0, 0:0:0);
        (RCLK => DO5)    = (0:0:0, 0:0:0);
        (RCLK => DO6)    = (0:0:0, 0:0:0);
        (RCLK => DO7)    = (0:0:0, 0:0:0);
        (RCLK => DO8)    = (0:0:0, 0:0:0);
        (RCLK => DO9)    = (0:0:0, 0:0:0);
        (RCLK => DO10)    = (0:0:0, 0:0:0);
        (RCLK => DO11)    = (0:0:0, 0:0:0);
        (RCLK => DO12)    = (0:0:0, 0:0:0);
        (RCLK => DO13)    = (0:0:0, 0:0:0);
        (RCLK => DO14)    = (0:0:0, 0:0:0);
        (RCLK => DO15)    = (0:0:0, 0:0:0);
        (RCLK => DO16)    = (0:0:0, 0:0:0);
        (RCLK => DO17)    = (0:0:0, 0:0:0);
        (RCLK => DO18)    = (0:0:0, 0:0:0);
        (RCLK => DO19)    = (0:0:0, 0:0:0);
        (RCLK => DO20)    = (0:0:0, 0:0:0);
        (RCLK => DO21)    = (0:0:0, 0:0:0);
        (RCLK => DO22)    = (0:0:0, 0:0:0);
        (RCLK => DO23)    = (0:0:0, 0:0:0);
        (RCLK => DO24)    = (0:0:0, 0:0:0);
        (RCLK => DO25)    = (0:0:0, 0:0:0);
        (RCLK => DO26)    = (0:0:0, 0:0:0);
        (RCLK => DO27)    = (0:0:0, 0:0:0);
        (RCLK => DO28)    = (0:0:0, 0:0:0);
        (RCLK => DO29)    = (0:0:0, 0:0:0);
        (RCLK => DO30)    = (0:0:0, 0:0:0);
        (RCLK => DO31)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);
        (RST => DO1)    = (0:0:0, 0:0:0);
        (RST => DO2)    = (0:0:0, 0:0:0);
        (RST => DO3)    = (0:0:0, 0:0:0);
        (RST => DO4)    = (0:0:0, 0:0:0);
        (RST => DO5)    = (0:0:0, 0:0:0);
        (RST => DO6)    = (0:0:0, 0:0:0);
        (RST => DO7)    = (0:0:0, 0:0:0);
        (RST => DO8)    = (0:0:0, 0:0:0);
        (RST => DO9)    = (0:0:0, 0:0:0);
        (RST => DO10)    = (0:0:0, 0:0:0);
        (RST => DO11)    = (0:0:0, 0:0:0);
        (RST => DO12)    = (0:0:0, 0:0:0);
        (RST => DO13)    = (0:0:0, 0:0:0);
        (RST => DO14)    = (0:0:0, 0:0:0);
        (RST => DO15)    = (0:0:0, 0:0:0);
        (RST => DO16)    = (0:0:0, 0:0:0);
        (RST => DO17)    = (0:0:0, 0:0:0);
        (RST => DO18)    = (0:0:0, 0:0:0);
        (RST => DO19)    = (0:0:0, 0:0:0);
        (RST => DO20)    = (0:0:0, 0:0:0);
        (RST => DO21)    = (0:0:0, 0:0:0);
        (RST => DO22)    = (0:0:0, 0:0:0);
        (RST => DO23)    = (0:0:0, 0:0:0);
        (RST => DO24)    = (0:0:0, 0:0:0);
        (RST => DO25)    = (0:0:0, 0:0:0);
        (RST => DO26)    = (0:0:0, 0:0:0);
        (RST => DO27)    = (0:0:0, 0:0:0);
        (RST => DO28)    = (0:0:0, 0:0:0);
        (RST => DO29)    = (0:0:0, 0:0:0);
        (RST => DO30)    = (0:0:0, 0:0:0);
        (RST => DO31)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX8_RX32 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,
    DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15,DO16,DO17,DO18,DO19,DO20,DO21,DO22,DO23,DO24,DO25,DO26,DO27,DO28,DO29,DO30,DO31,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 2048;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7;
output DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15,DO16,DO17,DO18,DO19,DO20,DO21,DO22,DO23,DO24,DO25,DO26,DO27,DO28,DO29,DO30,DO31;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [7:0] di;
wire [31:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ32 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ33 (EMPTY,EMPTY_sig);	 
buf INSXQ34 (AMFULL,AMFULL_node);	 
buf INSXQ35 (AMEMPTY,AMEMPTY_node);
assign di = {DI7,DI6,DI5,DI4,DI3,DI2,DI1,DI0};
//assign {DO31,DO30,DO29,DO28,DO27,DO26,DO25,DO24,DO23,DO22,DO21,DO20,DO19,DO18,DO17,DO16,DO15,DO14,DO13,DO12,DO11,DO10,DO9,DO8,DO7,DO6,DO5,DO4,DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
buf INSXQ4 (DO4,do[4]);
buf INSXQ5 (DO5,do[5]);
buf INSXQ6 (DO6,do[6]);
buf INSXQ7 (DO7,do[7]);
buf INSXQ8 (DO8,do[8]);
buf INSXQ9 (DO9,do[9]);

buf INSXQ10 (DO10,do[10]);
buf INSXQ11 (DO11,do[11]);
buf INSXQ12 (DO12,do[12]);
buf INSXQ13 (DO13,do[13]);
buf INSXQ14 (DO14,do[14]);
buf INSXQ15 (DO15,do[15]);
buf INSXQ16 (DO16,do[16]);
buf INSXQ17 (DO17,do[17]);
buf INSXQ18 (DO18,do[18]);
buf INSXQ19 (DO19,do[19]);

buf INSXQ20 (DO20,do[20]);
buf INSXQ21 (DO21,do[21]);
buf INSXQ22 (DO22,do[22]);
buf INSXQ23 (DO23,do[23]);
buf INSXQ24 (DO24,do[24]);
buf INSXQ25 (DO25,do[25]);
buf INSXQ26 (DO26,do[26]);
buf INSXQ27 (DO27,do[27]);
buf INSXQ28 (DO28,do[28]);
buf INSXQ29 (DO29,do[29]);

buf INSXQ30 (DO30,do[30]);
buf INSXQ31 (DO31,do[31]);

defparam FIFO_U0.WADDR_WIDTH = 11;
defparam FIFO_U0.WDATA_WIDTH = 8;

defparam FIFO_U0.RADDR_WIDTH = 9;
defparam FIFO_U0.RDATA_WIDTH = 32;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);
	$setuphold  (posedge WCLK, DI2, 1, 0);
	$setuphold  (posedge WCLK, DI3, 1, 0);
	$setuphold  (posedge WCLK, DI4, 1, 0);
	$setuphold  (posedge WCLK, DI5, 1, 0);
	$setuphold  (posedge WCLK, DI6, 1, 0);
	$setuphold  (posedge WCLK, DI7, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);
        (RCLK => DO1)    = (0:0:0, 0:0:0);
        (RCLK => DO2)    = (0:0:0, 0:0:0);
        (RCLK => DO3)    = (0:0:0, 0:0:0);
        (RCLK => DO4)    = (0:0:0, 0:0:0);
        (RCLK => DO5)    = (0:0:0, 0:0:0);
        (RCLK => DO6)    = (0:0:0, 0:0:0);
        (RCLK => DO7)    = (0:0:0, 0:0:0);
        (RCLK => DO8)    = (0:0:0, 0:0:0);
        (RCLK => DO9)    = (0:0:0, 0:0:0);
        (RCLK => DO10)    = (0:0:0, 0:0:0);
        (RCLK => DO11)    = (0:0:0, 0:0:0);
        (RCLK => DO12)    = (0:0:0, 0:0:0);
        (RCLK => DO13)    = (0:0:0, 0:0:0);
        (RCLK => DO14)    = (0:0:0, 0:0:0);
        (RCLK => DO15)    = (0:0:0, 0:0:0);
        (RCLK => DO16)    = (0:0:0, 0:0:0);
        (RCLK => DO17)    = (0:0:0, 0:0:0);
        (RCLK => DO18)    = (0:0:0, 0:0:0);
        (RCLK => DO19)    = (0:0:0, 0:0:0);
        (RCLK => DO20)    = (0:0:0, 0:0:0);
        (RCLK => DO21)    = (0:0:0, 0:0:0);
        (RCLK => DO22)    = (0:0:0, 0:0:0);
        (RCLK => DO23)    = (0:0:0, 0:0:0);
        (RCLK => DO24)    = (0:0:0, 0:0:0);
        (RCLK => DO25)    = (0:0:0, 0:0:0);
        (RCLK => DO26)    = (0:0:0, 0:0:0);
        (RCLK => DO27)    = (0:0:0, 0:0:0);
        (RCLK => DO28)    = (0:0:0, 0:0:0);
        (RCLK => DO29)    = (0:0:0, 0:0:0);
        (RCLK => DO30)    = (0:0:0, 0:0:0);
        (RCLK => DO31)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);
        (RST => DO1)    = (0:0:0, 0:0:0);
        (RST => DO2)    = (0:0:0, 0:0:0);
        (RST => DO3)    = (0:0:0, 0:0:0);
        (RST => DO4)    = (0:0:0, 0:0:0);
        (RST => DO5)    = (0:0:0, 0:0:0);
        (RST => DO6)    = (0:0:0, 0:0:0);
        (RST => DO7)    = (0:0:0, 0:0:0);
        (RST => DO8)    = (0:0:0, 0:0:0);
        (RST => DO9)    = (0:0:0, 0:0:0);
        (RST => DO10)    = (0:0:0, 0:0:0);
        (RST => DO11)    = (0:0:0, 0:0:0);
        (RST => DO12)    = (0:0:0, 0:0:0);
        (RST => DO13)    = (0:0:0, 0:0:0);
        (RST => DO14)    = (0:0:0, 0:0:0);
        (RST => DO15)    = (0:0:0, 0:0:0);
        (RST => DO16)    = (0:0:0, 0:0:0);
        (RST => DO17)    = (0:0:0, 0:0:0);
        (RST => DO18)    = (0:0:0, 0:0:0);
        (RST => DO19)    = (0:0:0, 0:0:0);
        (RST => DO20)    = (0:0:0, 0:0:0);
        (RST => DO21)    = (0:0:0, 0:0:0);
        (RST => DO22)    = (0:0:0, 0:0:0);
        (RST => DO23)    = (0:0:0, 0:0:0);
        (RST => DO24)    = (0:0:0, 0:0:0);
        (RST => DO25)    = (0:0:0, 0:0:0);
        (RST => DO26)    = (0:0:0, 0:0:0);
        (RST => DO27)    = (0:0:0, 0:0:0);
        (RST => DO28)    = (0:0:0, 0:0:0);
        (RST => DO29)    = (0:0:0, 0:0:0);
        (RST => DO30)    = (0:0:0, 0:0:0);
        (RST => DO31)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX4_RX32 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,DI1,DI2,DI3,
    DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15,DO16,DO17,DO18,DO19,DO20,DO21,DO22,DO23,DO24,DO25,DO26,DO27,DO28,DO29,DO30,DO31,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 4096;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1,DI2,DI3;
output DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15,DO16,DO17,DO18,DO19,DO20,DO21,DO22,DO23,DO24,DO25,DO26,DO27,DO28,DO29,DO30,DO31;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [3:0] di;
wire [31:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ32 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ33 (EMPTY,EMPTY_sig);	 
buf INSXQ34 (AMFULL,AMFULL_node);	 
buf INSXQ35 (AMEMPTY,AMEMPTY_node);
assign di = {DI3,DI2,DI1,DI0};
//assign {DO31,DO30,DO29,DO28,DO27,DO26,DO25,DO24,DO23,DO22,DO21,DO20,DO19,DO18,DO17,DO16,DO15,DO14,DO13,DO12,DO11,DO10,DO9,DO8,DO7,DO6,DO5,DO4,DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
buf INSXQ4 (DO4,do[4]);
buf INSXQ5 (DO5,do[5]);
buf INSXQ6 (DO6,do[6]);
buf INSXQ7 (DO7,do[7]);
buf INSXQ8 (DO8,do[8]);
buf INSXQ9 (DO9,do[9]);

buf INSXQ10 (DO10,do[10]);
buf INSXQ11 (DO11,do[11]);
buf INSXQ12 (DO12,do[12]);
buf INSXQ13 (DO13,do[13]);
buf INSXQ14 (DO14,do[14]);
buf INSXQ15 (DO15,do[15]);
buf INSXQ16 (DO16,do[16]);
buf INSXQ17 (DO17,do[17]);
buf INSXQ18 (DO18,do[18]);
buf INSXQ19 (DO19,do[19]);

buf INSXQ20 (DO20,do[20]);
buf INSXQ21 (DO21,do[21]);
buf INSXQ22 (DO22,do[22]);
buf INSXQ23 (DO23,do[23]);
buf INSXQ24 (DO24,do[24]);
buf INSXQ25 (DO25,do[25]);
buf INSXQ26 (DO26,do[26]);
buf INSXQ27 (DO27,do[27]);
buf INSXQ28 (DO28,do[28]);
buf INSXQ29 (DO29,do[29]);

buf INSXQ30 (DO30,do[30]);
buf INSXQ31 (DO31,do[31]);

defparam FIFO_U0.WADDR_WIDTH = 12;
defparam FIFO_U0.WDATA_WIDTH = 4;

defparam FIFO_U0.RADDR_WIDTH = 9;
defparam FIFO_U0.RDATA_WIDTH = 32;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);
	$setuphold  (posedge WCLK, DI2, 1, 0);
	$setuphold  (posedge WCLK, DI3, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);
        (RCLK => DO1)    = (0:0:0, 0:0:0);
        (RCLK => DO2)    = (0:0:0, 0:0:0);
        (RCLK => DO3)    = (0:0:0, 0:0:0);
        (RCLK => DO4)    = (0:0:0, 0:0:0);
        (RCLK => DO5)    = (0:0:0, 0:0:0);
        (RCLK => DO6)    = (0:0:0, 0:0:0);
        (RCLK => DO7)    = (0:0:0, 0:0:0);
        (RCLK => DO8)    = (0:0:0, 0:0:0);
        (RCLK => DO9)    = (0:0:0, 0:0:0);
        (RCLK => DO10)    = (0:0:0, 0:0:0);
        (RCLK => DO11)    = (0:0:0, 0:0:0);
        (RCLK => DO12)    = (0:0:0, 0:0:0);
        (RCLK => DO13)    = (0:0:0, 0:0:0);
        (RCLK => DO14)    = (0:0:0, 0:0:0);
        (RCLK => DO15)    = (0:0:0, 0:0:0);
        (RCLK => DO16)    = (0:0:0, 0:0:0);
        (RCLK => DO17)    = (0:0:0, 0:0:0);
        (RCLK => DO18)    = (0:0:0, 0:0:0);
        (RCLK => DO19)    = (0:0:0, 0:0:0);
        (RCLK => DO20)    = (0:0:0, 0:0:0);
        (RCLK => DO21)    = (0:0:0, 0:0:0);
        (RCLK => DO22)    = (0:0:0, 0:0:0);
        (RCLK => DO23)    = (0:0:0, 0:0:0);
        (RCLK => DO24)    = (0:0:0, 0:0:0);
        (RCLK => DO25)    = (0:0:0, 0:0:0);
        (RCLK => DO26)    = (0:0:0, 0:0:0);
        (RCLK => DO27)    = (0:0:0, 0:0:0);
        (RCLK => DO28)    = (0:0:0, 0:0:0);
        (RCLK => DO29)    = (0:0:0, 0:0:0);
        (RCLK => DO30)    = (0:0:0, 0:0:0);
        (RCLK => DO31)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);
        (RST => DO1)    = (0:0:0, 0:0:0);
        (RST => DO2)    = (0:0:0, 0:0:0);
        (RST => DO3)    = (0:0:0, 0:0:0);
        (RST => DO4)    = (0:0:0, 0:0:0);
        (RST => DO5)    = (0:0:0, 0:0:0);
        (RST => DO6)    = (0:0:0, 0:0:0);
        (RST => DO7)    = (0:0:0, 0:0:0);
        (RST => DO8)    = (0:0:0, 0:0:0);
        (RST => DO9)    = (0:0:0, 0:0:0);
        (RST => DO10)    = (0:0:0, 0:0:0);
        (RST => DO11)    = (0:0:0, 0:0:0);
        (RST => DO12)    = (0:0:0, 0:0:0);
        (RST => DO13)    = (0:0:0, 0:0:0);
        (RST => DO14)    = (0:0:0, 0:0:0);
        (RST => DO15)    = (0:0:0, 0:0:0);
        (RST => DO16)    = (0:0:0, 0:0:0);
        (RST => DO17)    = (0:0:0, 0:0:0);
        (RST => DO18)    = (0:0:0, 0:0:0);
        (RST => DO19)    = (0:0:0, 0:0:0);
        (RST => DO20)    = (0:0:0, 0:0:0);
        (RST => DO21)    = (0:0:0, 0:0:0);
        (RST => DO22)    = (0:0:0, 0:0:0);
        (RST => DO23)    = (0:0:0, 0:0:0);
        (RST => DO24)    = (0:0:0, 0:0:0);
        (RST => DO25)    = (0:0:0, 0:0:0);
        (RST => DO26)    = (0:0:0, 0:0:0);
        (RST => DO27)    = (0:0:0, 0:0:0);
        (RST => DO28)    = (0:0:0, 0:0:0);
        (RST => DO29)    = (0:0:0, 0:0:0);
        (RST => DO30)    = (0:0:0, 0:0:0);
        (RST => DO31)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX2_RX32 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,DI1,
    DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15,DO16,DO17,DO18,DO19,DO20,DO21,DO22,DO23,DO24,DO25,DO26,DO27,DO28,DO29,DO30,DO31,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 8192;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1;
output DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15,DO16,DO17,DO18,DO19,DO20,DO21,DO22,DO23,DO24,DO25,DO26,DO27,DO28,DO29,DO30,DO31;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [1:0] di;
wire [31:0] do;
wire FULL_sig, EMPTY_sig;	
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ32 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ33 (EMPTY,EMPTY_sig);	 
buf INSXQ34 (AMFULL,AMFULL_node);	 
buf INSXQ35 (AMEMPTY,AMEMPTY_node);
assign di = {DI1,DI0};
//assign {DO31,DO30,DO29,DO28,DO27,DO26,DO25,DO24,DO23,DO22,DO21,DO20,DO19,DO18,DO17,DO16,DO15,DO14,DO13,DO12,DO11,DO10,DO9,DO8,DO7,DO6,DO5,DO4,DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
buf INSXQ4 (DO4,do[4]);
buf INSXQ5 (DO5,do[5]);
buf INSXQ6 (DO6,do[6]);
buf INSXQ7 (DO7,do[7]);
buf INSXQ8 (DO8,do[8]);
buf INSXQ9 (DO9,do[9]);

buf INSXQ10 (DO10,do[10]);
buf INSXQ11 (DO11,do[11]);
buf INSXQ12 (DO12,do[12]);
buf INSXQ13 (DO13,do[13]);
buf INSXQ14 (DO14,do[14]);
buf INSXQ15 (DO15,do[15]);
buf INSXQ16 (DO16,do[16]);
buf INSXQ17 (DO17,do[17]);
buf INSXQ18 (DO18,do[18]);
buf INSXQ19 (DO19,do[19]);

buf INSXQ20 (DO20,do[20]);
buf INSXQ21 (DO21,do[21]);
buf INSXQ22 (DO22,do[22]);
buf INSXQ23 (DO23,do[23]);
buf INSXQ24 (DO24,do[24]);
buf INSXQ25 (DO25,do[25]);
buf INSXQ26 (DO26,do[26]);
buf INSXQ27 (DO27,do[27]);
buf INSXQ28 (DO28,do[28]);
buf INSXQ29 (DO29,do[29]);

buf INSXQ30 (DO30,do[30]);
buf INSXQ31 (DO31,do[31]);

defparam FIFO_U0.WADDR_WIDTH = 13;
defparam FIFO_U0.WDATA_WIDTH = 2;

defparam FIFO_U0.RADDR_WIDTH = 9;
defparam FIFO_U0.RDATA_WIDTH = 32;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);
        (RCLK => DO1)    = (0:0:0, 0:0:0);
        (RCLK => DO2)    = (0:0:0, 0:0:0);
        (RCLK => DO3)    = (0:0:0, 0:0:0);
        (RCLK => DO4)    = (0:0:0, 0:0:0);
        (RCLK => DO5)    = (0:0:0, 0:0:0);
        (RCLK => DO6)    = (0:0:0, 0:0:0);
        (RCLK => DO7)    = (0:0:0, 0:0:0);
        (RCLK => DO8)    = (0:0:0, 0:0:0);
        (RCLK => DO9)    = (0:0:0, 0:0:0);
        (RCLK => DO10)    = (0:0:0, 0:0:0);
        (RCLK => DO11)    = (0:0:0, 0:0:0);
        (RCLK => DO12)    = (0:0:0, 0:0:0);
        (RCLK => DO13)    = (0:0:0, 0:0:0);
        (RCLK => DO14)    = (0:0:0, 0:0:0);
        (RCLK => DO15)    = (0:0:0, 0:0:0);
        (RCLK => DO16)    = (0:0:0, 0:0:0);
        (RCLK => DO17)    = (0:0:0, 0:0:0);
        (RCLK => DO18)    = (0:0:0, 0:0:0);
        (RCLK => DO19)    = (0:0:0, 0:0:0);
        (RCLK => DO20)    = (0:0:0, 0:0:0);
        (RCLK => DO21)    = (0:0:0, 0:0:0);
        (RCLK => DO22)    = (0:0:0, 0:0:0);
        (RCLK => DO23)    = (0:0:0, 0:0:0);
        (RCLK => DO24)    = (0:0:0, 0:0:0);
        (RCLK => DO25)    = (0:0:0, 0:0:0);
        (RCLK => DO26)    = (0:0:0, 0:0:0);
        (RCLK => DO27)    = (0:0:0, 0:0:0);
        (RCLK => DO28)    = (0:0:0, 0:0:0);
        (RCLK => DO29)    = (0:0:0, 0:0:0);
        (RCLK => DO30)    = (0:0:0, 0:0:0);
        (RCLK => DO31)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);
        (RST => DO1)    = (0:0:0, 0:0:0);
        (RST => DO2)    = (0:0:0, 0:0:0);
        (RST => DO3)    = (0:0:0, 0:0:0);
        (RST => DO4)    = (0:0:0, 0:0:0);
        (RST => DO5)    = (0:0:0, 0:0:0);
        (RST => DO6)    = (0:0:0, 0:0:0);
        (RST => DO7)    = (0:0:0, 0:0:0);
        (RST => DO8)    = (0:0:0, 0:0:0);
        (RST => DO9)    = (0:0:0, 0:0:0);
        (RST => DO10)    = (0:0:0, 0:0:0);
        (RST => DO11)    = (0:0:0, 0:0:0);
        (RST => DO12)    = (0:0:0, 0:0:0);
        (RST => DO13)    = (0:0:0, 0:0:0);
        (RST => DO14)    = (0:0:0, 0:0:0);
        (RST => DO15)    = (0:0:0, 0:0:0);
        (RST => DO16)    = (0:0:0, 0:0:0);
        (RST => DO17)    = (0:0:0, 0:0:0);
        (RST => DO18)    = (0:0:0, 0:0:0);
        (RST => DO19)    = (0:0:0, 0:0:0);
        (RST => DO20)    = (0:0:0, 0:0:0);
        (RST => DO21)    = (0:0:0, 0:0:0);
        (RST => DO22)    = (0:0:0, 0:0:0);
        (RST => DO23)    = (0:0:0, 0:0:0);
        (RST => DO24)    = (0:0:0, 0:0:0);
        (RST => DO25)    = (0:0:0, 0:0:0);
        (RST => DO26)    = (0:0:0, 0:0:0);
        (RST => DO27)    = (0:0:0, 0:0:0);
        (RST => DO28)    = (0:0:0, 0:0:0);
        (RST => DO29)    = (0:0:0, 0:0:0);
        (RST => DO30)    = (0:0:0, 0:0:0);
        (RST => DO31)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX1_RX32 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,
    DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15,DO16,DO17,DO18,DO19,DO20,DO21,DO22,DO23,DO24,DO25,DO26,DO27,DO28,DO29,DO30,DO31,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 16384;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0;
output DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15,DO16,DO17,DO18,DO19,DO20,DO21,DO22,DO23,DO24,DO25,DO26,DO27,DO28,DO29,DO30,DO31;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [0:0] di;
wire [31:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ32 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ33 (EMPTY,EMPTY_sig);	 
buf INSXQ34 (AMFULL,AMFULL_node);	 
buf INSXQ35 (AMEMPTY,AMEMPTY_node);
assign di = {DI0};
//assign {DO31,DO30,DO29,DO28,DO27,DO26,DO25,DO24,DO23,DO22,DO21,DO20,DO19,DO18,DO17,DO16,DO15,DO14,DO13,DO12,DO11,DO10,DO9,DO8,DO7,DO6,DO5,DO4,DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
buf INSXQ4 (DO4,do[4]);
buf INSXQ5 (DO5,do[5]);
buf INSXQ6 (DO6,do[6]);
buf INSXQ7 (DO7,do[7]);
buf INSXQ8 (DO8,do[8]);
buf INSXQ9 (DO9,do[9]);

buf INSXQ10 (DO10,do[10]);
buf INSXQ11 (DO11,do[11]);
buf INSXQ12 (DO12,do[12]);
buf INSXQ13 (DO13,do[13]);
buf INSXQ14 (DO14,do[14]);
buf INSXQ15 (DO15,do[15]);
buf INSXQ16 (DO16,do[16]);
buf INSXQ17 (DO17,do[17]);
buf INSXQ18 (DO18,do[18]);
buf INSXQ19 (DO19,do[19]);

buf INSXQ20 (DO20,do[20]);
buf INSXQ21 (DO21,do[21]);
buf INSXQ22 (DO22,do[22]);
buf INSXQ23 (DO23,do[23]);
buf INSXQ24 (DO24,do[24]);
buf INSXQ25 (DO25,do[25]);
buf INSXQ26 (DO26,do[26]);
buf INSXQ27 (DO27,do[27]);
buf INSXQ28 (DO28,do[28]);
buf INSXQ29 (DO29,do[29]);

buf INSXQ30 (DO30,do[30]);
buf INSXQ31 (DO31,do[31]);

defparam FIFO_U0.WADDR_WIDTH = 14;
defparam FIFO_U0.WDATA_WIDTH = 1;

defparam FIFO_U0.RADDR_WIDTH = 9;
defparam FIFO_U0.RDATA_WIDTH = 32;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);
        (RCLK => DO1)    = (0:0:0, 0:0:0);
        (RCLK => DO2)    = (0:0:0, 0:0:0);
        (RCLK => DO3)    = (0:0:0, 0:0:0);
        (RCLK => DO4)    = (0:0:0, 0:0:0);
        (RCLK => DO5)    = (0:0:0, 0:0:0);
        (RCLK => DO6)    = (0:0:0, 0:0:0);
        (RCLK => DO7)    = (0:0:0, 0:0:0);
        (RCLK => DO8)    = (0:0:0, 0:0:0);
        (RCLK => DO9)    = (0:0:0, 0:0:0);
        (RCLK => DO10)    = (0:0:0, 0:0:0);
        (RCLK => DO11)    = (0:0:0, 0:0:0);
        (RCLK => DO12)    = (0:0:0, 0:0:0);
        (RCLK => DO13)    = (0:0:0, 0:0:0);
        (RCLK => DO14)    = (0:0:0, 0:0:0);
        (RCLK => DO15)    = (0:0:0, 0:0:0);
        (RCLK => DO16)    = (0:0:0, 0:0:0);
        (RCLK => DO17)    = (0:0:0, 0:0:0);
        (RCLK => DO18)    = (0:0:0, 0:0:0);
        (RCLK => DO19)    = (0:0:0, 0:0:0);
        (RCLK => DO20)    = (0:0:0, 0:0:0);
        (RCLK => DO21)    = (0:0:0, 0:0:0);
        (RCLK => DO22)    = (0:0:0, 0:0:0);
        (RCLK => DO23)    = (0:0:0, 0:0:0);
        (RCLK => DO24)    = (0:0:0, 0:0:0);
        (RCLK => DO25)    = (0:0:0, 0:0:0);
        (RCLK => DO26)    = (0:0:0, 0:0:0);
        (RCLK => DO27)    = (0:0:0, 0:0:0);
        (RCLK => DO28)    = (0:0:0, 0:0:0);
        (RCLK => DO29)    = (0:0:0, 0:0:0);
        (RCLK => DO30)    = (0:0:0, 0:0:0);
        (RCLK => DO31)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);
        (RST => DO1)    = (0:0:0, 0:0:0);
        (RST => DO2)    = (0:0:0, 0:0:0);
        (RST => DO3)    = (0:0:0, 0:0:0);
        (RST => DO4)    = (0:0:0, 0:0:0);
        (RST => DO5)    = (0:0:0, 0:0:0);
        (RST => DO6)    = (0:0:0, 0:0:0);
        (RST => DO7)    = (0:0:0, 0:0:0);
        (RST => DO8)    = (0:0:0, 0:0:0);
        (RST => DO9)    = (0:0:0, 0:0:0);
        (RST => DO10)    = (0:0:0, 0:0:0);
        (RST => DO11)    = (0:0:0, 0:0:0);
        (RST => DO12)    = (0:0:0, 0:0:0);
        (RST => DO13)    = (0:0:0, 0:0:0);
        (RST => DO14)    = (0:0:0, 0:0:0);
        (RST => DO15)    = (0:0:0, 0:0:0);
        (RST => DO16)    = (0:0:0, 0:0:0);
        (RST => DO17)    = (0:0:0, 0:0:0);
        (RST => DO18)    = (0:0:0, 0:0:0);
        (RST => DO19)    = (0:0:0, 0:0:0);
        (RST => DO20)    = (0:0:0, 0:0:0);
        (RST => DO21)    = (0:0:0, 0:0:0);
        (RST => DO22)    = (0:0:0, 0:0:0);
        (RST => DO23)    = (0:0:0, 0:0:0);
        (RST => DO24)    = (0:0:0, 0:0:0);
        (RST => DO25)    = (0:0:0, 0:0:0);
        (RST => DO26)    = (0:0:0, 0:0:0);
        (RST => DO27)    = (0:0:0, 0:0:0);
        (RST => DO28)    = (0:0:0, 0:0:0);
        (RST => DO29)    = (0:0:0, 0:0:0);
        (RST => DO30)    = (0:0:0, 0:0:0);
        (RST => DO31)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX8_RX16 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7,
    DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 2048;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1,DI2,DI3,DI4,DI5,DI6,DI7;
output DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [7:0] di;
wire [15:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ16 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ17 (EMPTY,EMPTY_sig);	 
buf INSXQ18 (AMFULL,AMFULL_node);	 
buf INSXQ19 (AMEMPTY,AMEMPTY_node);
assign di = {DI7,DI6,DI5,DI4,DI3,DI2,DI1,DI0};
//assign {DO15,DO14,DO13,DO12,DO11,DO10,DO9,DO8,DO7,DO6,DO5,DO4,DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
buf INSXQ4 (DO4,do[4]);
buf INSXQ5 (DO5,do[5]);
buf INSXQ6 (DO6,do[6]);
buf INSXQ7 (DO7,do[7]);
buf INSXQ8 (DO8,do[8]);
buf INSXQ9 (DO9,do[9]);

buf INSXQ10 (DO10,do[10]);
buf INSXQ11 (DO11,do[11]);
buf INSXQ12 (DO12,do[12]);
buf INSXQ13 (DO13,do[13]);
buf INSXQ14 (DO14,do[14]);
buf INSXQ15 (DO15,do[15]);
defparam FIFO_U0.WADDR_WIDTH = 11;
defparam FIFO_U0.WDATA_WIDTH = 8;

defparam FIFO_U0.RADDR_WIDTH = 10;
defparam FIFO_U0.RDATA_WIDTH = 16;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);
	$setuphold  (posedge WCLK, DI2, 1, 0);
	$setuphold  (posedge WCLK, DI3, 1, 0);
	$setuphold  (posedge WCLK, DI4, 1, 0);
	$setuphold  (posedge WCLK, DI5, 1, 0);
	$setuphold  (posedge WCLK, DI6, 1, 0);
	$setuphold  (posedge WCLK, DI7, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);
        (RCLK => DO1)    = (0:0:0, 0:0:0);
        (RCLK => DO2)    = (0:0:0, 0:0:0);
        (RCLK => DO3)    = (0:0:0, 0:0:0);
        (RCLK => DO4)    = (0:0:0, 0:0:0);
        (RCLK => DO5)    = (0:0:0, 0:0:0);
        (RCLK => DO6)    = (0:0:0, 0:0:0);
        (RCLK => DO7)    = (0:0:0, 0:0:0);
        (RCLK => DO8)    = (0:0:0, 0:0:0);
        (RCLK => DO9)    = (0:0:0, 0:0:0);
        (RCLK => DO10)    = (0:0:0, 0:0:0);
        (RCLK => DO11)    = (0:0:0, 0:0:0);
        (RCLK => DO12)    = (0:0:0, 0:0:0);
        (RCLK => DO13)    = (0:0:0, 0:0:0);
        (RCLK => DO14)    = (0:0:0, 0:0:0);
        (RCLK => DO15)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);
        (RST => DO1)    = (0:0:0, 0:0:0);
        (RST => DO2)    = (0:0:0, 0:0:0);
        (RST => DO3)    = (0:0:0, 0:0:0);
        (RST => DO4)    = (0:0:0, 0:0:0);
        (RST => DO5)    = (0:0:0, 0:0:0);
        (RST => DO6)    = (0:0:0, 0:0:0);
        (RST => DO7)    = (0:0:0, 0:0:0);
        (RST => DO8)    = (0:0:0, 0:0:0);
        (RST => DO9)    = (0:0:0, 0:0:0);
        (RST => DO10)    = (0:0:0, 0:0:0);
        (RST => DO11)    = (0:0:0, 0:0:0);
        (RST => DO12)    = (0:0:0, 0:0:0);
        (RST => DO13)    = (0:0:0, 0:0:0);
        (RST => DO14)    = (0:0:0, 0:0:0);
        (RST => DO15)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX4_RX16 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,DI1,DI2,DI3,
    DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 4096;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1,DI2,DI3;
output DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [3:0] di;
wire [15:0] do;
wire FULL_sig, EMPTY_sig; 
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ16 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ17 (EMPTY,EMPTY_sig);	 
buf INSXQ18 (AMFULL,AMFULL_node);	 
buf INSXQ19 (AMEMPTY,AMEMPTY_node);
assign di = {DI3,DI2,DI1,DI0};
//assign {DO15,DO14,DO13,DO12,DO11,DO10,DO9,DO8,DO7,DO6,DO5,DO4,DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
buf INSXQ4 (DO4,do[4]);
buf INSXQ5 (DO5,do[5]);
buf INSXQ6 (DO6,do[6]);
buf INSXQ7 (DO7,do[7]);
buf INSXQ8 (DO8,do[8]);
buf INSXQ9 (DO9,do[9]);

buf INSXQ10 (DO10,do[10]);
buf INSXQ11 (DO11,do[11]);
buf INSXQ12 (DO12,do[12]);
buf INSXQ13 (DO13,do[13]);
buf INSXQ14 (DO14,do[14]);
buf INSXQ15 (DO15,do[15]);
defparam FIFO_U0.WADDR_WIDTH = 12;
defparam FIFO_U0.WDATA_WIDTH = 4;

defparam FIFO_U0.RADDR_WIDTH = 10;
defparam FIFO_U0.RDATA_WIDTH = 16;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);
	$setuphold  (posedge WCLK, DI2, 1, 0);
	$setuphold  (posedge WCLK, DI3, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);
        (RCLK => DO1)    = (0:0:0, 0:0:0);
        (RCLK => DO2)    = (0:0:0, 0:0:0);
        (RCLK => DO3)    = (0:0:0, 0:0:0);
        (RCLK => DO4)    = (0:0:0, 0:0:0);
        (RCLK => DO5)    = (0:0:0, 0:0:0);
        (RCLK => DO6)    = (0:0:0, 0:0:0);
        (RCLK => DO7)    = (0:0:0, 0:0:0);
        (RCLK => DO8)    = (0:0:0, 0:0:0);
        (RCLK => DO9)    = (0:0:0, 0:0:0);
        (RCLK => DO10)    = (0:0:0, 0:0:0);
        (RCLK => DO11)    = (0:0:0, 0:0:0);
        (RCLK => DO12)    = (0:0:0, 0:0:0);
        (RCLK => DO13)    = (0:0:0, 0:0:0);
        (RCLK => DO14)    = (0:0:0, 0:0:0);
        (RCLK => DO15)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);
        (RST => DO1)    = (0:0:0, 0:0:0);
        (RST => DO2)    = (0:0:0, 0:0:0);
        (RST => DO3)    = (0:0:0, 0:0:0);
        (RST => DO4)    = (0:0:0, 0:0:0);
        (RST => DO5)    = (0:0:0, 0:0:0);
        (RST => DO6)    = (0:0:0, 0:0:0);
        (RST => DO7)    = (0:0:0, 0:0:0);
        (RST => DO8)    = (0:0:0, 0:0:0);
        (RST => DO9)    = (0:0:0, 0:0:0);
        (RST => DO10)    = (0:0:0, 0:0:0);
        (RST => DO11)    = (0:0:0, 0:0:0);
        (RST => DO12)    = (0:0:0, 0:0:0);
        (RST => DO13)    = (0:0:0, 0:0:0);
        (RST => DO14)    = (0:0:0, 0:0:0);
        (RST => DO15)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX2_RX16 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,DI1,
    DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 8192;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1;
output DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [1:0] di;
wire [15:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ16 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ17 (EMPTY,EMPTY_sig);	 
buf INSXQ18 (AMFULL,AMFULL_node);	 
buf INSXQ19 (AMEMPTY,AMEMPTY_node);
assign di = {DI1,DI0};
//assign {DO15,DO14,DO13,DO12,DO11,DO10,DO9,DO8,DO7,DO6,DO5,DO4,DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
buf INSXQ4 (DO4,do[4]);
buf INSXQ5 (DO5,do[5]);
buf INSXQ6 (DO6,do[6]);
buf INSXQ7 (DO7,do[7]);
buf INSXQ8 (DO8,do[8]);
buf INSXQ9 (DO9,do[9]);

buf INSXQ10 (DO10,do[10]);
buf INSXQ11 (DO11,do[11]);
buf INSXQ12 (DO12,do[12]);
buf INSXQ13 (DO13,do[13]);
buf INSXQ14 (DO14,do[14]);
buf INSXQ15 (DO15,do[15]);
defparam FIFO_U0.WADDR_WIDTH = 13;
defparam FIFO_U0.WDATA_WIDTH = 2;

defparam FIFO_U0.RADDR_WIDTH = 10;
defparam FIFO_U0.RDATA_WIDTH = 16;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);
        (RCLK => DO1)    = (0:0:0, 0:0:0);
        (RCLK => DO2)    = (0:0:0, 0:0:0);
        (RCLK => DO3)    = (0:0:0, 0:0:0);
        (RCLK => DO4)    = (0:0:0, 0:0:0);
        (RCLK => DO5)    = (0:0:0, 0:0:0);
        (RCLK => DO6)    = (0:0:0, 0:0:0);
        (RCLK => DO7)    = (0:0:0, 0:0:0);
        (RCLK => DO8)    = (0:0:0, 0:0:0);
        (RCLK => DO9)    = (0:0:0, 0:0:0);
        (RCLK => DO10)    = (0:0:0, 0:0:0);
        (RCLK => DO11)    = (0:0:0, 0:0:0);
        (RCLK => DO12)    = (0:0:0, 0:0:0);
        (RCLK => DO13)    = (0:0:0, 0:0:0);
        (RCLK => DO14)    = (0:0:0, 0:0:0);
        (RCLK => DO15)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);
        (RST => DO1)    = (0:0:0, 0:0:0);
        (RST => DO2)    = (0:0:0, 0:0:0);
        (RST => DO3)    = (0:0:0, 0:0:0);
        (RST => DO4)    = (0:0:0, 0:0:0);
        (RST => DO5)    = (0:0:0, 0:0:0);
        (RST => DO6)    = (0:0:0, 0:0:0);
        (RST => DO7)    = (0:0:0, 0:0:0);
        (RST => DO8)    = (0:0:0, 0:0:0);
        (RST => DO9)    = (0:0:0, 0:0:0);
        (RST => DO10)    = (0:0:0, 0:0:0);
        (RST => DO11)    = (0:0:0, 0:0:0);
        (RST => DO12)    = (0:0:0, 0:0:0);
        (RST => DO13)    = (0:0:0, 0:0:0);
        (RST => DO14)    = (0:0:0, 0:0:0);
        (RST => DO15)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX1_RX16 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,
    DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 16384;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0;
output DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,DO8,DO9,DO10,DO11,DO12,DO13,DO14,DO15;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [0:0] di;
wire [15:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ16 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ17 (EMPTY,EMPTY_sig);	 
buf INSXQ18 (AMFULL,AMFULL_node);	 
buf INSXQ19 (AMEMPTY,AMEMPTY_node);
assign di = {DI0};
//assign {DO15,DO14,DO13,DO12,DO11,DO10,DO9,DO8,DO7,DO6,DO5,DO4,DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
buf INSXQ4 (DO4,do[4]);
buf INSXQ5 (DO5,do[5]);
buf INSXQ6 (DO6,do[6]);
buf INSXQ7 (DO7,do[7]);
buf INSXQ8 (DO8,do[8]);
buf INSXQ9 (DO9,do[9]);

buf INSXQ10 (DO10,do[10]);
buf INSXQ11 (DO11,do[11]);
buf INSXQ12 (DO12,do[12]);
buf INSXQ13 (DO13,do[13]);
buf INSXQ14 (DO14,do[14]);
buf INSXQ15 (DO15,do[15]);

defparam FIFO_U0.WADDR_WIDTH = 14;
defparam FIFO_U0.WDATA_WIDTH = 1;

defparam FIFO_U0.RADDR_WIDTH = 10;
defparam FIFO_U0.RDATA_WIDTH = 16;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);
        (RCLK => DO1)    = (0:0:0, 0:0:0);
        (RCLK => DO2)    = (0:0:0, 0:0:0);
        (RCLK => DO3)    = (0:0:0, 0:0:0);
        (RCLK => DO4)    = (0:0:0, 0:0:0);
        (RCLK => DO5)    = (0:0:0, 0:0:0);
        (RCLK => DO6)    = (0:0:0, 0:0:0);
        (RCLK => DO7)    = (0:0:0, 0:0:0);
        (RCLK => DO8)    = (0:0:0, 0:0:0);
        (RCLK => DO9)    = (0:0:0, 0:0:0);
        (RCLK => DO10)    = (0:0:0, 0:0:0);
        (RCLK => DO11)    = (0:0:0, 0:0:0);
        (RCLK => DO12)    = (0:0:0, 0:0:0);
        (RCLK => DO13)    = (0:0:0, 0:0:0);
        (RCLK => DO14)    = (0:0:0, 0:0:0);
        (RCLK => DO15)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);
        (RST => DO1)    = (0:0:0, 0:0:0);
        (RST => DO2)    = (0:0:0, 0:0:0);
        (RST => DO3)    = (0:0:0, 0:0:0);
        (RST => DO4)    = (0:0:0, 0:0:0);
        (RST => DO5)    = (0:0:0, 0:0:0);
        (RST => DO6)    = (0:0:0, 0:0:0);
        (RST => DO7)    = (0:0:0, 0:0:0);
        (RST => DO8)    = (0:0:0, 0:0:0);
        (RST => DO9)    = (0:0:0, 0:0:0);
        (RST => DO10)    = (0:0:0, 0:0:0);
        (RST => DO11)    = (0:0:0, 0:0:0);
        (RST => DO12)    = (0:0:0, 0:0:0);
        (RST => DO13)    = (0:0:0, 0:0:0);
        (RST => DO14)    = (0:0:0, 0:0:0);
        (RST => DO15)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX4_RX8 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,DI1,DI2,DI3,
    DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 4096;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1,DI2,DI3;
output DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [3:0] di;
wire [7:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ8 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ9 (EMPTY,EMPTY_sig);	 
buf INSXQ10 (AMFULL,AMFULL_node);	 
buf INSXQ11 (AMEMPTY,AMEMPTY_node);
assign di = {DI3,DI2,DI1,DI0};
//assign {DO7,DO6,DO5,DO4,DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
buf INSXQ4 (DO4,do[4]);
buf INSXQ5 (DO5,do[5]);
buf INSXQ6 (DO6,do[6]);
buf INSXQ7 (DO7,do[7]);

defparam FIFO_U0.WADDR_WIDTH = 12;
defparam FIFO_U0.WDATA_WIDTH = 4;

defparam FIFO_U0.RADDR_WIDTH = 11;
defparam FIFO_U0.RDATA_WIDTH = 8;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);
	$setuphold  (posedge WCLK, DI2, 1, 0);
	$setuphold  (posedge WCLK, DI3, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);
        (RCLK => DO1)    = (0:0:0, 0:0:0);
        (RCLK => DO2)    = (0:0:0, 0:0:0);
        (RCLK => DO3)    = (0:0:0, 0:0:0);
        (RCLK => DO4)    = (0:0:0, 0:0:0);
        (RCLK => DO5)    = (0:0:0, 0:0:0);
        (RCLK => DO6)    = (0:0:0, 0:0:0);
        (RCLK => DO7)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);
        (RST => DO1)    = (0:0:0, 0:0:0);
        (RST => DO2)    = (0:0:0, 0:0:0);
        (RST => DO3)    = (0:0:0, 0:0:0);
        (RST => DO4)    = (0:0:0, 0:0:0);
        (RST => DO5)    = (0:0:0, 0:0:0);
        (RST => DO6)    = (0:0:0, 0:0:0);
        (RST => DO7)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX2_RX8 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,DI1,
    DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 8192;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1;
output DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [1:0] di;
wire [7:0] do;
wire FULL_sig, EMPTY_sig; 
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ8 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ9 (EMPTY,EMPTY_sig);	 
buf INSXQ10 (AMFULL,AMFULL_node);	 
buf INSXQ11 (AMEMPTY,AMEMPTY_node);
assign di = {DI1,DI0};
//assign {DO7,DO6,DO5,DO4,DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
buf INSXQ4 (DO4,do[4]);
buf INSXQ5 (DO5,do[5]);
buf INSXQ6 (DO6,do[6]);
buf INSXQ7 (DO7,do[7]);
defparam FIFO_U0.WADDR_WIDTH = 13;
defparam FIFO_U0.WDATA_WIDTH = 2;

defparam FIFO_U0.RADDR_WIDTH = 11;
defparam FIFO_U0.RDATA_WIDTH = 8;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);
        (RCLK => DO1)    = (0:0:0, 0:0:0);
        (RCLK => DO2)    = (0:0:0, 0:0:0);
        (RCLK => DO3)    = (0:0:0, 0:0:0);
        (RCLK => DO4)    = (0:0:0, 0:0:0);
        (RCLK => DO5)    = (0:0:0, 0:0:0);
        (RCLK => DO6)    = (0:0:0, 0:0:0);
        (RCLK => DO7)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);
        (RST => DO1)    = (0:0:0, 0:0:0);
        (RST => DO2)    = (0:0:0, 0:0:0);
        (RST => DO3)    = (0:0:0, 0:0:0);
        (RST => DO4)    = (0:0:0, 0:0:0);
        (RST => DO5)    = (0:0:0, 0:0:0);
        (RST => DO6)    = (0:0:0, 0:0:0);
        (RST => DO7)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX1_RX8 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,
    DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 16384;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0;
output DO0,DO1,DO2,DO3,DO4,DO5,DO6,DO7;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [0:0] di;
wire [7:0] do;
wire FULL_sig, EMPTY_sig; 
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ8 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ9 (EMPTY,EMPTY_sig);	 
buf INSXQ10 (AMFULL,AMFULL_node);	 
buf INSXQ11 (AMEMPTY,AMEMPTY_node);
assign di = {DI0};
//assign {DO7,DO6,DO5,DO4,DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
buf INSXQ4 (DO4,do[4]);
buf INSXQ5 (DO5,do[5]);
buf INSXQ6 (DO6,do[6]);
buf INSXQ7 (DO7,do[7]);
defparam FIFO_U0.WADDR_WIDTH = 14;
defparam FIFO_U0.WDATA_WIDTH = 1;

defparam FIFO_U0.RADDR_WIDTH = 11;
defparam FIFO_U0.RDATA_WIDTH = 8;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);
        (RCLK => DO1)    = (0:0:0, 0:0:0);
        (RCLK => DO2)    = (0:0:0, 0:0:0);
        (RCLK => DO3)    = (0:0:0, 0:0:0);
        (RCLK => DO4)    = (0:0:0, 0:0:0);
        (RCLK => DO5)    = (0:0:0, 0:0:0);
        (RCLK => DO6)    = (0:0:0, 0:0:0);
        (RCLK => DO7)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);
        (RST => DO1)    = (0:0:0, 0:0:0);
        (RST => DO2)    = (0:0:0, 0:0:0);
        (RST => DO3)    = (0:0:0, 0:0:0);
        (RST => DO4)    = (0:0:0, 0:0:0);
        (RST => DO5)    = (0:0:0, 0:0:0);
        (RST => DO6)    = (0:0:0, 0:0:0);
        (RST => DO7)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX2_RX4 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,DI1,
    DO0,DO1,DO2,DO3,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 8192;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0,DI1;
output DO0,DO1,DO2,DO3;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [1:0] di;
wire [3:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ4 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ5 (EMPTY,EMPTY_sig);	 
buf INSXQ6 (AMFULL,AMFULL_node);	 
buf INSXQ7 (AMEMPTY,AMEMPTY_node);
assign di = {DI1,DI0};
//assign {DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
defparam FIFO_U0.WADDR_WIDTH = 13;
defparam FIFO_U0.WDATA_WIDTH = 2;

defparam FIFO_U0.RADDR_WIDTH = 12;
defparam FIFO_U0.RDATA_WIDTH = 4;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, DI1, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);
        (RCLK => DO1)    = (0:0:0, 0:0:0);
        (RCLK => DO2)    = (0:0:0, 0:0:0);
        (RCLK => DO3)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);
        (RST => DO1)    = (0:0:0, 0:0:0);
        (RST => DO2)    = (0:0:0, 0:0:0);
        (RST => DO3)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX1_RX4 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,
    DO0,DO1,DO2,DO3,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 16384;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0;
output DO0,DO1,DO2,DO3;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [0:0] di;
wire [3:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ4 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ5 (EMPTY,EMPTY_sig);	 
buf INSXQ6 (AMFULL,AMFULL_node);	 
buf INSXQ7 (AMEMPTY,AMEMPTY_node);
assign di = {DI0};
//assign {DO3,DO2,DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);
buf INSXQ2 (DO2,do[2]);
buf INSXQ3 (DO3,do[3]);
defparam FIFO_U0.WADDR_WIDTH = 14;
defparam FIFO_U0.WDATA_WIDTH = 1;

defparam FIFO_U0.RADDR_WIDTH = 12;
defparam FIFO_U0.RDATA_WIDTH = 4;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);
        (RCLK => DO1)    = (0:0:0, 0:0:0);
        (RCLK => DO2)    = (0:0:0, 0:0:0);
        (RCLK => DO3)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);
        (RST => DO1)    = (0:0:0, 0:0:0);
        (RST => DO2)    = (0:0:0, 0:0:0);
        (RST => DO3)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMBFIFO16KA_WX1_RX2 (
    WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST,
    DI0,
    DO0,DO1,
    FULL,AMFULL,EMPTY,AMEMPTY);

parameter FIFO_FULL_FLAG = 16384;
parameter FIFO_AMFULL_FLAG = 1;
parameter FIFO_AMEMPTY_FLAG = 1;

input  WE,WCLK,RE,RCLK,FULLIN,EMPTYIN,RST,RPRST;
input  DI0;
output DO0,DO1;
output FULL,AMFULL,EMPTY,AMEMPTY;

wire [0:0] di;
wire [1:0] do;
wire FULL_sig, EMPTY_sig;
wire AMFULL_node, AMEMPTY_node;
reg notifier;

//assign FULL = FULL_sig;
buf INSXQ2 (FULL,FULL_sig);
//assign EMPTY = EMPTY_sig;
buf INSXQ3 (EMPTY,EMPTY_sig);	 
buf INSXQ4 (AMFULL,AMFULL_node);	 
buf INSXQ5 (AMEMPTY,AMEMPTY_node);
assign di = {DI0};
//assign {DO1,DO0} = do;
buf INSXQ0 (DO0,do[0]);
buf INSXQ1 (DO1,do[1]);

defparam FIFO_U0.WADDR_WIDTH = 14;
defparam FIFO_U0.WDATA_WIDTH = 1;

defparam FIFO_U0.RADDR_WIDTH = 13;
defparam FIFO_U0.RDATA_WIDTH = 2;

defparam FIFO_U0.TERMINAL_COUNT = FIFO_FULL_FLAG - 1;
defparam FIFO_U0.ALMOST_FULL_X = FIFO_AMFULL_FLAG;
defparam FIFO_U0.ALMOST_EMPTY_Y = FIFO_AMEMPTY_FLAG;

SC_FIFO_V2_16K FIFO_U0(
		.WE(WE),
		.WCLK(WCLK),
		.RST(RST),
		.RPRST(RPRST),
		.RE(RE),
		.RCLK(RCLK),
		.FULLIN(FULLIN),
		.EMPTYIN(EMPTYIN),
		.DI(di),
		.FULL(FULL_sig),
		.EMPTY(EMPTY_sig),
		.AMFULL(AMFULL_node),
		.AMEMPTY(AMEMPTY_node),
		.DO(do));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);
	$width (posedge RPRST, 1, 0, notifier);

	$setuphold  (posedge WCLK, DI0, 1, 0);

	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge RCLK, RE, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1); 
        $recovery(posedge RPRST, posedge RCLK, 1); 

        (RCLK => DO0)    = (0:0:0, 0:0:0);
        (RCLK => DO1)    = (0:0:0, 0:0:0);

	(WCLK => FULL)   = (0:0:0, 0:0:0);
	(WCLK => AMFULL) = (0:0:0, 0:0:0);
	(RCLK => EMPTY)   = (0:0:0, 0:0:0);
	(RCLK => AMEMPTY) = (0:0:0, 0:0:0);

        (RST => DO0)    = (0:0:0, 0:0:0);
        (RST => DO1)    = (0:0:0, 0:0:0);

	(RST => FULL)   = (0:0:0, 0:0:0);
	(RST => AMFULL) = (0:0:0, 0:0:0);
	(RST => EMPTY)   = (0:0:0, 0:0:0);
	(RST => AMEMPTY) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB16K_WX16_RX1 (
    WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST,
    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,
    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,
    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,RAD13,
    RD0);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,RAD13;
output RD0;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [9:0] wad;
wire [13:0] rad;
wire [1:0] wcs;
wire [15:0] wd;
wire [0:0] rd;
reg notifier;

assign wad = {WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD13,RAD12,RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};

assign wcs = {WCS1,WCS0};
assign wd = {WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD0} = rd;
buf INSXQ (RD0,rd);
defparam RAM_U0.WDATA_WIDTH=16;
defparam RAM_U0.WADDR_WIDTH=10;
defparam RAM_U0.RDATA_WIDTH=1;
defparam RAM_U0.RADDR_WIDTH=14;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);
	$setuphold  (posedge WCLK, WD8, 1, 0);
	$setuphold  (posedge WCLK, WD9, 1, 0);
	$setuphold  (posedge WCLK, WD10, 1, 0);
	$setuphold  (posedge WCLK, WD11, 1, 0);
	$setuphold  (posedge WCLK, WD12, 1, 0);
	$setuphold  (posedge WCLK, WD13, 1, 0);
	$setuphold  (posedge WCLK, WD14, 1, 0);
	$setuphold  (posedge WCLK, WD15, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);
	$setuphold  (posedge RCLK, RAD10, 1, 0);
	$setuphold  (posedge RCLK, RAD11, 1, 0);
	$setuphold  (posedge RCLK, RAD12, 1, 0);
	$setuphold  (posedge RCLK, RAD13, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1);

	(RCLK => RD0) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB16K_WX16_RX2 (
    WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST,
    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,
    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,
    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,
    RD0,RD1);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12;
output RD0,RD1;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [9:0] wad;
wire [12:0] rad;
wire [1:0] wcs;
wire [15:0] wd;
wire [1:0] rd;
reg notifier;

assign wad = {WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD12,RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};

assign wcs = {WCS1,WCS0};
assign wd = {WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
defparam RAM_U0.WDATA_WIDTH=16;
defparam RAM_U0.WADDR_WIDTH=10;
defparam RAM_U0.RDATA_WIDTH=2;
defparam RAM_U0.RADDR_WIDTH=13;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);
	$setuphold  (posedge WCLK, WD8, 1, 0);
	$setuphold  (posedge WCLK, WD9, 1, 0);
	$setuphold  (posedge WCLK, WD10, 1, 0);
	$setuphold  (posedge WCLK, WD11, 1, 0);
	$setuphold  (posedge WCLK, WD12, 1, 0);
	$setuphold  (posedge WCLK, WD13, 1, 0);
	$setuphold  (posedge WCLK, WD14, 1, 0);
	$setuphold  (posedge WCLK, WD15, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);
	$setuphold  (posedge RCLK, RAD10, 1, 0);
	$setuphold  (posedge RCLK, RAD11, 1, 0);
	$setuphold  (posedge RCLK, RAD12, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1);

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB16K_WX16_RX4 (
    WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST,
    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,
    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,
    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,
    RD0,RD1,RD2,RD3);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11;
output RD0,RD1,RD2,RD3;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [9:0] wad;
wire [11:0] rad;
wire [1:0] wcs;
wire [15:0] wd;
wire [3:0] rd;
reg notifier;

assign wad = {WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};

assign wcs = {WCS1,WCS0};
assign wd = {WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
defparam RAM_U0.WDATA_WIDTH=16;
defparam RAM_U0.WADDR_WIDTH=10;
defparam RAM_U0.RDATA_WIDTH=4;
defparam RAM_U0.RADDR_WIDTH=12;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);
	$setuphold  (posedge WCLK, WD8, 1, 0);
	$setuphold  (posedge WCLK, WD9, 1, 0);
	$setuphold  (posedge WCLK, WD10, 1, 0);
	$setuphold  (posedge WCLK, WD11, 1, 0);
	$setuphold  (posedge WCLK, WD12, 1, 0);
	$setuphold  (posedge WCLK, WD13, 1, 0);
	$setuphold  (posedge WCLK, WD14, 1, 0);
	$setuphold  (posedge WCLK, WD15, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);
	$setuphold  (posedge RCLK, RAD10, 1, 0);
	$setuphold  (posedge RCLK, RAD11, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1);

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);
	(RCLK => RD2) = (0:0:0, 0:0:0);
	(RCLK => RD3) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB16K_WX16_RX8 (
    WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST,
    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,
    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,
    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,
    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10;
output RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [9:0] wad;
wire [10:0] rad;
wire [1:0] wcs;
wire [15:0] wd;
wire [7:0] rd;
reg notifier;

assign wad = {WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};

assign wcs = {WCS1,WCS0};
assign wd = {WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
defparam RAM_U0.WDATA_WIDTH=16;
defparam RAM_U0.WADDR_WIDTH=10;
defparam RAM_U0.RDATA_WIDTH=8;
defparam RAM_U0.RADDR_WIDTH=11;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);
	$setuphold  (posedge WCLK, WD8, 1, 0);
	$setuphold  (posedge WCLK, WD9, 1, 0);
	$setuphold  (posedge WCLK, WD10, 1, 0);
	$setuphold  (posedge WCLK, WD11, 1, 0);
	$setuphold  (posedge WCLK, WD12, 1, 0);
	$setuphold  (posedge WCLK, WD13, 1, 0);
	$setuphold  (posedge WCLK, WD14, 1, 0);
	$setuphold  (posedge WCLK, WD15, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);
	$setuphold  (posedge RCLK, RAD10, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1);

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);
	(RCLK => RD2) = (0:0:0, 0:0:0);
	(RCLK => RD3) = (0:0:0, 0:0:0);
	(RCLK => RD4) = (0:0:0, 0:0:0);
	(RCLK => RD5) = (0:0:0, 0:0:0);
	(RCLK => RD6) = (0:0:0, 0:0:0);
	(RCLK => RD7) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB16K_WX2_RX1 (
    WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST,
    WD0,WD1,
    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,
    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,RAD13,
    RD0);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST;
input  WD0,WD1;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,RAD13;
output RD0;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [12:0] wad;
wire [13:0] rad;
wire [1:0] wcs;
wire [1:0] wd;
wire [0:0] rd;
reg notifier;

assign wad = {WAD12,WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD13,RAD12,RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};

assign wcs = {WCS1,WCS0};
assign wd = {WD1,WD0};
//assign {RD0} = rd;
buf INSXQ (RD0,rd);

defparam RAM_U0.WDATA_WIDTH=2;
defparam RAM_U0.WADDR_WIDTH=13;
defparam RAM_U0.RDATA_WIDTH=1;
defparam RAM_U0.RADDR_WIDTH=14;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);
	$setuphold  (posedge WCLK, WAD12, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);
	$setuphold  (posedge RCLK, RAD10, 1, 0);
	$setuphold  (posedge RCLK, RAD11, 1, 0);
	$setuphold  (posedge RCLK, RAD12, 1, 0);
	$setuphold  (posedge RCLK, RAD13, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1);

	(RCLK => RD0) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB16K_WX32_RX1 (
    WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST,
    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23,WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31,
    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,
    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,RAD13,
    RD0);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23,WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,RAD13;
output RD0;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [8:0] wad;
wire [13:0] rad;
wire [1:0] wcs;
wire [31:0] wd;
wire [0:0] rd;
reg notifier;

assign wad = {WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD13,RAD12,RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};

assign wcs = {WCS1,WCS0};
assign wd = {WD31,WD30,WD29,WD28,WD27,WD26,WD25,WD24,WD23,WD22,WD21,WD20,WD19,WD18,WD17,WD16,WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD0} = rd;
buf INSXQ (RD0,rd);

defparam RAM_U0.WDATA_WIDTH=32;
defparam RAM_U0.WADDR_WIDTH=9;
defparam RAM_U0.RDATA_WIDTH=1;
defparam RAM_U0.RADDR_WIDTH=14;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);
	$setuphold  (posedge WCLK, WD8, 1, 0);
	$setuphold  (posedge WCLK, WD9, 1, 0);
	$setuphold  (posedge WCLK, WD10, 1, 0);
	$setuphold  (posedge WCLK, WD11, 1, 0);
	$setuphold  (posedge WCLK, WD12, 1, 0);
	$setuphold  (posedge WCLK, WD13, 1, 0);
	$setuphold  (posedge WCLK, WD14, 1, 0);
	$setuphold  (posedge WCLK, WD15, 1, 0);
	$setuphold  (posedge WCLK, WD16, 1, 0);
	$setuphold  (posedge WCLK, WD17, 1, 0);
	$setuphold  (posedge WCLK, WD18, 1, 0);
	$setuphold  (posedge WCLK, WD19, 1, 0);
	$setuphold  (posedge WCLK, WD20, 1, 0);
	$setuphold  (posedge WCLK, WD21, 1, 0);
	$setuphold  (posedge WCLK, WD22, 1, 0);
	$setuphold  (posedge WCLK, WD23, 1, 0);
	$setuphold  (posedge WCLK, WD24, 1, 0);
	$setuphold  (posedge WCLK, WD25, 1, 0);
	$setuphold  (posedge WCLK, WD26, 1, 0);
	$setuphold  (posedge WCLK, WD27, 1, 0);
	$setuphold  (posedge WCLK, WD28, 1, 0);
	$setuphold  (posedge WCLK, WD29, 1, 0);
	$setuphold  (posedge WCLK, WD30, 1, 0);
	$setuphold  (posedge WCLK, WD31, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);
	$setuphold  (posedge RCLK, RAD10, 1, 0);
	$setuphold  (posedge RCLK, RAD11, 1, 0);
	$setuphold  (posedge RCLK, RAD12, 1, 0);
	$setuphold  (posedge RCLK, RAD13, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1);

	(RCLK => RD0) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB16K_WX32_RX16 (
    WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST,
    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23,WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31,
    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,
    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,
    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23,WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9;
output RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [8:0] wad;
wire [9:0] rad;
wire [1:0] wcs;
wire [31:0] wd;
wire [15:0] rd;
reg notifier;

assign wad = {WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};

assign wcs = {WCS1,WCS0};
assign wd = {WD31,WD30,WD29,WD28,WD27,WD26,WD25,WD24,WD23,WD22,WD21,WD20,WD19,WD18,WD17,WD16,WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
buf INSXQ8 (RD8,rd[8]);
buf INSXQ9 (RD9,rd[9]);

buf INSXQ10 (RD10,rd[10]);
buf INSXQ11 (RD11,rd[11]);
buf INSXQ12 (RD12,rd[12]);
buf INSXQ13 (RD13,rd[13]);
buf INSXQ14 (RD14,rd[14]);
buf INSXQ15 (RD15,rd[15]);
defparam RAM_U0.WDATA_WIDTH=32;
defparam RAM_U0.WADDR_WIDTH=9;
defparam RAM_U0.RDATA_WIDTH=16;
defparam RAM_U0.RADDR_WIDTH=10;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);
	$setuphold  (posedge WCLK, WD8, 1, 0);
	$setuphold  (posedge WCLK, WD9, 1, 0);
	$setuphold  (posedge WCLK, WD10, 1, 0);
	$setuphold  (posedge WCLK, WD11, 1, 0);
	$setuphold  (posedge WCLK, WD12, 1, 0);
	$setuphold  (posedge WCLK, WD13, 1, 0);
	$setuphold  (posedge WCLK, WD14, 1, 0);
	$setuphold  (posedge WCLK, WD15, 1, 0);
	$setuphold  (posedge WCLK, WD16, 1, 0);
	$setuphold  (posedge WCLK, WD17, 1, 0);
	$setuphold  (posedge WCLK, WD18, 1, 0);
	$setuphold  (posedge WCLK, WD19, 1, 0);
	$setuphold  (posedge WCLK, WD20, 1, 0);
	$setuphold  (posedge WCLK, WD21, 1, 0);
	$setuphold  (posedge WCLK, WD22, 1, 0);
	$setuphold  (posedge WCLK, WD23, 1, 0);
	$setuphold  (posedge WCLK, WD24, 1, 0);
	$setuphold  (posedge WCLK, WD25, 1, 0);
	$setuphold  (posedge WCLK, WD26, 1, 0);
	$setuphold  (posedge WCLK, WD27, 1, 0);
	$setuphold  (posedge WCLK, WD28, 1, 0);
	$setuphold  (posedge WCLK, WD29, 1, 0);
	$setuphold  (posedge WCLK, WD30, 1, 0);
	$setuphold  (posedge WCLK, WD31, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1);

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);
	(RCLK => RD2) = (0:0:0, 0:0:0);
	(RCLK => RD3) = (0:0:0, 0:0:0);
	(RCLK => RD4) = (0:0:0, 0:0:0);
	(RCLK => RD5) = (0:0:0, 0:0:0);
	(RCLK => RD6) = (0:0:0, 0:0:0);
	(RCLK => RD7) = (0:0:0, 0:0:0);
	(RCLK => RD8) = (0:0:0, 0:0:0);
	(RCLK => RD9) = (0:0:0, 0:0:0);
	(RCLK => RD10) = (0:0:0, 0:0:0);
	(RCLK => RD11) = (0:0:0, 0:0:0);
	(RCLK => RD12) = (0:0:0, 0:0:0);
	(RCLK => RD13) = (0:0:0, 0:0:0);
	(RCLK => RD14) = (0:0:0, 0:0:0);
	(RCLK => RD15) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);
	(RST => RD8) = (0:0:0, 0:0:0);
	(RST => RD9) = (0:0:0, 0:0:0);
	(RST => RD10) = (0:0:0, 0:0:0);
	(RST => RD11) = (0:0:0, 0:0:0);
	(RST => RD12) = (0:0:0, 0:0:0);
	(RST => RD13) = (0:0:0, 0:0:0);
	(RST => RD14) = (0:0:0, 0:0:0);
	(RST => RD15) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB16K_WX32_RX2 (
    WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST,
    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23,WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31,
    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,
    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,
    RD0,RD1);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23,WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12;
output RD0,RD1;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [8:0] wad;
wire [12:0] rad;
wire [1:0] wcs;
wire [31:0] wd;
wire [1:0] rd;
reg notifier;

assign wad = {WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD12,RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};

assign wcs = {WCS1,WCS0};
assign wd = {WD31,WD30,WD29,WD28,WD27,WD26,WD25,WD24,WD23,WD22,WD21,WD20,WD19,WD18,WD17,WD16,WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
defparam RAM_U0.WDATA_WIDTH=32;
defparam RAM_U0.WADDR_WIDTH=9;
defparam RAM_U0.RDATA_WIDTH=2;
defparam RAM_U0.RADDR_WIDTH=13;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);
	$setuphold  (posedge WCLK, WD8, 1, 0);
	$setuphold  (posedge WCLK, WD9, 1, 0);
	$setuphold  (posedge WCLK, WD10, 1, 0);
	$setuphold  (posedge WCLK, WD11, 1, 0);
	$setuphold  (posedge WCLK, WD12, 1, 0);
	$setuphold  (posedge WCLK, WD13, 1, 0);
	$setuphold  (posedge WCLK, WD14, 1, 0);
	$setuphold  (posedge WCLK, WD15, 1, 0);
	$setuphold  (posedge WCLK, WD16, 1, 0);
	$setuphold  (posedge WCLK, WD17, 1, 0);
	$setuphold  (posedge WCLK, WD18, 1, 0);
	$setuphold  (posedge WCLK, WD19, 1, 0);
	$setuphold  (posedge WCLK, WD20, 1, 0);
	$setuphold  (posedge WCLK, WD21, 1, 0);
	$setuphold  (posedge WCLK, WD22, 1, 0);
	$setuphold  (posedge WCLK, WD23, 1, 0);
	$setuphold  (posedge WCLK, WD24, 1, 0);
	$setuphold  (posedge WCLK, WD25, 1, 0);
	$setuphold  (posedge WCLK, WD26, 1, 0);
	$setuphold  (posedge WCLK, WD27, 1, 0);
	$setuphold  (posedge WCLK, WD28, 1, 0);
	$setuphold  (posedge WCLK, WD29, 1, 0);
	$setuphold  (posedge WCLK, WD30, 1, 0);
	$setuphold  (posedge WCLK, WD31, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);
	$setuphold  (posedge RCLK, RAD10, 1, 0);
	$setuphold  (posedge RCLK, RAD11, 1, 0);
	$setuphold  (posedge RCLK, RAD12, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1);

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB16K_WX32_RX4 (
    WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST,
    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23,WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31,
    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,
    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,
    RD0,RD1,RD2,RD3);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23,WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11;
output RD0,RD1,RD2,RD3;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [8:0] wad;
wire [11:0] rad;
wire [1:0] wcs;
wire [31:0] wd;
wire [3:0] rd;
reg notifier;

assign wad = {WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};

assign wcs = {WCS1,WCS0};
assign wd = {WD31,WD30,WD29,WD28,WD27,WD26,WD25,WD24,WD23,WD22,WD21,WD20,WD19,WD18,WD17,WD16,WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
defparam RAM_U0.WDATA_WIDTH=32;
defparam RAM_U0.WADDR_WIDTH=9;
defparam RAM_U0.RDATA_WIDTH=4;
defparam RAM_U0.RADDR_WIDTH=12;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);
	$setuphold  (posedge WCLK, WD8, 1, 0);
	$setuphold  (posedge WCLK, WD9, 1, 0);
	$setuphold  (posedge WCLK, WD10, 1, 0);
	$setuphold  (posedge WCLK, WD11, 1, 0);
	$setuphold  (posedge WCLK, WD12, 1, 0);
	$setuphold  (posedge WCLK, WD13, 1, 0);
	$setuphold  (posedge WCLK, WD14, 1, 0);
	$setuphold  (posedge WCLK, WD15, 1, 0);
	$setuphold  (posedge WCLK, WD16, 1, 0);
	$setuphold  (posedge WCLK, WD17, 1, 0);
	$setuphold  (posedge WCLK, WD18, 1, 0);
	$setuphold  (posedge WCLK, WD19, 1, 0);
	$setuphold  (posedge WCLK, WD20, 1, 0);
	$setuphold  (posedge WCLK, WD21, 1, 0);
	$setuphold  (posedge WCLK, WD22, 1, 0);
	$setuphold  (posedge WCLK, WD23, 1, 0);
	$setuphold  (posedge WCLK, WD24, 1, 0);
	$setuphold  (posedge WCLK, WD25, 1, 0);
	$setuphold  (posedge WCLK, WD26, 1, 0);
	$setuphold  (posedge WCLK, WD27, 1, 0);
	$setuphold  (posedge WCLK, WD28, 1, 0);
	$setuphold  (posedge WCLK, WD29, 1, 0);
	$setuphold  (posedge WCLK, WD30, 1, 0);
	$setuphold  (posedge WCLK, WD31, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);
	$setuphold  (posedge RCLK, RAD10, 1, 0);
	$setuphold  (posedge RCLK, RAD11, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1);

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);
	(RCLK => RD2) = (0:0:0, 0:0:0);
	(RCLK => RD3) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB16K_WX32_RX8 (
    WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST,
    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23,WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31,
    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,
    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,
    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23,WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10;
output RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [8:0] wad;
wire [10:0] rad;
wire [1:0] wcs;
wire [31:0] wd;
wire [7:0] rd;
reg notifier;

assign wad = {WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};

assign wcs = {WCS1,WCS0};
assign wd = {WD31,WD30,WD29,WD28,WD27,WD26,WD25,WD24,WD23,WD22,WD21,WD20,WD19,WD18,WD17,WD16,WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
defparam RAM_U0.WDATA_WIDTH=32;
defparam RAM_U0.WADDR_WIDTH=9;
defparam RAM_U0.RDATA_WIDTH=8;
defparam RAM_U0.RADDR_WIDTH=11;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);
	$setuphold  (posedge WCLK, WD8, 1, 0);
	$setuphold  (posedge WCLK, WD9, 1, 0);
	$setuphold  (posedge WCLK, WD10, 1, 0);
	$setuphold  (posedge WCLK, WD11, 1, 0);
	$setuphold  (posedge WCLK, WD12, 1, 0);
	$setuphold  (posedge WCLK, WD13, 1, 0);
	$setuphold  (posedge WCLK, WD14, 1, 0);
	$setuphold  (posedge WCLK, WD15, 1, 0);
	$setuphold  (posedge WCLK, WD16, 1, 0);
	$setuphold  (posedge WCLK, WD17, 1, 0);
	$setuphold  (posedge WCLK, WD18, 1, 0);
	$setuphold  (posedge WCLK, WD19, 1, 0);
	$setuphold  (posedge WCLK, WD20, 1, 0);
	$setuphold  (posedge WCLK, WD21, 1, 0);
	$setuphold  (posedge WCLK, WD22, 1, 0);
	$setuphold  (posedge WCLK, WD23, 1, 0);
	$setuphold  (posedge WCLK, WD24, 1, 0);
	$setuphold  (posedge WCLK, WD25, 1, 0);
	$setuphold  (posedge WCLK, WD26, 1, 0);
	$setuphold  (posedge WCLK, WD27, 1, 0);
	$setuphold  (posedge WCLK, WD28, 1, 0);
	$setuphold  (posedge WCLK, WD29, 1, 0);
	$setuphold  (posedge WCLK, WD30, 1, 0);
	$setuphold  (posedge WCLK, WD31, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);
	$setuphold  (posedge RCLK, RAD10, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1);

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);
	(RCLK => RD2) = (0:0:0, 0:0:0);
	(RCLK => RD3) = (0:0:0, 0:0:0);
	(RCLK => RD4) = (0:0:0, 0:0:0);
	(RCLK => RD5) = (0:0:0, 0:0:0);
	(RCLK => RD6) = (0:0:0, 0:0:0);
	(RCLK => RD7) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB16K_WX4_RX1 (
    WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST,
    WD0,WD1,WD2,WD3,
    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,
    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,RAD13,
    RD0);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST;
input  WD0,WD1,WD2,WD3;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,RAD13;
output RD0;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [11:0] wad;
wire [13:0] rad;
wire [1:0] wcs;
wire [3:0] wd;
wire [0:0] rd;
reg notifier;

assign wad = {WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD13,RAD12,RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};

assign wcs = {WCS1,WCS0};
assign wd = {WD3,WD2,WD1,WD0};
//assign {RD0} = rd;
buf INSXQ (RD0,rd);

defparam RAM_U0.WDATA_WIDTH=4;
defparam RAM_U0.WADDR_WIDTH=12;
defparam RAM_U0.RDATA_WIDTH=1;
defparam RAM_U0.RADDR_WIDTH=14;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);
	$setuphold  (posedge RCLK, RAD10, 1, 0);
	$setuphold  (posedge RCLK, RAD11, 1, 0);
	$setuphold  (posedge RCLK, RAD12, 1, 0);
	$setuphold  (posedge RCLK, RAD13, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1);

	(RCLK => RD0) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB16K_WX4_RX2 (
    WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST,
    WD0,WD1,WD2,WD3,
    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,
    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,
    RD0,RD1);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST;
input  WD0,WD1,WD2,WD3;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12;
output RD0,RD1;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [11:0] wad;
wire [12:0] rad;
wire [1:0] wcs;
wire [3:0] wd;
wire [1:0] rd;
reg notifier;

assign wad = {WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD12,RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};

assign wcs = {WCS1,WCS0};
assign wd = {WD3,WD2,WD1,WD0};
//assign {RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
defparam RAM_U0.WDATA_WIDTH=4;
defparam RAM_U0.WADDR_WIDTH=12;
defparam RAM_U0.RDATA_WIDTH=2;
defparam RAM_U0.RADDR_WIDTH=13;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);
	$setuphold  (posedge RCLK, RAD10, 1, 0);
	$setuphold  (posedge RCLK, RAD11, 1, 0);
	$setuphold  (posedge RCLK, RAD12, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1);

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB16K_WX8_RX1 (
    WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST,
    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,
    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,
    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,RAD13,
    RD0);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,RAD13;
output RD0;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [10:0] wad;
wire [13:0] rad;
wire [1:0] wcs;
wire [7:0] wd;
wire [0:0] rd;
reg notifier;

assign wad = {WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD13,RAD12,RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};

assign wcs = {WCS1,WCS0};
assign wd = {WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD0} = rd;
buf INSXQ (RD0,rd);

defparam RAM_U0.WDATA_WIDTH=8;
defparam RAM_U0.WADDR_WIDTH=11;
defparam RAM_U0.RDATA_WIDTH=1;
defparam RAM_U0.RADDR_WIDTH=14;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);
	$setuphold  (posedge RCLK, RAD10, 1, 0);
	$setuphold  (posedge RCLK, RAD11, 1, 0);
	$setuphold  (posedge RCLK, RAD12, 1, 0);
	$setuphold  (posedge RCLK, RAD13, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1);

	(RCLK => RD0) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB16K_WX8_RX2 (
    WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST,
    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,
    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,
    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,
    RD0,RD1);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12;
output RD0,RD1;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [10:0] wad;
wire [12:0] rad;
wire [1:0] wcs;
wire [7:0] wd;
wire [1:0] rd;
reg notifier;

assign wad = {WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD12,RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};

assign wcs = {WCS1,WCS0};
assign wd = {WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
defparam RAM_U0.WDATA_WIDTH=8;
defparam RAM_U0.WADDR_WIDTH=11;
defparam RAM_U0.RDATA_WIDTH=2;
defparam RAM_U0.RADDR_WIDTH=13;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);
	$setuphold  (posedge RCLK, RAD10, 1, 0);
	$setuphold  (posedge RCLK, RAD11, 1, 0);
	$setuphold  (posedge RCLK, RAD12, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1);

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB16K_WX8_RX4 (
    WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST,
    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,
    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,
    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,
    RD0,RD1,RD2,RD3);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE,RCEN,RCLK,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11;
output RD0,RD1,RD2,RD3;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [10:0] wad;
wire [11:0] rad;
wire [1:0] wcs;
wire [7:0] wd;
wire [3:0] rd;
reg notifier;

assign wad = {WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};

assign wcs = {WCS1,WCS0};
assign wd = {WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
defparam RAM_U0.WDATA_WIDTH=8;
defparam RAM_U0.WADDR_WIDTH=11;
defparam RAM_U0.RDATA_WIDTH=4;
defparam RAM_U0.RADDR_WIDTH=12;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAM_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RCLK(RCLK),
                      .RCEN(RCEN),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);
	$width (posedge RCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);

	$setuphold  (posedge RCLK, RCEN, 1, 0);

	$setuphold  (posedge RCLK, RAD0, 1, 0);
	$setuphold  (posedge RCLK, RAD1, 1, 0);
	$setuphold  (posedge RCLK, RAD2, 1, 0);
	$setuphold  (posedge RCLK, RAD3, 1, 0);
	$setuphold  (posedge RCLK, RAD4, 1, 0);
	$setuphold  (posedge RCLK, RAD5, 1, 0);
	$setuphold  (posedge RCLK, RAD6, 1, 0);
	$setuphold  (posedge RCLK, RAD7, 1, 0);
	$setuphold  (posedge RCLK, RAD8, 1, 0);
	$setuphold  (posedge RCLK, RAD9, 1, 0);
	$setuphold  (posedge RCLK, RAD10, 1, 0);
	$setuphold  (posedge RCLK, RAD11, 1, 0);

        $recovery(posedge RST, posedge RCLK, 1);

	(RCLK => RD0) = (0:0:0, 0:0:0);
	(RCLK => RD1) = (0:0:0, 0:0:0);
	(RCLK => RD2) = (0:0:0, 0:0:0);
	(RCLK => RD3) = (0:0:0, 0:0:0);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB16KA_WX16_RX1 (
    WCEN,WCLK,WCS0,WCS1,WE,RST,
    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,
    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,
    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,RAD13,
    RD0);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,RAD13;
output RD0;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [9:0] wad;
wire [13:0] rad;
wire [1:0] wcs;
wire [15:0] wd;
wire [0:0] rd;
reg notifier;

assign wad = {WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD13,RAD12,RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};

assign wcs = {WCS1,WCS0};
assign wd = {WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD0} = rd;
buf INSXQ (RD0,rd);

defparam RAM_U0.WDATA_WIDTH=16;
defparam RAM_U0.WADDR_WIDTH=10;
defparam RAM_U0.RDATA_WIDTH=1;
defparam RAM_U0.RADDR_WIDTH=14;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);
	$setuphold  (posedge WCLK, WD8, 1, 0);
	$setuphold  (posedge WCLK, WD9, 1, 0);
	$setuphold  (posedge WCLK, WD10, 1, 0);
	$setuphold  (posedge WCLK, WD11, 1, 0);
	$setuphold  (posedge WCLK, WD12, 1, 0);
	$setuphold  (posedge WCLK, WD13, 1, 0);
	$setuphold  (posedge WCLK, WD14, 1, 0);
	$setuphold  (posedge WCLK, WD15, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1);

	(RST => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);
	(RAD9 => RD0) = (0:0:0, 0:0:0);
	(RAD10 => RD0) = (0:0:0, 0:0:0);
	(RAD11 => RD0) = (0:0:0, 0:0:0);
	(RAD12 => RD0) = (0:0:0, 0:0:0);
	(RAD13 => RD0) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB16KA_WX16_RX2 (
    WCEN,WCLK,WCS0,WCS1,WE,RST,
    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,
    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,
    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,
    RD0,RD1);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12;
output RD0,RD1;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [9:0] wad;
wire [12:0] rad;
wire [1:0] wcs;
wire [15:0] wd;
wire [1:0] rd;
reg notifier;

assign wad = {WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD12,RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};

assign wcs = {WCS1,WCS0};
assign wd = {WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
defparam RAM_U0.WDATA_WIDTH=16;
defparam RAM_U0.WADDR_WIDTH=10;
defparam RAM_U0.RDATA_WIDTH=2;
defparam RAM_U0.RADDR_WIDTH=13;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);
	$setuphold  (posedge WCLK, WD8, 1, 0);
	$setuphold  (posedge WCLK, WD9, 1, 0);
	$setuphold  (posedge WCLK, WD10, 1, 0);
	$setuphold  (posedge WCLK, WD11, 1, 0);
	$setuphold  (posedge WCLK, WD12, 1, 0);
	$setuphold  (posedge WCLK, WD13, 1, 0);
	$setuphold  (posedge WCLK, WD14, 1, 0);
	$setuphold  (posedge WCLK, WD15, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);

	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);
	(RAD9 => RD0) = (0:0:0, 0:0:0);
	(RAD10 => RD0) = (0:0:0, 0:0:0);
	(RAD11 => RD0) = (0:0:0, 0:0:0);
	(RAD12 => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD1) = (0:0:0, 0:0:0);
	(RAD1 => RD1) = (0:0:0, 0:0:0);
	(RAD2 => RD1) = (0:0:0, 0:0:0);
	(RAD3 => RD1) = (0:0:0, 0:0:0);
	(RAD4 => RD1) = (0:0:0, 0:0:0);
	(RAD5 => RD1) = (0:0:0, 0:0:0);
	(RAD6 => RD1) = (0:0:0, 0:0:0);
	(RAD7 => RD1) = (0:0:0, 0:0:0);
	(RAD8 => RD1) = (0:0:0, 0:0:0);
	(RAD9 => RD1) = (0:0:0, 0:0:0);
	(RAD10 => RD1) = (0:0:0, 0:0:0);
	(RAD11 => RD1) = (0:0:0, 0:0:0);
	(RAD12 => RD1) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB16KA_WX16_RX4 (
    WCEN,WCLK,WCS0,WCS1,WE,RST,
    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,
    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,
    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,
    RD0,RD1,RD2,RD3);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11;
output RD0,RD1,RD2,RD3;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [9:0] wad;
wire [11:0] rad;
wire [1:0] wcs;
wire [15:0] wd;
wire [3:0] rd;
reg notifier;

assign wad = {WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};

assign wcs = {WCS1,WCS0};
assign wd = {WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
defparam RAM_U0.WDATA_WIDTH=16;
defparam RAM_U0.WADDR_WIDTH=10;
defparam RAM_U0.RDATA_WIDTH=4;
defparam RAM_U0.RADDR_WIDTH=12;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);
	$setuphold  (posedge WCLK, WD8, 1, 0);
	$setuphold  (posedge WCLK, WD9, 1, 0);
	$setuphold  (posedge WCLK, WD10, 1, 0);
	$setuphold  (posedge WCLK, WD11, 1, 0);
	$setuphold  (posedge WCLK, WD12, 1, 0);
	$setuphold  (posedge WCLK, WD13, 1, 0);
	$setuphold  (posedge WCLK, WD14, 1, 0);
	$setuphold  (posedge WCLK, WD15, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);

	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);
	(RAD9 => RD0) = (0:0:0, 0:0:0);
	(RAD10 => RD0) = (0:0:0, 0:0:0);
	(RAD11 => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD1) = (0:0:0, 0:0:0);
	(RAD1 => RD1) = (0:0:0, 0:0:0);
	(RAD2 => RD1) = (0:0:0, 0:0:0);
	(RAD3 => RD1) = (0:0:0, 0:0:0);
	(RAD4 => RD1) = (0:0:0, 0:0:0);
	(RAD5 => RD1) = (0:0:0, 0:0:0);
	(RAD6 => RD1) = (0:0:0, 0:0:0);
	(RAD7 => RD1) = (0:0:0, 0:0:0);
	(RAD8 => RD1) = (0:0:0, 0:0:0);
	(RAD9 => RD1) = (0:0:0, 0:0:0);
	(RAD10 => RD1) = (0:0:0, 0:0:0);
	(RAD11 => RD1) = (0:0:0, 0:0:0);

	(RAD0 => RD2) = (0:0:0, 0:0:0);
	(RAD1 => RD2) = (0:0:0, 0:0:0);
	(RAD2 => RD2) = (0:0:0, 0:0:0);
	(RAD3 => RD2) = (0:0:0, 0:0:0);
	(RAD4 => RD2) = (0:0:0, 0:0:0);
	(RAD5 => RD2) = (0:0:0, 0:0:0);
	(RAD6 => RD2) = (0:0:0, 0:0:0);
	(RAD7 => RD2) = (0:0:0, 0:0:0);
	(RAD8 => RD2) = (0:0:0, 0:0:0);
	(RAD9 => RD2) = (0:0:0, 0:0:0);
	(RAD10 => RD2) = (0:0:0, 0:0:0);
	(RAD11 => RD2) = (0:0:0, 0:0:0);

	(RAD0 => RD3) = (0:0:0, 0:0:0);
	(RAD1 => RD3) = (0:0:0, 0:0:0);
	(RAD2 => RD3) = (0:0:0, 0:0:0);
	(RAD3 => RD3) = (0:0:0, 0:0:0);
	(RAD4 => RD3) = (0:0:0, 0:0:0);
	(RAD5 => RD3) = (0:0:0, 0:0:0);
	(RAD6 => RD3) = (0:0:0, 0:0:0);
	(RAD7 => RD3) = (0:0:0, 0:0:0);
	(RAD8 => RD3) = (0:0:0, 0:0:0);
	(RAD9 => RD3) = (0:0:0, 0:0:0);
	(RAD10 => RD3) = (0:0:0, 0:0:0);
	(RAD11 => RD3) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB16KA_WX16_RX8 (
    WCEN,WCLK,WCS0,WCS1,WE,RST,
    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,
    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,
    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,
    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10;
output RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [9:0] wad;
wire [10:0] rad;
wire [1:0] wcs;
wire [15:0] wd;
wire [7:0] rd;
reg notifier;

assign wad = {WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};

assign wcs = {WCS1,WCS0};
assign wd = {WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
defparam RAM_U0.WDATA_WIDTH=16;
defparam RAM_U0.WADDR_WIDTH=10;
defparam RAM_U0.RDATA_WIDTH=8;
defparam RAM_U0.RADDR_WIDTH=11;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);
	$setuphold  (posedge WCLK, WD8, 1, 0);
	$setuphold  (posedge WCLK, WD9, 1, 0);
	$setuphold  (posedge WCLK, WD10, 1, 0);
	$setuphold  (posedge WCLK, WD11, 1, 0);
	$setuphold  (posedge WCLK, WD12, 1, 0);
	$setuphold  (posedge WCLK, WD13, 1, 0);
	$setuphold  (posedge WCLK, WD14, 1, 0);
	$setuphold  (posedge WCLK, WD15, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);

	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);
	(RAD9 => RD0) = (0:0:0, 0:0:0);
	(RAD10 => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD1) = (0:0:0, 0:0:0);
	(RAD1 => RD1) = (0:0:0, 0:0:0);
	(RAD2 => RD1) = (0:0:0, 0:0:0);
	(RAD3 => RD1) = (0:0:0, 0:0:0);
	(RAD4 => RD1) = (0:0:0, 0:0:0);
	(RAD5 => RD1) = (0:0:0, 0:0:0);
	(RAD6 => RD1) = (0:0:0, 0:0:0);
	(RAD7 => RD1) = (0:0:0, 0:0:0);
	(RAD8 => RD1) = (0:0:0, 0:0:0);
	(RAD9 => RD1) = (0:0:0, 0:0:0);
	(RAD10 => RD1) = (0:0:0, 0:0:0);

	(RAD0 => RD2) = (0:0:0, 0:0:0);
	(RAD1 => RD2) = (0:0:0, 0:0:0);
	(RAD2 => RD2) = (0:0:0, 0:0:0);
	(RAD3 => RD2) = (0:0:0, 0:0:0);
	(RAD4 => RD2) = (0:0:0, 0:0:0);
	(RAD5 => RD2) = (0:0:0, 0:0:0);
	(RAD6 => RD2) = (0:0:0, 0:0:0);
	(RAD7 => RD2) = (0:0:0, 0:0:0);
	(RAD8 => RD2) = (0:0:0, 0:0:0);
	(RAD9 => RD2) = (0:0:0, 0:0:0);
	(RAD10 => RD2) = (0:0:0, 0:0:0);

	(RAD0 => RD3) = (0:0:0, 0:0:0);
	(RAD1 => RD3) = (0:0:0, 0:0:0);
	(RAD2 => RD3) = (0:0:0, 0:0:0);
	(RAD3 => RD3) = (0:0:0, 0:0:0);
	(RAD4 => RD3) = (0:0:0, 0:0:0);
	(RAD5 => RD3) = (0:0:0, 0:0:0);
	(RAD6 => RD3) = (0:0:0, 0:0:0);
	(RAD7 => RD3) = (0:0:0, 0:0:0);
	(RAD8 => RD3) = (0:0:0, 0:0:0);
	(RAD9 => RD3) = (0:0:0, 0:0:0);
	(RAD10 => RD3) = (0:0:0, 0:0:0);

	(RAD0 => RD4) = (0:0:0, 0:0:0);
	(RAD1 => RD4) = (0:0:0, 0:0:0);
	(RAD2 => RD4) = (0:0:0, 0:0:0);
	(RAD3 => RD4) = (0:0:0, 0:0:0);
	(RAD4 => RD4) = (0:0:0, 0:0:0);
	(RAD5 => RD4) = (0:0:0, 0:0:0);
	(RAD6 => RD4) = (0:0:0, 0:0:0);
	(RAD7 => RD4) = (0:0:0, 0:0:0);
	(RAD8 => RD4) = (0:0:0, 0:0:0);
	(RAD9 => RD4) = (0:0:0, 0:0:0);
	(RAD10 => RD4) = (0:0:0, 0:0:0);

	(RAD0 => RD5) = (0:0:0, 0:0:0);
	(RAD1 => RD5) = (0:0:0, 0:0:0);
	(RAD2 => RD5) = (0:0:0, 0:0:0);
	(RAD3 => RD5) = (0:0:0, 0:0:0);
	(RAD4 => RD5) = (0:0:0, 0:0:0);
	(RAD5 => RD5) = (0:0:0, 0:0:0);
	(RAD6 => RD5) = (0:0:0, 0:0:0);
	(RAD7 => RD5) = (0:0:0, 0:0:0);
	(RAD8 => RD5) = (0:0:0, 0:0:0);
	(RAD9 => RD5) = (0:0:0, 0:0:0);
	(RAD10 => RD5) = (0:0:0, 0:0:0);

	(RAD0 => RD6) = (0:0:0, 0:0:0);
	(RAD1 => RD6) = (0:0:0, 0:0:0);
	(RAD2 => RD6) = (0:0:0, 0:0:0);
	(RAD3 => RD6) = (0:0:0, 0:0:0);
	(RAD4 => RD6) = (0:0:0, 0:0:0);
	(RAD5 => RD6) = (0:0:0, 0:0:0);
	(RAD6 => RD6) = (0:0:0, 0:0:0);
	(RAD7 => RD6) = (0:0:0, 0:0:0);
	(RAD8 => RD6) = (0:0:0, 0:0:0);
	(RAD9 => RD6) = (0:0:0, 0:0:0);
	(RAD10 => RD6) = (0:0:0, 0:0:0);

	(RAD0 => RD7) = (0:0:0, 0:0:0);
	(RAD1 => RD7) = (0:0:0, 0:0:0);
	(RAD2 => RD7) = (0:0:0, 0:0:0);
	(RAD3 => RD7) = (0:0:0, 0:0:0);
	(RAD4 => RD7) = (0:0:0, 0:0:0);
	(RAD5 => RD7) = (0:0:0, 0:0:0);
	(RAD6 => RD7) = (0:0:0, 0:0:0);
	(RAD7 => RD7) = (0:0:0, 0:0:0);
	(RAD8 => RD7) = (0:0:0, 0:0:0);
	(RAD9 => RD7) = (0:0:0, 0:0:0);
	(RAD10 => RD7) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB16KA_WX2_RX1 (
    WCEN,WCLK,WCS0,WCS1,WE,RST,
    WD0,WD1,
    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12,
    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,RAD13,
    RD0);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE,RST;
input  WD0,WD1;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,WAD9,WAD10,WAD11,WAD12;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,RAD13;
output RD0;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [12:0] wad;
wire [13:0] rad;
wire [1:0] wcs;
wire [1:0] wd;
wire [0:0] rd;
reg notifier;

assign wad = {WAD12,WAD11,WAD10,WAD9,WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD13,RAD12,RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};

assign wcs = {WCS1,WCS0};
assign wd = {WD1,WD0};
//assign {RD0} = rd;
buf INSXQ (RD0,rd);

defparam RAM_U0.WDATA_WIDTH=2;
defparam RAM_U0.WADDR_WIDTH=13;
defparam RAM_U0.RDATA_WIDTH=1;
defparam RAM_U0.RADDR_WIDTH=14;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);
	$setuphold  (posedge WCLK, WAD9, 1, 0);
	$setuphold  (posedge WCLK, WAD10, 1, 0);
	$setuphold  (posedge WCLK, WAD11, 1, 0);
	$setuphold  (posedge WCLK, WAD12, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1);

	(RST => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);
	(RAD9 => RD0) = (0:0:0, 0:0:0);
	(RAD10 => RD0) = (0:0:0, 0:0:0);
	(RAD11 => RD0) = (0:0:0, 0:0:0);
	(RAD12 => RD0) = (0:0:0, 0:0:0);
	(RAD13 => RD0) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB16KA_WX32_RX1 (
    WCEN,WCLK,WCS0,WCS1,WE,RST,
    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23,WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31,
    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,
    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,RAD13,
    RD0);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23,WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,RAD13;
output RD0;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [8:0] wad;
wire [13:0] rad;
wire [1:0] wcs;
wire [31:0] wd;
wire [0:0] rd;
reg notifier;

assign wad = {WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD13,RAD12,RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};

assign wcs = {WCS1,WCS0};
assign wd = {WD31,WD30,WD29,WD28,WD27,WD26,WD25,WD24,WD23,WD22,WD21,WD20,WD19,WD18,WD17,WD16,WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD0} = rd;
buf INSXQ (RD0,rd);
defparam RAM_U0.WDATA_WIDTH=32;
defparam RAM_U0.WADDR_WIDTH=9;
defparam RAM_U0.RDATA_WIDTH=1;
defparam RAM_U0.RADDR_WIDTH=14;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);
	$setuphold  (posedge WCLK, WD8, 1, 0);
	$setuphold  (posedge WCLK, WD9, 1, 0);
	$setuphold  (posedge WCLK, WD10, 1, 0);
	$setuphold  (posedge WCLK, WD11, 1, 0);
	$setuphold  (posedge WCLK, WD12, 1, 0);
	$setuphold  (posedge WCLK, WD13, 1, 0);
	$setuphold  (posedge WCLK, WD14, 1, 0);
	$setuphold  (posedge WCLK, WD15, 1, 0);
	$setuphold  (posedge WCLK, WD16, 1, 0);
	$setuphold  (posedge WCLK, WD17, 1, 0);
	$setuphold  (posedge WCLK, WD18, 1, 0);
	$setuphold  (posedge WCLK, WD19, 1, 0);
	$setuphold  (posedge WCLK, WD20, 1, 0);
	$setuphold  (posedge WCLK, WD21, 1, 0);
	$setuphold  (posedge WCLK, WD22, 1, 0);
	$setuphold  (posedge WCLK, WD23, 1, 0);
	$setuphold  (posedge WCLK, WD24, 1, 0);
	$setuphold  (posedge WCLK, WD25, 1, 0);
	$setuphold  (posedge WCLK, WD26, 1, 0);
	$setuphold  (posedge WCLK, WD27, 1, 0);
	$setuphold  (posedge WCLK, WD28, 1, 0);
	$setuphold  (posedge WCLK, WD29, 1, 0);
	$setuphold  (posedge WCLK, WD30, 1, 0);
	$setuphold  (posedge WCLK, WD31, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1);

	(RST => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);
	(RAD9 => RD0) = (0:0:0, 0:0:0);
	(RAD10 => RD0) = (0:0:0, 0:0:0);
	(RAD11 => RD0) = (0:0:0, 0:0:0);
	(RAD12 => RD0) = (0:0:0, 0:0:0);
	(RAD13 => RD0) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB16KA_WX32_RX16 (
    WCEN,WCLK,WCS0,WCS1,WE,RST,
    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23,WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31,
    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,
    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,
    RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23,WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9;
output RD0,RD1,RD2,RD3,RD4,RD5,RD6,RD7,RD8,RD9,RD10,RD11,RD12,RD13,RD14,RD15;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [8:0] wad;
wire [9:0] rad;
wire [1:0] wcs;
wire [31:0] wd;
wire [15:0] rd;
reg notifier;

assign wad = {WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};

assign wcs = {WCS1,WCS0};
assign wd = {WD31,WD30,WD29,WD28,WD27,WD26,WD25,WD24,WD23,WD22,WD21,WD20,WD19,WD18,WD17,WD16,WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD15,RD14,RD13,RD12,RD11,RD10,RD9,RD8,RD7,RD6,RD5,RD4,RD3,RD2,RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
buf INSXQ2 (RD2,rd[2]);
buf INSXQ3 (RD3,rd[3]);
buf INSXQ4 (RD4,rd[4]);
buf INSXQ5 (RD5,rd[5]);
buf INSXQ6 (RD6,rd[6]);
buf INSXQ7 (RD7,rd[7]);
buf INSXQ8 (RD8,rd[8]);
buf INSXQ9 (RD9,rd[9]);

buf INSXQ10 (RD10,rd[10]);
buf INSXQ11 (RD11,rd[11]);
buf INSXQ12 (RD12,rd[12]);
buf INSXQ13 (RD13,rd[13]);
buf INSXQ14 (RD14,rd[14]);
buf INSXQ15 (RD15,rd[15]);
defparam RAM_U0.WDATA_WIDTH=32;
defparam RAM_U0.WADDR_WIDTH=9;
defparam RAM_U0.RDATA_WIDTH=16;
defparam RAM_U0.RADDR_WIDTH=10;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);
	$setuphold  (posedge WCLK, WD8, 1, 0);
	$setuphold  (posedge WCLK, WD9, 1, 0);
	$setuphold  (posedge WCLK, WD10, 1, 0);
	$setuphold  (posedge WCLK, WD11, 1, 0);
	$setuphold  (posedge WCLK, WD12, 1, 0);
	$setuphold  (posedge WCLK, WD13, 1, 0);
	$setuphold  (posedge WCLK, WD14, 1, 0);
	$setuphold  (posedge WCLK, WD15, 1, 0);
	$setuphold  (posedge WCLK, WD16, 1, 0);
	$setuphold  (posedge WCLK, WD17, 1, 0);
	$setuphold  (posedge WCLK, WD18, 1, 0);
	$setuphold  (posedge WCLK, WD19, 1, 0);
	$setuphold  (posedge WCLK, WD20, 1, 0);
	$setuphold  (posedge WCLK, WD21, 1, 0);
	$setuphold  (posedge WCLK, WD22, 1, 0);
	$setuphold  (posedge WCLK, WD23, 1, 0);
	$setuphold  (posedge WCLK, WD24, 1, 0);
	$setuphold  (posedge WCLK, WD25, 1, 0);
	$setuphold  (posedge WCLK, WD26, 1, 0);
	$setuphold  (posedge WCLK, WD27, 1, 0);
	$setuphold  (posedge WCLK, WD28, 1, 0);
	$setuphold  (posedge WCLK, WD29, 1, 0);
	$setuphold  (posedge WCLK, WD30, 1, 0);
	$setuphold  (posedge WCLK, WD31, 1, 0);

	$setuphold  (posedge WCLK, WCEN, 1, 0);
	$setuphold  (posedge WCLK, WE, 1, 0);
	$setuphold  (posedge WCLK, WCS0, 1, 0);
	$setuphold  (posedge WCLK, WCS1, 1, 0);

	$setuphold  (posedge WCLK, WAD0, 1, 0);
	$setuphold  (posedge WCLK, WAD1, 1, 0);
	$setuphold  (posedge WCLK, WAD2, 1, 0);
	$setuphold  (posedge WCLK, WAD3, 1, 0);
	$setuphold  (posedge WCLK, WAD4, 1, 0);
	$setuphold  (posedge WCLK, WAD5, 1, 0);
	$setuphold  (posedge WCLK, WAD6, 1, 0);
	$setuphold  (posedge WCLK, WAD7, 1, 0);
	$setuphold  (posedge WCLK, WAD8, 1, 0);

        $recovery(posedge RST, posedge WCLK, 1);

	(RST => RD0) = (0:0:0, 0:0:0);
	(RST => RD1) = (0:0:0, 0:0:0);
	(RST => RD2) = (0:0:0, 0:0:0);
	(RST => RD3) = (0:0:0, 0:0:0);
	(RST => RD4) = (0:0:0, 0:0:0);
	(RST => RD5) = (0:0:0, 0:0:0);
	(RST => RD6) = (0:0:0, 0:0:0);
	(RST => RD7) = (0:0:0, 0:0:0);
	(RST => RD8) = (0:0:0, 0:0:0);
	(RST => RD9) = (0:0:0, 0:0:0);
	(RST => RD10) = (0:0:0, 0:0:0);
	(RST => RD11) = (0:0:0, 0:0:0);
	(RST => RD12) = (0:0:0, 0:0:0);
	(RST => RD13) = (0:0:0, 0:0:0);
	(RST => RD14) = (0:0:0, 0:0:0);
	(RST => RD15) = (0:0:0, 0:0:0);

	(RAD0 => RD0) = (0:0:0, 0:0:0);
	(RAD1 => RD0) = (0:0:0, 0:0:0);
	(RAD2 => RD0) = (0:0:0, 0:0:0);
	(RAD3 => RD0) = (0:0:0, 0:0:0);
	(RAD4 => RD0) = (0:0:0, 0:0:0);
	(RAD5 => RD0) = (0:0:0, 0:0:0);
	(RAD6 => RD0) = (0:0:0, 0:0:0);
	(RAD7 => RD0) = (0:0:0, 0:0:0);
	(RAD8 => RD0) = (0:0:0, 0:0:0);
	(RAD9 => RD0) = (0:0:0, 0:0:0);

	(RAD0 => RD1) = (0:0:0, 0:0:0);
	(RAD1 => RD1) = (0:0:0, 0:0:0);
	(RAD2 => RD1) = (0:0:0, 0:0:0);
	(RAD3 => RD1) = (0:0:0, 0:0:0);
	(RAD4 => RD1) = (0:0:0, 0:0:0);
	(RAD5 => RD1) = (0:0:0, 0:0:0);
	(RAD6 => RD1) = (0:0:0, 0:0:0);
	(RAD7 => RD1) = (0:0:0, 0:0:0);
	(RAD8 => RD1) = (0:0:0, 0:0:0);
	(RAD9 => RD1) = (0:0:0, 0:0:0);

	(RAD0 => RD2) = (0:0:0, 0:0:0);
	(RAD1 => RD2) = (0:0:0, 0:0:0);
	(RAD2 => RD2) = (0:0:0, 0:0:0);
	(RAD3 => RD2) = (0:0:0, 0:0:0);
	(RAD4 => RD2) = (0:0:0, 0:0:0);
	(RAD5 => RD2) = (0:0:0, 0:0:0);
	(RAD6 => RD2) = (0:0:0, 0:0:0);
	(RAD7 => RD2) = (0:0:0, 0:0:0);
	(RAD8 => RD2) = (0:0:0, 0:0:0);
	(RAD9 => RD2) = (0:0:0, 0:0:0);

	(RAD0 => RD3) = (0:0:0, 0:0:0);
	(RAD1 => RD3) = (0:0:0, 0:0:0);
	(RAD2 => RD3) = (0:0:0, 0:0:0);
	(RAD3 => RD3) = (0:0:0, 0:0:0);
	(RAD4 => RD3) = (0:0:0, 0:0:0);
	(RAD5 => RD3) = (0:0:0, 0:0:0);
	(RAD6 => RD3) = (0:0:0, 0:0:0);
	(RAD7 => RD3) = (0:0:0, 0:0:0);
	(RAD8 => RD3) = (0:0:0, 0:0:0);
	(RAD9 => RD3) = (0:0:0, 0:0:0);

	(RAD0 => RD4) = (0:0:0, 0:0:0);
	(RAD1 => RD4) = (0:0:0, 0:0:0);
	(RAD2 => RD4) = (0:0:0, 0:0:0);
	(RAD3 => RD4) = (0:0:0, 0:0:0);
	(RAD4 => RD4) = (0:0:0, 0:0:0);
	(RAD5 => RD4) = (0:0:0, 0:0:0);
	(RAD6 => RD4) = (0:0:0, 0:0:0);
	(RAD7 => RD4) = (0:0:0, 0:0:0);
	(RAD8 => RD4) = (0:0:0, 0:0:0);
	(RAD9 => RD4) = (0:0:0, 0:0:0);

	(RAD0 => RD5) = (0:0:0, 0:0:0);
	(RAD1 => RD5) = (0:0:0, 0:0:0);
	(RAD2 => RD5) = (0:0:0, 0:0:0);
	(RAD3 => RD5) = (0:0:0, 0:0:0);
	(RAD4 => RD5) = (0:0:0, 0:0:0);
	(RAD5 => RD5) = (0:0:0, 0:0:0);
	(RAD6 => RD5) = (0:0:0, 0:0:0);
	(RAD7 => RD5) = (0:0:0, 0:0:0);
	(RAD8 => RD5) = (0:0:0, 0:0:0);
	(RAD9 => RD5) = (0:0:0, 0:0:0);

	(RAD0 => RD6) = (0:0:0, 0:0:0);
	(RAD1 => RD6) = (0:0:0, 0:0:0);
	(RAD2 => RD6) = (0:0:0, 0:0:0);
	(RAD3 => RD6) = (0:0:0, 0:0:0);
	(RAD4 => RD6) = (0:0:0, 0:0:0);
	(RAD5 => RD6) = (0:0:0, 0:0:0);
	(RAD6 => RD6) = (0:0:0, 0:0:0);
	(RAD7 => RD6) = (0:0:0, 0:0:0);
	(RAD8 => RD6) = (0:0:0, 0:0:0);
	(RAD9 => RD6) = (0:0:0, 0:0:0);

	(RAD0 => RD7) = (0:0:0, 0:0:0);
	(RAD1 => RD7) = (0:0:0, 0:0:0);
	(RAD2 => RD7) = (0:0:0, 0:0:0);
	(RAD3 => RD7) = (0:0:0, 0:0:0);
	(RAD4 => RD7) = (0:0:0, 0:0:0);
	(RAD5 => RD7) = (0:0:0, 0:0:0);
	(RAD6 => RD7) = (0:0:0, 0:0:0);
	(RAD7 => RD7) = (0:0:0, 0:0:0);
	(RAD8 => RD7) = (0:0:0, 0:0:0);
	(RAD9 => RD7) = (0:0:0, 0:0:0);

	(RAD0 => RD8) = (0:0:0, 0:0:0);
	(RAD1 => RD8) = (0:0:0, 0:0:0);
	(RAD2 => RD8) = (0:0:0, 0:0:0);
	(RAD3 => RD8) = (0:0:0, 0:0:0);
	(RAD4 => RD8) = (0:0:0, 0:0:0);
	(RAD5 => RD8) = (0:0:0, 0:0:0);
	(RAD6 => RD8) = (0:0:0, 0:0:0);
	(RAD7 => RD8) = (0:0:0, 0:0:0);
	(RAD8 => RD8) = (0:0:0, 0:0:0);
	(RAD9 => RD8) = (0:0:0, 0:0:0);

	(RAD0 => RD9) = (0:0:0, 0:0:0);
	(RAD1 => RD9) = (0:0:0, 0:0:0);
	(RAD2 => RD9) = (0:0:0, 0:0:0);
	(RAD3 => RD9) = (0:0:0, 0:0:0);
	(RAD4 => RD9) = (0:0:0, 0:0:0);
	(RAD5 => RD9) = (0:0:0, 0:0:0);
	(RAD6 => RD9) = (0:0:0, 0:0:0);
	(RAD7 => RD9) = (0:0:0, 0:0:0);
	(RAD8 => RD9) = (0:0:0, 0:0:0);
	(RAD9 => RD9) = (0:0:0, 0:0:0);

	(RAD0 => RD10) = (0:0:0, 0:0:0);
	(RAD1 => RD10) = (0:0:0, 0:0:0);
	(RAD2 => RD10) = (0:0:0, 0:0:0);
	(RAD3 => RD10) = (0:0:0, 0:0:0);
	(RAD4 => RD10) = (0:0:0, 0:0:0);
	(RAD5 => RD10) = (0:0:0, 0:0:0);
	(RAD6 => RD10) = (0:0:0, 0:0:0);
	(RAD7 => RD10) = (0:0:0, 0:0:0);
	(RAD8 => RD10) = (0:0:0, 0:0:0);
	(RAD9 => RD10) = (0:0:0, 0:0:0);

	(RAD0 => RD11) = (0:0:0, 0:0:0);
	(RAD1 => RD11) = (0:0:0, 0:0:0);
	(RAD2 => RD11) = (0:0:0, 0:0:0);
	(RAD3 => RD11) = (0:0:0, 0:0:0);
	(RAD4 => RD11) = (0:0:0, 0:0:0);
	(RAD5 => RD11) = (0:0:0, 0:0:0);
	(RAD6 => RD11) = (0:0:0, 0:0:0);
	(RAD7 => RD11) = (0:0:0, 0:0:0);
	(RAD8 => RD11) = (0:0:0, 0:0:0);
	(RAD9 => RD11) = (0:0:0, 0:0:0);

	(RAD0 => RD12) = (0:0:0, 0:0:0);
	(RAD1 => RD12) = (0:0:0, 0:0:0);
	(RAD2 => RD12) = (0:0:0, 0:0:0);
	(RAD3 => RD12) = (0:0:0, 0:0:0);
	(RAD4 => RD12) = (0:0:0, 0:0:0);
	(RAD5 => RD12) = (0:0:0, 0:0:0);
	(RAD6 => RD12) = (0:0:0, 0:0:0);
	(RAD7 => RD12) = (0:0:0, 0:0:0);
	(RAD8 => RD12) = (0:0:0, 0:0:0);
	(RAD9 => RD12) = (0:0:0, 0:0:0);

	(RAD0 => RD13) = (0:0:0, 0:0:0);
	(RAD1 => RD13) = (0:0:0, 0:0:0);
	(RAD2 => RD13) = (0:0:0, 0:0:0);
	(RAD3 => RD13) = (0:0:0, 0:0:0);
	(RAD4 => RD13) = (0:0:0, 0:0:0);
	(RAD5 => RD13) = (0:0:0, 0:0:0);
	(RAD6 => RD13) = (0:0:0, 0:0:0);
	(RAD7 => RD13) = (0:0:0, 0:0:0);
	(RAD8 => RD13) = (0:0:0, 0:0:0);
	(RAD9 => RD13) = (0:0:0, 0:0:0);

	(RAD0 => RD14) = (0:0:0, 0:0:0);
	(RAD1 => RD14) = (0:0:0, 0:0:0);
	(RAD2 => RD14) = (0:0:0, 0:0:0);
	(RAD3 => RD14) = (0:0:0, 0:0:0);
	(RAD4 => RD14) = (0:0:0, 0:0:0);
	(RAD5 => RD14) = (0:0:0, 0:0:0);
	(RAD6 => RD14) = (0:0:0, 0:0:0);
	(RAD7 => RD14) = (0:0:0, 0:0:0);
	(RAD8 => RD14) = (0:0:0, 0:0:0);
	(RAD9 => RD14) = (0:0:0, 0:0:0);

	(RAD0 => RD15) = (0:0:0, 0:0:0);
	(RAD1 => RD15) = (0:0:0, 0:0:0);
	(RAD2 => RD15) = (0:0:0, 0:0:0);
	(RAD3 => RD15) = (0:0:0, 0:0:0);
	(RAD4 => RD15) = (0:0:0, 0:0:0);
	(RAD5 => RD15) = (0:0:0, 0:0:0);
	(RAD6 => RD15) = (0:0:0, 0:0:0);
	(RAD7 => RD15) = (0:0:0, 0:0:0);
	(RAD8 => RD15) = (0:0:0, 0:0:0);
	(RAD9 => RD15) = (0:0:0, 0:0:0);

endspecify
endmodule
`endcelldefine

`celldefine
module RAMB16KA_WX32_RX2 (
    WCEN,WCLK,WCS0,WCS1,WE,RST,
    WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23,WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31,
    WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8,
    RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12,
    RD0,RD1);

parameter RAM_INIT_FILE = "";

input  WCEN,WCLK,WCS0,WCS1,WE,RST;
input  WD0,WD1,WD2,WD3,WD4,WD5,WD6,WD7,WD8,WD9,WD10,WD11,WD12,WD13,WD14,WD15,WD16,WD17,WD18,WD19,WD20,WD21,WD22,WD23,WD24,WD25,WD26,WD27,WD28,WD29,WD30,WD31;
input  WAD0,WAD1,WAD2,WAD3,WAD4,WAD5,WAD6,WAD7,WAD8;
input  RAD0,RAD1,RAD2,RAD3,RAD4,RAD5,RAD6,RAD7,RAD8,RAD9,RAD10,RAD11,RAD12;
output RD0,RD1;

parameter RAM_INIT_FLAG = (RAM_INIT_FILE == "") ? 0 : 1 ;

wire [8:0] wad;
wire [12:0] rad;
wire [1:0] wcs;
wire [31:0] wd;
wire [1:0] rd;
reg notifier;

assign wad = {WAD8,WAD7,WAD6,WAD5,WAD4,WAD3,WAD2,WAD1,WAD0};
assign rad = {RAD12,RAD11,RAD10,RAD9,RAD8,RAD7,RAD6,RAD5,RAD4,RAD3,RAD2,RAD1,RAD0};

assign wcs = {WCS1,WCS0};
assign wd = {WD31,WD30,WD29,WD28,WD27,WD26,WD25,WD24,WD23,WD22,WD21,WD20,WD19,WD18,WD17,WD16,WD15,WD14,WD13,WD12,WD11,WD10,WD9,WD8,WD7,WD6,WD5,WD4,WD3,WD2,WD1,WD0};
//assign {RD1,RD0} = rd;
buf INSXQ0 (RD0,rd[0]);
buf INSXQ1 (RD1,rd[1]);
defparam RAM_U0.WDATA_WIDTH=32;
defparam RAM_U0.WADDR_WIDTH=9;
defparam RAM_U0.RDATA_WIDTH=2;
defparam RAM_U0.RADDR_WIDTH=13;
defparam RAM_U0.MEM_INIT_FILE = RAM_INIT_FILE;
defparam RAM_U0.MEM_INIT_FLAG = RAM_INIT_FLAG;

SC_PDPRAMA_16K RAM_U0 (.WCEN(WCEN),
                      .WCLK(WCLK),
                      .WE(WE),
                      .WCS(wcs),
                      .RST(RST),
                      .WD(wd),
                      .WAD(wad),
                      .RAD(rad),
                      .RD(rd));

specify
	$width (posedge WCLK, 1, 0, notifier);

	$width (posedge RST, 1, 0, notifier);

	$setuphold  (posedge WCLK, WD0, 1, 0);
	$setuphold  (posedge WCLK, WD1, 1, 0);
	$setuphold  (posedge WCLK, WD2, 1, 0);
	$setuphold  (posedge WCLK, WD3, 1, 0);
	$setuphold  (posedge WCLK, WD4, 1, 0);
	$setuphold  (posedge WCLK, WD5, 1, 0);
	$setuphold  (posedge WCLK, WD6, 1, 0);
	$setuphold  (posedge WCLK, WD7, 1, 0);
	$setuphold  (posedge WCLK, WD8, 1, 0);
	$setuphold  (posedge WCLK, WD9, 1, 0);
	$setuphold  (posedge WCLK, WD10, 1, 0);
	$setuphold  (posedge WCLK, WD11, 1, 0);
	$setuphold  (posedge WCLK, WD12, 1, 0);
	$setuphold  (posedge WCLK, WD13, 1, 0);
	$setuphold  (posedge WCLK, WD14, 1, 0);
	$setuphold  (posedge WCLK, WD15, 1, 0);
	$setuphold  (posedge WCLK, WD16, 1, 0);
	$setuphold  (posedge WCLK, WD17, 1, 0);
	$setuphold  (posedge WCLK, WD18, 1, 0);
	$setuphold  (posedge WCLK, WD19, 1, 0);
	$setuphold  (posedge WCLK, WD20, 1, 0);
	$setuphold  (posedge WCLK, WD21, 1, 0);
	$setuphold  (posedge WCLK, WD22, 1, 0);
	$setuphold  (posedge WCLK, WD23, 1, 0);
	$setuphold  (posedge WCLK, WD24, 1, 0);
	$setuphold  (posedge WCLK, WD25, 1, 0);
	$setuphold  (posedge WCLK, WD26, 1,